﻿namespace csMSX2
{
    public static class Z80A 
    {
        public static ushort Z80A_REG_PC; //0~65535
        public static ushort Z80A_REG_SP;

        public static ushort Z80A_REG_IX;
        public static ushort Z80A_REG_IY;

        public static byte Z80A_REG_A; //0~255
        public static byte Z80A_REG_F;
        public static byte Z80A_REG_B;
        public static byte Z80A_REG_C;
        public static byte Z80A_REG_D;
        public static byte Z80A_REG_E;
        public static byte Z80A_REG_H;
        public static byte Z80A_REG_L;

        public static byte Z80A_REG_A2;
        public static byte Z80A_REG_F2;
        public static byte Z80A_REG_B2;
        public static byte Z80A_REG_C2;
        public static byte Z80A_REG_D2;
        public static byte Z80A_REG_E2;
        public static byte Z80A_REG_H2;
        public static byte Z80A_REG_L2;

        public static byte Z80A_REG_I;
        public static byte Z80A_REG_R;

        public static sbyte Z80A_REG_IFF1;
        public static sbyte Z80A_REG_IFF2;

        public const ushort C_Flag = 0x0100;
        public const ushort S_Flag16 = 0x8000;
        public const ushort S_Flag = 0x0080;
        public const ushort H_Flag16 = 0x1000;
        public const ushort H_Flag = 0x0010;

        public static void MSX_INIT_Z80A()
        {
            Z80A_REG_PC = 0;
            Z80A_REG_SP = 0;
            Z80A_REG_IX = 0;
            Z80A_REG_IY = 0;

            Z80A_REG_A = 0;
            Z80A_REG_F = 0;
            Z80A_REG_B = 0;
            Z80A_REG_C = 0;
            Z80A_REG_D = 0;
            Z80A_REG_E = 0;
            Z80A_REG_H = 0;
            Z80A_REG_L = 0;
            
            Z80A_REG_A2 = 0;
            Z80A_REG_F2 = 0;
            Z80A_REG_B2 = 0;
            Z80A_REG_C2 = 0;
            Z80A_REG_D2 = 0;
            Z80A_REG_E2 = 0;
            Z80A_REG_H2 = 0;
            Z80A_REG_L2 = 0;

            Z80A_REG_I = 0;
            Z80A_REG_R = 0;
            Z80A_REG_IFF1 = 0;
            Z80A_REG_IFF2 = 0;
        }

        public static void EXEC_Z80A_ADD_PC(int iSz, int iSz0)
        {
            Z80A_REG_PC = (ushort)((Z80A_REG_PC + iSz) & 0xFFFF);
            if (iSz == 0) iSz = iSz0;
            MSX.Gi_Z80A_ClockSize = MSX.Gi_Z80A_CLOCK + iSz;
        }

        public static ushort GET_Z80A_REG_AF()
        {
            return (ushort)((Z80A_REG_A << 8) | Z80A_REG_F);
        }

        public static ushort GET_Z80A_REG_BC()
        {
            return (ushort)((Z80A_REG_B << 8) | Z80A_REG_C);
        }

        public static ushort GET_Z80A_REG_DE()
        {
            return (ushort)((Z80A_REG_D << 8) | Z80A_REG_E);
        }

        public static ushort GET_Z80A_REG_HL()
        {
            return (ushort)((Z80A_REG_H << 8) | Z80A_REG_L);
        }

        public static ushort GET_Z80A_REG_AF2()
        {
            return (ushort)((Z80A_REG_A2 << 8) | Z80A_REG_F2);
        }

        public static ushort GET_Z80A_REG_BC2()
        {
            return (ushort)((Z80A_REG_B2 << 8) | Z80A_REG_C2);
        }

        public static ushort GET_Z80A_REG_DE2()
        {
            return (ushort)((Z80A_REG_D2 << 8) | Z80A_REG_E2);
        }

        public static ushort GET_Z80A_REG_HL2()
        {
            return (ushort)((Z80A_REG_H2 << 8) | Z80A_REG_L2);
        }

        public static void PUT_Z80A_REG_AF(ushort oVal)
        {
            Z80A_REG_A = (byte)(oVal >> 8);
            Z80A_REG_F = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_BC(ushort oVal)
        {
            Z80A_REG_B = (byte)(oVal >> 8);
            Z80A_REG_C = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_DE(ushort oVal)
        {
            Z80A_REG_D = (byte)(oVal >> 8);
            Z80A_REG_E = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_HL(ushort oVal)
        {
            Z80A_REG_H = (byte)(oVal >> 8);
            Z80A_REG_L = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_AF2(ushort oVal)
        {
            Z80A_REG_A2 = (byte)(oVal >> 8);
            Z80A_REG_F2 = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_BC2(ushort oVal)
        {
            Z80A_REG_B2 = (byte)(oVal >> 8);
            Z80A_REG_C2 = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_DE2(ushort oVal)
        {
            Z80A_REG_D2 = (byte)(oVal >> 8);
            Z80A_REG_E2 = (byte)(oVal & 0x00FF);
        }

        public static void PUT_Z80A_REG_HL2(ushort oVal)
        {
            Z80A_REG_H2 = (byte)(oVal >> 8);
            Z80A_REG_L2 = (byte)(oVal & 0x00FF);
        }

        public static byte GET_Z80A_REG_IXH()
        {
            return (byte)(Z80A_REG_IX >> 8);
        }

        public static byte GET_Z80A_REG_IXL()
        {
            return (byte)(Z80A_REG_IX & 0x00FF);
        }

        public static byte GET_Z80A_REG_IYH()
        {
            return (byte)(Z80A_REG_IY >> 8);
        }

        public static byte GET_Z80A_REG_IYL()
        {
            return (byte)(Z80A_REG_IY & 0x00FF);
        }

        public static void PUT_Z80A_REG_IXH(byte iVal)
        {
            Z80A_REG_IX = (byte)((Z80A_REG_IX & 0x00FF) | (iVal << 8));
        }

        public static void PUT_Z80A_REG_IXL(byte iVal)
        {
            Z80A_REG_IX = (byte)((Z80A_REG_IX & 0xFF00) | (iVal));
        }

        public static void PUT_Z80A_REG_IYH(byte iVal)
        {
            Z80A_REG_IY = (byte)((Z80A_REG_IY & 0x00FF) | (iVal << 8));
        }

        public static void PUT_Z80A_REG_IYL(byte iVal)
        {
            Z80A_REG_IY = (byte)((Z80A_REG_IY & 0xFF00) | (iVal));
        }

        public static sbyte GET_Z80A_FLAG_S()
        {
            return (sbyte)((Z80A_REG_F & 128) == 0 ? 0 : 1); //1000 0000
        }
        
        public static sbyte GET_Z80A_FLAG_Z()
        {
            return (sbyte)((Z80A_REG_F & 64) == 0 ? 0 : 1); //0100 0000
        }
        
        public static sbyte GET_Z80A_FLAG_Y()
        {
            return (sbyte)((Z80A_REG_F & 32) == 0 ? 0 : 1); //0010 0000
        }
        
        public static sbyte GET_Z80A_FLAG_H()
        {
            return (sbyte)((Z80A_REG_F & 16) == 0 ? 0 : 1); //0001 0000
        }
        
        public static sbyte GET_Z80A_FLAG_X()
        {
            return (sbyte)((Z80A_REG_F & 8) == 0 ? 0 : 1); //0000 1000
        }
        
        public static sbyte GET_Z80A_FLAG_PV()
        {
            return (sbyte)((Z80A_REG_F & 4) == 0 ? 0 : 1); //0000 0100
        }
        
        public static sbyte GET_Z80A_FLAG_N()
        {
            return (sbyte)((Z80A_REG_F & 2) == 0 ? 0 : 1); //0000 0010
        }
        
        public static sbyte GET_Z80A_FLAG_C()
        {
            return (sbyte)((Z80A_REG_F & 1) == 0 ? 0 : 1); //0000 0001
        }
        
        public static void PUT_Z80A_FLAG_S(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0x7F); //0111 1111
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 128); //1000 0000
            };
        }
        
        public static void PUT_Z80A_FLAG_Z(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xBF); //1011 1111
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 64); //0100 0000
            };
        }
        
        public static void PUT_Z80A_FLAG_Y(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xDF); //1101 1111
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 32); //0010 0000
            };
        }
        
        public static void PUT_Z80A_FLAG_H(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xEF); //1110 1111
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 16); //0001 0000
            };
        }
        
        public static void PUT_Z80A_FLAG_X(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xF7); //1111 0111
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 8); //0000 1000
            };
        }
        
        public static void PUT_Z80A_FLAG_PV(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xFB); //1111 1011
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 4); //0000 0100
            };
        }
        
        public static void PUT_Z80A_FLAG_N(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xFD); //1111 1101
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 2); //0000 0010
            };
        }

        public static void PUT_Z80A_FLAG_C(sbyte iVal)
        {
            if (iVal == 0)
            {
                Z80A_REG_F = (byte)(Z80A_REG_F & 0xFE); //1111 1110
            }
            else
            {
                Z80A_REG_F = (byte)(Z80A_REG_F | 1); //0000 0001
            };
        }

        public static sbyte giGetIdx8(byte iVal)
        {
            if (iVal > 127)
            {  
                return (sbyte)(iVal - 256);
            }
            else
            {
                return (sbyte)(iVal);
            };
        }

        public static sbyte giGet16Sign(ushort oVal)
        {
          //Sign 16 Bit (1:음수,0:양수)
            if (oVal > 32767)
            {
                return 1;
            }
            else
            {
                return 0;
            };
        }

        public static sbyte giGet8Sign(byte iVal)
        {
          //Sign 8 Bit (1:음수,0:양수)
            if (iVal > 127)
            {
                return 1;
            }
            else
            {
                return 0;
            };
        }

        public static sbyte giGet16Zero(ushort oVal)
        {
          //Zero 16 Bit (1:Zero1,0:Other)
            if (oVal == 0)
            { 
                return 1;
            }
            else
            {
                return 0;
            };
        }

        public static sbyte giGet8Zero(byte iVal)
        {
          //Zero 8 Bit (1:Zero1,0:Other)
            if (iVal == 0)
            {
                return 1;
            }
            else
            {
                return 0;
            };
        }
        
        public static ushort goGetLngToLng(int oVal)
        {
            int R;

            R = oVal;
            if (R < 0) R = R + 65536;
            if (R > 65535) R = R & 0xFFFF; //-65536;

            return (ushort)R;
        }
        
        public static byte giGetIntToInt(int iVal)
        {
            int R;

            R = iVal;
            if (R < 0) R = R + 256;
            if (R > 255) R = R & 0xFF; //-256;

            return (byte)R;
        }

        public static ushort goGetIntHLToLng(byte iValH, byte iValL)
        {
            return (ushort)((iValH << 8) | iValL);
        }

        public static void gtMoveLngToIntHL(ushort oVal, ref byte iValH, ref byte iValL)
        {  
            iValH = (byte)(oVal >> 8);
            iValL = (byte)(oVal & 0x00FF);
        }

        public static byte giGetLngToIntH(ushort Reg16)
        {
            return (byte)(Reg16 >> 8);
        }

        public static byte giGetLngToIntL(ushort Reg16)
        {
            return (byte)(Reg16 & 0x00FF);
        }

        public static void gt_INC_16TO16(ushort oVal, ref ushort Reg16)
        {
          //nn=nn+1
            Reg16 = goGetLngToLng(oVal + 1); //INC
        }

        public static void gt_DEC_16TO16(ushort oVal, ref ushort Reg16)
        {
          //nn=nn-1
            Reg16 = goGetLngToLng(oVal - 1); //DEC
        }

        public static void gt_INC_16TO8(ushort oVal, ref byte RegH, ref byte RegL)
        {
            ushort Reg16;
          //nn=nn+1
            Reg16 = goGetLngToLng(oVal + 1); //INC
            RegH = giGetLngToIntH(Reg16);
            RegL = giGetLngToIntL(Reg16);
        }

        public static void gt_DEC_16TO8(ushort oVal, ref byte RegH, ref byte RegL)
        {
            ushort Reg16;
          //nn=nn-1
            Reg16 = goGetLngToLng(oVal - 1); //DEC
            RegH = giGetLngToIntH(Reg16);
            RegL = giGetLngToIntL(Reg16);
        }

        public static void gt_INC_8TO8(byte iVal, ref byte Reg8)
        {
            short iResult;
          //i=i+1
          //S=Sign(i), Z=Zero(i), H=Hcry(i), Before P=7Fh, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            iResult = (short)(iVal + 1); //INC
            Reg8 = (byte)(iResult & 0xFF);
            PUT_Z80A_FLAG_H((sbyte)((iVal & 0x0F) == 15 ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(iVal == 0x7F ? 1 : 0)); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_DEC_8TO8(byte iVal, ref byte Reg8)
        {
            short iResult;
          //i=i-1
          //S=Sign(i), Z=Zero(i), H=Hbrw(i), Before P=80h, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            iResult = (short)(iVal - 1); //DEC
            Reg8 = giGetIntToInt(iResult);
            PUT_Z80A_FLAG_H((sbyte)((iVal & 0x0F) == 0 ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(iVal == 0x80 ? 1 : 0)); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_ADD_16TO16(ushort oVal1, ushort oVal2, ref ushort Reg16, sbyte iCv)
        {
            ft_ADD_16TO16(oVal1, oVal2, ref Reg16, iCv);
        }

        public static void gt_SUB_16TO16(ushort oVal1, ushort oVal2, ref ushort Reg16, sbyte iCv)
        {
            ft_SUB_16TO16(oVal1, oVal2, ref Reg16, iCv);
        }

        public static void gt_ADD_16TO8(ushort oVal1, ushort oVal2, ref byte RegH, ref byte RegL, sbyte iCv)
        {
            ushort Reg16 = 0;

            ft_ADD_16TO16(oVal1, oVal2, ref Reg16, iCv);
            RegH = giGetLngToIntH(Reg16);
            RegL = giGetLngToIntL(Reg16);
        }

        public static void gt_SUB_16TO8(ushort oVal1, ushort oVal2, ref byte RegH, ref byte RegL, sbyte iCv)
        {
            ushort Reg16 = 0;

            ft_SUB_16TO16(oVal1, oVal2, ref Reg16, iCv);
            RegH = giGetLngToIntH(Reg16);
            RegL = giGetLngToIntL(Reg16);
        }

        public static void ft_ADD_16TO16(ushort oVal1, ushort oVal2, ref ushort Reg16, sbyte iCv)
        {
            int oResult; sbyte iCarry;
          //nn=nn+rr
          //H=Hcry(nn), N=0, C=Carry(nn) : ADD
          //S=Sign(nn), Z=Zero(nn), P=Oflow(nn) : ADC
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            iCarry = (sbyte)(iCv == 1 ? GET_Z80A_FLAG_C() : 0); //ADC
            oResult = (int)(oVal1 + oVal2 + iCarry); //ADD
            Reg16 = (ushort)(oResult & 0xFFFF);
            PUT_Z80A_FLAG_C((sbyte)(Reg16 != oResult ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)(((oVal1 & 0x0FFF) + ((oVal2 + iCarry) & 0x0FFF)) > 0x0FFF ? 1 : 0)); //하프캐리
            if (iCv == 1)
            {
                PUT_Z80A_FLAG_PV((sbyte)(((oVal1 ^ oResult) & ((oVal2 + iCarry) ^ oResult) & S_Flag16) != 0 ? 1 : 0)); //오버플로
                PUT_Z80A_FLAG_S(giGet16Sign(Reg16));
                PUT_Z80A_FLAG_Z(giGet16Zero(Reg16));
            };
        }

        public static void ft_SUB_16TO16(ushort oVal1, ushort oVal2, ref ushort Reg16, sbyte iCv)
        {
            int oResult; sbyte iCarry;
          //nn=nn-rr
          //H=Hbrw(nn), N=1, C=Borrow(nn) : SUB
          //S=Sign(nn), Z=Zero(nn), P=Oflow(nn) : SBC
            PUT_Z80A_FLAG_N(1); //뺄셈
            iCarry = (sbyte)(iCv == 1 ? GET_Z80A_FLAG_C() : 0); //SBC
            oResult = (int)(oVal1 - oVal2 - iCarry); //SUB
            Reg16 = goGetLngToLng(oResult);
            PUT_Z80A_FLAG_C((sbyte)(Reg16 != oResult ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)((oVal1 & 0x0FFF) < ((oVal2 + iCarry) & 0x0FFF) ? 1 : 0)); //하프캐리
            if (iCv == 1) 
            {
                PUT_Z80A_FLAG_PV((sbyte)(((oVal1 ^ (oVal2 + iCarry)) & (oVal1 ^ oResult) & S_Flag16) != 0 ? 1 : 0)); //오버플로
                PUT_Z80A_FLAG_S(giGet16Sign(Reg16));
                PUT_Z80A_FLAG_Z(giGet16Zero(Reg16));
            };
        }

        public static void gt_ADD_8TO8(byte iVal1, byte iVal2, ref byte Reg8, sbyte iCv)
        {
            short iResult; sbyte iCarry;
          //i=i+r
          //S=Sign(i), Z=Zero(i), H=Hcry(i), P=Oflow(i), N=0, C=Carry(i)
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            iCarry = (sbyte)(iCv == 1 ? GET_Z80A_FLAG_C() : 0); //ADC
            iResult = (short)(iVal1 + iVal2 + iCarry); //ADD
            Reg8 = (byte)(iResult & 0xFF);
            PUT_Z80A_FLAG_C((sbyte)(Reg8 != iResult ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)(((iVal1 & 0x0F) + ((iVal2 + iCarry) & 0x0F)) > 0x0F ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(((iVal1 ^ iResult) & ((iVal2 + iCarry) ^ iResult) & S_Flag) != 0 ? 1 : 0)); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_SUB_8TO8(byte iVal1, byte iVal2, ref byte Reg8, sbyte iCv)
        {
            short iResult; sbyte iCarry;
          //i=i-r
          //S=Sign(i), Z=Zero(i), H=Hbrw(i), P=Oflow(i), N=0, C=Borrow(i)
            PUT_Z80A_FLAG_N(1); //뺄셈
            iCarry = (sbyte)(iCv == 1 ? GET_Z80A_FLAG_C() : 0); //SBC
            iResult = (short)(iVal1 - iVal2 - iCarry); //SUB
            Reg8 = giGetIntToInt(iResult);
            PUT_Z80A_FLAG_C((sbyte)(Reg8 != iResult ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)((iVal1 & 0x0F) < ((iVal2 + iCarry) & 0x0F) ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(((iVal1 ^ (iVal2 + iCarry)) & (iVal1 ^ iResult) & S_Flag) != 0 ? 1 : 0)); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_CP(byte iVal2)
        {
            short iResult; byte Reg8;
          //CP=i-r
          //S=Sign(CP), Z=Zero(CP), H=Hbrw(CP), P=Oflow(CP), N=1, C=Borrow(CP)
            PUT_Z80A_FLAG_N(1); //뺄셈
            iResult = (short)(Z80A_REG_A - iVal2); //SUB
            Reg8 = giGetIntToInt(iResult);
            PUT_Z80A_FLAG_C((sbyte)(Reg8 != iResult ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)((Z80A_REG_A & 0x0F) < (iVal2 & 0x0F) ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV(0); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_AND_8TO8(byte iVal1, byte iVal2, ref byte Reg8)
        {
          //i=i And r
          //S=Sign(i), Z=Zero(i), H=1, P=Peven(i), N=0, C=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            Reg8 = (byte)(iVal1 & iVal2); //AND
            PUT_Z80A_FLAG_C(0); //Not캐리
            PUT_Z80A_FLAG_H(1); //하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_XOR_8TO8(byte iVal1, byte iVal2, ref byte Reg8)
        {
          //i=i Xor r
          //S=Sign(i), Z=Zero(i), H=0, P=Peven(i), N=0, C=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            Reg8 = (byte)(iVal1 ^ iVal2); //XOR
            PUT_Z80A_FLAG_C(0); //Not캐리
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_OR_8TO8(byte iVal1, byte iVal2, ref byte Reg8)
        {
          //i=i Or r
          //S=Sign(i), Z=Zero(i), H=0, P=Peven(i), N=0, C=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            Reg8 = (byte)(iVal1 | iVal2); //OR
            PUT_Z80A_FLAG_C(0); //Not캐리
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_BIT(sbyte iBit, byte Reg8)
        {
          //Z=bit=0, H=1, N=0
            PUT_Z80A_FLAG_N(0); //뺄셈
            PUT_Z80A_FLAG_Z((sbyte)((Reg8 & TBL.Gi_B_Table[iBit]) == 0 ? 1 : 0)); //1:Zero
            PUT_Z80A_FLAG_H(1); //하프캐리
        }

        public static void gt_SET(sbyte iBit, ref byte Reg8)
        {
          //bit<=1
            Reg8 = (byte)(Reg8 | TBL.Gi_B_Table[iBit]); //1
        }

        public static void gt_RES(sbyte iBit, ref byte Reg8)
        {
          //bit<=0
            Reg8 = (byte)(Reg8 & TBL.Gi_NB_Table[iBit]); //0
        }

        public static void gt_SCF()
        {
          //C=1, H=0, N=0
            PUT_Z80A_FLAG_N(0); //NOT제로
            PUT_Z80A_FLAG_H(0); //하프캐리
            PUT_Z80A_FLAG_C(1); //캐리
        }

        public static void gt_CCF()
        {
            sbyte C;
          //H=C, N=0, C=Not(C)
            PUT_Z80A_FLAG_N(0); //NOT제로
            C = GET_Z80A_FLAG_C();
            PUT_Z80A_FLAG_H(C); //하프캐리
            if (C == 0) //캐리
            {
                PUT_Z80A_FLAG_C(1);
            }
            else
            {
                PUT_Z80A_FLAG_C(0);
            };
        }

        public static void gt_CPL() //비트반전
        {
          //A=Not(A), H=1, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            PUT_Z80A_FLAG_H(1); //하프캐리
            Z80A_REG_A = giGetIntToInt(~Z80A_REG_A);
        }

        public static void gt_NEG() //음수값 : -n, (NOT n) + 1 -> 뺄셈을 음수의 덧셈으로 할 경우
        {
            byte iRegOrg; short iResult;
          //P=Before A=80h, C=Before A<>00h, A=0-A, S=Sigh(A), Z=Zero(A), H=Hcr(A), N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            iRegOrg = Z80A_REG_A;
            iResult = (short)(0 - iRegOrg);
            Z80A_REG_A = giGetIntToInt(iResult);
            PUT_Z80A_FLAG_C((sbyte)(iRegOrg != 0 ? 1 : 0)); //캐리
            PUT_Z80A_FLAG_H((sbyte)(((iRegOrg ^ iResult) & H_Flag) != 0 ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(iRegOrg == 0x80 ? 1 : 0)); //오버플로
            PUT_Z80A_FLAG_S(giGet8Sign(Z80A_REG_A)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Z80A_REG_A)); //Zero
        }

        public static void gt_DAA()
        {
            byte iRegA, iAdj; short iResult; sbyte iResCry; byte iH, iL; sbyte F_H;
          //DAA
          //S=Sign(결과), Z=Zero(결과), H=하프캐리(결과), P=Peven(결과), C=작업에따라변경
          //Debug.Print " N:" + CStr(Z80A_FLAG_N) + " A:" + Right("00" + Hex(Z80A_REG_A), 2) + " C:" + CStr(Z80A_FLAG_C) + " H:" + CStr(Z80A_FLAG_H)
            iRegA = Z80A_REG_A;
            iAdj = 0;
            iResult = 0;
            iResCry = 0;
            iH = (byte)(iRegA >> 4);
            iL = (byte)(iRegA & 0x0F);
            F_H = GET_Z80A_FLAG_H();
            if (GET_Z80A_FLAG_N() == 0) //ADD
            {
                if (GET_Z80A_FLAG_C() == 0)
                {
                  if ((iH <= 0x09) && (F_H == 0) && (iL <= 0x09)) { iAdj = 0x00; };
                  if ((iH <= 0x08) && (F_H == 0) && (iL >= 0x0A)) { iAdj = 0x06; };
                  if ((iH <= 0x09) && (F_H == 1) && (iL <= 0x03)) { iAdj = 0x06; };
                  if ((iH >= 0x0A) && (F_H == 0) && (iL <= 0x09)) { iAdj = 0x60; iResCry = 1; };
                  if ((iH >= 0x09) && (F_H == 0) && (iL >= 0x0A)) { iAdj = 0x66; iResCry = 1; };
                  if ((iH >= 0x0A) && (F_H == 1) && (iL <= 0x03)) { iAdj = 0x66; iResCry = 1; };
                }
                else
                {
                  if ((iH <= 0x02) && (F_H == 0) && (iL <= 0x09)) { iAdj = 0x60; iResCry = 1; };
                  if ((iH <= 0x02) && (F_H == 0) && (iL >= 0x0A)) { iAdj = 0x66; iResCry = 1; };
                  if ((iH <= 0x03) && (F_H == 1) && (iL <= 0x03)) { iAdj = 0x66; iResCry = 1; };
                };
            }
            else //SUB
            {
                if (GET_Z80A_FLAG_C() == 0)
                { 
                  if ((iH <= 0x09) && (F_H == 0) && (iL <= 0x09)) { iAdj = 0x00; };
                  if ((iH <= 0x08) && (F_H == 1) && (iL >= 0x06)) { iAdj = 0xFA; };
                }
                else
                {
                  if ((iH >= 0x07) && (F_H == 0) && (iL <= 0x09)) { iAdj = 0xA0; iResCry = 1; };
                  if ((iH >= 0x06) && (F_H == 1) && (iL >= 0x06)) { iAdj = 0x9A; iResCry = 1; };
                };
            };
            iResult = (short)(iRegA + iAdj);
            Z80A_REG_A = giGetIntToInt(iResult);
            PUT_Z80A_FLAG_H((sbyte)(((iRegA & 0xF) + (iAdj & 0xF)) > 0xF ? 1 : 0)); //하프캐리
            PUT_Z80A_FLAG_C(iResCry); //캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Z80A_REG_A]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S((sbyte)(giGet8Sign(Z80A_REG_A))); //Sign
            PUT_Z80A_FLAG_Z((sbyte)(giGet8Zero(Z80A_REG_A))); //Zero
        }

        public static void gt_PUSH_16(ushort oVal)
        {
            MEM.PUT_MSX_MEMORY(goGetLngToLng(Z80A_REG_SP - 1), giGetLngToIntH(oVal));
            MEM.PUT_MSX_MEMORY(goGetLngToLng(Z80A_REG_SP - 2), giGetLngToIntL(oVal));
            Z80A_REG_SP = goGetLngToLng(Z80A_REG_SP - 2);
        }

        public static void gt_POP_16(ref ushort Reg16)
        {
            Reg16 = goGetIntHLToLng(MEM.GET_MSX_MEMORY((ushort)((Z80A_REG_SP + 1) & 0xFFFF)), MEM.GET_MSX_MEMORY(Z80A_REG_SP));
            Z80A_REG_SP = (ushort)((Z80A_REG_SP + 2) & 0xFFFF);
        }

        public static void gt_POP_16TO2(ref byte RegH, ref byte RegL)
        {
            RegH = MEM.GET_MSX_MEMORY((ushort)((Z80A_REG_SP + 1) & 0xFFFF));
            RegL = MEM.GET_MSX_MEMORY(Z80A_REG_SP);
            Z80A_REG_SP = (ushort)((Z80A_REG_SP + 2) & 0xFFFF);
        }

        public static void gt_RLCA()
        {
            gt_RLC(ref Z80A_REG_A, 1);
        }

        public static void gt_RLA()
        {
            gt_RL(ref Z80A_REG_A, 1);
        }

        public static void gt_RRCA()
        {
            gt_RRC(ref Z80A_REG_A, 1);
        }

        public static void gt_RRA()
        {
            gt_RR(ref Z80A_REG_A, 1);
        }

        public static void gt_RLC(ref byte Reg8, sbyte iArg)
        {
            sbyte C;
          //H=0, N=0, C=1[1]
          //P=Peven, S=Sign, Z=Zero
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)((Reg8 & 128) == 0 ? 0 : 1); //1[1]
            Reg8 = (byte)(((Reg8 << 1) & 255) + C); //2[7]+C
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            if (iArg == 0)
            {
                PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
                PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
                PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
            };
        }

        public static void gt_RL(ref byte Reg8, sbyte iArg)
        {
            sbyte C;
          //H=0, N=0, C=1[1]
          //P=Peven, S=Sign, Z=Zero
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)((Reg8 & 128) == 0 ? 0 : 1); //1[1]
            Reg8 = (byte)(((Reg8 << 1) & 255) + GET_Z80A_FLAG_C()); //2[7]+FC
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            if (iArg == 0)
            {
                PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
                PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
                PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
            };
        }

        public static void gt_RRC(ref byte Reg8, sbyte iArg)
        {
            sbyte C;
          //H=0, N=0, C=8[1]
          //P=Peven, S=Sign, Z=Zero
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)(Reg8 & 1); //8[1]
            Reg8 = (byte)((C << 7) + (Reg8 >> 1)); //C+1[7]
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            if (iArg == 0)
            {
                PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
                PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
                PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
            };
        }

        public static void gt_RR(ref byte Reg8, sbyte iArg)
        {
            sbyte C;
          //H=0, N=0, C=8[1]
          //P=Peven, S=Sign, Z=Zero
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)(Reg8 & 1); //8[1]
            Reg8 = (byte)((GET_Z80A_FLAG_C() << 7) + (Reg8 >> 1)); //FC+1[7]
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            if (iArg == 0)
            {
                PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
                PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
                PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
            };
        }

        public static void gt_SLA(ref byte Reg8)
        {
            sbyte C;
          //S=Sign, Z=Zero, H=0, P=Peven, N=0, C=1[1]
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)((Reg8 & 128) == 0 ? 0 : 1); //1[1]
            Reg8 = (byte)(((Reg8 << 1) & 255)); //2[7]+0
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_SLL(ref byte Reg8)
        {
            sbyte C;
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)((Reg8 & 128) == 0 ? 0 : 1); //1[1]
            Reg8 = (byte)(((Reg8 << 1) & 255) + 1); //2[7]+1 //+1버그명령???
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_SRL(ref byte Reg8)
        {
            sbyte C;
          //S=0, Z=Zero, H=0, P=Peven, N=0, C=8[1]
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)(Reg8 & 1); //8[1]
            Reg8 = (byte)(Reg8 >> 1); //0+1[7]
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(0); //giGet8Sign(Reg8) //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_SRA(ref byte Reg8)
        {
            sbyte C; sbyte C1;
          //S=Sign, Z=Zero, H=0, P=Peven, N=0, C=8[1]
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            C = (sbyte)(Reg8 & 1); //8[1]
            C1 = (sbyte)((Reg8 & 128) == 0 ? 0 : 1); //1[1]
            Reg8 = (byte)((C1 << 7) + (Reg8 >> 1)); //1[1]+1[7]
            PUT_Z80A_FLAG_C(C);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_RLD()
        {
            byte Reg8, iVal, iValx, iValA1, iValA2, iValB1, iValB2;
          //A,(HL)
          //S=Sign, Z=Zero, H=0, P=Peven, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            iValA1 = (byte)((Z80A_REG_A >> 4));
            iValA2 = (byte)(Z80A_REG_A & 15);
            iVal = MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL());
            iValB1 = (byte)(iVal >> 4);
            iValB2 = (byte)(iVal & 15);
            iValx = iValA2;
            iValA2 = iValB1;
            iValB1 = iValB2;
            iValB2 = iValx;
            Reg8 = (byte)((iValA1 << 4) + iValA2);
            Z80A_REG_A = Reg8;
            MEM.PUT_MSX_MEMORY(GET_Z80A_REG_HL(), (byte)((iValB1 << 4) + iValB2));
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_RRD()
        {
            byte Reg8, iVal, iValx, iValA1, iValA2, iValB1, iValB2;
            //A,(HL)
            //S=Sign, Z=Zero, H=0, P=Peven, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            iValA1 = (byte)(Z80A_REG_A >> 4);
            iValA2 = (byte)(Z80A_REG_A & 15);
            iVal = MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL());
            iValB1 = (byte)(iVal >> 4);
            iValB2 = (byte)(iVal & 15);
            iValx = iValA2;
            iValA2 = iValB2;
            iValB2 = iValB1;
            iValB1 = iValx;
            Reg8 = (byte)((iValA1 << 4) + iValA2);
            Z80A_REG_A = Reg8;
            MEM.PUT_MSX_MEMORY(GET_Z80A_REG_HL(), (byte)((iValB1 << 4) + iValB2));
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
            PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
        }

        public static void gt_LDI()
        {
          //(DE)=(HL), HL=HL+1, DE=DE+1, BC=BC-1
          //H=0, P=BC-1<>0, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            MEM.PUT_MSX_MEMORY(GET_Z80A_REG_DE(), MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()));
            PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() + 1));
            PUT_Z80A_REG_DE(goGetLngToLng(GET_Z80A_REG_DE() + 1));
            PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1));
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }

        public static void gt_LDIR()
        {
            ushort HL, DE, BC;
          //Repeat (DE)=(HL), HL=HL+1, DE=DE+1, BC=BC-1 While (BC<>0)
          //H=0, P=BC-1<>0, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            HL = GET_Z80A_REG_HL();
            DE = GET_Z80A_REG_DE();
            BC = GET_Z80A_REG_BC();
        LoopProc: ;
            MEM.PUT_MSX_MEMORY(DE, MEM.GET_MSX_MEMORY(HL));
            HL = goGetLngToLng(HL + 1);
            DE = goGetLngToLng(DE + 1);
            BC = goGetLngToLng(BC - 1);
            if (BC > 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            PUT_Z80A_REG_HL(HL);
            PUT_Z80A_REG_DE(DE);
            PUT_Z80A_REG_BC(BC);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(0); //Not오버플로
        }

        public static void gt_LDD()
        {
          //(DE)=(HL), HL=HL-1, DE=DE-1, BC=BC-1
          //H=0, P=BC-1<>0, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            MEM.PUT_MSX_MEMORY(GET_Z80A_REG_DE(), MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()));
            PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() - 1));
            PUT_Z80A_REG_DE(goGetLngToLng(GET_Z80A_REG_DE() - 1));
            PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1));
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }

        public static void gt_LDDR()
        {
            ushort HL, DE, BC;
          //Repeat (DE)=(HL), HL=HL-1, DE=DE-1, BC=BC-1 While (BC<>0)
          //H=0, P=BC-1<>0, N=0
            PUT_Z80A_FLAG_N(0); //Not뺄셈
            HL = GET_Z80A_REG_HL();
            DE = GET_Z80A_REG_DE();
            BC = GET_Z80A_REG_BC();
        LoopProc: ;
            MEM.PUT_MSX_MEMORY(DE, MEM.GET_MSX_MEMORY(HL));
            HL = goGetLngToLng(HL - 1);
            DE = goGetLngToLng(DE - 1);
            BC = goGetLngToLng(BC - 1);
            if (BC > 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            PUT_Z80A_REG_HL(HL);
            PUT_Z80A_REG_DE(DE);
            PUT_Z80A_REG_BC(BC);
            PUT_Z80A_FLAG_H(0); //Not하프캐리
            PUT_Z80A_FLAG_PV(0); //Not오버플로
        }

        public static void gt_CPI()
        {
          //CP=A-(HL), HL=HL+1, BC=BC-1
          //S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            gt_CP(MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()));
            PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() + 1));
            PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1));
          //Z80A_FLAG_C = ? //캐리
          //Z80A_FLAG_H = ? //하프캐리 -> CP결과
          //Z80A_FLAG_S = ? //Sign     -> CP결과
          //Z80A_FLAG_Z = ? //Zero     -> CP결과
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }

        public static void gt_CPIR()
        {
            ushort HL, BC;
          //Repeat CP=A-(HL), HL=HL+1, BC=BC-1 While (BC<>0) And (Z<>1)
          //S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            HL = GET_Z80A_REG_HL();
            BC = GET_Z80A_REG_BC();
        LoopProc: ;
            gt_CP(MEM.GET_MSX_MEMORY(HL));
            HL = goGetLngToLng(HL + 1);
            BC = goGetLngToLng(BC - 1);
            if ((BC != 0) && (GET_Z80A_FLAG_Z() != 1))
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            PUT_Z80A_REG_HL(HL);
            PUT_Z80A_REG_BC(BC);
          //Z80A_FLAG_C = ? //캐리
          //Z80A_FLAG_H = ? //하프캐리 -> CP결과
          //Z80A_FLAG_S = ? //Sign     -> CP결과
          //Z80A_FLAG_Z = ? //Zero     -> CP결과
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }

        public static void gt_CPD()
        {
          //CP=A-(HL), HL=HL-1, BC=BC-1
          //S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            gt_CP(MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()));
            PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() - 1));
            PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1));
          //Z80A_FLAG_C = ? //캐리
          //Z80A_FLAG_H = ? //하프캐리 -> CP결과
          //Z80A_FLAG_S = ? //Sign     -> CP결과
          //Z80A_FLAG_Z = ? //Zero     -> CP결과
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }

        public static void gt_CPDR()
        {
            ushort HL, BC;
          //Repeat CP=A-(HL), HL=HL-1, BC=BC-1 While (BC<>0) And (Z<>1)
          //S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            PUT_Z80A_FLAG_N(1); //뺄셈
            HL = GET_Z80A_REG_HL();
            BC = GET_Z80A_REG_BC();
        LoopProc: ;
            gt_CP(MEM.GET_MSX_MEMORY(HL));
            HL = goGetLngToLng(HL - 1);
            BC = goGetLngToLng(BC - 1);
            if ((BC != 0) && (GET_Z80A_FLAG_Z() != 1))
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            PUT_Z80A_REG_HL(HL);
            PUT_Z80A_REG_BC(BC);
          //Z80A_FLAG_C = ? //캐리
          //Z80A_FLAG_H = ? //하프캐리 -> CP결과
          //Z80A_FLAG_S = ? //Sign     -> CP결과
          //Z80A_FLAG_Z = ? //Zero     -> CP결과
            PUT_Z80A_FLAG_PV((sbyte)(GET_Z80A_REG_BC() > 0 ? 1 : 0)); //오버플로
        }
    }
}
