unit frmASM;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, ExtCtrls, StdCtrls,
  Windows, LConvEncoding;

type

  { TASMFrm }

  TASMFrm = class(TForm)
    ASM21ColChk: TCheckBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    MemPage0Lbl: TLabel;
    Label16: TLabel;
    MemPage1Lbl: TLabel;
    MemPage2Lbl: TLabel;
    MemPage3Lbl: TLabel;
    LoadMsgLbl: TLabel;
    LoadFme: TGroupBox;
    SaveType0Opt: TRadioButton;
    SaveType1Opt: TRadioButton;
    SaveExecTxt: TEdit;
    SaveFme: TGroupBox;
    SaveEndTxt: TEdit;
    DumpRunCmd: TButton;
    LoadRunCmd: TButton;
    SaveRunCmd: TButton;
    LoadStartTxt: TEdit;
    SaveStartTxt: TEdit;
    DumpViewCmd: TButton;
    DisASMEndTxt: TEdit;
    DumpEndTxt: TEdit;
    DumpFme: TGroupBox;
    DumpStartTxt: TEdit;
    DisASMWriteCmd: TButton;
    LoadViewCmd: TButton;
    SaveViewCmd: TButton;
    DumpWriteCmd: TButton;
    DisASMWriteTxt: TEdit;
    DisASMFme: TGroupBox;
    ASMRunCmd: TButton;
    DisASMRunCmd: TButton;
    ASMStartTxt: TEdit;
    ASMMemChk: TCheckBox;
    DisASMStartTxt: TEdit;
    DisASMViewCmd: TButton;
    LoadFileCmd: TButton;
    SaveWriteCmd: TButton;
    DumpWriteTxt: TEdit;
    LoadFileTxt: TEdit;
    SaveWriteTxt: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    SampleCmd: TButton;
    ASMViewCmd: TButton;
    ChtExitCmd: TButton;
    ASMCmd: TButton;
    DumpCmd: TButton;
    ASMFileTxt: TEdit;
    ASMWriteTxt: TEdit;
    GroupBox1: TGroupBox;
    ASMFme: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    LoadCmd: TButton;
    ASMFileCmd: TButton;
    ASMWriteCmd: TButton;
    SlotSel0Opt: TRadioButton;
    SlotSel1Opt: TRadioButton;
    LoadType0Opt: TRadioButton;
    SlotSel2Opt: TRadioButton;
    LoadType1Opt: TRadioButton;
    SlotSel3Opt: TRadioButton;
    LoadType2Opt: TRadioButton;
    SlotSel4Opt: TRadioButton;
    LoadType3Opt: TRadioButton;
    SlotSel5Opt: TRadioButton;
    SaveCmd: TButton;
    Panel1: TPanel;
    DisASMCmd: TButton;
    procedure ASMCmdClick(Sender: TObject);
    procedure ASMFileCmdClick(Sender: TObject);
    procedure ASMFileTxtEnter(Sender: TObject);
    procedure ASMFileTxtExit(Sender: TObject); procedure ASMFileTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ASMRunCmdClick(Sender: TObject);
    procedure ASMStartTxtEnter(Sender: TObject);
    procedure ASMStartTxtExit(Sender: TObject);
    procedure ASMStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ASMViewCmdClick(Sender: TObject);
    procedure ASMWriteCmdClick(Sender: TObject);
    procedure ASMWriteTxtEnter(Sender: TObject);
    procedure ASMWriteTxtExit(Sender: TObject); procedure ASMWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ChtExitCmdClick(Sender: TObject);
    procedure DisASMCmdClick(Sender: TObject);
    procedure DisASMEndTxtEnter(Sender: TObject);
    procedure DisASMEndTxtExit(Sender: TObject);
    procedure DisASMEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DisASMRunCmdClick(Sender: TObject);
    procedure DisASMStartTxtEnter(Sender: TObject);
    procedure DisASMStartTxtExit(Sender: TObject);
    procedure DisASMStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DisASMViewCmdClick(Sender: TObject);
    procedure DisASMWriteCmdClick(Sender: TObject);
    procedure DisASMWriteTxtEnter(Sender: TObject);
    procedure DisASMWriteTxtExit(Sender: TObject);
    procedure DisASMWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DumpCmdClick(Sender: TObject);
    procedure DumpEndTxtEnter(Sender: TObject);
    procedure DumpEndTxtExit(Sender: TObject);
    procedure DumpEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DumpRunCmdClick(Sender: TObject);
    procedure DumpStartTxtEnter(Sender: TObject);
    procedure DumpStartTxtExit(Sender: TObject);
    procedure DumpStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DumpViewCmdClick(Sender: TObject);
    procedure DumpWriteCmdClick(Sender: TObject);
    procedure DumpWriteTxtEnter(Sender: TObject);
    procedure DumpWriteTxtExit(Sender: TObject);
    procedure DumpWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LoadCmdClick(Sender: TObject);
    procedure LoadFileCmdClick(Sender: TObject);
    procedure LoadFileTxtEnter(Sender: TObject);
    procedure LoadFileTxtExit(Sender: TObject);
    procedure LoadFileTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure LoadRunCmdClick(Sender: TObject);
    procedure LoadStartTxtEnter(Sender: TObject);
    procedure LoadStartTxtExit(Sender: TObject);
    procedure LoadStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure LoadViewCmdClick(Sender: TObject);
    procedure SampleCmdClick(Sender: TObject);
    procedure SaveCmdClick(Sender: TObject);
    procedure SaveEndTxtEnter(Sender: TObject);
    procedure SaveEndTxtExit(Sender: TObject);
    procedure SaveEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SaveExecTxtEnter(Sender: TObject);
    procedure SaveExecTxtExit(Sender: TObject);
    procedure SaveExecTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SaveRunCmdClick(Sender: TObject);
    procedure SaveStartTxtEnter(Sender: TObject);
    procedure SaveStartTxtExit(Sender: TObject);
    procedure SaveStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SaveViewCmdClick(Sender: TObject);
    procedure SaveWriteCmdClick(Sender: TObject);
    procedure SaveWriteTxtEnter(Sender: TObject);
    procedure SaveWriteTxtExit(Sender: TObject);
    procedure SaveWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    procedure ftSlotSelect;
    function fsGet_ASM_Separate0(sStr: String): String;
    function fsGet_ASM_Separate5(sStr: String): String;
    function fsGet_ASM_Del_Comment(sStr: String): String;
    function fsLoadRunCmd_Dump: String;
    function fsGetDumpLine(oAddr: LongInt; iVal:Integer): String;
    function fsGetCheckSum(sStr: String): String;
  public

  end;

const
  con_MSX_ASMFile: String = 'C:\MSX_ASM.Txt';
  con_MSX_ASMWrite: String = 'C:\MSX_ASM_OUT.Txt';
  con_MSX_DisASMWrite: String = 'C:\MSX_DisASM_OUT.Txt';
  con_MSX_DumpWrite: String = 'C:\MSX_Dump_OUT.Txt';
  con_MSX_LoadFile: String = 'C:\MSX_Load.Txt';
  con_MSX_SaveWrite: String = 'C:\MSX_Save_OUT.Txt';

var
  ASMFrm: TASMFrm;

implementation

{$R *.lfm}

{ TASMFrm }
uses
  frmDspMessage,
  msxZ80A_Asm, msxZ80A_Dis, msxMEM, msxFDC,
  untFunction;

var
  fsViewASM_Msg: String = '';
  fsViewDisASM_Msg: String = '';
  fsViewDump_Msg: String = '';
  fsViewLoad_Msg: String = '';
  fsViewSave_Msg: String = '';

  fiDumpCont: Integer;
  fsDumpAddr: String;
  fsDumpData: String;
  fsDumpText: String;

procedure TASMFrm.FormCreate(Sender: TObject);
var
  i, P: Integer;
begin
  ASMFme.Visible := False;
  DisASMFme.Visible := False;
  DumpFme.Visible := False;
  LoadFme.Visible := False;
  SaveFme.Visible := False;

  DisASMFme.Top := ASMFme.Top; DisASMFme.Left := ASMFme.Left;
  DumpFme.Top := ASMFme.Top; DumpFme.Left := ASMFme.Left;
  LoadFme.Top := ASMFme.Top; LoadFme.Left := ASMFme.Left;
  SaveFme.Top := ASMFme.Top; SaveFme.Left := ASMFme.Left;

  ASMFileTxt.Text := con_MSX_ASMFile;
  ASMWriteTxt.Text := con_MSX_ASMWrite;
  DisASMWriteTxt.Text := con_MSX_DisASMWrite;
  DumpWriteTxt.Text := con_MSX_DumpWrite;
  LoadFileTxt.Text := con_MSX_LoadFile;
  LoadType0Opt.Checked := True;
  LoadType1Opt.Checked := False;
  LoadType2Opt.Checked := False;
  LoadType3Opt.Checked := False;
  SaveWriteTxt.Text := con_MSX_SaveWrite;
  SaveType0Opt.Checked := True;
  SaveType1Opt.Checked := False;

  for i := 0 to 255 do
    begin
      P := 0;
      P := P + gmiIfThen((i And 128) = 0, 0, 1);
      P := P + gmiIfThen((i And 64) = 0, 0, 1);
      P := P + gmiIfThen((i And 32) = 0, 0, 1);
      P := P + gmiIfThen((i And 16) = 0, 0, 1);
      P := P + gmiIfThen((i And 8) = 0, 0, 1);
      P := P + gmiIfThen((i And 4) = 0, 0, 1);
      P := P + gmiIfThen((i And 2) = 0, 0, 1);
      P := P + gmiIfThen((i And 1) = 0, 0, 1);
      if ((P = 0) Or (P = 2) Or (P = 4) Or (P = 6) Or (P = 8)) then
        Gi_P_Table[i] := 1
      else
        Gi_P_Table[i] := 0
      ;
    end;

  Gi_B_Table[0] := 1;
  Gi_B_Table[1] := 2;
  Gi_B_Table[2] := 4;
  Gi_B_Table[3] := 8;
  Gi_B_Table[4] := 16;
  Gi_B_Table[5] := 32;
  Gi_B_Table[6] := 64;
  Gi_B_Table[7] := 128;
  Gi_NB_Table[0] := $FE; //1111 1110
  Gi_NB_Table[1] := $FD; //1111 1101
  Gi_NB_Table[2] := $FB; //1111 1011
  Gi_NB_Table[3] := $F7; //1111 0111
  Gi_NB_Table[4] := $EF; //1110 1111
  Gi_NB_Table[5] := $DF; //1101 1111
  Gi_NB_Table[6] := $BF; //1011 1111
  Gi_NB_Table[7] := $7F; //0111 1111
end;

procedure TASMFrm.FormShow(Sender: TObject);
begin
  MemPage0Lbl.Caption := gmsCStr(Gi_MEM_PAGE0);
  MemPage1Lbl.Caption := gmsCStr(Gi_MEM_PAGE1);
  MemPage2Lbl.Caption := gmsCStr(Gi_MEM_PAGE2);
  MemPage3Lbl.Caption := gmsCStr(Gi_MEM_PAGE3);
end;

procedure TASMFrm.FormActivate(Sender: TObject);
begin
  //
end;

procedure TASMFrm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  //
end;

procedure TASMFrm.ChtExitCmdClick(Sender: TObject);
begin
  Close;
end;

procedure TASMFrm.ASMCmdClick(Sender: TObject);
begin
  ASMCmd.Font.Style := [];
  DisASMCmd.Font.Style := [];
  DumpCmd.Font.Style := [];
  LoadCmd.Font.Style := [];
  SaveCmd.Font.Style := [];
  ASMFme.Visible := True; ASMCmd.Font.Style := [fsBold];
  DisASMFme.Visible := False;
  DumpFme.Visible := False;
  LoadFme.Visible := False;
  SaveFme.Visible := False;
end;

procedure TASMFrm.DisASMCmdClick(Sender: TObject);
begin
  ASMCmd.Font.Style := [];
  DisASMCmd.Font.Style := [];
  DumpCmd.Font.Style := [];
  LoadCmd.Font.Style := [];
  SaveCmd.Font.Style := [];
  ASMFme.Visible := False;
  DisASMFme.Visible := True; DisASMCmd.Font.Style := [fsBold];
  DumpFme.Visible := False;
  LoadFme.Visible := False;
  SaveFme.Visible := False;
end;

procedure TASMFrm.DumpCmdClick(Sender: TObject);
begin
  ASMCmd.Font.Style := [];
  DisASMCmd.Font.Style := [];
  DumpCmd.Font.Style := [];
  LoadCmd.Font.Style := [];
  SaveCmd.Font.Style := [];
  ASMFme.Visible := False;
  DisASMFme.Visible := False;
  DumpFme.Visible := True; DumpCmd.Font.Style := [fsBold];
  LoadFme.Visible := False;
  SaveFme.Visible := False;
end;

procedure TASMFrm.LoadCmdClick(Sender: TObject);
begin
  ASMCmd.Font.Style := [];
  DisASMCmd.Font.Style := [];
  DumpCmd.Font.Style := [];
  LoadCmd.Font.Style := [];
  SaveCmd.Font.Style := [];
  ASMFme.Visible := False;
  DisASMFme.Visible := False;
  DumpFme.Visible := False;
  LoadFme.Visible := True; LoadCmd.Font.Style := [fsBold];
  SaveFme.Visible := False;
end;

procedure TASMFrm.SaveCmdClick(Sender: TObject);
begin
  ASMCmd.Font.Style := [];
  DisASMCmd.Font.Style := [];
  DumpCmd.Font.Style := [];
  LoadCmd.Font.Style := [];
  SaveCmd.Font.Style := [];
  ASMFme.Visible := False;
  DisASMFme.Visible := False;
  DumpFme.Visible := False;
  LoadFme.Visible := False;
  SaveFme.Visible := True; SaveCmd.Font.Style := [fsBold];
end;

procedure TASMFrm.ASMFileCmdClick(Sender: TObject);
var
  Dlg: TOpenDialog;
begin
  ChtExitCmd.SetFocus;
  ASMFileCmd.Enabled := False;

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일(*.*)|*.*|ASM 파일|*.ASM|BIN 파일|*.BIN|ROM 파일|*.ROM|TEXT 파일|*.TXT';

  if (Dlg.Execute) then ASMFileTxt.Text := Dlg.FileName;

  ASMFileCmd.Enabled := True;
  ASMRunCmd.SetFocus;
end;

procedure TASMFrm.ASMFileTxtEnter(Sender: TObject);
begin
  ASMFileTxt.Color := clYellow;
end;

procedure TASMFrm.ASMFileTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then ASMWriteTxt.SetFocus;
  if (Key = VK_UP) then ASMFileTxt.SetFocus;
  if (Key = VK_DOWN) then ASMWriteTxt.SetFocus;
end;

procedure TASMFrm.ASMFileTxtExit(Sender: TObject);
begin
  ASMFileTxt.Color := clWhite;

  ASMFileTxt.Text := gmsGetTrim(ASMFileTxt.Text);
  if (gmsTrim(ASMFileTxt.Text) = '') then ASMFileTxt.Text := con_MSX_ASMFile;
end;

procedure TASMFrm.ASMWriteCmdClick(Sender: TObject);
begin
  //
end;

procedure TASMFrm.ASMWriteTxtEnter(Sender: TObject);
begin
  ASMWriteTxt.Color := clYellow;
end;

procedure TASMFrm.ASMWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then ASMStartTxt.SetFocus;
  if (Key = VK_UP) then ASMFileTxt.SetFocus;
  if (Key = VK_DOWN) then ASMStartTxt.SetFocus;
end;

procedure TASMFrm.ASMWriteTxtExit(Sender: TObject);
begin
  ASMWriteTxt.Color := clWhite;

  ASMWriteTxt.Text := gmsGetTrim(ASMWriteTxt.Text);
  if (gmsTrim(ASMWriteTxt.Text) = '') then ASMWriteTxt.Text := con_MSX_ASMWrite;
end;

procedure TASMFrm.ASMStartTxtEnter(Sender: TObject);
begin
  ASMStartTxt.Color := clYellow;
end;

procedure TASMFrm.ASMStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then ASMRunCmd.SetFocus;
  if (Key = VK_UP) then ASMWriteTxt.SetFocus;
  if (Key = VK_DOWN) then ASMRunCmd.SetFocus;
end;

procedure TASMFrm.ASMStartTxtExit(Sender: TObject);
begin
  ASMStartTxt.Color := clWhite;

  ASMStartTxt.Text := gsGetStringHex4(gmsGetTrim(ASMStartTxt.Text));
end;

procedure TASMFrm.DisASMWriteCmdClick(Sender: TObject);
begin
  //
end;

procedure TASMFrm.DisASMWriteTxtEnter(Sender: TObject);
begin
  DisASMWriteTxt.Color := clYellow;
end;

procedure TASMFrm.DisASMWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DisASMStartTxt.SetFocus;
  if (Key = VK_UP) then DisASMWriteTxt.SetFocus;
  if (Key = VK_DOWN) then DisASMStartTxt.SetFocus;
end;

procedure TASMFrm.DisASMWriteTxtExit(Sender: TObject);
begin
  DisASMWriteTxt.Color := clWhite;

  DisASMWriteTxt.Text := gmsGetTrim(DisASMWriteTxt.Text);
  if (gmsTrim(DisASMWriteTxt.Text) = '') then DisASMWriteTxt.Text := con_MSX_DisASMWrite;
end;

procedure TASMFrm.DisASMStartTxtEnter(Sender: TObject);
begin
  DisASMStartTxt.Color := clYellow;
end;

procedure TASMFrm.DisASMStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DisASMEndTxt.SetFocus;
  if (Key = VK_UP) then DisASMWriteTxt.SetFocus;
  if (Key = VK_DOWN) then DisASMRunCmd.SetFocus;
end;

procedure TASMFrm.DisASMStartTxtExit(Sender: TObject);
begin
  DisASMStartTxt.Color := clWhite;

  DisASMStartTxt.Text := gsGetStringHex4(gmsGetTrim(DisASMStartTxt.Text));
end;

procedure TASMFrm.DisASMEndTxtEnter(Sender: TObject);
begin
  DisASMEndTxt.Color := clYellow;
end;

procedure TASMFrm.DisASMEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DisASMRunCmd.SetFocus;
  if (Key = VK_UP) then DisASMStartTxt.SetFocus;
  if (Key = VK_DOWN) then DisASMRunCmd.SetFocus;
end;

procedure TASMFrm.DisASMEndTxtExit(Sender: TObject);
begin
  DisASMEndTxt.Color := clWhite;

  DisASMEndTxt.Text := gsGetStringHex4(gmsGetTrim(DisASMEndTxt.Text));
end;

procedure TASMFrm.DumpWriteCmdClick(Sender: TObject);
begin
  //
end;

procedure TASMFrm.DumpWriteTxtEnter(Sender: TObject);
begin
  DumpWriteTxt.Color := clYellow;
end;

procedure TASMFrm.DumpWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DumpStartTxt.SetFocus;
  if (Key = VK_UP) then DumpWriteTxt.SetFocus;
  if (Key = VK_DOWN) then DumpStartTxt.SetFocus;
end;

procedure TASMFrm.DumpWriteTxtExit(Sender: TObject);
begin
  DumpWriteTxt.Color := clWhite;

  DumpWriteTxt.Text := gmsGetTrim(DumpWriteTxt.Text);
  if (gmsTrim(DumpWriteTxt.Text) = '') then DumpWriteTxt.Text := con_MSX_DumpWrite;
end;

procedure TASMFrm.DumpStartTxtEnter(Sender: TObject);
begin
  DumpStartTxt.Color := clYellow;
end;

procedure TASMFrm.DumpStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DumpEndTxt.SetFocus;
  if (Key = VK_UP) then DumpWriteTxt.SetFocus;
  if (Key = VK_DOWN) then DumpRunCmd.SetFocus;
end;

procedure TASMFrm.DumpStartTxtExit(Sender: TObject);
begin
  DumpStartTxt.Color := clWhite;

  DumpStartTxt.Text := gsGetStringHex4(gmsGetTrim(DumpStartTxt.Text));
end;

procedure TASMFrm.DumpEndTxtEnter(Sender: TObject);
begin
  DumpEndTxt.Color := clYellow;
end;

procedure TASMFrm.DumpEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then DumpRunCmd.SetFocus;
  if (Key = VK_UP) then DumpStartTxt.SetFocus;
  if (Key = VK_DOWN) then DumpRunCmd.SetFocus;
end;

procedure TASMFrm.DumpEndTxtExit(Sender: TObject);
begin
  DumpEndTxt.Color := clWhite;

  DumpEndTxt.Text := gsGetStringHex4(gmsGetTrim(DumpEndTxt.Text));
end;

procedure TASMFrm.LoadFileCmdClick(Sender: TObject);
var
  Dlg: TOpenDialog;
begin
  ChtExitCmd.SetFocus;
  LoadFileCmd.Enabled := False;

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일(*.*)|*.*|ASM 파일|*.ASM|BIN 파일|*.BIN|ROM 파일|*.ROM|TEXT 파일|*.TXT';

  if (Dlg.Execute) then LoadFileTxt.Text := Dlg.FileName;

  LoadFileCmd.Enabled := True;
  LoadRunCmd.SetFocus;
end;

procedure TASMFrm.LoadFileTxtEnter(Sender: TObject);
begin
  LoadFileTxt.Color := clYellow;
end;

procedure TASMFrm.LoadFileTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then LoadStartTxt.SetFocus;
  if (Key = VK_UP) then LoadFileTxt.SetFocus;
  if (Key = VK_DOWN) then LoadStartTxt.SetFocus;
end;

procedure TASMFrm.LoadFileTxtExit(Sender: TObject);
begin
  LoadFileTxt.Color := clWhite;

  LoadFileTxt.Text := gmsGetTrim(LoadFileTxt.Text);
  if (gmsTrim(LoadFileTxt.Text) = '') then LoadFileTxt.Text := con_MSX_LoadFile;
end;

procedure TASMFrm.LoadStartTxtEnter(Sender: TObject);
begin
  LoadStartTxt.Color := clYellow;
end;

procedure TASMFrm.LoadStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then LoadRunCmd.SetFocus;
  if (Key = VK_UP) then LoadFileTxt.SetFocus;
  if (Key = VK_DOWN) then LoadRunCmd.SetFocus;
end;

procedure TASMFrm.LoadStartTxtExit(Sender: TObject);
begin
  LoadStartTxt.Color := clWhite;

  LoadStartTxt.Text := gsGetStringHex4(gmsGetTrim(LoadStartTxt.Text));
end;

procedure TASMFrm.SaveWriteCmdClick(Sender: TObject);
begin
  //
end;

procedure TASMFrm.SaveWriteTxtEnter(Sender: TObject);
begin
  SaveWriteTxt.Color := clYellow;
end;

procedure TASMFrm.SaveWriteTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then SaveStartTxt.SetFocus;
  if (Key = VK_UP) then SaveWriteTxt.SetFocus;
  if (Key = VK_DOWN) then SaveStartTxt.SetFocus;
end;

procedure TASMFrm.SaveWriteTxtExit(Sender: TObject);
begin
  SaveWriteTxt.Color := clWhite;

  SaveWriteTxt.Text := gmsGetTrim(SaveWriteTxt.Text);
  if (gmsTrim(SaveWriteTxt.Text) = '') then SaveWriteTxt.Text := con_MSX_SaveWrite;
end;

procedure TASMFrm.SaveStartTxtEnter(Sender: TObject);
begin
  SaveStartTxt.Color := clYellow;
end;

procedure TASMFrm.SaveStartTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then SaveEndTxt.SetFocus;
  if (Key = VK_UP) then SaveWriteTxt.SetFocus;
  if (Key = VK_DOWN) then SaveRunCmd.SetFocus;
end;

procedure TASMFrm.SaveStartTxtExit(Sender: TObject);
begin
  SaveStartTxt.Color := clWhite;

  SaveStartTxt.Text := gsGetStringHex4(gmsGetTrim(SaveStartTxt.Text));
end;

procedure TASMFrm.SaveEndTxtEnter(Sender: TObject);
begin
  SaveEndTxt.Color := clYellow;
end;

procedure TASMFrm.SaveEndTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then SaveExecTxt.SetFocus;
  if (Key = VK_UP) then SaveStartTxt.SetFocus;
  if (Key = VK_DOWN) then SaveRunCmd.SetFocus;
end;

procedure TASMFrm.SaveEndTxtExit(Sender: TObject);
begin
  SaveEndTxt.Color := clWhite;

  SaveEndTxt.Text := gsGetStringHex4(gmsGetTrim(SaveEndTxt.Text));
end;

procedure TASMFrm.SaveExecTxtEnter(Sender: TObject);
begin
  SaveExecTxt.Color := clYellow;
end;

procedure TASMFrm.SaveExecTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) then SaveRunCmd.SetFocus;
  if (Key = VK_UP) then SaveEndTxt.SetFocus;
  if (Key = VK_DOWN) then SaveRunCmd.SetFocus;
end;

procedure TASMFrm.SaveExecTxtExit(Sender: TObject);
begin
  SaveExecTxt.Color := clWhite;

  SaveExecTxt.Text := gsGetStringHex4(gmsGetTrim(SaveExecTxt.Text));
end;

procedure TASMFrm.ASMRunCmdClick(Sender: TObject);
var
  TxtFile: TextFile;
  OutFile: TextFile;
  TxtLine, TxtWrite: String;
  TT, Tr: String;
  Tp: String; Ln: LongInt; eMsg: String;
  i, K: Integer; S: String;
  StartNo: LongInt; StChk: String; oAddr: LongInt; iVal, iMem: Integer;
label
  ReadProc_0, NextProc_0, CloseProc_0, ReadProc_1, SkipProc_1, NextProc_1, CloseProc_X, CloseProc_1, LastProc, ExitProc;
begin
  //If Gi_MSX_Execute = 1 Then GoTo ExitProc '실행중종료
  ftSlotSelect;

  if (gmsTrim(ASMFileTxt.Text) = '') then
    begin
      ASMFileTxt.SetFocus;
      goto ExitProc;
    end;
  if (gb_MSX_DSK_FILE_EXIST(gmsTrim(ASMFileTxt.Text)) = False) then //파일유무확인
    begin
      ASMFileTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(ASMWriteTxt.Text) = '') then
    begin
      ASMFileTxt.SetFocus;
      GoTo ExitProc;
    end;

  TT := '';

  ChtExitCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents
  ASMRunCmd.Enabled := False;

  iMem := gmiIfThen(ASMMemChk.Checked = True, 1, 0);
  StartNo := goGetHex16ToLng(ASMStartTxt.Text);
  StChk := gmsTrim(ASMStartTxt.Text);

  // ---------- Pass 1 ----------
  Gi_Z80A_Asm := 0; //0:Pass1, 1:Pass2

  for i := 0 to Gi_Label_Tot do
    begin
      gsASM_Wrt_Label[i] := '';
      gsASM_Wrt_Addr[i] := 0;
    end;

  Z80A_REG_PC_Asm := -1;

  Ln := 0;
  AssignFile(TxtFile, gmsTrim(ASMFileTxt.Text));
  Reset(TxtFile); //파일없으면오류발생

ReadProc_0:
  ReadLn(TxtFile, TxtLine);
  if (gmiIfThen(ASM21ColChk.Checked = True, 1, 0) = 1) then TxtLine := gmsMid(TxtLine, 21);
  TxtLine := gmsReplace(TxtLine, gmsChr(9), ' '); //TAB은 공백으로
  //MessageDlg(Self.Caption, TxtLine, mtError, [mbOK], 0);

  Tr := TxtLine; TxtWrite := '';
  Ln := Ln + 1; Tp := gmsRight('00000' + gmsCStr(Ln), 5) + ' ' + Tr;

  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  Tr := fsGet_ASM_Del_Comment(Tr); //코멘트 삭제 [;]
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      GoTo NextProc_0;
    end;

  Tr := fsGet_ASM_Separate0(Tr); //분리하기0 & 대문자변환(''문자열제외)
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  Tr := fsGet_ASM_Separate5(Tr); //분리하기5[' '], gsASM1~5,x
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  if (gsASM1 = 'ORG') then //ORG
    begin
      eMsg := gs_Z80A_ASM_ORG;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + gmsSpace(2) + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  if (gmsRight(gsASM1, 1) = ':') then //Label
    begin
      eMsg := gs_Z80A_ASM_LABEL;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      if (gsASM2 = '') then
        begin
          gsASM2 := 'EQU';
          gsASM3 := '$';
        end;
      if (gsASM2 <> 'EQU') then
        begin
          eMsg := gs_Z80A_ASM_Label_Write(gsASM_Label, Z80A_REG_PC_Asm);
          if (eMsg <> '') then
            begin
              TT := '';
              TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
              TT := TT + Tp + vbCrLf;
              TT := TT + eMsg + vbCrLf;
              goto CloseProc_X;
            end;
          gsASM1 := gsASM2;
          gsASM2 := gsASM3;
          gsASM3 := gsASM4;
          gsASM4 := gsASM5;
          gsASM5 := gsASMx;
          gsASMx := '';
        end;
    end;

  if (gsASM2 = 'EQU') then //EQU
    begin
      eMsg := gs_Z80A_ASM_EQU;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      eMsg := gs_Z80A_ASM_Label_Write(gsASM_Label, goASM_Addr);
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      TxtWrite := gsGetLngToHex16(goASM_Addr) + ' =' + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  if (gsASM1 = 'END') then //END
    begin
      eMsg := gs_Z80A_ASM_END;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto NextProc_0;
    end;

  if (Z80A_REG_PC_Asm = -1) then
    begin
      eMsg := '## 시작번지 미지정 (ORG없음) !';
      TT := '';
      TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
      TT := TT + Tp + vbCrLf;
      TT := TT + eMsg + vbCrLf;
      goto CloseProc_X;
    end;

  if ((gsASM1 = 'DEFB') Or (gsASM1 = 'DB')) then //DEFB
    begin
      eMsg := gs_Z80A_ASM_DEFB;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto NextProc_0;
    end;

  if ((gsASM1 = 'DEFW') Or (gsASM1 = 'DW')) then //DEFW
    begin
      eMsg := gs_Z80A_ASM_DEFW;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto NextProc_0;
    end;

  if ((gsASM1 = 'DEFM') Or (gsASM1 = 'DM')) then //DEFM
    begin
      eMsg := gs_Z80A_ASM_DEFM;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto NextProc_0;
    end;

  if ((gsASM1 = 'DEFS') Or (gsASM1 = 'DS')) then //DEFS
    begin
      eMsg := gs_Z80A_ASM_DEFS;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_X;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto NextProc_0;
    end;

  eMsg := gs_Z80A_ASM_CODE; //CODE
  if (eMsg <> '') then
    begin
      TT := '';
      TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
      TT := TT + Tp + vbCrLf;
      TT := TT + eMsg + vbCrLf;
      goto CloseProc_X;
    end;
  TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine;
  Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;

NextProc_0:
  if (Eof(TxtFile)) then goto CloseProc_0;
  goto ReadProc_0;

CloseProc_0:
  CloseFile(TxtFile);

  // ---------- Pass 2 ----------
  Gi_Z80A_Asm := 1; //0:Pass1, 1:Pass2

  Z80A_REG_PC_Asm := -1;

  Ln := 0;
  AssignFile(TxtFile, gmsTrim(ASMFileTxt.Text));
  Reset(TxtFile);

  AssignFile(OutFile, gmsTrim(ASMWriteTxt.Text));
  ReWrite(OutFile); //기존파일덮어쓰기

ReadProc_1:
  ReadLn(TxtFile, TxtLine);
  if (gmiIfThen(ASM21ColChk.Checked = True, 1, 0) = 1) then TxtLine := gmsMid(TxtLine, 21);
  TxtLine := gmsReplace(TxtLine, gmsChr(9), ' '); //TAB은 공백으로
  //MessageDlg(Self.Caption, TxtLine, mtError, [mbOK], 0);

  Tr := TxtLine; TxtWrite := '';
  Ln := Ln + 1; Tp := gmsRight('00000' + gmsCStr(Ln), 5) + ' ' + Tr;

  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  Tr := fsGet_ASM_Del_Comment(Tr); //코멘트 삭제 [;]
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  Tr := fsGet_ASM_Separate0(Tr); //분리하기0 & 대문자변환(''문자열제외)
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  Tr := fsGet_ASM_Separate5(Tr); //분리하기5[' '], gsASM1~5,x
  if (gmsTrim(Tr) = '') then
    begin
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  if (gsASM1 = 'ORG') then //ORG
    begin
      eMsg := gs_Z80A_ASM_ORG;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + gmsSpace(2) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  if (gmsRight(gsASM1, 1) = ':') then //Label
    begin
      eMsg := gs_Z80A_ASM_LABEL;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      if (gsASM2 = '') then
        begin
          gsASM2 := 'EQU';
          gsASM3 := '$';
        end;
      if (gsASM2 <> 'EQU') then
        begin
          gsASM1 := gsASM2;
          gsASM2 := gsASM3;
          gsASM3 := gsASM4;
          gsASM4 := gsASM5;
          gsASM5 := gsASMx;
          gsASMx := '';
        end;
    end;

  if (gsASM2 = 'EQU') Then //EQU
    begin
      eMsg := gs_Z80A_ASM_EQU;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      TxtWrite := gsGetLngToHex16(goASM_Addr) + ' =' + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  if (gsASM1 = 'END') then //END
    begin
      eMsg := gs_Z80A_ASM_END;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      TxtWrite := gmsSpace(6) + gmsSpace(14) + TxtLine;
      goto SkipProc_1;
    end;

  if (Z80A_REG_PC_Asm = -1) then
    begin
      eMsg := '## 시작번지 미지정 (ORG없음) !';
      TT := '';
      TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
      TT := TT + Tp + vbCrLf;
      TT := TT + eMsg + vbCrLf;
      goto CloseProc_1;
    end;

  if ((gsASM1 = 'DEFB') Or (gsASM1 = 'DB')) then //DEFB
    begin
      eMsg := gs_Z80A_ASM_DEFB;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto SkipProc_1;
    end;

  if ((gsASM1 = 'DEFW') Or (gsASM1 = 'DW')) then //DEFW
    begin
      eMsg := gs_Z80A_ASM_DEFW;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto SkipProc_1;
    end;

  if ((gsASM1 = 'DEFM') Or (gsASM1 = 'DM')) then //DEFM
    begin
      eMsg := gs_Z80A_ASM_DEFM;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      GoTo SkipProc_1;
    end;

  if ((gsASM1 = 'DEFS') Or (gsASM1 = 'DS')) then //DEFS
    begin
      eMsg := gs_Z80A_ASM_DEFS;
      if (eMsg <> '') then
        begin
          TT := '';
          TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
          TT := TT + Tp + vbCrLf;
          TT := TT + eMsg + vbCrLf;
          goto CloseProc_1;
        end;
      if (gmiLen(gsASM_Data) <= 12) then
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine
      else
        TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gsASM_Data + gmsSpace(2) + TxtLine
      ;
      Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;
      goto SkipProc_1;
    end;

  eMsg := gs_Z80A_ASM_CODE; //CODE
  if (eMsg <> '') then
    begin
      TT := '';
      TT := TT + 'Pass : ' + gmsCStr(Gi_Z80A_Asm) + vbCrLf;
      TT := TT + Tp + vbCrLf;
      TT := TT + eMsg + vbCrLf;
      goto CloseProc_1;
    end;
  TxtWrite := gsGetLngToHex16(Z80A_REG_PC_Asm) + ': ' + gmsLeft(gsASM_Data + gmsSpace(12), 12) + gmsSpace(2) + TxtLine;
  Z80A_REG_PC_Asm := Z80A_REG_PC_Asm + giASM_PC_Add;

SkipProc_1:
  WriteLn(OutFile, TxtWrite); //Text파일(ANSI) 읽어서 저장시 한글 정상저장 됨

  //Text파일(ANSI) 읽어서 Memo 로 보낼때 한글 깨짐 처리
  TxtWrite := CP949ToUTF8(TxtWrite); //AnsiToUTF8(),UTF8ToAnsi(),CP949ToUTF8(),UTF8ToCP949()
  TT := TT + TxtWrite + vbCrLf;

  if (iMem = 1) then
    begin
      Tr := TxtWrite;
      if (gmsTrim(Tr) = '') then goto NextProc_1;
      if (gmsMid(Tr, 5, 1) <> ':') then goto NextProc_1;
      if (StChk = '') then StartNo := goGetHex16ToLng(gmsLeft(Tr, 4));
      Tr := gmsMid(Tr, 7); K := gmiInStr(1, Tr, ' '); if (K > 0) then Tr := gmsLeft(Tr, K - 1);
      for i := 1 to (K div 2) do
        begin
          S := gmsTrim(gmsMid(Tr, (i * 2) - 1, 2));
          if (S <> '') then
            begin
              if (StChk = '') then
                oAddr := StartNo + i - 1
              else
                oAddr := StartNo
              ;
              iVal := giGetHex8ToInt(S);
              gt_PUT_MSX_MEMORY(oAddr, iVal);
              if (StChk <> '') then StartNo := StartNo + 1;
            end;
        end;
    end;

NextProc_1:
  if (Eof(TxtFile)) then goto CloseProc_1;
  goto ReadProc_1;

CloseProc_X:
  CloseFile(TxtFile);
  goto LastProc;

CloseProc_1:
  CloseFile(TxtFile);
  CloseFile(OutFile);
  // ---------- End ----------

LastProc:
  ASMRunCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  fsViewASM_Msg := TT;

  GsDspMessage := fsViewASM_Msg;
  DspMessageFrm.ShowModal;

ExitProc:
  Gi_MSX_SLOT := 0;
end;

procedure TASMFrm.ASMViewCmdClick(Sender: TObject);
begin
  GsDspMessage := fsViewASM_Msg;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.DisASMRunCmdClick(Sender: TObject);
var
  OutFile: TextFile;
  TT, T: String; i: LongInt;
  StAddr, EdAddr: LongInt;
label
  LoopProc0, LoopProc, ExitProc;
begin
  //If Gi_MSX_Execute = 1 Then GoTo ExitProc '실행중종료
  ftSlotSelect;

  if (gmsTrim(DisASMWriteTxt.Text) = '') then
    begin
      DisASMWriteTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(DisASMStartTxt.Text) = '') then
    begin
      DisASMStartTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(DisASMEndTxt.Text) = '') then
    begin
      DisASMEndTxt.SetFocus;
      goto ExitProc;
    end;

  for i := 0 to 65535 do Gi_MSX_DisASM_MEM_Use[i] := 0; //Jump&Call Label

  StAddr := goGetHex16ToLng(gmsTrim(DisASMStartTxt.Text));
  EdAddr := goGetHex16ToLng(gmsTrim(DisASMEndTxt.Text));
  if (StAddr > 65520) then StAddr := 65520;
  if (EdAddr > 65520) then EdAddr := 65520;

  ChtExitCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents
  DisASMCmd.Enabled := False;

  TT := '';

  Z80A_REG_PC_DASM_ST := StAddr;
  Z80A_REG_IDX_DASM := 0;
  Z80A_Dis_ADDR := 0;
  Z80A_Dis_DUMP := '';
  Z80A_Dis_ASM1 := '';
  Z80A_Dis_ASM2 := '';

LoopProc0:
  gt_Move_Z80A_CODE;
  if (Z80A_REG_PC_DASM_ST <= EdAddr) then goto LoopProc0;

  Z80A_REG_PC_DASM_ST := StAddr;
  Z80A_REG_IDX_DASM := 0;
  Z80A_Dis_ADDR := 0;
  Z80A_Dis_DUMP := '';
  Z80A_Dis_ASM1 := '';
  Z80A_Dis_ASM2 := '';

  AssignFile(OutFile, gmsTrim(DisASMWriteTxt.Text));
  ReWrite(OutFile); //기존파일덮어쓰기

T := '';
  T := T + gsGetLngToHex16(StAddr) + '  ';
  T := T + gmsSpace(14) + gmsSpace(7);
  T := T + gmsLeft('ORG' + gmsSpace(6), 6);
  T := T + gsGetLngToHex16_Disp(StAddr);
  WriteLn(OutFile, T);
  TT := TT + T + vbCrLf;
LoopProc:
  T := '';
  gt_Move_Z80A_CODE;
  T := T + gsGetLngToHex16(go_Z80A_Dis_ADDR) + ': ';
  T := T + gmsLeft(gs_Z80A_Dis_DUMP + Space(14), 14);
  if (Gi_MSX_DisASM_MEM_Use[go_Z80A_Dis_ADDR] <> 0) then
    T := T + 'M' + gsGetLngToHex16(go_Z80A_Dis_ADDR) + ': '
  else
    T := T + gmsSpace(7)
  ;
  T := T + gmsLeft(gs_Z80A_Dis_ASM1 + gmsSpace(6), 6);
  T := T + gs_Z80A_Dis_ASM2;
  WriteLn(OutFile, T);
  TT := TT + T + vbCrLf;
  if (Z80A_REG_PC_DASM_ST <= EdAddr) then goto LoopProc;

  CloseFile(OutFile);

  DisASMCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  fsViewDisASM_Msg := TT;

  GsDspMessage := fsViewDisASM_Msg;
  DspMessageFrm.ShowModal;

ExitProc:
  Gi_MSX_SLOT := 0;
end;

procedure TASMFrm.DisASMViewCmdClick(Sender: TObject);
begin
  GsDspMessage := fsViewDisASM_Msg;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.DumpRunCmdClick(Sender: TObject);
var
  OutFile: TextFile;
  TT, T: String;
  L: LongInt;
  StartNo, EndNo, ExecNo: LongInt;
label
  ExitProc;
begin
  //If Gi_MSX_Execute = 1 Then GoTo ExitProc '실행중종료
  ftSlotSelect;

  if (gmsTrim(DumpWriteTxt.Text) = '') then
    begin
      DumpWriteTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(DumpStartTxt.Text) = '') then
    begin
      DumpStartTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(DumpEndTxt.Text) = '') then
    begin
      DumpEndTxt.SetFocus;
      GoTo ExitProc;
    end;

  TT := '';

  ChtExitCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents
  DumpRunCmd.Enabled := False;

  StartNo := goGetHex16ToLng(DumpStartTxt.Text);
  EndNo := goGetHex16ToLng(DumpEndTxt.Text);
  if (EndNo < StartNo) then EndNo := StartNo;

  AssignFile(OutFile, gmsTrim(DumpWriteTxt.Text));
  ReWrite(OutFile); //기존파일덮어쓰기

  for L := StartNo to EndNo do
    begin
      T := fsGetDumpLine(L, gb_GET_MSX_MEMORY(L));
      if (T <> '') then
        begin
          WriteLn(OutFile, T);
          TT := TT + T + vbCrLf;
        end;
    end;
  T := fsGetDumpLine(-1, 0);
  if (T <> '') then
    begin
      WriteLn(OutFile, T);
      TT := TT + T + vbCrLf;
    end;

  CloseFile(OutFile);

  DumpRunCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  fsViewDump_Msg := TT;

  GsDspMessage := fsViewDump_Msg;
  DspMessageFrm.ShowModal;

ExitProc:
  Gi_MSX_SLOT := 0;
end;

procedure TASMFrm.DumpViewCmdClick(Sender: TObject);
begin
  GsDspMessage := fsViewDump_Msg;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.LoadRunCmdClick(Sender: TObject);
var
  FH: File Of Byte;
  TT, T: String;
  RecordCount: LongInt;
  L: Long; b: Byte; iVal: Integer;
  StartNo: LongInt; StChk: String;
  oStNo, oEdNo, oExNo: LongInt;
  iStH: Integer = 0; iStL: Integer = 0;
  iEdH: Integer = 0; iEdL: Integer = 0;
  iExH: Integer = 0; iExL: Integer = 0;
label
  NextProc, CloseProc, LastProc, ExitProc;
begin
  //If Gi_MSX_Execute = 1 Then GoTo ExitProc '실행중종료
  ftSlotSelect;

  if (gmsTrim(LoadFileTxt.Text) = '') then
    begin
      LoadFileTxt.SetFocus;
      goto ExitProc;
    end;
  RecordCount := 0;
  if (gb_MSX_DSK_FILE_EXIST(Trim(LoadFileTxt.Text)) = False) then
    begin
      LoadFileTxt.SetFocus;
      goto ExitProc;
    end
  else
    begin
      RecordCount := Gi_FILE_SIZE;
    end;
  if (RecordCount = 0) then goto CloseProc;
  if ((gmsTrim(LoadStartTxt.Text) = '') And (LoadType1Opt.Checked = True)) then
    begin
      LoadStartTxt.SetFocus;
      goto ExitProc;
    end;

  TT := '';

  LoadMsgLbl.Caption := '';

  ChtExitCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents
  LoadRunCmd.Enabled := False;

  if ((LoadType2Opt.Checked = True) Or (LoadType3Opt.Checked = True)) then //Dump,DisASM
    begin
      TT := fsLoadRunCmd_Dump;
      goto LastProc;
    end;

  AssignFile(FH, gmsTrim(LoadFileTxt.Text));
  Reset(FH); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)

  StartNo := goGetHex16ToLng(LoadStartTxt.Text);
  StChk := gmsTrim(LoadStartTxt.Text);

  for L := 1 to RecordCount do
    begin
      Read(FH, b); iVal := b;
      if (LoadType0Opt.Checked = True) then //Bin
        begin
          if (L = 1) then goto NextProc; //식별Byte
          if (L = 2) then //시작
            begin
              iStL := iVal;
              goto NextProc;
            end;
          if (L = 3) then
            begin
              iStH := iVal;
              goto NextProc;
            end;
          oStNo := goGetIntHLToLng(iStH, iStL);
          if (L = 4) then //종료
            begin
              iEdL := iVal;
              goto NextProc;
            end;
          if (L = 5) then
            begin
              iEdH := iVal;
              goto NextProc;
            end;
          oEdNo := goGetIntHLToLng(iEdH, iEdL);
          if (L = 6) then //실행
            begin
              iExL := iVal;
              goto NextProc;
            end;
          if (L = 7) then
            begin
              iExH := iVal;
              goto NextProc;
            end;
          oExNo := goGetIntHLToLng(iExH, iExL);
          if (L = 8) then
            begin
              LoadMsgLbl.Caption := gsGetLngToHex16(oStNo) + ',' + gsGetLngToHex16(oEdNo) + ',' + gsGetLngToHex16(oExNo);
              if (StChk = '') then StartNo := oStNo;
            end;
        end;
      gt_PUT_MSX_MEMORY(StartNo, iVal);
      T := fsGetDumpLine(StartNo, iVal);
      if (T <> '') then TT := TT + T + vbCrLf;
      StartNo := StartNo + 1;
NextProc:
    end;

  T := fsGetDumpLine(-1, 0);
  if (T <> '') then TT := TT + T + vbCrLf;

CloseProc:
  CloseFile(FH);

LastProc:
  LoadRunCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  fsViewLoad_Msg := TT;

  GsDspMessage := fsViewLoad_Msg;
  DspMessageFrm.ShowModal;

ExitProc:
  Gi_MSX_SLOT := 0;
end;

procedure TASMFrm.LoadViewCmdClick(Sender: TObject);
begin
  GsDspMessage := fsViewLoad_Msg;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.SaveRunCmdClick(Sender: TObject);
var
  FH: File Of Byte;
  TT, T: String;
  L: LongInt; b: Byte;
  StartNo, EndNo, ExecNo: LongInt;
  iStH, iStL: Integer;
  iEdH, iEdL: Integer;
  iExH, iExL: Integer;
label
  ExitProc;
begin
  //If Gi_MSX_Execute = 1 Then GoTo ExitProc '실행중종료
  ftSlotSelect;

  if (gmsTrim(SaveWriteTxt.Text) = '') then
    begin
      SaveWriteTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(SaveStartTxt.Text) = '') then
    begin
      SaveStartTxt.SetFocus;
      goto ExitProc;
    end;
  if (gmsTrim(SaveEndTxt.Text) = '') then
    begin
      SaveEndTxt.SetFocus;
      goto ExitProc;
    end;
  if ((Trim(SaveExecTxt.Text) = '') And (SaveType0Opt.Checked = True)) then
    begin
      SaveExecTxt.SetFocus;
      goto ExitProc
    end;

  TT := '';

  ChtExitCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents
  SaveRunCmd.Enabled := False;

  StartNo := goGetHex16ToLng(SaveStartTxt.Text);
  EndNo := goGetHex16ToLng(SaveEndTxt.Text);
  ExecNo := goGetHex16ToLng(SaveExecTxt.Text);
  if (EndNo < StartNo) then EndNo := StartNo;

  iStL := giGetHex8ToInt(gmsRight(SaveStartTxt.Text, 2));
  iStH := giGetHex8ToInt(gmsLeft(SaveStartTxt.Text, 2));
  iEdL := giGetHex8ToInt(gmsRight(SaveEndTxt.Text, 2));
  iEdH := giGetHex8ToInt(gmsLeft(SaveEndTxt.Text, 2));
  iExL := giGetHex8ToInt(gmsRight(SaveExecTxt.Text, 2));
  iExH := giGetHex8ToInt(gmsLeft(SaveExecTxt.Text, 2));

  AssignFile(FH, gmsTrim(SaveWriteTxt.Text));
  Rewrite(FH); //출력(기존파일이있으면삭제)

  if (SaveType0Opt.Checked = True) then //Bin
    begin
      b := 254; Write(FH, b); //FEh
      b := iStL; Write(FH, b);
      b := iStH; Write(FH, b);
      b := iEdL; Write(FH, b);
      b := iEdH; Write(FH, b);
      b := iExL; Write(FH, b);
      b := iExH; Write(FH, b);
    end;
  for L := StartNo to EndNo do
    begin
      b := gb_GET_MSX_MEMORY(L);
      Write(FH, b);
      T := fsGetDumpLine(L, gb_GET_MSX_MEMORY(L));
      If (T <> '') then TT := TT + T + vbCrLf;
    end;

  CloseFile(FH);

  T := fsGetDumpLine(-1, 0);
  if (T <> '') then TT := TT + T + vbCrLf;

  SaveRunCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  fsViewSave_Msg := TT;

  GsDspMessage := fsViewSave_Msg;
  DspMessageFrm.ShowModal;

ExitProc:
  Gi_MSX_SLOT := 0;
end;

procedure TASMFrm.SaveViewCmdClick(Sender: TObject);
begin
  GsDspMessage := fsViewSave_Msg;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.SampleCmdClick(Sender: TObject);
var
  S: String;
begin
  S := '';

  S := S + '          ORG       4000h               ;시작번지설정 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '          CHPUT     EQU       0A2h      ;레이블정의 - CHPUT [A]의 문자 출력 ' + vbCrLf;
  S := S + '          INT32     EQU       6Fh       ;INT32 - 화면을 Graphic 1모드(32*24) 초기화 ' + vbCrLf;
  S := S + '          LINELEN   EQU       0F3B0h    ;현재 화면의 폭 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '         ;Cartridge ' + vbCrLf;
  S := S + '          DM        ''AB''                ;롬카트리지 구분용 ' + vbCrLf;
  S := S + '          DW        ProgramStart        ;시작번지 ' + vbCrLf;
  S := S + '          DB        0,0,0,0,0,0         ;또는 DS 6 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'ProgramStart: ' + vbCrLf;
  S := S + '          CALL      INT32               ;Init32 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '          LD        A, 32               ;Width 32 ' + vbCrLf;
  S := S + '          LD        (LINELEN), A        ;또는 LD (0F3B0h), A ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '          LD        HL, Message ' + vbCrLf;
  S := S + '          Call      PrintStr ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'Prog_Loop:JR        Prog_Loop           ;롬카트리지 실행이라 무한루프로 처리 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'New_Line: PUSH      AF ' + vbCrLf;
  S := S + '          LD        A, 10+3             ;13:CR ' + vbCrLf;
  S := S + '          Call      CHPUT ' + vbCrLf;
  S := S + '          LD        A, 10               ;10:LF ' + vbCrLf;
  S := S + '          CALL      CHPUT + 1-1         ;+,-,*,/ 연산가능 ' + vbCrLf;
  S := S + '          POP       AF ' + vbCrLf;
  S := S + '          RET ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'PrintStr: EQU       $ ' + vbCrLf;
  S := S + '          LD        A, (HL) ' + vbCrLf;
  S := S + '          CP        255 ' + vbCrLf;
  S := S + '          RET       Z ' + vbCrLf;
  S := S + '          INC       HL ' + vbCrLf;
  S := S + '          Call      CHPUT ' + vbCrLf;
  S := S + '          JR        PrintStr ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'Message:  DM        ''Hello World !'' ' + vbCrLf;
  S := S + '          DB        255 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '         ;아래는 실행과 무관 - 선언문 설명용 ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + 'TestAddr  EQU       $                   ;현재번지정의 ' + vbCrLf;
  S := S + 'TestAddr2 EQU       TestAddr+1 ' + vbCrLf;
  S := S + '         ;DM 또는 DEFM (문자열) - 문자는 [''] 로 ' + vbCrLf;
  S := S + '          DEFM      ''ABC'', ''A'', ''B'', ''012'', ''0'', ''1'' ' + vbCrLf;
  S := S + '         ;DW 또는 DEFW (2Byte데이터) 10진수는 구분자 없거나 d, 16진수는 h, 2진수는 b ' + vbCrLf;
  S := S + '          DEFW      0h, 100H, 100H-1, 0ABCDh, 0, 100, 32d, 1234d, 1010b, ProgramStart, TestAddr, TestAddr2 ' + vbCrLf;
  S := S + '         ;DB 또는 DEFB (1Byte데이터) 10진수는 구분자 없거나 d, 16진수는 h, 2진수는 b ' + vbCrLf;
  S := S + '          DEFB      0, 1, 1+2+3-1, 0Ah, 0Bh, 10h, 0ABh, 32d, 1010b, ''A'', ''B'', '' '', ''1'' ' + vbCrLf;
  S := S + '         ;DS 또는 DEFS (영역확보) ' + vbCrLf;
  S := S + '          DEFS 1, 2, 3 ' + vbCrLf;
  S := S + '          DM        ''ABC abc 123 + - * / :'', '' '' ' + vbCrLf;
  S := S + '          LD        A, ''A'' ' + vbCrLf;
  S := S + '          LD        A, ''A''+1 ' + vbCrLf;
  S := S + '          LD        A, ''A''-1 ' + vbCrLf;
  S := S + '          LD        A, ''A'' + 1 - 1 ' + vbCrLf;
  S := S + '          LD        A, ''A''*2 ' + vbCrLf;
  S := S + '          LD        A, ''A''/2 ' + vbCrLf;
  S := S + '          LD        A, ''a''-''A'' ' + vbCrLf;
  S := S + '          LD        A, ''A''+10-10h+10b+10d ' + vbCrLf;
  S := S + '' + vbCrLf;
  S := S + '          END                           ;종료 ' + vbCrLf;

  GsDspMessage := S;
  DspMessageFrm.ShowModal;
end;

procedure TASMFrm.ftSlotSelect;
begin
  Gi_MSX_SLOT := 0; //기본Slot
  if (SlotSel1Opt.Checked = True) then Gi_MSX_SLOT := 1; //Slot#0
  if (SlotSel2Opt.Checked = True) then Gi_MSX_SLOT := 2; //Slot#1
  if (SlotSel3Opt.Checked = True) then Gi_MSX_SLOT := 3; //Slot#2
  if (SlotSel4Opt.Checked = True) then Gi_MSX_SLOT := 4; //Slot#3
  if (SlotSel5Opt.Checked = True) then Gi_MSX_SLOT := 5; //VRAM

  fiDumpCont := 0;
  fsDumpAddr := '';
  fsDumpData := '';
  fsDumpText := '';
end;

//분리하기0 & 대문자변환(''문자열제외)
function TASMFrm.fsGet_ASM_Separate0(sStr: String): String;
var
  R: String;
  i, K: Integer; C: String;
label
  LoopProc, LastProc;
begin
  R := '';

  K := 0;
  for i := 1 to gmiLen(sStr) do
    begin
      C := gmsMid(sStr, i, 1);
      if (C = '''') then
        begin
          K := K + 1;
          if (K = 2) then K := 0;
        end;
      if (K = 1) then
        begin //['문자열']-예약문자는특수문자로-나중에원복
          if (C = ' ') then C := '＿';
          if (C = ',') then C := '，';
          if (C = '+') then C := '＋';
          if (C = '-') then C := '－';
          if (C = '*') then C := '＊';
          if (C = '/') then C := '／';
          if (C = ':') then C := '：';
        end
      else
        begin //[문자열]
          if ((C >= 'a') And (C <= 'z')) then C := gmsChr(gmiAsc(C) - (gmiAsc('a') - gmiAsc('A'))); //대문자변환
        end;
      R := R + C;
    end;

  R := gmsTrim(gmsReplace(R, ',', ', '));
  R := gmsTrim(gmsReplace(R, ':', ': '));
LoopProc:
  R := gmsTrim(gmsReplace(R, '  ', ' ')); //공백은[' ']1칸으로
  if (gmiInStr(1, R, '  ') > 0) then goto LoopProc;
  R := gmsTrim(gmsReplace(R, '( ', '(')); //공백없애기(연산자)
  R := gmsTrim(gmsReplace(R, ' )', ')'));
  R := gmsTrim(gmsReplace(R, '+ ', '+'));
  R := gmsTrim(gmsReplace(R, ' +', '+'));
  R := gmsTrim(gmsReplace(R, '- ', '-'));
  R := gmsTrim(gmsReplace(R, ' -', '-'));
  R := gmsTrim(gmsReplace(R, '* ', '*'));
  R := gmsTrim(gmsReplace(R, ' *', '*'));
  R := gmsTrim(gmsReplace(R, '/ ', '/'));
  R := gmsTrim(gmsReplace(R, ' /', '/'));

LastProc:
  Result := R;
end;

//분리하기5[' ']
function TASMFrm.fsGet_ASM_Separate5(sStr: String): String;
var
  P: Integer;
label
  LastProc;
begin
  GsASM1 := ''; GsASM2 := ''; GsASM3 := ''; GsASM4 := ''; GsASM5 := ''; GsASMx := '';

  sStr := gmsTrim(sStr); if (sStr = '') then goto LastProc;
  P := gmiInStr(1, sStr, ' ');
  if (P = 0) then
    begin
      gsASM1 := sStr;
    end
  else
    begin
      gsASM1 := gmsTrim(gmsLeft(sStr, P));
      sStr := gmsTrim(gmsMid(sStr, P)); if (sStr = '') then goto LastProc;
      P := gmiInStr(1, sStr, ' ');
      if (P = 0) then
        begin
          gsASM2 := sStr;
        end
      else
        begin
          gsASM2 := gmsTrim(gmsLeft(sStr, P));
          sStr := gmsTrim(gmsMid(sStr, P)); if (sStr = '') then goto LastProc;
          P := gmiInStr(1, sStr, ' ');
          if (P = 0) then
            begin
              gsASM3 := sStr;
            end
          else
            begin
              gsASM3 := gmsTrim(gmsLeft(sStr, P));
              sStr := gmsTrim(gmsMid(sStr, P)); if (sStr = '') then goto LastProc;
              P := gmiInStr(1, sStr, ' ');
              if (P = 0) then
                begin
                  gsASM4 := sStr
                end
              else
                begin
                  gsASM4 := gmsTrim(gmsLeft(sStr, P));
                  sStr := gmsTrim(gmsMid(sStr, P)); if (sStr = '') then goto LastProc;
                  P := gmiInStr(1, sStr, ' ');
                  if (P = 0) then
                    begin
                      gsASM5 := sStr;
                    end
                  else
                    begin
                      gsASM5 := gmsTrim(gmsLeft(sStr, P));
                      gsASMx := gmsTrim(gmsReplace(gmsMid(sStr, P), ' ', ''));
                    end;
                end;
            end;
        end;
    end;

LastProc:
  Result := GsASM1 + ' ' + GsASM2 + ' ' + GsASM3 + ' ' + GsASM4 + ' ' + GsASM5 + ' ' + GsASMx;
end;

function TASMFrm.fsGet_ASM_Del_Comment(sStr: String): String;
var
  R: String;
  i, K: Integer; C: String;
label
  LastProc;
begin
  R := '';

  K := 0;
  for i := 1 to gmiLen(sStr) do
    begin
      C := gmsMid(sStr, i, 1);
      If (C = '''') then
        begin
          K := K + 1;
          if (K = 2) then K := 0;
        end;
      if ((C = ';') And (K = 0)) then
        begin
          R := gmsLeft(sStr, i - 1);
          goto LastProc;
        end;
    end;

  R := sStr;

LastProc:
  Result := R;
end;

function TASMFrm.fsLoadRunCmd_Dump: String;
var
  TxtFile: TextFile;
  R: String;
  i, K: Integer; Tr, T, S: String;
  StartNo: LongInt; StChk: String; oAddr: LongInt; iVal: Integer;
label
  ReadProc, NextProc, CloseProc, LastProc;
begin
  R := '';

  StartNo := goGetHex16ToLng(LoadStartTxt.Text);
  StChk := gmsTrim(LoadStartTxt.Text);

  AssignFile(TxtFile, gmsTrim(LoadFileTxt.Text));
  Reset(TxtFile); //파일없으면오류발생

ReadProc:
  ReadLn(TxtFile, Tr);

  if (gmsTrim(Tr) = '') then goto NextProc;
  If (gmsMid(Tr, 5, 1) <> ':') then goto NextProc;

  if (StChk = '') then StartNo := goGetHex16ToLng(gmsLeft(Tr, 4));

  if (LoadType2Opt.Checked = True) then
    begin
      Tr := gmsMid(Tr, 7); Tr := gmsLeft(Tr, 48); Tr := gmsReplace(Tr, ' ', '');
      for i := 1 To 16 do
        begin
          S := gmsTrim(gmsMid(Tr, (i * 2) - 1, 2));
          if (S <> '') then
            begin
              if (StChk = '') then
                oAddr := StartNo + i - 1
              else
                oAddr := StartNo
              ;
              iVal := giGetHex8ToInt(S);
              gt_PUT_MSX_MEMORY(oAddr, iVal);
              T := fsGetDumpLine(oAddr, iVal);
              if (T <> '') then R := R + T + vbCrLf;
              if (StChk <> '') then StartNo := StartNo + 1;
            end;
        end;
    end
  else
    begin
      Tr := gmsMid(Tr, 7); K := gmiInStr(1, Tr, ' '); if (K > 0) then Tr := gmsLeft(Tr, K - 1);
      for i := 1 to (K div 2) do
        begin
          S := gmsTrim(gmsMid(Tr, (i * 2) - 1, 2));
          if (S <> '') then
            begin
              if (StChk = '') then
                oAddr := StartNo + i - 1
              else
                oAddr := StartNo
              ;
              iVal := giGetHex8ToInt(S);
              gt_PUT_MSX_MEMORY(oAddr, iVal);
              T := fsGetDumpLine(oAddr, iVal);
              if (T <> '') then R := R + T + vbCrLf;
              if (StChk <> '') then StartNo := StartNo + 1;
            end;
        end;
    end;

NextProc:
  if (Eof(TxtFile)) then goto CloseProc;
  goto ReadProc;

CloseProc:
  CloseFile(TxtFile);

  T := fsGetDumpLine(-1, 0);
  if (T <> '') then R := R + T + vbCrLf;

LastProc:
  Result := R;
end;

function TASMFrm.fsGetDumpLine(oAddr: LongInt; iVal:Integer): String;
var
  R: String;
label
  NextProc, LastProc;
begin
  R := '';

  if (oAddr = -1) then
    begin
      if (fiDumpCont = 0) then
        goto LastProc
      else
        goto NextProc
      ;
    end;

  fiDumpCont := fiDumpCont + 1;

  if (fiDumpCont = 1) then fsDumpAddr := gsGetLngToHex16(oAddr) + ': ';

  fsDumpData := fsDumpData + gsGetLngToHex8(iVal) + ' ';
  if (iVal >= 32) And (iVal < 126) Then
    fsDumpText := fsDumpText + gmsChr(iVal)
  else
    fsDumpText := fsDumpText + '.'
  ;

NextProc:
  if ((fiDumpCont = 16) Or (oAddr = -1)) then
    begin
      R := fsDumpAddr + gmsLeft(fsDumpData + gmsSpace(48), 48) + ' ' + gmsLeft(fsDumpText + gmsSpace(16), 16) + '  ' + fsGetCheckSum(fsDumpData) + gmsIfThen(gsGetLngToHex16_Cry <> '0', '  ' + gsGetLngToHex16_Cry, '');
      fiDumpCont := 0;
      fsDumpAddr := '';
      fsDumpData := '';
      fsDumpText := '';
    end;

LastProc:
  Result := R;
end;

function TASMFrm.fsGetCheckSum(sStr: String): String;
var
  R: String;
  oTot: LongInt; i: Integer;
label
  LastProc;
begin
  R := '';

  sStr := gmsReplace(sStr, ' ', '');
  if (sStr = '') then goto LastProc;

  oTot := 0;
  for i := 1 to (gmiLen(sStr) div 2) do oTot := oTot + giGetHex8ToInt(gmsMid(sStr, (i * 2) - 1, 2));

  R := gsGetLngToHex8(oTot);

LastProc:
  Result := R;
end;

end.

