unit frmCalculate;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, Windows;

type

  { TCalculateFrm }

  TCalculateFrm = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    NumBsBtn: TButton;
    Num5Btn: TButton;
    Num6Btn: TButton;
    NumMulBtn: TButton;
    Num1Btn: TButton;
    Num2Btn: TButton;
    Num3Btn: TButton;
    NumSubBtn: TButton;
    Num0Btn: TButton;
    NumSgnBtn: TButton;
    NumDotBtn: TButton;
    NumClsBtn: TButton;
    NumAddBtn: TButton;
    NumEqualBtn: TButton;
    NumAllClsBtn: TButton;
    NumPerBtn: TButton;
    Num7Btn: TButton;
    Num8Btn: TButton;
    Num9Btn: TButton;
    NumDivBtn: TButton;
    Num4Btn: TButton;
    NumAutoChk: TCheckBox;
    NumTotTxt: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure NumEqualBtnClick(Sender: TObject);
    procedure NumAllClsBtnClick(Sender: TObject);
    procedure NumClsBtnClick(Sender: TObject);
    procedure NumBsBtnClick(Sender: TObject);
    procedure NumAddBtnClick(Sender: TObject);
    procedure NumSubBtnClick(Sender: TObject);
    procedure NumMulBtnClick(Sender: TObject);
    procedure NumDivBtnClick(Sender: TObject);
    procedure NumPerBtnClick(Sender: TObject);
    procedure NumSgnBtnClick(Sender: TObject);
    procedure NumDotBtnClick(Sender: TObject);
    procedure Num0BtnClick(Sender: TObject);
    procedure Num1BtnClick(Sender: TObject);
    procedure Num2BtnClick(Sender: TObject);
    procedure Num3BtnClick(Sender: TObject);
    procedure Num4BtnClick(Sender: TObject);
    procedure Num5BtnClick(Sender: TObject);
    procedure Num6BtnClick(Sender: TObject);
    procedure Num7BtnClick(Sender: TObject);
    procedure Num8BtnClick(Sender: TObject);
    procedure Num9BtnClick(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: char);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    procedure ftFormClose();
    procedure ftClearTextAll();
    procedure ftMoveChrToText(S: String);
    procedure ComputeTotRtn();
  public

  end;

var
  CalculateFrm: TCalculateFrm;

implementation

{$R *.lfm}

{ TCalculateFrm }

uses
  untValues, untStrings;

procedure TCalculateFrm.FormCreate(Sender: TObject);
begin
  //
end;

procedure TCalculateFrm.FormShow(Sender: TObject);
begin
  Memo1.Text := '';
  NumTotTxt.Text := '';
end;

procedure TCalculateFrm.FormActivate(Sender: TObject);
begin
  Memo1.SetFocus();
end;

procedure TCalculateFrm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  //
end;

procedure TCalculateFrm.ftFormClose();
begin
  Close();
end;

procedure TCalculateFrm.NumEqualBtnClick(Sender: TObject);
begin
  ComputeTotRtn();
  Memo1.SetFocus();
end;

procedure TCalculateFrm.NumAllClsBtnClick(Sender: TObject);
begin
  ftClearTextAll();
end;

procedure TCalculateFrm.NumClsBtnClick(Sender: TObject);
begin
  ftClearTextAll();
end;

procedure TCalculateFrm.ftClearTextAll();
begin
  Memo1.Text := '';
  NumTotTxt.Text := '';
  Memo1.SetFocus();
end;

procedure TCalculateFrm.NumBsBtnClick(Sender: TObject);
begin
  Memo1.SetFocus();
  Keybd_Event(8, 8, 0, 0); //8:BS, WinAPI(Keybd_Event, Mouse_Event, ... )
end;

procedure TCalculateFrm.NumAddBtnClick(Sender: TObject);
begin
  ComputeTotRtn();
  Memo1.SetFocus();
end;

procedure TCalculateFrm.NumSubBtnClick(Sender: TObject);
begin
  ComputeTotRtn();
  ftMoveChrToText('-');
end;

procedure TCalculateFrm.NumMulBtnClick(Sender: TObject);
begin
  ComputeTotRtn();
  ftMoveChrToText('*');
end;

procedure TCalculateFrm.NumDivBtnClick(Sender: TObject);
begin
  ComputeTotRtn();
  ftMoveChrToText('/');
end;

procedure TCalculateFrm.NumPerBtnClick(Sender: TObject);
begin
  ftMoveChrToText('%');
end;

procedure TCalculateFrm.NumSgnBtnClick(Sender: TObject);
begin
  ftMoveChrToText('-');
end;

procedure TCalculateFrm.NumDotBtnClick(Sender: TObject);
begin
  ftMoveChrToText('.');
end;

procedure TCalculateFrm.Num0BtnClick(Sender: TObject);
begin
  ftMoveChrToText('0');
end;

procedure TCalculateFrm.Num1BtnClick(Sender: TObject);
begin
  ftMoveChrToText('1');
end;

procedure TCalculateFrm.Num2BtnClick(Sender: TObject);
begin
  ftMoveChrToText('2');
end;

procedure TCalculateFrm.Num3BtnClick(Sender: TObject);
begin
  ftMoveChrToText('3');
end;

procedure TCalculateFrm.Num4BtnClick(Sender: TObject);
begin
  ftMoveChrToText('4');
end;

procedure TCalculateFrm.Num5BtnClick(Sender: TObject);
begin
  ftMoveChrToText('5');
end;

procedure TCalculateFrm.Num6BtnClick(Sender: TObject);
begin
  ftMoveChrToText('6');
end;

procedure TCalculateFrm.Num7BtnClick(Sender: TObject);
begin
  ftMoveChrToText('7');
end;

procedure TCalculateFrm.Num8BtnClick(Sender: TObject);
begin
  ftMoveChrToText('8');
end;

procedure TCalculateFrm.Num9BtnClick(Sender: TObject);
begin
  ftMoveChrToText('9');
end;

procedure TCalculateFrm.ftMoveChrToText(S: String);
begin
  Memo1.Text := Memo1.Text + S;

  Memo1.SelStart := giLen(Memo1.Text);
  Memo1.SelLength := 0;
  Memo1.SetFocus();
end;

procedure TCalculateFrm.Memo1KeyPress(Sender: TObject; var Key: char);
begin
  if (Key = '=') then ComputeTotRtn();
end;

procedure TCalculateFrm.Memo1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_ESCAPE) then ftFormClose();
  if (Key = VK_RETURN) then
    begin
      if (NumAutoChk.Checked = False) then ComputeTotRtn();
    end;
  if (Key = VK_F1) then
    begin
      if (NumAutoChk.Checked = False) then
        NumAutoChk.Checked := True
      else
        NumAutoChk.Checked := False
      ;
    end;
  if (Key = VK_F4) then ftClearTextAll();
end;

procedure TCalculateFrm.ComputeTotRtn();
var
  Txt, S, T, X: String;
  Hab, Gum: Currency;
  C: Integer;
  j: Integer;
label
  ExitProc;
begin
  NumTotTxt.Text := '';

  T := gsTrim(Memo1.Text);
  C :=  giSplitString(T, gsChr(13), 1); //Lf = "\n"
  if (C = 0) then goto ExitProc;

  Hab := 0; Txt := '';
  for j := 1 to C do
    begin
      S := gsTrim(GsSplitStr1[j]);
      S := gsReplace(S, gsChr(13), '');
      Gum := gcStrToCur122(S);
      X := gsLeft(S, 1);
      if ((X = '*') Or (X = '/')) then
        begin
          if (X = '*') then Hab := gcMul(Hab, Gum);
          if (X = '/') then Hab := gcDiv(Hab, Gum);
        end
      else
        begin
          if (gsRight(S, 1) <> '%') then
            Hab := Hab + Gum
          else
            Hab := Hab + (gcDiv(gcMul(Hab, Gum), 100))
          ;
        end;
      if (Gum <> 0) then
        begin
          if ((X = '*') Or (X = '/')) then
            begin
              Txt := Txt + X + gsSpc(3) + gsCurToStr122(Gum) + gsChr(13); //"\r\n"
            end
          else
            begin
              if (gsRight(S, 1) <> '%') then
                Txt := Txt + gsCurToStr122(Gum) + gsChr(13)
              else
                Txt := Txt + gsCurToStr122(Gum) + '%' + gsChr(13)
              ;
            end;
        end;
    end;

  Memo1.Text := Txt;
  NumTotTxt.Text := gsCurToStr122(Hab) + gsSpc(3);

  Memo1.SelStart := giLen(Memo1.Text);
  Memo1.SelLength := 0;

ExitProc:
end;

end.

