unit frmDskManager;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, ExtCtrls, Grids,
  StdCtrls, Types, Windows;

type

  { TDskManagerFrm }

  TDskManagerFrm = class(TForm)
    DiskBCreateCmd: TButton;
    Ren1Cmd: TButton;
    In1Cmd: TButton;
    Out1Cmd: TButton;
    Ren2Cmd: TButton;
    In2Cmd: TButton;
    Out2Cmd: TButton;
    SaveOkCmd: TButton;
    SaveCancelCmd: TButton;
    FileNameTxt: TEdit;
    SaveFme: TGroupBox;
    Panel1: TPanel;
    Copy1Cmd: TButton;
    Del1Cmd: TButton;
    Copy2Cmd: TButton;
    Del2Cmd: TButton;
    DiskCopyCmd: TButton;
    ChtExitCmd: TButton;
    FileNameBtn: TButton;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    procedure ChtExitCmdClick(Sender: TObject);
    procedure Copy1CmdClick(Sender: TObject);
    procedure Copy2CmdClick(Sender: TObject);
    procedure Del1CmdClick(Sender: TObject);
    procedure Del2CmdClick(Sender: TObject);
    procedure DiskBCreateCmdClick(Sender: TObject);
    procedure DiskCopyCmdClick(Sender: TObject);
    procedure FileNameBtnClick(Sender: TObject);
    procedure FileNameTxtEnter(Sender: TObject);
    procedure FileNameTxtExit(Sender: TObject);
    procedure FileNameTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure In1CmdClick(Sender: TObject);
    procedure In2CmdClick(Sender: TObject);
    procedure Out1CmdClick(Sender: TObject);
    procedure Out2CmdClick(Sender: TObject);
    procedure Ren1CmdClick(Sender: TObject);
    procedure Ren2CmdClick(Sender: TObject);
    procedure SaveCancelCmdClick(Sender: TObject);
    procedure SaveOkCmdClick(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; aCol, aRow: Integer; aRect: TRect; aState: TGridDrawState);
    procedure StringGrid1Enter(Sender: TObject);
    procedure StringGrid1PrepareCanvas(Sender: TObject; aCol, aRow: Integer; aState: TGridDrawState);
    procedure StringGrid2DrawCell(Sender: TObject; aCol, aRow: Integer; aRect: TRect; aState: TGridDrawState);
    procedure StringGrid2Enter(Sender: TObject);
    procedure StringGrid2PrepareCanvas(Sender: TObject; aCol, aRow: Integer; aState: TGridDrawState);
  private
    procedure ftButtonEnableRtn;
    function fsGetSeltName: String;
    function fbFileNameIsDisk(iDisk: Integer; fName: String): Boolean;
    function fsGetFileName(fName:String): String;
    function fsGetFileName2(fName: String): String;
    function fsGetMsxFileName(fName: String): String;
    function fsGetMsxFileChar(C: String): String;
    procedure ftMsxDiskFileCopy;
    procedure ftMsxDiskFileRename;
    procedure ftMsxDiskFileDelete;
    procedure ftMsxDiskFileIn;
    procedure ftMsxDiskFileOut;
    procedure ftDisplayDataRtn(iDisk: Integer);
    procedure ftDisplayFileName(iSheet: Integer; fName: String; fSize: String; fDate: String; fAttrib: String; fPos: String; fCluster: String);
  public

  end;

var
  DskManagerFrm: TDskManagerFrm;

implementation

{$R *.lfm}

{ TDskManagerFrm }
uses
  msxMSX, msxFDC,
  untFunction;

var
  fiFirstRun: Integer = 0;

  fs_DSK_A_FILE_bak: String;
  fs_DSK_B_FILE_bak: String;

  MyTextStyle: TTextStyle;

  wrkBuffer: Array[0..32-1] Of Integer; //[0~31]
  wrkFAT12Entry: Array[0..714-1] Of Integer; //[0~713]

  foDiskAfree: LongInt;
  foDiskBfree: LongInt;
  fiDiskAcnt: Integer;
  fiDiskBcnt: Integer;

  fiDisk, fiDisk2: Integer;
  fiWork: Integer;

  fsFileName: String;
  fsSeltName: String;
  fsWriteName: String;

  foSze: LongInt;
  fiLba: Integer;
  fiPos: Integer;
  fiClt: Integer;

  fiLbaAnull: Integer;
  fiPosAnull: Integer;
  fiLbaBnull: Integer;
  fiPosBnull: Integer;

procedure TDskManagerFrm.FormCreate(Sender: TObject);
begin
  StringGrid1.Options := StringGrid1.Options + [goRowSelect];
  StringGrid1.Options := StringGrid1.Options + [goColSizing];
  StringGrid1.SelectedColor := clSilver;

  MyTextStyle := StringGrid1.DefaultTextStyle;
  MyTextStyle.Alignment := taCenter; //taLeftJustify, taRightJustify
  StringGrid1.DefaultTextStyle := MyTextStyle;

  StringGrid2.Options := StringGrid1.Options + [goRowSelect];
  StringGrid2.Options := StringGrid1.Options + [goColSizing];
  StringGrid2.SelectedColor := clSilver;

  MyTextStyle := StringGrid2.DefaultTextStyle;
  MyTextStyle.Alignment := taCenter; //taLeftJustify, taRightJustify
  StringGrid2.DefaultTextStyle := MyTextStyle;
end;

procedure TDskManagerFrm.FormShow(Sender: TObject);
begin
  fiFirstRun := 0;

  fs_DSK_A_FILE_bak := Gs_DSK_A_FILE; Gs_DSK_A_FILE := Gs_DSK_A_IsFn;
  fs_DSK_B_FILE_bak := Gs_DSK_B_FILE; Gs_DSK_B_FILE := Gs_DSK_B_IsFn;

  ChtExitCmd.SetFocus;
  ftButtonEnableRtn;

  Screen.Cursor := crHourGlass; //마우스(모래시계)

  StringGrid1.RowCount := 1;
  StringGrid1.RowCount := 50;
  StringGrid2.RowCount := 1;
  StringGrid2.RowCount := 50;

  if (Gi_DSK_A_IsOk = 1) then ftDisplayDataRtn(1);
  if (Gi_DSK_B_IsOk = 1) then ftDisplayDataRtn(2);

  Screen.Cursor := crDefault; //마우스(정상)
end;

procedure TDskManagerFrm.FormActivate(Sender: TObject);
begin
  if (fiFirstRun = 0) then
    begin
      fiFirstRun := 1;

    end;
end;

procedure TDskManagerFrm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  if (fiFirstRun = 1) then
    begin
      Gs_DSK_A_FILE := fs_DSK_A_FILE_bak;
      Gs_DSK_B_FILE := fs_DSK_B_FILE_bak;
    end;
end;

procedure TDskManagerFrm.ChtExitCmdClick(Sender: TObject);
begin
  Close;
end;

procedure TDskManagerFrm.ftButtonEnableRtn;
begin
  Copy1Cmd.Enabled := True;
  Ren1Cmd.Enabled := True;
  Del1Cmd.Enabled := True;
  In1Cmd.Enabled := True;
  Out1Cmd.Enabled := True;
  if (Gi_DSK_A_IsOk = 0) then
    begin
      Copy1Cmd.Enabled := False;
      Copy2Cmd.Enabled := False;
      Ren1Cmd.Enabled := False;
      Del1Cmd.Enabled := False;
      In1Cmd.Enabled := False;
      Out1Cmd.Enabled := False;
    end;

  Copy2Cmd.Enabled := True;
  Ren2Cmd.Enabled := True;
  Del2Cmd.Enabled := True;
  In2Cmd.Enabled := True;
  Out2Cmd.Enabled := True;
  if (Gi_DSK_B_IsOk = 0) then
    begin
      Copy2Cmd.Enabled := False;
      Copy1Cmd.Enabled := False;
      Ren2Cmd.Enabled := False;
      Del2Cmd.Enabled := False;
      In2Cmd.Enabled := False;
      Out2Cmd.Enabled := False;
    end;
end;

procedure TDskManagerFrm.DiskCopyCmdClick(Sender: TObject);
var
  TxtFile: TextFile;
label
  LastProc;
begin
  if (Gs_DSK_A_IsFn = '') then goto LastProc;
  if (Gs_DSK_B_IsFn = '') then goto LastProc;

  if (MessageDlg('* Disk A 을 Disk B 로 복사할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  ChtExitCmd.SetFocus;
  DiskCopyCmd.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  Try
    Try
      AssignFile(TxtFile, Gs_DSK_B_IsFn); //파일생성
      ReWrite(TxtFile);
      CloseFile(TxtFile);

      gt_Disk_Copy_A_to_B; //2DD-720KB

      Gi_DSK_B_IsOk := 1;
      ftButtonEnableRtn;

      ftDisplayDataRtn(2);
    Except
    End;
  Finally
  End;

  DiskCopyCmd.Enabled := True;
  DiskCopyCmd.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

LastProc:
end;

procedure TDskManagerFrm.DiskBCreateCmdClick(Sender: TObject);
var
  TxtFile: TextFile;
label
  LastProc;
begin
  if (Gs_DSK_B_IsFn = '') then goto LastProc;
  if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_B_IsFn) = True) then goto LastProc;

  if (MessageDlg('* Disk B 를 생성할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  ChtExitCmd.SetFocus;
  DiskBCreateCmd.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  Try
    Try
      AssignFile(TxtFile, Gs_DSK_B_IsFn); //파일생성
      ReWrite(TxtFile);
      CloseFile(TxtFile);

      gt_Disk_B_Create; //2DD-720KB

      Gi_DSK_B_IsOk := 1;
      ftButtonEnableRtn;

      ftDisplayDataRtn(2);
    Except
    End;
  Finally
  End;

  DiskBCreateCmd.Enabled := True;
  DiskBCreateCmd.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

LastProc:
end;

procedure TDskManagerFrm.Copy1CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  if (fiDiskBcnt = 112) then
    begin
      MessageDlg(Self.Caption, '* Disk B full [112] !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  fiDisk := 1; fiDisk2 := 2;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 Disk B 로 복사할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  if (fbFileNameIsDisk(2, fsSeltName) = True) then
    begin
      MessageDlg(Self.Caption, '* 파일명 중복 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  if (foSze > foDiskBfree) then
    begin
      MessageDlg(Self.Caption, '* 저장 공간 부족 !', mtError, [mbOK], 0);
      GoTo LastProc;
    end;

  ftMsxDiskFileCopy;

LastProc:
end;

procedure TDskManagerFrm.Ren1CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 1;
  fiWork := 1;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  SaveFme.Caption := 'Disk A 파일명 변경';
  FileNameTxt.Text := fsSeltName;
  SaveFme.Visible := True;
  FileNameTxt.SetFocus;

LastProc:
end;

procedure TDskManagerFrm.Del1CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 1;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 삭제할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  ftMsxDiskFileDelete;

LastProc:
end;

procedure TDskManagerFrm.In1CmdClick(Sender: TObject);
var
  Dlg: TOpenDialog;
label
  LastProc;
begin
  SaveFme.Visible := False;

  if (fiDiskAcnt = 112) then
    begin
      MessageDlg(Self.Caption, '* Disk A full [112] !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일 (*.*)|*.*|BAS 파일|*.BAS|ROM 파일|*.ROM|BIN 파일|*.BIN|COM 파일|*.COM|SYS 파일|*.SYS';

  if (Dlg.Execute) then fsFileName := Dlg.FileName;

  fiDisk := 1;
  fiWork := 2;

  if (fsFileName <> '') then
    begin
      SaveFme.Caption := 'Disk A 파일 불러오기';
      FileNameTxt.Text := fsGetMsxFileName(fsGetFileName(fsFileName));
      SaveFme.Visible := True;
      FileNameTxt.SetFocus;
    end;

LastProc:
end;

procedure TDskManagerFrm.Out1CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 1;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 [C:\]로 복사할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  fsWriteName := 'C:\' + fsSeltName;
  if (gb_MSX_DSK_FILE_EXIST(fsWriteName) = True) then
    begin
      MessageDlg(Self.Caption, '* 파일명 중복 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  ftMsxDiskFileOut;

LastProc:
end;

procedure TDskManagerFrm.Copy2CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  if (fiDiskAcnt = 112) then
    begin
      MessageDlg(Self.Caption, '* Disk A full [112] !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  fiDisk := 2; fiDisk2 := 1;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 Disk A 로 복사할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  if (fbFileNameIsDisk(1, fsSeltName) = True) then
    begin
      MessageDlg(Self.Caption, '* 파일명 중복 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  if (foSze > foDiskAfree) then
    begin
      MessageDlg(Self.Caption, '* 저장 공간 부족 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  ftMsxDiskFileCopy;

LastProc:
end;

procedure TDskManagerFrm.Ren2CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 2;
  fiWork := 1;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  SaveFme.Caption := 'Disk B 파일명 변경';
  FileNameTxt.Text := fsSeltName;
  SaveFme.Visible := True;
  FileNameTxt.SetFocus;

LastProc:
end;

procedure TDskManagerFrm.Del2CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 2;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 삭제할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  ftMsxDiskFileDelete;

LastProc:
end;

procedure TDskManagerFrm.In2CmdClick(Sender: TObject);
var
  Dlg: TOpenDialog;
label
  LastProc;
begin
  SaveFme.Visible := False;

  if (fiDiskBcnt = 112) then
    begin
      MessageDlg(Self.Caption, '* Disk B full [112] !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일 (*.*)|*.*|BAS 파일|*.BAS|ROM 파일|*.ROM|BIN 파일|*.BIN|COM 파일|*.COM|SYS 파일|*.SYS';

  if (Dlg.Execute) then fsFileName := Dlg.FileName;

  fiDisk := 2;
  fiWork := 2;

  if (fsFileName <> '') then
    begin
      SaveFme.Caption := 'Disk B 파일 불러오기';
      FileNameTxt.Text := fsGetMsxFileName(fsGetFileName(fsFileName));
      SaveFme.Visible := True;
      FileNameTxt.SetFocus;
    end;

LastProc:
end;

procedure TDskManagerFrm.Out2CmdClick(Sender: TObject);
label
  LastProc;
begin
  SaveFme.Visible := False;

  fiDisk := 2;

  fsSeltName := fsGetSeltName;
  if (fsSeltName = '') then goto LastProc;

  if (MessageDlg('* 파일[' + fsSeltName + ']을 [C:\]로 복사할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  fsWriteName := 'C:\' + fsSeltName;
  if (gb_MSX_DSK_FILE_EXIST(fsWriteName) = True) then
    begin
      MessageDlg(Self.Caption, '* 파일명 중복 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  ftMsxDiskFileOut;

LastProc:
end;

procedure TDskManagerFrm.StringGrid1Enter(Sender: TObject);
begin
  SaveFme.Visible := False;
end;

procedure TDskManagerFrm.StringGrid1PrepareCanvas(Sender: TObject; aCol, aRow: Integer; aState: TGridDrawState);
var
  MyTextStyle: TTextStyle;
begin
  if ((aRow >= 1) And (aCol >= 1)) then
    begin
      MyTextStyle := StringGrid1.Canvas.TextStyle;
      MyTextStyle.Alignment := taCenter;
      if ((aCol = 1) Or (aCol = 3)) then MyTextStyle.Alignment := taLeftJustify;
      if (aCol = 2) then MyTextStyle.Alignment := taRightJustify;
      StringGrid1.Canvas.TextStyle := MyTextStyle;
    end;
end;

procedure TDskManagerFrm.StringGrid1DrawCell(Sender: TObject; aCol, aRow: Integer; aRect: TRect; aState: TGridDrawState);
var
  SavedAlign: Word;
label
  ExitProc;
begin
  if ((aRow < 1) Or (aCol < 1)) then goto ExitProc;

  with TStringGrid(Sender) do
    begin
      if (gmsTrim(Cells[1, ARow]) = '*Total Size') then
        begin
          Canvas.Font.Color := clRed;
          Canvas.Brush.Color := clYellow;
          if (aCol = 1) then
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_LEFT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Left+2, aRect.Top+2, Cells[ACol, ARow]); //좌측정렬
            end
          else
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_RIGHT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Right-4, aRect.Top+2, Cells[ACol, ARow]); //우측정렬
            end;
        end;
      if (gmsTrim(Cells[1, ARow]) = '*Free  Size') then
        begin
          Canvas.Font.Color := clBlue;
          Canvas.Brush.Color := clWhite;
          if (aCol = 1) then
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_LEFT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Left+2, aRect.Top+2, Cells[ACol, ARow]); //좌측정렬
            end
          else
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_RIGHT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Right-4, aRect.Top+2, Cells[ACol, ARow]); //우측정렬
            end;
        end;
    end;

ExitProc:
end;

procedure TDskManagerFrm.StringGrid2Enter(Sender: TObject);
begin
  SaveFme.Visible := False;
end;

procedure TDskManagerFrm.StringGrid2PrepareCanvas(Sender: TObject; aCol, aRow: Integer; aState: TGridDrawState);
var
  MyTextStyle: TTextStyle;
begin
  if ((aRow >= 1) And (aCol >= 1)) then
    begin
      MyTextStyle := StringGrid2.Canvas.TextStyle;
      MyTextStyle.Alignment := taCenter;
      if ((aCol = 1) Or (aCol = 3)) then MyTextStyle.Alignment := taLeftJustify;
      if (aCol = 2) then MyTextStyle.Alignment := taRightJustify;
      StringGrid2.Canvas.TextStyle := MyTextStyle;
    end;
end;

procedure TDskManagerFrm.StringGrid2DrawCell(Sender: TObject; aCol, aRow: Integer; aRect: TRect; aState: TGridDrawState);
var
  SavedAlign: Word;
label
  ExitProc;
begin
  if ((aRow < 1) Or (aCol < 1)) then goto ExitProc;

  with TStringGrid(Sender) do
    begin
      if (gmsTrim(Cells[1, ARow]) = '*Total Size') then
        begin
          Canvas.Font.Color := clRed;
          Canvas.Brush.Color := clYellow;
          if (aCol = 1) then
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_LEFT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Left+2, aRect.Top+2, Cells[ACol, ARow]); //좌측정렬
            end
          else
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_RIGHT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Right-4, aRect.Top+2, Cells[ACol, ARow]); //우측정렬
            end;
        end;
      if (gmsTrim(Cells[1, ARow]) = '*Free  Size') then
        begin
          Canvas.Font.Color := clBlue;
          Canvas.Brush.Color := clWhite;
          if (aCol = 1) then
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_LEFT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Left+2, aRect.Top+2, Cells[ACol, ARow]); //좌측정렬
            end
          else
            begin
              SavedAlign := SetTextAlign(Canvas.Handle, TA_RIGHT); //Left,Right,Center - 없으면선택셀색상흐려짐
              Canvas.FillRect(aRect);
              Canvas.TextOut(aRect.Right-4, aRect.Top+2, Cells[ACol, ARow]); //우측정렬
            end;
        end;
    end;

ExitProc:
end;

procedure TDskManagerFrm.SaveOkCmdClick(Sender: TObject);
label
  LastProc;
begin
  if (fsWriteName = '') then goto LastProc;

  if (fbFileNameIsDisk(fiDisk, fsWriteName) = True) then
    begin
      MessageDlg(Self.Caption, '* 파일명 중복 !', mtError, [mbOK], 0);
      goto LastProc;
    end;

  if (fiWork = 1) then ftMsxDiskFileRename;
  if (fiWork = 2) then ftMsxDiskFileIn;

  SaveFme.Visible := False;

LastProc:
end;

procedure TDskManagerFrm.SaveCancelCmdClick(Sender: TObject);
begin
  SaveFme.Visible := False;
end;

procedure TDskManagerFrm.FileNameBtnClick(Sender: TObject);
begin
  //
end;

procedure TDskManagerFrm.FileNameTxtEnter(Sender: TObject);
begin
  FileNameTxt.Color := clYellow;
end;

procedure TDskManagerFrm.FileNameTxtKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_ESCAPE) then SaveCancelCmd.SetFocus;
  if (Key = VK_RETURN) then SaveOkCmd.SetFocus;
end;

procedure TDskManagerFrm.FileNameTxtExit(Sender: TObject);
begin
  FileNameTxt.Color := clWhite;

  fsWriteName := fsGetMsxFileName(FileNameTxt.Text);
  FileNameTxt.Text := fsWriteName;
end;

function TDskManagerFrm.fsGetSeltName: String;
var
  R: String;
  Rw1: LongInt; S, S1, S2, S3, S4, S5: String;
label
  LastProc;
begin
  R := '';

  if (fiDisk = 1) then
    begin
      Rw1 := StringGrid1.Row;
      if (Rw1 < 1) then goto LastProc;
      S := StringGrid1.Cells[1, Rw1];
      S3 := StringGrid1.Cells[2, Rw1];
      S4 := StringGrid1.Cells[5, Rw1];
      S5 := StringGrid1.Cells[6, Rw1];
    end;

  if (fiDisk = 2) then
    begin
      Rw1 := StringGrid2.Row;
      if (Rw1 < 1) then goto LastProc;
      S := StringGrid2.Cells[1, Rw1];
      S3 := StringGrid2.Cells[2, Rw1];
      S4 := StringGrid2.Cells[5, Rw1];
      S5 := StringGrid2.Cells[6, Rw1];
    end;

  if (gmsTrim(S) = '') then goto LastProc;
  if (gmsLeft(S, 1) = '*') then goto LastProc;

  S1 := gmsTrim(gmsLeft(S, 8));
  S2 := gmsTrim(gmsRight(S, 3));

  if (S2 <> '') then
    R := S1 + '.' + S2
  else
    R := S1
  ;

  //MessageDlg(Self.Caption, R, mtError, [mbOK], 0);

  foSze := gmiVal(S3);
  fiLba := gmiVal(gmsLeft(S4, 1));
  fiPos := gmiVal(gmsRight(S4, 3));
  fiClt := gmiVal(S5);

LastProc:
  Result := R;
end;

function TDskManagerFrm.fbFileNameIsDisk(iDisk: Integer; fName: String): Boolean;
var
  R: Boolean;
  Rw: LongInt; i: Integer; S, S1, S2, SS: String;
label
  Next1Proc, Next2Proc, LastProc;
begin
  R := False;

  if (iDisk = 1) then
    begin
      Rw := StringGrid1.RowCount;
      if (Rw < (1 + 1)) then goto LastProc;
      for i := 1 to (Rw - 1) do
        begin
          S := StringGrid1.Cells[1, i];
          if (gmsTrim(S) = '') then goto Next1Proc;
          if (gmsLeft(S, 1) = '*') then goto Next1Proc;
          S1 := gmsTrim(gmsLeft(S, 8));
          S2 := gmsTrim(gmsRight(S, 3));
          if (S2 <> '') then
            SS := S1 + '.' + S2
          else
            SS := S1
          ;
          if (fName = SS) then
            begin
              R := True;
              goto LastProc;
            end;
Next1Proc:
        end;
    end;

  if (iDisk = 2) then
    begin
      Rw := StringGrid2.RowCount;
      if (Rw < (1 + 1)) then goto LastProc;
      for i := 1 to (Rw - 1) do
        begin
          S := StringGrid2.Cells[1, i];
          if (gmsTrim(S) = '') then goto Next2Proc;
          if (gmsLeft(S, 1) = '*') then goto Next2Proc;
          S1 := gmsTrim(gmsLeft(S, 8));
          S2 := gmsTrim(gmsRight(S, 3));
          if (S2 <> '') then
            SS := S1 + '.' + S2
          else
            SS := S1
          ;
          if (fName = SS) then
            begin
              R := True;
              goto LastProc;
            end;
Next2Proc:
        end;
    end;

LastProc:
  Result := R;
end;

function TDskManagerFrm.fsGetFileName(fName:String): String;
var
  R: String;
  P: Integer;
label
  LoopProc, LastProc;
begin
  R := '';

LoopProc:
  fName := gmsTrim(fName);
  if (fName = '') then goto LastProc;

  P := gmiInStr(1, fName, '\');
  if (P = 0) then
    begin
      R := fName;
    end
  else
    begin
      fName := gmsMid(fName, P + 1, 0);
      goto LoopProc;
    end;

LastProc:
  Result := R;
end;

function TDskManagerFrm.fsGetFileName2(fName: String): String;
var
  R: String;
  P: Integer;
begin
  R := '';

  P := gmiInStr(1, fName, '.');
  if (P > 0) then
    R := gmsLeft(gmsLeft(fName, P - 1) + Space(8), 8) + gmsLeft(gmsMid(fName, P + 1, 0) + Space(3), 3)
  else
    R := gmsLeft(fName + Space(11), 11)
  ;

  Result := R;
end;

function TDskManagerFrm.fsGetMsxFileName(fName: String): String;
var
  R: String;
  i, P: Integer;  C: String;
  T1, T2, S1, S2: String;
label
  LastProc;
begin
  R := '';

  fName := gmsTrim(gmsUpper(fName));
  if (fName = '') then goto LastProc;

  P := 0;
  for i := 1 to gmiLen(fName) do
    begin
      C := gmsMid(fName, i, 1);
      if (C = '.') then P := i;
    end;
  if (P = 1) then goto LastProc;

  if (P > 0) then
    begin
      S1 := gmsLeft(fName, P - 1);
      S2 := gmsMid(fName, P + 1, 0);
    end
  else
    begin
      S1 := fName;
      S2 := '';
    end;

  T1 := '';
  if (S1 <> '') then
    for i := 1 to gmiLen(S1) do
      begin
        C := gmsMid(S1, i, 1);
        T1 := T1 + fsGetMsxFileChar(C);
      end;
  T1 := gmsLeft(T1, 8);

  T2 := '';
  if (S2 <> '') then
    for i := 1 to gmiLen(S2) do
      begin
        C := gmsMid(S2, i, 1);
        T2 := T2 + fsGetMsxFileChar(C);
      end;
  T2 := gmsLeft(T2, 3);

  if (T1 = '') then goto LastProc;
  if (T2 <> '') then
    R := T1 + '.' + T2
  else
    R := T1
  ;

LastProc:
  Result := R;
end;

function TDskManagerFrm.fsGetMsxFileChar(C: String): String;
var
  R: String;
begin
  R := '';

  if ((C >= 'A') And (C <= 'Z')) then R := C;
  if ((C >= '0') And (C <= '9')) then R := C;
  if (C = '$') then R := C;
  if (C = '&') then R := C;
  if (C = '#') then R := C;
  if (C = '%') then R := C;
  if (C = '''') then R := C;
  if (C = '(') then R := C;
  if (C = ')') then R := C;
  if (C = '-') then R := C;
  if (C = '@') then R := C;
  if (C = '^') then R := C;
  if (C = '{') then R := C;
  if (C = '}') then R := C;
  if (C = '~') then R := C;
  if (C = '`') then R := C;
  if (C = '!') then R := C;
  if (C = '_') then R := C;

  Result := R;
end;

procedure TDskManagerFrm.ftMsxDiskFileCopy;
var
  i: Integer; F: Boolean; P, C: Integer;
  T, T2: Integer;
label
  LoopProc, SkipProc, NextProc, LastProc;
begin
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  T := -1;
  F := gb_READ_MSX_DSK_FAT12(fiDisk2);
  gt_MOVE_FAT12_TO_ENTRY;
  for i := 0 to (714 - 1) do
    begin
      wrkFAT12Entry[i] := dskFAT12Entry[i];
      if (i >= 2) then
        if ((T = -1) And (wrkFAT12Entry[i] = 0)) then T := i;
    end;

  F := gb_READ_MSX_DSK_FAT12(fiDisk);
  gt_MOVE_FAT12_TO_ENTRY;

  F := gb_READ_MSX_DSK_LBA(fiDisk, fiLba);
  for i := 0 to (32 - 1) do wrkBuffer[i] := dskBuffer[i + fiPos];
  wrkBuffer[26] := (T And $FF);
  wrkBuffer[27] := (T And $F00) div 256; //정수 - 나누기(div),몫(mod)

  F := gb_READ_MSX_DSK_LBA(fiDisk2, gmiIfThen(fiDisk2 = 1, fiLbaAnull, fiLbaBnull));
  for i := 0 to (32 - 1) do dskBuffer[i + gmiIfThen(fiDisk2 = 1, fiPosAnull, fiPosBnull)] := wrkBuffer[i];
  F := gb_WRITE_MSX_DSK_LBA(fiDisk2, gmiIfThen(fiDisk2 = 1, fiLbaAnull, fiLbaBnull));

  P := fiClt;
LoopProc:
  if ((P >= 2) And (P <= (714 - 1))) then
    begin
      F := gb_READ_MSX_DSK_CLUSTER(fiDisk, P);
      F := gb_WRITE_MSX_DSK_CLUSTER(fiDisk2, T);
      C := dskFAT12Entry[P];
      if ((C >= $FF8) And (C <= $FFF)) then
        begin
          wrkFAT12Entry[T] := C;
          goto NextProc;
        end;
      P := C;
      for i := (T + 1) to (714 - 1) do
        if (wrkFAT12Entry[i] = 0) then
          begin
            T2 := i;
            goto SkipProc;
          end;
SkipProc:
      wrkFAT12Entry[T] := T2;
      T := T2;
      goto LoopProc;
    end;

NextProc:
  for i := 0 to (714 - 1) do dskFAT12Entry[i] := wrkFAT12Entry[i];
  gt_MOVE_ENTRY_TO_FAT12;
  F := gb_WRITE_MSX_DSK_FAT12(fiDisk2);

  F := gb_MSX_DSK_COPY_FAT_TO_FAT2(fiDisk2);

  ftDisplayDataRtn(fiDisk2);

LastProc:
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents
end;

procedure TDskManagerFrm.ftMsxDiskFileRename;
var
  i: Integer; S: String; F: Boolean;
begin
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  S := fsGetFileName2(fsWriteName);
  F := gb_READ_MSX_DSK_LBA(fiDisk, fiLba);
  for i := 0 to 10 do dskBuffer[i + fiPos] := gmiAsc(gmsMid(S, i + 1, 1));
  F := gb_WRITE_MSX_DSK_LBA(fiDisk, fiLba);

  ftDisplayDataRtn(fiDisk);

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents
end;

procedure TDskManagerFrm.ftMsxDiskFileDelete;
var
  F: Boolean; P, C: Integer;
label
  LoopProc, SkipProc;
begin
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  F := gb_READ_MSX_DSK_FAT12(fiDisk);
  gt_MOVE_FAT12_TO_ENTRY;

  F := gb_READ_MSX_DSK_LBA(fiDisk, fiLba);
  dskBuffer[fiPos] := $E5;
  F := gb_WRITE_MSX_DSK_LBA(fiDisk, fiLba);

  P := fiClt;
LoopProc:
  if ((P >= 2) And (P <= (714 - 1))) then
    begin
      C := dskFAT12Entry[P];
      dskFAT12Entry[P] := 0;
      if ((C >= $FF8) And (C <= $FFF)) then goto SkipProc;
      P := C;
      goto LoopProc;
    end;

SkipProc:
  gt_MOVE_ENTRY_TO_FAT12;
  F := gb_WRITE_MSX_DSK_FAT12(fiDisk);

  F := gb_MSX_DSK_COPY_FAT_TO_FAT2(fiDisk);

  ftDisplayDataRtn(fiDisk);

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents
end;

procedure TDskManagerFrm.ftMsxDiskFileIn;
var
  FH: File Of Byte;
  i: Integer; L: LongInt; F: Boolean; T, T2: Integer;
  S: String; C: Byte; W: Integer;
  oCount: LongInt;
label
  SkipProc, CloseProc, LastProc;
begin
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  //MessageDlg(Self.Caption, fsFileName, mtError, [mbOK], 0);
  if (gb_MSX_DSK_FILE_EXIST(fsFileName) <> True) then goto LastProc;
  oCount := Gi_FILE_SIZE;
  //MessageDlg(Self.Caption, gmsCStr(oCount, 0), mtError, [mbOK], 0);

  T := -1;
  F := gb_READ_MSX_DSK_FAT12(fiDisk);
  gt_MOVE_FAT12_TO_ENTRY;
  for i := 0 to (714 - 1) do
    begin
      wrkFAT12Entry[i] := dskFAT12Entry[i];
      if (i >= 2) then
        if ((T = -1) And (wrkFAT12Entry[i] = 0)) then T := i;
    end;

  AssignFile(FH, fsFileName);

  Reset(FH); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)

  if (fiDisk = 1) then
    if (oCount > foDiskAfree) then
      begin
        MessageDlg(Self.Caption, '* 저장 공간 부족 !', mtError, [mbOK], 0);
        goto CloseProc;
      end;
  if (fiDisk = 2) then
    if (oCount > foDiskBfree) then
      begin
        MessageDlg(Self.Caption, '* 저장 공간 부족 !', mtError, [mbOK], 0);
        goto CloseProc;
      end;

  S := fsGetFileName2(fsWriteName);
  for i := 0 to (32 - 1) do
    begin
      wrkBuffer[i] := 0;
      if ((i >= 0) And (i <= 10)) then wrkBuffer[i] := gmiAsc(gmsMid(S, i + 1, 1));
    end;
  wrkBuffer[26] := (T And $FF);
  wrkBuffer[27] := (T And $F00) div 256;
  S := gmsRight('00000000' + gmsHex(oCount, 0), 8);
  wrkBuffer[28] := gmiHex8ToInt(gmsMid(S, 7, 2));
  wrkBuffer[29] := gmiHex8ToInt(gmsMid(S, 5, 2));
  wrkBuffer[30] := gmiHex8ToInt(gmsMid(S, 3, 2));
  wrkBuffer[31] := gmiHex8ToInt(gmsMid(S, 1, 2));
  S := gmsTime; //HH:MM:SS
  S := gmsRight(gmsBin(gmiVal(gmsMid(S, 1, 2)), 8), 5) +
       gmsRight(gmsBin(gmiVal(gmsMid(S, 4, 2)), 8), 6) +
       gmsRight(gmsBin(gmiVal(gmsMid(S, 7, 2)), 8), 5);
  wrkBuffer[22] := gmiBin8ToInt(gmsRight(S, 8));
  wrkBuffer[23] := gmiBin8ToInt(gmsLeft(S, 8));
  S := gmsDate; //YYYY-MM-DD
  S := gmsRight(gmsBin(gmiVal(gmsMid(S, 1, 4)) - 1980, 8), 7) +
       gmsRight(gmsBin(gmiVal(gmsMid(S, 6, 2)), 8), 4) +
       gmsRight(gmsBin(gmiVal(gmsMid(S, 9, 2)), 8), 5);
  wrkBuffer[24] := gmiBin8ToInt(gmsRight(S, 8));
  wrkBuffer[25] := gmiBin8ToInt(gmsLeft(S, 8));

  F := gb_READ_MSX_DSK_LBA(fiDisk, gmiIfThen(fiDisk = 1, fiLbaAnull, fiLbaBnull));
  for i := 0 to (32 - 1) do dskBuffer[i + gmiIfThen(fiDisk = 1, fiPosAnull, fiPosBnull)] := wrkBuffer[i];
  F := gb_WRITE_MSX_DSK_LBA(fiDisk, gmiIfThen(fiDisk = 1, fiLbaAnull, fiLbaBnull));

  W := -1;
  for L := 1 to oCount do
    begin
      W := W + 1;
      Read(FH, dskCluster[W]); //Read Byte
      if (W = (1024 - 1)) then
        begin
          F := gb_WRITE_MSX_DSK_CLUSTER(fiDisk, T);
          for i := (T + 1) to (714 - 1) do
            if (wrkFAT12Entry[i] = 0) then
              begin
                T2 := i;
                goto SkipProc;
              end;
SkipProc:
          if (L < oCount) then
            begin
              wrkFAT12Entry[T] := T2;
              T := T2;
              W := -1;
            end;
        end;
    end;

  if (W < (1024 - 1)) then
    begin
      for i := (W + 1) to 1023 do dskCluster[i] := 0;
      F := gb_WRITE_MSX_DSK_CLUSTER(fiDisk, T);
    end;
  wrkFAT12Entry[T] := $FFF;

  for i := 0 to (714 - 1) do dskFAT12Entry[i] := wrkFAT12Entry[i];
  gt_MOVE_ENTRY_TO_FAT12;
  F := gb_WRITE_MSX_DSK_FAT12(fiDisk);

  F := gb_MSX_DSK_COPY_FAT_TO_FAT2(fiDisk);

  ftDisplayDataRtn(fiDisk);

CloseProc:
  CloseFile(FH);

LastProc:
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents
end;

procedure TDskManagerFrm.ftMsxDiskFileOut;
var
  FH: File Of Byte;
  i: Integer; L: LongInt; F: Boolean; P, C: Integer;
label
  LoopProc, CloseProc, LastProc;
begin
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  F := gb_READ_MSX_DSK_FAT12(fiDisk);
  gt_MOVE_FAT12_TO_ENTRY;
  if (foSze = 0) then goto LastProc;

  AssignFile(FH, fsWriteName);

  Rewrite(FH); //출력(기존파일이있으면삭제)

  L := 0;
  P := fiClt;
LoopProc:
  if ((P >= 2) And (P <= (714 - 1))) then
    begin
      F := gb_READ_MSX_DSK_CLUSTER(fiDisk, P);

      for i := 0 to (1024 - 1) do
        begin
          L := L + 1;
          Write(FH, dskCluster[i]); //Write Byte
          if (foSze = L) then goto CloseProc;
        end;

      C := dskFAT12Entry[P];
      if ((C >= $FF8) And (C <= $FFF)) then goto CloseProc;
      P := C;
      goto LoopProc;
    end;

CloseProc:
  CloseFile(FH);

LastProc:
  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents
end;

procedure TDskManagerFrm.ftDisplayDataRtn(iDisk: Integer);
var
  R: Boolean;
  P, C, C2, V, iLn: Integer;
  i, j, k: Integer;
  fName, fSize, fDate, fAttrib: String;
  fPos, fCluster: String;
  iSizeA, iSizeB, iSz: LongInt;
label
   SkipProc, FEndProg;
begin
  iSizeA := 0;
  if (iDisk = 1) then
    begin
      StringGrid1.RowCount := 1;
      fiDiskAcnt := 0;
      fiLbaAnull := -1;
      fiPosAnull := -1;
    end;

  iSizeB := 0;
  if (iDisk = 2) then
    begin
      StringGrid2.RowCount := 1;
      fiDiskBcnt := 0;
      fiLbaBnull := -1;
      fiPosBnull := -1;
    end;

  for i := 7 to 13 do
    begin
      R := gb_READ_MSX_DSK_LBA(iDisk, i);
      for j := 0 to 15 do
        begin
          P := j * 32;
          fName := '';
          for k := 0 to 10 do
            begin
              C := dskBuffer[P + k];
              if (k = 0) then
                begin
                  if ((C = 0) Or (C = $E5)) then
                    begin
                      if ((iDisk = 1) And (fiLbaAnull = -1)) then
                        begin
                          fiLbaAnull := i;
                          fiPosAnull := P;
                        end;
                      if ((iDisk = 2) And (fiLbaBnull = -1)) then
                        begin
                          fiLbaBnull := i;
                          fiPosBnull := P;
                        end;
                    end;
                  if (C = 0) then goto SkipProc; //없음
                  if (C = $E5) then goto SkipProc; //삭제
                end;
              fName := fName + gmsChr(C);
            end;
          fName := gmsLeft(fName, 8) + '.' + gmsRight(fName, 3);
          fSize := '';
          iSz := 0;
          iSz := iSz + (dskBuffer[P + 28] * 1);
          iSz := iSz + (dskBuffer[P + 29] * 256);
          iSz := iSz + (dskBuffer[P + 30] * 65536);
          iSz := iSz + (dskBuffer[P + 31] * 16777216);
          fSize := gmsCStr(iSz, 0);
          if (iDisk = 1) then iSizeA := iSizeA + gmiVal(fSize);
          if (iDisk = 2) then iSizeB := iSizeB + gmiVal(fSize);
          fDate := '';
          C2 := dskBuffer[P + 25];
          C := dskBuffer[P + 24];
          V := (C2 shr 1) + 1980; //연도 - C2/2
          fDate := fDate + gmsRight('0000' + gmsCStr(V, 0), 4) + '-';
          V := ((C2 And 1) * 8) + (C shr 5); //월  - C/32
          fDate := fDate + gmsRight('00' + gmsCStr(V, 0), 2) + '-';
          V := (C And 31); //일
          fDate := fDate + gmsRight('00' + gmsCStr(V, 0), 2) + ' ';
          C2 := dskBuffer[P + 23];
          C := dskBuffer[P + 22];
          V := (C2 shr 3); //시 - C2/8
          fDate := fDate + gmsRight('00' + gmsCStr(V, 0), 2) + ':';
          V := ((C2 And 7) * 8) + (C shr 5); //분 - C/32
          fDate := fDate + gmsRight('00' + gmsCStr(V, 0), 2) + '';
          V := (C And 31); //초/2
          V := V * 2;
          fAttrib := '';
          C := dskBuffer[P + 11];
          fAttrib := fAttrib + gmsIfThen((C And 32) = 0, '_', 'A');
          fAttrib := fAttrib + gmsIfThen((C And 16) = 0, '_', 'D');
          fAttrib := fAttrib + gmsIfThen((C And 8) = 0, '_', 'V');
          fAttrib := fAttrib + gmsIfThen((C And 4) = 0, '_', 'S');
          fAttrib := fAttrib + gmsIfThen((C And 2) = 0, '_', 'H');
          fAttrib := fAttrib + gmsIfThen((C And 1) = 0, '_', 'R');
          fPos := '';
          fPos := gmsCStr(i, 0) + ':' + gmsRight('000' + gmsCStr(P, 0), 3);
          fCluster := '';
          fCluster := gmsCStr((dskBuffer[P + 26]) + (dskBuffer[P + 27] * 256), 0);
          ftDisplayFileName(iDisk, fName, fSize, fDate, fAttrib, fPos, fCluster);
SkipProc:
        end;
    end;

FEndProg:
  if (iDisk = 1) then
    begin
      //정렬
      if (StringGrid1.RowCount > 1) then
        begin
          StringGrid1.SortOrder := soAscending;
          StringGrid1.SortColRow(True, 1, 1, StringGrid1.RowCount - 1); //1Col,1~nRow
        end;
      //Total
      iLn := StringGrid1.RowCount;
      iLn := iLn + 1;
      StringGrid1.RowCount := iLn;
      for j := 1 to (StringGrid1.ColCount - 1) do
        begin
          //vaSpread1.Col = j
          //vaSpread1.ForeColor = gcnColRed
          //vaSpread1.BackColor = gcnColWYellow
        end;
      StringGrid1.Cells[1, iLn - 1] := '*Total Size';
      StringGrid1.Cells[2, iLn - 1] := gmsCStr(iSizeA, 0);
      StringGrid1.Cells[3, iLn - 1] := '';
      StringGrid1.Cells[4, iLn - 1] := '';
      StringGrid1.Cells[5, iLn - 1] := '';
      StringGrid1.Cells[6, iLn - 1] := '';
      //Free
      iLn := StringGrid1.RowCount;
      iLn := iLn + 1;
      StringGrid1.RowCount := iLn;
      for j := 1 to (StringGrid1.ColCount - 1) do
        begin
          //vaSpread1.Col = j
          //vaSpread1.ForeColor = gcnColBlue
        end;
      StringGrid1.Cells[1, iLn - 1] := '*Free  Size';
      foDiskAfree := go_GET_DISK_SPACE(iDisk);
      StringGrid1.Cells[2, iLn - 1] := gmsCStr(foDiskAfree, 0);
      StringGrid1.Cells[3, iLn - 1] := '';
      StringGrid1.Cells[4, iLn - 1] := '';
      StringGrid1.Cells[5, iLn - 1] := '';
      StringGrid1.Cells[6, iLn - 1] := '';
    end;

  if (iDisk = 2) then
    begin
      //정렬
      if (StringGrid2.RowCount > 1) then
        begin
          StringGrid2.SortOrder := soAscending;
          StringGrid2.SortColRow(True, 1, 1, StringGrid2.RowCount - 1); //1Col,1~nRow
        end;
      //Total
      iLn := StringGrid2.RowCount;
      iLn := iLn + 1;
      StringGrid2.RowCount := iLn;
      for j := 1 to (StringGrid2.ColCount - 1) do
        begin
          //vaSpread2.Col = j
          //vaSpread2.ForeColor = gcnColRed
          //vaSpread2.BackColor = gcnColWYellow
        end;
      StringGrid2.Cells[1, iLn - 1] := '*Total Size';
      StringGrid2.Cells[2, iLn - 1] := gmsCStr(iSizeB, 0);
      StringGrid2.Cells[3, iLn - 1] := '';
      StringGrid2.Cells[4, iLn - 1] := '';
      StringGrid2.Cells[5, iLn - 1] := '';
      StringGrid2.Cells[6, iLn - 1] := '';
      //Free
      iLn := StringGrid2.RowCount;
      iLn := iLn + 1;
      StringGrid2.RowCount := iLn;
      for j := 1 to (StringGrid2.ColCount - 1) do
        begin
          //vaSpread2.Col = j
          //vaSpread2.ForeColor = gcnColBlue
        end;
      StringGrid2.Cells[1, iLn - 1] := '*Free  Size';
      foDiskBfree := go_GET_DISK_SPACE(iDisk);
      StringGrid2.Cells[2, iLn - 1] := gmsCStr(foDiskBfree, 0);
      StringGrid2.Cells[3, iLn - 1] := '';
      StringGrid2.Cells[4, iLn - 1] := '';
      StringGrid2.Cells[5, iLn - 1] := '';
      StringGrid2.Cells[6, iLn - 1] := '';
    end;
end;

procedure TDskManagerFrm.ftDisplayFileName(iSheet: Integer; fName: String; fSize: String; fDate: String; fAttrib: String; fPos: String; fCluster: String);
var
  iLn: Integer;
begin
  if (iSheet = 1) then
    begin
      iLn := StringGrid1.RowCount;
      iLn := iLn + 1;
      StringGrid1.RowCount := iLn;
      StringGrid1.Cells[0, iLn - 1] := gmsCStr(iLn - 1, 0);
      StringGrid1.Cells[1, iLn - 1] := fName;
      StringGrid1.Cells[2, iLn - 1] := fSize;
      StringGrid1.Cells[3, iLn - 1] := fDate;
      StringGrid1.Cells[4, iLn - 1] := fAttrib;
      StringGrid1.Cells[5, iLn - 1] := fPos;
      StringGrid1.Cells[6, iLn - 1] := fCluster;
      fiDiskAcnt := iLn - 1;
    end;

  if (iSheet = 2) then
    begin
      iLn := StringGrid2.RowCount;
      iLn := iLn + 1;
      StringGrid2.RowCount := iLn;
      StringGrid2.Cells[0, iLn - 1] := gmsCStr(iLn - 1, 0);
      StringGrid2.Cells[1, iLn - 1] := fName;
      StringGrid2.Cells[2, iLn - 1] := fSize;
      StringGrid2.Cells[3, iLn - 1] := fDate;
      StringGrid2.Cells[4, iLn - 1] := fAttrib;
      StringGrid2.Cells[5, iLn - 1] := fPos;
      StringGrid2.Cells[6, iLn - 1] := fCluster;
      fiDiskBcnt := iLn - 1;
    end;
end;

  //FAT12, 2DD, 720KB
  //섹터 - 1440 (0~1439) = 2 Head * 80 Track * 9 Sector
  //0 - 부트섹터
  //1~3 - FAT12#1
  //4~6 - FAT12#2
  //7~13 - 디렉터리, 7*512/32=112파일
  //14~1439 - 데이터

  //512*3=1536/1.5=1024클러스터지정가능
  //1439-14+1=1426/2=713클러스터=730112Byte
  //클러스터번호는 2~714까지지정가능

end.

