unit frmMSX2;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, ExtCtrls, StdCtrls,
  Math;

type

  { TMSX2Frm }

  TMSX2Frm = class(TForm)
    AsmBtn: TButton;
    DiskBBtn: TButton;
    CalcBtn: TButton;
    ColorBtn: TButton;
    StartBtn: TButton;
    ExitBtn: TButton;
    StopBtn: TButton;
    ClearBtn: TButton;
    SetsBtn: TButton;
    DiskABtn: TButton;
    GFBTN: TButton;
    ScreenModeLbl: TLabel;
    MsxExecLbl: TLabel;
    MsxPnl: TPanel;
    GFPNL: TPanel;
    ScrnMSX: TImage;
    Timer1: TTimer;
    Timer2: TTimer;
    Timer3: TTimer;
    procedure AsmBtnClick(Sender: TObject);
    procedure CalcBtnClick(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure SetsBtnClick(Sender: TObject);
    procedure DiskABtnClick(Sender: TObject);
    procedure DiskBBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure ScrnMSXClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
  private
    procedure MSX_AUTO_SPEED;
    procedure DisplayExecuteState;
    function ShowFileOpenDialog: String;
    procedure READ_MSX_SETTING;
    procedure SETS_MSX_SETTING;
  public

  end;

var
  MSX2Frm: TMSX2Frm;

  fi_TimerCpuInterval: LongInt; //1000=1초, 16.66=1초에60번

  //타이머(딜레이용-AutoSpeed)
  fo_Exec_Time: Double;
  fo_ST_Timer: Double;
  fo_ED_Timer: Double;

  fi_MSX_SCREEN_MODE_Bak: ShortInt;

implementation

{$R *.lfm}

{ TMSX2Frm }
uses
  frmSets, frmASM, frmCalculate, frmColor,
  msxMSX, msxZ80A, msxMI, msxINT, msxMEM, msxIO, msxVDT, msxVDT_OUT,
  msxPSG, msxPSG_OUT, msxFDC, msxSaveLoad,
  untFunction, untRegistry;

var
  fiFirstRun: Integer = 0;

procedure TMSX2Frm.FormCreate(Sender: TObject);
begin
  //
end;

procedure TMSX2Frm.FormShow(Sender: TObject);
begin
  fiFirstRun := 0;
end;

procedure TMSX2Frm.FormActivate(Sender: TObject);
begin
  if (fiFirstRun = 0) then
    begin
      fiFirstRun := 1;

      GiMENU := 0; //0:[초기],1:시작,2:중지
      READ_MSX_SETTING;
      SETS_MSX_SETTING;
      Gi_MSX_PortWrite := 0; //1:Port Write [Test용]
      Gs_DSK_A_FILE_Bak := '';
      Gs_DSK_B_FILE_Bak := '';
      Gi_MSX_DISK_A_Run := 0;
      Gi_MSX_DISK_B_Run := 0;
      Gi_MSX_Execute := 0; //0:중지,1:실행중
      Gi_MSX_GotFocus := 0; //0:없음,1:포커스
      DisplayExecuteState;
      ScreenModeLbl.Caption := '';
      fi_MSX_SCREEN_MODE_Bak := -1;

      MSX_INIT;

      //EI상테에서 IM1일경우 0038h 1초에 60번 발생
      Gi_MSX_Timer_60_INT := 0; //1초60번확인(INT)
      fi_TimerCpuInterval := IfThen(Gi_MSX_Int_Timer = 0, 16, Gi_MSX_Int_Timer); //1000=1초, 16.66=1초에60번
      timer1.Interval := fi_TimerCpuInterval;
      timer1.Enabled := True;
      //사운드재생용
      timer2.Interval := 50; //1초에20번
      timer2.Enabled := True;
      //화면표시용
      Gi_MSX_Timer_16_VDP := 0;
      if (Gi_MSX_DisplayFrame = 0) then timer3.Interval := 16; //1초에60번
      if (Gi_MSX_DisplayFrame = 1) then timer3.Interval := 33; //1초에30번
      if (Gi_MSX_DisplayFrame = 2) then timer3.Interval := 45; //1초에22번
      if (Gi_MSX_DisplayFrame = 3) then timer3.Interval := 62; //1초에16번
      timer3.Enabled := True;

      Gb_MidiOpened := False;
      gt_MSX_Midi_Open;
    end;
end;

procedure TMSX2Frm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  if (fiFirstRun = 1) then
    begin
      if (Gb_MidiOpened = True) then gt_MSX_Midi_Close;
    end;
end;

procedure TMSX2Frm.StartBtnClick(Sender: TObject);
var
  iSz: Byte;
label
  LoopProc, ExitProc;
begin
  Gi_MSX_GotFocus := 0;
  if (Gi_MSX_Execute = 1) then
    begin
      DisplayExecuteState;
      goto ExitProc;
    end;

  GiMENU := 1; //0:초기,1:[시작],2:중지

  Gi_MSX_Execute := 1;
  DisplayExecuteState;

  fo_ST_Timer := GetTickCount64; //시작시간확인 ?????.??초
  fo_Exec_Time := 0;
  Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)

LoopProc:
  if ((Go_MSX_InterruptBack = Z80A_REG_PC) And (Go_MSX_InterruptBack <> 0)) then Gi_MSX_Interrupt := 0; //인터럽트종료 [초기값(-1)불가]

  //Tape I/O
  if (Gi_MEM_PAGE0 = 0) then //Page#0->Slot#0
    begin
      if (Z80A_REG_PC = $E1) then MSX_TAPE_BIOS_TAPION;
      if (Z80A_REG_PC = $E4) then MSX_TAPE_BIOS_TAPIN;
      if (Z80A_REG_PC = $E7) then MSX_TAPE_BIOS_TAPIOF;
      if (Z80A_REG_PC = $EA) then MSX_TAPE_BIOS_TAPOON;
      if (Z80A_REG_PC = $ED) then MSX_TAPE_BIOS_TAPOUT;
      if (Z80A_REG_PC = $F0) then MSX_TAPE_BIOS_TAPOOF;
      if (Z80A_REG_PC = $F3) then MSX_TAPE_BIOS_STMOTR;
    end;

  //Disk I/O
  if (Gi_MEM_PAGE1 = 3) then //Page#1->Slot#3
    begin
      if (Z80A_REG_PC = $4010) then MSX_DISK_BIOS_DSKIO;  //Read/Write sectors from disk
      if (Z80A_REG_PC = $4013) then MSX_DISK_BIOS_DSKCHG; //Check disk change status
      if (Z80A_REG_PC = $4016) then MSX_DISK_BIOS_GETDPB; //GETDPB: Disk format
      if (Z80A_REG_PC = $401C) then MSX_DISK_BIOS_DSKFMT; //Format disk
    end;

  EXEC_Z80A_CODE; //Z80A 명령 실행

  //MSX_REG_DISPLAY;
  Application.ProcessMessages; //DoEvents
  if (Gi_MSX_Auto_Speed = 1) then MSX_AUTO_SPEED;

  if (Gi_MSX_Execute = 0) then goto ExitProc; //계속실행 아니면 종료

  if (Gi_Z80A_EI_Chk > 0) then //EI 바로 다음은 인터럽트 금지
    begin
      Gi_Z80A_EI_Chk := Gi_Z80A_EI_Chk - 1;
      goto LoopProc;
    end;

  //인터럽트 - 1초에60번수행, IM1에서0038H호출, EI 다음명령 후 에 실행됨
  if ((Z80A_REG_IFF1 = 1) And (Z80A_INT_MODE = 1) And (Gi_MSX_Timer_60_INT = 1)) then
    begin
      Z80A_HALT := 1;
      if ((Gi_MSX_InterruptDup = 1) Or (Gi_MSX_Interrupt = 0)) then //0:금지,1:인터럽트중복허용(컴퓨터속도느릴경우스텍오버플로워폭주됨)
        begin
          Gi_MSX_Interrupt := 1; //인터럽트시작
          Gi_MSX_Timer_60_INT := 0;

          iSz := 1;
          Go_MSX_InterruptBack := Z80A_REG_PC;
          gt_PUSH_16(Z80A_REG_PC);
          Z80A_REG_PC := $38; //0038h
          Gi_Z80A_CLOCK := 11;
          EXEC_Z80A_ADD_PC(0, iSz); //1

          if (Gi_MSX_Execute = 0) then goto ExitProc; //계속실행 아니면 종료

          //MSX_REG_DISPLAY;
          Application.ProcessMessages; //DoEvents
          if (Gi_MSX_Auto_Speed = 1) then MSX_AUTO_SPEED;
        end;
    end;

  goto LoopProc;

ExitProc:
end;

procedure TMSX2Frm.MSX_AUTO_SPEED;
var
  oCpuTime, oPrgTime: Double;
label
  LoopProc, ExitProc;
begin
  //Clock 3.57954MHz, 1 Cycle 279n * (명령State+OP코드바이트수)
  //1m(밀리)=1/1000, 1u(마이크로)=1/1000000, 1n(나노)=1/1000000000

  oCpuTime := (Gi_Z80A_ClockSize * 279) / 1000; //u=1/1,000n
  fo_Exec_Time := fo_Exec_Time + oCpuTime;

  if (fo_Exec_Time < 10000) then goto ExitProc; //1/100초(Z80A실행시간) 지날때까지 대기

LoopProc:
  //Application.ProcessMessages; //DoEvents
  fo_ED_Timer := GetTickCount64; //종료시간확인, ?????.??초
  if (fo_ED_Timer < fo_ST_Timer) then fo_ST_Timer := fo_ED_Timer; //일자변경됨
  oPrgTime := fo_ED_Timer - fo_ST_Timer;
  if (oPrgTime < 0.01) then goto LoopProc; //1/100초(컴퓨터시간) 지날때까지대기

  fo_ST_Timer := GetTickCount64; //시작시간확인
  fo_Exec_Time := 0;

ExitProc:
end;

procedure TMSX2Frm.StopBtnClick(Sender: TObject);
label
  LastProc;
begin
  Gi_MSX_GotFocus := 0;
  if (Gi_MSX_Execute <> 1) then goto LastProc;
  Gi_MSX_Execute := 0;

  GiMENU := 2; //0:초기,1:시작,2:[중지]

LastProc:
  DisplayExecuteState;
end;

procedure TMSX2Frm.ClearBtnClick(Sender: TObject);
begin
  Gi_MSX_GotFocus := 0;
  if (Gi_MSX_Execute = 0) then
    begin
      GFBTN.SetFocus;
      ClearBtn.Enabled := False;

      Screen.Cursor := crHourGlass; //마우스(모래시계)
      Application.ProcessMessages; //DoEvents

      GiMENU := 0; //0:[초기],1:시작,2:중지
      SETS_MSX_SETTING;
      MSX_INIT;

      ClearBtn.Enabled := True;
      ClearBtn.SetFocus;

      Screen.Cursor := crDefault; //마우스(정상)
      Application.ProcessMessages; //DoEvents
    end;
  DisplayExecuteState;

  ScreenModeLbl.Caption := '';
  fi_MSX_SCREEN_MODE_Bak := -1;
end;

procedure TMSX2Frm.SetsBtnClick(Sender: TObject);
var
  bFocus: ShortInt;
begin
  bFocus := Gi_MSX_GotFocus;

  Gi_MSX_GotFocus := 0;
  DisplayExecuteState;

  SetsFrm.ShowModal;

  Gi_MSX_GotFocus := bFocus;
  DisplayExecuteState;

  fi_TimerCpuInterval := IfThen(Gi_MSX_Int_Timer = 0, 16, Gi_MSX_Int_Timer); //1000=1초, 16.66=1초에60번
  timer1.Interval := fi_TimerCpuInterval;
  if (Gi_MSX_DisplayFrame = 0) then timer3.Interval := 16; //1초에60번
  if (Gi_MSX_DisplayFrame = 1) then timer3.Interval := 33; //1초에30번
  if (Gi_MSX_DisplayFrame = 2) then timer3.Interval := 45; //1초에22번
  if (Gi_MSX_DisplayFrame = 3) then timer3.Interval := 62; //1초에16번
end;

procedure TMSX2Frm.DiskABtnClick(Sender: TObject);
label
  LastProc;
begin
  Gi_MSX_GotFocus := 0;
  DisplayExecuteState;
  if (GiMENU <> 2) then goto LastProc; //0:초기,1:시작,2:[중지]

  GFBTN.SetFocus;
  DiskABtn.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  MsxSaveStatus;

  DiskABtn.Enabled := True;
  DiskABtn.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

LastProc:
end;

procedure TMSX2Frm.DiskBBtnClick(Sender: TObject);
var
  MsxFile: String;
label
  LastProc;
begin
  Gi_MSX_GotFocus := 0;
  DisplayExecuteState;
  if (GiMENU <> 0) then goto LastProc; //0:[초기],1:시작,2:중지

  MsxFile := gsGetMsxFileName(gmsTrim(ShowFileOpenDialog));
  if (MsxFile = '') then goto LastProc;

  GFBTN.SetFocus;
  DiskBBtn.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  MsxLoadStatus(MsxFile);

  DiskBBtn.Enabled := True;
  DiskBBtn.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

  ScreenModeLbl.Caption := '';
  fi_MSX_SCREEN_MODE_Bak := -1;

LastProc:
end;

procedure TMSX2Frm.AsmBtnClick(Sender: TObject);
begin
  ASMFrm.ShowModal;
end;

procedure TMSX2Frm.CalcBtnClick(Sender: TObject);
begin
  CalculateFrm.ShowModal;
end;

procedure TMSX2Frm.ColorBtnClick(Sender: TObject);
begin
  ColorFrm.ShowModal;
end;

procedure TMSX2Frm.ExitBtnClick(Sender: TObject);
begin
  Gi_MSX_GotFocus := 0;
  DisplayExecuteState;

  Gi_MSX_Execute := 0; //중지: 실행중이면 작동안함?

  Close;
end;

procedure TMSX2Frm.ScrnMSXClick(Sender: TObject);
begin
  Gi_MSX_GotFocus := 1;
  DisplayExecuteState;
  GFBTN.SetFocus; //ScrnMSX.SetFocus;
end;

procedure TMSX2Frm.DisplayExecuteState;
begin
  if (Gi_MSX_Execute = 0) then
    begin
      MsxExecLbl.Caption := '';
    end
  else
    begin
      MsxExecLbl.Caption := '실행중';
    end;
  if (Gi_MSX_GotFocus = 0) then
    begin
      MsxExecLbl.Font.Color := clBlack;
    end
  else
    begin
      MsxExecLbl.Font.Color := clRed;
    end;
end;

procedure TMSX2Frm.Timer1Timer(Sender: TObject);
begin
  //CPU Interrupt
  Gi_MSX_Timer_60_INT := 1;
end;

procedure TMSX2Frm.Timer2Timer(Sender: TObject);
begin
  //사운드재생용
  if (Gi_MSX_Execute = 1) then //실행중
    begin
      MSX_PSG_TONE_OUT_A(Gi_MSX_PSG_T_ON_A);
      MSX_PSG_TONE_OUT_B(Gi_MSX_PSG_T_ON_B);
      MSX_PSG_TONE_OUT_C(Gi_MSX_PSG_T_ON_C);
      MSX_PSG_NOISE_OUT_A(Gi_MSX_PSG_N_ON_A);
      MSX_PSG_NOISE_OUT_B(Gi_MSX_PSG_N_ON_B);
      MSX_PSG_NOISE_OUT_C(Gi_MSX_PSG_N_ON_C);
    end
  else //중지
    begin
      MSX_PSG_TONE_OUT_A(1);
      MSX_PSG_TONE_OUT_B(1);
      MSX_PSG_TONE_OUT_C(1);
      MSX_PSG_NOISE_OUT_A(1);
      MSX_PSG_NOISE_OUT_B(1);
      MSX_PSG_NOISE_OUT_C(1);
    end;

  //Disk 구동 표시용
  if (Gi_MSX_DISK_A_Run > 0) then
    begin
      DiskABtn.Font.Style := [fsBold];
      Gi_MSX_DISK_A_Run := Gi_MSX_DISK_A_Run - 1;
      if (Gi_MSX_DISK_A_Run = 0) then DiskABtn.Font.Style := [];
    end;
  if (Gi_MSX_DISK_B_Run > 0) then
    begin
      DiskBBtn.Font.Style := [fsBold];
      Gi_MSX_DISK_B_Run := Gi_MSX_DISK_B_Run - 1;
      if (Gi_MSX_DISK_B_Run = 0) then DiskBBtn.Font.Style := [];
    end;
end;

procedure TMSX2Frm.Timer3Timer(Sender: TObject);
var
  S: String;
begin
  //화면표시용
  Gi_MSX_Timer_16_VDP := 1;
  if ((Gi_MSX_Execute = 1) And (Gi_MSX_SCREEN_MODE <> fi_MSX_SCREEN_MODE_Bak)) then //실행중
    begin
      if (Gi_MSX_SCREEN_MODE <> 10) then
        S := gmsCStr(Gi_MSX_SCREEN_MODE, 0)
      else
        S := '0+'
      ;
      ScreenModeLbl.Caption := 'SC ' + S;
      fi_MSX_SCREEN_MODE_Bak := Gi_MSX_SCREEN_MODE;
    end;

  MSX_SCREEN_DISP;
end;

function TMSX2Frm.ShowFileOpenDialog: String;
var
  Dlg: TOpenDialog;
  R: String;
begin
  R := '';

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일 (*.*)|*.*|MSX 파일|*.MSX';

  if (Dlg.Execute) then R := Dlg.FileName;

  Result := R;
end;

procedure TMSX2Frm.READ_MSX_SETTING;
begin
  Gi_MSX2_Sets := giGetRegistry('MSX_Machine');
  Gi_DISK_Sets := giGetRegistry('MSX_DiskRom');
  Gi_CHAR_Sets := giGetRegistry('MSX_CharFont');
  Gi_SC2X_Sets := giGetRegistry('MSX_Scale2x');

  Gi_MSX_Int_Timer := giGetRegistry('MSX_IntTimer');
  Gi_MSX_DisplayFrame := giGetRegistry('MSX_DisplayFrame');

  Gi_MSX_InterruptDup := giGetRegistry('MSX_InterruptDup');
  Gi_MSX_Auto_Speed := giGetRegistry('MSX_AutoSpeed');
  Gi_MSX_KeyChange := giGetRegistry('MSX_KeyChange');
  Gi_MSX_JoyOn := giGetRegistry('MSX_JoyOn');
  Gi_MSX_SpaceOn := giGetRegistry('MSX_SpaceOn');
  Gi_MSX_VDT_ST_FF := giGetRegistry('MSX_VdtStFf');

  Gs_CAS_FILE := gsGetCasFileName(gsGetRegistry('MSX_CasFile'));
  Gs_ROM_FILE := gsGetRomFileName(gsGetRegistry('MSX_RomFile'));
  Gi_ROM_TYPE := giGetRegistry('MSX_RomType');
  Gs_DSK_A_FILE := gsGetDskFileName(gsGetRegistry('MSX_DiskAFile'));
  Gs_DSK_B_FILE := gsGetDskFileName(gsGetRegistry('MSX_DiskBFile'));
  Gi_DSK_A_ON := 0;
  Gi_DSK_B_ON := 0;

  if ((Gi_MSX2_Sets < 0) Or (Gi_MSX2_Sets > 1)) then Gi_MSX2_Sets := 0;
  if ((Gi_DISK_Sets < 0) Or (Gi_DISK_Sets > 1)) then Gi_DISK_Sets := 0;
  if ((Gi_CHAR_Sets < 0) Or (Gi_CHAR_Sets > 1)) then Gi_CHAR_Sets := 0;
  if ((Gi_SC2X_Sets < 0) Or (Gi_SC2X_Sets > 1)) then Gi_SC2X_Sets := 0;
  if ((Gi_MSX_Int_Timer < 10) Or (Gi_MSX_Int_Timer > 100)) then Gi_MSX_Int_Timer := 0;
  if ((Gi_MSX_DisplayFrame < 0) Or (Gi_MSX_DisplayFrame > 3)) then Gi_MSX_DisplayFrame := 0;
  if ((Gi_MSX_InterruptDup < 0) Or (Gi_MSX_InterruptDup > 1)) then Gi_MSX_InterruptDup := 0;
  if ((Gi_MSX_Auto_Speed < 0) Or (Gi_MSX_Auto_Speed > 1)) then Gi_MSX_Auto_Speed := 0;
  if ((Gi_MSX_KeyChange < 0) Or (Gi_MSX_KeyChange > 1)) then Gi_MSX_KeyChange := 0;
  if ((Gi_MSX_JoyOn < 0) Or (Gi_MSX_JoyOn > 1)) then Gi_MSX_JoyOn := 0;
  if ((Gi_MSX_SpaceOn < 0) Or (Gi_MSX_SpaceOn > 1)) then Gi_MSX_SpaceOn := 0;
  if ((Gi_MSX_VDT_ST_FF < 0) Or (Gi_MSX_VDT_ST_FF > 1)) then Gi_MSX_VDT_ST_FF := 0;
  if ((Gi_ROM_TYPE < 0) Or (Gi_ROM_TYPE > 5)) then Gi_ROM_TYPE := 0;
  if ((Gi_DSK_A_ON < 0) Or (Gi_DSK_A_ON > 1)) then Gi_DSK_A_ON := 0;
  if ((Gi_DSK_B_ON < 0) Or (Gi_DSK_B_ON > 1)) then Gi_DSK_B_ON := 0;
end;

procedure TMSX2Frm.SETS_MSX_SETTING;
begin
  GiMSX2 := Gi_MSX2_Sets;
  GiDISK := Gi_DISK_Sets;
  GiCHAR := Gi_CHAR_Sets;
  GiSC2X := Gi_SC2X_Sets;
end;

end.

