unit frmSets;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, Math;

type

  { TSetsFrm }

  TSetsFrm = class(TForm)
    AutoSpeedChk: TCheckBox;
    CasEnterCmd: TButton;
    CasFileTxt: TEdit;
    CasHelpCmd: TButton;
    CasWriteCmd: TButton;
    DiskBCreateCmd: TButton;
    DiskSelt0Opt: TRadioButton;
    DiskSelt1Opt: TRadioButton;
    DskAFileTxt: TEdit;
    DskAHelpCmd: TButton;
    DskMngBtn: TButton;
    DskAOnChk: TCheckBox;
    DskBFileTxt: TEdit;
    DskBHelpCmd: TButton;
    DskBOnChk: TCheckBox;
    DiskDivCmd: TButton;
    DspFrame0Opt: TRadioButton;
    DspFrame1Opt: TRadioButton;
    DspFrame2Opt: TRadioButton;
    DspFrame3Opt: TRadioButton;
    FontSelt0Opt: TRadioButton;
    FontSelt1Opt: TRadioButton;
    GroupBox1: TGroupBox;
    GroupBox10: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    GroupBox6: TGroupBox;
    GroupBox7: TGroupBox;
    GroupBox8: TGroupBox;
    GroupBox9: TGroupBox;
    IntDupeChk: TCheckBox;
    JoyStickChk: TCheckBox;
    KeyChangeChk: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Msx1Lbl: TLabel;
    Msx2Lbl: TLabel;
    MsxSelt0Opt: TRadioButton;
    MsxSelt1Opt: TRadioButton;
    RomEnterCmd: TButton;
    RomFileTxt: TEdit;
    RomHelpCmd: TButton;
    RomSelt0Opt: TRadioButton;
    RomSelt1Opt: TRadioButton;
    RomSelt2Opt: TRadioButton;
    RomSelt3Opt: TRadioButton;
    RomSelt4Opt: TRadioButton;
    RomSelt5Opt: TRadioButton;
    SetEnterCmd: TButton;
    SetExitCmd: TButton;
    SpaceOnChk: TCheckBox;
    TimerTxt: TEdit;
    VdtStFfChk: TCheckBox;
    procedure CasFileTxtEnter(Sender: TObject);
    procedure DiskBCreateCmdClick(Sender: TObject);
    procedure DiskDivCmdClick(Sender: TObject);
    procedure DskAFileTxtEnter(Sender: TObject);
    procedure DskBFileTxtEnter(Sender: TObject);
    procedure DskMngBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure RomFileTxtEnter(Sender: TObject);
    procedure SetEnterCmdClick(Sender: TObject);
    procedure SetExitCmdClick(Sender: TObject);
    procedure CasFileTxtExit(Sender: TObject);
    procedure RomFileTxtExit(Sender: TObject);
    procedure DskAFileTxtExit(Sender: TObject);
    procedure DskBFileTxtExit(Sender: TObject);
    procedure CasWriteCmdClick(Sender: TObject);
    procedure CasHelpCmdClick(Sender: TObject);
    procedure CasEnterCmdClick(Sender: TObject);
    procedure RomHelpCmdClick(Sender: TObject);
    procedure RomEnterCmdClick(Sender: TObject);
    procedure DskAHelpCmdClick(Sender: TObject);
    procedure DskBHelpCmdClick(Sender: TObject);
    procedure TimerTxtEnter(Sender: TObject);
    procedure TimerTxtExit(Sender: TObject);
  private
    function ShowFileOpenDialog: String;
    procedure WRITE_MSX_SETTING;
  public

  end;

var
  SetsFrm: TSetsFrm;

implementation

{$R *.lfm}

{ TSetsFrm }
uses
  frmDskManager,
  msxMSX, msxZ80A, msxMEM, msxFDC,
  untFunction, untRegistry;

const
  FLen: Integer = 200;

var
  fs_DSK_A_FILE_bak: String;
  fs_DSK_B_FILE_bak: String;

procedure TSetsFrm.FormCreate(Sender: TObject);
begin
  //
end;

procedure TSetsFrm.FormShow(Sender: TObject);
begin
  if (gmsRight(gmsTrim(Msx1Lbl.Caption), 1) = '-') then Msx1Lbl.Caption := Msx1Lbl.Caption + csMSX_Version;

  if (Gi_MSX2_Sets = 0) then begin MsxSelt0Opt.Checked := True; end else begin MsxSelt1Opt.Checked := True; end;
  if (Gi_DISK_Sets = 0) then begin DiskSelt0Opt.Checked := True; end else begin DiskSelt1Opt.Checked := True; end;
  if (Gi_CHAR_Sets = 0) then begin FontSelt0Opt.Checked := True; end else begin FontSelt1Opt.Checked := True; end;
  //Scale2xChk.Checked := IfThen(Gi_SC2X_Sets = 0, false, true);

  TimerTxt.Text := gmsCStr(Gi_MSX_Int_Timer, 0);
  if (Gi_MSX_Int_Timer = 0) then TimerTxt.Text := '';
  if ((Gi_MSX_DisplayFrame < 0) Or (Gi_MSX_DisplayFrame > 3)) then Gi_MSX_DisplayFrame := 0;
  if (Gi_MSX_DisplayFrame = 0) then DspFrame0Opt.Checked := True;
  if (Gi_MSX_DisplayFrame = 1) then DspFrame1Opt.Checked := True;
  if (Gi_MSX_DisplayFrame = 2) then DspFrame2Opt.Checked := True;
  if (Gi_MSX_DisplayFrame = 3) then DspFrame3Opt.Checked := True;

  IntDupeChk.Checked := gmbIfThen(Gi_MSX_InterruptDup = 0, False, True);
  AutoSpeedChk.Checked := gmbIfThen(Gi_MSX_Auto_Speed = 0, False, True);
  KeyChangeChk.Checked := gmbIfThen(Gi_MSX_KeyChange = 0, False, True);
  JoyStickChk.Checked := gmbIfThen(Gi_MSX_JoyOn = 0, False, True);
  SpaceOnChk.Checked := gmbIfThen(Gi_MSX_SpaceOn = 0, False, True);
  VdtStFfChk.Checked := gmbIfThen(Gi_MSX_VDT_ST_FF = 0, False, True);

  CasFileTxt.Text := Gs_CAS_FILE;
  RomFileTxt.Text := Gs_ROM_FILE;
  if ((Gi_ROM_TYPE < 0) Or (Gi_ROM_TYPE > 5)) then Gi_ROM_TYPE := 0;
  if (Gi_ROM_TYPE = 0) then RomSelt0Opt.Checked := True;
  if (Gi_ROM_TYPE = 1) then RomSelt1Opt.Checked := True;
  if (Gi_ROM_TYPE = 2) then RomSelt2Opt.Checked := True;
  if (Gi_ROM_TYPE = 3) then RomSelt3Opt.Checked := True;
  if (Gi_ROM_TYPE = 4) then RomSelt4Opt.Checked := True;
  if (Gi_ROM_TYPE = 5) then RomSelt5Opt.Checked := True;
  DskAFileTxt.Text := Gs_DSK_A_FILE;
  DskBFileTxt.Text := Gs_DSK_B_FILE;
  DskAOnChk.Checked := gmbIfThen(Gi_DSK_A_ON = 0, False, True);
  DskBOnChk.Checked := gmbIfThen(Gi_DSK_B_ON = 0, False, True);

  if (Gi_MSX_Execute = 0) then
    begin
      DskMngBtn.Enabled := True;
      DiskBCreateCmd.Enabled := True;
      DiskDivCmd.Enabled := True;
    end
  else
    begin
      DskMngBtn.Enabled := False;
      DiskBCreateCmd.Enabled := False;
      DiskDivCmd.Enabled := False;
    end;
end;

procedure TSetsFrm.FormActivate(Sender: TObject);
begin
  //
end;

procedure TSetsFrm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  //
end;

procedure TSetsFrm.SetEnterCmdClick(Sender: TObject);
begin
  WRITE_MSX_SETTING;
  Close;
end;

procedure TSetsFrm.SetExitCmdClick(Sender: TObject);
begin
  Close;
end;

procedure TSetsFrm.CasFileTxtEnter(Sender: TObject);
begin
  CasFileTxt.Color := clYellow;
end;

procedure TSetsFrm.CasFileTxtExit(Sender: TObject);
begin
  CasFileTxt.Color := clWhite;

  CasFileTxt.Text := gmsTrim(gmsDelete(gmsLeft(CasFileTxt.Text, FLen)));
  CasFileTxt.Text := gsGetCasFileName(CasFileTxt.Text);
end;

procedure TSetsFrm.RomFileTxtEnter(Sender: TObject);
begin
  RomFileTxt.Color := clYellow;
end;

procedure TSetsFrm.RomFileTxtExit(Sender: TObject);
begin
  RomFileTxt.Color := clWhite;

  RomFileTxt.Text := gmsTrim(gmsDelete(gmsLeft(RomFileTxt.Text, FLen)));
  RomFileTxt.Text := gsGetRomFileName(RomFileTxt.Text);
end;

procedure TSetsFrm.DskAFileTxtEnter(Sender: TObject);
begin
  DskAFileTxt.Color := clYellow;
end;

procedure TSetsFrm.DskAFileTxtExit(Sender: TObject);
begin
  DskAFileTxt.Color := clWhite;

  DskAFileTxt.Text := gmsTrim(gmsDelete(gmsLeft(DskAFileTxt.Text, FLen)));
  DskAFileTxt.Text := gsGetDskFileName(DskAFileTxt.Text);
end;

procedure TSetsFrm.DskBFileTxtEnter(Sender: TObject);
begin
  DskBFileTxt.Color := clYellow;
end;

procedure TSetsFrm.DskBFileTxtExit(Sender: TObject);
begin
  DskBFileTxt.Color := clWhite;

  DskBFileTxt.Text := gmsTrim(gmsDelete(gmsLeft(DskBFileTxt.Text, FLen)));
  DskBFileTxt.Text := gsGetDskFileName(DskBFileTxt.Text);
end;

procedure TSetsFrm.CasWriteCmdClick(Sender: TObject);
var
  FH: File Of Byte;
  FileName: String;
  TXT_TAB, VAR_TAB, ARY_TAB, STR_END: Word;
  L: Word;
  B: Byte;
begin
  SetEnterCmd.SetFocus;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  CasWriteCmd.Enabled := false;

  FileName := 'C:\MSX-' + FormatDateTime('YYYYMMDD', Now) + '-' + FormatDateTime('HHMMSS', Now) + '.CAS';
  AssignFile(FH, FileName);

  Rewrite(FH); //출력(기존파일이있으면삭제)

  TXT_TAB := GET_MSX_MEMORY_16($F676);
  VAR_TAB := GET_MSX_MEMORY_16($F6C2);
  ARY_TAB := GET_MSX_MEMORY_16($F6C4);
  STR_END := GET_MSX_MEMORY_16($F6C6);

  B := giGetLngToIntL(TXT_TAB); Write(FH, B);
  B := giGetLngToIntH(TXT_TAB); Write(FH, B);
  B := giGetLngToIntL(VAR_TAB); Write(FH, B);
  B := giGetLngToIntH(VAR_TAB); Write(FH, B);
  B := giGetLngToIntL(ARY_TAB); Write(FH, B);
  B := giGetLngToIntH(ARY_TAB); Write(FH, B);
  B := giGetLngToIntL(STR_END); Write(FH, B);
  B := giGetLngToIntH(STR_END); Write(FH, B);

  for L := TXT_TAB to (VAR_TAB - 1) do
    begin
      B := GET_MSX_MEMORY(L); Write(FH, B);
    end;

  CloseFile(FH);

  CasWriteCmd.Enabled := true;
  Screen.Cursor := crDefault; //마우스(정상)
end;

procedure TSetsFrm.CasHelpCmdClick(Sender: TObject);
begin
  CasFileTxt.Text := ShowFileOpenDialog;
  CasFileTxt.SetFocus;
end;

procedure TSetsFrm.CasEnterCmdClick(Sender: TObject);
var
  FH: File Of Byte;
  FileName: String;
  TXT_TAB, VAR_TAB, ARY_TAB, STR_END: Word;
  RecordCount: LongInt;
  StartNo: Word;
  B: Byte;
label
  ExitProc;
begin
  Gi_MSX_TAPE_Work := 0; //Tape Read 초기화

  FileName := gmsTrim(CasFileTxt.Text);
  if (FileName = '') then goto ExitProc;
  if (gmiInStr(1, FileName, 'MSX-') = 0) then goto ExitProc;
  if (gb_MSX_DSK_FILE_EXIST(FileName) <> True) then goto ExitProc;

  SetEnterCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  CasEnterCmd.Enabled := False;

  TXT_TAB := 0; VAR_TAB := 0; ARY_TAB := 0; STR_END := 0;
  AssignFile(FH, FileName);
  Reset(FH); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)
  RecordCount := 0;

  while (True) do
    begin
      Try
        Try
          Read(FH, B);
          if (RecordCount = 0) then begin TXT_TAB := (TXT_TAB + B); end;
          if (RecordCount = 1) then begin TXT_TAB := (TXT_TAB + (B * 256)); StartNo := TXT_TAB; end;
          if (RecordCount = 2) then begin VAR_TAB := (VAR_TAB + B); end;
          if (RecordCount = 3) then begin VAR_TAB := (VAR_TAB + (B * 256)); end;
          if (RecordCount = 4) then begin ARY_TAB := (ARY_TAB + B); end;
          if (RecordCount = 5) then begin ARY_TAB := (ARY_TAB + (B * 256)); end;
          if (RecordCount = 6) then begin STR_END := (STR_END + B); end;
          if (RecordCount = 7) then begin STR_END := (STR_END + (B * 256)); end;
          if (RecordCount >= 8) then
            begin
              PUT_MSX_MEMORY(StartNo, B);
              StartNo := StartNo + 1;
            end;
          RecordCount := RecordCount + 1;
        Except
          break;
        End;
      Finally
      End;
    end;

    PUT_MSX_MEMORY_16($F6C2, VAR_TAB);
    PUT_MSX_MEMORY_16($F6C4, VAR_TAB);
    PUT_MSX_MEMORY_16($F6C6, VAR_TAB);

    CloseFile(FH);

    CasEnterCmd.Enabled := True;
    Screen.Cursor := crDefault; //마우스(정상)

ExitProc:
end;

procedure TSetsFrm.RomHelpCmdClick(Sender: TObject);
begin
  RomFileTxt.Text := ShowFileOpenDialog;
  RomFileTxt.SetFocus;
end;

procedure TSetsFrm.RomEnterCmdClick(Sender: TObject);
var
  FH: File Of Byte;
  FileName: String;
  RecordCount: LongInt;
  StartNo :LongInt;
  B, B0, B1, B2, B3: Byte;
  fl: LongInt;
label
  ExitProc;
begin
  FileName := gmsTrim(RomFileTxt.Text);
  if (FileName = '') then goto ExitProc;
  if (gb_MSX_DSK_FILE_EXIST(FileName) <> True) then goto ExitProc;

  SetEnterCmd.SetFocus;
  Screen.Cursor := crHourGlass; //마우스(모래시계)
  RomEnterCmd.Enabled := False;

  AssignFile(FH, FileName);
  Reset(FH); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)

  Gi_Big32K_ROM := 0;
  fl := FileSize(FH);
  if (fl > 32768) then Gi_Big32K_ROM := 1;

  StartNo := $4000;
  RecordCount := 0;

  while (True) do
    begin
      Try
        Try
          Read(FH, B);
          if (RecordCount = 0) then B0 := MSX_MEM[1, StartNo];
          if (RecordCount = 1) then B1 := MSX_MEM[1, StartNo];
          if (RecordCount = 2) then B2 := MSX_MEM[1, StartNo];
          if (RecordCount = 3) then B3 := MSX_MEM[1, StartNo];
          if (StartNo <= 49151) then MSX_MEM[1, StartNo] := B; //Slot#1 MEM [4000~7FFF]
          MSX_ROM[RecordCount] := B; //Mega ROM [0000~4MB]
          if ((Gi_Big32K_ROM = 0) And (RecordCount = 3) And (B >= $80)) then
            begin
              MSX_MEM[1, $8000] := MSX_MEM[1, $4000];
              MSX_MEM[1, $8001] := MSX_MEM[1, $4001];
              MSX_MEM[1, $8002] := MSX_MEM[1, $4002];
              MSX_MEM[1, $8003] := MSX_MEM[1, $4003];
              MSX_MEM[1, $4000] := B0;
              MSX_MEM[1, $4001] := B1;
              MSX_MEM[1, $4002] := B2;
              MSX_MEM[1, $4003] := B3;
              StartNo := (StartNo + $4000); //8000~
            end;
          StartNo := StartNo + 1;
          RecordCount := RecordCount + 1;
        Except
          break;
        End;
      Finally
      End;
    end;

  CloseFile(FH);

  RomEnterCmd.Enabled := True;
  Screen.Cursor := crDefault; //마우스(정상)

ExitProc:
end;

procedure TSetsFrm.DskMngBtnClick(Sender: TObject);
var
  Fn1Ok, Fn2Ok: Integer;
label
  LastProc;
begin
  Gs_DSK_A_IsFn := gmsTrim(gmsLeft(DskAFileTxt.Text, FLen));
  Gs_DSK_B_IsFn := gmsTrim(gmsLeft(DskBFileTxt.Text, FLen));

  Fn1Ok := 0;
  if (Gs_DSK_A_IsFn <> '') then
    if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_A_IsFn) = True) then
      if (gb_MSX_DSK_FILE_SIZE720(Gs_DSK_A_IsFn) = True) then
        Fn1Ok := 1;

  Fn2Ok := 0;
  if (Gs_DSK_B_IsFn <> '') then
    if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_B_IsFn) = True) then
      if (gb_MSX_DSK_FILE_SIZE720(Gs_DSK_B_IsFn) = True) then
        Fn2Ok := 1;

  if ((Fn1Ok = 0) And (Fn2Ok = 0)) then goto LastProc;
  Gi_DSK_A_IsOk := Fn1Ok;
  Gi_DSK_B_IsOk := Fn2Ok;
  DskManagerFrm.ShowModal;

LastProc:
end;

procedure TSetsFrm.DiskBCreateCmdClick(Sender: TObject);
var
  TxtFile: TextFile;
label
  LastProc;
begin
  Gs_DSK_B_IsFn := gmsTrim(gmsLeft(DskBFileTxt.Text, FLen));

  if (Gs_DSK_B_IsFn = '') then goto LastProc;
  if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_B_IsFn) = True) then goto LastProc;

  if (MessageDlg('* Disk B 를 생성할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  SetExitCmd.SetFocus;
  DiskBCreateCmd.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  fs_DSK_A_FILE_bak := Gs_DSK_A_FILE; Gs_DSK_A_FILE := Gs_DSK_A_IsFn;
  fs_DSK_B_FILE_bak := Gs_DSK_B_FILE; Gs_DSK_B_FILE := Gs_DSK_B_IsFn;

  Try
    Try
      AssignFile(TxtFile, Gs_DSK_B_IsFn); //파일생성
      ReWrite(TxtFile);
      CloseFile(TxtFile);

      gt_Disk_B_Create; //2DD-720KB
    Except
    End;
  Finally
  End;

  Gs_DSK_A_FILE := fs_DSK_A_FILE_bak;
  Gs_DSK_B_FILE := fs_DSK_B_FILE_bak;

  DiskBCreateCmd.Enabled := True;
  DiskBCreateCmd.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

LastProc:
end;

procedure TSetsFrm.DiskDivCmdClick(Sender: TObject);
var
  i, j: LongInt; k: Integer;
  Ln: LongInt; b: Byte;
  WrtFile: String;
  FH: THandle;
  FH_R: File Of Byte;
  FH_W: File Of Byte;
label
  LastProc;
begin
  Gs_DSK_B_IsFn := gmsTrim(gmsLeft(DskBFileTxt.Text, FLen));

  if (Gs_DSK_B_IsFn = '') then goto LastProc;
  if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_B_IsFn) = False) then goto LastProc;

  Ln := 0;
  Try
    Try
      FH := FileOpen(Gs_DSK_B_IsFn, fmOpenRead or fmShareDenyNone);
      Ln := FileSeek(FH, 0, fsFromEnd);
      FileClose(FH);
    Except
    End;
  Finally
  End;

  //MessageDlg(Self.Caption, gmsCStr(Ln, 8), mtError, [mbOK], 0);
  if (Ln <= 737280) then goto LastProc;
  if (MessageDlg('* Disk B 를 분할할까요 ?', mtInformation, mbOkCancel, 0) <> 1) then goto LastProc; //[1:Yes]

  SetExitCmd.SetFocus;
  DiskDivCmd.Enabled := False;

  Screen.Cursor := crHourGlass; //마우스(모래시계)
  Application.ProcessMessages; //DoEvents

  AssignFile(FH_R, Gs_DSK_B_IsFn);
  Reset(FH_R); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)

  j := 0; k := 0;
  for i := 1 to Ln do
    begin
      Read(FH_R, b);
      j := j + 1;
      if (j = 1) then
        begin
          k := k + 1;
          WrtFile := gmsLeft(Gs_DSK_B_IsFn, gmiLen(Gs_DSK_B_IsFn) - 4) + '_' + gmsRight('00' + gmsCStr(k, 0), 2) + gmsRight(Gs_DSK_B_IsFn, 4);
          AssignFile(FH_W, WrtFile);
          Rewrite(FH_W); //출력(기존파일이있으면삭제)
        end;
      Write(FH_W, b);
      if (j = 737280) then
        begin
          CloseFile(FH_W);
          j := 0;
        end;
    end;

  if (j > 0) then CloseFile(FH_W);
  CloseFile(FH_R);

  DiskDivCmd.Enabled := True;
  DiskDivCmd.SetFocus;

  Screen.Cursor := crDefault; //마우스(정상)
  Application.ProcessMessages; //DoEvents

LastProc:
end;

procedure TSetsFrm.DskAHelpCmdClick(Sender: TObject);
begin
  DskAFileTxt.Text := ShowFileOpenDialog;
  DskAFileTxt.SetFocus;
end;

procedure TSetsFrm.DskBHelpCmdClick(Sender: TObject);
begin
  DskBFileTxt.Text := ShowFileOpenDialog;
  DskBFileTxt.SetFocus;
end;

procedure TSetsFrm.TimerTxtEnter(Sender: TObject);
begin
  TimerTxt.Color := clYellow;
end;

procedure TSetsFrm.TimerTxtExit(Sender: TObject);
var
  iVal: LongInt;
begin
  TimerTxt.Color := clWhite;

  iVal := gmiVal(gmsRight(gmsTrim(TimerTxt.Text), 5));
  if ((iVal < 10) Or (iVal > 100)) then iVal := 0;
  TimerTxt.Text := gmsCStr(iVal, 0);
  if (iVal = 0) then TimerTxt.Text := '';
end;

function TSetsFrm.ShowFileOpenDialog: String;
var
  Dlg: TOpenDialog;
  R: String;
begin
  R := '';

  Dlg := TOpenDialog.Create(Self.Owner);
  Dlg.Title := '열기';
  Dlg.FileName := '';
  Dlg.Filter := '모든 파일 (*.*)|*.*|CAS 파일|*.CAS|ROM 파일|*.ROM|DISK 파일|*.DSK';

  if (Dlg.Execute) then R := Dlg.FileName;

  Result := R;
end;

procedure TSetsFrm.WRITE_MSX_SETTING;
begin
  if (MsxSelt0Opt.Checked = True) then begin Gi_MSX2_Sets := 0; end else begin Gi_MSX2_Sets := 1; end;
  if (DiskSelt0Opt.Checked = True) then begin Gi_DISK_Sets := 0; end else begin Gi_DISK_Sets := 1; end;
  if (FontSelt0Opt.Checked = True) then begin Gi_CHAR_Sets := 0; end else begin Gi_CHAR_Sets := 1; end;
  //Gi_SC2X_Sets := IfThen(Scale2xChk.Checked = false, 0, 1);

  Gi_MSX_Int_Timer := gmiVal(gmsRight(gmsTrim(TimerTxt.Text), 5));
  if ((Gi_MSX_Int_Timer < 10) Or (Gi_MSX_Int_Timer > 100)) then Gi_MSX_Int_Timer := 0;
  Gi_MSX_DisplayFrame := 0;
  if (DspFrame0Opt.Checked = True) then Gi_MSX_DisplayFrame := 0;
  if (DspFrame1Opt.Checked = True) then Gi_MSX_DisplayFrame := 1;
  if (DspFrame2Opt.Checked = True) then Gi_MSX_DisplayFrame := 2;
  if (DspFrame3Opt.Checked = True) then Gi_MSX_DisplayFrame := 3;

  Gi_MSX_InterruptDup := IfThen(IntDupeChk.Checked = True, 1, 0);
  Gi_MSX_Auto_Speed := IfThen(AutoSpeedChk.Checked = True, 1, 0);
  Gi_MSX_KeyChange := IfThen(KeyChangeChk.Checked = True, 1, 0);
  Gi_MSX_JoyOn := IfThen(JoyStickChk.Checked = True, 1, 0);
  Gi_MSX_SpaceOn := IfThen(SpaceOnChk.Checked = True, 1, 0);
  Gi_MSX_VDT_ST_FF := IfThen(VdtStFfChk.Checked = True, 1, 0);

  Gs_CAS_FILE := gmsTrim(gmsLeft(CasFileTxt.Text, FLen));
  Gs_ROM_FILE := gmsTrim(gmsLeft(RomFileTxt.Text, FLen));
  Gi_ROM_TYPE := 0;
  if (RomSelt0Opt.Checked = true) then Gi_ROM_TYPE := 0;
  if (RomSelt1Opt.Checked = true) then Gi_ROM_TYPE := 1;
  if (RomSelt2Opt.Checked = true) then Gi_ROM_TYPE := 2;
  if (RomSelt3Opt.Checked = true) then Gi_ROM_TYPE := 3;
  if (RomSelt4Opt.Checked = true) then Gi_ROM_TYPE := 4;
  if (RomSelt5Opt.Checked = true) then Gi_ROM_TYPE := 5;
  Gs_DSK_A_FILE := gmsTrim(gmsLeft(DskAFileTxt.Text, FLen));
  Gs_DSK_B_FILE := gmsTrim(gmsLeft(DskBFileTxt.Text, FLen));
  Gi_DSK_A_ON := IfThen(DskAOnChk.Checked = True, 1, 0);
  Gi_DSK_B_ON := IfThen(DskBOnChk.Checked = True, 1, 0);
  if (Gs_DSK_A_FILE = '') then
    begin
      Gi_DSK_A_ON := 0;
    end
  else
    begin
      if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_A_FILE) <> True) then
        begin
          DskAOnChk.Checked := False;
          Gi_DSK_A_ON := 0;
        end;
    end;
  if (Gs_DSK_B_FILE = '') then
    begin
      Gi_DSK_B_ON := 0;
    end
  else
    begin
      if (gb_MSX_DSK_FILE_EXIST(Gs_DSK_B_FILE) <> True) then
        begin
          DskBOnChk.Checked := False;
          Gi_DSK_B_ON := 0;
        end;
    end;

  giUpdateRegistry('MSX_Machine', Gi_MSX2_Sets);
  giUpdateRegistry('MSX_DiskRom', Gi_DISK_Sets);
  giUpdateRegistry('MSX_CharFont', Gi_CHAR_Sets);
  giUpdateRegistry('MSX_Scale2x', Gi_SC2X_Sets);

  giUpdateRegistry('MSX_IntTimer', Gi_MSX_Int_Timer);
  giUpdateRegistry('MSX_DisplayFrame', Gi_MSX_DisplayFrame);

  giUpdateRegistry('MSX_InterruptDup', Gi_MSX_InterruptDup);
  giUpdateRegistry('MSX_AutoSpeed', Gi_MSX_Auto_Speed);
  giUpdateRegistry('MSX_KeyChange', Gi_MSX_KeyChange);
  giUpdateRegistry('MSX_JoyOn', Gi_MSX_JoyOn);
  giUpdateRegistry('MSX_SpaceOn', Gi_MSX_SpaceOn);
  giUpdateRegistry('MSX_VdtStFf', Gi_MSX_VDT_ST_FF);

  gsUpdateRegistry('MSX_CasFile', Gs_CAS_FILE);
  gsUpdateRegistry('MSX_RomFile', Gs_ROM_FILE);
  giUpdateRegistry('MSX_RomType', Gi_ROM_TYPE);
  gsUpdateRegistry('MSX_DiskAFile', Gs_DSK_A_FILE);
  gsUpdateRegistry('MSX_DiskBFile', Gs_DSK_B_FILE);
end;

end.

