unit msxINT;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

const
  Gi_Z80A_EI_Cnt = 2;

var
  Gi_MSX_Interrupt: ShortInt; //1:인터럽트수행중
  Go_MSX_InterruptBack: Word; //0~65535
  Gi_Z80A_EI_Chk: ShortInt; //1:직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)

  Z80A_INT_MODE: ShortInt;
  Z80A_HALT: ShortInt;

  procedure MSX_INIT_INT;
  procedure gt_NOP;
  procedure gt_HALT;
  procedure gt_DI;
  procedure gt_EI;
  procedure gt_LD_I_A;
  procedure gt_LD_R_A;
  procedure gt_LD_A_I;
  procedure gt_LD_A_R;
  procedure gt_IM_0;
  procedure gt_IM_1;
  procedure gt_IM_2;
  procedure gt_IM_0_1;
  procedure gt_RETI;
  procedure gt_RETN;
  procedure gt_RST_00;
  procedure gt_RST_08;
  procedure gt_RST_10;
  procedure gt_RST_18;
  procedure gt_RST_20;
  procedure gt_RST_28;
  procedure gt_RST_30;
  procedure gt_RST_38;
  procedure gt_RST(iVal: Byte); //Call 명령과 동일

implementation

uses
  msxZ80A;

procedure MSX_INIT_INT;
begin
  Gi_MSX_Interrupt := 0; //1:인터럽트수행중
  Go_MSX_InterruptBack := 0;
  Gi_Z80A_EI_Chk := 0;

  Z80A_INT_MODE := 0;
  Z80A_HALT := 0;
end;

procedure gt_NOP;
begin
  //
end;

procedure gt_HALT;
begin
  //MsgBox ("* SYSTEM HALT !")
end;

procedure gt_DI;
begin
  Z80A_REG_IFF1 := 0;
  Z80A_REG_IFF2 := 0;
end;

procedure gt_EI;
begin
  Z80A_REG_IFF1 := 1;
  Z80A_REG_IFF2 := 1;
end;

procedure gt_LD_I_A;
begin
  Z80A_REG_I := Z80A_REG_A;
end;

procedure gt_LD_R_A;
begin
  Z80A_REG_R := Z80A_REG_A;
end;

procedure gt_LD_A_I;
begin
  //A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
  //If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
  PUT_Z80A_FLAG_N(0); //Not뺄셈
  Z80A_REG_A := Z80A_REG_I;
  //Z80A_FLAG_C = ?; //캐리
  PUT_Z80A_FLAG_H(0); //Not하프캐리
  PUT_Z80A_FLAG_PV(Z80A_REG_IFF2); //오버플로
  PUT_Z80A_FLAG_S(giGet8Sign(Z80A_REG_A)); //Sign
  PUT_Z80A_FLAG_Z(giGet8Zero(Z80A_REG_A)); //Zero
end;

procedure gt_LD_A_R;
begin
  //A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
  //If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
  PUT_Z80A_FLAG_N(0); //Not뺄셈
  Z80A_REG_A := Z80A_REG_R;
  //Z80A_FLAG_C = ?; //캐리
  PUT_Z80A_FLAG_H(0); //하프캐리
  PUT_Z80A_FLAG_PV(Z80A_REG_IFF2); //오버플로
  PUT_Z80A_FLAG_S(giGet8Sign(Z80A_REG_A)); //Sign
  PUT_Z80A_FLAG_Z(giGet8Zero(Z80A_REG_A)); //Zero
end;

procedure gt_IM_0;
begin
  Z80A_INT_MODE := 0;
end;

procedure gt_IM_1;
begin
  Z80A_INT_MODE := 1;
end;

procedure gt_IM_2;
begin
  Z80A_INT_MODE := 2;
end;

procedure gt_IM_0_1;
begin
  // ??? 알려지지않음
end;

procedure gt_RETI;
begin
  //RET
end;

procedure gt_RETN;
begin
  Z80A_REG_IFF1 := Z80A_REG_IFF2;
  //RET
end;

procedure gt_RST_00;
begin
  gt_RST($00);
end;

procedure gt_RST_08;
begin
  gt_RST($08);
end;

procedure gt_RST_10;
begin
  gt_RST($10);
end;

procedure gt_RST_18;
begin
  gt_RST($18);
end;

procedure gt_RST_20;
begin
  gt_RST($20);
end;

procedure gt_RST_28;
begin
  gt_RST($28);
end;

procedure gt_RST_30;
begin
  gt_RST($30);
end;

procedure gt_RST_38;
begin
  gt_RST($38);
end;

procedure gt_RST(iVal: Byte); //Call 명령과 동일
begin
  gt_PUSH_16(((Z80A_REG_PC + 1) And $FFFF));
  Z80A_REG_PC := iVal;
end;

end.

