unit msxIO;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math;

var
  MSX_PORT: Array[0..256-1] Of Byte; //0~255 [0~255]

  //MSX2, CLOCK-IC, 레지스터4비트 - 배터리로백업됨
  //BLOCK0 - 0~12(CLOCK), 13(MODE), 14(TEST-기록전용), 15(RESET-기록전용)
  //LOCK1 - 0~12(ALARM)
  //LOCK2 - 0~12(RAM-1)
  //LOCK3 - 0~12(RAM-2)
  //ODE(0:Clock카운트의정지(초이상),1:개시/0:알람출력Off,1:On/00~11:블럭0~3선택)
  MSX_CLOCK_REG: Array[0..4-1, 0..16-1] Of Byte; //0~255 [0~3, 0~15]

  Gi_MSX_PortWrite: ShortInt; //1:Port Write [Test용]

  procedure MSX_INIT_IO;
  function GET_MSX_PORT(iAddress: Byte): Byte;
  procedure PUT_MSX_PORT(iAddress: Byte; iVal: Byte);
  procedure MSX_VDT_ADDRESS_HIGH;
  procedure gt_PORT_IN_A(iPort: Byte);
  procedure gt_PORT_OUT_A(iPort: Byte);
  procedure gt_PORT_IN(var Reg8: Byte);
  procedure gt_PORT_OUT(Reg8: Byte);
  procedure gt_INI;
  procedure gt_INIR;
  procedure gt_IND;
  procedure gt_INDR;
  procedure gt_OUTI;
  procedure gt_OTIR;
  procedure gt_OUTD;
  procedure gt_OTDR;

implementation

uses
  msxMSX, msxZ80A, msxMEM, msxPPI, msxPSG, msxVDT, msxTBL;

procedure MSX_INIT_IO;
var
  i, j: Integer;
begin
  for i := 0 to 255 do MSX_PORT[i] := 0;

  for i := 0 to 3 do //MSX2
    for j := 0 to 15 do
      MSX_CLOCK_REG[i, j] := 0;
end;

function GET_MSX_PORT(iAddress: Byte): Byte;
var
  GET_PORT, C: Byte;
begin
  GET_PORT := 0; //Default

  //RS-232C (8251A)
  //if (iAddress = $80) then begin end; //Data Read
  //if (iAddress = $81) then begin end; //Status Read

  //프린터
  if (iAddress = $90) then GET_PORT := MSX_PORT[iAddress]; //Status Read (b1)

  //VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
  //MAIN-ROM [6번지]값 참조
  if (iAddress = $98) then //Video 램에서의 Data Read / VRAM data read/write port
    begin
      //if (Gi_MSX_VRAM_IO = 1) then
        //begin
          GET_PORT := MSX_VRAM[Go_MSX_VRAM_ADDRESS];
          Go_MSX_VRAM_ADDRESS := Go_MSX_VRAM_ADDRESS + 1;
          if (GiMSX2 = 0) then //MSX1
            begin
              if (Go_MSX_VRAM_ADDRESS > 16383) then Go_MSX_VRAM_ADDRESS := 0;
            end
          else //MSX2
            begin
              if (Go_MSX_VRAM_ADDRESS > 131071) then Go_MSX_VRAM_ADDRESS := 0;
            end;
        //end;
    end;
  //VDP 포트 #1
  //MAIN-ROM [6번지]값+1
  if (iAddress = $99) then //Status Read / Status register read port
    begin
      if (GiMSX2 = 0) then //MSX1
        begin
          GET_PORT := MSX_VDT_REG_ST; MSX_VDT_ST_REG_FF := 0; //Clear
        end
      else //MSX2
        begin
          if (MSX_VDT_REG[15] = 0) then begin GET_PORT := MSX_VDT_REG_ST; MSX_VDT_ST_REG_FF := 0; end; //Clear //1[4]=0000
          if (MSX_VDT_REG[15] = 1) then begin GET_PORT := MSX_VDT_REG_ST1; MSX_VDT_ST_REG_FH := 0; end; //Clear
          if (MSX_VDT_REG[15] = 2) then GET_PORT := MSX_VDT_REG_ST2;
          if (MSX_VDT_REG[15] = 3) then GET_PORT := MSX_VDT_REG_ST3;
          if (MSX_VDT_REG[15] = 4) then GET_PORT := MSX_VDT_REG_ST4;
          if (MSX_VDT_REG[15] = 5) then GET_PORT := MSX_VDT_REG_ST5;
          if (MSX_VDT_REG[15] = 6) then GET_PORT := MSX_VDT_REG_ST6;
          if (MSX_VDT_REG[15] = 7) then GET_PORT := MSX_VDT_REG_ST7;
          if (MSX_VDT_REG[15] = 8) then GET_PORT := MSX_VDT_REG_ST8;
          if (MSX_VDT_REG[15] = 9) then GET_PORT := MSX_VDT_REG_ST9;
        end;
    end;

  //PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
  if (iAddress = $A2) then //지정된 Register에서 읽기
    begin
      C := MSX_PORT[$A0];
      if (C = 00) then GET_PORT := MSX_PSG_REG[00];
      if (C = 01) then GET_PORT := MSX_PSG_REG[01];
      if (C = 02) then GET_PORT := MSX_PSG_REG[02];
      if (C = 03) then GET_PORT := MSX_PSG_REG[03];
      if (C = 04) then GET_PORT := MSX_PSG_REG[04];
      if (C = 05) then GET_PORT := MSX_PSG_REG[05];
      if (C = 06) then GET_PORT := MSX_PSG_REG[06];
      if (C = 07) then GET_PORT := MSX_PSG_REG[07];
      if (C = 08) then GET_PORT := MSX_PSG_REG[08];
      if (C = 09) then GET_PORT := MSX_PSG_REG[09];
      if (C = 10) then GET_PORT := MSX_PSG_REG[10];
      if (C = 11) then GET_PORT := MSX_PSG_REG[11];
      if (C = 12) then GET_PORT := MSX_PSG_REG[12];
      if (C = 13) then GET_PORT := MSX_PSG_REG[13];
      if (C = 14) then begin SET_MSX_PSG_STATUS; GET_PORT := MSX_PSG_REG[14]; end; //I/O포트A(Read),Cas, Jis, Trigger B, A, R, L, D, U (1:안눌림)
      if (C = 15) then begin GET_PORT := MSX_PSG_REG[15]; end; //I/O포트B(Write)
    end;

  //PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
  if (iAddress = $A8) then //PPI-register A / Primary slot select register
    begin
      GET_PORT := GET_MSX_PPI_REG_A;
    end;
    if (iAddress = $A9) then //PPI-register B / Keyboard matrix row input register
      begin
        SET_MSX_KEY_STATUS;
        GET_PORT := MSX_PPI_REG_B; //Keyboard matrix row input register
      end;
    if (iAddress = $AA) then //PPI-register C / Keyboard and cassette interface
      begin
        GET_PORT := GET_MSX_PPI_REG_C;
      end;

    if (iAddress = $B5) then //지정된 Clock 블록+Reg 읽기
      begin
        C := MSX_PORT[$B4];
        if (C <= 13) then GET_PORT := MSX_CLOCK_REG[IfThen(C <= 12, MSX_CLOCK_REG[0, 13] And 3, 0), C];
      end;

  Result := GET_PORT;
end;

procedure PUT_MSX_PORT(iAddress: Byte; iVal: Byte);
var
  C, iBit, iReg, iRegH: Byte;
begin
  //RS-232C (8251A)
  //if (iAddress = $80) then begin end; //Data Write
  //if (iAddress = $81) then begin end; //Mode Set

  //프린터
  if (iAddress = $90) then MSX_PORT[iAddress] := iVal; //Status Write (b0)
  //if (iAddress = $91) then begin end; //Print Data

  //VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
  //MAIN-ROM [7번지]값 참조
  if (iAddress = $98) then //Video 램으로의 Data Write / VRAM data read/write port
    begin
      //if (Gi_MSX_VRAM_IO = 2) then
        //begin
          MSX_VRAM[Go_MSX_VRAM_ADDRESS] := iVal;
          Go_MSX_VRAM_ADDRESS := Go_MSX_VRAM_ADDRESS + 1;
          if (GiMSX2 = 0) then //MSX1
            begin
              if (Go_MSX_VRAM_ADDRESS > 16383) then Go_MSX_VRAM_ADDRESS := 0;
            end
          else //MSX2
            begin
              if (Go_MSX_VRAM_ADDRESS > 131071) then Go_MSX_VRAM_ADDRESS := 0;
            end;
          Gi_MSX_Screen_Out := 1; //화면표시작업
        //end;
    end;
  //VDP 포트 #1
  //MAIN-ROM [7번지]값+1
  if (iAddress = $99) then //Command, Address Set / VDP register write port (bit 7=1 in second write), VRAM address register (bit 7=0 in second write, bit 6: read/write access (0=read))
    begin
      if (Gi_MSX_VRAM_Flg = 0) then //첫번째전송
        begin
          Gi_MSX_VRAM_Flg := 1;
          MSX_PORT[iAddress] := iVal;
        end
      else                          //두번째전송
        begin
          Gi_MSX_VRAM_Flg := 0;
          C := MSX_PORT[iAddress];
          if ((iVal And 128) > 0) then //1[1]=1 : 레지스트리에 기록
            begin
              if (GiMSX2 = 0) then //MSX1
                begin
                  iReg := (iVal And 7); //6[3] - Reg번호
                end
              else //MSX2
                begin
                  iReg := (iVal And 63); //3[6] - Reg번호
                end;
              MSX_VDT_REG[iReg] := C;
              if ((iReg = 00) Or (iReg = 01)) then MSX_SCREEN_MODE_SET; //MSX1
              if ((iReg = 08) Or (iReg = 09)) then MSX_SCREEN_MODE_SET; //MSX2
              if (iReg = 02) then MSX_SCREEN_MODE_SET2; //MSX2
              if (iReg = 08) then MSX_SCREEN_MODE_SET8; //MSX2
              if (iReg = 09) then MSX_SCREEN_MODE_SET9; //MSX2
              if (iReg = 14) then MSX_VDT_ADDRESS_HIGH; //MSX2
              if (iReg = 32) then MSX_VDT_CMD_REG32_SET;
              if (iReg = 33) then MSX_VDT_CMD_REG33_SET;
              if (iReg = 34) then MSX_VDT_CMD_REG34_SET;
              if (iReg = 35) then MSX_VDT_CMD_REG35_SET;
              if (iReg = 36) then MSX_VDT_CMD_REG36_SET;
              if (iReg = 37) then MSX_VDT_CMD_REG37_SET;
              if (iReg = 38) then MSX_VDT_CMD_REG38_SET;
              if (iReg = 39) then MSX_VDT_CMD_REG39_SET;
              if (iReg = 40) then MSX_VDT_CMD_REG40_SET;
              if (iReg = 41) then MSX_VDT_CMD_REG41_SET;
              if (iReg = 42) then MSX_VDT_CMD_REG42_SET;
              if (iReg = 43) then MSX_VDT_CMD_REG43_SET;
              if (iReg = 44) then MSX_VDT_CMD_REG44_SET;
              if (iReg = 45) then MSX_VDT_CMD_REG45_SET;
              if (iReg = 46) then MSX_VDT_CMD_REG46_SET;
              Gi_MSX_Screen_Out := 1; //화면표시작업
            end
          else                  //1[1]=0 : 상위 메모리번지 지정
            begin
              iRegH := (iVal And 63); //3[6] - 상위번지(VRAM), 63=3Fh=0011 1111
              if ((iVal And 64) = 0) then //Read  : 2[1]=0, 00?? ????
                begin
                  Gi_MSX_VRAM_IO := 1; //Read
                end
              else                  //Write : 2[1]=1, 01?? ????
                begin
                  Gi_MSX_VRAM_IO := 2; //Write
                end;
              Go_MSX_VRAM_ADDRESS := goGetIntHLToLng(iRegH, C);
              if (GiMSX2 = 1) then MSX_VDT_ADDRESS_HIGH; //MSX2 - 상위번지
            end;
        end;
    end;
  //VDP 포트 #2
  //MAIN-ROM [7번지]값+2
  if (iAddress = $9A) then //팔레트 레지스터에의 기입
    begin
      if (GiMSX2 = 1) then //MSX2
        begin
          C := (MSX_VDT_REG[16] And 15); //1[4]=0000
          if (Gi_MSX2_VRAM_Flg = 0) then
            begin
              MSX_VDT_REG_PAL_Red[C] := Gi_M_Table36[Gi_D_Table16[iVal And $70]]; //2[3]
              MSX_VDT_REG_PAL_Blue[C] := Gi_M_Table36[iVal And 7]; //6[3]
              Gi_MSX2_VRAM_Flg := 1;
            end
          else
            begin
              MSX_VDT_REG_PAL_Green[C] := Gi_M_Table36[iVal And 7]; //6[3]
              MSX_VDT_REG[16] := ((MSX_VDT_REG[16] + 1) And 15);
              Gi_MSX2_VRAM_Flg := 0;
            end;
          MSX_COLOR_PALETTE(C, MSX_VDT_REG_PAL_Red[C], MSX_VDT_REG_PAL_Green[C], MSX_VDT_REG_PAL_Blue[C]);
          Gi_MSX_Screen_Out := 1; //화면표시작업
        end;
    end;
   //VDP 포트 #3
   //MAIN-ROM [7번지]값+3
   if (iAddress = $9B) then //간접지정된 레지스터에의 기입
     begin
       if (GiMSX2 = 1) then //MSX2
         begin
           iReg := (MSX_VDT_REG[17] And 63);
           if ((iReg <> 17) And (iReg <= 46)) then MSX_VDT_REG[iReg] := iVal; //Reg17-금지
           if ((iReg = 00) Or (iReg = 01)) then MSX_SCREEN_MODE_SET; //MSX1
           if (iReg = 02) then MSX_SCREEN_MODE_SET2; //MSX2
           if (iReg = 08) then MSX_SCREEN_MODE_SET8; //MSX2
           if (iReg = 09) then MSX_SCREEN_MODE_SET9; //MSX2
           if (iReg = 14) then MSX_VDT_ADDRESS_HIGH; //MSX2
           if (iReg = 32) then MSX_VDT_CMD_REG32_SET;
           if (iReg = 33) then MSX_VDT_CMD_REG33_SET;
           if (iReg = 34) then MSX_VDT_CMD_REG34_SET;
           if (iReg = 35) then MSX_VDT_CMD_REG35_SET;
           if (iReg = 36) then MSX_VDT_CMD_REG36_SET;
           if (iReg = 37) then MSX_VDT_CMD_REG37_SET;
           if (iReg = 38) then MSX_VDT_CMD_REG38_SET;
           if (iReg = 39) then MSX_VDT_CMD_REG39_SET;
           if (iReg = 40) then MSX_VDT_CMD_REG40_SET;
           if (iReg = 41) then MSX_VDT_CMD_REG41_SET;
           if (iReg = 42) then MSX_VDT_CMD_REG42_SET;
           if (iReg = 43) then MSX_VDT_CMD_REG43_SET;
           if (iReg = 44) then MSX_VDT_CMD_REG44_SET;
           if (iReg = 45) then MSX_VDT_CMD_REG45_SET;
           if (iReg = 46) then MSX_VDT_CMD_REG46_SET;
           if ((MSX_VDT_REG[17] And 128) = 0) then //1[2]=10 -> Not Auto Increment
             begin
               MSX_VDT_REG[17] := (iReg + 1); //1[2]=00 -> Auto Increment
             end;
           Gi_MSX_Screen_Out := 1; //화면표시작업
         end;
     end;

  //PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
  if (iAddress = $A0) then //Read Write Register 번호지정
    begin
      MSX_PORT[iAddress] := iVal; //Reg(iVal)번을 포트(A0h)로 출력
    end;
  if (iAddress = $A1) then //지정된 Register로 기록
    begin
      C := MSX_PORT[$A0];
      if (C = 00) then begin MSX_PSG_REG[00] := iVal; MSX_PSG_REG_R00_WRITE; end;
      if (C = 01) then begin MSX_PSG_REG[01] := iVal; MSX_PSG_REG_R01_WRITE; end;
      if (C = 02) then begin MSX_PSG_REG[02] := iVal; MSX_PSG_REG_R02_WRITE; end;
      if (C = 03) then begin MSX_PSG_REG[03] := iVal; MSX_PSG_REG_R03_WRITE; end;
      if (C = 04) then begin MSX_PSG_REG[04] := iVal; MSX_PSG_REG_R04_WRITE; end;
      if (C = 05) then begin MSX_PSG_REG[05] := iVal; MSX_PSG_REG_R05_WRITE; end;
      if (C = 06) then begin MSX_PSG_REG[06] := iVal; MSX_PSG_REG_R06_WRITE; end;
      if (C = 07) then begin MSX_PSG_REG[07] := iVal; MSX_PSG_REG_R07_WRITE; end;
      if (C = 08) then begin MSX_PSG_REG[08] := iVal; MSX_PSG_REG_R08_WRITE; end;
      if (C = 09) then begin MSX_PSG_REG[09] := iVal; MSX_PSG_REG_R09_WRITE; end;
      if (C = 10) then begin MSX_PSG_REG[10] := iVal; MSX_PSG_REG_R10_WRITE; end;
      if (C = 11) then begin MSX_PSG_REG[11] := iVal; MSX_PSG_REG_R11_WRITE; end;
      if (C = 12) then begin MSX_PSG_REG[12] := iVal; MSX_PSG_REG_R12_WRITE; end;
      if (C = 13) then begin MSX_PSG_REG[13] := iVal; MSX_PSG_REG_R13_WRITE; end;
      if (C = 14) then MSX_PSG_REG[14] := iVal; //I/O포트A(Read)
      if (C = 15) then MSX_PSG_REG[15] := iVal; //I/O포트B(Write)
    end;

  //PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
  if (iAddress = $A8) then //PPI-register A / Primary slot select register
    begin
      Gi_MEM_PAGE3 := ((iVal And 192) shr 6); //7~6Bit
      Gi_MEM_PAGE2 := ((iVal And 48) shr 4);  //5~4Bit
      Gi_MEM_PAGE1 := ((iVal And 12) shr 2);  //3~2Bit
      Gi_MEM_PAGE0 := ((iVal And 3));        //1~0Bit
    end;
  if (iAddress = $AA) then //PPI-register C / Keyboard and cassette interface
    begin
      PUT_MSX_PPI_REG_C(iVal);
    end;
  if (iAddress = $AB) then //Mode Set / Command register : bit0<-1
    begin
      iBit := ((iVal And 14) shr 1); //5[3]
      if ((iVal And 1) = 1) then //1[1]=1 Set
        begin
          PUT_MSX_PPI_REG_C(((GET_MSX_PPI_REG_C Or Gi_B_Table[iBit])));
        end
      else //Res
        begin
          PUT_MSX_PPI_REG_C(((GET_MSX_PPI_REG_C And Gi_NB_Table[iBit])));
        end;
    end;

  //MSX2 - Clock
  if (iAddress = $B4) then //Clock Reg 지정
    begin
      MSX_PORT[$B4] := (iVal And 15);
    end;
  if (iAddress = $B5) then //지정된 Clock 블록+Reg 기록
    begin
      C := MSX_PORT[$B4];
      if (C <= 15) then MSX_CLOCK_REG[IfThen(C <= 12, MSX_CLOCK_REG[0, 13] And 3, 0), C] := iVal;
    end;

  //MSX2 - Memory Mapper registers
  if (GiMSX2 = 1) then //MSX2
    begin
      if (iAddress = $FC) then
        begin
          MSX_PORT[$FC] := iVal;
          MSX_MEMORY_CHANGE(0, iVal); //Memory Page0[2] Change
        end;
      if (iAddress = $FD) then
        begin
          MSX_PORT[$FD] := iVal;
          MSX_MEMORY_CHANGE(1, iVal); //Memory Page1[2] Change
        end;
      if (iAddress = $FE) then
        begin
          MSX_PORT[$FE] := iVal;
          MSX_MEMORY_CHANGE(2, iVal); //Memory Page2[2] Change
        end;
      if (iAddress = $FF) then
        begin
          MSX_PORT[$FF] := iVal;
          MSX_MEMORY_CHANGE(3, iVal); //Memory Page3[2] Change
        end;
    end;
end;

procedure MSX_VDT_ADDRESS_HIGH;
begin
  Go_MSX_VRAM_ADDRESS := (Go_MSX_VRAM_ADDRESS And 16383) + ((MSX_VDT_REG[14] And 7) * 16384); //Bit16~14, 3FFFh
end;

procedure gt_PORT_IN_A(iPort: Byte);
begin
  Z80A_REG_A := GET_MSX_PORT(iPort);
end;

procedure gt_PORT_OUT_A(iPort: Byte);
begin
  PUT_MSX_PORT(iPort, Z80A_REG_A);
end;

procedure gt_PORT_IN(var Reg8: Byte);
begin
  PUT_Z80A_FLAG_N(0); //Not뺄셈
  Reg8 := GET_MSX_PORT(Z80A_REG_C);
  //Z80A_FLAG_C := ?; //캐리
  PUT_Z80A_FLAG_H(0); //Not하프캐리
  PUT_Z80A_FLAG_PV(Gi_P_Table[Reg8]); //1:짝수,0:홀수
  PUT_Z80A_FLAG_S(giGet8Sign(Reg8)); //Sign
  PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)); //Zero
end;

procedure gt_PORT_OUT(Reg8: Byte);
begin
  PUT_MSX_PORT(Z80A_REG_C, Reg8);
end;

procedure gt_INI;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
  PUT_MSX_MEMORY(GET_Z80A_REG_HL, GET_MSX_PORT(Z80A_REG_C));
  PUT_Z80A_REG_HL(((GET_Z80A_REG_HL + 1) And $FFFF));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  PUT_Z80A_FLAG_Z(IfThen(Z80A_REG_B = 0, 1, 0)); //오버플로
end;

procedure gt_INIR;
label
  LoopProc;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
LoopProc: ;
  PUT_MSX_MEMORY(GET_Z80A_REG_HL, GET_MSX_PORT(Z80A_REG_C));
  PUT_Z80A_REG_HL(((GET_Z80A_REG_HL + 1) And $FFFF));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  if (Z80A_REG_B <> 0) then
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 21;
      goto LoopProc;
    end
  else
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 16;
    end;
  PUT_Z80A_FLAG_Z(1); //Zero
end;

procedure gt_IND;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
  PUT_MSX_MEMORY(GET_Z80A_REG_HL, GET_MSX_PORT(Z80A_REG_C));
  PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL - 1));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  PUT_Z80A_FLAG_Z(IfThen(Z80A_REG_B = 0, 1, 0)); //오버플로
end;

procedure gt_INDR;
label
  LoopProc;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
LoopProc: ;
  PUT_MSX_MEMORY(GET_Z80A_REG_HL, GET_MSX_PORT(Z80A_REG_C));
  PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL - 1));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  if (Z80A_REG_B <> 0) then
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 21;
      goto LoopProc;
    end
  else
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 16;
    end;
  PUT_Z80A_FLAG_Z(1); //Zero
end;

procedure gt_OUTI;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
  PUT_MSX_PORT(Z80A_REG_C, GET_MSX_MEMORY(GET_Z80A_REG_HL));
  PUT_Z80A_REG_HL(((GET_Z80A_REG_HL + 1) And $FFFF));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  PUT_Z80A_FLAG_Z(IfThen(Z80A_REG_B = 0, 1, 0)); //오버플로
end;

procedure gt_OTIR;
label
  LoopProc;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
LoopProc: ;
  PUT_MSX_PORT(Z80A_REG_C, GET_MSX_MEMORY(GET_Z80A_REG_HL));
  PUT_Z80A_REG_HL(((GET_Z80A_REG_HL + 1) And $FFFF));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  if (Z80A_REG_B <> 0) then
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 21;
      goto LoopProc;
    end
  else
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 16;
    end;
  PUT_Z80A_FLAG_Z(1); //Zero
end;

procedure gt_OUTD;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
  PUT_MSX_PORT(Z80A_REG_C, GET_MSX_MEMORY(GET_Z80A_REG_HL));
  PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL - 1));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  PUT_Z80A_FLAG_Z(IfThen(Z80A_REG_B = 0, 1, 0)); //오버플로
end;

procedure gt_OTDR;
label
  LoopProc;
begin
  PUT_Z80A_FLAG_N(1); //뺄셈
LoopProc: ;
  PUT_MSX_PORT(Z80A_REG_C, GET_MSX_MEMORY(GET_Z80A_REG_HL));
  PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL - 1));
  Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
  if (Z80A_REG_B <> 0) then
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 21;
      goto LoopProc;
    end
  else
    begin
      Gi_Z80A_CLOCK := Gi_Z80A_CLOCK + 16;
    end;
  PUT_Z80A_FLAG_Z(1); //Zero
end;

end.

