unit msxMI;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM, msxMI_CB, msxMI_DD, msxMI_ED, msxMI_FD;

procedure EXEC_Z80A_CODE;
var
  idx: Byte; //0~255
  iSz: Byte;
  Reg8: Byte;
  Reg16: Word;
  PC1p: Word;

begin
  Z80A_REG_R := Z80A_REG_R + 1; Z80A_REG_R := Z80A_REG_R And 127; //0111 1111

  idx := GET_MSX_MEMORY(Z80A_REG_PC);
  iSz := 1;

  PC1p := ((Z80A_REG_PC + 1) And $FFFF);

  Case (idx) of
    $00: //NOP
      begin
        Gi_Z80A_CLOCK := 4;
        gt_NOP;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $01: //LD BC,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        PUT_Z80A_REG_BC(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $02: //LD (BC),A
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_BC, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $03: //INC BC
      begin
        Gi_Z80A_CLOCK := 6;
        gt_INC_16TO8(GET_Z80A_REG_BC, Z80A_REG_B, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $04: //INC B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_B, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $05: //DEC B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_B, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $06: //LD B,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_B := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $07: //RLCA
      begin
        Gi_Z80A_CLOCK := 4;
        gt_RLCA;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $08: //EX AF,AF
      begin
        Gi_Z80A_CLOCK := 4;
        Reg8 := Z80A_REG_A; Z80A_REG_A := Z80A_REG_A2; Z80A_REG_A2 := Reg8;
        Reg8 := Z80A_REG_F; Z80A_REG_F := Z80A_REG_F2; Z80A_REG_F2 := Reg8;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $09: //ADD HL,BC
      begin
        Gi_Z80A_CLOCK := 11;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_BC, Z80A_REG_H, Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0A: //LD A,(BC)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_A := GET_MSX_MEMORY(GET_Z80A_REG_BC);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0B: //DEC BC
      begin
        Gi_Z80A_CLOCK := 6;
        gt_DEC_16TO8(GET_Z80A_REG_BC, Z80A_REG_B, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0C: //INC C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_C, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0D: //DEC C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_C, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0E: //LD C,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_C := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $0F: //RRCA
      begin
        Gi_Z80A_CLOCK := 4;
        gt_RRCA;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $10: //DJNZ idx
      begin
        iSz := 2;
        Z80A_REG_B := giGetIntToInt(Z80A_REG_B - 1);
        if (Z80A_REG_B <> 0) then
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
            Gi_Z80A_CLOCK := 13;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 8;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $11: //LD DE,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        PUT_Z80A_REG_DE(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $12: //LD (DE),A
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_DE, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $13: //INC DE
      begin
        Gi_Z80A_CLOCK := 6;
        gt_INC_16TO8(GET_Z80A_REG_DE, Z80A_REG_D, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $14: //INC D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_D, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $15: //DEC D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_D, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $16: //LD D,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_D := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $17: //RLA
      begin
        Gi_Z80A_CLOCK := 4;
        gt_RLA;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $18: //JR idx
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 12;
        Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $19: //ADD HL,DE
      begin
        Gi_Z80A_CLOCK := 11;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_DE, Z80A_REG_H, Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1A: //LD A,(DE)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_A := GET_MSX_MEMORY(GET_Z80A_REG_DE);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1B: //DEC DE
      begin
        Gi_Z80A_CLOCK := 6;
        gt_DEC_16TO8(GET_Z80A_REG_DE, Z80A_REG_D, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1C: //INC E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_E, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1D: //DEC E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_E, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1E: //LD E,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_E := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $1F: //RRA
      begin
        Gi_Z80A_CLOCK := 4;
        gt_RRA;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $20: //JR NZ,idx
      begin
        iSz := 2;
        if (GET_Z80A_FLAG_Z = 0) then
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
            Gi_Z80A_CLOCK := 12;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 7;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $21: //LD HL,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        PUT_Z80A_REG_HL(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $22: //LD (nn),HL
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 16;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $23: //INC HL
      begin
        Gi_Z80A_CLOCK := 6;
        gt_INC_16TO8(GET_Z80A_REG_HL, Z80A_REG_H, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $24: //INC H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_H, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $25: //DEC H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_H, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $26: //LD H,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_H := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $27: //DAA
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DAA;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $28: //JR Z,idx
      begin
        iSz := 2;
        if (GET_Z80A_FLAG_Z = 1) then
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
            Gi_Z80A_CLOCK := 12;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 7;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $29: //ADD HL,HL
      begin
        Gi_Z80A_CLOCK := 11;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_HL, Z80A_REG_H, Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2A: //LD HL,(nn)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 16;
        PUT_Z80A_REG_HL(GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p)));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2B: //DEC HL
      begin
        Gi_Z80A_CLOCK := 6;
        gt_DEC_16TO8(GET_Z80A_REG_HL, Z80A_REG_H, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2C: //INC L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_L, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2D: //DEC L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_L, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2E: //LD L,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_L := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $2F: //CPL
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CPL;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $30: //JR NC,idx
      begin
        iSz := 2;
        if (GET_Z80A_FLAG_C = 0) then
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
            Gi_Z80A_CLOCK := 12;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 7;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $31: //LD SP,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        Z80A_REG_SP := GET_MSX_MEMORY_16(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $32: //LD (nn),A
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 13;
        PUT_MSX_MEMORY(GET_MSX_MEMORY_16(PC1p), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $33: //INC SP
      begin
        Gi_Z80A_CLOCK := 6;
        gt_INC_16TO16(Z80A_REG_SP, Z80A_REG_SP);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $34: //INC (HL)
      begin
        Gi_Z80A_CLOCK := 11;
        gt_INC_8TO8(GET_MSX_MEMORY(GET_Z80A_REG_HL), Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $35: //DEC (HL)
      begin
        Gi_Z80A_CLOCK := 11;
        gt_DEC_8TO8(GET_MSX_MEMORY(GET_Z80A_REG_HL), Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $36: //LD (HL),n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 10;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $37: //SCF
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SCF;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $38: //JR C,idx
      begin
        iSz := 2;
        if (GET_Z80A_FLAG_C = 1) then
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz + giGetIdx8(GET_MSX_MEMORY(PC1p)));
            Gi_Z80A_CLOCK := 12;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 7;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $39: //ADD HL,SP
      begin
        Gi_Z80A_CLOCK := 11;
        gt_ADD_16TO8(GET_Z80A_REG_HL, Z80A_REG_SP, Z80A_REG_H, Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3A: //LD A,(nn)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 13;
        Z80A_REG_A := GET_MSX_MEMORY(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3B: //DEC SP
      begin
        Gi_Z80A_CLOCK := 6;
        gt_DEC_16TO16(Z80A_REG_SP, Z80A_REG_SP);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3C: //INC A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_INC_8TO8(Z80A_REG_A, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3D: //DEC A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DEC_8TO8(Z80A_REG_A, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3E: //LD A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_A := GET_MSX_MEMORY(PC1p);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $3F: //CCF
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CCF;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $40: //LD B,B
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_B := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $41: //LD B,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $42: //LD B,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $43: //LD B,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $44: //LD B,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $45: //LD B,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $46: //LD B,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_B := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $47: //LD B,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_B := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $48: //LD C,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $49: //LD C,C
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_C := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4A: //LD C,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4B: //LD C,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4C: //LD C,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4D: //LD C,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4E: //LD C,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_C := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $4F: //LD C,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_C := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $50: //LD D,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $51: //LD D,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $52: //LD D,D
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_D := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $53: //LD D,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $54: //LD D,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $55: //LD D,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $56: //LD D,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_D := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $57: //LD D,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_D := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $58: //LD E,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $59: //LD E,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5A: //LD E,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5B: //LD E,E
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_E := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5C: //LD E,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5D: //LD E,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5E: //LD E,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_E := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $5F: //LD E,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_E := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $60: //LD H,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $61: //LD H,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $62: //LD H,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $63: //LD H,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $64: //LD H,H
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_H := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $65: //LD H,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $66: //LD H,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_H := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $67: //LD H,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_H := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $68: //LD L,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $69: //LD L,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6A: //LD L,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6B: //LD L,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6C: //LD L,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6D: //LD L,L
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_L := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6E: //LD L,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_L := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $6F: //LD L,A
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_L := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $70: //LD (HL),B
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $71: //LD (HL),C
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $72: //LD (HL),D
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $73: //LD (HL),E
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $74: //LD (HL),H
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $75: //LD (HL),L
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $76: //HALT
      begin
        gt_HALT;
        if (Z80A_HALT = 0) then
          begin
            Gi_Z80A_CLOCK := 4;
            EXEC_Z80A_ADD_PC(0, iSz);
          end
        else
          begin
            Z80A_HALT := 0;
            Gi_Z80A_CLOCK := 4;
            EXEC_Z80A_ADD_PC(iSz, 0);
          end;
      end;
    $77: //LD (HL),A
      begin
        Gi_Z80A_CLOCK := 7;
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $78: //LD A,B
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_B;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $79: //LD A,C
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_C;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7A: //LD A,D
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_D;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7B: //LD A,E
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_E;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7C: //LD A,H
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_H;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7D: //LD A,L
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_A := Z80A_REG_L;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7E: //LD A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        Z80A_REG_A := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $7F: //LD A,A
      begin
        Gi_Z80A_CLOCK := 4;
      //Z80A_REG_A := Z80A_REG_A;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $80: //ADD A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $81: //ADD A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $82: //ADD A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $83: //ADD A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $84: //ADD A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $85: //ADD A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $86: //ADD A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $87: //ADD A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $88: //ADC A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $89: //ADC A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8A: //ADC A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8B: //ADC A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8C: //ADC A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8D: //ADC A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8E: //ADC A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $8F: //ADC A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_ADD_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $90: //SUB A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $91: //SUB A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $92: //SUB A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $93: //SUB A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $94: //SUB A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $95: //SUB A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $96: //SUB A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $97: //SUB A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $98: //SBC A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $99: //SBC A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9A: //SBC A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9B: //SBC A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9C: //SBC A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9D: //SBC A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9E: //SBC A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $9F: //SBC A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_SUB_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A0: //AND A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A1: //AND A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A2: //AND A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A3: //AND A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A4: //AND A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A5: //AND A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A6: //AND A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_AND_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A7: //AND A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_AND_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A8: //XOR A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $A9: //XOR A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AA: //XOR A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AB: //XOR A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AC: //XOR A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AD: //XOR A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AE: //XOR A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_XOR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $AF: //XOR A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_XOR_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B0: //OR A,B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_B, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B1: //OR A,C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_C, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B2: //OR A,D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_D, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B3: //OR A,E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_E, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B4: //OR A,H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_H, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B5: //OR A,L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_L, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B6: //OR A,(HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_OR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GET_Z80A_REG_HL), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B7: //OR A,A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_OR_8TO8(Z80A_REG_A, Z80A_REG_A, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B8: //CP B
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $B9: //CP C
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BA: //CP D
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BB: //CP E
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BC: //CP H
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BD: //CP L
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BE: //CP (HL)
      begin
        Gi_Z80A_CLOCK := 7;
        gt_CP(GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $BF: //CP A
      begin
        Gi_Z80A_CLOCK := 4;
        gt_CP(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $C0: //RET NZ
      begin
        if (GET_Z80A_FLAG_Z = 0) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $C1: //POP BC
      begin
        Gi_Z80A_CLOCK := 10;
        gt_POP_16TO2(Z80A_REG_B, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $C2: //JP NZ,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_Z = 0) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $C3: //JP nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $C4: //CALL NZ,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_Z = 0) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $C5: //PUSH BC
      begin
        Gi_Z80A_CLOCK := 11;
        gt_PUSH_16(GET_Z80A_REG_BC);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $C6: //ADD A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $C7: //RST 00H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_00;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $C8: //RET Z
      begin
        if (GET_Z80A_FLAG_Z = 1) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $C9: //RET
      begin
        Gi_Z80A_CLOCK := 10;
        gt_POP_16(Z80A_REG_PC);
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $CA: //JP Z,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_Z = 1) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $CB: //CB - Bit instructions
      begin
        Z80A_REG_R := Z80A_REG_R + 1; Z80A_REG_R := (Z80A_REG_R And 127); //0111 1111
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_CB;
      end;
    $CC: //CALL Z,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_Z = 1) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $CD: //CALL nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 17;
        gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
        Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $CE: //ADC A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $CF: //RST 08H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_08;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $D0: //RET NC
      begin
        if (GET_Z80A_FLAG_C = 0) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $D1: //POP DE
      begin
        Gi_Z80A_CLOCK := 10;
        gt_POP_16TO2(Z80A_REG_D, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $D2: //JP NC,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_C = 0) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $D3: //OUT (p),A
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 11;
        gt_PORT_OUT_A(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $D4: //CALL NC,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_C = 0) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $D5: //PUSH DE
      begin
        Gi_Z80A_CLOCK := 11;
        gt_PUSH_16(GET_Z80A_REG_DE);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $D6: //SUB A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $D7: //RST 10H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_10;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $D8: //RET C
      begin
        if (GET_Z80A_FLAG_C = 1) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $D9: //EXX
      begin
        Gi_Z80A_CLOCK := 4;
        Reg8 := Z80A_REG_B; Z80A_REG_B := Z80A_REG_B2; Z80A_REG_B2 := Reg8;
        Reg8 := Z80A_REG_C; Z80A_REG_C := Z80A_REG_C2; Z80A_REG_C2 := Reg8;
        Reg8 := Z80A_REG_D; Z80A_REG_D := Z80A_REG_D2; Z80A_REG_D2 := Reg8;
        Reg8 := Z80A_REG_E; Z80A_REG_E := Z80A_REG_E2; Z80A_REG_E2 := Reg8;
        Reg8 := Z80A_REG_H; Z80A_REG_H := Z80A_REG_H2; Z80A_REG_H2 := Reg8;
        Reg8 := Z80A_REG_L; Z80A_REG_L := Z80A_REG_L2; Z80A_REG_L2 := Reg8;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $DA: //JP C,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_C = 1) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $DB: //IN A,(p)
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 11;
        gt_PORT_IN_A(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $DC: //CALL C,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_C = 1) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $DD: //DD - IX instructions
      begin
        Z80A_REG_R := Z80A_REG_R + 1; Z80A_REG_R := (Z80A_REG_R And 127); //0111 1111
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_DD;
      end;
    $DE: //SBC A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $DF: //RST 18H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_18;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $E0: //RET PO
      begin
        if (GET_Z80A_FLAG_PV = 0) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $E1: //POP HL
      begin
        Gi_Z80A_CLOCK := 10;
        gt_POP_16TO2(Z80A_REG_H, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $E2: //JP PO,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_PV = 0) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $E3: //EX (SP),HL
      begin
        Gi_Z80A_CLOCK := 19;
        Reg16 := GET_MSX_MEMORY_16(Z80A_REG_SP);
        PUT_MSX_MEMORY_16(Z80A_REG_SP, GET_Z80A_REG_HL);
        PUT_Z80A_REG_HL(Reg16);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $E4: //CALL PO,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_PV = 0) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $E5: //PUSH HL
      begin
        Gi_Z80A_CLOCK := 11;
        gt_PUSH_16(GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $E6: //AND A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_AND_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $E7: //RST 20H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_20;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $E8: //RET PE
      begin
        if (GET_Z80A_FLAG_PV = 1) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $E9: //JP (HL)
      begin
        Gi_Z80A_CLOCK := 4;
        Z80A_REG_PC := GET_Z80A_REG_HL; //PC<-HL
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $EA: //JP PE,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_PV = 1) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $EB: //EX DE,HL
      begin
        Gi_Z80A_CLOCK := 4;
        Reg8 := Z80A_REG_D; Z80A_REG_D := Z80A_REG_H; Z80A_REG_H := Reg8;
        Reg8 := Z80A_REG_E; Z80A_REG_E := Z80A_REG_L; Z80A_REG_L := Reg8;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $EC: //CALL PE,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_PV = 1) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $ED: //ED - Extended instructions
      begin
        Z80A_REG_R := Z80A_REG_R + 1; Z80A_REG_R := (Z80A_REG_R And 127); //0111 1111
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_ED;
      end;
    $EE: //XOR A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_XOR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $EF: //RST 28H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_28;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $F0: //RET P
      begin
        if (GET_Z80A_FLAG_S = 0) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $F1: //POP AF
      begin
        Gi_Z80A_CLOCK := 10;
        gt_POP_16TO2(Z80A_REG_A, Z80A_REG_F);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $F2: //JP P,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_S = 0) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $F3: //DI
      begin
        Gi_Z80A_CLOCK := 4;
        gt_DI;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $F4: //CALL P,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_S = 0) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $F5: //PUSH AF
      begin
        Gi_Z80A_CLOCK := 11;
        gt_PUSH_16(GET_Z80A_REG_AF);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $F6: //OR A,n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_OR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(PC1p), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $F7: //RST 30H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_30;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $F8: //RET M
      begin
        if (GET_Z80A_FLAG_S = 1) then
          begin
            gt_POP_16(Z80A_REG_PC);
            Gi_Z80A_CLOCK := 11;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 5;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
    $F9: //LD SP,HL
      begin
        Gi_Z80A_CLOCK := 6;
        Z80A_REG_SP := GET_Z80A_REG_HL;
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $FA: //JP M,nn
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 10;
        if (GET_Z80A_FLAG_S = 1) then
          begin
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $FB: //EI
      begin
        Gi_Z80A_CLOCK := 4;
        gt_EI;
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $FC: //CALL M,nn
      begin
        iSz := 3;
        if (GET_Z80A_FLAG_S = 1) then
          begin
            gt_PUSH_16(goGetLngToLng(Z80A_REG_PC + iSz));
            Z80A_REG_PC := GET_MSX_MEMORY_16(PC1p);
            Gi_Z80A_CLOCK := 17;
          end
        else
          begin
            Z80A_REG_PC := goGetLngToLng(Z80A_REG_PC + iSz);
            Gi_Z80A_CLOCK := 10;
          end;
        EXEC_Z80A_ADD_PC(0, iSz); //3
      end;
    $FD: //FD - IY instruction
      begin
        Z80A_REG_R := Z80A_REG_R + 1; Z80A_REG_R := (Z80A_REG_R And 127); //0111 1111
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_FD;
      end;
    $FE: //CP n
      begin
        iSz := 2;
        Gi_Z80A_CLOCK := 7;
        gt_CP(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz, 0);
      end;
    $FF: //RST 38H
      begin
        Gi_Z80A_CLOCK := 11;
        gt_RST_38;
        EXEC_Z80A_ADD_PC(0, iSz); //1
      end;
  Else //실행안됨
  End;
end;

end.

