unit msxMI_CB;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE_CB;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM;

procedure EXEC_Z80A_CODE_CB;
var
  idx: Byte; //0~255
  iSz: Byte;
  Reg8: Byte;

begin
  idx := GET_MSX_MEMORY(Z80A_REG_PC);
  iSz := 2;

  Gi_Z80A_CLOCK := 8;

  Case (idx) of
    $00: //RLC B
      begin
        gt_RLC(Z80A_REG_B, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $01: //RLC C
      begin
        gt_RLC(Z80A_REG_C, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $02: //RLC D
      begin
        gt_RLC(Z80A_REG_D, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $03: //RLC E
      begin
        gt_RLC(Z80A_REG_E, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $04: //RLC H
      begin
        gt_RLC(Z80A_REG_H, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $05: //RLC L
      begin
        gt_RLC(Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $06: //RLC (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RLC(Reg8, 0);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $07: //RLC A
      begin
        gt_RLC(Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $08: //RRC B
      begin
        gt_RRC(Z80A_REG_B, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $09: //RRC C
      begin
        gt_RRC(Z80A_REG_C, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0A: //RRC D
      begin
        gt_RRC(Z80A_REG_D, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0B: //RRC E
      begin
        gt_RRC(Z80A_REG_E, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0C: //RRC H
      begin
        gt_RRC(Z80A_REG_H, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0D: //RRC L
      begin
        gt_RRC(Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0E: //RRC (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RRC(Reg8, 0);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $0F: //RRC A
      begin
        gt_RRC(Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $10: //RL B
      begin
        gt_RL(Z80A_REG_B, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $11: //RL C
      begin
        gt_RL(Z80A_REG_C, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $12: //RL D
      begin
        gt_RL(Z80A_REG_D, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $13: //RL E
      begin
        gt_RL(Z80A_REG_E, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $14: //RL H
      begin
        gt_RL(Z80A_REG_H, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $15: //RL L
      begin
        gt_RL(Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $16: //RL (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RL(Reg8, 0);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $17: //RL A
      begin
        gt_RL(Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $18: //RR B
      begin
        gt_RR(Z80A_REG_B, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $19: //RR C
      begin
        gt_RR(Z80A_REG_C, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1A: //RR D
      begin
        gt_RR(Z80A_REG_D, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1B: //RR E
      begin
        gt_RR(Z80A_REG_E, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1C: //RR H
      begin
        gt_RR(Z80A_REG_H, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1D: //RR L
      begin
        gt_RR(Z80A_REG_L, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1E: //RR (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RR(Reg8, 0);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $1F: //RR A
      begin
        gt_RR(Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $20: //SLA B
      begin
        gt_SLA(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $21: //SLA C
      begin
        gt_SLA(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $22: //SLA D
      begin
        gt_SLA(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $23: //SLA E
      begin
        gt_SLA(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $24: //SLA H
      begin
        gt_SLA(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $25: //SLA L
      begin
        gt_SLA(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $26: //SLA (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SLA(Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $27: //SLA A
      begin
        gt_SLA(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $28: //SRA B
      begin
        gt_SRA(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $29: //SRA C
      begin
        gt_SRA(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2A: //SRA D
      begin
        gt_SRA(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2B: //SRA E
      begin
        gt_SRA(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2C: //SRA H
      begin
        gt_SRA(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2D: //SRA L
      begin
        gt_SRA(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2E: //SRA (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SRA(Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2F: //SRA A
      begin
        gt_SRA(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $30: //SLL B '@@@@@ SLL,SLS
      begin
        gt_SLL(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $31: //SLL C '@@@@@
      begin
        gt_SLL(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $32: //SLL D '@@@@@
      begin
        gt_SLL(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $33: //SLL E '@@@@@
      begin
        gt_SLL(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $34: //SLL H '@@@@@
      begin
        gt_SLL(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $35: //SLL L '@@@@@
      begin
        gt_SLL(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $36: //SLL (HL) '@@@@@
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SLL(Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $37: //SLL A '@@@@@
      begin
        gt_SLL(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $38: //SRL B
      begin
        gt_SRL(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $39: //SRL C
      begin
        gt_SRL(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3A: //SRL D
      begin
        gt_SRL(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3B: //SRL E
      begin
        gt_SRL(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3C: //SRL H
      begin
        gt_SRL(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3D: //SRL L
      begin
        gt_SRL(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3E: //SRL (HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SRL(Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $3F: //SRL A
      begin
        gt_SRL(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $40: //BIT 0,B
      begin
        gt_BIT(0, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $41: //BIT 0,C
      begin
        gt_BIT(0, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $42: //BIT 0,D
      begin
        gt_BIT(0, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $43: //BIT 0,E
      begin
        gt_BIT(0, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $44: //BIT 0,H
      begin
        gt_BIT(0, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $45: //BIT 0,L
      begin
        gt_BIT(0, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $46: //BIT 0,(HL)
      begin
        gt_BIT(0, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $47: //BIT 0,A
      begin
        gt_BIT(0, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $48: //BIT 1,B
      begin
        gt_BIT(1, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $49: //BIT 1,C
      begin
        gt_BIT(1, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4A: //BIT 1,D
      begin
        gt_BIT(1, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4B: //BIT 1,E
      begin
        gt_BIT(1, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4C: //BIT 1,H
      begin
        gt_BIT(1, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4D: //BIT 1,L
      begin
        gt_BIT(1, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4E: //BIT 1,(HL)
      begin
        gt_BIT(1, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4F: //BIT 1,A
      begin
        gt_BIT(1, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $50: //BIT 2,B
      begin
        gt_BIT(2, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $51: //BIT 2,C
      begin
        gt_BIT(2, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $52: //BIT 2,D
      begin
        gt_BIT(2, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $53: //BIT 2,E
      begin
        gt_BIT(2, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $54: //BIT 2,H
      begin
        gt_BIT(2, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $55: //BIT 2,L
      begin
        gt_BIT(2, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $56: //BIT 2,(HL)
      begin
        gt_BIT(2, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $57: //BIT 2,A
      begin
        gt_BIT(2, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $58: //BIT 3,B
      begin
        gt_BIT(3, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $59: //BIT 3,C
      begin
        gt_BIT(3, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5A: //BIT 3,D
      begin
        gt_BIT(3, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5B: //BIT 3,E
      begin
        gt_BIT(3, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5C: //BIT 3,H
      begin
        gt_BIT(3, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5D: //BIT 3,L
      begin
        gt_BIT(3, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5E: //BIT 3,(HL)
      begin
        gt_BIT(3, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5F: //BIT 3,A
      begin
        gt_BIT(3, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $60: //BIT 4,B
      begin
        gt_BIT(4, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $61: //BIT 4,C
      begin
        gt_BIT(4, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $62: //BIT 4,D
      begin
        gt_BIT(4, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $63: //BIT 4,E
      begin
        gt_BIT(4, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $64: //BIT 4,H
      begin
        gt_BIT(4, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $65: //BIT 4,L
      begin
        gt_BIT(4, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $66: //BIT 4,(HL)
      begin
        gt_BIT(4, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $67: //BIT 4,A
      begin
        gt_BIT(4, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $68: //BIT 5,B
      begin
        gt_BIT(5, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $69: //BIT 5,C
      begin
        gt_BIT(5, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6A: //BIT 5,D
      begin
        gt_BIT(5, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6B: //BIT 5,E
      begin
        gt_BIT(5, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6C: //BIT 5,H
      begin
        gt_BIT(5, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6D: //BIT 5,L
      begin
        gt_BIT(5, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6E: //BIT 5,(HL)
      begin
        gt_BIT(5, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6F: //BIT 5,A
      begin
        gt_BIT(5, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $70: //BIT 6,B
      begin
        gt_BIT(6, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $71: //BIT 6,C
      begin
        gt_BIT(6, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $72: //BIT 6,D
      begin
        gt_BIT(6, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $73: //BIT 6,E
      begin
        gt_BIT(6, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $74: //BIT 6,H
      begin
        gt_BIT(6, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $75: //BIT 6,L
      begin
        gt_BIT(6, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $76: //BIT 6,(HL)
      begin
        gt_BIT(6, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $77: //BIT 6,A
      begin
        gt_BIT(6, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $78: //BIT 7,B
      begin
        gt_BIT(7, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $79: //BIT 7,C
      begin
        gt_BIT(7, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7A: //BIT 7,D
      begin
        gt_BIT(7, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7B: //BIT 7,E
      begin
        gt_BIT(7, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7C: //BIT 7,H
      begin
        gt_BIT(7, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7D: //BIT 7,L
      begin
        gt_BIT(7, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7E: //BIT 7,(HL)
      begin
        gt_BIT(7, GET_MSX_MEMORY(GET_Z80A_REG_HL));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7F: //BIT 7,A
      begin
        gt_BIT(7, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $80: //RES 0,B
      begin
        gt_RES(0, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $81: //RES 0,C
      begin
        gt_RES(0, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $82: //RES 0,D
      begin
        gt_RES(0, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $83: //RES 0,E
      begin
        gt_RES(0, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $84: //RES 0,H
      begin
        gt_RES(0, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $85: //RES 0,L
      begin
        gt_RES(0, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $86: //RES 0,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(0, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $87: //RES 0,A
      begin
        gt_RES(0, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $88: //RES 1,B
      begin
        gt_RES(1, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $89: //RES 1,C
      begin
        gt_RES(1, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8A: //RES 1,D
      begin
        gt_RES(1, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8B: //RES 1,E
      begin
        gt_RES(1, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8C: //RES 1,H
      begin
        gt_RES(1, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8D: //RES 1,L
      begin
        gt_RES(1, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8E: //RES 1,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(1, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8F: //RES 1,A
      begin
        gt_RES(1, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $90: //RES 2,B
      begin
        gt_RES(2, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $91: //RES 2,C
      begin
        gt_RES(2, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $92: //RES 2,D
      begin
        gt_RES(2, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $93: //RES 2,E
      begin
        gt_RES(2, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $94: //RES 2,H
      begin
        gt_RES(2, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $95: //RES 2,L
      begin
        gt_RES(2, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $96: //RES 2,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(2, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $97: //RES 2,A
      begin
        gt_RES(2, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $98: //RES 3,B
      begin
        gt_RES(3, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $99: //RES 3,C
      begin
        gt_RES(3, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9A: //RES 3,D
      begin
        gt_RES(3, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9B: //RES 3,E
      begin
        gt_RES(3, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9C: //RES 3,H
      begin
        gt_RES(3, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9D: //RES 3,L
      begin
        gt_RES(3, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9E: //RES 3,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(3, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9F: //RES 3,A
      begin
        gt_RES(3, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A0: //RES 4,B
      begin
        gt_RES(4, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A1: //RES 4,C
      begin
        gt_RES(4, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A2: //RES 4,D
      begin
        gt_RES(4, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A3: //RES 4,E
      begin
        gt_RES(4, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A4: //RES 4,H
      begin
        gt_RES(4, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A5: //RES 4,L
      begin
        gt_RES(4, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A6: //RES 4,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(4, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A7: //RES 4,A
      begin
        gt_RES(4, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A8: //RES 5,B
      begin
        gt_RES(5, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A9: //RES 5,C
      begin
        gt_RES(5, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AA: //RES 5,D
      begin
        gt_RES(5, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AB: //RES 5,E
      begin
        gt_RES(5, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AC: //RES 5,H
      begin
        gt_RES(5, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AD: //RES 5,L
      begin
        gt_RES(5, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AE: //RES 5,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(5, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AF: //RES 5,A
      begin
        gt_RES(5, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B0: //RES 6,B
      begin
        gt_RES(6, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B1: //RES 6,C
      begin
        gt_RES(6, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B2: //RES 6,D
      begin
        gt_RES(6, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B3: //RES 6,E
      begin
        gt_RES(6, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B4: //RES 6,H
      begin
        gt_RES(6, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B5: //RES 6,L
      begin
        gt_RES(6, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B6: //RES 6,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(6, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B7: //RES 6,A
      begin
        gt_RES(6, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B8: //RES 7,B
      begin
        gt_RES(7, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B9: //RES 7,C
      begin
        gt_RES(7, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BA: //RES 7,D
      begin
        gt_RES(7, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BB: //RES 7,E
      begin
        gt_RES(7, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BC: //RES 7,H
      begin
        gt_RES(7, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BD: //RES 7,L
      begin
        gt_RES(7, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BE: //RES 7,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_RES(7, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BF: //RES 7,A
      begin
        gt_RES(7, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C0: //SET 0,B
      begin
        gt_SET(0, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C1: //SET 0,C
      begin
        gt_SET(0, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C2: //SET 0,D
      begin
        gt_SET(0, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C3: //SET 0,E
      begin
        gt_SET(0, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C4: //SET 0,H
      begin
        gt_SET(0, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C5: //SET 0,L
      begin
        gt_SET(0, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C6: //SET 0,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(0, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C7: //SET 0,A
      begin
        gt_SET(0, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C8: //SET 1,B
      begin
        gt_SET(1, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $C9: //SET 1,C
      begin
        gt_SET(1, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CA: //SET 1,D
      begin
        gt_SET(1, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CB: //SET 1,E
      begin
        gt_SET(1, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CC: //SET 1,H
      begin
        gt_SET(1, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CD: //SET 1,L
      begin
        gt_SET(1, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CE: //SET 1,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(1, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CF: //SET 1,A
      begin
        gt_SET(1, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D0: //SET 2,B
      begin
        gt_SET(2, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D1: //SET 2,C
      begin
        gt_SET(2, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D2: //SET 2,D
      begin
        gt_SET(2, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D3: //SET 2,E
      begin
        gt_SET(2, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D4: //SET 2,H
      begin
        gt_SET(2, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D5: //SET 2,L
      begin
        gt_SET(2, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D6: //SET 2,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(2, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D7: //SET 2,A
      begin
        gt_SET(2, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D8: //SET 3,B
      begin
        gt_SET(3, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $D9: //SET 3,C
      begin
        gt_SET(3, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DA: //SET 3,D
      begin
        gt_SET(3, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DB: //SET 3,E
      begin
        gt_SET(3, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DC: //SET 3,H
      begin
        gt_SET(3, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DD: //SET 3,L
      begin
        gt_SET(3, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DE: //SET 3,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(3, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $DF: //SET 3,A
      begin
        gt_SET(3, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E0: //SET 4,B
      begin
        gt_SET(4, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E1: //SET 4,C
      begin
        gt_SET(4, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E2: //SET 4,D
      begin
        gt_SET(4, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E3: //SET 4,E
      begin
        gt_SET(4, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E4: //SET 4,H
      begin
        gt_SET(4, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E5: //SET 4,L
      begin
        gt_SET(4, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E6: //SET 4,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(4, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E7: //SET 4,A
      begin
        gt_SET(4, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E8: //SET 5,B
      begin
        gt_SET(5, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E9: //SET 5,C
      begin
        gt_SET(5, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $EA: //SET 5,D
      begin
        gt_SET(5,  Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $EB: //SET 5,E
      begin
        gt_SET(5, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $EC: //SET 5,H
      begin
        gt_SET(5, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $ED: //SET 5,L
      begin
        gt_SET(5, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $EE: //SET 5,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(5, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $EF: //SET 5,A
      begin
        gt_SET(5, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F0: //SET 6,B
      begin
        gt_SET(6, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F1: //SET 6,C
      begin
        gt_SET(6, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F2: //SET 6,D
      begin
        gt_SET(6, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F3: //SET 6,E
      begin
        gt_SET(6, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F4: //SET 6,H
      begin
        gt_SET(6, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F5: //SET 6,L
      begin
        gt_SET(6, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F6: //SET 6,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(6, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F7: //SET 6,A
      begin
        gt_SET(6, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F8: //SET 7,B
      begin
        gt_SET(7, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $F9: //SET 7,C
      begin
        gt_SET(7, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FA: //SET 7,D
      begin
        gt_SET(7, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FB: //SET 7,E
      begin
        gt_SET(7, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FC: //SET 7,H
      begin
        gt_SET(7, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FD: //SET 7,L
      begin
        gt_SET(7, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FE: //SET 7,(HL)
      begin
        Reg8 := GET_MSX_MEMORY(GET_Z80A_REG_HL);
        gt_SET(7, Reg8);
        PUT_MSX_MEMORY(GET_Z80A_REG_HL, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $FF: //SET 7,A
      begin
        gt_SET(7, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
  Else //실행안됨
  End;
end;

end.

