unit msxMI_DD;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE_DD;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM, msxMI_DD_CB;

procedure EXEC_Z80A_CODE_DD;
var
  idx: Byte; //0~255
  iSz: Byte;
  Reg8: Byte;
  Reg16: Word;
  GetIxyIdx: Word;
  PC1p: Word;
  PC2p: Word;

begin
  idx := GET_MSX_MEMORY(Z80A_REG_PC);
  iSz := 2;

  GetIxyIdx := goGetLngToLng(Z80A_REG_IX + giGetIdx8(GET_MSX_MEMORY(((Z80A_REG_PC + 1) And $FFFF))));
  PC1p := ((Z80A_REG_PC + 1) And $FFFF);
  PC2p := ((Z80A_REG_PC + 2) And $FFFF);

  Case (idx) of
    $09: //ADD IX,BC
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IX, GET_Z80A_REG_BC, Z80A_REG_IX, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $19: //ADD IX,DE
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IX, GET_Z80A_REG_DE, Z80A_REG_IX, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $21: //LD IX,nn
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 14;
        Z80A_REG_IX := GET_MSX_MEMORY_16(PC1p);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $22: //LD (nn),IX
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), Z80A_REG_IX);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $23: //INC IX
      begin
        Gi_Z80A_CLOCK := 10;
        gt_INC_16TO16(Z80A_REG_IX, Z80A_REG_IX);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $24: //INC IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_INC_8TO8(GET_Z80A_REG_IXH, Reg8);
        PUT_Z80A_REG_IXH(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $25: //DEC IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_DEC_8TO8(GET_Z80A_REG_IXH, Reg8);
        PUT_Z80A_REG_IXH(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $26: //LD IXH,n '@@@@@
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 11;
        PUT_Z80A_REG_IXH(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $29: //ADD IX,IX
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IX, Z80A_REG_IX, Z80A_REG_IX, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2A: //LD IX,(nn)
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        Z80A_REG_IX := GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2B: //DEC IX
      begin
        Gi_Z80A_CLOCK := 10;
        gt_DEC_16TO16(Z80A_REG_IX, Z80A_REG_IX);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2C: //INC IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_INC_8TO8(GET_Z80A_REG_IXL, Reg8);
        PUT_Z80A_REG_IXL(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2D: //DEC IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_DEC_8TO8(GET_Z80A_REG_IXL, Reg8);
        PUT_Z80A_REG_IXL(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2E: //LD IXL,n '@@@@@
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 11;
        PUT_Z80A_REG_IXL(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $34: //INC (IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 23;
        gt_INC_8TO8(GET_MSX_MEMORY(GetIxyIdx), Reg8);
        PUT_MSX_MEMORY(GetIxyIdx, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $35: //DEC (IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 23;
        gt_DEC_8TO8(GET_MSX_MEMORY(GetIxyIdx), Reg8);
        PUT_MSX_MEMORY(GetIxyIdx, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $36: //LD (IX+d),n
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, GET_MSX_MEMORY(PC2p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $39: //ADD IX,SP
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IX, Z80A_REG_SP, Z80A_REG_IX, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $44: //LD B,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_B := GET_Z80A_REG_IXH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $45: //LD B,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_B := GET_Z80A_REG_IXL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $46: //LD B,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_B := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4C: //LD C,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_C := GET_Z80A_REG_IXH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4D: //LD C,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_C := GET_Z80A_REG_IXL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4E: //LD C,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_C := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $54: //LD D,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_D := GET_Z80A_REG_IXH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $55: //LD D,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_D := GET_Z80A_REG_IXL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $56: //LD D,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_D := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5C: //LD E,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_E := GET_Z80A_REG_IXH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5D: //LD E,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_E := GET_Z80A_REG_IXL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5E: //LD E,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_E := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $60: //LD IXH,B '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $61: //LD IXH,C '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $62: //LD IXH,D '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $63: //LD IXH,E '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $64: //LD IXH,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
      //PUT_Z80A_REG_IXH(GET_Z80A_REG_IXH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $65: //LD IXH,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(GET_Z80A_REG_IXL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $66: //LD H,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_H := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $67: //LD IXH,A '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXH(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $68: //LD IXL,B '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $69: //LD IXL,C '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6A: //LD IXL,D '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6B: //LD IXL,E '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6C: //LD IXL,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(GET_Z80A_REG_IXH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6D: //LD IXL,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
      //PUT_Z80A_REG_IXL(GET_Z80A_REG_IXL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6E: //LD L,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_L := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6F: //LD IXL,A '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IXL(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $70: //LD (IX+d),B
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $71: //LD (IX+d),C
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $72: //LD (IX+d),D
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $73: //LD (IX+d),E
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $74: //LD (IX+d),H
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $75: //LD (IX+d),L
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $77: //LD (IX+d),A
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7C: //LD A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_A := GET_Z80A_REG_IXH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7D: //LD A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_A := GET_Z80A_REG_IXL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7E: //LD A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_A := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $84: //ADD A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $85: //ADD A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $86: //ADD A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8C: //ADC A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8D: //ADC A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8E: //ADC A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $94: //SUB A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $95: //SUB A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $96: //SUB A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9C: //SBC A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9D: //SBC A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9E: //SBC A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A4: //AND A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_AND_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A5: //AND A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_AND_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A6: //AND A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_AND_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AC: //XOR A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_XOR_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AD: //XOR A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_XOR_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AE: //XOR A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_XOR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B4: //OR A,IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_OR_8TO8(Z80A_REG_A, GET_Z80A_REG_IXH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B5: //OR A,IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_OR_8TO8(Z80A_REG_A, GET_Z80A_REG_IXL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B6: //OR A,(IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_OR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BC: //CP IXH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_CP(GET_Z80A_REG_IXH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BD: //CP IXL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_CP(GET_Z80A_REG_IXL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BE: //CP (IX+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_CP(GET_MSX_MEMORY(GetIxyIdx));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CB: //DD-CB - IX bit instruction
      begin
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_DD_CB;
      end;
    $E1: //POP IX
      begin
        Gi_Z80A_CLOCK := 14;
        gt_POP_16(Z80A_REG_IX);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E3: //EX (SP),IX
      begin
        Gi_Z80A_CLOCK := 23;
        Reg16 := GET_MSX_MEMORY_16(Z80A_REG_SP);
        PUT_MSX_MEMORY_16(Z80A_REG_SP, Z80A_REG_IX);
        Z80A_REG_IX := Reg16;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E5: //PUSH IX
      begin
        Gi_Z80A_CLOCK := 15;
        gt_PUSH_16(Z80A_REG_IX);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E9: //JP (IX)
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_PC := Z80A_REG_IX; //PC<-IX
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $F9: //LD SP,IX
      begin
        Gi_Z80A_CLOCK := 10;
        Z80A_REG_SP := Z80A_REG_IX;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
  Else
    begin
      Gi_Z80A_CLOCK := 0;
      EXEC_Z80A_ADD_PC(0, 0); //없는명령은취소됨
    end;
  End;
end;

end.

