unit msxMI_DD_CB;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE_DD_CB;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM;

procedure EXEC_Z80A_CODE_DD_CB;
var
  idx: Byte; //0~255
  iSz: Byte;
  GetIxyIdx: Word;
  GetIdxMem8: Byte;

begin
  idx := GET_MSX_MEMORY(((Z80A_REG_PC + 1) And $FFFF));
  iSz := 4;

  GetIxyIdx := goGetLngToLng(Z80A_REG_IX + giGetIdx8(GET_MSX_MEMORY(Z80A_REG_PC)));
  GetIdxMem8 := GET_MSX_MEMORY(GetIxyIdx);

  Gi_Z80A_CLOCK := 23;

  Case (idx) of
    $00: //RLC (IX+d),B '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $01: //RLC (IX+d),C '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $02: //RLC (IX+d),D '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $03: //RLC (IX+d),E '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $04: //RLC (IX+d),H '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $05: //RLC (IX+d),L '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $06: //RLC (IX+d)
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $07: //RLC (IX+d),A '@@@@@
      begin
        gt_RLC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $08: //RRC (IX+d),B '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $09: //RRC (IX+d),C '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0A: //RRC (IX+d),D '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0B: //RRC (IX+d),E '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0C: //RRC (IX+d),H '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0D: //RRC (IX+d),L '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0E: //RRC (IX+d)
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $0F: //RRC (IX+d),A '@@@@@
      begin
        gt_RRC(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $10: //RL (IX+d),B '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $11: //RL (IX+d),C '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $12: //RL (IX+d),D '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $13: //RL (IX+d),E '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $14: //RL (IX+d),H '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $15: //RL (IX+d),L '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $16: //RL,(IX+d)
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $17: //RL (IX+d),A '@@@@@
      begin
        gt_RL(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $18: //RR (IX+d),B '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $19: //RR (IX+d),C '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1A: //RR (IX+d),D '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1B: //RR (IX+d),E '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1C: //RR (IX+d),H '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1D: //RR (IX+d),L '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1E: //RR,(IX+d)
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $1F: //RR (IX+d),A '@@@@@
      begin
        gt_RR(GetIdxMem8, 0);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $20: //SLA (IX+d),B '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $21: //SLA (IX+d),C '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $22: //SLA (IX+d),D '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $23: //SLA (IX+d),E '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $24: //SLA (IX+d),H '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $25: //SLA (IX+d),L '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $26: //SLA,(IX+d)
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $27: //SLA (IX+d),A '@@@@@
      begin
        gt_SLA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $28: //SRA (IX+d),B '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $29: //SRA (IX+d),C '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2A: //SRA (IX+d),D '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2B: //SRA (IX+d),E '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2C: //SRA (IX+d),H '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2D: //SRA (IX+d),L '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2E: //SRA,(IX+d)
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $2F: //SRA (IX+d),A '@@@@@
      begin
        gt_SRA(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $30: //SLL (IX+d),B '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $31: //SLL (IX+d),C '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $32: //SLL (IX+d),D '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $33: //SLL (IX+d),E '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $34: //SLL (IX+d),H '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $35: //SLL (IX+d),L '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $36: //SLL (IX+d) '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $37: //SLL (IX+d),A '@@@@@
      begin
        gt_SLL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $38: //SRL (IX+d),B '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $39: //SRL (IX+d),C '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3A: //SRL (IX+d),D '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3B: //SRL (IX+d),E '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3C: //SRL (IX+d),H '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3D: //SRL (IX+d),L '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3E: //SRL,(IX+d)
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $3F: //SRL (IX+d),A '@@@@@
      begin
        gt_SRL(GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $40: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $41: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $42: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $43: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $44: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $45: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $46: //BIT 0,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $47: //BIT 0,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(0, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $48: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $49: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4A: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4B: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4C: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4D: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4E: //BIT 1,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $4F: //BIT 1,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(1, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $50: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $51: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $52: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $53: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $54: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $55: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $56: //BIT 2,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $57: //BIT 2,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(2, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $58: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $59: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5A: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5B: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5C: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5D: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5E: //BIT 3,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $5F: //BIT 3,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(3, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $60: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $61: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $62: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $63: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $64: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $65: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $66: //BIT 4,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $67: //BIT 4,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(4, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $68: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $69: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6A: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6B: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6C: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6D: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6E: //BIT 5,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $6F: //BIT 5,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(5, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $70: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $71: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $72: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $73: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $74: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $75: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $76: //BIT 6,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $77: //BIT 6,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(6, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $78: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $79: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7A: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7B: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7C: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7D: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7E: //BIT 7,(IX+d)
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $7F: //BIT 7,(IX+d) '@@@@@
      begin
        Gi_Z80A_CLOCK := 20;
        gt_BIT(7, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $80: //RES 0,(IX+d),B '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $81: //RES 0,(IX+d),C '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $82: //RES 0,(IX+d),D '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $83: //RES 0,(IX+d),E '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $84: //RES 0,(IX+d),H '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $85: //RES 0,(IX+d),L '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $86: //RES 0,(IX+d)
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $87: //RES 0,(IX+d),A '@@@@@
      begin
        gt_RES(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $88: //RES 1,(IX+d),B '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $89: //RES 1,(IX+d),C '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8A: //RES 1,(IX+d),D '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8B: //RES 1,(IX+d),E '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8C: //RES 1,(IX+d),H '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8D: //RES 1,(IX+d),L '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8E: //RES 1,(IX+d)
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $8F: //RES 1,(IX+d),A '@@@@@
      begin
        gt_RES(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $90: //RES 2,(IX+d),B '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $91: //RES 2,(IX+d),C '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $92: //RES 2,(IX+d),D '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $93: //RES 2,(IX+d),E '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $94: //RES 2,(IX+d),H '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $95: //RES 2,(IX+d),L '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $96: //RES 2,(IX+d)
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $97: //RES 2,(IX+d),A '@@@@@
      begin
        gt_RES(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $98: //RES 3,(IX+d),B '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $99: //RES 3,(IX+d),C '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9A: //RES 3,(IX+d),D '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9B: //RES 3,(IX+d),E '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9C: //RES 3,(IX+d),H '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9D: //RES 3,(IX+d),L '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9E: //RES 3,(IX+d)
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $9F: //RES 3,(IX+d),A '@@@@@
      begin
        gt_RES(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A0: //RES 4,(IX+d),B '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A1: //RES 4,(IX+d),C '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A2: //RES 4,(IX+d),D '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A3: //RES 4,(IX+d),E '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A4: //RES 4,(IX+d),H '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A5: //RES 4,(IX+d),L '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A6: //RES 4,(IX+d)
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A7: //RES 4,(IX+d),A '@@@@@
      begin
        gt_RES(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A8: //RES 5,(IX+d),B '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $A9: //RES 5,(IX+d),C '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AA: //RES 5,(IX+d),D '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AB: //RES 5,(IX+d),E '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AC: //RES 5,(IX+d),H '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AD: //RES 5,(IX+d),L '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AE: //RES 5,(IX+d)
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $AF: //RES 5,(IX+d),A '@@@@@
      begin
        gt_RES(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B0: //RES 6,(IX+d),B '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B1: //RES 6,(IX+d),C '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B2: //RES 6,(IX+d),D '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B3: //RES 6,(IX+d),E '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B4: //RES 6,(IX+d),H '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B5: //RES 6,(IX+d),L '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B6: //RES 6,(IX+d)
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B7: //RES 6,(IX+d),A '@@@@@
      begin
        gt_RES(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B8: //RES 7,(IX+d),B '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $B9: //RES 7,(IX+d),C '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BA: //RES 7,(IX+d),D '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BB: //RES 7,(IX+d),E '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BC: //RES 7,(IX+d),H '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BD: //RES 7,(IX+d),L '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BE: //RES 7,(IX+d)
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $BF: //RES 7,(IX+d),A '@@@@@
      begin
        gt_RES(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C0: //SET 0,(IX+d),B '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C1: //SET 0,(IX+d),C '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C2: //SET 0,(IX+d),D '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C3: //SET 0,(IX+d),E '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C4: //SET 0,(IX+d),H '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C5: //SET 0,(IX+d),L '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C6: //SET 0,(IX+d)
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C7: //SET 0,(IX+d),A '@@@@@
      begin
        gt_SET(0, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C8: //SET 1,(IX+d),B '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $C9: //SET 1,(IX+d),C '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CA: //SET 1,(IX+d),D '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CB: //SET 1,(IX+d),E '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CC: //SET 1,(IX+d),H '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CD: //SET 1,(IX+d),L '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CE: //SET 1,(IX+d)
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $CF: //SET 1,(IX+d),A '@@@@@
      begin
        gt_SET(1, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D0: //SET 2,(IX+d),B '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D1: //SET 2,(IX+d),C '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D2: //SET 2,(IX+d),D '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D3: //SET 2,(IX+d),E '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D4: //SET 2,(IX+d),H '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D5: //SET 2,(IX+d),L '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D6: //SET 2,(IX+d)
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D7: //SET 2,(IX+d),A '@@@@@
      begin
        gt_SET(2, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D8: //SET 3,(IX+d),B '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $D9: //SET 3,(IX+d),C '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DA: //SET 3,(IX+d),D '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DB: //SET 3,(IX+d),E '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DC: //SET 3,(IX+d),H '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DD: //SET 3,(IX+d),L '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DE: //SET 3,(IX+d)
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $DF: //SET 3,(IX+d),A '@@@@@
      begin
        gt_SET(3, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E0: //SET 4,(IX+d),B '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E1: //SET 4,(IX+d),C '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E2: //SET 4,(IX+d),D '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E3: //SET 4,(IX+d),E '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E4: //SET 4,(IX+d),H '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E5: //SET 4,(IX+d),L '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E6: //SET 4,(IX+d)
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E7: //SET 4,(IX+d),A '@@@@@
      begin
        gt_SET(4, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E8: //SET 5,(IX+d),B '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $E9: //SET 5,(IX+d),C '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $EA: //SET 5,(IX+d),D '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $EB: //SET 5,(IX+d),E '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $EC: //SET 5,(IX+d),H '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $ED: //SET 5,(IX+d),L '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $EE: //SET 5,(IX+d)
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $EF: //SET 5,(IX+d),A '@@@@@
      begin
        gt_SET(5, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F0: //SET 6,(IX+d),B '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F1: //SET 6,(IX+d),C '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F2: //SET 6,(IX+d),D '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F3: //SET 6,(IX+d),E '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F4: //SET 6,(IX+d),H '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F5: //SET 6,(IX+d),L '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F6: //SET 6,(IX+d)
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F7: //SET 6,(IX+d),A '@@@@@
      begin
        gt_SET(6, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F8: //SET 7,(IX+d),B '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_B := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $F9: //SET 7,(IX+d),C '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_C := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FA: //SET 7,(IX+d),D '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_D := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FB: //SET 7,(IX+d),E '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_E := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FC: //SET 7,(IX+d),H '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_H := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FD: //SET 7,(IX+d),L '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_L := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FE: //SET 7,(IX+d)
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
    $FF: //SET 7,(IX+d),A '@@@@@
      begin
        gt_SET(7, GetIdxMem8);
        PUT_MSX_MEMORY(GetIxyIdx, GetIdxMem8);
        Z80A_REG_A := GetIdxMem8;
        EXEC_Z80A_ADD_PC(iSz - 2, 0);
      end;
  Else //실행안됨
  End;
end;

end.

