unit msxMI_ED;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE_ED;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM;

procedure EXEC_Z80A_CODE_ED;
var
  idx: Byte; //0~255
  iSz: Byte;
  Reg8: Byte;
  PC1p: Word;

begin
  idx := GET_MSX_MEMORY(Z80A_REG_PC);
  iSz := 2;

  PC1p := ((Z80A_REG_PC + 1) And $FFFF);

  Case (idx) of
    $40: //IN B,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $41: //OUT (C),B
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $42: //SBC HL,BC
      begin
        Gi_Z80A_CLOCK := 15;
        gt_SUB_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_BC, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $43: //LD (nn),BC
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), GET_Z80A_REG_BC);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $44: //NEG
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $45: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
      //Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $46: //IM 0
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_0;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $47: //LD I,A
      begin
        Gi_Z80A_CLOCK := 9;
        gt_LD_I_A;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $48: //IN C,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $49: //OUT (C),C
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4A: //ADC HL,BC
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_BC, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4B: //LD BC,(nn)
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_Z80A_REG_BC(GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p)));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4C: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4D: //RETI
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETI;
        gt_POP_16(Z80A_REG_PC);
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $4E: //IM 0/1 '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_0_1;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4F: //LD R,A
      begin
        Gi_Z80A_CLOCK := 9;
        gt_LD_R_A;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $50: //IN D,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $51: //OUT (C),D
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $52: //SBC HL,DE
      begin
        Gi_Z80A_CLOCK := 15;
        gt_SUB_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_DE, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $53: //LD (nn),DE
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), GET_Z80A_REG_DE);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $54: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $55: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $56: //IM 1
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_1;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $57: //LD A,I
      begin
        Gi_Z80A_CLOCK := 9;
        gt_LD_A_I;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $58: //IN E,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $59: //OUT (C),E
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5A: //ADC HL,DE
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_DE, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5B: //LD DE,(nn)
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_Z80A_REG_DE(GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p)));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5C: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5D: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $5E: //IM 2
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_2;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5F: //LD A,R
      begin
        Gi_Z80A_CLOCK := 9;
        gt_LD_A_R;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $60: //IN H,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $61: //OUT (C),H
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $62: //SBC HL,HL
      begin
        Gi_Z80A_CLOCK := 15;
        gt_SUB_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_HL, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $63: //LD (nn),HL '@@@@@
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), GET_Z80A_REG_HL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $64: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $65: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $66: //IM 0
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_0;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $67: //RRD
      begin
        Gi_Z80A_CLOCK := 18;
        gt_RRD;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $68: //IN L,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $69: //OUT (C),L
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6A: //ADC HL,HL
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO8(GET_Z80A_REG_HL, GET_Z80A_REG_HL, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6B: //LD HL,(nn) '@@@@@
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_Z80A_REG_HL(GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p)));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6C: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6D: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
        Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt; //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $6E: //IM 0/1 '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_0_1;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6F: //RLD
      begin
        Gi_Z80A_CLOCK := 18;
        gt_RLD;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $70: //IN (C) '@@@@@
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $71: //OUT (C),0 '@@@@@
      begin
        Gi_Z80A_CLOCK := 12;
        Reg8 := 0;
        gt_PORT_OUT(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $72: //SBC HL,SP
      begin
        Gi_Z80A_CLOCK := 15;
        gt_SUB_16TO8(GET_Z80A_REG_HL, Z80A_REG_SP, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $73: //LD (nn),SP
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), Z80A_REG_SP);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $74: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $75: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
      //Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $76: //IM 1
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_1;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $78: //IN A,(C)
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_IN(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $79: //OUT (C),A
      begin
        Gi_Z80A_CLOCK := 12;
        gt_PORT_OUT(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7A: //ADC HL,SP
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO8(GET_Z80A_REG_HL, Z80A_REG_SP, Z80A_REG_H, Z80A_REG_L, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7B: //LD SP,(nn)
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        Z80A_REG_SP := GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7C: //NEG '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_NEG;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7D: //RETN
      begin
        Gi_Z80A_CLOCK := 14;
        gt_RETN;
        gt_POP_16(Z80A_REG_PC);
      //Gi_Z80A_EI_Chk := Gi_Z80A_EI_Cnt //EI 확인용
        EXEC_Z80A_ADD_PC(0, iSz - 1); //2
      end;
    $7E: //IM 2
      begin
        Gi_Z80A_CLOCK := 8;
        gt_IM_2;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A0: //LDI
      begin
        Gi_Z80A_CLOCK := 16;
        gt_LDI;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A1: //CPI
      begin
        Gi_Z80A_CLOCK := 16;
        gt_CPI;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A2: //INI
      begin
        Gi_Z80A_CLOCK := 16;
        gt_INI;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A3: //OUTI
      begin
        Gi_Z80A_CLOCK := 16;
        gt_OUTI;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A8: //LDD
      begin
        Gi_Z80A_CLOCK := 16;
        gt_LDD;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A9: //CPD
      begin
        Gi_Z80A_CLOCK := 16;
        gt_CPD;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AA: //IND
      begin
        Gi_Z80A_CLOCK := 16;
        gt_IND;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AB: //OUTD
      begin
        Gi_Z80A_CLOCK := 16;
        gt_OUTD;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B0: //LDIR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_LDIR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B1: //CPIR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_CPIR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B2: //INIR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_INIR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B3: //OTIR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_OTIR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B8: //LDDR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_LDDR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B9: //CPDR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_CPDR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BA: //INDR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_INDR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BB: //OTDR
      begin
        Gi_Z80A_CLOCK := 0;
        gt_OTDR; //21/16
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
  Else
    begin
      Gi_Z80A_CLOCK := 0;
      EXEC_Z80A_ADD_PC(1, 0); //없는명령은NOP
    end;
  End;
end;

end.

