unit msxMI_FD;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure EXEC_Z80A_CODE_FD;

implementation

uses
  msxMSX, msxZ80A, msxINT, msxIO, msxMEM, msxMI_FD_CB;

procedure EXEC_Z80A_CODE_FD;
var
  idx: Byte; //0~255
  iSz: Byte;
  Reg8: Byte;
  Reg16: Word;
  GetIxyIdx: Word;
  PC1p: Word;
  PC2p: Word;

begin
  idx := GET_MSX_MEMORY(Z80A_REG_PC);
  iSz := 2;

  GetIxyIdx := goGetLngToLng(Z80A_REG_IY + giGetIdx8(GET_MSX_MEMORY(((Z80A_REG_PC + 1) And $FFFF))));
  PC1p := ((Z80A_REG_PC + 1) And $FFFF);
  PC2p := ((Z80A_REG_PC + 2) And $FFFF);

  Case (idx) of
    $09: //ADD IY,BC
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IY, GET_Z80A_REG_BC, Z80A_REG_IY, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $19: //ADD IY,DE
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IY, GET_Z80A_REG_DE, Z80A_REG_IY, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $21: //LD IY,nn
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 14;
        Z80A_REG_IY := GET_MSX_MEMORY_16(PC1p);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $22: //LD (nn),IY
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        PUT_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p), Z80A_REG_IY);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $23: //INC IY
      begin
        Gi_Z80A_CLOCK := 10;
        gt_INC_16TO16(Z80A_REG_IY, Z80A_REG_IY);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $24: //INC IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_INC_8TO8(GET_Z80A_REG_IYH, Reg8);
        PUT_Z80A_REG_IYH(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $25: //DEC IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_DEC_8TO8(GET_Z80A_REG_IYH, Reg8);
        PUT_Z80A_REG_IYH(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $26: //LD IYH,n '@@@@@
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 11;
        PUT_Z80A_REG_IYH(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $29: //ADD IY,IY
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IY, Z80A_REG_IY, Z80A_REG_IY, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2A: //LD IY,(nn)
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 20;
        Z80A_REG_IY := GET_MSX_MEMORY_16(GET_MSX_MEMORY_16(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2B: //DEC IY
      begin
        Gi_Z80A_CLOCK := 10;
        gt_DEC_16TO16(Z80A_REG_IY, Z80A_REG_IY);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2C: //INC IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_INC_8TO8(GET_Z80A_REG_IYL, Reg8);
        PUT_Z80A_REG_IYL(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2D: //DEC IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_DEC_8TO8(GET_Z80A_REG_IYL, Reg8);
        PUT_Z80A_REG_IYL(Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $2E: //LD IYL,n '@@@@@
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 11;
        PUT_Z80A_REG_IYL(GET_MSX_MEMORY(PC1p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $34: //INC (IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 23;
        gt_INC_8TO8(GET_MSX_MEMORY(GetIxyIdx), Reg8);
        PUT_MSX_MEMORY(GetIxyIdx, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $35: //DEC (IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 23;
        gt_DEC_8TO8(GET_MSX_MEMORY(GetIxyIdx), Reg8);
        PUT_MSX_MEMORY(GetIxyIdx, Reg8);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $36: //LD (IY+d),n
      begin
        iSz := 4;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, GET_MSX_MEMORY(PC2p));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $39: //ADD IY,SP
      begin
        Gi_Z80A_CLOCK := 15;
        gt_ADD_16TO16(Z80A_REG_IY, Z80A_REG_SP, Z80A_REG_IY, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $44: //LD B,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_B := GET_Z80A_REG_IYH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $45: //LD B,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_B := GET_Z80A_REG_IYL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $46: //LD B,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_B := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4C: //LD C,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_C := GET_Z80A_REG_IYH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4D: //LD C,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_C := GET_Z80A_REG_IYL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $4E: //LD C,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_C := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $54: //LD D,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_D := GET_Z80A_REG_IYH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $55: //LD D,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_D := GET_Z80A_REG_IYL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $56: //LD D,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_D := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5C: //LD E,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_E := GET_Z80A_REG_IYH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5D: //LD E,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_E := GET_Z80A_REG_IYL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $5E: //LD E,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_E := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $60: //LD IYH,B '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $61: //LD IYH,C '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $62: //LD IYH,D '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $63: //LD IYH,E '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $64: //LD IYH,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
      //PUT_Z80A_REG_IYH(GET_Z80A_REG_IYH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $65: //LD IYH,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(GET_Z80A_REG_IYL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $66: //LD H,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_H := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $67: //LD IYH,A '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYH(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $68: //LD IYL,B '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $69: //LD IYL,C '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6A: //LD IYL,D '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6B: //LD IYL,E '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6C: //LD IYL,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(GET_Z80A_REG_IYH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6D: //LD IYL,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
      //PUT_Z80A_REG_IYL(GET_Z80A_REG_IYL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6E: //LD L,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_L := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $6F: //LD IYL,A '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        PUT_Z80A_REG_IYL(Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $70: //LD (IY+d),B
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_B);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $71: //LD (IY+d),C
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_C);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $72: //LD (IY+d),D
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_D);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $73: //LD (IY+d),E
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_E);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $74: //LD (IY+d),H
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_H);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $75: //LD (IY+d),L
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_L);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $77: //LD (IY+d),A
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        PUT_MSX_MEMORY(GetIxyIdx, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7C: //LD A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_A := GET_Z80A_REG_IYH;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7D: //LD A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_A := GET_Z80A_REG_IYL;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $7E: //LD A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        Z80A_REG_A := GET_MSX_MEMORY(GetIxyIdx);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $84: //ADD A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $85: //ADD A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $86: //ADD A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8C: //ADC A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8D: //ADC A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_ADD_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $8E: //ADC A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_ADD_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $94: //SUB A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $95: //SUB A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $96: //SUB A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 0);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9C: //SBC A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9D: //SBC A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_SUB_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $9E: //SBC A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_SUB_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A, 1);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A4: //AND A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_AND_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A5: //AND A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_AND_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $A6: //AND A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_AND_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AC: //XOR A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_XOR_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AD: //XOR A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_XOR_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $AE: //XOR A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_XOR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B4: //OR A,IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_OR_8TO8(Z80A_REG_A, GET_Z80A_REG_IYH, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B5: //OR A,IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_OR_8TO8(Z80A_REG_A, GET_Z80A_REG_IYL, Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $B6: //OR A,(IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_OR_8TO8(Z80A_REG_A, GET_MSX_MEMORY(GetIxyIdx), Z80A_REG_A);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BC: //CP IYH '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_CP(GET_Z80A_REG_IYH);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BD: //CP IYL '@@@@@
      begin
        Gi_Z80A_CLOCK := 8;
        gt_CP(GET_Z80A_REG_IYL);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $BE: //CP (IY+d)
      begin
        iSz := 3;
        Gi_Z80A_CLOCK := 19;
        gt_CP(GET_MSX_MEMORY(GetIxyIdx));
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $CB: //FD-CB - IY bit instruction
      begin
        EXEC_Z80A_ADD_PC(1, 0);
        EXEC_Z80A_CODE_FD_CB;
      end;
    $E1: //POP IY
      begin
        Gi_Z80A_CLOCK := 14;
        gt_POP_16(Z80A_REG_IY);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E3: //EX (SP),IY
      begin
        Gi_Z80A_CLOCK := 23;
        Reg16 := GET_MSX_MEMORY_16(Z80A_REG_SP);
        PUT_MSX_MEMORY_16(Z80A_REG_SP, Z80A_REG_IY);
        Z80A_REG_IY := Reg16;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E5: //PUSH IY
      begin
        Gi_Z80A_CLOCK := 15;
        gt_PUSH_16(Z80A_REG_IY);
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
    $E9: //JP (IY)
      begin
        Gi_Z80A_CLOCK := 8;
        Z80A_REG_PC := Z80A_REG_IY; //PC<-IY
        EXEC_Z80A_ADD_PC(0, iSz); //2
      end;
    $F9: //LD SP,IY
      begin
        Gi_Z80A_CLOCK := 10;
        Z80A_REG_SP := Z80A_REG_IY;
        EXEC_Z80A_ADD_PC(iSz - 1, 0);
      end;
  Else
    begin
      Gi_Z80A_CLOCK := 0;
      EXEC_Z80A_ADD_PC(0, 0); //없는명령은취소됨
    end;
  End;
end;

end.

