unit msxMSX;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var

const
  csMSX_Version = '2024.04.20';

var
  GiMENU: ShortInt; //0:초기,1:시작,2:중지

  GiMSX2: ShortInt; //0:MSX,1:MSX2
  GiDISK: ShortInt; //1:Disk Rom Load
  GiCHAR: ShortInt; //Font - 0:8*8,1:6*8
  GiSC2X: ShortInt; //1:Scale2x

  Gi_MSX2_Sets: ShortInt;
  Gi_DISK_Sets: ShortInt;
  Gi_CHAR_Sets: ShortInt;
  Gi_SC2X_Sets: ShortInt;

  Gi_MSX_Int_Timer: ShortInt; //Timer 속도 (10~100)
  Gi_MSX_DisplayFrame: ShortInt; //1초에 0:60번[16],1:30번[33],2:22번[45],3:16번[62]

  Gi_MSX_InterruptDup: ShortInt; //1:인터럽트중복허용
  Gi_MSX_Auto_Speed: ShortInt; //1:Auto Speed
  Gi_MSX_KeyChange: ShortInt; //1:Key Change
  Gi_MSX_JoyOn: ShortInt; //1:조이스틱사용
  Gi_MSX_SpaceOn: ShortInt; //1:Space On
  Gi_MSX_VDT_ST_FF: ShortInt;

  Gs_CAS_FILE: String;
  Gs_ROM_FILE: String;
  Gi_ROM_TYPE: ShortInt;
  Gs_DSK_A_FILE: String;
  Gs_DSK_B_FILE: String;
  Gi_DSK_A_ON: ShortInt;
  Gi_DSK_B_ON: ShortInt;

  Gs_DSK_A_IsFn: String;
  Gs_DSK_B_IsFn: String;
  Gi_DSK_A_IsOk: ShortInt;
  Gi_DSK_B_IsOk: ShortInt;

  Gi_MSX_Execute: ShortInt; //0:중지,1:실행중 //-128~127
  Gi_MSX_GotFocus: ShortInt; //0:없음,1:포커스

  Gi_Z80A_CLOCK: LongInt; //-2,147,483,648 ~ 2,147,483,647
  Gi_Z80A_ClockSize: LongInt;

  Gi_MSX_Timer_60_INT: ShortInt; //1초60번확인(INT)
  Gi_MSX_Timer_16_VDP: ShortInt; //1초16번확인(VDP)

  procedure MSX_INIT;
  function gsGetRomFileName(fName: String): String;
  function gsGetDskFileName(fName: String): String;
  function gsGetCasFileName(fName: String): String;
  function gsGetMsxFileName(fName: String): String;

implementation

uses
  msxINT, msxMEM, msxIO, msxPPI, msxVDT, msxPSG, msxFDC, msxTBL, msxMSX_Init,
  untFunction;

procedure MSX_INIT;
begin
  MSX_INIT_INT;
  MSX_INIT_MEM;
  MSX_INIT_IO;
  MSX_INIT_PPI;
  MSX_INIT_VDT;
  MSX_INIT_PSG;
  MSX_INIT_FDC;

  MSX_INIT_P_Table;
  MSX_INIT_B_Table;
  MSX_INIT_MD_Table;

  MSX_Color_Setting;
  MSX_Compute_Oct_Hz;

  if (GiMSX2 = 0) then //MSX1
    Get_MSX1_ROM
  else //MSX2
    Get_MSX2_ROM
  ;
  if (GiDISK = 1) then Get_MSX_DISK_ROM; //DISK

end;

function gsGetRomFileName(fName: String): String;
var
  R: String;
label
  LastProc;
begin
  R := '';
  fName := gmsTrim(fName);
  if (fName = '') then goto LastProc;
  if (gmsUpper(gmsRight(fName, 4)) = '.ROM') then R := fName;
LastProc:
  Result := R;
end;

function gsGetDskFileName(fName: String): String;
var
  R: String;
label
  LastProc;
begin
  R := '';
  fName := gmsTrim(fName);
  if (fName = '') then goto LastProc;
  if (gmsUpper(gmsRight(fName, 4)) = '.DSK') then R := fName;
LastProc:
  Result := R;
end;

function gsGetCasFileName(fName: String): String;
var
  R: String;
label
  LastProc;
begin
  R := '';
  fName := gmsTrim(fName);
  if (fName = '') then goto LastProc;
  if (gmsUpper(gmsRight(fName, 4)) = '.CAS') then R := fName;
LastProc:
  Result := R;
end;

function gsGetMsxFileName(fName: String): String;
var
  R: String;
label
  LastProc;
begin
  R := '';
  fName := gmsTrim(fName);
  if (fName = '') then goto LastProc;
  if (gmsUpper(gmsRight(fName, 4)) = '.MSX') then R := fName;
LastProc:
  Result := R;
end;

end.

