unit msxPPI;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, Windows;

var
  //MSX_PPI_REG_A: Byte; //Slot Page
  //Gi_MEM_PAGE0: ShortInt; //-128~127
  //Gi_MEM_PAGE1: ShortInt;
  //Gi_MEM_PAGE2: ShortInt;
  //Gi_MEM_PAGE3: ShortInt;

  MSX_PPI_REG_B: Byte; //RegC(KMT) 에서 지정된 키매트릭스 상태값

  //MSX_PPI_REG_C: Byte;
  MSX_PPI_REG_C_KSO: Byte; //7 bit - 1-bit Sound output, 1:on, 0:off - 비트사운드출력
  MSX_PPI_REG_C_KCL: Byte; //6 bit - Keyboard CAPS LED, 1:off, 0:on
  MSX_PPI_REG_C_CWT: Byte; //5 bit - Cassette Write Signal, 1:on, 0:off
  MSX_PPI_REG_C_CMT: Byte; //4 bit - Cassette Motor, 1:off, 0:on
  MSX_PPI_REG_C_KMT: Byte; //3~0 bit - Keyboard Matrix의 지정행번호 (0~10)

  procedure MSX_INIT_PPI;
  function GET_MSX_PPI_REG_A: Byte;
  function GET_MSX_PPI_REG_C: Byte;
  procedure PUT_MSX_PPI_REG_C(iVal: Byte);
  function gb_MSX_KEY_X: ShortInt;
  function gb_MSX_KEY_Z: ShortInt;
  function gb_MSX_KEY_Left: ShortInt;
  function gb_MSX_KEY_Right: ShortInt;
  function gb_MSX_KEY_Up: ShortInt;
  function gb_MSX_KEY_Down: ShortInt;
  procedure SET_MSX_KEY_STATUS;

implementation

uses
  msxMSX, msxZ80A, msxMEM, msxTBL;

procedure MSX_INIT_PPI;
begin
  //MSX_PPI_REG_A := 0;
  MSX_PPI_REG_B := 0;
  //MSX_PPI_REG_C := 0;

  MSX_PPI_REG_C_KSO := 0;
  MSX_PPI_REG_C_KCL := 0;
  MSX_PPI_REG_C_CWT := 0;
  MSX_PPI_REG_C_CMT := 0;
  MSX_PPI_REG_C_KMT := 0;
end;

function GET_MSX_PPI_REG_A: Byte;
var
  R: Byte;
begin
  R := 0;
  R := (R + Gi_M_Table64[Gi_MEM_PAGE3]);
  R := (R + Gi_M_Table16[Gi_MEM_PAGE2]);
  R := (R + Gi_M_Table4[Gi_MEM_PAGE1]);
  R := (R + Gi_MEM_PAGE0);

  Result := R;
end;

function GET_MSX_PPI_REG_C: Byte;
var
  R: Byte;
begin
  R := 0;
  R := (R + Go_M_Table128[MSX_PPI_REG_C_KSO]);
  R := (R + Gi_M_Table64[MSX_PPI_REG_C_KCL]);
  R := (R + Gi_M_Table32[MSX_PPI_REG_C_CWT]);
  R := (R + Gi_M_Table16[MSX_PPI_REG_C_CMT]);
  R := (R + MSX_PPI_REG_C_KMT);

  Result := R;
end;

procedure PUT_MSX_PPI_REG_C(iVal: Byte);
begin
  MSX_PPI_REG_C_KSO := IfThen((iVal And 128) = 0, 0, 1); //1-bit Sound output, 1:on - 비트사운드출력
  MSX_PPI_REG_C_KCL := IfThen((iVal And 64) = 0, 0, 1);  //Keyboard CAPS LED, 0:on
  MSX_PPI_REG_C_CWT := IfThen((iVal And 32) = 0, 0, 1);  //Cassette Write Signal, 1:on
  MSX_PPI_REG_C_CMT := IfThen((iVal And 16) = 0, 0, 1);  //Cassette Motor, 0:on
  MSX_PPI_REG_C_KMT := (iVal And 15);                    //Keyboard Matrix의 지정행번호 (0~10)
end;

function gb_MSX_KEY_X: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(88) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

function gb_MSX_KEY_Z: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(90) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

function gb_MSX_KEY_Left: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(37) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

function gb_MSX_KEY_Right: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(39) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

function gb_MSX_KEY_Up: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(38) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

function gb_MSX_KEY_Down: ShortInt;
begin
  Result := IfThen(((GetAsyncKeyState(40) And 32768) > 0) And (Gi_MSX_GotFocus = 1), 1, 0);
end;

procedure SET_MSX_KEY_STATUS;
var
  T: Byte;
  Key7, Key6, Key5, Key4, Key3, Key2, Key1, Key0: ShortInt;
  iRet0, iRet1, iBreak, iTab: ShortInt;
  iSpc, iF09, iF12: ShortInt;
  NumS, NumP, NumA, NumK: ShortInt;
label
  NextProc, LastProc;
begin
  //002C: 11 ;0001 0 001(1:International (QWERTY/other) Keyboard)
  //GetAsyncKeyState
  //0000h: 이전에 누른 적이 없고 호출 시점에 안 눌린 상태
  //0001h: 이전에 누른 적이 있고 호출 시점에 안 눌린 상태
  //8000h: 이전에 누른 적이 없고 호출 시점에 눌린 상태
  //8001h: 이전에 누른 적이 있고 호출 시점에 눌린 상태

  NumS := IfThen((GetAsyncKeyState(111) And 32768) > 0, 1, 0); //[/]
  NumP := IfThen((GetAsyncKeyState(107) And 32768) > 0, 1, 0); //[+]
  NumA := IfThen((GetAsyncKeyState(106) And 32768) > 0, 1, 0); //[*]
  NumK := (NumP Or NumA);

  T := 0;

  if (Gi_MSX_GotFocus <> 1) then goto LastProc;

  //7,6,5,4,3,2,1,0
  if (MSX_PPI_REG_C_KMT = 0) then
    begin
      Key7 := IfThen((GetAsyncKeyState(55) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(54) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(53) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(52) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(51) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(50) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(49) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(48) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

  //;,],[,\,=,-,9,8
  if (MSX_PPI_REG_C_KMT = 1) then
    begin
      Key7 := IfThen((GetAsyncKeyState(186) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(221) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(219) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(220) And 32768) > 0, 1, 0);
      if (GiMSX2 = 0) then
        begin
          Key3 := (IfThen((GetAsyncKeyState(187) And 32768) > 0, 1, 0) Or (NumP)); //[+]
        end
      else
        begin
          Key3 := IfThen((GetAsyncKeyState(187) And 32768) > 0, 1, 0); //[+]
        end;
      Key2 := IfThen((GetAsyncKeyState(189) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(57) And 32768) > 0, 1, 0);
      if (GiMSX2 = 0) then
        begin
          Key0 := (IfThen((GetAsyncKeyState(56) And 32768) > 0, 1, 0) Or (NumA)); //[*]
        end
      else
        begin
          Key0 := IfThen((GetAsyncKeyState(56) And 32768) > 0, 1, 0); //[*]
        end;
      goto NextProc;
    end;

  //B,A,DEAD-END,/,.>,,<,`~,'"
  if (MSX_PPI_REG_C_KMT = 2) then
    begin
      Key7 := IfThen((GetAsyncKeyState(66) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 0) then Key6 := IfThen((GetAsyncKeyState(65) And 32768) > 0, 1, 0); //A
      Key5 := IfThen((GetAsyncKeyState(35) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 1) then Key5 := IfThen((GetAsyncKeyState(68) And 32768) > 0, 1, 0); //D->-[DEAD]
      if (GiMSX2 = 0) then
        begin
          Key4 := (IfThen((GetAsyncKeyState(191) And 32768) > 0, 1, 0) Or (NumS));
        end
      else
        begin
          Key4 := IfThen((GetAsyncKeyState(191) And 32768) > 0, 1, 0);
        end;
      if (Gi_MSX_KeyChange = 1) then Key4 := IfThen((GetAsyncKeyState(83) And 32768) > 0, 1, 0); //->/?
      Key3 := IfThen((GetAsyncKeyState(190) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 1) then Key3 := IfThen((GetAsyncKeyState(65) And 32768) > 0, 1, 0); //A->.>
      Key2 := IfThen((GetAsyncKeyState(188) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(192) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(222) And 32768) > 0, 1, 0);
      goto NextProc;
     end;

  //J,I,H,G,F,E,D,C
  if (MSX_PPI_REG_C_KMT = 3) then
    begin
      Key7 := IfThen((GetAsyncKeyState(74) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(73) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(72) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(71) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 0) then Key3 := IfThen((GetAsyncKeyState(70) And 32768) > 0, 1, 0); //F
      Key2 := IfThen((GetAsyncKeyState(69) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 0) then Key1 := IfThen((GetAsyncKeyState(68) And 32768) > 0, 1, 0); //D
      Key0 := IfThen((GetAsyncKeyState(67) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

  //R,Q,P,O,N,M,L,K
  if (MSX_PPI_REG_C_KMT = 4) then
    begin
      Key7 := IfThen((GetAsyncKeyState(82) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(81) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(80) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(79) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(78) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(77) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(76) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(75) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

  //Z,Y,X,W,V,U,T,S
  if (MSX_PPI_REG_C_KMT = 5) then
    begin
      Key7 := IfThen((GetAsyncKeyState(90) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(89) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(88) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(87) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(86) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(85) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(84) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 0) then Key0 := IfThen((GetAsyncKeyState(83) And 32768) > 0, 1, 0); //S
      goto NextProc;
    end;

  //F3[F8],F2[F7],F1[F6],CODE-F07,CAPLOCK,GRAPH-F08,CTRL,SHIFT
  if (MSX_PPI_REG_C_KMT = 6) then
    begin
      //iF08 := ((GetAsyncKeyState(119) And 32768) > 0 ? 1 : 0); 'F08
      //iHanEng := ((GetAsyncKeyState(229) And 32768) > 0 ? 1 : 0); '한/영
      //iHanJa := ((GetAsyncKeyState(25) And 32768) > 0 ? 1 : 0); '한자
      Key7 := IfThen((GetAsyncKeyState(114) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(113) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(112) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(118) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(20) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(119) And 32768) > 0, 1, 0);
      if (Gi_MSX_KeyChange = 1) then Key2 := IfThen((GetAsyncKeyState(70) And 32768) > 0, 1, 0); //F->GRAPH
      Key1 := IfThen((GetAsyncKeyState(17) And 32768) > 0, 1, 0);
      if (GiMSX2 = 0) then
        begin
          Key0 := (IfThen((GetAsyncKeyState(16) And 32768) > 0, 1, 0) Or (NumK)); //Shift
        end
      else
        begin
          Key0 := IfThen((GetAsyncKeyState(16) And 32768) > 0, 1, 0); //Shift
        end;
      goto NextProc;
    end;

  //Result :=,SELECT-F11,BS,STOP-BREAK/PAUSE/F12,TAB-F9,ESC,F5[F10],F4[F9]
  if (MSX_PPI_REG_C_KMT = 7) then
    begin
      iRet0 := IfThen((GetAsyncKeyState(13) And 32768) > 0, 1, 0); //Enter
      iRet1 := IfThen((GetAsyncKeyState(108) And 32768) > 0, 1, 0); //Num Enter
      iBreak := IfThen((GetAsyncKeyState(19) And 32768) > 0, 1, 0); //Pause/Break
      iTab := IfThen((GetAsyncKeyState(9) And 32768) > 0, 1, 0); //Tab
      iF09 := IfThen((GetAsyncKeyState(120) And 32768) > 0, 1, 0); //F09
      iF12 := IfThen((GetAsyncKeyState(123) And 32768) > 0, 1, 0); //F12
      Key7 := (iRet0 Or iRet1);
      Key6 := IfThen((GetAsyncKeyState(122) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(8) And 32768) > 0, 1, 0);
      Key4 := (iBreak Or iF12);
      Key3 := (iTab Or iF09);
      Key2 := IfThen((GetAsyncKeyState(27) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(116) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(115) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

  //RIGHT,DOWN,UP,LEFT,DEL,INS,HOME[CLS],SPACE
  if (MSX_PPI_REG_C_KMT = 8) then
    begin
      iSpc := IfThen((GetAsyncKeyState(32) And 32768) > 0, 1, 0); //Space
      Key7 := IfThen((GetAsyncKeyState(39) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(40) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(38) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(37) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(46) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(45) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(36) And 32768) > 0, 1, 0);
      Key0 := (iSpc Or Gi_MSX_SpaceOn);
      goto NextProc;
    end;

  //키패드 4,3,2,1,0,/,+,*
  if (MSX_PPI_REG_C_KMT = 9) then
    begin
      Key7 := IfThen((GetAsyncKeyState(100) And 32768) > 0, 1, 0);
      Key6 := IfThen((GetAsyncKeyState(99) And 32768) > 0, 1, 0);
      Key5 := IfThen((GetAsyncKeyState(98) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(97) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(96) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(111) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(107) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(106) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

  //키피드 .,,-NOT,-,9,8,7,6,5
  if (MSX_PPI_REG_C_KMT = 10) then
    begin
      Key7 := IfThen((GetAsyncKeyState(110) And 32768) > 0, 1, 0);
      Key6 := 0;
      Key5 := IfThen((GetAsyncKeyState(109) And 32768) > 0, 1, 0);
      Key4 := IfThen((GetAsyncKeyState(105) And 32768) > 0, 1, 0);
      Key3 := IfThen((GetAsyncKeyState(104) And 32768) > 0, 1, 0);
      Key2 := IfThen((GetAsyncKeyState(103) And 32768) > 0, 1, 0);
      Key1 := IfThen((GetAsyncKeyState(102) And 32768) > 0, 1, 0);
      Key0 := IfThen((GetAsyncKeyState(101) And 32768) > 0, 1, 0);
      goto NextProc;
    end;

NextProc:
  if (Key7 = 1) then T := (T Or 128);
  if (Key6 = 1) then T := (T Or 64);
  if (Key5 = 1) then T := (T Or 32);
  if (Key4 = 1) then T := (T Or 16);
  if (Key3 = 1) then T := (T Or 8);
  if (Key2 = 1) then T := (T Or 4);
  if (Key1 = 1) then T := (T Or 2);
  if (Key0 = 1) then T := (T Or 1);

LastProc:
  MSX_PPI_REG_B := giGetIntToInt(Not T); //부정NOT
end;

  //F07 -> CODE
  //F08 -> GRAPH
  //F09 -> TAB
  //F11 -> SELECT
  //F12 -> STOP
  //END -> DEAD[-]

end.

