unit msxPSG;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math;

var
  MSX_PSG_REG: Array[0..16-1] Of Byte; //0~255 [0~15]

  //PSG 레지스터
  //R00-채널A음성분주기-하위8비트
  //R01-채널A음성분주기-상위4비트
  //R02-채널B음성분주기-하위8비트
  //R03-채널B음성분주기-상위4비트
  //R04-채널C음성분주기-하위8비트
  //R05-채널C음성분주기-상위4비트
  //R06-노이즈분주기
  //R07-음의믹싱
  //R08-채널A음량
  //R09-채널B음량
  //R10-채널C음량
  //R11-엔빌로프주기-하위8비트
  //R12-엔빌로프주기-상위8비트
  //R13-엔빌로프파형
  //R14-I/O포트A(Read) - 7bit:카세트입력비트데이터, 6bit:0(키보드50음배열),1(Jis배열),5~0bit:범용입출력인터페이스접속7,6,4,3,2,1
  //R15-I/O포트B(Write) - 7bit:1(가나모드표시램프소등), 6bit:범용입출력인터페이스#1[0]/#2[1]와접속, bit5:인터페이스2의8번단자, bit4:인터페이스1의8번단자

  Gd_MSX_PSG_Oct_Hz: Array[0..128-1] Of Double; //Double [0~127]

  Go_MSX_PSG_TONE_A: Word;
  Gi_MSX_PSG_VEV_A: ShortInt;
  Gi_MSX_PSG_VOL_A: ShortInt;
  Go_MSX_PSG_TONE_B: Word;
  Gi_MSX_PSG_VEV_B: ShortInt;
  Gi_MSX_PSG_VOL_B: ShortInt;
  Go_MSX_PSG_TONE_C: Word;
  Gi_MSX_PSG_VEV_C: ShortInt;
  Gi_MSX_PSG_VOL_C: ShortInt;
  Go_MSX_PSG_NOISE: ShortInt;
  Go_MSX_PSG_TONE_EV: Word;
  Gi_MSX_PSG_PATN_EV: ShortInt;

  Gi_MSX_PSG_T_ON_A: ShortInt;
  Gi_MSX_PSG_T_ON_B: ShortInt;
  Gi_MSX_PSG_T_ON_C: ShortInt;

  Gi_MSX_PSG_N_ON_A: ShortInt;
  Gi_MSX_PSG_N_ON_B: ShortInt;
  Gi_MSX_PSG_N_ON_C: ShortInt;

  Gi_MIDI_TON_A: SmallInt;
  Gi_MIDI_TON_B: SmallInt;
  Gi_MIDI_TON_C: SmallInt;
  Gi_MIDI_TON_NS: SmallInt;

  Gi_MIDI_VOL_A: ShortInt;
  Gi_MIDI_VOL_B: ShortInt;
  Gi_MIDI_VOL_C: ShortInt;

  Gi_MSX_PSG_T_ON_A_Bak: ShortInt;
  Gi_MSX_PSG_T_ON_B_Bak: ShortInt;
  Gi_MSX_PSG_T_ON_C_Bak: ShortInt;

  Gi_MIDI_TON_A_Bak: SmallInt;
  Gi_MIDI_TON_B_Bak: SmallInt;
  Gi_MIDI_TON_C_Bak: SmallInt;

  Gi_MIDI_VEV_A_Bak: ShortInt;
  Gi_MIDI_VEV_B_Bak: ShortInt;
  Gi_MIDI_VEV_C_Bak: ShortInt;

  Gi_MIDI_VOL_A_Bak: ShortInt;
  Gi_MIDI_VOL_B_Bak: ShortInt;
  Gi_MIDI_VOL_C_Bak: ShortInt;

  procedure MSX_INIT_PSG;
  procedure SET_MSX_PSG_STATUS;
  procedure MSX_PSG_REG_R00_WRITE;
  procedure MSX_PSG_REG_R01_WRITE;
  procedure MSX_PSG_REG_R02_WRITE;
  procedure MSX_PSG_REG_R03_WRITE;
  procedure MSX_PSG_REG_R04_WRITE;
  procedure MSX_PSG_REG_R05_WRITE;
  procedure MSX_PSG_REG_R06_WRITE;
  procedure MSX_PSG_REG_R07_WRITE;
  procedure MSX_PSG_REG_R08_WRITE;
  procedure MSX_PSG_REG_R09_WRITE;
  procedure MSX_PSG_REG_R10_WRITE;
  procedure MSX_PSG_REG_R11_WRITE;
  procedure MSX_PSG_REG_R12_WRITE;
  procedure MSX_PSG_REG_R13_WRITE;
  procedure MSX_PSG_MIDI_TONE_A;
  procedure MSX_PSG_MIDI_TONE_B;
  procedure MSX_PSG_MIDI_TONE_C;
  procedure MSX_PSG_MIDI_NOISE;
  procedure MSX_PSG_MIDI_VOL_A;
  procedure MSX_PSG_MIDI_VOL_B;
  procedure MSX_PSG_MIDI_VOL_C;
  function fi_GET_TON_TO_MIDI(oTon: Word; iNos: ShortInt): SmallInt;
  function fi_GET_VOL_TO_MIDI(iVol: ShortInt): ShortInt;
  procedure MSX_Compute_Oct_Hz;

implementation

uses
  msxMSX, msxZ80A, msxPPI, msxPSG_OUT;

procedure MSX_INIT_PSG;
var
  i: Integer;
begin
  for i := 0 to 15 do
    MSX_PSG_REG[i] := 0;

  for i := 0 to 127 do
    Gd_MSX_PSG_Oct_Hz[i] := 0;

  Go_MSX_PSG_TONE_A := 0;
  Gi_MSX_PSG_VEV_A := 0;
  Gi_MSX_PSG_VOL_A := 0;
  Go_MSX_PSG_TONE_B := 0;
  Gi_MSX_PSG_VEV_B := 0;
  Gi_MSX_PSG_VOL_B := 0;
  Go_MSX_PSG_TONE_C := 0;
  Gi_MSX_PSG_VEV_C := 0;
  Gi_MSX_PSG_VOL_C := 0;
  Go_MSX_PSG_NOISE := 0;
  Go_MSX_PSG_TONE_EV := 0;
  Gi_MSX_PSG_PATN_EV := 0;
  Gi_MSX_PSG_T_ON_A := 1;
  Gi_MSX_PSG_T_ON_B := 1;
  Gi_MSX_PSG_T_ON_C := 1;
  Gi_MSX_PSG_N_ON_A := 1;
  Gi_MSX_PSG_N_ON_B := 1;
  Gi_MSX_PSG_N_ON_C := 1;

  Gi_MIDI_TON_A := 0;
  Gi_MIDI_TON_B := 0;
  Gi_MIDI_TON_C := 0;
  Gi_MIDI_TON_NS := 0;
  Gi_MIDI_VOL_A := 0;
  Gi_MIDI_VOL_B := 0;
  Gi_MIDI_VOL_C := 0;

  Gi_MSX_PSG_T_ON_A_Bak := 0;
  Gi_MSX_PSG_T_ON_B_Bak := 0;
  Gi_MSX_PSG_T_ON_C_Bak := 0;
  Gi_MIDI_TON_A_Bak := 0;
  Gi_MIDI_TON_B_Bak := 0;
  Gi_MIDI_TON_C_Bak := 0;
  Gi_MIDI_VEV_A_Bak := 0;
  Gi_MIDI_VEV_B_Bak := 0;
  Gi_MIDI_VEV_C_Bak := 0;
  Gi_MIDI_VOL_A_Bak := 0;
  Gi_MIDI_VOL_B_Bak := 0;
  Gi_MIDI_VOL_C_Bak := 0;
end;

procedure SET_MSX_PSG_STATUS;
var
  R: ShortInt;
  CasMotor: ShortInt;
  CasRead, KbdType: ShortInt;
  JoyBtnB, JoyBtnA: ShortInt;
  JoyRight, JoyLeft, JoyDown, JoyUp: ShortInt;
begin
  //A포트-R14
  //I/O포트A (Read)
  //MSX_PSG_REG_R14 'I/O포트A(Read)  b7:(카세트데이터입력),b6:(0:키50음배열,1:JIS배열),b5:(7번단자),b4:(6),b3:(4),b2:(3),b1:(2),b0(1) - 범용입출력인터페이스접속
  //MSX_PSG_REG_R15 'I/O포트B(Write) b7:(0:한글키LED-On,1:Off),b6:(0:포트A의5~0가법용입출력인터페이스1번과접속,1:2번과접속),b:(범용입출력인터페이스2의8번단자에접속),b4:(1의8번단자접속),b3~b0(사용안함)
  CasMotor := MSX_PPI_REG_C_CMT; //0:On,1:Off
  CasRead := 0; //0:Low,1:High
  KbdType := 0; //0:50음배열,JIS배열
  JoyBtnB := IfThen((Gb_MSX_KEY_Z = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  JoyBtnA := IfThen((Gb_MSX_KEY_X = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  JoyRight := IfThen((Gb_MSX_KEY_Right = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  JoyLeft := IfThen((Gb_MSX_KEY_Left = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  JoyDown := IfThen((Gb_MSX_KEY_Down = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  JoyUp := IfThen((Gb_MSX_KEY_Up = 1) And (Gi_MSX_JoyOn = 1), 0, 1); //0:On,1:Off
  R := 0;
  if (CasRead = 1) then R := (R + 128);
  if (KbdType = 1) then R := (R + 64);
  if (JoyBtnB = 1) then R := (R + 32);
  if (JoyBtnA = 1) then R := (R + 16);
  if (JoyRight = 1) then R := (R + 8);
  if (JoyLeft = 1) then R := (R + 4);
  if (JoyDown = 1) then R := (R + 2);
  if (JoyUp = 1) then R := (R + 1);
  MSX_PSG_REG[14] := (R);
end;

procedure MSX_PSG_REG_R00_WRITE;
begin
  //MSX_PSG_REG_R00 '채널A음성분주기-하위8비트
  Go_MSX_PSG_TONE_A := goGetIntHLToLng((MSX_PSG_REG[01] And 15), MSX_PSG_REG[00]);
  MSX_PSG_MIDI_TONE_A;
end;

procedure MSX_PSG_REG_R01_WRITE;
begin
  //MSX_PSG_REG_R01 '채널A음성분주기-상위4비트
  Go_MSX_PSG_TONE_A := goGetIntHLToLng((MSX_PSG_REG[01] And 15), MSX_PSG_REG[00]);
  MSX_PSG_MIDI_TONE_A;
end;

procedure MSX_PSG_REG_R02_WRITE;
begin
  //MSX_PSG_REG_R02 '채널B음성분주기-하위8비트
  Go_MSX_PSG_TONE_B := goGetIntHLToLng((MSX_PSG_REG[03] And 15), MSX_PSG_REG[02]);
  MSX_PSG_MIDI_TONE_B;
end;

procedure MSX_PSG_REG_R03_WRITE;
begin
  //MSX_PSG_REG_R03 '채널B음성분주기-상위4비트
  Go_MSX_PSG_TONE_B := goGetIntHLToLng((MSX_PSG_REG[03] And 15), MSX_PSG_REG[02]);
  MSX_PSG_MIDI_TONE_B;
end;

procedure MSX_PSG_REG_R04_WRITE;
begin
  //MSX_PSG_REG_R04 '채널C음성분주기-하위8비트
  Go_MSX_PSG_TONE_C := goGetIntHLToLng((MSX_PSG_REG[05] And 15), MSX_PSG_REG[04]);
  MSX_PSG_MIDI_TONE_C;
end;

procedure MSX_PSG_REG_R05_WRITE;
begin
  //MSX_PSG_REG_R05 '채널C음성분주기-상위4비트
  Go_MSX_PSG_TONE_C := goGetIntHLToLng((MSX_PSG_REG[05] And 15), MSX_PSG_REG[04]);
  MSX_PSG_MIDI_TONE_C;
end;

procedure MSX_PSG_REG_R06_WRITE;
begin
  //MSX_PSG_REG_R06 '노이즈분주기-하위5비트
  Go_MSX_PSG_NOISE := (MSX_PSG_REG[06] And 31);
  MSX_PSG_MIDI_NOISE;
end;

procedure MSX_PSG_REG_R07_WRITE;
begin
  //MSX_PSG_REG_R07 '음의믹싱-In/Out(1:B포트출력),(0:A포트입력),Noise(C),(B),(A),Tone(C),(B),(A)-0:On,1:Off
  Gi_MSX_PSG_N_ON_C := IfThen((MSX_PSG_REG[07] And 32) = 0, 0, 1);
  Gi_MSX_PSG_N_ON_B := IfThen((MSX_PSG_REG[07] And 16) = 0, 0, 1);
  Gi_MSX_PSG_N_ON_A := IfThen((MSX_PSG_REG[07] And 8) = 0, 0, 1);
  Gi_MSX_PSG_T_ON_C := IfThen((MSX_PSG_REG[07] And 4) = 0, 0, 1);
  Gi_MSX_PSG_T_ON_B := IfThen((MSX_PSG_REG[07] And 2) = 0, 0, 1);
  Gi_MSX_PSG_T_ON_A := IfThen((MSX_PSG_REG[07] And 1) = 0, 0, 1);
end;

procedure MSX_PSG_REG_R08_WRITE;
begin
  //MSX_PSG_REG_R08 '채널A음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
  Gi_MSX_PSG_VEV_A := IfThen((MSX_PSG_REG[08] And 16) = 0, 0, 1);
  Gi_MSX_PSG_VOL_A := ((MSX_PSG_REG[08] And 15));
  MSX_PSG_MIDI_VOL_A;
end;

procedure MSX_PSG_REG_R09_WRITE;
begin
  //MSX_PSG_REG_R09 '채널B음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
  Gi_MSX_PSG_VEV_B := IfThen((MSX_PSG_REG[09] And 16) = 0, 0, 1);
  Gi_MSX_PSG_VOL_B := ((MSX_PSG_REG[09] And 15));
  MSX_PSG_MIDI_VOL_B;
end;

procedure MSX_PSG_REG_R10_WRITE;
begin
  //MSX_PSG_REG_R10 '채널C음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
  Gi_MSX_PSG_VEV_C := IfThen((MSX_PSG_REG[10] And 16) = 0, 0, 1);
  Gi_MSX_PSG_VOL_C := ((MSX_PSG_REG[10] And 15));
  MSX_PSG_MIDI_VOL_C;
end;

procedure MSX_PSG_REG_R11_WRITE;
begin
  //MSX_PSG_REG_R11 '엔빌로프주기-하위8비트
  Go_MSX_PSG_TONE_EV := goGetIntHLToLng(MSX_PSG_REG[12], MSX_PSG_REG[11]);
end;

procedure MSX_PSG_REG_R12_WRITE;
begin
  //MSX_PSG_REG_R12 '엔빌로프주기-상위8비트
  Go_MSX_PSG_TONE_EV := goGetIntHLToLng(MSX_PSG_REG[12], MSX_PSG_REG[11]);
end;

procedure MSX_PSG_REG_R13_WRITE;
begin
  //MSX_PSG_REG_R13 '엔빌로프패턴-하위4비트
  Gi_MSX_PSG_PATN_EV := ((MSX_PSG_REG[13] And 15));
end;

procedure MSX_PSG_MIDI_TONE_A;
begin
  Gi_MIDI_TON_A := fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_A, 0);
end;

procedure MSX_PSG_MIDI_TONE_B;
begin
  Gi_MIDI_TON_B := fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_B, 0);
end;

procedure MSX_PSG_MIDI_TONE_C;
begin
  Gi_MIDI_TON_C := fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_C, 0);
end;

procedure MSX_PSG_MIDI_NOISE;
begin
  Gi_MIDI_TON_NS := fi_GET_TON_TO_MIDI(Go_MSX_PSG_NOISE, 1); //?
end;

procedure MSX_PSG_MIDI_VOL_A;
begin
  Gi_MIDI_VOL_A := fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_A);
end;

procedure MSX_PSG_MIDI_VOL_B;
begin
  Gi_MIDI_VOL_B := fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_B);
end;

procedure MSX_PSG_MIDI_VOL_C;
begin
  Gi_MIDI_VOL_C := fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_C);
end;

function fi_GET_TON_TO_MIDI(oTon: Word; iNos: ShortInt): SmallInt;
var
  i: Byte; R: SmallInt; Hz: Double; cHz: Double; bHz: Double;
label
  LastProc;
begin
  if (oTon = 0) then begin R := -1; goto LastProc; end;
  if (iNos = 0) then
    begin
      Hz := 111860.78125 / oTon; //주파수계산(27(FFFh)~111860(001h))
    end
  else
    begin
      //Hz := 111860.78125 / oTon / 1000; //주파수계산(3.6(31)~111.9(1))
      Hz := 111860.78125 / oTon / 10; //360~11,190
    end;
  R := 0;
  bHz := 12545;
  for i := 0 to 127 do
    begin
      cHz := Abs(Hz - Gd_MSX_PSG_Oct_Hz[i]);
      if (cHz < bHz) then
        begin
          bHz := cHz;
          R := i;
        end
      else
        begin
          goto LastProc;
        end;
    end;

LastProc:
  Result := R;
end;

function fi_GET_VOL_TO_MIDI(iVol: ShortInt): ShortInt;
var
  R: Byte;
begin
  R := Trunc(iVol * 8.5); //Int() 타입불일치 오류발생 (자동캐스팅안됨)
  if (R > fiMaxVol) then R := fiMaxVol;

  Result := R;
end;

procedure MSX_Compute_Oct_Hz;
var
  i: Integer; j: ShortInt; Hz: Double;
begin
  Gd_MSX_PSG_Oct_Hz[69] := 440;
  j := 0;
  for i := 70 to 127 do
    begin
      j := j + 1;
      hz := 440 * (Power(2, (j / 12.0)));
      Gd_MSX_PSG_Oct_Hz[i] := hz;
    end;
  j := 0;
  for i := 68 downto 0 do
    begin
      j := j - 1;
      hz := 440 * (Power(2, (j / 12.0)));
      Gd_MSX_PSG_Oct_Hz[i] := hz;
    end;
end;

end.

