unit msxPSG_OUT;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, MMSystem;

const
  fiMaxVol = 127;

  fiMidi = 71;   //71:Clarinet, 80:Square Wave
  fiMidi2 = 0;   //0:Grand Piano
  fiNoise = 127; //127:Gunshot

var
  Gi_MDH: LongInt;
  Gb_MidiOpened: Boolean;

  procedure gt_MSX_Midi_Open;
  procedure gt_MSX_Midi_Close;
  procedure gt_MSX_Midi_Out(iCmd: Byte; iChannel: Byte; iTone: Byte; iVolume: Byte);
  procedure MSX_PSG_TONE_OUT_A(iOn: ShortInt);
  procedure MSX_PSG_TONE_OUT_B(iOn: ShortInt);
  procedure MSX_PSG_TONE_OUT_C(iOn: ShortInt);
  procedure MSX_PSG_NOISE_OUT_A(iOn: ShortInt);
  procedure MSX_PSG_NOISE_OUT_B(iOn: ShortInt);
  procedure MSX_PSG_NOISE_OUT_C(iOn: ShortInt);

implementation

uses
  msxPSG;

procedure gt_MSX_Midi_Open;
begin
  //핸들,Mapper,0,0,CallBack_Null
  if (midiOutOpen(@Gi_MDH, 0, 0, 0, 0) = 0) then //Gi_MDH<-미디를열고핸들을저장
    begin
      Gb_MidiOpened := true;
      gt_MSX_Midi_Out($C0, 1, fiMidi, 0); //악기선택
      gt_MSX_Midi_Out($C0, 2, fiMidi, 0);
      gt_MSX_Midi_Out($C0, 3, fiMidi, 0);
      gt_MSX_Midi_Out($C0, 4, fiNoise, 0); //악기선택
      gt_MSX_Midi_Out($C0, 5, fiNoise, 0);
      gt_MSX_Midi_Out($C0, 6, fiNoise, 0);
    end;
end;

procedure gt_MSX_Midi_Close;
begin
  //핸들
  if (Gb_MidiOpened) then
    begin
      midiOutReset(Gi_MDH);
      midiOutClose(Gi_MDH); //미디닫기(Gi_MDH핸들)
      Gb_MidiOpened := false;
    end;
end;

procedure gt_MSX_Midi_Out(iCmd: Byte; iChannel: Byte; iTone: Byte; iVolume: Byte);
begin
  //핸들,명령코드,채널(0~15),파라미터1(톤0~127),파라미터2(볼륨0~127)
  //명령코드 90h~9Fh(채널1~16)-노트On, 80h~8Fh(채널1~16)-노트Off
  //         C0h~CFh(채널1~16)-악기변경,D0h~DFh-ChannelAfterTouch,E0h~EFh-ChannelPitchWheel
  //60=도,61=도#,62=레
  if (Gb_MidiOpened) then
    midiOutShortMsg(Gi_MDH, ((iCmd + iChannel - 1) Or (iTone * 256) Or (iVolume * 65536)));
end;

procedure MSX_PSG_TONE_OUT_A(iOn: ShortInt);
begin
  if ((iOn = 0) And (Gi_MIDI_TON_A >= 0)) then
    begin
      if ((Gi_MSX_PSG_T_ON_A_Bak = 0) Or (Gi_MIDI_TON_A_Bak <> Gi_MIDI_TON_A) Or (Gi_MIDI_VEV_A_Bak <> Gi_MSX_PSG_VEV_A) Or (Gi_MIDI_VOL_A_Bak <> Gi_MIDI_VOL_A)) then
        begin
          if (Gi_MSX_PSG_T_ON_A_Bak = 1) then begin gt_MSX_Midi_Out($80, 1, Gi_MIDI_TON_A_Bak, 0); Gi_MSX_PSG_T_ON_A_Bak := 0; end;
          if ((Gi_MIDI_VEV_A_Bak <> Gi_MSX_PSG_VEV_A)) then
            begin
              if ((Gi_MSX_PSG_VEV_A = 0)) then
                gt_MSX_Midi_Out($C0, 1, fiMidi, 0) //악기선택
              else
                gt_MSX_Midi_Out($C0, 1, fiMidi2, 0) //악기선택
              ;
            end;
          if ((Gi_MSX_PSG_VEV_A = 0) And (Gi_MIDI_VOL_A > 0)) then begin gt_MSX_Midi_Out($90, 1, Gi_MIDI_TON_A, Gi_MIDI_VOL_A); Gi_MSX_PSG_T_ON_A_Bak := 1; end;
          if (Gi_MSX_PSG_VEV_A = 1) then begin gt_MSX_Midi_Out($90, 1, Gi_MIDI_TON_A, fiMaxVol); Gi_MSX_PSG_T_ON_A_Bak := 1; end;
        end;
      Gi_MIDI_TON_A_Bak := Gi_MIDI_TON_A;
      Gi_MIDI_VEV_A_Bak := Gi_MSX_PSG_VEV_A;
      Gi_MIDI_VOL_A_Bak := Gi_MIDI_VOL_A;
    end
  else
    begin
      if (Gi_MSX_PSG_T_ON_A_Bak = 1) then begin gt_MSX_Midi_Out($80, 1, Gi_MIDI_TON_A_Bak, 0); Gi_MSX_PSG_T_ON_A_Bak := 0; end
    end;
end;

procedure MSX_PSG_TONE_OUT_B(iOn: ShortInt);
begin
 if ((iOn = 0) And (Gi_MIDI_TON_B >= 0)) then
    begin
      if ((Gi_MSX_PSG_T_ON_B_Bak = 0) Or (Gi_MIDI_TON_B_Bak <> Gi_MIDI_TON_B) Or (Gi_MIDI_VEV_B_Bak <> Gi_MSX_PSG_VEV_B) Or (Gi_MIDI_VOL_B_Bak <> Gi_MIDI_VOL_B)) then
        begin
          if (Gi_MSX_PSG_T_ON_B_Bak = 1) then begin gt_MSX_Midi_Out($80, 2, Gi_MIDI_TON_B_Bak, 0); Gi_MSX_PSG_T_ON_B_Bak := 0; end;
          if ((Gi_MIDI_VEV_B_Bak <> Gi_MSX_PSG_VEV_B)) then
            begin
              if ((Gi_MSX_PSG_VEV_B = 0)) then
                gt_MSX_Midi_Out($C0, 2, fiMidi, 0) //악기선택
              else
                gt_MSX_Midi_Out($C0, 2, fiMidi2, 0) //악기선택
              ;
            end;
          if ((Gi_MSX_PSG_VEV_B = 0) And (Gi_MIDI_VOL_B > 0)) then begin gt_MSX_Midi_Out($90, 2, Gi_MIDI_TON_B, Gi_MIDI_VOL_B); Gi_MSX_PSG_T_ON_B_Bak := 1; end;
          if (Gi_MSX_PSG_VEV_B = 1) then begin gt_MSX_Midi_Out($90, 2, Gi_MIDI_TON_B, fiMaxVol); Gi_MSX_PSG_T_ON_B_Bak := 1; end;
        end;
      Gi_MIDI_TON_B_Bak := Gi_MIDI_TON_B;
      Gi_MIDI_VEV_B_Bak := Gi_MSX_PSG_VEV_B;
      Gi_MIDI_VOL_B_Bak := Gi_MIDI_VOL_B;
    end
  else
    begin
      if (Gi_MSX_PSG_T_ON_B_Bak = 1) then begin gt_MSX_Midi_Out($80, 2, Gi_MIDI_TON_B_Bak, 0); Gi_MSX_PSG_T_ON_B_Bak := 0; end
    end;
end;

procedure MSX_PSG_TONE_OUT_C(iOn: ShortInt);
begin
  if ((iOn = 0) And (Gi_MIDI_TON_C >= 0)) then
    begin
      if ((Gi_MSX_PSG_T_ON_C_Bak = 0) Or (Gi_MIDI_TON_C_Bak <> Gi_MIDI_TON_C) Or (Gi_MIDI_VEV_C_Bak <> Gi_MSX_PSG_VEV_C) Or (Gi_MIDI_VOL_C_Bak <> Gi_MIDI_VOL_C)) then
        begin
          if (Gi_MSX_PSG_T_ON_C_Bak = 1) then begin gt_MSX_Midi_Out($80, 3, Gi_MIDI_TON_C_Bak, 0); Gi_MSX_PSG_T_ON_C_Bak := 0; end;
          if ((Gi_MIDI_VEV_C_Bak <> Gi_MSX_PSG_VEV_C)) then
            begin
              if ((Gi_MSX_PSG_VEV_C = 0)) then
                gt_MSX_Midi_Out($C0, 3, fiMidi, 0) //악기선택
              else
                gt_MSX_Midi_Out($C0, 3, fiMidi2, 0) //악기선택
              ;
            end;
          if ((Gi_MSX_PSG_VEV_C = 0) And (Gi_MIDI_VOL_C > 0)) then begin gt_MSX_Midi_Out($90, 3, Gi_MIDI_TON_C, Gi_MIDI_VOL_C); Gi_MSX_PSG_T_ON_C_Bak := 1; end;
          if (Gi_MSX_PSG_VEV_C = 1) then begin gt_MSX_Midi_Out($90, 3, Gi_MIDI_TON_C, fiMaxVol); Gi_MSX_PSG_T_ON_C_Bak := 1; end;
        end;
      Gi_MIDI_TON_C_Bak := Gi_MIDI_TON_C;
      Gi_MIDI_VEV_C_Bak := Gi_MSX_PSG_VEV_C;
      Gi_MIDI_VOL_C_Bak := Gi_MIDI_VOL_C;
    end
  else
    begin
      if (Gi_MSX_PSG_T_ON_C_Bak = 1) then begin gt_MSX_Midi_Out($80, 3, Gi_MIDI_TON_C_Bak, 0); Gi_MSX_PSG_T_ON_C_Bak := 0; end
    end;
end;

procedure MSX_PSG_NOISE_OUT_A(iOn: ShortInt);
begin
  if ((iOn = 0) And (Gi_MIDI_TON_NS >= 0)) then
    begin
      if ((Gi_MSX_PSG_VEV_A = 0) And (Gi_MIDI_VOL_A > 0)) then gt_MSX_Midi_Out($90, 4, Gi_MIDI_TON_NS, Gi_MIDI_VOL_A);
      if ((Gi_MSX_PSG_VEV_A = 1)) then gt_MSX_Midi_Out($90, 4, Gi_MIDI_TON_NS, fiMaxVol);
    end;
end;

procedure MSX_PSG_NOISE_OUT_B(iOn: ShortInt);
begin
  if ((iOn = 0) And (Gi_MIDI_TON_NS >= 0)) then
    begin
      if ((Gi_MSX_PSG_VEV_B = 0) And (Gi_MIDI_VOL_B > 0)) then gt_MSX_Midi_Out($90, 5, Gi_MIDI_TON_NS, Gi_MIDI_VOL_B);
      if ((Gi_MSX_PSG_VEV_B = 1)) then gt_MSX_Midi_Out($90, 5, Gi_MIDI_TON_NS, fiMaxVol);
    end;
end;

procedure MSX_PSG_NOISE_OUT_C(iOn: ShortInt);
begin
  if ((iOn = 0) And (Gi_MIDI_TON_NS >= 0)) then
    begin
      if ((Gi_MSX_PSG_VEV_C = 0) And (Gi_MIDI_VOL_C > 0)) then gt_MSX_Midi_Out($90, 6, Gi_MIDI_TON_NS, Gi_MIDI_VOL_C);
      if ((Gi_MSX_PSG_VEV_C = 1)) then gt_MSX_Midi_Out($90, 6, Gi_MIDI_TON_NS, fiMaxVol);
    end;
end;

end.

