unit msxSaveLoad;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure MsxSaveStatus;
  procedure MsxLoadStatus(FileName: String);

implementation

uses
  msxZ80A, msxINT, msxMEM, msxIO, msxPPI, msxVDT, msxPSG;

procedure MsxSaveStatus;
var
  FH: File Of Byte;
  i, j: Integer;
  b, bh, bl: Byte;
  FileName: String;
begin
  FileName := 'C:\MSX-' + FormatDateTime('YYYYMMDD', Now) + '-' + FormatDateTime('HHMMSS', Now) + '.MSX';
  AssignFile(FH, FileName);

  Rewrite(FH); //출력(기존파일이있으면삭제)

  //Z80A
  gtMoveLngToIntHL(Z80A_REG_PC, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Z80A_REG_SP, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Z80A_REG_IX, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Z80A_REG_IY, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Z80A_REG_A; Write(FH, b);
  b := Z80A_REG_F; Write(FH, b);
  b := Z80A_REG_B; Write(FH, b);
  b := Z80A_REG_C; Write(FH, b);
  b := Z80A_REG_D; Write(FH, b);
  b := Z80A_REG_E; Write(FH, b);
  b := Z80A_REG_H; Write(FH, b);
  b := Z80A_REG_L; Write(FH, b);
  b := Z80A_REG_A2; Write(FH, b);
  b := Z80A_REG_F2; Write(FH, b);
  b := Z80A_REG_B2; Write(FH, b);
  b := Z80A_REG_C2; Write(FH, b);
  b := Z80A_REG_D2; Write(FH, b);
  b := Z80A_REG_E2; Write(FH, b);
  b := Z80A_REG_H2; Write(FH, b);
  b := Z80A_REG_L2; Write(FH, b);
  b := Z80A_REG_I; Write(FH, b);
  b := Z80A_REG_R; Write(FH, b);
  b := Z80A_REG_IFF1; Write(FH, b);
  b := Z80A_REG_IFF2; Write(FH, b);

  //INT
  b := Gi_MSX_Interrupt; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_InterruptBack, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Z80A_INT_MODE; Write(FH, b);
  b := Z80A_HALT; Write(FH, b);

  //MEM
  for i := 0 to (4 - 1) do
    begin
      for j := 0 to (65536 - 1) do
        begin
          b := MSX_MEM[i, j]; Write(FH, b);
        end;
    end;
  b := Gi_MEM_PAGE0; Write(FH, b);
  b := Gi_MEM_PAGE1; Write(FH, b);
  b := Gi_MEM_PAGE2; Write(FH, b);
  b := Gi_MEM_PAGE3; Write(FH, b);
  b := Gi_MEM_EXT_PAGE0; Write(FH, b);
  b := Gi_MEM_EXT_PAGE1; Write(FH, b);
  b := Gi_MEM_EXT_PAGE2; Write(FH, b);
  b := Gi_MEM_EXT_PAGE3; Write(FH, b);
  for i := 0 to (4194304 - 1) do
    begin
      b := MSX_ROM[i]; Write(FH, b);
    end;
  b := Gi_Big32K_ROM; Write(FH, b);
  for i := 0 to (4194304 - 1) do
    begin
      b := MSX_RAM[i]; Write(FH, b);
    end;
  b := Gi_RAM_PAGE0; Write(FH, b);
  b := Gi_RAM_PAGE1; Write(FH, b);
  b := Gi_RAM_PAGE2; Write(FH, b);
  b := Gi_RAM_PAGE3; Write(FH, b);

  //IO
  for i := 0 to (256 - 1) do
    begin
      b := MSX_PORT[i]; Write(FH, b);
    end;
  for i := 0 to (4 - 1) do
    begin
      for j := 0 to (16 - 1) do
        begin
          b := MSX_CLOCK_REG[i, j]; Write(FH, b);
        end;
    end;
  b := Gi_MSX_PortWrite; Write(FH, b);

  //PPI
  b := MSX_PPI_REG_B; Write(FH, b);
  b := MSX_PPI_REG_C_KSO; Write(FH, b);
  b := MSX_PPI_REG_C_KCL; Write(FH, b);
  b := MSX_PPI_REG_C_CWT; Write(FH, b);
  b := MSX_PPI_REG_C_CMT; Write(FH, b);
  b := MSX_PPI_REG_C_KMT; Write(FH, b);

  //VDT
  for i := 0 to (131072 - 1) do
    begin
      b := MSX_VRAM[i]; Write(FH, b);
    end;
  for i := 0 to (47 - 1) do
    begin
      b := MSX_VDT_REG[i]; Write(FH, b);
    end;
  b := MSX_VDT_REG_IE1; Write(FH, b);
  b := MSX_VDT_REG_EV; Write(FH, b);
  b := MSX_VDT_REG_16K; Write(FH, b);
  b := MSX_VDT_REG_ON; Write(FH, b);
  b := MSX_VDT_REG_IE0; Write(FH, b);
  b := MSX_VDT_REG_SZ; Write(FH, b);
  b := MSX_VDT_REG_SM; Write(FH, b);
  b := MSX_VDT_REG_TP; Write(FH, b);
  b := MSX_VDT_REG_SPD; Write(FH, b);
  b := MSX_VDT_REG_LN; Write(FH, b);
  b := MSX_VDT_REG_IL; Write(FH, b);
  b := MSX_VDT_REG_EO; Write(FH, b);
  for i := 0 to (131072 - 1) do
    begin
      b := MSX_VRAM_Buff[i]; Write(FH, b);
    end;
  gtMoveLngToIntHL(Go_MSX_VRAM_Buff_Size, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VRAM_Buff_Count, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SX, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SY, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DX, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DY, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NX, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_Mjg, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NY, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_Min, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_VDT_CMD_REG_Color; Write(FH, b);
  b := MSX_VDT_CMD_REG_MXC; Write(FH, b);
  b := MSX_VDT_CMD_REG_MXD; Write(FH, b);
  b := MSX_VDT_CMD_REG_MXS; Write(FH, b);
  b := MSX_VDT_CMD_REG_DIY; Write(FH, b);
  b := MSX_VDT_CMD_REG_DIX; Write(FH, b);
  b := MSX_VDT_CMD_REG_EQ; Write(FH, b);
  b := MSX_VDT_CMD_REG_MAJ; Write(FH, b);
  b := MSX_VDT_CMD_REG_CMD; Write(FH, b);
  b := MSX_VDT_CMD_REG_LO; Write(FH, b);
  b := MSX_VDT_ST_REG_FF; Write(FH, b);
  b := Gi_MSX_VDT_ST_REG_FF; Write(FH, b);
  b := MSX_VDT_ST_REG_5S; Write(FH, b);
  b := MSX_VDT_ST_REG_C; Write(FH, b);
  b := MSX_VDT_ST_REG_5SN; Write(FH, b);
  b := MSX_VDT_ST_REG_FL; Write(FH, b);
  b := MSX_VDT_ST_REG_LPS; Write(FH, b);
  b := MSX_VDT_ST_REG_ID; Write(FH, b);
  b := MSX_VDT_ST_REG_FH; Write(FH, b);
  b := MSX_VDT_ST_REG_TR; Write(FH, b);
  b := MSX_VDT_ST_REG_VR; Write(FH, b);
  b := MSX_VDT_ST_REG_HR; Write(FH, b);
  b := MSX_VDT_ST_REG_BD; Write(FH, b);
  b := MSX_VDT_ST_REG_EO; Write(FH, b);
  b := MSX_VDT_ST_REG_CE; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_ST_REG_Column, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_ST_REG_Row, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_VDT_ST_REG_Color; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VDT_ST_REG_BX, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_SCREEN_MODE; Write(FH, b);
  b := Gi_MSX_VRAM_IO; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_VRAM_ADDRESS, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_VRAM_Flg; Write(FH, b);
  b := Gi_MSX2_VRAM_Flg; Write(FH, b);
  for i := 0 to (16 - 1) do
    begin
      b := MSX_VDT_REG_PAL_Red[i]; Write(FH, b);
      b := MSX_VDT_REG_PAL_Green[i]; Write(FH, b);
      b := MSX_VDT_REG_PAL_Blue[i]; Write(FH, b);
    end;

  //PSG
  for i := 0 to (16 - 1) do
    begin
      b := MSX_PSG_REG[i]; Write(FH, b);
    end;
  gtMoveLngToIntHL(Go_MSX_PSG_TONE_A, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_PSG_VEV_A; Write(FH, b);
  b := Gi_MSX_PSG_VOL_A; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_PSG_TONE_B, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_PSG_VEV_B; Write(FH, b);
  b := Gi_MSX_PSG_VOL_B; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_PSG_TONE_C, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_PSG_VEV_C; Write(FH, b);
  b := Gi_MSX_PSG_VOL_C; Write(FH, b);
  b := Go_MSX_PSG_NOISE; Write(FH, b);
  gtMoveLngToIntHL(Go_MSX_PSG_TONE_EV, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MSX_PSG_PATN_EV; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_A; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_B; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_C; Write(FH, b);
  b := Gi_MSX_PSG_N_ON_A; Write(FH, b);
  b := Gi_MSX_PSG_N_ON_B; Write(FH, b);
  b := Gi_MSX_PSG_N_ON_C; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_A, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_B, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_C, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_NS, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MIDI_VOL_A; Write(FH, b);
  b := Gi_MIDI_VOL_B; Write(FH, b);
  b := Gi_MIDI_VOL_C; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_A_Bak; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_B_Bak; Write(FH, b);
  b := Gi_MSX_PSG_T_ON_C_Bak; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_A_Bak, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_B_Bak, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  gtMoveLngToIntHL(Gi_MIDI_TON_C_Bak, bh, bl);
  b := bl; Write(FH, b);
  b := bh; Write(FH, b);
  b := Gi_MIDI_VEV_A_Bak; Write(FH, b);
  b := Gi_MIDI_VEV_B_Bak; Write(FH, b);
  b := Gi_MIDI_VEV_C_Bak; Write(FH, b);
  b := Gi_MIDI_VOL_A_Bak; Write(FH, b);
  b := Gi_MIDI_VOL_B_Bak; Write(FH, b);
  b := Gi_MIDI_VOL_C_Bak; Write(FH, b);

  CloseFile(FH);
end;

procedure MsxLoadStatus(FileName: String);
var
  FH: File Of Byte;
  i, j: Integer;
  b, bh, bl: Byte;
begin
  AssignFile(FH, FileName);

  Reset(FH); //입력(파일없으면오류발생), 파일사이즈함수:FileSize(FH)

  //Z80A
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Z80A_REG_PC := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Z80A_REG_SP := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Z80A_REG_IX := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Z80A_REG_IY := goGetIntHLToLng(bh, bl);
  Read(FH, b); Z80A_REG_A := b;
  Read(FH, b); Z80A_REG_F := b;
  Read(FH, b); Z80A_REG_B := b;
  Read(FH, b); Z80A_REG_C := b;
  Read(FH, b); Z80A_REG_D := b;
  Read(FH, b); Z80A_REG_E := b;
  Read(FH, b); Z80A_REG_H := b;
  Read(FH, b); Z80A_REG_L := b;
  Read(FH, b); Z80A_REG_A2 := b;
  Read(FH, b); Z80A_REG_F2 := b;
  Read(FH, b); Z80A_REG_B2 := b;
  Read(FH, b); Z80A_REG_C2 := b;
  Read(FH, b); Z80A_REG_D2 := b;
  Read(FH, b); Z80A_REG_E2 := b;
  Read(FH, b); Z80A_REG_H2 := b;
  Read(FH, b); Z80A_REG_L2 := b;
  Read(FH, b); Z80A_REG_I := b;
  Read(FH, b); Z80A_REG_R := b;
  Read(FH, b); Z80A_REG_IFF1 := b;
  Read(FH, b); Z80A_REG_IFF2 := b;

  //INT
  Read(FH, b); Gi_MSX_Interrupt := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_InterruptBack := goGetIntHLToLng(bh, bl);
  Read(FH, b); Z80A_INT_MODE := b;
  Read(FH, b); Z80A_HALT := b;

  //MEM
  for i := 0 to (4 - 1) do
    begin
      for j := 0 to (65536 - 1) do
        begin
          Read(FH, b); MSX_MEM[i, j] := b;
        end;
    end;
  Read(FH, b); Gi_MEM_PAGE0 := b;
  Read(FH, b); Gi_MEM_PAGE1 := b;
  Read(FH, b); Gi_MEM_PAGE2 := b;
  Read(FH, b); Gi_MEM_PAGE3 := b;
  Read(FH, b); Gi_MEM_EXT_PAGE0 := b;
  Read(FH, b); Gi_MEM_EXT_PAGE1 := b;
  Read(FH, b); Gi_MEM_EXT_PAGE2 := b;
  Read(FH, b); Gi_MEM_EXT_PAGE3 := b;
  for i := 0 to (4194304 - 1) do
    begin
      Read(FH, b); MSX_ROM[i] := b;
    end;
  Read(FH, b); Gi_Big32K_ROM := b;
  for i := 0 to (4194304 - 1) do
    begin
      Read(FH, b); MSX_RAM[i] := b;
    end;
  Read(FH, b); Gi_RAM_PAGE0 := b;
  Read(FH, b); Gi_RAM_PAGE1 := b;
  Read(FH, b); Gi_RAM_PAGE2 := b;
  Read(FH, b); Gi_RAM_PAGE3 := b;

  //IO
  for i := 0 to (256 - 1) do
    begin
      Read(FH, b); MSX_PORT[i] := b;
    end;
  for i := 0 to (4 - 1) do
    begin
      for j := 0 to (16 - 1) do
        begin
          Read(FH, b); MSX_CLOCK_REG[i, j] := b;
        end;
    end;
  Read(FH, b); Gi_MSX_PortWrite := b;

  //PPI
  Read(FH, b); MSX_PPI_REG_B := b;
  Read(FH, b); MSX_PPI_REG_C_KSO := b;
  Read(FH, b); MSX_PPI_REG_C_KCL := b;
  Read(FH, b); MSX_PPI_REG_C_CWT := b;
  Read(FH, b); MSX_PPI_REG_C_CMT := b;
  Read(FH, b); MSX_PPI_REG_C_KMT := b;

  //VDT
  for i := 0 to (131072 - 1) do
    begin
      Read(FH, b); MSX_VRAM[i] := b;
    end;
  for i := 0 to (47 - 1) do
    begin
      Read(FH, b); MSX_VDT_REG[i] := b;
    end;
  Read(FH, b); MSX_VDT_REG_IE1 := b;
  Read(FH, b); MSX_VDT_REG_EV := b;
  Read(FH, b); MSX_VDT_REG_16K := b;
  Read(FH, b); MSX_VDT_REG_ON := b;
  Read(FH, b); MSX_VDT_REG_IE0 := b;
  Read(FH, b); MSX_VDT_REG_SZ  := b;
  Read(FH, b); MSX_VDT_REG_SM := b;
  Read(FH, b); MSX_VDT_REG_TP := b;
  Read(FH, b); MSX_VDT_REG_SPD := b;
  Read(FH, b); MSX_VDT_REG_LN := b;
  Read(FH, b); MSX_VDT_REG_IL := b;
  Read(FH, b); MSX_VDT_REG_EO := b;
  for i := 0 to (131072 - 1) do
    begin
      Read(FH, b); MSX_VRAM_Buff[i] := b;
    end;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VRAM_Buff_Size := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VRAM_Buff_Count := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_SX := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_SY := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_DX := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_DY := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_NX := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_Mjg := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_NY := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_CMD_REG_Min := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_VDT_CMD_REG_Color := b;
  Read(FH, b); MSX_VDT_CMD_REG_MXC := b;
  Read(FH, b); MSX_VDT_CMD_REG_MXD := b;
  Read(FH, b); MSX_VDT_CMD_REG_MXS := b;
  Read(FH, b); MSX_VDT_CMD_REG_DIY := b;
  Read(FH, b); MSX_VDT_CMD_REG_DIX := b;
  Read(FH, b); MSX_VDT_CMD_REG_EQ := b;
  Read(FH, b); MSX_VDT_CMD_REG_MAJ := b;
  Read(FH, b); MSX_VDT_CMD_REG_CMD := b;
  Read(FH, b); MSX_VDT_CMD_REG_LO := b;
  Read(FH, b); MSX_VDT_ST_REG_FF := b;
  Read(FH, b); Gi_MSX_VDT_ST_REG_FF := b;
  Read(FH, b); MSX_VDT_ST_REG_5S := b;
  Read(FH, b); MSX_VDT_ST_REG_C := b;
  Read(FH, b); MSX_VDT_ST_REG_5SN := b;
  Read(FH, b); MSX_VDT_ST_REG_FL := b;
  Read(FH, b); MSX_VDT_ST_REG_LPS := b;
  Read(FH, b); MSX_VDT_ST_REG_ID := b;
  Read(FH, b); MSX_VDT_ST_REG_FH := b;
  Read(FH, b); MSX_VDT_ST_REG_TR := b;
  Read(FH, b); MSX_VDT_ST_REG_VR := b;
  Read(FH, b); MSX_VDT_ST_REG_HR := b;
  Read(FH, b); MSX_VDT_ST_REG_BD := b;
  Read(FH, b); MSX_VDT_ST_REG_EO := b;
  Read(FH, b); MSX_VDT_ST_REG_CE := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_ST_REG_Column := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_ST_REG_Row := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_VDT_ST_REG_Color := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VDT_ST_REG_BX := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_SCREEN_MODE := b;
  Read(FH, b); Gi_MSX_VRAM_IO := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_VRAM_ADDRESS := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_VRAM_Flg := b;
  Read(FH, b); Gi_MSX2_VRAM_Flg := b;
  for i := 0 to (16 - 1) do
    begin
      Read(FH, b); MSX_VDT_REG_PAL_Red[i] := b;
      Read(FH, b); MSX_VDT_REG_PAL_Green[i] := b;
      Read(FH, b); MSX_VDT_REG_PAL_Blue[i] := b;
      MSX_COLOR_PALETTE(i, MSX_VDT_REG_PAL_Red[i], MSX_VDT_REG_PAL_Green[i], MSX_VDT_REG_PAL_Blue[i]);
    end;

  //PSG
  for i := 0 to (16 - 1) do
    begin
      Read(FH, b); MSX_PSG_REG[i] := b;
    end;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_PSG_TONE_A := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_PSG_VEV_A := b;
  Read(FH, b); Gi_MSX_PSG_VOL_A := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_PSG_TONE_B := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_PSG_VEV_B := b;
  Read(FH, b); Gi_MSX_PSG_VOL_B := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_PSG_TONE_C := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_PSG_VEV_C := b;
  Read(FH, b); Gi_MSX_PSG_VOL_C := b;
  Read(FH, b); Go_MSX_PSG_NOISE := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Go_MSX_PSG_TONE_EV := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MSX_PSG_PATN_EV := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_A := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_B := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_C := b;
  Read(FH, b); Gi_MSX_PSG_N_ON_A := b;
  Read(FH, b); Gi_MSX_PSG_N_ON_B := b;
  Read(FH, b); Gi_MSX_PSG_N_ON_C := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_A := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_B := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_C := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_NS := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MIDI_VOL_A := b;
  Read(FH, b); Gi_MIDI_VOL_B := b;
  Read(FH, b); Gi_MIDI_VOL_C := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_A_Bak := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_B_Bak := b;
  Read(FH, b); Gi_MSX_PSG_T_ON_C_Bak := b;
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_A_Bak := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_B_Bak := goGetIntHLToLng(bh, bl);
  Read(FH, b); bl := b;
  Read(FH, b); bh := b;
  Gi_MIDI_TON_C_Bak := goGetIntHLToLng(bh, bl);
  Read(FH, b); Gi_MIDI_VEV_A_Bak := b;
  Read(FH, b); Gi_MIDI_VEV_B_Bak := b;
  Read(FH, b); Gi_MIDI_VEV_C_Bak := b;
  Read(FH, b); Gi_MIDI_VOL_A_Bak := b;
  Read(FH, b); Gi_MIDI_VOL_B_Bak := b;
  Read(FH, b); Gi_MIDI_VOL_C_Bak := b;

  CloseFile(FH);
end;

end.

