unit msxTBL;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

var
  //PE/PO테이블
  Gi_P_Table: Array[0..256-1] Of ShortInt; //-128~127 [0~255]
  //BIT테이블
  Gi_B_Table: Array[0..8-1] Of Byte; //0~255 [0~7]
  Gi_NB_Table: Array[0..8-1] Of Byte; //0~255 [0~7]

  //Text테이블
  Gi_T_TableY: Array[0..960-1] Of LongInt;
  Gi_T_TableX: Array[0..960-1] Of LongInt;
  Go_T_VRamTable: Array[0..960-1] Of LongInt;
  //Text2테이블
  Gi_T2_TableY: Array[0..2160-1] Of LongInt;
  Gi_T2_TableX: Array[0..2160-1] Of LongInt;
  Go_T2_VRamTable: Array[0..2160-1] Of LongInt;
  //Graphic테이블
  Gi_G_TableY: Array[0..768-1] Of LongInt;
  Gi_G_TableX: Array[0..768-1] Of LongInt;
  Go_G_VRamTable: Array[0..768-1] Of LongInt;
  //Sprite-Test
  Gi_S_Table8: Array[0..1024-1] Of LongInt;
  Gi_S_TableY: Array[0..1024-1] Of LongInt;
  Gi_S_TableX: Array[0..1024-1] Of LongInt;
  Go_S_VRamTable: Array[0..1024-1] Of LongInt;
  //Color테이블
  Gi_MSX_ForeColors: Array[0..256-1] Of LongInt;
  Gi_MSX_BackColors: Array[0..256-1] Of LongInt;
  Gi_Spr_TableStart: Array[0..256-1] Of LongInt; //Sprite
  Gi_Col_Pos2: Array[0..512-1] Of LongInt; //16색상위치(0~1)
  Gi_Col_Pos4: Array[0..512-1] Of LongInt; //04색상위치(0~4)
  //Mul,Div테이블
  Gi_M_Table2: Array[0..256-1] Of LongInt;
  Gi_M_Table4: Array[0..256-1] Of LongInt;
  Gi_M_Table8: Array[0..256-1] Of LongInt;
  Gi_M_Table16: Array[0..256-1] Of LongInt;
  Gi_M_Table32: Array[0..256-1] Of LongInt;
  Gi_M_Table36: Array[0..256-1] Of LongInt;
  Gi_M_Table64: Array[0..256-1] Of LongInt;
  Go_M_Table128: Array[0..1024-1] Of LongInt;
  Go_M_Table256: Array[0..1024-1] Of LongInt;
  Go_M_Table512: Array[0..1024-1] Of LongInt;
  Go_M_Table1024: Array[0..256-1] Of LongInt;
  Go_M_Table2048: Array[0..256-1] Of LongInt;
  Go_M_Table2560: Array[0..256-1] Of LongInt;
  Go_M_Table4096: Array[0..256-1] Of LongInt;
  Go_M_Table8192: Array[0..256-1] Of LongInt;
  Go_M_Table16384: Array[0..256-1] Of LongInt;
  Go_M_Table32768: Array[0..256-1] Of LongInt;
  Go_M_Table65536: Array[0..256-1] Of LongInt;
  Gi_D_Table2: Array[0..512-1] Of LongInt;
  Gi_D_Table4: Array[0..512-1] Of LongInt;
  Gi_D_Table8: Array[0..256-1] Of LongInt;
  Gi_D_Table16: Array[0..256-1] Of LongInt;
  Gi_D_Table32: Array[0..768-1] Of LongInt;
  Gi_D_Table64: Array[0..256-1] Of LongInt;
  Gi_D_Table128: Array[0..256-1] Of LongInt;
  Gi_D_Table256: Array[0..65536-1] Of LongInt;

  procedure MSX_INIT_P_Table;
  procedure MSX_INIT_B_Table;
  procedure MSX_INIT_MD_Table;

implementation

uses
  msxMSX, msxZ80A;

procedure MSX_INIT_P_Table;
var
  P: ShortInt; i: Integer;
begin
  for i := 0 to 255 do
    begin
      P := 0;
      if ((i And 128) <> 0) then P := P + 1;
      if ((i And 64) <> 0) then P := P + 1;
      if ((i And 32) <> 0) then P := P + 1;
      if ((i And 16) <> 0) then P := P + 1;
      if ((i And 8) <> 0) then P := P + 1;
      if ((i And 4) <> 0) then P := P + 1;
      if ((i And 2) <> 0) then P := P + 1;
      if ((i And 1) <> 0) then P := P + 1;
      if ((P = 0) Or (P = 2) Or (P = 4) Or (P = 6) Or (P = 8)) then
        Gi_P_Table[i] := 1
      else
        Gi_P_Table[i] := 0
      ;
    end;
end;

procedure MSX_INIT_B_Table;
begin
  Gi_B_Table[0] := 1;
  Gi_B_Table[1] := 2;
  Gi_B_Table[2] := 4;
  Gi_B_Table[3] := 8;
  Gi_B_Table[4] := 16;
  Gi_B_Table[5] := 32;
  Gi_B_Table[6] := 64;
  Gi_B_Table[7] := 128;
  Gi_NB_Table[0] := $FE; //1111 1110
  Gi_NB_Table[1] := $FD; //1111 1101
  Gi_NB_Table[2] := $FB; //1111 1011
  Gi_NB_Table[3] := $F7; //1111 0111
  Gi_NB_Table[4] := $EF; //1110 1111
  Gi_NB_Table[5] := $DF; //1101 1111
  Gi_NB_Table[6] := $BF; //1011 1111
  Gi_NB_Table[7] := $7F; //0111 1111
end;

procedure MSX_INIT_MD_Table;
var
  i: Integer;
begin
  for i := 0 to 959 do
    begin
      Gi_T_TableY[i] := (i div 40);
      Gi_T_TableX[i] := i - (Gi_T_TableY[i] * 40);
      if (GiCHAR = 0) then
        Go_T_VRamTable[i] := (Gi_T_TableY[i] * 2560) + (Gi_T_TableX[i] * 8) //8*8=64*40=2560, 8Dot
      else
        Go_T_VRamTable[i] := (Gi_T_TableY[i] * 1920) + (Gi_T_TableX[i] * 6) //8*6=48*40=1920, 8Dot
      ;
    end;

  for i := 0 to 2159 do
    begin
      Gi_T2_TableY[i] := (i div 80);
      Gi_T2_TableX[i] := i - (Gi_T2_TableY[i] * 80);
      if (GiCHAR = 0) then
        Go_T2_VRamTable[i] := (Gi_T2_TableY[i] * 5120) + (Gi_T2_TableX[i] * 8) //8*8=64*80=5120, 8Dot
      else
        Go_T2_VRamTable[i] := (Gi_T2_TableY[i] * 3840) + (Gi_T2_TableX[i] * 6) //8*6=48*80=3840, 8Dot
      ;
    end;

  for i := 0 to 767 do
    begin
      Gi_G_TableY[i] := (i div 32);
      Gi_G_TableX[i] := i - (Gi_G_TableY[i] * 32);
      Go_G_VRamTable[i] := (Gi_G_TableY[i] * 2048) + (Gi_G_TableX[i] * 8); //8*8=64*32=2048, 8Dot
    end;

  for i := 0 to 1023 do
    begin
      Gi_S_Table8[i] := i * 8;
      Gi_S_TableY[i] := (i div 32);
      Gi_S_TableX[i] := i - (Gi_S_TableY[i] * 32);
      Go_S_VRamTable[i] := (Gi_S_TableY[i] * 2048) + (Gi_S_TableX[i] * 8);
    end;

  for i := 0 to 255 do
    begin
      Gi_MSX_ForeColors[i] := ((i And $F0) div 16);
      Gi_MSX_BackColors[i] := (i And $0F);
      Gi_Spr_TableStart[i] := (i div 4) * 4;
      Gi_M_Table2[i] := i * 2;
      Gi_M_Table4[i] := i * 4;
      Gi_M_Table8[i] := i * 8;
      Gi_M_Table16[i] := i * 16;
      Gi_M_Table32[i] := i * 32;
      Gi_M_Table36[i] := i * 36;
      Gi_M_Table64[i] := i * 64;
      Go_M_Table512[i] := i * 512;
      Go_M_Table1024[i] := i * 1024;
      Go_M_Table2048[i] := i * 2048;
      Go_M_Table2560[i] := i * 2560;
      Go_M_Table4096[i] := i * 4096;
      Go_M_Table8192[i] := i * 8192;
      Go_M_Table16384[i] := i * 16384;
      Go_M_Table32768[i] := i * 32768;
      Go_M_Table65536[i] := i * 65536;
      Gi_D_Table8[i] := (i div 8);
      Gi_D_Table16[i] := (i div 16);
      Gi_D_Table64[i] := (i div 64);
      Gi_D_Table128[i] := (i div 128);
    end;

  for i := 0 to 511 do
    begin
      Gi_Col_Pos2[i] := i mod 2;
      Gi_Col_Pos4[i] := i mod 4;
      Gi_D_Table2[i] := (i div 2);
      Gi_D_Table4[i] := (i div 4);
    end;

  for i := 0 to 767 do
    begin
      Gi_D_Table32[i] := (i div 32);
    end;

  for i := 0 to 1023 do
    begin
      Go_M_Table128[i] := i * 128;
      Go_M_Table256[i] := i * 256;
    end;

  for i := 0 to 65535 do
    begin
      Gi_D_Table256[i] := (goGetLngToLng(i And $FF00) div 256);
    end;
end;

end.

