unit msxVDT;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, Windows, Graphics;

var
  //VRAM - MSX1(3FFFh[16383])16KB, MSX2(0~1FFFFh[131071])128KB
  MSX_VRAM: Array[0..131072-1] Of Byte; //0~255 [0~16383 | 0~131071]

  MSX_VDT_REG: Array[0..47-1] Of Byte; //0~255 [0~46]
  //MSX1, #00~#07
  //#00-모드레지스터#0, Graphics Mode(7,1)
  //    '0'
  //     DG : Digitize mode: sets the color bus to the input or output mode
  //     IE2 : Enables interrupts from Light pen
  //     IE1 : Enabled interrupt from horizontal retrace
  //     M5 : Screen mode flag
  //     M4 : Screen mode flag
  //     M3 : Screen mode flag
  //     '0'
  MSX_VDT_REG_IE1: Byte; // bit - Enables interrupt from horizontal retrace
  MSX_VDT_REG_EV: Byte;  // bit - EXT VID
  //#01-모드레지스터#1, VRAM Size(1,1:4?16K), Enable(2,1/1:표시), IE(3,1), Graphics Mode(4,2), Spr Size(7,1), Spr Mag(8,1)
  //    '0'
  //    BL : Blank screen: (1:Display Enable, 0:Disable)
  //    IE0 : Enables interrupt from vertical retrace
  //    M1 : Screen mode flag
  //    M2 : Screen mode flag
  //    '0'
  //    SI : Sprite size: (1:16*16,0:8*8)
  //    MAG : Sprite enlarging: (1:Double size)
  MSX_VDT_REG_16K: Byte; //7 bit - VRAM 4K/16K
  MSX_VDT_REG_ON: Byte;  //6 bit - 1:화면표시 / BL
  MSX_VDT_REG_IE0: Byte; //5 bit - Enables interrupt from vertical retrace
  MSX_VDT_REG_SZ: Byte;  //1 bit - SPR SIZE (0:8*8,1:16*16) / SI
  MSX_VDT_REG_SM: Byte;  //0 bit - SPR MAG (0:기본,1:가로세로2배확대) / MAG
  //#02-Pattern Name Table (화면문자0~255) - 0A16~A10지정, A9~A0은0
  //#03-Color Table (4bit:bit1색+4bit:bit0색)
  //#04-Pattern Generate Table (폰트8[우측2bit표시안함]*0~255) - 00A16~A11지정, A10~A0은0
  //#05-Sprite Attribute Table
  //#06-Sprite Pattern Table
  //#07-Backdrop Color (4bit:전경색+4bit:배경색)
  //MSX2, #08~#23
  //#08-모드레지스터#2
  //    MS : Mouse
  //    LP : Light pen
  //    TP : Sets the color of code 0 to the color of the palette
  //    CB : Color bus
  //    VR : Selects the type and organization of VRAM
  //    '0'
  //    SPD : Sprite disable
  //    BW : Black/White
  MSX_VDT_REG_TP: Byte;  //5 bit - MSX2, Sets Color 0
  MSX_VDT_REG_SPD: Byte; //1 bit - MSX2, 1:소프라이트 비표시
  //#09-모드레지스터#3
  //    LN : Line: (1:212, 0:192)
  //    '0'
  //    S1 : Selects simultaneous mode
  //    S2 : Selects simultaneous mode
  //    IL : Interlace (0:1매의화면만표,1:2매의화면의교대표시)
  //    EO : Event/Odd screens (0:논인터레이스모드(보통모드),1:인터레이스모드)
  //    *NT : RGB output only: (1:PAL mode,0:NTSC mode)
  //    DC : Dot clock
  MSX_VDT_REG_LN: Byte; //7 bit - MSX2, Graphic Line - 0:192,1:212
  MSX_VDT_REG_IL: Byte; //3 bit
  MSX_VDT_REG_EO: Byte; //2 bit
  //#10-Color Table (High)
  //#11-소프라이트으트리뷰트테이블(High)
  //#12-텍스트 블링크시 문자색
  //#13-짝수페이지표시Even/6초(7~4),홀수페이지표시Odd/6초(3~0)
  //#14-VRAM의 어드레스 설정 (상위:3비트)
  //#15-S#n의 간접지정
  //#16-P#n의 간접지정
  //#17-R#n의 간접지정
  //#18-화면위치의 보정
  //#19-주사선번호, CRT가 특별한 주사선의 표시를 끝낸 순간에 가로채기를 발생시킴 (IE1=1일경우)
  //#20-컬러버스트신호1
  //#21-컬러버스트신호2
  //#22-컬러버스트신호3
  //#23-화면의 표시개시 라인을 설정 (화면의 세로방향 스크롤)

  //VRAM - MSX2, Command
  MSX_VRAM_Buff: Array[0..131072-1] Of Byte; //0~255 ['0~1FFFFh(131071)]
  Go_MSX_VRAM_Buff_Size: LongInt;
  Go_MSX_VRAM_Buff_Count: LongInt;

  //VDT Command 레지스터 - Write Only
  //MSX2, #32~#46(VDT커맨드실행시사용)
  //#32-SX: Source X - 7~0
  //#33-SX:              8
  Go_MSX_VDT_CMD_REG_SX: Word;
  //#34-SY: Source Y - 7~0
  //#35-SY:            9,8
  Go_MSX_VDT_CMD_REG_SY: Word;
  //#36-DX: Destination X - 7~0
  //#37-DX:                   8
  Go_MSX_VDT_CMD_REG_DX: Word;
  //#38-DY: Destination Y - 7~0
  //#39-DY:                 9,8
  Go_MSX_VDT_CMD_REG_DY: Word;
  //#40-NX: Number of dots in X-axis - 7~0
  //#41-NX:                              8
  Go_MSX_VDT_CMD_REG_NX: Word;
  Go_MSX_VDT_CMD_REG_Mjg: Word;
  //#42-NY: Number of dots in Y=axis - 7~0
  //#43-NY:                            9,8
  Go_MSX_VDT_CMD_REG_NY: Word;
  Go_MSX_VDT_CMD_REG_Min: Word;
  //#44-Color: X=2N(7~4), X=2N+1(3~0)                           - G4,G6 (N=0..127)
  //           X=4N(7~6), X=4N+1(5~4), X=4N+2(3~2), X=4N+3(1~0) - G5 (N=0..127)
  //           X=N(One dot)(7~0)                                - G7
  Gi_MSX_VDT_CMD_REG_Color: Byte;
  //#45-뱅크변환(Bit6-0:VRAM,1:확장RAM[사용안함])
  //    Select destination memory and direction from base coordinate
  MSX_VDT_CMD_REG_MXC: Byte; //Bit6 - MSX2, 0:VRAM, 1:확장RAM
  //    MXD - Bit5-0:VRAM,1:ExpRam - Destination select
  MSX_VDT_CMD_REG_MXD: Byte; //Bit5
  MSX_VDT_CMD_REG_MXS: Byte; //Bit4
  //    DIY - Bit3-0:Down,1:Up     - Y Transfer direction
  MSX_VDT_CMD_REG_DIY: Byte; //Bit3
  //    DIX - Bit2-0:Right,1:Left  - X Transfer direction
  MSX_VDT_CMD_REG_DIX: Byte; //Bit2
  MSX_VDT_CMD_REG_EQ: Byte;  //Bit1
  MSX_VDT_CMD_REG_MAJ: Byte; //Bit0 - Line 긴변선택
  //#46-Execute the command (7~0:11110000)
  MSX_VDT_CMD_REG_CMD: Byte; //Bit7~4
  MSX_VDT_CMD_REG_LO: Byte;  //Bit3~0

  //public static byte[] MSX_VDT_ST_REG = new byte[10]; //0~255 [0~9]
  //MSX1, #0
  //MSX_VDT_REG_ST - 가로채기정보
  MSX_VDT_ST_REG_FF: Byte;  //7 bit - End of the raster scan of the last line of the active display, 1초에60번발생(60Hz), 1초에50번발행(50Hz)
  Gi_MSX_VDT_ST_REG_FF: Byte;
  MSX_VDT_ST_REG_5S: Byte;  //6 bit - 소프라이트 1줄에 5개이상 표시로, 5번째이상 표시안되는 상태
  MSX_VDT_ST_REG_C: Byte;   //5 bit - 소프라이트 충돌
  MSX_VDT_ST_REG_5SN: Byte; //4~0 bit - 표시안되는 첫번째 소프라이트 번호
  //MSX2, #1~#9
  //MSX_VDT_REG_ST1 - 가로채기정보
  MSX_VDT_ST_REG_FL: Byte;  //'7 bit - Light Pen
  MSX_VDT_ST_REG_LPS: Byte; //6 bit - Light Pen Button
  MSX_VDT_ST_REG_ID: Byte;  //5~1 bit - VDT Chip
  MSX_VDT_ST_REG_FH: Byte;  //0 bit - Horizontal scan interrup flag
  //MSX_VDT_REG_ST2
  MSX_VDT_ST_REG_TR: Byte;  //7 bit - Transfer ready flag
  MSX_VDT_ST_REG_VR: Byte;  //6 bit - Vertical retrace flag
  MSX_VDT_ST_REG_HR: Byte;  //5 bit - Horizontal retrace flag
  MSX_VDT_ST_REG_BD: Byte;  //4 bit - Color detect flag
  MSX_VDT_ST_REG_EO: Byte;  //1 bit - Display field flag
  MSX_VDT_ST_REG_CE: Byte;  //0 bit - Command execution flag
  //MSX_VDT_REG_ST3 - Column register low
  //MSX_VDT_REG_ST4 - Column register high (1111111 8)
  Go_MSX_VDT_ST_REG_Column: LongInt;
  //MSX_VDT_REG_ST5 - Row register row
  //MSX_VDT_REG_ST6 - Row register high (111111 9,8)
  Go_MSX_VDT_ST_REG_Row: LongInt;
  //MSX_VDT_REG_ST7 - Color register
  Gi_MSX_VDT_ST_REG_Color: Byte;
  //MSX_VDT_REG_ST8 - Coded color X register low
  //MSX_VDT_REG_ST9 - Coded color Y register high (1111111 8)
  Go_MSX_VDT_ST_REG_BX: LongInt;

  Gi_MSX_Screen_Out: ShortInt; //1:화면출력필요
  Gi_MSX_ForeColor: Byte;
  Gi_MSX_BackColor: Byte;
  Gi_MSX_OutColor: Byte;
  Gi_MSX_ForeColor_Blink: Byte;
  Gi_MSX_BackColor_Blink: Byte;
  Gi_MSX_Blink_Time_Bl: Byte;
  Gi_MSX_Blink_Time_Co: Byte;

  Gi_MSX_SCREEN_MODE: ShortInt; //0:TEXT, 1:GRAPHIC_1, 2:GRAPHIC_2, 3:MULTI_COLOR, 10:TEXT 80
  Gi_MSX_Screen_Mode_Prv: ShortInt;
  Gi_MSX_VDT_Reg_LN_Prv: Byte;
  Gi_MSX_Graphic_Page: ShortInt;

  Gi_MSX_VRAM_IO: ShortInt; //1:Read,2:Write
  Go_MSX_VRAM_ADDRESS: LongInt;
  Gi_MSX_VRAM_Flg: ShortInt;
  Gi_MSX2_VRAM_Flg: ShortInt;

  Go_MSX_SCR_CHAR_ADDR: LongInt;
  Go_MSX_SCR_COLR_ADDR: LongInt;
  Go_MSX_SCR_FONT_ADDR: LongInt;
  Go_MSX_SCR_BLNK_ADDR: LongInt; //MSX2 - Text 80 Blink
  Go_MSX_SPR_ATRB_ADDR: LongInt;
  Go_MSX_SPR_FONT_ADDR: LongInt;
  Go_MSX_SPR_COLR_ADDR: LongInt; //MSX2 - Screen 8 Sprite Color

  //VDT Palette 레지스터 - MSX1(기본설정), MSX2(팔레트레지스터로지정)
  MSX_VDT_REG_PAL_Red: Array[0..16-1] Of Byte; //0~255 [0~15]
  MSX_VDT_REG_PAL_Green: Array[0..16-1] Of Byte; //0~255 [0~15]
  MSX_VDT_REG_PAL_Blue: Array[0..16-1] Of Byte; //0~255 [0~15]
  Go_MSX_Color: Array[0..16-1] Of LongWord; //'BitMap(PictureBox) 표시용
  Go_MSX_Color_RGB: Array[0..16-1] Of LongWord; //화면표시용
  Go_MSX_Color_G7: Array[0..16-1] Of LongWord; //Screen 8, Graphic7용 소프라이트 고정색상
  Go_MSX_Color_G7_RGB: Array[0..16-1] Of LongWord; //화면표시용
  Gc_MSX_Color: Array[0..16-1] Of TColor; //'BitMap(PictureBox) 표시용
  Gc_MSX_Color_RGB: Array[0..16-1] Of TColor; //화면표시용
  Gc_MSX_Color_G7: Array[0..16-1] Of TColor; //Screen 8, Graphic7용 소프라이트 고정색상
  Gc_MSX_Color_G7_RGB: Array[0..16-1] Of TColor; //화면표시용

  procedure MSX_INIT_VDT;
  procedure MSX_SCREEN_MODE_SET;
  procedure MSX_SCREEN_MODE_SET2;
  procedure MSX_SCREEN_MODE_SET8;
  procedure MSX_SCREEN_MODE_SET9;
  function MSX_VDT_REG_ST: Byte;
  function MSX_VDT_REG_ST1: Byte;
  function MSX_VDT_REG_ST2: Byte;
  function MSX_VDT_REG_ST3: Byte;
  function MSX_VDT_REG_ST4: Byte;
  function MSX_VDT_REG_ST5: Byte;
  function MSX_VDT_REG_ST6: Byte;
  function MSX_VDT_REG_ST7: Byte;
  function MSX_VDT_REG_ST8: byte;
  function MSX_VDT_REG_ST9: Byte;
  procedure MSX_VDT_CMD_REG_SX;
  procedure MSX_VDT_CMD_REG32_SET;
  procedure MSX_VDT_CMD_REG33_SET;
  procedure MSX_VDT_CMD_REG_SY;
  procedure MSX_VDT_CMD_REG34_SET;
  procedure MSX_VDT_CMD_REG35_SET;
  procedure MSX_VDT_CMD_REG_DX;
  procedure MSX_VDT_CMD_REG36_SET;
  procedure MSX_VDT_CMD_REG37_SET;
  procedure MSX_VDT_CMD_REG_DY;
  procedure MSX_VDT_CMD_REG38_SET;
  procedure MSX_VDT_CMD_REG39_SET;
  procedure MSX_VDT_CMD_REG_NX;
  procedure MSX_VDT_CMD_REG40_SET;
  procedure MSX_VDT_CMD_REG41_SET;
  procedure MSX_VDT_CMD_REG_NY;
  procedure MSX_VDT_CMD_REG42_SET;
  procedure MSX_VDT_CMD_REG43_SET;
  procedure MSX_VDT_CMD_REG_CLR;
  procedure MSX_VDT_CMD_REG44_SET;
  procedure MSX_VDT_CMD_REG45_SET;
  procedure MSX_VDT_CMD_REG46_SET;
  function GET_VDT_CMD_REG_NX: Word;
  function GET_VDT_CMD_REG_NY: Word;
  procedure MSX_Color_Setting;
  procedure MSX_COLOR_PALETTE(iReg: Byte; iRed: Byte; iGreen: Byte; iBlue: Byte);
  procedure MSX_COLOR_PALETTE_G7(iReg: Byte; iRed: Byte; iGreen: Byte; iBlue: Byte);

implementation

uses
  msxMSX, msxZ80A, msxVDT_CMD, msxTBL,
  untFunction;

procedure MSX_INIT_VDT;
var
  i: Integer;
begin
  for i := 0 to 131071 do MSX_VRAM[i] := 0;

  for i := 0 to 46 do MSX_VDT_REG[i] := 0;

  Gi_MSX_Screen_Out := 0;

  Gi_MSX_SCREEN_MODE := 0;
  MSX_VDT_REG_LN := 0;
  Gi_MSX_Screen_Mode_Prv := -1;
  Gi_MSX_VDT_Reg_LN_Prv := 0;
  Gi_MSX_Graphic_Page := 0;

  MSX_VDT_REG_IE1 := 0;
  MSX_VDT_REG_EV := 0;
  MSX_VDT_REG_16K := 0;
  MSX_VDT_REG_ON := 1;
  MSX_VDT_REG_IE0 := 0;
  MSX_VDT_REG_SZ := 0;
  MSX_VDT_REG_SM := 0;
  MSX_VDT_REG_TP := 0;
  MSX_VDT_REG_SPD := 0;
  MSX_VDT_REG_IL := 0;
  MSX_VDT_REG_EO := 0;

  for i := 0 to 131071 do MSX_VRAM_Buff[i] := 0;
  Go_MSX_VRAM_Buff_Size := 0;
  Go_MSX_VRAM_Buff_Count := 0;

  Go_MSX_VDT_CMD_REG_SX := 0;
  Go_MSX_VDT_CMD_REG_SY := 0;
  Go_MSX_VDT_CMD_REG_DX := 0;
  Go_MSX_VDT_CMD_REG_DY := 0;
  Go_MSX_VDT_CMD_REG_NX := 0;
  Go_MSX_VDT_CMD_REG_NY := 0;
  Go_MSX_VDT_CMD_REG_Mjg := 0;
  Go_MSX_VDT_CMD_REG_Min := 0;
  Gi_MSX_VDT_CMD_REG_Color := 0;
  MSX_VDT_CMD_REG_MXC := 0;
  MSX_VDT_CMD_REG_MXD := 0;
  MSX_VDT_CMD_REG_MXS := 0;
  MSX_VDT_CMD_REG_DIY := 0;
  MSX_VDT_CMD_REG_DIX := 0;
  MSX_VDT_CMD_REG_EQ := 0;
  MSX_VDT_CMD_REG_MAJ := 0;
  MSX_VDT_CMD_REG_CMD := 0;
  MSX_VDT_CMD_REG_LO := 0;

  Go_MSX_VDT_CMD_REG_SX := 0;
  Go_MSX_VDT_CMD_REG_SY := 0;
  Go_MSX_VDT_CMD_REG_DX := 0;
  Go_MSX_VDT_CMD_REG_DY := 0;
  Go_MSX_VDT_CMD_REG_NX := 0;
  Go_MSX_VDT_CMD_REG_NY := 0;
  Go_MSX_VDT_CMD_REG_Mjg := 0;
  Go_MSX_VDT_CMD_REG_Min := 0;
  Gi_MSX_VDT_CMD_REG_Color := 0;
  MSX_VDT_CMD_REG_MXC := 0;
  MSX_VDT_CMD_REG_MXD := 0;
  MSX_VDT_CMD_REG_MXS := 0;
  MSX_VDT_CMD_REG_DIY := 0;
  MSX_VDT_CMD_REG_DIX := 0;
  MSX_VDT_CMD_REG_EQ := 0;
  MSX_VDT_CMD_REG_MAJ := 0;
  MSX_VDT_CMD_REG_CMD := 0;
  MSX_VDT_CMD_REG_LO := 0;

  MSX_VDT_ST_REG_FF := 0;
  Gi_MSX_VDT_ST_REG_FF := 0;
  MSX_VDT_ST_REG_5S := 0;
  MSX_VDT_ST_REG_C := 0;
  MSX_VDT_ST_REG_5SN := 0;
  MSX_VDT_ST_REG_FL := 0;
  MSX_VDT_ST_REG_LPS := 0;
  MSX_VDT_ST_REG_ID := 0;
  MSX_VDT_ST_REG_FH := 0;
  MSX_VDT_ST_REG_TR := 0;
  MSX_VDT_ST_REG_VR := 0;
  MSX_VDT_ST_REG_HR := 0;
  MSX_VDT_ST_REG_BD := 0;
  MSX_VDT_ST_REG_EO := 0;
  MSX_VDT_ST_REG_CE := 0;
  Go_MSX_VDT_ST_REG_Column := 0;
  Go_MSX_VDT_ST_REG_Row := 0;
  Gi_MSX_VDT_ST_REG_Color := 0;
  Go_MSX_VDT_ST_REG_BX := 0;

  Gi_MSX_VRAM_IO := 0;
  Go_MSX_VRAM_ADDRESS := 0;
  Gi_MSX_VRAM_Flg := 0;
  Gi_MSX2_VRAM_Flg := 0;

  Go_MSX_SCR_CHAR_ADDR := 0;
  Go_MSX_SCR_COLR_ADDR := 0;
  Go_MSX_SCR_FONT_ADDR := 0;
  Go_MSX_SCR_BLNK_ADDR := 0;
  Go_MSX_SPR_ATRB_ADDR := 0;
  Go_MSX_SPR_FONT_ADDR := 0;
  Go_MSX_SPR_COLR_ADDR := 0;

  for i := 0 to 15 do
    begin
      MSX_VDT_REG_PAL_Red[i] := 0;
      MSX_VDT_REG_PAL_Green[i] := 0;
      MSX_VDT_REG_PAL_Blue[i] := 0;
      Go_MSX_Color[i] := 0;
      Go_MSX_Color_RGB[i] := 0;
      Go_MSX_Color_G7[i] := 0;
      Go_MSX_Color_G7_RGB[i] := 0;
    end;
end;

procedure MSX_SCREEN_MODE_SET;
var
  M1, M0: ShortInt;
begin
  if (GiMSX2 = 0) then //MSX1
    M0 := Gi_D_Table2[MSX_VDT_REG[0] And 2] //R0(7,1)
  else //MSX2
    M0 := Gi_D_Table2[MSX_VDT_REG[0] And 14] //R0(5,3)
  ;
  M1 := Gi_D_Table8[MSX_VDT_REG[1] And $18];  //R1(4,2)
  if ((M1 = 2) And (M0 = 0)) then Gi_MSX_SCREEN_MODE := 0;  //10+000-TEXT - MSX1
  if ((M1 = 0) And (M0 = 0)) then Gi_MSX_SCREEN_MODE := 1;  //00+000-GRAPHIC_1 - MSX1
  if ((M1 = 0) And (M0 = 1)) then Gi_MSX_SCREEN_MODE := 2;  //00+001-GRAPHIC_2 - MSX1
  if ((M1 = 1) And (M0 = 0)) then Gi_MSX_SCREEN_MODE := 3;  //01+000-MULTI_COLOR - MSX1
  if ((M1 = 2) And (M0 = 2)) then Gi_MSX_SCREEN_MODE := 10; //10+010-TEXT2 - MSX2
  if ((M1 = 0) And (M0 = 2)) then Gi_MSX_SCREEN_MODE := 4;  //00+010-GRAPHIC_3 - MSX2
  if ((M1 = 0) And (M0 = 3)) then
    begin
      Gi_MSX_SCREEN_MODE := 5; //00+011-GRAPHIC_4 - MSX2
      Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 127]; //0~3 * 8000h
    end;
  if ((M1 = 0) And (M0 = 4)) then
    begin
      Gi_MSX_SCREEN_MODE := 6; //00+100-GRAPHIC_5 - MSX2
      Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 127]; //0~3 * 8000h
    end;
  if ((M1 = 0) And (M0 = 5)) then
    begin
      Gi_MSX_SCREEN_MODE := 7; //00+101-GRAPHIC_6 - MSX2
      Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 63]; //0~1 * 10000h
    end;
  if ((M1 = 0) And (M0 = 7)) then
    begin
      Gi_MSX_SCREEN_MODE := 8; //00+111-GRAPHIC_7 - MSX2
      Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 63]; //0~1 * 10000h
    end;
  MSX_VDT_REG_EV := (MSX_VDT_REG[0] And 1); //R0(8,1), EXT VID
  if (GiMSX2 = 1) then //MSX2
    begin
      MSX_VDT_REG_IE1 := IfThen((MSX_VDT_REG[0] And 16) = 0, 0, 1);
    end;
  MSX_VDT_REG_16K := IfThen((MSX_VDT_REG[1] And 128) = 0, 0, 1); //R1(1,1), 4/16K
  MSX_VDT_REG_ON := IfThen((MSX_VDT_REG[1] And 64) = 0, 0, 1);   //R1(2,1), 1:화면표시
  MSX_VDT_REG_IE0 := IfThen((MSX_VDT_REG[1] And 32) = 0, 0, 1);  //R1(3,1), IE
  MSX_VDT_REG_SZ := IfThen((MSX_VDT_REG[1] And 2) = 0, 0, 1);    //R1(7,1), SPR SIZE
  MSX_VDT_REG_SM := (MSX_VDT_REG[1] And 1);                      //R1(8,1), SPR MAG
end;

procedure MSX_SCREEN_MODE_SET2;
begin
  if (Gi_MSX_SCREEN_MODE = 5) then Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 127]; //0~3 * 8000h
  if (Gi_MSX_SCREEN_MODE = 6) then Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 127]; //0~3 * 8000h
  if (Gi_MSX_SCREEN_MODE = 7) then Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 63];  //0~1 * 10000h
  if (Gi_MSX_SCREEN_MODE = 8) then Gi_MSX_Graphic_Page := Gi_D_Table32[MSX_VDT_REG[2] And 63];  //0~1 * 10000h
end;

procedure MSX_SCREEN_MODE_SET8;
begin
  MSX_VDT_REG_TP := IfThen((MSX_VDT_REG[8] And 32) = 0, 0, 1);
  MSX_VDT_REG_SPD := IfThen((MSX_VDT_REG[8] And 2) = 0, 0, 1);
end;

procedure MSX_SCREEN_MODE_SET9;
begin
  MSX_VDT_REG_LN := IfThen((MSX_VDT_REG[9] And 128) = 0, 0, 1); //R9(1,1), 192/212
  MSX_VDT_REG_IL := IfThen((MSX_VDT_REG[9] And 8) = 0, 0, 1);
  MSX_VDT_REG_EO := IfThen((MSX_VDT_REG[9] And 4) = 0, 0, 1);
end;

function MSX_VDT_REG_ST: Byte;
var
  R: Byte;
begin
  //확인요망(부팅관련) ???
  if (Gi_MSX_VDT_ST_FF = 0) then
    begin
      MSX_VDT_ST_REG_FF := 1;
    end
  else
    begin
      if (Gi_MSX_VDT_ST_REG_FF = 0) then //화변표시후Set, 1초에60번(60Hz)
        Gi_MSX_VDT_ST_REG_FF := 1
      else
        Gi_MSX_VDT_ST_REG_FF := 0
      ;
      MSX_VDT_ST_REG_FF := Gi_MSX_VDT_ST_REG_FF;
    end;
  R := 0;
  R := (R + Go_M_Table128[MSX_VDT_ST_REG_FF]);
  R := (R + Gi_M_Table64[MSX_VDT_ST_REG_5S]);
  R := (R + Gi_M_Table32[MSX_VDT_ST_REG_C]);
  R := (R + MSX_VDT_ST_REG_5SN);

  Result := R;
end;

function MSX_VDT_REG_ST1: Byte;
var
  R: Byte;
begin
  R := 0;
  R := (R + Go_M_Table128[MSX_VDT_ST_REG_FL]);
  R := (R + Gi_M_Table64[MSX_VDT_ST_REG_LPS]);
  R := (R + Gi_M_Table2[MSX_VDT_ST_REG_ID]);
  R := (R + MSX_VDT_ST_REG_FH);

  Result := R;
end;

function MSX_VDT_REG_ST2: Byte;
var
  R: Byte;
begin
  R := 0;
  R := (R + Go_M_Table128[MSX_VDT_ST_REG_TR]);
  R := (R + Gi_M_Table64[MSX_VDT_ST_REG_VR]);
  R := (R + Gi_M_Table32[MSX_VDT_ST_REG_HR]);
  R := (R + Gi_M_Table16[MSX_VDT_ST_REG_BD]);
  R := (R + Gi_M_Table2[MSX_VDT_ST_REG_EO]);
  R := (R + MSX_VDT_ST_REG_CE);
  //확인요망(부팅관련) ???
  //If MSX_VDT_REG_IE0 = 1 Then
  if (MSX_VDT_ST_REG_VR = 0) then
    MSX_VDT_ST_REG_VR := 1
  else
    MSX_VDT_ST_REG_VR := 0
  ;
  //If MSX_VDT_REG_IE0 = 1 Then
  if (MSX_VDT_ST_REG_HR = 0) then
    MSX_VDT_ST_REG_HR := 1
  else
    MSX_VDT_ST_REG_HR := 0
  ;

  Result := R;
end;

function MSX_VDT_REG_ST3: Byte;
begin
  Result := (Go_MSX_VDT_ST_REG_Column And 255);
end;

function MSX_VDT_REG_ST4: Byte;
begin
  Result := Gi_D_Table256[Go_MSX_VDT_ST_REG_Column];
end;

function MSX_VDT_REG_ST5: Byte;
begin
  Result := (Go_MSX_VDT_ST_REG_Row And 255);
end;

function MSX_VDT_REG_ST6: Byte;
begin
  Result := Gi_D_Table256[Go_MSX_VDT_ST_REG_Row];
end;

function MSX_VDT_REG_ST7: Byte;
begin
  if ((MSX_VDT_ST_REG_CE = 1) And (MSX_VDT_ST_REG_TR = 1)) then
    begin
      if (Go_MSX_VRAM_Buff_Count > 0) then
        begin
          Go_MSX_VRAM_Buff_Count := Go_MSX_VRAM_Buff_Count - 1;
          Gi_MSX_VDT_ST_REG_Color := MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count];
          if (Go_MSX_VRAM_Buff_Count = 0) then
            begin
              MSX_VDT_ST_REG_CE := 0;
              MSX_VDT_ST_REG_TR := 0;
            end;
        end
      else
        begin
          MSX_VDT_ST_REG_CE := 0;
          MSX_VDT_ST_REG_TR := 0;
        end;
    end;

  Result := Gi_MSX_VDT_ST_REG_Color;
end;

function MSX_VDT_REG_ST8: byte;
begin
  Result := (Go_MSX_VDT_ST_REG_BX And 255);
end;

function MSX_VDT_REG_ST9: Byte;
begin
  Result := Gi_D_Table256[Go_MSX_VDT_ST_REG_BX];
end;

procedure MSX_VDT_CMD_REG_SX;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SX, MSX_VDT_REG[33], MSX_VDT_REG[32]);
end;

procedure MSX_VDT_CMD_REG32_SET;
begin
  Go_MSX_VDT_CMD_REG_SX := goGetIntHLToLng((MSX_VDT_REG[33] And 1), MSX_VDT_REG[32]);
end;

procedure MSX_VDT_CMD_REG33_SET;
begin
  Go_MSX_VDT_CMD_REG_SX := goGetIntHLToLng((MSX_VDT_REG[33] And 1), MSX_VDT_REG[32]);
end;

procedure MSX_VDT_CMD_REG_SY;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SY, MSX_VDT_REG[35], MSX_VDT_REG[34]);
end;

procedure MSX_VDT_CMD_REG34_SET;
begin
  Go_MSX_VDT_CMD_REG_SY := goGetIntHLToLng((MSX_VDT_REG[35] And 3), MSX_VDT_REG[34]);
end;

procedure MSX_VDT_CMD_REG35_SET;
begin
  Go_MSX_VDT_CMD_REG_SY := goGetIntHLToLng((MSX_VDT_REG[35] And 3), MSX_VDT_REG[34]);
end;

procedure MSX_VDT_CMD_REG_DX;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DX, MSX_VDT_REG[37], MSX_VDT_REG[36]);
end;

procedure MSX_VDT_CMD_REG36_SET;
begin
  Go_MSX_VDT_CMD_REG_DX := goGetIntHLToLng((MSX_VDT_REG[37] And 1), MSX_VDT_REG[36]);
end;

procedure MSX_VDT_CMD_REG37_SET;
begin
  Go_MSX_VDT_CMD_REG_DX := goGetIntHLToLng((MSX_VDT_REG[37] And 1), MSX_VDT_REG[36]);
end;

procedure MSX_VDT_CMD_REG_DY;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DY, MSX_VDT_REG[39], MSX_VDT_REG[38]);
end;

procedure MSX_VDT_CMD_REG38_SET;
begin
  Go_MSX_VDT_CMD_REG_DY := goGetIntHLToLng((MSX_VDT_REG[39] And 3), MSX_VDT_REG[38]);
end;

procedure MSX_VDT_CMD_REG39_SET;
begin
  Go_MSX_VDT_CMD_REG_DY := goGetIntHLToLng((MSX_VDT_REG[39] And 3), MSX_VDT_REG[38]);
end;

procedure MSX_VDT_CMD_REG_NX;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NX, MSX_VDT_REG[41], MSX_VDT_REG[40]);
end;

procedure MSX_VDT_CMD_REG40_SET;
begin
  Go_MSX_VDT_CMD_REG_NX := goGetIntHLToLng((MSX_VDT_REG[41] And 1), MSX_VDT_REG[40]);
  Go_MSX_VDT_CMD_REG_Mjg := goGetIntHLToLng((MSX_VDT_REG[41] And 3), MSX_VDT_REG[40]);
end;

procedure MSX_VDT_CMD_REG41_SET;
begin
  Go_MSX_VDT_CMD_REG_NX := goGetIntHLToLng((MSX_VDT_REG[41] And 1), MSX_VDT_REG[40]);
  Go_MSX_VDT_CMD_REG_Mjg := goGetIntHLToLng((MSX_VDT_REG[41] And 3), MSX_VDT_REG[40]);
end;

procedure MSX_VDT_CMD_REG_NY;
begin
  gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NY, MSX_VDT_REG[43], MSX_VDT_REG[42]);
end;

procedure MSX_VDT_CMD_REG42_SET;
begin
  Go_MSX_VDT_CMD_REG_NY := goGetIntHLToLng((MSX_VDT_REG[43] And 3), MSX_VDT_REG[42]);
  Go_MSX_VDT_CMD_REG_Min := goGetIntHLToLng((MSX_VDT_REG[43] And 1), MSX_VDT_REG[42]);
end;

procedure MSX_VDT_CMD_REG43_SET;
begin
  Go_MSX_VDT_CMD_REG_NY := goGetIntHLToLng((MSX_VDT_REG[43] And 3), MSX_VDT_REG[42]);
  Go_MSX_VDT_CMD_REG_Min := goGetIntHLToLng((MSX_VDT_REG[43] And 1), MSX_VDT_REG[42]);
end;

procedure MSX_VDT_CMD_REG_CLR;
begin
  MSX_VDT_REG[44] := Gi_MSX_VDT_CMD_REG_Color;
end;

procedure MSX_VDT_CMD_REG44_SET;
begin
  Gi_MSX_VDT_CMD_REG_Color := MSX_VDT_REG[44];

  if (MSX_VDT_ST_REG_CE = 1) then
    begin
      if ((MSX_VDT_CMD_REG_CMD = $F) Or (MSX_VDT_CMD_REG_CMD = $B)) then
        begin
          MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] := MSX_VDT_REG[44];
          Go_MSX_VRAM_Buff_Count := Go_MSX_VRAM_Buff_Count + 1;
          if (Go_MSX_VRAM_Buff_Count >= Go_MSX_VRAM_Buff_Size) then
            begin
              MSX_VDT_ST_REG_CE := 0;
              MSX_VDT_ST_REG_TR := 0;
              if (MSX_VDT_CMD_REG_CMD = $F) then MSX_VDT_CMD_REG46_HMMC;
              if (MSX_VDT_CMD_REG_CMD = $B) then MSX_VDT_CMD_REG46_LMMC;
            end;
        end;
    end;
end;

procedure MSX_VDT_CMD_REG45_SET;
begin
  MSX_VDT_CMD_REG_MXC := IfThen((MSX_VDT_REG[45] And 64) = 0, 0, 1);
  MSX_VDT_CMD_REG_MXD := IfThen((MSX_VDT_REG[45] And 32) = 0, 0, 1);
  MSX_VDT_CMD_REG_MXS := IfThen((MSX_VDT_REG[45] And 16) = 0, 0, 1);
  MSX_VDT_CMD_REG_DIY := IfThen((MSX_VDT_REG[45] And 8) = 0, 0, 1);
  MSX_VDT_CMD_REG_DIX := IfThen((MSX_VDT_REG[45] And 4) = 0, 0, 1);
  MSX_VDT_CMD_REG_EQ := IfThen((MSX_VDT_REG[45] And 2) = 0, 0, 1);
  MSX_VDT_CMD_REG_MAJ := IfThen((MSX_VDT_REG[45] And 1) = 0, 0, 1);
end;

procedure MSX_VDT_CMD_REG46_SET;
var
  Nx, Ny: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  MSX_VDT_ST_REG_CE := 0;
  MSX_VDT_ST_REG_TR := 0;

  //Destination, Source, Unint, Mnemonic
  MSX_VDT_CMD_REG_CMD := Gi_D_Table16[MSX_VDT_REG[46] And $F0];
  MSX_VDT_CMD_REG_LO := (MSX_VDT_REG[46] And $F);

  //High-speed move
  if (MSX_VDT_CMD_REG_CMD = $F) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      Go_MSX_VRAM_Buff_Size := Nx * Ny;
      if (Gi_MSX_SCREEN_MODE = 5) then Go_MSX_VRAM_Buff_Size := Trunc(Go_MSX_VRAM_Buff_Size / 2);
      if (Gi_MSX_SCREEN_MODE = 6) then Go_MSX_VRAM_Buff_Size := Trunc(Go_MSX_VRAM_Buff_Size / 4);
      if (Gi_MSX_SCREEN_MODE = 7) then Go_MSX_VRAM_Buff_Size := Trunc(Go_MSX_VRAM_Buff_Size / 2);
      MSX_VRAM_Buff[0] := MSX_VDT_REG[44];
      Go_MSX_VRAM_Buff_Count := 1;
      if (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size) then
        MSX_VDT_ST_REG_TR := 1
      else
        MSX_VDT_ST_REG_CE := 0
      ;
    end;
  if (MSX_VDT_CMD_REG_CMD = $E) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_YMMM; //D:VRAM, S:VRAM, U:Byte, YMMM
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $D) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_HMMM(0); //D:VRAM, S:VRAM, U:Byte, HMMM
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $C) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_HMMV; //D:VRAM, S:VDP, U:Byte, HMMV
      MSX_VDT_ST_REG_CE := 0;
    end;

  //Logical Move
  if (MSX_VDT_CMD_REG_CMD = $B) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      Go_MSX_VRAM_Buff_Size := Nx * Ny;
      MSX_VRAM_Buff[0] := MSX_VDT_REG[44];
      Go_MSX_VRAM_Buff_Count := 1;
      if (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size) then
        MSX_VDT_ST_REG_TR := 1
      else
        MSX_VDT_ST_REG_CE := 0
      ;
    end;
  if (MSX_VDT_CMD_REG_CMD = $A) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_ST_REG_TR := 0;
      MSX_VDT_CMD_REG46_LMCM; //D:CPU, S:VRAM, U:Dot, LMCM
      MSX_VDT_ST_REG_TR := 1;
    end;
  if (MSX_VDT_CMD_REG_CMD = $9) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_LMMM; //D:VRAM, S:VRAM, U:Dot, LMMM
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $8) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_LMMV; //D:VRAM, S:VDP, U:Dot, LMMV
      MSX_VDT_ST_REG_CE := 0;
    end;

  //Line,Search,Pset,Point
  if (MSX_VDT_CMD_REG_CMD = $7) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_LINE; //D:VRAM, S:VDP, U:Dot, LINE
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $6) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_SRCH; //D:VRAM, S:VDP, U:Dot, SRCH
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $5) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_PSET; //D:VRAM, S:VDP, U:Dot, PSET
      MSX_VDT_ST_REG_CE := 0;
    end;
  if (MSX_VDT_CMD_REG_CMD = $4) then
    begin
      MSX_VDT_ST_REG_CE := 1;
      MSX_VDT_CMD_REG46_POINT; //D:VDT, S:VRAM, U:Dot, POINT
      MSX_VDT_ST_REG_CE := 0;
    end;

  //Invalid
  //If MSX_VDT_CMD_REG_CMD = &H3 Then 'Invalid
  //If MSX_VDT_CMD_REG_CMD = &H2 Then 'Invalid
  //If MSX_VDT_CMD_REG_CMD = &H1 Then 'Invalid

  //Stop
  if (MSX_VDT_CMD_REG_CMD = 0) then //STOP
    begin
      MSX_VDT_ST_REG_CE := 0;
      MSX_VDT_ST_REG_TR := 0;
    end;
end;

function GET_VDT_CMD_REG_NX: Word;
var
  R: Word;
begin
  R := Go_MSX_VDT_CMD_REG_NX;
  if (R = 0) then
    begin
      if (Gi_MSX_SCREEN_MODE = 5) then R := 256;
      if (Gi_MSX_SCREEN_MODE = 6) then R := 512;
      if (Gi_MSX_SCREEN_MODE = 7) then R := 512;
      if (Gi_MSX_SCREEN_MODE = 8) then R := 256;
    end;

  Result := R;
end;

function GET_VDT_CMD_REG_NY: Word;
var
  R: Word;
begin
  R := Go_MSX_VDT_CMD_REG_NY;
  //if (R = 0) then
  //begin
  //    if (Gi_MSX_SCREEN_MODE = 5) then R := 1024;
  //    if (Gi_MSX_SCREEN_MODE = 6) then R := 1024;
  //    if (Gi_MSX_SCREEN_MODE = 7) then R := 512;
  //    if (Gi_MSX_SCREEN_MODE = 8) then R := 512;
  //end;

  Result := R;
end;

procedure MSX_Color_Setting;
var
  i, iGreen, iRed, iBlue: Byte;
begin
  //MSX1 기본색상 - MSX2 에서는 약간 달라짐(특히White색상이더밝아짐)
  //Tranparent (투명)
  MSX_VDT_REG_PAL_Red[0] := $0;
  MSX_VDT_REG_PAL_Green[0] := $0;
  MSX_VDT_REG_PAL_Blue[0] := $0;
  //Black
  MSX_VDT_REG_PAL_Red[1] := $0;
  MSX_VDT_REG_PAL_Green[1] := $0;
  MSX_VDT_REG_PAL_Blue[1] := $0;
  //Medium Green
  MSX_VDT_REG_PAL_Red[2] := $20;
  MSX_VDT_REG_PAL_Green[2] := $C0;
  MSX_VDT_REG_PAL_Blue[2] := $20;
  //Light Green
  MSX_VDT_REG_PAL_Red[3] := $60;
  MSX_VDT_REG_PAL_Green[3] := $E0;
  MSX_VDT_REG_PAL_Blue[3] := $60;
  //Dark Blue
  MSX_VDT_REG_PAL_Red[4] := $20;
  MSX_VDT_REG_PAL_Green[4] := $20;
  MSX_VDT_REG_PAL_Blue[4] := $E0;
  //Light Blue
  MSX_VDT_REG_PAL_Red[5] := $40;
  MSX_VDT_REG_PAL_Green[5] := $60;
  MSX_VDT_REG_PAL_Blue[5] := $E0;
  //Dark Red
  MSX_VDT_REG_PAL_Red[6] := $A0;
  MSX_VDT_REG_PAL_Green[6] := $20;
  MSX_VDT_REG_PAL_Blue[6] := $20;
  //Cyan [Aqua Blue]
  MSX_VDT_REG_PAL_Red[7] := $40;
  MSX_VDT_REG_PAL_Green[7] := $C0;
  MSX_VDT_REG_PAL_Blue[7] := $E0;
  //Medium Red
  MSX_VDT_REG_PAL_Red[8] := $E0;
  MSX_VDT_REG_PAL_Green[8] := $20;
  MSX_VDT_REG_PAL_Blue[8] := $20;
  //Light Red
  MSX_VDT_REG_PAL_Red[9] := $E0;
  MSX_VDT_REG_PAL_Green[9] := $60;
  MSX_VDT_REG_PAL_Blue[9] := $60;
  //Dark Yellow
  MSX_VDT_REG_PAL_Red[10] := $C0;
  MSX_VDT_REG_PAL_Green[10] := $C0;
  MSX_VDT_REG_PAL_Blue[10] := $20;
  //Light Yellow
  MSX_VDT_REG_PAL_Red[11] := $C0;
  MSX_VDT_REG_PAL_Green[11] := $C0;
  MSX_VDT_REG_PAL_Blue[11] := $80;
  //Dark Green
  MSX_VDT_REG_PAL_Red[12] := $20;
  MSX_VDT_REG_PAL_Green[12] := $80;
  MSX_VDT_REG_PAL_Blue[12] := $20;
  //agenta [Purple]
  MSX_VDT_REG_PAL_Red[13] := $C0;
  MSX_VDT_REG_PAL_Green[13] := $40;
  MSX_VDT_REG_PAL_Blue[13] := $A0;
  //ray
  MSX_VDT_REG_PAL_Red[14] := $A0;
  MSX_VDT_REG_PAL_Green[14] := $A0;
  MSX_VDT_REG_PAL_Blue[14] := $A0;
  //hite
  MSX_VDT_REG_PAL_Red[15] := $E0;
  MSX_VDT_REG_PAL_Green[15] := $E0;
  MSX_VDT_REG_PAL_Blue[15] := $E0;

  for i := 0 to 15 do
    MSX_COLOR_PALETTE(i, MSX_VDT_REG_PAL_Red[i], MSX_VDT_REG_PAL_Green[i], MSX_VDT_REG_PAL_Blue[i]);

  //MSX2 - Screen 8 소프라이트 색상
  for i := 0 to 15 do
    begin
      if (i = 00) then begin iGreen := 0; iRed := 0; iBlue := 0; end; //흑색
      if (i = 01) then begin iGreen := 0; iRed := 0; iBlue := 2; end; //어두운청색
      if (i = 02) then begin iGreen := 0; iRed := 3; iBlue := 0; end; //어두운적색
      if (i = 03) then begin iGreen := 0; iRed := 3; iBlue := 2; end; //어두운자색
      if (i = 04) then begin iGreen := 3; iRed := 0; iBlue := 0; end; //어두운녹색
      if (i = 05) then begin iGreen := 3; iRed := 0; iBlue := 2; end; //어두운물색
      if (i = 06) then begin iGreen := 3; iRed := 3; iBlue := 0; end; //어두운황색
      if (i = 07) then begin iGreen := 3; iRed := 3; iBlue := 2; end; //회색
      if (i = 08) then begin iGreen := 4; iRed := 7; iBlue := 2; end; //살색?
      if (i = 09) then begin iGreen := 0; iRed := 0; iBlue := 7; end; //청색
      if (i = 10) then begin iGreen := 0; iRed := 7; iBlue := 0; end; //적색
      if (i = 11) then begin iGreen := 0; iRed := 7; iBlue := 7; end; //자색
      if (i = 12) then begin iGreen := 7; iRed := 0; iBlue := 0; end; //녹색
      if (i = 13) then begin iGreen := 7; iRed := 0; iBlue := 7; end; //물색
      if (i = 14) then begin iGreen := 7; iRed := 7; iBlue := 0; end; //황색
      if (i = 15) then begin iGreen := 7; iRed := 7; iBlue := 7; end; //백색
      MSX_COLOR_PALETTE_G7(i, iRed, iGreen, iBlue);
    end;
end;

procedure MSX_COLOR_PALETTE(iReg: Byte; iRed: Byte; iGreen: Byte; iBlue: Byte);
begin
  //Go_MSX_Color[iReg] := gmoRGB(iBlue, iGreen, iRed); //VB6
  Go_MSX_Color[iReg] := gmoRGB(iRed, iGreen, iBlue);
  Go_MSX_Color_RGB[iReg] := gmoRGB(iRed, iGreen, iBlue);
  //Gc_MSX_Color[iReg] := Color.FromArgb(iBlue, iGreen, iRed); //VB6
  Gc_MSX_Color[iReg] := RGB(iRed, iGreen, iBlue);
  Gc_MSX_Color_RGB[iReg] := RGB(iRed, iGreen, iBlue);
end;

procedure MSX_COLOR_PALETTE_G7(iReg: Byte; iRed: Byte; iGreen: Byte; iBlue: Byte);
begin
  //Go_MSX_Color_G7[iReg] := gmoRGB(Gi_M_Table36[iBlue], Gi_M_Table36[iGreen], Gi_M_Table36[iRed]); //VB6
  Go_MSX_Color_G7[iReg] := gmoRGB(Gi_M_Table36[iRed], Gi_M_Table36[iGreen], Gi_M_Table36[iBlue]);
  Go_MSX_Color_G7_RGB[iReg] := gmoRGB(Gi_M_Table36[iRed], Gi_M_Table36[iGreen], Gi_M_Table36[iBlue]);
  //Gc_MSX_Color_G7[iReg] := Color.FromArgb(Gi_M_Table36[iBlue], Gi_M_Table36[iGreen], Gi_M_Table36[iRed]); //VB6
  Gc_MSX_Color_G7[iReg] := RGB(Gi_M_Table36[iRed], Gi_M_Table36[iGreen], Gi_M_Table36[iBlue]);
  Gc_MSX_Color_G7_RGB[iReg] := RGB(Gi_M_Table36[iRed], Gi_M_Table36[iGreen], Gi_M_Table36[iBlue]);
end;

end.

