unit msxVDT_CMD;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

//var
  procedure MSX_VDT_CMD_REG46_HMMC;
  procedure MSX_VDT_CMD_REG46_YMMM;
  procedure MSX_VDT_CMD_REG46_HMMM(iSel: ShortInt);
  procedure MSX_VDT_CMD_REG46_HMMV;
  procedure MSX_VDT_CMD_REG46_LMMC;
  procedure MSX_VDT_CMD_REG46_LMCM;
  procedure MSX_VDT_CMD_REG46_LMCM_5(Sx: LongInt; Sy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMCM_6(Sx: LongInt; Sy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMCM_7(Sx: LongInt; Sy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMCM_8(Sx: LongInt; Sy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMM;
  procedure MSX_VDT_CMD_REG46_LMMM_5(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMM_6(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMM_7(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMM_8(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMV;
  procedure MSX_VDT_CMD_REG46_LMMV_5(Dx: LongInt; Dy: LongInt; iCol: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMV_6(Dx: LongInt; Dy: LongInt; iCol: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMV_7(Dx: LongInt; Dy: LongInt; iCol: LongInt);
  procedure MSX_VDT_CMD_REG46_LMMV_8(Dx: LongInt; Dy: LongInt; iCol: LongInt);
  procedure MSX_VDT_CMD_REG46_LINE;
  procedure MSX_VDT_CMD_REG46_SRCH;
  procedure MSX_VDT_CMD_REG46_PSET;
  procedure MSX_VDT_CMD_REG46_POINT;
  function MSX_VDT_CMD_REG46_POINT_5(Sx: LongInt; Sy: LongInt): Byte;
  function MSX_VDT_CMD_REG46_POINT_6(Sx: LongInt; Sy: LongInt): Byte;
  function MSX_VDT_CMD_REG46_POINT_7(Sx: LongInt; Sy: LongInt): Byte;
  function MSX_VDT_CMD_REG46_POINT_8(Sx: LongInt; Sy: LongInt): Byte;
  function fi_MSX_VDT_CMD_LO(iColS: Byte; iColD: Byte): Byte;

implementation

uses
  msxMSX, msxZ80A, msxVDT, msxTBL,
  untFunction;

var
  fbY, fbX: Boolean;

procedure MSX_VDT_CMD_REG46_HMMC;
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  oAddrY, oAddrX: LongInt;
  iFlg: ShortInt;
  Xp: LongInt;
  fo_MSX_VRAM_Buff_Count: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  X1 := Go_MSX_VDT_CMD_REG_DX;
  Y1 := Go_MSX_VDT_CMD_REG_DY;
  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      X2 := X1 + (Nx - 1); StX := 1;
    end
  else
    begin
      X2 := X1 - (Nx - 1); StX := -1;
    end;
  if (MSX_VDT_CMD_REG_DIY = 0) then
    begin
      Y2 := Y1 + (Ny - 1); StY := 1;
    end
  else
    begin
      Y2 := Y1 - (Ny - 1); StY := -1;
    end;

  fo_MSX_VRAM_Buff_Count := 0;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 5) then //4 Page, 0~255*0~1023, 16색상
    begin
      oAddrY := Go_M_Table128[Y1]; //(256 / 2)
      Y := Y1; fbY := True;
      while fbY do
        begin
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 256;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table2[Xp];
                  MSX_VRAM[oAddrY + oAddrX] := MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //16Color+16Color
                  fo_MSX_VRAM_Buff_Count := fo_MSX_VRAM_Buff_Count + 1;
                  iFlg := 1;
                end
              else
                begin
                  iFlg := 0;
                end;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 128;
            end
          else
            begin
              oAddrY := oAddrY - 128; if (oAddrY < 0) then oAddrY := oAddrY + 128;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 6) then //4 Page, 0~511*0~1023, 4색상
    begin
      oAddrY := Go_M_Table128[Y1]; //(512 / 4)
      Y := Y1; fbY := True;
      while fbY do
        begin
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 512;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table4[Xp];
                  MSX_VRAM[oAddrY + oAddrX] := MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //4Color+4Color+4Color+4Color
                  fo_MSX_VRAM_Buff_Count := fo_MSX_VRAM_Buff_Count + 1;
                end;
              iFlg := (iFlg + 1);
              if (iFlg = 4) then iFlg := 0;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 128;
            end
          else
            begin
              oAddrY := oAddrY - 128; if (oAddrY < 0) then oAddrY := oAddrY + 128;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 7) then //2 Page, 0~511*0~511, 16색상
    begin
      oAddrY := Go_M_Table256[Y1]; //(512 / 2)
      Y := Y1; fbY := True;
      while fbY do
        begin
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 512;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table2[Xp];
                  MSX_VRAM[oAddrY + oAddrX] := MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //16Color+16Color
                  fo_MSX_VRAM_Buff_Count := fo_MSX_VRAM_Buff_Count + 1;
                  iFlg := 1;
                end
              else
                begin
                  iFlg := 0;
                end;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 256;
            end
          else
            begin
              oAddrY := oAddrY - 256; if (oAddrY < 0) then oAddrY := oAddrY + 256;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  if (Gi_MSX_SCREEN_MODE = 8) then //2 Page, 0~255*0~511, 256색상
    begin
      oAddrY := Go_M_Table256[Y1];
      Y := Y1; fbY := True;
      while fbY do
        begin
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 256;
              oAddrX := Xp;
              MSX_VRAM[oAddrY + oAddrX] := MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //256Color
              fo_MSX_VRAM_Buff_Count := fo_MSX_VRAM_Buff_Count + 1;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 256;
            end
          else
            begin
              oAddrY := oAddrY - 256; if (oAddrY < 0) then oAddrY := oAddrY + 256;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_DY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;

  Gi_MSX_Screen_Out := 1; //화면표시작업
end;

procedure MSX_VDT_CMD_REG46_YMMM;
begin
  MSX_VDT_CMD_REG46_HMMM(1);
end;

procedure MSX_VDT_CMD_REG46_HMMM(iSel: ShortInt);
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  oAddrY, oAddrX: LongInt;
  oAddrY2, oAddrX2, Dx2: LongInt;
  iFlg: ShortInt; iNx: LongInt;
  Xp: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  if (iSel = 0) then
    begin
      X1 := Go_MSX_VDT_CMD_REG_SX;
      Y1 := Go_MSX_VDT_CMD_REG_SY;
      if (MSX_VDT_CMD_REG_DIX = 0) then
        begin
          X2 := X1 + (Nx - 1); StX := 1;
        end
      else
        begin
          X2 := X1 - (Nx - 1); StX := -1;
        end;
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Y2 := Y1 + (Ny - 1); StY := 1;
        end
      else
        begin
          Y2 := Y1 - (Ny - 1); StY := -1;
        end;
    end
  else
    begin
      X1 := Go_MSX_VDT_CMD_REG_DX;
      Y1 := Go_MSX_VDT_CMD_REG_SY;
      if (MSX_VDT_CMD_REG_DIX = 0) then
        begin
          if ((Gi_MSX_SCREEN_MODE = 5) OR (Gi_MSX_SCREEN_MODE = 8)) then
            begin
              iNx := 255 - X1 + 1;
            end
          else
            begin
              iNx := 511 - X1 + 1;
            end;
          X2 := X1 + (iNx - 1); StX := 1;
        end
      else
        begin
          if ((Gi_MSX_SCREEN_MODE = 5) OR (Gi_MSX_SCREEN_MODE = 8)) then
            begin
              iNx := X1 + 1;
            end
          else
            begin
              iNx := X1 + 1;
            end;
          X2 := X1 - (iNx - 1); StX := -1;
        end;
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Y2 := Y1 + (Ny - 1); StY := 1;
        end
      else
        begin
          Y2 := Y1 - (Ny - 1); StY := -1;
        end;
    end;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 5) then //4 Page, 0~255*0~1023, 16색상
    begin
      oAddrY := Go_M_Table128[Y1]; //(256 / 2)
      oAddrY2 := Go_M_Table128[Go_MSX_VDT_CMD_REG_DY];
      Y := Y1; fbY := True;
      while fbY do
        begin
          Dx2 := 0;
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 256;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table2[Xp];
                  oAddrX2 := Gi_D_Table2[Go_MSX_VDT_CMD_REG_DX + Dx2];
                  MSX_VRAM[oAddrY2 + oAddrX2] := MSX_VRAM[oAddrY + oAddrX]; //16Color+16Color
                  iFlg := 1;
                end
              else
                begin
                  iFlg := 0;
                end;
              Dx2 := Dx2 + 1;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 128;
              oAddrY2 := oAddrY2 + 128;
            end
          else
            begin
              oAddrY := oAddrY - 128; if (oAddrY < 0) then oAddrY := oAddrY + 128;
              oAddrY2 := oAddrY2 - 128; if (oAddrY2 < 0) then oAddrY2 := oAddrY2 + 128;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 6) then //4 Page, 0~511*0~1023, 4색상
    begin
      oAddrY := Go_M_Table128[Y1]; //(512 / 4)
      oAddrY2 := Go_M_Table128[Go_MSX_VDT_CMD_REG_DY];
      Y := Y1; fbY := True;
      while fbY do
        begin
          Dx2 := 0;
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 512;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table4[Xp];
                  oAddrX2 := Gi_D_Table4[Go_MSX_VDT_CMD_REG_DX + Dx2];
                  MSX_VRAM[oAddrY2 + oAddrX2] := MSX_VRAM[oAddrY + oAddrX]; //4Color+4Color+4Color+4Color
                end;
              iFlg := (iFlg + 1);
              if (iFlg = 4) then iFlg := 0;
              Dx2 := Dx2 + 1;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 128;
              oAddrY2 := oAddrY2 + 128;
            end
          else
            begin
              oAddrY := oAddrY - 128; if (oAddrY < 0) then oAddrY := oAddrY + 128;
              oAddrY2 := oAddrY2 - 128; if (oAddrY2 < 0) then oAddrY2 := oAddrY2 + 128;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  iFlg := 0;
  if (Gi_MSX_SCREEN_MODE = 7) then //2 Page, 0~511*0~511, 16색상
    begin
      oAddrY := Go_M_Table256[Y1]; //(512 / 2)
      oAddrY2 := Go_M_Table256[Go_MSX_VDT_CMD_REG_DY];
      Y := Y1; fbY := True;
      while fbY do
        begin
          Dx2 := 0;
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 512;
              if (iFlg = 0) then
                begin
                  oAddrX := Gi_D_Table2[Xp];
                  oAddrX2 := Gi_D_Table2[Go_MSX_VDT_CMD_REG_DX + Dx2];
                  MSX_VRAM[oAddrY2 + oAddrX2] := MSX_VRAM[oAddrY + oAddrX]; //16Color+16Color
                  iFlg := 1;
                end
              else
                begin
                  iFlg := 0;
                end;
              Dx2 := Dx2 + 1;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 256;
              oAddrY2 := oAddrY2 + 256;
            end
          else
            begin
              oAddrY := oAddrY - 256; if (oAddrY < 0) then oAddrY := oAddrY + 256;
              oAddrY2 := oAddrY2 - 256; if (oAddrY2 < 0) then oAddrY2 := oAddrY2 + 256;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  if (Gi_MSX_SCREEN_MODE = 8) then //2 Page, 0~255*0~511, 256색상
    begin
      oAddrY := Go_M_Table256[Y1];
      oAddrY2 := Go_M_Table256[Go_MSX_VDT_CMD_REG_DY];
      Y := Y1; fbY := True;
      while fbY do
        begin
          Dx2 := 0;
          X := X1; fbX := True;
          while fbX do
            begin
              Xp := X; if (Xp < 0) then Xp := Xp + 256;
              oAddrX := Xp;
              oAddrX2 := Go_MSX_VDT_CMD_REG_DX + Dx2;
              MSX_VRAM[oAddrY2 + oAddrX2] := MSX_VRAM[oAddrY + oAddrX]; //256Color
              Dx2 := Dx2 + 1;
              X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
            end;
          if (StY = 1) then
            begin
              oAddrY := oAddrY + 256;
              oAddrY2 := oAddrY2 + 256;
            end
          else
            begin
              oAddrY := oAddrY - 256; if (oAddrY < 0) then oAddrY := oAddrY + 256;
              oAddrY2 := oAddrY2 - 256; if (oAddrY2 < 0) then oAddrY2 := oAddrY2 + 256;
            end;
          Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
        end;
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY + Go_MSX_VDT_CMD_REG_NY);
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY - Go_MSX_VDT_CMD_REG_NY);
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_SY;
  MSX_VDT_CMD_REG_DY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;
end;

procedure MSX_VDT_CMD_REG46_HMMV;
var
  iBak: Byte;
begin
  iBak := MSX_VDT_CMD_REG_LO;

  MSX_VDT_CMD_REG_LO := 0;
  MSX_VDT_CMD_REG46_LMMV;

  MSX_VDT_CMD_REG_LO := iBak;
end;

procedure MSX_VDT_CMD_REG46_LMMC;
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  iColS: Byte;
  Dx, Dy: LongInt;
  Xp: LongInt;
  fo_MSX_VRAM_Buff_Count: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  X1 := 0;
  Y1 := 0;
  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      X2 := (Nx - 1); StX := 1;
    end
  else
    begin
      X2 := (Nx - 1) * (-1); StX := -1;
    end;
  if (MSX_VDT_CMD_REG_DIY = 0) then
    begin
      Y2 := (Ny - 1); StY := 1;
    end
  else
    begin
      Y2 := (Ny - 1) * (-1); StY := -1;
    end;

  fo_MSX_VRAM_Buff_Count := 0;

  Y := Y1; fbY := True;
  while fbY do
    begin
      Dy := Y + Go_MSX_VDT_CMD_REG_DY;
      X := X1; fbX := True;
      while fbX do
        begin
          Xp := X;
          if (Xp < 0) then
            begin
              if (Gi_MSX_SCREEN_MODE = 5) then Xp := Xp + 256;
              if (Gi_MSX_SCREEN_MODE = 6) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 7) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 8) then Xp := Xp + 256;
            end;
          Dx := Xp + Go_MSX_VDT_CMD_REG_DX;
          iColS := MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count];
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, iColS);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, iColS);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, iColS);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, iColS);
          fo_MSX_VRAM_Buff_Count := fo_MSX_VRAM_Buff_Count + 1;
          X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
        end;
      Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_DY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;

  Gi_MSX_Screen_Out := 1; //화면표시작업
end;

procedure MSX_VDT_CMD_REG46_LMCM;
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  Sx, Sy: LongInt;
  Xp: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  X1 := 0;
  Y1 := 0;
  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      X2 := (Nx - 1); StX := 1;
    end
  else
    begin
      X2 := (Nx - 1) * (-1); StX := -1;
    end;
  if (MSX_VDT_CMD_REG_DIY = 0) then
    begin
      Y2 := (Ny - 1); StY := 1;
    end
  else
    begin
      Y2 := (Ny - 1) * (-1); StY := -1;
    end;

  Go_MSX_VRAM_Buff_Count := 0;

  Y := Y1; fbY := True;
  while fbY do
    begin
      Sy := Y + Go_MSX_VDT_CMD_REG_SY;
      X := X1; fbX := True;
      while fbX do
        begin
          Xp := X;
          if (Xp < 0) then
            begin
              if (Gi_MSX_SCREEN_MODE = 5) then Xp := Xp + 256;
              if (Gi_MSX_SCREEN_MODE = 6) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 7) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 8) then Xp := Xp + 256;
            end;
          Sx := Xp + Go_MSX_VDT_CMD_REG_SX;
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMCM_5(Sx, Sy);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMCM_6(Sx, Sy);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMCM_7(Sx, Sy);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMCM_8(Sx, Sy);
          Go_MSX_VRAM_Buff_Count := Go_MSX_VRAM_Buff_Count + 1;
          X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
        end;
      Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_SY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;
  MSX_VDT_CMD_REG_CLR;
end;

//4 Page, 0~255*0~1023, 16색상
procedure MSX_VDT_CMD_REG46_LMCM_5(Sx: LongInt; Sy: LongInt);
var
  iPosS: LongInt;
  iColS: Byte;
  iColS2: Byte;
  oAddrS: LongInt;
begin
  iPosS := Gi_Col_Pos2[Sx];
  oAddrS := Go_M_Table128[Sy] + Gi_D_Table2[Sx]; //256/2*1024/2

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table16[iColS2 And $F0];
  if (iPosS = 1) then iColS := (iColS2 And $F);

  MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] := iColS;

  Gi_MSX_VDT_CMD_REG_Color := iColS;
end;

//4 Page, 0~511*0~1023, 4색상
procedure MSX_VDT_CMD_REG46_LMCM_6(Sx: LongInt; Sy: LongInt);
var
  iPosS: LongInt;
  iColS: Byte;
  iColS2: Byte;
  oAddrS: LongInt;
begin
  iPosS := Gi_Col_Pos4[Sx];
  oAddrS := Go_M_Table128[Sy] + Gi_D_Table4[Sx]; //512/4*1024/4

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table64[iColS2];
  if (iPosS = 1) then iColS := Gi_D_Table16[iColS2 And 63];
  if (iPosS = 2) then iColS := Gi_D_Table4[iColS2 And 15];
  if (iPosS = 3) then iColS := (iColS2 And 3);

  MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] := iColS;

  Gi_MSX_VDT_CMD_REG_Color := iColS;
end;

//2 Page, 0~511*0~511, 16색상
procedure MSX_VDT_CMD_REG46_LMCM_7(Sx: LongInt; Sy: LongInt);
var
  iPosS: LongInt;
  iColS: Byte;
  iColS2: Byte;
  oAddrS: LongInt;
begin
  iPosS := Gi_Col_Pos2[Sx];
  oAddrS := Go_M_Table256[Sy] + Gi_D_Table2[Sx]; //512/2*512/2

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table16[iColS2 And $F0];
  if (iPosS = 1) then iColS := (iColS2 And $F);

  MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] := iColS;

  Gi_MSX_VDT_CMD_REG_Color := iColS;
end;

//2 Page, 0~255*0~511, 256색상
procedure MSX_VDT_CMD_REG46_LMCM_8(Sx: LongInt; Sy: LongInt);
var
  iColS: Byte;
  oAddrS: LongInt;
begin
  oAddrS := Go_M_Table256[Sy] + Sx; //256*512

  iColS := MSX_VRAM[oAddrS];

  MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] := iColS;

  Gi_MSX_VDT_CMD_REG_Color := iColS;
end;

procedure MSX_VDT_CMD_REG46_LMMM;
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  Sx, Sy: LongInt;
  Dx, Dy: LongInt;
  Xp: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  X1 := 0;
  Y1 := 0;
  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      X2 := (Nx - 1); StX := 1;
    end
  else
    begin
      X2 := (Nx - 1) * (-1); StX := -1;
    end;
  if (MSX_VDT_CMD_REG_DIY = 0) then
    begin
      Y2 := (Ny - 1); StY := 1;
    end
  else
    begin
      Y2 := (Ny - 1) * (-1); StY := -1;
    end;

  Y := Y1; fbY := True;
  while fbY do
    begin
      Sy := Y + Go_MSX_VDT_CMD_REG_SY;
      Dy := Y + Go_MSX_VDT_CMD_REG_DY;
      X := X1; fbX := True;
      while fbX do
        begin
          Xp := X;
          if (Xp < 0) then
            begin
              if (Gi_MSX_SCREEN_MODE = 5) then Xp := Xp + 256;
              if (Gi_MSX_SCREEN_MODE = 6) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 7) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 8) then Xp := Xp + 256;
            end;
          Sx := Xp + Go_MSX_VDT_CMD_REG_SX;
          Dx := Xp + Go_MSX_VDT_CMD_REG_DX;
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMM_5(Sx, Sy, Dx, Dy);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMM_6(Sx, Sy, Dx, Dy);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMM_7(Sx, Sy, Dx, Dy);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMM_8(Sx, Sy, Dx, Dy);
          X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
        end;
      Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY + Go_MSX_VDT_CMD_REG_NY);
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_SY := goGetLngToLng(Go_MSX_VDT_CMD_REG_SY - Go_MSX_VDT_CMD_REG_NY);
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_SY;
  MSX_VDT_CMD_REG_DY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;
end;

//4 Page, 0~255*0~1023, 16색상
procedure MSX_VDT_CMD_REG46_LMMM_5(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
var
  iPosS, iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColS2, iColD2: Byte;
  oAddrS, oAddrD: LongInt;
begin
  iPosS := Gi_Col_Pos2[Sx];
  oAddrS := (Go_M_Table128[Sy] + Gi_D_Table2[Sx]); //256/2*1024/2
  iPosD := Gi_Col_Pos2[Dx];
  oAddrD := (Go_M_Table128[Dy] + Gi_D_Table2[Dx]); //256/2*1024/2

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table16[iColS2 And $F0];
  if (iPosS = 1) then iColS := (iColS2 And $F);
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table16[iColD2 And $F0];
  if (iPosD = 1) then iColD := (iColD2 And $F);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := ((iColD2 And $F) OR Gi_M_Table16[iColT]);
  if (iPosD = 1) then MSX_VRAM[oAddrD] := ((iColD2 And $F0) OR iColT);
end;

//4 Page, 0~511*0~1023, 4색상
procedure MSX_VDT_CMD_REG46_LMMM_6(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
var
  iPosS, iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColS2, iColD2: Byte;
  oAddrS, oAddrD: LongInt;
begin
  iPosS := Gi_Col_Pos4[Sx];
  oAddrS := Go_M_Table128[Sy] + Gi_D_Table4[Sx]; //512/4*1024/4
  iPosD := Gi_Col_Pos4[Dx];
  oAddrD := Go_M_Table128[Dy] + Gi_D_Table4[Dx]; //512/4*1024/4

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table64[iColS2 shr 6]; //[/]64
  if (iPosS = 1) then iColS := Gi_D_Table16[(iColS2 And 63) shr 4]; //[/]16
  if (iPosS = 2) then iColS := Gi_D_Table4[(iColS2 And 15) shr 2]; //[/]4
  if (iPosS = 3) then iColS := (iColS2 And 3);
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table64[iColD2 shr 6]; //[/]64
  if (iPosD = 1) then iColD := Gi_D_Table16[(iColD2 And 63) shr 4]; //[/]16
  if (iPosD = 2) then iColD := Gi_D_Table4[(iColD2 And 15) shr 2]; //[/]4
  if (iPosD = 3) then iColD := (iColD2 And 3);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 3);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := (((iColD2 And 63) And $F0) OR (iColT shl 6)); //[*]64
  if (iPosD = 1) then MSX_VRAM[oAddrD] := (((iColD2 And 207) And $F0) OR (iColT shl 4)); //[*]16
  if (iPosD = 2) then MSX_VRAM[oAddrD] := (((iColD2 And 243) And $F0) OR (iColT shl 2)); //[*]4
  if (iPosD = 3) then MSX_VRAM[oAddrD] := (((iColD2 And 252) And $F0) OR iColT);
end;

//2 Page, 0~511*0~511, 16색상
procedure MSX_VDT_CMD_REG46_LMMM_7(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
var
  iPosS, iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColS2, iColD2: Byte;
  oAddrS, oAddrD: LongInt;
begin
  iPosS := Gi_Col_Pos2[Sx];
  oAddrS := Go_M_Table256[Sy] + Gi_D_Table2[Sx]; //512/2*512/2
  iPosD := Gi_Col_Pos2[Dx];
  oAddrD := Go_M_Table256[Dy] + Gi_D_Table2[Dx]; //512/2*512/2

  iColS2 := MSX_VRAM[oAddrS];
  if (iPosS = 0) then iColS := Gi_D_Table16[iColS2 And $F0];
  if (iPosS = 1) then iColS := (iColS2 And $F);
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table16[iColD2 And $F0];
  if (iPosD = 1) then iColD := (iColD2 And $F);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := ((iColD2 And $F) OR Gi_M_Table16[iColT]);
  if (iPosD = 1) then MSX_VRAM[oAddrD] := ((iColD2 And $F0) OR iColT);
end;

//2 Page, 0~255*0~511, 256색상
procedure MSX_VDT_CMD_REG46_LMMM_8(Sx: LongInt; Sy: LongInt; Dx: LongInt; Dy: LongInt);
var
  iColS, iColD: Byte;
  oAddrS, oAddrD: LongInt;
begin
  oAddrS := Go_M_Table256[Sy] + Sx; //256*512
  oAddrD := Go_M_Table256[Dy] + Dx; //256*512

  iColS := MSX_VRAM[oAddrS];
  iColD := MSX_VRAM[oAddrD];

  MSX_VRAM[oAddrD] := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 255);
end;

procedure MSX_VDT_CMD_REG46_LMMV;
var
  X, Y: LongInt;
  X1, Y1, X2, Y2: LongInt; StX, StY: ShortInt;
  Nx, Ny: Word;
  Dx, Dy: LongInt;
  Xp: LongInt;
begin
  Nx := GET_VDT_CMD_REG_NX;
  Ny := GET_VDT_CMD_REG_NY;

  X1 := 0;
  Y1 := 0;
  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      X2 := (Nx - 1); StX := 1;
    end
  else
    begin
      X2 := (Nx - 1) * (-1); StX := -1;
    end;
  if (MSX_VDT_CMD_REG_DIY = 0) then
    begin
      Y2 := (Ny - 1); StY := 1;
    end
  else
    begin
      Y2 := (Ny - 1) * (-1); StY := -1;
    end;

  Y := Y1; fbY := True;
  while fbY do
    begin
      Dy := Y + Go_MSX_VDT_CMD_REG_DY;
      X := X1; fbX := True;
      while fbX do
        begin
          Xp := X;
          if (Xp < 0) then
            begin
              if (Gi_MSX_SCREEN_MODE = 5) then Xp := Xp + 256;
              if (Gi_MSX_SCREEN_MODE = 6) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 7) then Xp := Xp + 512;
              if (Gi_MSX_SCREEN_MODE = 8) then Xp := Xp + 256;
            end;
          Dx := Xp + Go_MSX_VDT_CMD_REG_DX;
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
          X := X + StX; fbX := gmbIfThen(StX = 1, X <= X2, X >= X2);
        end;
      Y := Y + StY; fbY := gmbIfThen(StY = 1, Y <= Y2, Y >= Y2);
    end;

  if (StY = 1) then
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_NY);
    end
  else
    begin
      Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_NY);
    end;
  MSX_VDT_CMD_REG_DY;
  Go_MSX_VDT_CMD_REG_NY := goGetLngToLng(0); //화면끝 ?
  MSX_VDT_CMD_REG_NY;
end;

//4 Page, 0~255*0~1023, 16색상
procedure MSX_VDT_CMD_REG46_LMMV_5(Dx: LongInt; Dy: LongInt; iCol: LongInt);
var
  iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  if ((Dx < 0) OR (Dx > 255)) then goto LastProc;
  if ((Dy < 0) OR (Dy > 1023)) then goto LastProc;

  iPosD := Gi_Col_Pos2[Dx];
  oAddrD := Go_M_Table128[Dy] + Gi_D_Table2[Dx]; //256/2*1024/2

  if (iCol = (-1)) then
    begin
      iColS := (Gi_MSX_VDT_CMD_REG_Color And 15);
    end
  else
    begin
      iColS := (iCol And 15);
    end;
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table16[iColD2 And $F0];
  if (iPosD = 1) then iColD := (iColD2 And $F);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := ((iColD2 And $F) OR Gi_M_Table16[iColT]);
  if (iPosD = 1) then MSX_VRAM[oAddrD] := ((iColD2 And $F0) OR iColT);

LastProc:
end;

//4 Page, 0~511*0~1023, 4색상
procedure MSX_VDT_CMD_REG46_LMMV_6(Dx: LongInt; Dy: LongInt; iCol: LongInt);
var
  iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  if ((Dx < 0) OR (Dx > 511)) then goto LastProc;
  if ((Dy < 0) OR (Dy > 1023)) then goto LastProc;

  iPosD := Gi_Col_Pos4[Dx];
  oAddrD := Go_M_Table128[Dy] + Gi_D_Table4[Dx]; //512/4*1024/4

  if (iCol = (-1)) then
    begin
      iColS := (Gi_MSX_VDT_CMD_REG_Color And 3);
    end
  else
    begin
      iColS := (iCol And 3);
    end;
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table64[iColD2];
  if (iPosD = 1) then iColD := Gi_D_Table16[iColD2 And 63];
  if (iPosD = 2) then iColD := Gi_D_Table4[iColD2 And 15];
  if (iPosD = 3) then iColD := (iColD2 And 3);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 3);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := ((iColD2 And 63) OR Gi_M_Table64[iColT]);
  if (iPosD = 1) then MSX_VRAM[oAddrD] := ((iColD2 And 207) OR Gi_M_Table16[iColT]);
  if (iPosD = 2) then MSX_VRAM[oAddrD] := ((iColD2 And 243) OR Gi_M_Table4[iColT]);
  if (iPosD = 3) then MSX_VRAM[oAddrD] := ((iColD2 And 252) OR iColT);

LastProc:
end;

//2 Page, 0~511*0~511, 16색상
procedure MSX_VDT_CMD_REG46_LMMV_7(Dx: LongInt; Dy: LongInt; iCol: LongInt);
var
  iPosD: LongInt;
  iColS, iColD, iColT: Byte;
  iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  if ((Dx < 0) OR (Dx > 511)) then goto LastProc;
  if ((Dy < 0) OR (Dy > 511)) then goto LastProc;

  iPosD := Gi_Col_Pos2[Dx];
  oAddrD := Go_M_Table256[Dy] + Gi_D_Table2[Dx]; //512/2*512/2

  if (iCol = (-1)) then
    begin
      iColS := (Gi_MSX_VDT_CMD_REG_Color And 15);
    end
  else
    begin
      iColS := (iCol And 15);
    end;
  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := Gi_D_Table16[iColD2 And $F0];
  if (iPosD = 1) then iColD := (iColD2 And $F);

  iColT := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15);

  if (iPosD = 0) then MSX_VRAM[oAddrD] := ((iColD2 And $F) OR Gi_M_Table16[iColT]);
  if (iPosD = 1) then MSX_VRAM[oAddrD] := ((iColD2 And $F0) OR iColT);

LastProc:
end;

//2 Page, 0~255*0~511, 256색상
procedure MSX_VDT_CMD_REG46_LMMV_8(Dx: LongInt; Dy: LongInt; iCol: LongInt);
var
  iColS, iColD: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin

  if ((Dx < 0) OR (Dx > 255)) then goto LastProc;
  if ((Dy < 0) OR (Dy > 511)) then goto LastProc;

  oAddrD := Go_M_Table256[Dy] + Dx; //256*512

  if (iCol = (-1)) then
    begin
      iColS := Gi_MSX_VDT_CMD_REG_Color;
    end
  else
    begin
      iColS := iCol;
    end;
  iColD := MSX_VRAM[oAddrD];

  MSX_VRAM[oAddrD] := (fi_MSX_VDT_CMD_LO(iColS, iColD) And 255);

LastProc:
end;

//Line
procedure MSX_VDT_CMD_REG46_LINE;
var
  i: LongInt;
  X1, Y1, X2, Y2: LongInt;
  Y: LongInt;
  F: Double; F1, F2: LongInt;
  Dx, Dy: LongInt;
begin
  X1 := Go_MSX_VDT_CMD_REG_DX;
  Y1 := Go_MSX_VDT_CMD_REG_DY;
  if (MSX_VDT_CMD_REG_MAJ = 0) then //X긴변
    begin
      if (MSX_VDT_CMD_REG_DIX = 0) then
        begin
          X2 := X1 + (Go_MSX_VDT_CMD_REG_Mjg);
        end
      else
        begin
          X2 := X1 + ((Go_MSX_VDT_CMD_REG_Mjg) * (-1));
        end;
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Y2 := Y1 + (Go_MSX_VDT_CMD_REG_Min);
        end
      else
        begin
          Y2 := Y1 + ((Go_MSX_VDT_CMD_REG_Min) * (-1));
        end;
      if (X1 > X2) then
        begin
          gmtSwap16(X1, X2);
          gmtSwap16(Y1, Y2);
        end;
      F2 := X2 - X1;
      if (Y1 <= Y2) then
        begin
          Y := 1;
          F1 := Y2 - Y1;
        end
      else
        begin
          Y := -1;
          F1 := Y1 - Y2;
        end;
      F := 0; if (F2 <> 0) then F := (F1) / (F2);
      for i := 0 to (X2 - X1) do
        begin
          Dx := X1 + i;
          Dy := Y1 + (Trunc(i * F + 0.5) * Y);
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
        end;
    end
  else //Y긴변
    begin
      if (MSX_VDT_CMD_REG_DIX = 0) then
        begin
          X2 := X1 + (Go_MSX_VDT_CMD_REG_Min);
        end
      else
        begin
          X2 := X1 + ((Go_MSX_VDT_CMD_REG_Min) * (-1));
        end;
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Y2 := Y1 + (Go_MSX_VDT_CMD_REG_Mjg);
        end
      else
        begin
          Y2 := Y1 + ((Go_MSX_VDT_CMD_REG_Mjg) * (-1));
        end;
      if (Y1 > Y2) then
        begin
          gmtSwap16(X1, X2);
          gmtSwap16(Y1, Y2);
        end;
      F2 := Y2 - Y1;
      if (X1 <= X2) then
        begin
          Y := 1;
          F1 := X2 - X1;
        end
      else
        begin
          Y := -1;
          F1 := X1 - X2;
        end;
      F := 0; if (F2 <> 0) then F := (F1) / (F2);
      for i := 0 to (Y2 - Y1) do
        begin
          Dy := Y1 + i;
          Dx := X1 + (Trunc(i * F + 0.5) * Y);
          if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
          if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
        end;
    end;

  if (MSX_VDT_CMD_REG_MAJ = 0) then //X긴변
    begin
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_Min);
        end
      else
        begin
          Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_Min);
        end;
    end
  else //Y긴변
    begin
      if (MSX_VDT_CMD_REG_DIY = 0) then
        begin
          Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY + Go_MSX_VDT_CMD_REG_Min);
        end
      else
        begin
          Go_MSX_VDT_CMD_REG_DY := goGetLngToLng(Go_MSX_VDT_CMD_REG_DY - Go_MSX_VDT_CMD_REG_Min);
        end;
    end;
  MSX_VDT_CMD_REG_DY;
end;

procedure MSX_VDT_CMD_REG46_SRCH;
var
  i: LongInt;
  X2: LongInt; StX: ShortInt;
  Sx, Sy: LongInt;
  iCol: Byte;
label
  LastProc;
begin
  Sx := Go_MSX_VDT_CMD_REG_SX;
  Sy := Go_MSX_VDT_CMD_REG_SY;

  if (MSX_VDT_CMD_REG_DIX = 0) then
    begin
      if (Gi_MSX_SCREEN_MODE = 5) then X2 := 255;
      if (Gi_MSX_SCREEN_MODE = 6) then X2 := 511;
      if (Gi_MSX_SCREEN_MODE = 7) then X2 := 511;
      if (Gi_MSX_SCREEN_MODE = 8) then X2 := 255;
      StX := 1;
    end
  else
    begin
      X2 := 0;
      StX := -1;
    end;

  MSX_VDT_ST_REG_BD := 0;

  i := Sx; fbX := True;
  while fbX do
    begin
      if (Gi_MSX_SCREEN_MODE = 5) then iCol := MSX_VDT_CMD_REG46_POINT_5(i, Sy);
      if (Gi_MSX_SCREEN_MODE = 6) then iCol := MSX_VDT_CMD_REG46_POINT_6(i, Sy);
      if (Gi_MSX_SCREEN_MODE = 7) then iCol := MSX_VDT_CMD_REG46_POINT_7(i, Sy);
      if (Gi_MSX_SCREEN_MODE = 8) then iCol := MSX_VDT_CMD_REG46_POINT_8(i, Sy);
      if (MSX_VDT_CMD_REG_EQ = 0) then //경계색발견
        begin
          if (iCol = Gi_MSX_VDT_CMD_REG_Color) then
            begin
              MSX_VDT_ST_REG_BD := 1; //발견
              Go_MSX_VDT_ST_REG_BX := (i And 511) OR 65024; //11111118 76543210
              goto LastProc;
            end;
        end
      else //경계색이외를발견
        begin
          if (iCol <> Gi_MSX_VDT_CMD_REG_Color) then
            begin
              MSX_VDT_ST_REG_BD := 1; //발견
              Go_MSX_VDT_ST_REG_BX := (i And 511) OR 65024; //11111118 76543210
              goto LastProc;
            end;
        end;
      i := i + StX; fbX := gmbIfThen(StX = 1, i <= X2, i >= X2);
    end;

LastProc:
end;

//Pset
procedure MSX_VDT_CMD_REG46_PSET;
var
  Dx, Dy: LongInt;
begin
  Dx := Go_MSX_VDT_CMD_REG_DX;
  Dy := Go_MSX_VDT_CMD_REG_DY;
  if (Gi_MSX_SCREEN_MODE = 5) then MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
  if (Gi_MSX_SCREEN_MODE = 6) then MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
  if (Gi_MSX_SCREEN_MODE = 7) then MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
  if (Gi_MSX_SCREEN_MODE = 8) then MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
end;

procedure MSX_VDT_CMD_REG46_POINT;
var
  Sx, Sy: LongInt;
begin
  Sx := Go_MSX_VDT_CMD_REG_SX;
  Sy := Go_MSX_VDT_CMD_REG_SY;
  if (Gi_MSX_SCREEN_MODE = 5) then Gi_MSX_VDT_ST_REG_Color := MSX_VDT_CMD_REG46_POINT_5(Sx, Sy);
  if (Gi_MSX_SCREEN_MODE = 6) then Gi_MSX_VDT_ST_REG_Color := MSX_VDT_CMD_REG46_POINT_6(Sx, Sy);
  if (Gi_MSX_SCREEN_MODE = 7) then Gi_MSX_VDT_ST_REG_Color := MSX_VDT_CMD_REG46_POINT_7(Sx, Sy);
  if (Gi_MSX_SCREEN_MODE = 8) then Gi_MSX_VDT_ST_REG_Color := MSX_VDT_CMD_REG46_POINT_8(Sx, Sy);

  Gi_MSX_VDT_CMD_REG_Color := Gi_MSX_VDT_ST_REG_Color;
  MSX_VDT_CMD_REG_CLR;
end;

//4 Page, 0~255*0~1023, 16색상
function MSX_VDT_CMD_REG46_POINT_5(Sx: LongInt; Sy: LongInt): Byte;
var
  iPosD: LongInt;
  iColD, iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  iColD := 0;
  if ((Sx < 0) OR (Sx > 255)) then goto LastProc;
  if ((Sy < 0) OR (Sy > 1023)) then goto LastProc;

  iPosD := Gi_Col_Pos2[Sx];
  oAddrD := Go_M_Table128[Sy] + Gi_D_Table2[Sx]; //256/2*1024/2

  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := (Gi_D_Table16[iColD2 And $F0]);
  if (iPosD = 1) then iColD := (iColD2 And $F);

LastProc:
  Result := iColD;
end;

//4 Page, 0~511*0~1023, 4색상
function MSX_VDT_CMD_REG46_POINT_6(Sx: LongInt; Sy: LongInt): Byte;
var
  iPosD: LongInt;
  iColD, iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  iColD := 0;
  if ((Sx < 0) OR (Sx > 511)) then goto LastProc;
  if ((Sy < 0) OR (Sy > 1023)) then goto LastProc;

  iPosD := Gi_Col_Pos4[Sx];
  oAddrD := Go_M_Table128[Sy] + Gi_D_Table4[Sx]; //512/4*1024/4

  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := (Gi_D_Table64[iColD2]);
  if (iPosD = 1) then iColD := (Gi_D_Table16[iColD2 And 63]);
  if (iPosD = 2) then iColD := (Gi_D_Table4[iColD2 And 15]);
  if (iPosD = 3) then iColD := (iColD2 And 3);

LastProc:
  Result := iColD;
end;

//2 Page, 0~511*0~511, 16색상
function MSX_VDT_CMD_REG46_POINT_7(Sx: LongInt; Sy: LongInt): Byte;
var
  iPosD: LongInt;
  iColD, iColD2: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  iColD := 0;
  if ((Sx < 0) OR (Sx > 511)) then goto LastProc;
  if ((Sy < 0) OR (Sy > 511)) then goto LastProc;

  iPosD := Gi_Col_Pos2[Sx];
  oAddrD := Go_M_Table256[Sy] + Gi_D_Table2[Sx]; //512/2*512/2

  iColD2 := MSX_VRAM[oAddrD];
  if (iPosD = 0) then iColD := (Gi_D_Table16[iColD2 And $F0]);
  if (iPosD = 1) then iColD := (iColD2 And $F);

LastProc:
  Result := iColD;
end;

//2 Page, 0~255*0~511, 256색상
function MSX_VDT_CMD_REG46_POINT_8(Sx: LongInt; Sy: LongInt): Byte;
var
  iColD: Byte;
  oAddrD: LongInt;
label
  LastProc;
begin
  iColD := 0;
  if ((Sx < 0) OR (Sx > 255)) then goto LastProc;
  if ((Sy < 0) OR (Sy > 511)) then goto LastProc;

  oAddrD := Go_M_Table256[Sy] + Sx; //256*512

  iColD := MSX_VRAM[oAddrD];

LastProc:
  Result := iColD;
end;

function fi_MSX_VDT_CMD_LO(iColS: Byte; iColD: Byte): Byte;
var
  R: Byte;
begin
  R := 0;

  if (MSX_VDT_CMD_REG_LO = $0) then R := iColS;
  if (MSX_VDT_CMD_REG_LO = $1) then R := (iColS And iColD);
  if (MSX_VDT_CMD_REG_LO = $2) then R := (iColS OR iColD);
  if (MSX_VDT_CMD_REG_LO = $3) then R := ((giGetIntToInt(Not iColS) And iColD) OR (iColS And giGetIntToInt(Not iColD)));
  if (MSX_VDT_CMD_REG_LO = $4) then R := (giGetIntToInt(Not iColS));

  if ((MSX_VDT_CMD_REG_LO >= $8) And (MSX_VDT_CMD_REG_LO <= $C)) then
  begin
    if (iColS = 0) then
      begin
        R := iColD;
      end
    else
      begin
        if (MSX_VDT_CMD_REG_LO = $8) then R := iColS;
        if (MSX_VDT_CMD_REG_LO = $9) then R := (iColS And iColD);
        if (MSX_VDT_CMD_REG_LO = $A) then R := (iColS OR iColD);
        if (MSX_VDT_CMD_REG_LO = $B) then R := ((giGetIntToInt(Not iColS) And iColD) OR (iColS And giGetIntToInt(Not iColD)));
        if (MSX_VDT_CMD_REG_LO = $C) then R := giGetIntToInt(Not iColS);
      end;
  end;

  Result := R;
end;

end.

