unit msxVDT_OUT;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Windows;

var
  BitmapInfo: TBitmapInfo;
  BitmapInfoHeader: TBitmapInfoHeader;

  //MSX1
  vdtBuffer40: Array[0..61440-1] Of LongInt;    //320*192(40*8*24*8)(40*24=960Char)
  vdtBuffer46: Array[0..46080-1] Of LongInt;    //240*192(40*6*24*8)(40*24=960Char)//글자우측2Dot표시안함(가로로크게표시됨)
  vdtBuffer32: Array[0..49152-1] Of LongInt;    //256*192(32*8*24*8)(32*24=768Char)
  vdtBufferSpr: Array[0..49152-1] Of SmallInt;  //256*192
  //MSX2
  vdtBuffer80: Array[0..122880-1] Of LongInt;   //640*192(80*8*24*8)(80*27=2160Char)
  vdtBuffer80p: Array[0..135680-1] Of LongInt;  //640*212(80*8*26.5*8)(80*27=2160Char)
  vdtBuffer86: Array[0..92160-1] Of LongInt;    //480*192(80*6*24*8)(80*27=2160Char)//글자우측2Dot표시안함(가로로크게표시됨)
  vdtBuffer86p: Array[0..101760-1] Of LongInt;  //480*212(80*6*26.5*8)(80*27=2160Char)//글자우측2Dot표시안함(가로로크게표시됨)
  vdtBuffer32p: Array[0..54272-1] Of LongInt;   //256*212(32*8*26.5*8)
  vdtBuffer64: Array[0..98304-1] Of LongInt;    //512*192(64*8*24*8)
  vdtBuffer64p: Array[0..108544-1] Of LongInt;  //512*212(64*8*26.5*8)
  vdtBufferSpr2: Array[0..54272-1] Of SmallInt; //256*212

  procedure MSX_SCREEN_INIT;
  procedure MSX_SCREEN_DISP;
  procedure MSX_SCREEN_0_DISP;
  procedure MSX_SCREEN_10_DISP;
  procedure MSX_SCREEN_1_DISP;
  procedure MSX_SCREEN_2_DISP;
  procedure MSX_SCREEN_3_DISP;
  procedure ft_MSX_SCREEN_3_PSet(X: LongInt; Y: LongInt; C: LongInt);
  procedure MSX_SCREEN_4_DISP;
  procedure MSX_SCREEN_5_DISP;
  procedure MSX_SCREEN_6_DISP;
  procedure MSX_SCREEN_7_DISP;
  procedure MSX_SCREEN_8_DISP;

implementation

uses
  FrmMSX2, msxMSX, msxVDT, msxVDT_SPRITE, msxTBL,
  untFunction;

procedure MSX_SCREEN_INIT;
begin
  if (Gi_MSX_SCREEN_MODE = 0) then
    begin
      if (GiCHAR = 0) then
        begin
          //40*24 (320*192)
          //With vdtBMPInfo.bmiHeader
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
          BitmapInfoHeader.biWidth := 320; //비트맵의 가로폭을 지정합니다.
          BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다. 무조건 1로 지정합니다.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
          //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
          //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
        end
      else
        begin
          //40*24 (240*192)
          //With vdtBMPInfo.bmiHeader
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
          BitmapInfoHeader.biWidth := 240; //비트맵의 가로폭을 지정합니다.
          BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다. 무조건 1로 지정합니다.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
          //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
          //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
        end;
    end;

  if (Gi_MSX_SCREEN_MODE = 10) then
    begin
      if (GiCHAR = 0) then
        begin
          //80*24/80*26.5 (640*192/640*212)
          if (MSX_VDT_REG_LN = 0) then
            begin
              BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
              BitmapInfoHeader.biWidth := 640; //비트맵의 가로폭을 지정합니다.
              BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
              BitmapInfoHeader.biPlanes := 1; //플레인 수입니다. 무조건 1로 지정합니다.
              BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
              BitmapInfoHeader.biCompression := 0;
              BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
              BitmapInfoHeader.biXPelsPerMeter := 0;
              BitmapInfoHeader.biYPelsPerMeter := 0;
              BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
              BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
              //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
              //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
            end
          else
            begin
              BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
              BitmapInfoHeader.biWidth := 640; //비트맵의 가로폭을 지정합니다.
              BitmapInfoHeader.biHeight := -212; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
              BitmapInfoHeader.biPlanes := 1; //플레인 수입니다. 무조건 1로 지정합니다.
              BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
              BitmapInfoHeader.biCompression := 0;
              BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
              BitmapInfoHeader.biXPelsPerMeter := 0;
              BitmapInfoHeader.biYPelsPerMeter := 0;
              BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
              BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
              //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
              //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
            end;
        end
      else
        begin
          //80*24/80*26.5 (480*192/480*212)
          if (MSX_VDT_REG_LN = 0) then
            begin
              BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
              BitmapInfoHeader.biWidth := 480; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
              BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
              BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
              BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
              BitmapInfoHeader.biCompression := 0;
              BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
              BitmapInfoHeader.biXPelsPerMeter := 0;
              BitmapInfoHeader.biYPelsPerMeter := 0;
              BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
              BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
              //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
              //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
            end
          else
            begin
              BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
              BitmapInfoHeader.biWidth := 480; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
              BitmapInfoHeader.biHeight := -212; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
              BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
              BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
              BitmapInfoHeader.biCompression := 0;
              BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
              BitmapInfoHeader.biXPelsPerMeter := 0;
              BitmapInfoHeader.biYPelsPerMeter := 0;
              BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
              BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
              //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
              //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
            end;
        end;
    end;

  if ((Gi_MSX_SCREEN_MODE = 1) OR (Gi_MSX_SCREEN_MODE = 2) OR (Gi_MSX_SCREEN_MODE = 4) OR (Gi_MSX_SCREEN_MODE = 3)) then
    begin
      //32*24 (256*192) / 16*12 (64*48)
      BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
      BitmapInfoHeader.biWidth := 256; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
      BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
      BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
      BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
      BitmapInfoHeader.biCompression := 0;
      BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
      BitmapInfoHeader.biXPelsPerMeter := 0;
      BitmapInfoHeader.biYPelsPerMeter := 0;
      BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
      BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
      //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
      //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
    end;

  if ((Gi_MSX_SCREEN_MODE = 5) OR (Gi_MSX_SCREEN_MODE = 8)) then
    begin
      //32*24/32*26BitmapInfoHeader.5 (256*192/256*212)
      if (MSX_VDT_REG_LN = 0) then
        begin
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
          BitmapInfoHeader.biWidth := 256; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
          //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
          //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
        end
      else
        begin
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
          BitmapInfoHeader.biWidth := 256; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biHeight := -212; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
          //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
          //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
        end;
    end;

  if ((Gi_MSX_SCREEN_MODE = 6) OR (Gi_MSX_SCREEN_MODE = 7)) then
    begin
      //64*24/64*26BitmapInfoHeader.5 (512*192/512*212)
      if (MSX_VDT_REG_LN = 0) then
        begin
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
          BitmapInfoHeader.biWidth := 512; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biHeight := -192; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
          //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
          //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
        end
      else
        begin
          BitmapInfoHeader.biSize := 40; //표준 비트맵은 헤더 크기가 무조건 40입니다BitmapInfoHeader.
          BitmapInfoHeader.biWidth := 512; //비트맵의 가로폭을 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biHeight := -212; //비트맵의 세로폭을 지정합니다BitmapInfoHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다BitmapInfoHeader.
          BitmapInfoHeader.biPlanes := 1; //플레인 수입니다BitmapInfoHeader. 무조건 1로 지정합니다BitmapInfoHeader.
          BitmapInfoHeader.biBitCount := 32; //몇 비트 컬러를 사용할지 지정합니다BitmapInfoHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
          BitmapInfoHeader.biCompression := 0;
          BitmapInfoHeader.biSizeImage := 0; //비트맵 데이터의 크기입니다BitmapInfoHeader. 이건 지정해도 그만 안해도 그만입니다BitmapInfoHeader. 지정 안해도 속도 저하 같은거 없습니다BitmapInfoHeader.
          BitmapInfoHeader.biXPelsPerMeter := 0;
          BitmapInfoHeader.biYPelsPerMeter := 0;
          BitmapInfoHeader.biClrUsed := 0; //팔레트에서 실제 사용할 색상수를 지정합니다BitmapInfoHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다BitmapInfoHeader.
          BitmapInfoHeader.biClrImportant := 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다BitmapInfoHeader.
          //나머지 요소는 모조리 0으로 지정하면 됩니다BitmapInfoHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다BitmapInfoHeader.
          //일곱번째 인수는 팔레트 처리방법인데BitmapInfoHeader.BitmapInfoHeader.BitmapInfoHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다BitmapInfoHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다BitmapInfoHeader.
        end
    end;

  BitmapInfo.bmiHeader := BitmapInfoHeader;
  BitmapInfo.bmiColors[0].rgbBlue := 0;
  BitmapInfo.bmiColors[0].rgbGreen := 0;
  BitmapInfo.bmiColors[0].rgbRed := 0;
  BitmapInfo.bmiColors[0].rgbReserved := 0;
end;

procedure MSX_SCREEN_DISP;
var
  i, j, c: LongInt;
begin
  //If (Gi_MSX_Screen_Out = 1) And (Gi_MSX_Timer_16_VDP = 1) Then
  if ((Gi_MSX_Execute = 1) And (Gi_MSX_Timer_16_VDP = 1)) then
  begin
    Gi_MSX_Screen_Out := 0;
    Gi_MSX_Timer_16_VDP := 0;
    if ((Gi_MSX_SCREEN_MODE <> Gi_MSX_Screen_Mode_Prv) OR
       ((Gi_MSX_SCREEN_MODE >= 5) And (MSX_VDT_REG_LN <> Gi_MSX_VDT_Reg_LN_Prv))) then
      begin
        MSX_SCREEN_INIT;
        c := RGB($20, $20, $E0); ////Dark Blue
        for i := 0 to MSX2Frm.ScrnMSX.Width - 1 do
          for j := 0 to MSX2Frm.ScrnMSX.Height - 1 do
            Msx2Frm.ScrnMSX.Canvas.Pixels[i, j] := c;
        Gi_MSX_Screen_Mode_Prv := Gi_MSX_SCREEN_MODE;
        Gi_MSX_VDT_Reg_LN_Prv := MSX_VDT_REG_LN;
      end;
    if (Gi_MSX_SCREEN_MODE = 0) then MSX_SCREEN_0_DISP; //TEXT MODE - 40*24문자*2색
    if (Gi_MSX_SCREEN_MODE = 1) then MSX_SCREEN_1_DISP; //GRAPHIC1 MODE - 32*24문자*16색
    if (Gi_MSX_SCREEN_MODE = 2) then MSX_SCREEN_2_DISP; //GRAPHIC2 MODE - 256*192도트*16색
    if (Gi_MSX_SCREEN_MODE = 3) then MSX_SCREEN_3_DISP; //MULTI COLOR MODE - 64*48도트*16색
    if (Gi_MSX_SCREEN_MODE = 10) then MSX_SCREEN_10_DISP; //TEXT2 MODE - 80*24문자*2색
    if (Gi_MSX_SCREEN_MODE = 4) then MSX_SCREEN_4_DISP; //GRAPHIC3 MODE - 256*192도트*16색
    if (Gi_MSX_SCREEN_MODE = 5) then MSX_SCREEN_5_DISP; //GRAPHIC4 MODE - 256*212도트*16색
    if (Gi_MSX_SCREEN_MODE = 6) then MSX_SCREEN_6_DISP; //GRAPHIC5 MODE - 512*212도트*4색
    if (Gi_MSX_SCREEN_MODE = 7) then MSX_SCREEN_7_DISP; //GRAPHIC6 MODE - 512*212도트*16색
    if (Gi_MSX_SCREEN_MODE = 8) then MSX_SCREEN_8_DISP; //GRAPHIC7 MODE - 256*212도트*256색
  end;
end;

//SCREEN 0[40], TEXT MODE - 40*24문자*2색
procedure MSX_SCREEN_0_DISP;
var
  i, j, k, L: LongInt;
  C, b, P: LongInt;
begin
  if (GiMSX2 = 0) then //MSX1
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 7]; //R4:(?????AAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 15]; //R2:(????AAAA)+0000000000, 0400h
    end
  else
    begin //MSX2
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 63]; //R4:(??AAAAAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 127]; //R2:(?AAAAAAA)+0000000000, 0400h
    end;

  Gi_MSX_ForeColor := Gi_D_Table16[MSX_VDT_REG[7] And $F0];
  Gi_MSX_BackColor := (MSX_VDT_REG[7] And $F);
  Gi_MSX_OutColor := Gi_MSX_BackColor;
  if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  if (GiCHAR = 0) then
    begin

      //61440:320*192(40*8*24*8),960:40*24
      if (MSX_VDT_REG_ON = 1) then
        begin
          for i := 0 to (960 - 1) do //화면 Char 표시
            begin
              C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
              P := Go_T_VRamTable[i];
              for j := 0 to 7 do //폰트
                begin
                  b := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                  for k := 1 to 8 do
                    begin
                      if ((b And Gi_B_Table[8 - k]) > 0) then
                        vdtBuffer40[P + k - 1] := Go_MSX_Color[Gi_MSX_ForeColor]
                      else
                        vdtBuffer40[P + k - 1] := Go_MSX_Color[Gi_MSX_BackColor]
                      ;
                    end;
                  P := P + 320; //1Line320Dot
                end;
            end;
        end
      else
        begin
          for L := 0 to (61440 - 1) do //화면 Clear
            begin
              vdtBuffer40[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end;
        end;

      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(320 * 2.94), Trunc(192 * 3.6), 0, 0, 320, 192, @vdtBuffer40, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end
  else
    begin

      //46080:240*192(40*6*24*8),960:40*24
      if (MSX_VDT_REG_ON = 1) then
        begin
          for i := 0 to (960 - 1) do //화면 Char 표시
            begin
              C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
              P := Go_T_VRamTable[i];
              for j := 0 to 7 do //폰트
                begin
                  b := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                  for k := 1 to 6 do
                    begin
                      if ((b And Gi_B_Table[8 - k]) > 0) then
                        vdtBuffer46[P + k - 1] := Go_MSX_Color[Gi_MSX_ForeColor]
                      else
                        vdtBuffer46[P + k - 1] := Go_MSX_Color[Gi_MSX_BackColor]
                      ;
                    end;
                  P := P + 240; //1Line240Dot
                end;
            end;
        end
      else
        begin
          for L := 0 to (46080 - 1) do //화면 Clear
            begin
              vdtBuffer46[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end;
        end;

      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 13, 12, Trunc(240 * 3.9), Trunc(192 * 3.6), 0, 0, 240, 192, @vdtBuffer46, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end;

end;

//SCREEN 0[80], TEXT2 MODE - 80*24문자*2색
procedure MSX_SCREEN_10_DISP;
var
  i, j, k, L: LongInt;
  C, b, P: LongInt;
  iForeColor, iBackColor: LongInt;
  N, Nc, Np: LongInt;
  PK: LongInt;
begin
  Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 63]; //R4:(??AAAAAA)+00000000000, 0800h - TEXT1 동일
  Go_MSX_SCR_CHAR_ADDR := Go_M_Table4096[Gi_D_Table4[MSX_VDT_REG[2] And 127]]; //R2:(?AAAAA11)+000000000000, 1000h
  Go_MSX_SCR_BLNK_ADDR := Gi_M_Table32[MSX_VDT_REG[10] And 7] + Gi_D_Table8[MSX_VDT_REG[3]]; //R3 :(AAAAA???)+000000000
  Go_MSX_SCR_BLNK_ADDR := Go_M_Table512[Go_MSX_SCR_BLNK_ADDR]; //R10:(?????AAA)
  Gi_MSX_ForeColor := Gi_D_Table16[MSX_VDT_REG[7] And $F0];
  Gi_MSX_BackColor := (MSX_VDT_REG[7] And $F);
  Gi_MSX_OutColor := Gi_MSX_BackColor;
  if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];
  Gi_MSX_ForeColor_Blink := Gi_D_Table16[MSX_VDT_REG[12] And $F0];
  Gi_MSX_BackColor_Blink := (MSX_VDT_REG[12] And $F);
  Gi_MSX_Blink_Time_Bl := Gi_D_Table16[MSX_VDT_REG[13] And $F0]; //Bl/6초
  Gi_MSX_Blink_Time_Co := (MSX_VDT_REG[13] And $F); //Co/6초

  if (GiCHAR = 0) then
    begin

      //122880:640*192(80*8*24*8),  2160[80*27]
      //135680:640*212(80*8*26.5*8),2160[80*27]
      Nc := 0; Np := 7;
      if (MSX_VDT_REG_ON = 1) then
        begin
          for i := 0 to (2160 - 1) do //화면 Char 표시
            begin
              C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
              N := MSX_VRAM[Go_MSX_SCR_BLNK_ADDR + Nc];
              if (((N And Gi_B_Table[Np]) = 0) OR (Gi_MSX_Blink_Time_Bl = 0)) then
                begin
                  //Normal
                  iForeColor := Gi_MSX_ForeColor;
                  iBackColor := Gi_MSX_BackColor;
                end
              else
                begin
                  //Blink
                  iForeColor := Gi_MSX_ForeColor_Blink;
                  iBackColor := Gi_MSX_BackColor_Blink;
                end;
              P := Go_T2_VRamTable[i];
              for j := 0 to 7 do //폰트
                begin
                  b := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                  for k := 1 to 8 do
                    begin
                      PK := P + k - 1;
                      if ((b And Gi_B_Table[8 - k]) > 0) then
                        begin
                          if (MSX_VDT_REG_LN = 0) then
                            if (PK < 122880) then vdtBuffer80[PK] := Go_MSX_Color[iForeColor]
                          else
                            if (PK < 135680) then vdtBuffer80p[PK] := Go_MSX_Color[iForeColor]
                          ;
                        end
                      else
                        begin
                          if (MSX_VDT_REG_LN = 0) then
                            if (PK < 122880) then vdtBuffer80[PK] := Go_MSX_Color[iBackColor]
                          else
                            if (PK < 135680) then vdtBuffer80p[PK] := Go_MSX_Color[iBackColor]
                          ;
                        end;
                    end;
                  P := P + 640; //1Line640Dot
                end;
              Np := Np - 1; if (Np < 0) then begin Nc := Nc + 1; Np := 7; end;
            end;
        end
      else
        begin
          if (MSX_VDT_REG_LN = 0) then
            begin
              for L := 0 to (122880 - 1) do //화면 Clear
                vdtBuffer80[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end
          else
            begin
              for L := 0 to (135680 - 1) do //화면 Clear
                vdtBuffer80p[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end;
        end;

      if (MSX_VDT_REG_LN = 0) then
        begin
          StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(640 * 1.47), Trunc(192 * 3.6), 0, 0, 640, 192, @vdtBuffer80, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
          MSX2Frm.ScrnMSX.Refresh;
        end
      else
        begin
          StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(640 * 1.47), Trunc(212 * 3.25), 0, 0, 640, 212, @vdtBuffer80p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
          MSX2Frm.ScrnMSX.Refresh;
        end;
    end
  else
    begin

      // 92160:480*192(80*6*24*8),  2160[80*27]
      //101760:480*212(80*6*26.5*8),2160[80*27]
      Nc := 0; Np := 7;
      if (MSX_VDT_REG_ON = 1) then
        begin
          for i := 0 to (2160 - 1) do //화면 Char 표시
            begin
              C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
              N := MSX_VRAM[Go_MSX_SCR_BLNK_ADDR + Nc];
              if (((N And Gi_B_Table[Np]) = 0) OR (Gi_MSX_Blink_Time_Bl = 0)) then
                begin
                  //Normal
                  iForeColor := Gi_MSX_ForeColor;
                  iBackColor := Gi_MSX_BackColor;
                end
              else
                begin
                  //Blink
                  iForeColor := Gi_MSX_ForeColor_Blink;
                  iBackColor := Gi_MSX_BackColor_Blink;
                end;
              P := Go_T2_VRamTable[i];
              for j := 0 to 7 do //폰트
                begin
                  b := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                  for k := 1 to 6 do
                    begin
                      PK := P + k - 1;
                      if ((b And Gi_B_Table[8 - k]) > 0) then
                        begin
                          if (MSX_VDT_REG_LN = 0) then
                            if (PK < 92160) then vdtBuffer86[PK] := Go_MSX_Color[iForeColor]
                          else
                            if (PK < 101760) then vdtBuffer86p[PK] := Go_MSX_Color[iForeColor]
                          ;
                        end
                      else
                        begin
                          if (MSX_VDT_REG_LN = 0) then
                            if (PK < 92160) then vdtBuffer86[PK] := Go_MSX_Color[iBackColor]
                          else
                            if (PK < 101760) then vdtBuffer86p[PK] := Go_MSX_Color[iBackColor]
                          ;
                        end;
                    end;
                  P := P + 480; //1Line480Dot
                end;
              Np := Np - 1; if (Np < 0) then begin Nc := Nc + 1; Np := 7; end;
            end;
        end
      else
        begin
          if (MSX_VDT_REG_LN = 0) then
            begin
              for L := 0 to (92160 - 1) do //화면 Clear
                vdtBuffer86[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end
          else
            begin
              for L := 0 to (101760 - 1) do //화면 Clear
                vdtBuffer86p[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
            end;
        end;

      if (MSX_VDT_REG_LN = 0) then
        begin
          StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(480 * 1.96), Trunc(192 * 3.6), 0, 0, 480, 192, @vdtBuffer86, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
          MSX2Frm.ScrnMSX.Refresh;
        end
      else
        begin
          StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(480 * 1.96), Trunc(212 * 3.25), 0, 0, 480, 212, @vdtBuffer86p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
          MSX2Frm.ScrnMSX.Refresh;
        end;
    end;
end;

//SCREEN 1, GRAPHIC1 MODE - 32*24문자*16색
procedure MSX_SCREEN_1_DISP;
var
  i, j, k, L: LongInt;
  C, b, O, P: LongInt;
  MSX_ForeColor: LongInt;
  MSX_BackColor: LongInt;
begin
  if (GiMSX2 = 0) then //MSX1
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 7]; //R4: (?????AAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 15]; //R2: (????AAAA)+0000000000, 0400h
      Go_MSX_SCR_COLR_ADDR := Gi_M_Table64[MSX_VDT_REG[3]]; //R3: (AAAAAAAA)+000000, 0040h
    end
  else //MSX2
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 63]; //R4: (??AAAAAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 127]; //R2: (?AAAAAAA)+0000000000, 0400h
      Go_MSX_SCR_COLR_ADDR := Gi_M_Table64[MSX_VDT_REG[3]]; //R3: (AAAAAAAA)+000000, 0040h
      Go_MSX_SCR_COLR_ADDR := Go_MSX_SCR_COLR_ADDR + Go_M_Table16384[MSX_VDT_REG[10] And 7]; //R10:(?????AAA)+AAAAAAAA000000. 4???h
    end;

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor := 0) Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  //49152:256*192(32*8*24*8),768:32*24
  if (MSX_VDT_REG_ON = 1) then
    begin
      for i := 0 to (768 - 1) do //화면 Char 표시
        begin
          C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
          O := MSX_VRAM[Go_MSX_SCR_COLR_ADDR + Gi_D_Table8[C]]; //해당문자Color테이블8Byte
          MSX_ForeColor := Gi_MSX_ForeColors[O];
          MSX_BackColor := Gi_MSX_BackColors[O];
          if (MSX_ForeColor = 0) then MSX_ForeColor := Gi_MSX_OutColor;
          if (MSX_BackColor = 0) then MSX_BackColor := Gi_MSX_OutColor;
          P := Go_G_VRamTable[i];
          for j := 0 to 7 do //폰트
            begin
              b := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
              for k := 1 to 8 do
                begin
                  if ((b And Gi_B_Table[8 - k]) > 0) then
                    vdtBuffer32[P + k - 1] := Go_MSX_Color[MSX_ForeColor]
                  else
                    vdtBuffer32[P + k - 1] := Go_MSX_Color[MSX_BackColor]
                  ;
                end;
              P := P + 256; //1Line256Dot
            end;
        end;
      MSX_SPRITE_DISP;
    end
  else
    begin
      for L := 0 to (49152 - 1) do //화면 Clear
        vdtBuffer32[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
    end;

  StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(192 * 3.6), 0, 0, 256, 192, @vdtBuffer32, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
  MSX2Frm.ScrnMSX.Refresh;
end;

//SCREEN 2, GRAPHIC2 MODE - 256*192도트*16색
procedure MSX_SCREEN_2_DISP;
var
  i, j, k, L: LongInt;
  C, b, O, P: LongInt;
  oAddr1, oAddr2: LongInt;
  MSX_ForeColor: LongInt;
  MSX_BackColor: LongInt;
begin
  if (GiMSX2 = 0) then //MSX1
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table8192[Gi_D_Table4[MSX_VDT_REG[4] And 4]]; //R4: (?????A11)+0000000000000, 2000h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 15]; //R2: (????AAAA)+0000000000, 0400h
      Go_MSX_SCR_COLR_ADDR := Go_M_Table8192[Gi_D_Table128[MSX_VDT_REG[3] And 128]]; //R3: (A1111111)+0000000000000, 2000h
    end
  else //MSX2
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table8192[Gi_D_Table4[MSX_VDT_REG[4] And 63]]; //R4: (??AAAA11)+0000000000000, 2000h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 127]; //R2: (?AAAAAAA)+0000000000, 0400h
      Go_MSX_SCR_COLR_ADDR := Go_M_Table8192[Gi_D_Table128[MSX_VDT_REG[3] And 128]]; //R3: (A1111111)+0000000000000, 2000h
      Go_MSX_SCR_COLR_ADDR := Go_MSX_SCR_COLR_ADDR + Go_M_Table16384[MSX_VDT_REG[10] And 7]; //R10:(?????AAA)+AAAAAAAA000000. 4???h
    end;

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  //49152:256*192(32*8*24*8),768:32*24
  if (MSX_VDT_REG_ON = 1) then
    begin
      for i := 0 to (768 - 1) do //화면 Char 표시
        begin
          C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
          P := Go_G_VRamTable[i];
          for j := 0 to 7 do //폰트
            begin
              oAddr1 := Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C] + j;
              oAddr2 := Go_MSX_SCR_COLR_ADDR + Gi_M_Table8[C] + j;
              if (i >= 256) then begin oAddr1 := oAddr1 + 2048; oAddr2 := oAddr2 + 2048; end; //256*8
              if (i >= 512) then begin oAddr1 := oAddr1 + 2048; oAddr2 := oAddr2 + 2048; end; //256*8
              b := MSX_VRAM[oAddr1]; //해당문자Font테이블8Byte
              O := MSX_VRAM[oAddr2]; //해당문자Color테이블8Byte
              MSX_ForeColor := Gi_MSX_ForeColors[O];
              MSX_BackColor := Gi_MSX_BackColors[O];
              if (MSX_ForeColor = 0) then MSX_ForeColor := Gi_MSX_OutColor;
              if (MSX_BackColor = 0) then MSX_BackColor := Gi_MSX_OutColor;
              for k := 1 to 8 do
                begin
                  if ((b And Gi_B_Table[8 - k]) > 0) then
                    vdtBuffer32[P + k - 1] := Go_MSX_Color[MSX_ForeColor]
                  else
                    vdtBuffer32[P + k - 1] := Go_MSX_Color[MSX_BackColor]
                  ;
                end;
              P := P + 256; //1Line256Dot
            end;
        end;
      if (Gi_MSX_SCREEN_MODE = 2) then
        MSX_SPRITE_DISP
      else
        MSX_SPRITE_2_DISP(0)
      ;
    end
  else
    begin
      for L := 0 to (49152 - 1) do //화면 Clear
        vdtBuffer32[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
    end;

  StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(192 * 3.6), 0, 0, 256, 192, @vdtBuffer32, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
  MSX2Frm.ScrnMSX.Refresh;
end;

//SCREEN 3, MULTI COLOR MODE - 32*24블록,64*48도트,(256*192)*16색
procedure MSX_SCREEN_3_DISP;
var
  i, L, C, O, Co, Ch, Cl: LongInt;
  X, Y, Z: LongInt;
begin
  if (GiMSX2 = 0) then //MSX1
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 7]; //R4: (?????AAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 15]; //R2: (????AAAA)+0000000000, 0400h
    end
  else //MSX2
    begin
      Go_MSX_SCR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[4] And 63]; //R4: (??AAAAAA)+00000000000, 0800h
      Go_MSX_SCR_CHAR_ADDR := Go_M_Table1024[MSX_VDT_REG[2] And 127]; //R2: (?AAAAAAA)+0000000000, 0400h
    end;

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  //32*24블록,64*48도트
  if (MSX_VDT_REG_ON = 1) then
    begin
      for i := 0 to 767 do
        begin
          C := MSX_VRAM[Go_MSX_SCR_CHAR_ADDR + i];
          O := Go_MSX_SCR_FONT_ADDR + Gi_M_Table8[C];
          //X(32)*Y(24)블록구하기
          Y := Gi_D_Table32[i];
          X := i mod 32;
          Z := Gi_M_Table2[Y mod 4];
          //블록표시,32*24->64*48
          X := Gi_M_Table2[X]; //0,2,4~62
          Y := Gi_M_Table2[Y]; //0,2,4~46
          Co := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + O + Z];
          Ch := Gi_D_Table16[Co And $F0]; //좌
          Cl := Co And $F; //우
          ft_MSX_SCREEN_3_PSet(X + 0, Y + 0, Go_MSX_Color[Ch]); //좌(상)
          ft_MSX_SCREEN_3_PSet(X + 1, Y + 0, Go_MSX_Color[Cl]); //우(상)
          Co := MSX_VRAM[Go_MSX_SCR_FONT_ADDR + O + Z + 1];
          Ch := Gi_D_Table16[Co And $F0]; //좌
          Cl := Co And $F; //우
          ft_MSX_SCREEN_3_PSet(X + 0, Y + 1, Go_MSX_Color[Ch]); //좌(하)
          ft_MSX_SCREEN_3_PSet(X + 1, Y + 1, Go_MSX_Color[Cl]); //우(하)
        end;
    end
  else
    begin
      for L := 0 to (49152 - 1) do //화면 Clear
        vdtBuffer32[L] := Go_MSX_Color[Gi_MSX_OutColor]; //화면을배경색으로채움
    end;

  MSX_SPRITE_DISP;

  StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(192 * 3.6), 0, 0, 256, 192, @vdtBuffer32, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
  MSX2Frm.ScrnMSX.Refresh;
end;

procedure ft_MSX_SCREEN_3_PSet(X: LongInt; Y: LongInt; C: LongInt);
var
  i, L, L2: LongInt;
begin
  //64*48->256*192
  L := Go_M_Table256[Gi_M_Table4[Y]] + Gi_M_Table4[X];

  for i := 0 to 3 do //0~3Col
    begin
      L2 := L + i;
      vdtBuffer32[L2] := C;     //0Line
      vdtBuffer32[L2 + 256] := C; //1Line
      vdtBuffer32[L2 + 512] := C; //2Line
      vdtBuffer32[L2 + 768] := C; //3Line
    end;
end;

//SCREEN 4, GRAPHIC3 MODE - 256*192도트*16색
procedure MSX_SCREEN_4_DISP;
begin
  MSX_SCREEN_2_DISP;
end;

//SCREEN 5, GRAPHIC4 MODE - 256*212도트*16색
procedure MSX_SCREEN_5_DISP;
var
  i, L, L1, L2, Lx: LongInt;
  Lt, F, C: LongInt;
  iLine, iLineDsp, iLineFlg: LongInt;
  MSX_ForeColor: LongInt;
label
  SpriteProc;
begin
  //Go_MSX_SCR_CHAR_ADDR := Go_M_Table32768(Gi_D_Table32(MSX_VDT_REG(2) And 127)) //R2: (?AA11111)+000000000000000, 8000h
  Go_MSX_SCR_CHAR_ADDR := Go_M_Table32768[Gi_MSX_Graphic_Page]; //0~3 * 8000h

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  if (MSX_VDT_REG_LN = 0) then
    Lt := 49152 - 1 //256*192
  else
    Lt := 54272 - 1 //256*212
  ;

  iLine := 0; iLineFlg := 0;
  if (MSX_VDT_REG_ON = 1) then
    begin
      F := 0;
      L1 := Go_MSX_SCR_CHAR_ADDR;
      L2 := Go_M_Table128[MSX_VDT_REG[23]];
      L := L1 + L2; Lx := L1 + 32767;
      for i := 0 to Lt do
        begin
          C := MSX_VRAM[L];
          if (F = 0) then
            begin
              MSX_ForeColor := Gi_D_Table16[C And $F0];
              F := 1;
            end
          else
            begin
              MSX_ForeColor := C And $F;
              F := 0;
              L := L + 1;
              if (L > Lx) then L := L - 32768;
            end;
          if (MSX_VDT_REG_LN = 0) then
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer32[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer32[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end
          else
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer32p[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer32p[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end;
          iLineFlg := iLineFlg + 1;
          if (iLineFlg = 256) then
            begin
              if (MSX_VDT_REG_IE1 = 1) then
                begin
                  iLineDsp := MSX_VDT_REG[23] + iLine;
                  if (iLineDsp > 255) then iLineDsp := iLineDsp - 256;
                  if (iLineDsp = (MSX_VDT_REG[19] + 3)) then begin MSX_VDT_ST_REG_FH := 1; goto SpriteProc; end; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                end;
              iLineFlg := 0;
              iLine := iLine + 1;
              L1 := Go_M_Table32768[Gi_MSX_Graphic_Page];
              L2 := Go_M_Table128[MSX_VDT_REG[23] + iLine];
              L := L1 + L2; Lx := L1 + 32767;
              if (L > Lx) then L := L - 32768;
            end;
        end;
    end
  else
    begin
      for i := 0 to Lt do
        begin
          if (MSX_VDT_REG_LN = 0) then
            vdtBuffer32[i] := 0
          else
            vdtBuffer32p[i] := 0
          ;
        end;
    end;

SpriteProc: ;
  MSX_SPRITE_2_DISP(MSX_VDT_REG_LN);

  if (MSX_VDT_REG_LN = 0) then
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(192 * 3.6), 0, 0, 256, 192, @vdtBuffer32, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end
  else
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(212 * 3.25), 0, 0, 256, 212, @vdtBuffer32p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end;
end;

//SCREEN 6, GRAPHIC5 MODE - 512*212도트*4색
procedure MSX_SCREEN_6_DISP;
var
  i, L, L1, L2, Lx: LongInt;
  Lt, F, C: LongInt;
  iLine, iLineDsp, iLineFlg: LongInt;
  MSX_ForeColor: LongInt;
label
  SpriteProc;
begin
  //Go_MSX_SCR_CHAR_ADDR := Go_M_Table32768(Gi_D_Table32(MSX_VDT_REG(2) And 127)) //R2: (?AA11111)+000000000000000, 8000h
  Go_MSX_SCR_CHAR_ADDR := Go_M_Table32768[Gi_MSX_Graphic_Page]; //0~3 * 8000h

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  if (MSX_VDT_REG_LN = 0) then
    Lt := 98304 - 1 //512*192
  else
    Lt := 108544 - 1 //512*212
  ;

  iLine := 0; iLineFlg := 0;
  if (MSX_VDT_REG_ON = 1) then
    begin
      F := 0;
      L1 := Go_MSX_SCR_CHAR_ADDR;
      L2 := Go_M_Table128[MSX_VDT_REG[23]];
      L := L1 + L2; Lx := L1 + 32767;
      for i := 0 to Lt do
        begin
          C := MSX_VRAM[L];
          if (F = 0) then MSX_ForeColor := Gi_D_Table64[C And 192];
          if (F = 1) then MSX_ForeColor := Gi_D_Table16[C And 48];
          if (F = 2) then MSX_ForeColor := Gi_D_Table4[C And 12];
          if (F = 3) then MSX_ForeColor := (C And 3);
          F := F + 1;
          if (F = 4) then
            begin
              F := 0;
              L := L + 1;
              if (L > Lx) then L := L - 32768;
            end;
          if (MSX_VDT_REG_LN = 0) then
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer64[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer64[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end
          else
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer64p[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer64p[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end;
          iLineFlg := iLineFlg + 1;
          if (iLineFlg = 512) then
            begin
              if (MSX_VDT_REG_IE1 = 1) then
                begin
                  iLineDsp := MSX_VDT_REG[23] + iLine;
                  if (iLineDsp > 255) then iLineDsp := iLineDsp - 256;
                  if (iLineDsp = (MSX_VDT_REG[19] + 3)) then begin MSX_VDT_ST_REG_FH := 1; goto SpriteProc; end; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                end;
              iLineFlg := 0;
              iLine := iLine + 1;
              L1 := Go_M_Table32768[Gi_MSX_Graphic_Page];
              L2 := Go_M_Table128[MSX_VDT_REG[23] + iLine];
              L := L1 + L2; Lx := L1 + 32767;
              if (L > Lx) then L := L - 32768;
            end;
        end;
    end
  else
    begin
      for i := 0 to Lt do
        begin
          if (MSX_VDT_REG_LN = 0) then
            vdtBuffer64[i] := 0
          else
            vdtBuffer64p[i] := 0
          ;
        end;
    end;

SpriteProc: ;
  MSX_SPRITE_2_DISP(MSX_VDT_REG_LN);

  if (MSX_VDT_REG_LN = 0) then
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(512 * 1.84), Trunc(192 * 3.6), 0, 0, 512, 192, @vdtBuffer64, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end
  else
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(512 * 1.84), Trunc(212 * 3.25), 0, 0, 512, 212, @vdtBuffer64p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end;
end;

//SCREEN 7, GRAPHIC6 MODE - 512*212도트*16색
procedure MSX_SCREEN_7_DISP;
var
  i, L, L1, L2, Lx: LongInt;
  Lt, F, C: LongInt;
  iLine, iLineDsp, iLineFlg: LongInt;
  MSX_ForeColor: LongInt;
label
  SpriteProc;
begin
  //Go_MSX_SCR_CHAR_ADDR := Go_M_Table65536(Gi_D_Table32(MSX_VDT_REG(2) And 63)) //R2: (??A11111)+0000000000000000, 10000h
  Go_MSX_SCR_CHAR_ADDR := Go_M_Table65536[Gi_MSX_Graphic_Page]; //0~1 * 10000h

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  if (MSX_VDT_REG_LN = 0) then
    Lt := 98304 - 1 //512*192
  else
    Lt := 108544 - 1 //512*212
  ;

  iLine := 0; iLineFlg := 0;
  if (MSX_VDT_REG_ON = 1) then
    begin
      F := 0;
      L1 := Go_MSX_SCR_CHAR_ADDR;
      L2 := Go_M_Table256[MSX_VDT_REG[23]];
      L := L1 + L2; Lx := L1 + 65535;
      for i := 0 to Lt do
        begin
          C := MSX_VRAM[L];
          if (F = 0) then
            begin
              MSX_ForeColor := Gi_D_Table16[C And $F0];
              F := 1;
            end
          else
            begin
              MSX_ForeColor := C And $F;
              F := 0;
              L := L + 1;
              if (L > Lx) then L := L - 65536;
            end;
          if (MSX_VDT_REG_LN = 0) then
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer64[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer64[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end
          else
            begin
              if ((MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) then
                vdtBuffer64p[i] := Go_MSX_Color[Gi_MSX_OutColor]
              else
                vdtBuffer64p[i] := Go_MSX_Color[MSX_ForeColor]
              ;
            end;
          iLineFlg := iLineFlg + 1;
          if (iLineFlg = 512) then
            begin
              if (MSX_VDT_REG_IE1 = 1) then
                begin
                  iLineDsp := MSX_VDT_REG[23] + iLine;
                  if (iLineDsp > 255) then iLineDsp := iLineDsp - 256;
                  if (iLineDsp = (MSX_VDT_REG[19] + 3)) then begin MSX_VDT_ST_REG_FH := 1; goto SpriteProc; end; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                end;
              iLineFlg := 0;
              iLine := iLine + 1;
              L1 := Go_M_Table65536[Gi_MSX_Graphic_Page];
              L2 := Go_M_Table256[MSX_VDT_REG[23] + iLine];
              L := L1 + L2; Lx := L1 + 65535;
              if (L > Lx) then L := L - 65536;
            end;
        end;
    end
  else
    begin
      for i := 0 to Lt do
        begin
          if (MSX_VDT_REG_LN = 0) then
            vdtBuffer64[i] := 0
          else
            vdtBuffer64p[i] := 0
          ;
        end;
    end;

SpriteProc:
  MSX_SPRITE_2_DISP(MSX_VDT_REG_LN);

  if (MSX_VDT_REG_LN = 0) then
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(512 * 1.84), Trunc(192 * 3.6), 0, 0, 512, 192, @vdtBuffer64, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end
  else
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(512 * 1.84), Trunc(212 * 3.25), 0, 0, 512, 212, @vdtBuffer64p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end;
end;

//SCREEN 8, GRAPHIC7 MODE - 256*212도트*256색
procedure MSX_SCREEN_8_DISP;
var
  i, L, L1, L2, Lx: LongInt;
  Lt, C: LongInt;
  iLine, iLineDsp, iLineFlg: LongInt;
  MSX_ForeColor: LongInt;
  Color_Green: LongInt;
  Color_Red: LongInt;
  Color_Blue: LongInt;
label
  SpriteProc;
begin
  //Go_MSX_SCR_CHAR_ADDR := Go_M_Table65536(Gi_D_Table32(MSX_VDT_REG(2) And 63)) //R2: (??A11111)+0000000000000000, 10000h
  Go_MSX_SCR_CHAR_ADDR := Go_M_Table65536[Gi_MSX_Graphic_Page]; //0~1 * 10000h

  Gi_MSX_OutColor := (MSX_VDT_REG[7] And $F);
  //if (Gi_MSX_OutColor = 0) then Gi_MSX_OutColor := 4; //파란색
  //////////수정할곳 => MSX2Frm.ScrnMSX.BackColor := Gc_MSX_Color_RGB[Gi_MSX_OutColor];

  if (MSX_VDT_REG_LN = 0) then
    Lt := 49152 - 1 //256*192
  else
    Lt := 54272 - 1 //256*212
  ;

  iLine := 0; iLineFlg := 0;
  if (MSX_VDT_REG_ON = 1) then
    begin
      L1 := Go_MSX_SCR_CHAR_ADDR;
      L2 := Go_M_Table256[MSX_VDT_REG[23]];
      L := L1 + L2; Lx := L1 + 65535;
      for i := 0 to Lt do
        begin
          C := MSX_VRAM[L];
          L := L + 1;
          if (L > Lx) then L := L - 65536;
          Color_Green := Gi_D_Table32[C And 224]; //11100000
          Color_Red := Gi_D_Table4[C And 28];   //00011100
          Color_Blue := Gi_M_Table2[C And 3];   //00000011*
          Color_Green := Gi_M_Table36[Color_Green];
          Color_Red := Gi_M_Table36[Color_Red];
          Color_Blue := Gi_M_Table36[Color_Blue];
          //MSX_ForeColor := goRGB((Byte)Color_Blue, (Byte)Color_Green, (Byte)Color_Red); //VB6
          MSX_ForeColor := gmoRGB(Color_Red, Color_Green, Color_Blue);
          if (MSX_VDT_REG_LN = 0) then
            vdtBuffer32[i] := MSX_ForeColor
          else
            vdtBuffer32p[i] := MSX_ForeColor
          ;
          iLineFlg := iLineFlg + 1;
          if (iLineFlg = 256) then
            begin
              if (MSX_VDT_REG_IE1 = 1) then
                begin
                  iLineDsp := MSX_VDT_REG[23] + iLine;
                  if (iLineDsp > 255) then iLineDsp := iLineDsp - 256;
                  if (iLineDsp = (MSX_VDT_REG[19] + 3)) then begin MSX_VDT_ST_REG_FH := 1; goto SpriteProc; end; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                end;
              iLineFlg := 0;
              iLine := iLine + 1;
              L1 := Go_M_Table65536[Gi_MSX_Graphic_Page];
              L2 := Go_M_Table256[MSX_VDT_REG[23] + iLine];
              L := L1 + L2; Lx := L1 + 65535;
              if (L > Lx) then L := L - 65536;
            end;
        end;
    end
  else
    begin
      for i := 0 to Lt do
        begin
          if (MSX_VDT_REG_LN = 0) then
            vdtBuffer32[i] := 0
          else
            vdtBuffer32p[i] := 0
          ;
        end;
    end;

SpriteProc:
  MSX_SPRITE_2_DISP(MSX_VDT_REG_LN);

  if (MSX_VDT_REG_LN = 0) then
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(192 * 3.6), 0, 0, 256, 192, @vdtBuffer32, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end
  else
    begin
      StretchDIBits(MSX2Frm.ScrnMSX.Canvas.Handle, 11, 12, Trunc(256 * 3.68), Trunc(212 * 3.25), 0, 0, 256, 212, @vdtBuffer32p, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
      MSX2Frm.ScrnMSX.Refresh;
    end;
end;

end.

