unit msxVDT_SPRITE;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math;

//var
  procedure MSX_SPRITE_DISP;
  procedure MSX_SPRITE_2_DISP(iLn: ShortInt);

implementation

uses
  msxMSX, msxZ80A, msxVDT, msxVDT_OUT, msxTBL;

//소프라이트
procedure MSX_SPRITE_DISP;
var
  i, j, k, M: ShortInt; L: LongInt;
  V: LongInt; b: Byte; P, Ps, sf: LongInt;
  Sy, Sx: LongInt; Sc: Byte; FC: SmallInt; EC: ShortInt; Xp: LongInt;
  Vpm: Array[0..4-1] Of LongInt;
  Syy: Array[0..4-1] Of LongInt;
  Sxx: Array[0..4-1] Of LongInt;
label
  SkipProc;
begin
  Go_MSX_SPR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[6] And 7];  //R6:(?????AAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
  Go_MSX_SPR_ATRB_ADDR := Go_M_Table128[MSX_VDT_REG[5] And 127]; //R5:(?AAAAAAA)+0000000, 0080h / 0~31(4Byte) - Y좌표(0~255),X좌표(0~255),패턴번호(0~255),A(EC)000AAAA(Color)

  MSX_VDT_REG_SZ := IfThen((MSX_VDT_REG[1] And 2) = 0, 0, 1); //R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
  MSX_VDT_REG_SM := IfThen((MSX_VDT_REG[1] And 1) = 0, 0, 1); //R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
  MSX_VDT_ST_REG_C := 0; //1:소프라이트 충돌

  for L := 0 to (49152 - 1) do vdtBufferSpr[L] := -1;

  for i := 0 to 31 do
    begin
      V := Go_MSX_SPR_ATRB_ADDR + Gi_M_Table4[i];
      Sy := MSX_VRAM[V]; //Y좌표0~255
      Sx := MSX_VRAM[V + 1]; //X좌표0~255
      if (Sy = $D0) then goto SkipProc; //이후표시안함[D0h,208]
      Sc := MSX_VRAM[V + 2]; //패턴번호8Byte0~255
      FC := MSX_VRAM[V + 3];
      EC := IfThen((FC And 128) = 0, 0, 1); //EC
      FC := (FC And 15); //색상0~15
      if (Sy = 255) then begin Sy := 0; end else begin Sy := Sy + 1; end;
      if (EC = 1) then Sx := Sx - 32;
      Syy[0] := Sy; Sxx[0] := Sx; Vpm[0] := Go_M_Table256[Syy[0]] + Sxx[0]; //256*192
      Syy[1] := Sy + 8; Sxx[1] := Sx; Vpm[1] := Go_M_Table256[Syy[1]] + Sxx[1];
      Syy[2] := Sy; Sxx[2] := Sx + 8; Vpm[2] := Go_M_Table256[Syy[2]] + Sxx[2];
      Syy[3] := Sy + 8; Sxx[3] := Sx + 8; Vpm[3] := Go_M_Table256[Syy[3]] + Sxx[3];
      P := Vpm[0];
      if (MSX_VDT_REG_SZ = 0) then //8*8
        begin
          sf := Go_MSX_SPR_FONT_ADDR + Gi_M_Table8[Sc];
          for j := 0 to 7 do //8Byte
            begin
              b := MSX_VRAM[sf + j];
              for k := 1 to 8 do //8Bit
                begin
                  if ((b And Gi_B_Table[8 - k]) > 0) then //[1]
                    begin
                    //If (MSX_VDT_REG_SM = 0) Then //정상
                      Xp := Sxx[0] + k - 1;
                      if ((Xp >= 0) And (Xp <= 255)) then //좌우표시범위이내확인
                        begin
                          Ps := P + k - 1;
                          if (Ps > 65535) then Ps := Ps - 65536;
                          if ((Ps >= 0) And (Ps <= 49151)) then
                            begin
                              if (vdtBufferSpr[Ps] = -1) then
                                begin
                                  vdtBufferSpr[Ps] := IfThen(FC = 0, -2, FC);
                                end
                              else
                                begin
                                  if (vdtBufferSpr[Ps] = -2) then vdtBufferSpr[Ps] := IfThen(FC = 0, -2, FC);
                                  MSX_VDT_ST_REG_C := 1;
                                end;
                            end;
                        end;
                    //Else //확대

                    //End If
                    end;
                end;
                P := P + 256; //1Line256Dot
            end;
        end
      else //16*16
        begin
          Sc := Gi_Spr_TableStart[Sc]; //첫번째위치
          for M := 0 to 3 do //8Byte*4
            begin
              sf := Go_MSX_SPR_FONT_ADDR + Gi_M_Table8[Sc + M];
              if (M = 0) then P := Vpm[0];
              if (M = 1) then P := Vpm[1];
              if (M = 2) then P := Vpm[2];
              if (M = 3) then P := Vpm[3];
              for j := 0 to 7 do //8Byte
                begin
                  b := MSX_VRAM[sf + j];
                  for k := 1 to 8 do //8Bit
                    begin
                      if ((b And Gi_B_Table[8 - k]) > 0) then //[1]
                        begin
                        //If (MSX_VDT_REG_SM = 0) Then //정상
                          Xp := Sxx[M] + k - 1;
                          if ((Xp >= 0) And (Xp <= 255)) then //좌우표시범위이내확인
                            begin
                              Ps := P + k - 1;
                              if (Ps > 65535) then Ps := Ps - 65536;
                              if ((Ps >= 0) And (Ps <= 49151)) then
                                begin
                                  if (vdtBufferSpr[Ps] = -1) then
                                    begin
                                      vdtBufferSpr[Ps] := IfThen(FC = 0, -2, FC);
                                    end
                                  else
                                    begin
                                      if (vdtBufferSpr[Ps] = -2) then vdtBufferSpr[Ps] := IfThen(FC = 0, -2, FC);
                                      MSX_VDT_ST_REG_C := 1;
                                    end;
                                end;
                            end;
                        //Else //확대

                        //End If
                        end;
                    end;
                  P := P + 256; //1Line256Dot
                end;
            end;
        end;
    end;

SkipProc:
  for L := 0 to (49152 - 1) do
  begin
    if (vdtBufferSpr[L] >= 0) then vdtBuffer32[L] := Go_MSX_Color[vdtBufferSpr[L]];
  end;

end;

//소프라이트2 (MSX2)
procedure MSX_SPRITE_2_DISP(iLn: ShortInt);
var
  i, j, k, M: ShortInt; L, L2: LongInt;
  V, V2: LongInt; b: Byte; P, Ps, sf: LongInt;
  Sy, Sx: LongInt; Sc: Byte; FC: SmallInt; C: LongInt;
  EC: ShortInt; Cc, IC: ShortInt; Xp: LongInt;
  Vpm: Array[0..4-1] Of LongInt;
  Syy: Array[0..4-1] Of LongInt;
  Sxx: Array[0..4-1] Of LongInt;
label
  SkipProc, ExitProc;
begin
  if (MSX_VDT_REG_SPD = 1) then goto ExitProc;

  Go_MSX_SPR_FONT_ADDR := Go_M_Table2048[MSX_VDT_REG[6] And 63]; //R6: (??AAAAAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
  //R11: 000000+(A16,A15), R5: (A14~A10)+1xx
  Go_MSX_SPR_ATRB_ADDR := goGetIntHLToLng((MSX_VDT_REG[11] And 3), (MSX_VDT_REG[5] And $FC));
  Go_MSX_SPR_ATRB_ADDR := Go_M_Table128[Go_MSX_SPR_ATRB_ADDR];
  Go_MSX_SPR_COLR_ADDR := Go_MSX_SPR_ATRB_ADDR - 512; //200h
  if (Go_MSX_SPR_COLR_ADDR < 0) then Go_MSX_SPR_COLR_ADDR := 0;

  MSX_VDT_REG_SZ := IfThen((MSX_VDT_REG[1] And 2) = 0, 0, 1); //R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
  MSX_VDT_REG_SM := IfThen((MSX_VDT_REG[1] And 1) = 0, 0, 1); //R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
  MSX_VDT_ST_REG_C := 0; //1:소프라이트 충돌

  for L := 0 to (54272 - 1) do vdtBufferSpr2[L] := -1; //256*212

  for i := 0 to 31 do
    begin
      V := Go_MSX_SPR_ATRB_ADDR + Gi_M_Table4[i]; //어트리뷰트테이블
      Sy := MSX_VRAM[V]; //Y좌표0~255
      Sx := MSX_VRAM[V + 1]; //X좌표0~255
      if (Sy = $D8) then goto SkipProc; //이후표시안함[D8h,216]
      Sy := Sy - MSX_VDT_REG[23]; if (Sy < 0) then Sy := Sy + 256; //스크롤반영
      Sc := MSX_VRAM[V + 2]; //패턴번호8Byte0~255
      V2 := Go_MSX_SPR_COLR_ADDR + Gi_M_Table16[i]; //칼라테이블
      FC := MSX_VRAM[V2];
      EC := IfThen((FC And 128) = 0, 0, 1); //EC - 1:Shift Left
      if (Sy = 255) then begin Sy := 0; end else begin Sy := Sy + 1; end;
      if (EC = 1) then Sx := Sx - 32;
      Syy[0] := Sy; Sxx[0] := Sx; Vpm[0] := Go_M_Table256[Syy[0]] + Sxx[0]; //256*212
      Syy[1] := Sy + 8; Sxx[1] := Sx; Vpm[1] := Go_M_Table256[Syy[1]] + Sxx[1];
      Syy[2] := Sy; Sxx[2] := Sx + 8; Vpm[2] := Go_M_Table256[Syy[2]] + Sxx[2];
      Syy[3] := Sy + 8; Sxx[3] := Sx + 8; Vpm[3] := Go_M_Table256[Syy[3]] + Sxx[3];
      P := Vpm[0];
      if (MSX_VDT_REG_SZ = 0) then //8*8
        begin
          sf := Go_MSX_SPR_FONT_ADDR + Gi_M_Table8[Sc]; //패턴테이블
          for j := 0 to 7 do //8Byte
            begin
              FC := MSX_VRAM[V2 + j]; //칼라테이블
              Cc := IfThen((FC And 64) = 0, 0, 1); //CC - 1:동일우선순위,Or칼라,충돌없음
              IC := IfThen((FC And 32) = 0, 0, 1); //IC - 1:충돌확인안함
              FC := (FC And 15); //색상0~15
              b := MSX_VRAM[sf + j]; //캐릭터
              for k := 1 to 8 do //8Bit
                begin
                  if ((b And Gi_B_Table[8 - k]) > 0) then //[1]
                    begin
                      //If (MSX_VDT_REG_SM = 0) Then //정상
                      Xp := Sxx[0] + k - 1;
                      if ((Xp >= 0) And (Xp <= 255)) then //좌우표시범위이내확인
                        begin
                          Ps := P + k - 1;
                          if (Ps > 65535) then Ps := Ps - 65536;
                          if ((Ps >= 0) And (Ps <= 54271)) then
                            begin
                              if (vdtBufferSpr2[Ps] = -1) then
                                begin
                                  vdtBufferSpr2[Ps] := IfThen((MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC);
                                end
                              else
                                begin
                                  if (vdtBufferSpr2[Ps] = -2) then
                                    begin
                                      vdtBufferSpr2[Ps] := IfThen((MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC);
                                    end
                                  else
                                    begin
                                      if (Not((MSX_VDT_REG_TP = 0) And (FC = 0))) then
                                        begin
                                          if (Cc = 1) then //Or-Color
                                            begin
                                              if (vdtBufferSpr2[Ps] < 0) then vdtBufferSpr2[Ps] := 0;
                                              vdtBufferSpr2[Ps] := (vdtBufferSpr2[Ps] OR FC); //소프라이트 색상 겹치는부분 OR 연산
                                            end;
                                        end;
                                    end;
                                  if ((Cc = 0) And (IC = 0)) then MSX_VDT_ST_REG_C := 1;
                                end;
                            end;
                        end;
                      //Else //확대

                      //End If
                    end;
                end;
              P := P + 256; //1Line256Dot
            end;
        end
      else //16*16
        begin
          Sc := Gi_Spr_TableStart[Sc]; //첫번째위치
          for M := 0 to 3 do //8Byte*4
            begin
              sf := Go_MSX_SPR_FONT_ADDR + Gi_M_Table8[Sc + M]; //패턴테이블
              if (M = 0) then P := Vpm[0];
              if (M = 1) then P := Vpm[1];
              if (M = 2) then P := Vpm[2];
              if (M = 3) then P := Vpm[3];
              for j := 0 to 7 do //8Byte
                begin
                  FC := MSX_VRAM[V2 + IfThen((M = 1) OR (M = 3), 8, 0) + j]; //칼라테이블
                  Cc := IfThen((FC And 64) = 0, 0, 1); //CC - 1:동일우선순위,Or칼라,충돌없음
                  IC := IfThen((FC And 32) = 0, 0, 1); //IC - 1:충돌확인안함
                  FC := (FC And 15); //색상0~15
                  b := MSX_VRAM[sf + j]; //캐릭터
                  for k := 1 to 8 do //8Bit
                    begin
                      if ((b And Gi_B_Table[8 - k]) > 0) then //[1]
                        begin
                          //If (MSX_VDT_REG_SM = 0) Then //정상
                          Xp := Sxx[M] + k - 1;
                          if ((Xp >= 0) And (Xp <= 255)) then //좌우표시범위이내확인
                            begin
                              Ps := P + k - 1;
                              if (Ps > 65535) then Ps := Ps - 65536;
                              if ((Ps >= 0) And (Ps <= 54271)) then
                                begin
                                  if (vdtBufferSpr2[Ps] = -1) then
                                    begin
                                      vdtBufferSpr2[Ps] := IfThen((MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC);
                                    end
                                  else
                                    begin
                                      if (vdtBufferSpr2[Ps] = -2) then
                                        begin
                                          vdtBufferSpr2[Ps] := IfThen((MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC);
                                        end
                                      else
                                        begin
                                          if (Not((MSX_VDT_REG_TP = 0) And (FC = 0))) then
                                            begin
                                              if (Cc = 1) then //Or-Color
                                                begin
                                                  if (vdtBufferSpr2[Ps] < 0) then vdtBufferSpr2[Ps] := 0;
                                                  vdtBufferSpr2[Ps] := (vdtBufferSpr2[Ps] OR FC); //소프라이트 색상 겹치는부분 OR 연산
                                                end;
                                            end;
                                        end;
                                      if ((Cc = 0) And (IC = 0)) then MSX_VDT_ST_REG_C := 1;
                                    end;
                                end;
                            end;
                          //Else //확대

                          //End If
                        end;
                    end;
                  P := P + 256; //1Line256Dot
                end;
            end;
        end;
    end;

SkipProc:
  //256*192/256*212
  if ((Gi_MSX_SCREEN_MODE = 4) OR (Gi_MSX_SCREEN_MODE = 5)) then
    begin
      if (iLn = 0) then
        begin
          for L := 0 to (49152 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color[vdtBufferSpr2[L]];
                  vdtBuffer32[L] := C;
                end;
            end;
        end
      else
        begin
          for L := 0 to (54272 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color[vdtBufferSpr2[L]];
                  vdtBuffer32p[L] := C;
                end;
            end;
        end;
    end;

  //256*192/256*212
  if (Gi_MSX_SCREEN_MODE = 8) then
    begin
      if (iLn = 0) then
        begin
          for L := 0 to (49152 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color_G7[vdtBufferSpr2[L]];
                  vdtBuffer32[L] := C;
                end;
            end;
        end
      else
        begin
          for L := 0 to (54272 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color_G7[vdtBufferSpr2[L]];
                  vdtBuffer32p[L] := C;
                end;
            end;
        end;
    end;

  //512*192/512*212
  if ((Gi_MSX_SCREEN_MODE = 6) OR (Gi_MSX_SCREEN_MODE = 7)) then
    begin
      L2 := 0;
      if (iLn = 0) then
        begin
          for L := 0 to (49152 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color[vdtBufferSpr2[L]];
                  vdtBuffer80[L2] := C; L2 := L2 + 1;
                  vdtBuffer80[L2] := C;
                end;
            end;
        end
      else
        begin
          for L := 0 to (54272 - 1) do
            begin
              if (vdtBufferSpr2[L] >= 0) then
                begin
                  C := Go_MSX_Color[vdtBufferSpr2[L]];
                  vdtBuffer80p[L2] := C; L2 := L2 + 1;
                  vdtBuffer80p[L2] := C;
                end;
            end;
        end;
    end;

ExitProc:
end;

end.

