unit msxZ80A_Asm;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils;

const
  Gi_Label_Tot: Integer = 10000;
  Gi_B_Table_0: SmallInt = 1;
  Gi_B_Table_1: SmallInt = 2;
  Gi_B_Table_2: SmallInt = 4;
  Gi_B_Table_3: SmallInt = 8;
  Gi_B_Table_4: SmallInt = 16;
  Gi_B_Table_5: SmallInt = 32;
  Gi_B_Table_6: SmallInt = 64;
  Gi_B_Table_7: SmallInt = 128;

var
  Gi_MSX_SLOT: Integer; //0:[기본],1:[0슬롯],2:[1슬롯];3:[2슬롯],4:[3슬롯],5:[VRAM]
  Gi_Z80A_Asm: Integer; //0:Pass1, 1:Pass2
  GsDspMessage: String;

  //프로그램 카운터(16) - 어셈블용
  Z80A_REG_PC_Asm: LongInt;

  GsASM1, GsASM2, GsASM3, GsASM4, GsASM5, GsASMx: String;

  GsASM_Wrt_Label: Array[0..10000] Of String; //Gi_Label_Tot
  GsASM_Wrt_Addr: Array[0..10000] Of LongInt; //Gi_Label_Tot

  GsASM_Label: String;
  GoASM_Addr: LongInt;
  GsASM_Data: String;
  GiASM_PC_Add: Integer;

  GsGetTxtSeparate: Array[0..1000] Of String;

  GsGetLngToHex16_Cry: String;
  Go_MSX_DisASM_ADR_Ref: LongInt;

  function gs_Z80A_ASM_CODE: String;
  procedure ft_ASM_TEXT_ADD(sCmd: String);
  function fs_ASM_IXY_INDEX(sCmd: String; var DdFd: String; var iVal: Integer): String;
  function gs_Z80A_ASM_ORG: String;
  function gs_Z80A_ASM_EQU: String;
  function gs_Z80A_ASM_LABEL: String;
  function gs_Z80A_ASM_DEFB: String;
  function gs_Z80A_ASM_DEFW: String;
  function gs_Z80A_ASM_DEFM: String;
  function gs_Z80A_ASM_DEFS: String;
  function gs_Z80A_ASM_END: String;
  function gs_Z80A_ASM_Label_Write(sLabel: String;  oAddr: LongInt): String;
  function gs_Z80A_ASM_Label_Read(sLabel: String; var oAddr: LongInt): String;
  function gtLabelConvert(sVal: String; var sVal2: String; iSel: ShortInt = 0): String;
  function gtWordConvert(sVal: String; var oVal: LongInt): String;
  function gtByteConvert(sVal: String; var iVal: Integer): String;
  function gtGetStringCompute(sVal: String; var oVal: LongInt): String;
  function giGetTxtSeparate(sStr: String): Integer;
  function gsGetStringHex4(sVal: String): String;
  function gsGetStringHex2(sVal: String): String;
  function gsGetLngToHex16_Disp(oVal: LongInt): String;
  function goGetLngToLng(oVal: LongInt): LongInt;
  function giGetIntToInt(iVal: Integer): Integer;
  function goGetIntHLToLng(iValH: Integer; iValL: Integer): LongInt;
  procedure gtMoveLngToIntHL(oVal: LongInt; var iValH: Integer; var iValL: Integer);
  function giGetLngToIntH(oVal: LongInt): Integer;
  function giGetLngToIntL(oVal: LongInt): Integer;
  function gsGetBin8ToHex8(sVal: String): String;
  function gsGetLngToHex16(oVal: LongInt): String;
  function gsGetLngToHex8(oVal: LongInt): String;
  function goGetHex16ToLng(sVal: String): LongInt;
  function giGetHex8ToInt(sVal: String): Integer;
  function giGetBin8ToInt(sBin: String; iSel: ShortInt = 0): Integer;
  function giGetBin4ToInt(sBin: String; iSel: ShortInt = 0): Integer;
  function giGetBin3ToInt(sBin: String; iSel: ShortInt = 0): Integer;
  function giGetBin2ToInt(sBin: String; iSel: ShortInt = 0): Integer;
  function gsGetIntToBin8(iVal: Integer): String;
  procedure gtSwap16(var oVal1: LongInt; var oVal2: LongInt);
  procedure gtSwap8(var iVal1: Integer; var iVal2: Integer);

implementation

uses
  untFunction;

function gs_Z80A_ASM_CODE(): String;
var
  R: String;
  S: String;
  iVal: Integer = 0; iVal2: Integer = 0; oVal: LongInt = 0;
  Ccc, Xxx1, Xxx2, Xxx3: String; DdFd: String = '';
  Mem1: LongInt = 0; Mem2: LongInt = 0;
  bXx1, bXx2, bXx3, bXx4: String;
label
  LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  // 레지스트리 검색을 입력값 보다 우선검색, 순서 바뀌면 레지스트리를 레이블로 검색 가능 //

  //-- LD ?,? --------------------------------------------------
  if (gsASM1 = 'LD') then
    begin

      //LD ? -> LD A,?
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM3 := gsASM2;
          gsASM2 := 'A,';
        end;

      //LD ?,?
      if (gmsTrim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          //- LD n,n (8 Bit) -
          Xxx1 := '';
          if (gsASM2 = 'B,') then Xxx1 := '000';
          if (gsASM2 = 'C,') then Xxx1 := '001';
          if (gsASM2 = 'D,') then Xxx1 := '010';
          if (gsASM2 = 'E,') then Xxx1 := '011';
          if (gsASM2 = 'H,') then Xxx1 := '100';
          if (gsASM2 = 'L,') then Xxx1 := '101';
          if (gsASM2 = '(HL),') then Xxx1 := '110';
          if (gsASM2 = 'A,') then Xxx1 := '111';
          Xxx2 := '';
          if (gsASM3 = 'B') then Xxx2 := '000';
          if (gsASM3 = 'C') then Xxx2 := '001';
          if (gsASM3 = 'D') then Xxx2 := '010';
          if (gsASM3 = 'E') then Xxx2 := '011';
          if (gsASM3 = 'H') then Xxx2 := '100';
          if (gsASM3 = 'L') then Xxx2 := '101';
          if (gsASM3 = '(HL)') then Xxx2 := '110';
          if (gsASM3 = 'A') then Xxx2 := '111';
          bXx1 := Xxx1;
          bXx2 := Xxx2;

          //LD r,r (8 Bit)
          if ((Xxx1 <> '') And (Xxx2 <> '')) then
            begin
              if (Not ((Xxx1 = '110') And (Xxx2 = '110'))) then
                begin
                  ft_ASM_TEXT_ADD(gsGetBin8ToHex8('01' + Xxx1 + Xxx2)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD (IX/IY+-n),r/n (8 Bit)
          if (((gmsLeft(gsASM2, 3) = '(IX') Or (gmsLeft(gsASM2, 3) = '(IY')) And (gmsRight(gsASM2, 2) = '),')) then //(IX/IY+-n)
            begin
              R := fs_ASM_IXY_INDEX(gmsLeft(gsASM2, gmiLen(gsASM2) - 1), DdFd, iVal); if (R <> '') then goto LastProc;
              if (gmsLeft(gsASM2, 3) = '(IX') then DdFd := 'DD' else DdFd := 'FD'; //LD (IX[Y]+d),r/n
              if ((Xxx2 <> '') And (Xxx2 <> '110')) then //,r
                begin
                  ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('01' + '110' + Xxx2) + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (Xxx2 = '') then //,n
                begin
                  R := gtByteConvert(gsASM3, iVal2); if (R <> '') then goto LastProc;
                  ft_ASM_TEXT_ADD(DdFd + '36' + gsGetLngToHex8(iVal) + gsGetLngToHex8(iVal2)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD r,(IX/IY+-n) (8 Bit)
          if (((gmsLeft(gsASM3, 3) = '(IX') Or (gmsLeft(gsASM3, 3) = '(IY')) And (gmsRight(gsASM3, 1) = ')')) then //(IX/IY+-n)
            begin
              R := fs_ASM_IXY_INDEX(gsASM3, DdFd, iVal); if (R <> '') then goto LastProc;
              if (gmsLeft(gsASM3, 3) = '(IX') then DdFd := 'DD' else DdFd := 'FD'; //LD r,(IX[Y]+d)
              if ((Xxx1 <> '') And (Xxx1 <> '110')) then //r,
                begin
                  ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('01' + Xxx1 + '110') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD A,? (8 Bit)
          if (gsASM2 = 'A,') then
            begin
              if (gsASM3 = '(BC)') then
                begin
                  ft_ASM_TEXT_ADD('0A'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM3 = '(DE)') then
                begin
                  ft_ASM_TEXT_ADD('1A'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gmsLeft(gsASM3, 1) = '(') And (gmsRight(gsASM3, 1) = ')')) then //LD A,(nn)
                begin
                  R := gtWordConvert(gmsMid(gsASM3, 2, gmiLen(gsASM3) - 2), Mem2); if (R <> '') then goto LastProc;
                  S := gsGetLngToHex16(Mem2);
                  ft_ASM_TEXT_ADD('3A' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM3 = 'I') then
                begin
                  ft_ASM_TEXT_ADD('ED' + '57'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM3 = 'R') then
                begin
                  ft_ASM_TEXT_ADD('ED' + '5F'); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD ?,A (8 Bit)
          if (gsASM3 = 'A') then
            begin
              if (gsASM2 = '(BC),') then
                begin
                  ft_ASM_TEXT_ADD('02'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM2 = '(DE),') then
                begin
                  ft_ASM_TEXT_ADD('12'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gmsLeft(gsASM2, 1) = '(') And (gmsRight(gsASM2, 2) = '),')) then //LD (nn),A
                begin
                  R := gtWordConvert(gmsMid(gsASM2, 2, gmiLen(gsASM2) - 2 - 1), Mem1); if (R <> '') then goto LastProc;
                  S := gsGetLngToHex16(Mem1);
                  ft_ASM_TEXT_ADD('32' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM2 = 'I,') then
                begin
                  ft_ASM_TEXT_ADD('ED' + '47'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM2 = 'R,') then
                begin
                  ft_ASM_TEXT_ADD('ED' + '4F'); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //- LD nn,nn (16 Bit) -
          Xxx1 := '';
          if (gsASM2 = 'BC,') then Xxx1 := '00';
          if (gsASM2 = 'DE,') then Xxx1 := '01';
          if (gsASM2 = 'HL,') then Xxx1 := '10';
          if (gsASM2 = 'SP,') then Xxx1 := '11';
          Xxx2 := '';
          if (gsASM3 = 'BC') then Xxx2 := '00';
          if (gsASM3 = 'DE') then Xxx2 := '01';
          if (gsASM3 = 'HL') then Xxx2 := '10';
          if (gsASM3 = 'SP') then Xxx2 := '11';
          bXx3 := Xxx1;
          bXx4 := Xxx2;

          //LD SP,rr (16 Bit)
          if (gsASM2 = 'SP,') then
            begin
              if (gsASM3 = 'HL') then
                begin
                  ft_ASM_TEXT_ADD('F9'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM3 = 'IX') then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'F9'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (gsASM3 = 'IY') then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'F9'); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD r,IXH/IXL (8 Bit)
          if ((gsASM2 = 'B,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '44'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'B,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '45'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'C,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '4C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'C,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '4D'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'D,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '54'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'D,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '55'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'E,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '5C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'E,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '5D'); //-- TEXT ADD --
              goto LastProc;
            end;

          //LD IXH/IXL,r (8 Bit)
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'B')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '60'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'C')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '61'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'D')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '62'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'E')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '63'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '64'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '65'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXH,') And (gsASM3 = 'A')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '67'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'B')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '68'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'C')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '69'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'D')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '6A'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'E')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '6B'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '6C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '6D'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IXL,') And (gsASM3 = 'A')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '6F'); //-- TEXT ADD --
              goto LastProc;
            end;

          //LD A,IXH/IXL (8 Bit)
          if ((gsASM2 = 'A,') And (gsASM3 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '7C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'A,') And (gsASM3 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '7D'); //-- TEXT ADD --
              goto LastProc;
            end;

          //LD r,IYH/IYL (8 Bit)
          if ((gsASM2 = 'B,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '44'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'B,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '45'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'C,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '4C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'C,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '4D'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'D,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '54'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'D,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '55'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'E,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '5C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'E,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '5D'); //-- TEXT ADD --
              goto LastProc;
            end;

          //LD IYH/IYL,r (8 Bit)
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'B')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '60'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'C')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '61'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'D')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '62'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'E')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '63'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '64'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '65'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYH,') And (gsASM3 = 'A')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '67'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'B')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '68'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'C')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '69'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'D')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '6A'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'E')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '6B'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '6C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '6D'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IYL,') And (gsASM3 = 'A')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '6F'); //-- TEXT ADD --
              goto LastProc;
            end;

          //LD A,IYH/IYL (8 Bit)
          if ((gsASM2 = 'A,') And (gsASM3 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '7C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'A,') And (gsASM3 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '7D'); //-- TEXT ADD --
              goto LastProc;
            end;

          Xxx1 := bXx1;
          Xxx2 := bXx2;
          //LD r,n (8 Bit)
          if (Xxx1 <> '') then
            begin
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '110') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;

          Xxx1 := bXx3;
          Xxx2 := bXx4;
          //LD rr,(nn) (16 Bit)
          if ((gmsLeft(gsASM3, 1) = '(') And (gmsRight(gsASM3, 1) = ')')) then
            begin
              R := gtWordConvert(gmsMid(gsASM3, 2, gmiLen(gsASM3) - 2), Mem2); if (R <> '') then goto LastProc;
              S := gsGetLngToHex16(Mem2);
              if (gsASM2 = 'HL,') then //LD HL,(nn)
                begin
                  ft_ASM_TEXT_ADD('2A' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (Xxx1 <> '') then //LD rr,(nn)
                begin
                  ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx1 + '1011') + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM2 = 'IX,') Or (gsASM2 = 'IY,')) then //LD IX/IY,(nn)
                begin
                  if (gmsLeft(gsASM2, 2) = 'IX') then DdFd := 'DD' else DdFd := 'FD';
                  ft_ASM_TEXT_ADD(DdFd + '2A' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD (nn),rr (16 Bit)
          if ((gmsLeft(gsASM2, 1) = '(') And (gmsRight(gsASM2, 2) = '),')) then
            begin
              R := gtWordConvert(gmsMid(gsASM2, 2, gmiLen(gsASM2) - 2 - 1), Mem1); if (R <> '') then goto LastProc;
              S := gsGetLngToHex16(Mem1);
              if (gsASM3 = 'HL') then //LD (nn),HL
                begin
                  ft_ASM_TEXT_ADD('22' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if (Xxx2 <> '') then //LD (nn),rr
                begin
                  ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx2 + '0011') + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM3 = 'IX') Or (gsASM3 = 'IY')) then //LD (nn),IX/IY
                begin
                  if (gsASM3 = 'IX') then DdFd := 'DD' else DdFd := 'FD';
                  ft_ASM_TEXT_ADD(DdFd + '22' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD rr,nn (16 Bit)
          if ((Xxx1 <> '') Or (gsASM2 = 'IX,') Or (gsASM2 = 'IY,')) then
            begin
              R := gtWordConvert(gsASM3, Mem2); if (R <> '') then goto LastProc;
              S := gsGetLngToHex16(Mem2);
              if (Xxx1 <> '') then //LD rr,nn
                begin
                  ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '0001') + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM2 = 'IX,') Or (gsASM2 = 'IY,')) then //LD IX/IY,nn
                begin
                  if (gmsLeft(gsASM2, 2) = 'IX') then DdFd := 'DD' else DdFd := 'FD';
                  ft_ASM_TEXT_ADD(DdFd + '21' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //LD IXH/IXL,n (8 Bit)
          if (gsASM2 = 'IXH,') then
            begin
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD('DD' + '26' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;
          if (gsASM2 = 'IXL,') then
            begin
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD('DD' + '2E' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;

         //LD IYH/IYL,n (8 Bit)
          if (gsASM2 = 'IYH,') then
            begin
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD('FD' + '26' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;
          if (gsASM2 = 'IYL,') then
            begin
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD('FD' + '2E' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (LD) !'; goto LastProc;
    end;

  //-- ADD/ADC/SUB/SBC/AND/OR/XOR/CP ? --------------------------------------------------
  if ((gsASM1 = 'ADD') Or (gsASM1 = 'ADC') Or (gsASM1 = 'SUB') Or (gsASM1 = 'SBC') Or (gsASM1 = 'AND') Or (gsASM1 = 'OR') Or (gsASM1 = 'XOR') Or (gsASM1 = 'CP')) then
    begin

      //CMD ? -> CMD A,?
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM3 := gsASM2;
          gsASM2 := 'A,';
        end;

      //CMD ?,?
      if (gmsTrim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Ccc := '';
          if (gsASM1 = 'ADD') then Ccc := '000';
          if (gsASM1 = 'ADC') then Ccc := '001';
          if (gsASM1 = 'SUB') then Ccc := '010';
          if (gsASM1 = 'SBC') then Ccc := '011';
          if (gsASM1 = 'AND') then Ccc := '100';
          if (gsASM1 = 'OR') then Ccc := '110';
          if (gsASM1 = 'XOR') then Ccc := '101';
          if (gsASM1 = 'CP') then Ccc := '111';

          //- CMD A,? (8 Bit) -
          if (gsASM2 = 'A,') then
            begin
              Xxx2 := '';
              if (gsASM3 = 'B') then Xxx2 := '000';
              if (gsASM3 = 'C') then Xxx2 := '001';
              if (gsASM3 = 'D') then Xxx2 := '010';
              if (gsASM3 = 'E') then Xxx2 := '011';
              if (gsASM3 = 'H') then Xxx2 := '100';
              if (gsASM3 = 'L') then Xxx2 := '101';
              if (gsASM3 = '(HL)') then Xxx2 := '110';
              if (gsASM3 = 'A') then Xxx2 := '111';
              //CMD A,r (8 Bit)
              if (Xxx2 <> '') then
                begin
                  ft_ASM_TEXT_ADD(gsGetBin8ToHex8('10' + Ccc + Xxx2)); //-- TEXT ADD --
                  goto LastProc;
                end;
             //CMD A,(IX/IY+-n) (8 Bit)
              if (((gmsLeft(gsASM3, 3) = '(IX') Or (gmsLeft(gsASM3, 3) = '(IY')) And (gmsRight(gsASM3, 1) = ')')) then //(IX/IY+-n)
                begin
                  R := fs_ASM_IXY_INDEX(gsASM3, DdFd, iVal); if (R <> '') then goto LastProc;
                  ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('10' + Ccc + '110') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;

             //CMD A,IXH/IXL/IYH/IYL (8 Bit)
              if ((gsASM1 = 'ADD') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '84'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADD') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '85'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADC') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '8C'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADC') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '8D'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SUB') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '94'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SUB') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '95'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SBC') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '9C'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SBC') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + '9D'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'AND') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'A4'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'AND') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'A5'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'XOR') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'AC'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'XOR') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'AD'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'OR') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'B4'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'OR') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'B5'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'CP') And (gsASM3 = 'IXH')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'BC'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'CP') And (gsASM3 = 'IXL')) then
                begin
                  ft_ASM_TEXT_ADD('DD' + 'BD'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADD') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '84'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADD') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '85'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADC') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '8C'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'ADC') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '8D'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SUB') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '94'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SUB') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '95'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SBC') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '9C'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'SBC') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + '9D'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'AND') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'A4'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'AND') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'A5'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'XOR') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'AC'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'XOR') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'AD'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'OR') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'B4'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'OR') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'B5'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'CP') And (gsASM3 = 'IYH')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'BC'); //-- TEXT ADD --
                  goto LastProc;
                end;
              if ((gsASM1 = 'CP') And (gsASM3 = 'IYL')) then
                begin
                  ft_ASM_TEXT_ADD('FD' + 'BD'); //-- TEXT ADD --
                  goto LastProc;
                end;

              //CMD A,n (8 Bit)
              R := gtByteConvert(gsASM3, iVal); if (R <> '') then goto LastProc;
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Ccc + '110') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;

          //- CMD HL,rr (16 Bit) -
          if (gsASM2 = 'HL,') then
            begin
              Xxx2 := '';
              if (gsASM3 = 'BC') then Xxx2 := '00';
              if (gsASM3 = 'DE') then Xxx2 := '01';
              if (gsASM3 = 'HL') then Xxx2 := '10';
              if (gsASM3 = 'SP') then Xxx2 := '11';
              if (Xxx2 <> '') then
                begin
                  if (gsASM1 = 'ADD') then //ADD HL,nn
                    begin
                      ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx2 + '1001')); //-- TEXT ADD --
                      goto LastProc;
                    end;
                  if (gsASM1 = 'ADC') then //ADC HL,nn
                    begin
                      ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx2 + '1010')); //-- TEXT ADD --
                      goto LastProc;
                    end;
                  if (gsASM1 = 'SBC') then //SBC HL,nn
                    begin
                      ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx2 + '0010')); //-- TEXT ADD --
                      goto LastProc;
                    end;
                end;
            end;

         //CMD IX/IY,rr (16 Bit)
          if ((gsASM2 = 'IX,') Or (gsASM2 = 'IY,')) then
            begin
              if (gmsLeft(gsASM2, 2) = 'IX') then DdFd := 'DD' else DdFd := 'FD';
              Xxx2 := '';
              if (gsASM3 = 'BC') then Xxx2 := '00';
              if (gsASM3 = 'DE') then Xxx2 := '01';
              if (gsASM3 = gmsLeft(gsASM2, 2)) then Xxx2 := '10';
              if (gsASM3 = 'SP') then Xxx2 := '11';
              if (Xxx2 <> '') then
                begin
                  if (gsASM1 = 'ADD') then //ADD IX/IY,nn
                    begin
                      ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('00' + Xxx2 + '1001')); //-- TEXT ADD --
                      goto LastProc;
                    end;
                end;
            end;
        end;

      R := '## 구문 오류 (ADD/ADC/SUB/SBC/AND/OR/XOR/CP) !'; goto LastProc;
    end;

  //-- INC/DEC ? --------------------------------------------------
  if ((gsASM1 = 'INC') Or (gsASM1 = 'DEC')) then
    begin

      //INC/DEC -> INC/DEC A
      if (Trim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM2 := 'A';
        end;

      //INC/DEC r (8 Bit)
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = 'B') then Xxx1 := '000';
          if (gsASM2 = 'C') then Xxx1 := '001';
          if (gsASM2 = 'D') then Xxx1 := '010';
          if (gsASM2 = 'E') then Xxx1 := '011';
          if (gsASM2 = 'H') then Xxx1 := '100';
          if (gsASM2 = 'L') then Xxx1 := '101';
          if (gsASM2 = '(HL)') then Xxx1 := '110';
          if (gsASM2 = 'A') then Xxx1 := '111';
          if (Xxx1 <> '') then
            begin
              if (gsASM1 = 'INC') then //INC r
                ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '100')) //-- TEXT ADD --
              else //DEC r
               ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '101')) //-- TEXT ADD --
              ;
              goto LastProc;
            end;
          if (((gmsLeft(gsASM2, 3) = '(IX') Or (gmsLeft(gsASM2, 3) = '(IY')) And (gmsRight(gsASM2, 1) = ')')) then //(IX/IY+-n)
            begin
              R := fs_ASM_IXY_INDEX(gsASM2, DdFd, iVal); if (R <> '') then goto LastProc;
              if (gsASM1 = 'INC') then //INC (IX/IY+-n)
                begin
                  ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('00' + '110' + '100') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end
              else //DEC (IX/IY+-n)
                begin
                  ft_ASM_TEXT_ADD(DdFd + gsGetBin8ToHex8('00' + '110' + '101') + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;

          //INC/DEC rr (16 Bit)
          Xxx1 := '';
          if (gsASM2 = 'BC') then Xxx1 := '00';
          if (gsASM2 = 'DE') then Xxx1 := '01';
          if (gsASM2 = 'HL') then Xxx1 := '10';
          if (gsASM2 = 'SP') then Xxx1 := '11';
          if (Xxx1 <> '') then
            begin
              if (gsASM1 = 'INC') then //INC rr
                ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '0011')) //-- TEXT ADD --
              else //DEC rr
                ft_ASM_TEXT_ADD(gsGetBin8ToHex8('00' + Xxx1 + '1011')) //-- TEXT ADD --
              ;
              goto LastProc;
            end;
          if ((gsASM2 = 'IX') Or (gsASM2 = 'IY')) then
            begin
              if (gsASM2 = 'IX') then DdFd := 'DD' else DdFd := 'FD';
              if (gsASM1 = 'INC') then //INC IX/IY
                ft_ASM_TEXT_ADD(DdFd + '23') //-- TEXT ADD --
              else //DEC IX/IY
                ft_ASM_TEXT_ADD(DdFd + '2B') //-- TEXT ADD --
              ;
              goto LastProc;
            end;

          //INC/DEC IXH/IXL/IYH/IYL (8 Bit)
          if ((gsASM1 = 'INC') And (gsASM2 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '24'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'DEC') And (gsASM2 = 'IXH')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '25'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'INC') And (gsASM2 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '2C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'DEC') And (gsASM2 = 'IXL')) then
            begin
              ft_ASM_TEXT_ADD('DD' + '2D'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'INC') And (gsASM2 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '24'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'DEC') And (gsASM2 = 'IYH')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '25'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'INC') And (gsASM2 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '2C'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM1 = 'DEC') And (gsASM2 = 'IYL')) then
            begin
              ft_ASM_TEXT_ADD('FD' + '2D'); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (INC) !'; goto LastProc;
    end;

  //-- PUSH/POP ? --------------------------------------------------
  if ((gsASM1 = 'PUSH') Or (gsASM1 = 'POP')) then
    begin

     //PUSH/POP ?
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = 'BC') then Xxx1 := '00'; //PUSH/POP BC
          if (gsASM2 = 'DE') then Xxx1 := '01'; //PUSH/POP DE
          if (gsASM2 = 'HL') then Xxx1 := '10'; //PUSH/POP HL
          if (gsASM2 = 'AF') then Xxx1 := '11'; //PUSH/POP AF
          if (Xxx1 <> '') then
            begin
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Xxx1 + gmsIfThen(gsASM1 = 'PUSH', '0101', '0001'))); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'IX') Or (gsASM2 = 'IY')) then //PUSH/POP IX/IY
            begin
              if (gsASM2 = 'IX') then DdFd := 'DD' else DdFd := 'FD';
              ft_ASM_TEXT_ADD(DdFd + gmsIfThen(gsASM1 = 'PUSH', 'E5', 'E1')); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (PUSH/POP) !'; goto LastProc;
    end;

  //-- EX ?,? --------------------------------------------------
  if (gsASM1 = 'EX') then
    begin

      //EX ?,?
      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          if ((gsASM2 = 'DE,') And (gsASM3 = 'HL')) then //EX DE,HL
            begin
              ft_ASM_TEXT_ADD('EB'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = 'AF,') And ((gsASM3 = 'AF') Or (gsASM3 = 'AF`') Or (gsASM3 = 'AF2'))) then //EX AF,AF|AF`|AF2
            begin
              ft_ASM_TEXT_ADD('08'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = '(SP),') And (gsASM3 = 'HL')) then //EX (SP),HL
            begin
              ft_ASM_TEXT_ADD('E3'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = '(SP),') And (gsASM3 = 'IX')) then //EX (SP),IX
            begin
              ft_ASM_TEXT_ADD('DD' + 'E3'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = '(SP),') And (gsASM3 = 'IY')) then //EX (SP),IY
            begin
              ft_ASM_TEXT_ADD('FD' + 'E3'); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (EX) !'; goto LastProc;
    end;

  //-- EXX --------------------------------------------------
  if (gsASM1 = 'EXX') then
    begin

      //EXX
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('D9'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (EXX) !'; goto LastProc;
    end;

  //-- LDI --------------------------------------------------
  if (gsASM1 = 'LDI') then
    begin

      //LDI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A0'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (LDI) !'; goto LastProc;
    end;

  //-- LDIR --------------------------------------------------
  if (gsASM1 = 'LDIR') then
    begin

      //LDIR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B0'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (LDIR) !'; goto LastProc;
    end;

  //-- LDD --------------------------------------------------
  if (gsASM1 = 'LDD') then
    begin

      //LDD
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A8'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (LDD) !'; goto LastProc;
    end;

  //-- LDDR --------------------------------------------------
  if (gsASM1 = 'LDDR') then
    begin

      //LDDR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B8'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (LDDR) !'; goto LastProc;
    end;

  //-- CPI --------------------------------------------------
  if (gsASM1 = 'CPI') then
    begin

      //CPI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A1'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CPI) !'; goto LastProc;
    end;

  //-- CPIR --------------------------------------------------
  if (gsASM1 = 'CPIR') then
    begin

     //CPIR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B1'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CPIR) !'; goto LastProc;
    end;

  //-- CPD --------------------------------------------------
  if (gsASM1 = 'CPD') then
    begin

      //CPD
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A9'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CPD) !'; goto LastProc;
    end;

  //-- CPDR --------------------------------------------------
  if (gsASM1 = 'CPDR') then
    begin

      //CPDR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B9'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CPDR) !'; goto LastProc;
    end;

  //-- DAA --------------------------------------------------
  if (gsASM1 = 'DAA') then
    begin

      //DAA
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('27'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (DAA) !'; goto LastProc;
    end;

  //-- CPL --------------------------------------------------
  if (gsASM1 = 'CPL') then
    begin

      //CPL
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('2F'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CPL) !'; goto LastProc;
    end;

  //-- NEG --------------------------------------------------
  if (gsASM1 = 'NEG') then
    begin

      //NEG
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + '44'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (NEG) !'; goto LastProc;
    end;

  //-- RLCA --------------------------------------------------
  if (gsASM1 = 'RLCA') then
    begin

      //RLCA
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('07'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RLCA) !'; goto LastProc;
    end;

  //-- RLA --------------------------------------------------
  if (gsASM1 = 'RLA') then
    begin

      //RLA
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('17'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RLA) !'; goto LastProc;
    end;

  //-- RRCA --------------------------------------------------
  if (gsASM1 = 'RRCA') then
    begin

      //RRCA
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('0F'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RRCA) !'; goto LastProc;
    end;

  //-- RRA --------------------------------------------------
  if (gsASM1 = 'RRA') then
    begin

      //RRA
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('1F'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RRA) !'; goto LastProc;
    end;

  //-- RLC/RL/RRC/RR/SLA/SRA/SRL ? --------------------------------------------------
  if (((gsASM1 = 'RLC') Or (gsASM1 = 'RL') Or (gsASM1 = 'RRC') Or (gsASM1 = 'RR') Or (gsASM1 = 'SLA') Or (gsASM1 = 'SRA') Or (gsASM1 = 'SRL'))) then
    begin

      //CMD -> CMD A
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM2 := 'A';
        end;

      //CMD r,rw
      Xxx3 := '';
      if ((gsASM3 <> '') And (Trim(gsASM4 + gsASM5 + gsASMx) = '')) then
        begin
          if (gsASM3 = 'B') then Xxx3 := '000';
          if (gsASM3 = 'C') then Xxx3 := '001';
          if (gsASM3 = 'D') then Xxx3 := '010';
          if (gsASM3 = 'E') then Xxx3 := '011';
          if (gsASM3 = 'H') then Xxx3 := '100';
          if (gsASM3 = 'L') then Xxx3 := '101';
          if (gsASM3 = 'A') then Xxx3 := '111';
          //CMD r,rw -> CMD r [xxx3]
          gsASM2 := gmsLeft(gsASM2, gmiLen(gsASM2) - 1);
          gsASM3 := '';
        end;

      //CMD r
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = 'B') then Xxx1 := '000';
          if (gsASM2 = 'C') then Xxx1 := '001';
          if (gsASM2 = 'D') then Xxx1 := '010';
          if (gsASM2 = 'E') then Xxx1 := '011';
          if (gsASM2 = 'H') then Xxx1 := '100';
          if (gsASM2 = 'L') then Xxx1 := '101';
          if (gsASM2 = '(HL)') then Xxx1 := '110';
          if (gsASM2 = 'A') then Xxx1 := '111';
          Ccc := '';
          if (gsASM1 = 'RLC') then Ccc := '000';
          if (gsASM1 = 'RL') then Ccc := '010';
          if (gsASM1 = 'RRC') then Ccc := '001';
          if (gsASM1 = 'RR') then Ccc := '011';
          if (gsASM1 = 'SLA') then Ccc := '100';
          if (gsASM1 = 'SRA') then Ccc := '101';
          if (gsASM1 = 'SLL') then Ccc := '110';
          if (gsASM1 = 'SRL') then Ccc := '111';
          if (Xxx1 <> '') then //CMD r
            begin
              ft_ASM_TEXT_ADD('CB' + gsGetBin8ToHex8('00' + Ccc + Xxx1)); //-- TEXT ADD --
              goto LastProc;
            end
          else
            begin
              if (((gmsLeft(gsASM2, 3) = '(IX') Or (gmsLeft(gsASM2, 3) = '(IY')) And (gmsRight(gsASM2, 1) = ')')) then //(IX/IY+-n)
                begin
                  R := fs_ASM_IXY_INDEX(gsASM2, DdFd, iVal); if (R <> '') then goto LastProc;
                  if (Xxx3 = '') then //CMD (IX/IY+-n)
                    ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('00' + Ccc + '110')) //-- TEXT ADD --
                  else //CMD (IX/IY+-n),rw
                    ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('00' + Ccc + Xxx3)) //-- TEXT ADD --
                  ;
                  goto LastProc;
                end;
            end;
        end;

      R := '## 구문 오류 (RLC/RL/RRC/RR/SLA/SRA/SRL) !'; goto LastProc;
    end;

  //-- RLD --------------------------------------------------
  if (gsASM1 = 'RLD') then
    begin

      //RLD
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + '6F'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RLD) !'; goto LastProc;
    end;

  //-- RRD --------------------------------------------------
  if (gsASM1 = 'RRD') then
    begin

      //RRD
      if (Trim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + '67'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RRD) !'; goto LastProc;
    end;

  //-- BIT/SET/RES b,? --------------------------------------------------
  if ((gsASM1 = 'BIT') Or (gsASM1 = 'SET') Or (gsASM1 = 'RES')) then
    begin

      //CMD b,r,rw
      Xxx3 := '';
      if ((gsASM4 <> '') And (Trim(gsASM5 + gsASMx) = '')) then
        begin
          if (gsASM4 = 'B') then Xxx3 := '000';
          if (gsASM4 = 'C') then Xxx3 := '001';
          if (gsASM4 = 'D') then Xxx3 := '010';
          if (gsASM4 = 'E') then Xxx3 := '011';
          if (gsASM4 = 'H') then Xxx3 := '100';
          if (gsASM4 = 'L') then Xxx3 := '101';
          if (gsASM4 = 'A') then Xxx3 := '111';
         //CMD b,r,rw -> CMD b,r [xxx3]
          gsASM3 := gmsLeft(gsASM3, gmiLen(gsASM3) - 1);
          gsASM4 := '';
        end;

      //CMD b,r
      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = '0,') then Xxx1 := '000';
          if (gsASM2 = '1,') then Xxx1 := '001';
          if (gsASM2 = '2,') then Xxx1 := '010';
          if (gsASM2 = '3,') then Xxx1 := '011';
          if (gsASM2 = '4,') then Xxx1 := '100';
          if (gsASM2 = '5,') then Xxx1 := '101';
          if (gsASM2 = '6,') then Xxx1 := '110';
          if (gsASM2 = '7,') then Xxx1 := '111';
          if (Xxx1 <> '') then
            begin
              Xxx2 := '';
              if (gsASM3 = 'B') then Xxx2 := '000';
              if (gsASM3 = 'C') then Xxx2 := '001';
              if (gsASM3 = 'D') then Xxx2 := '010';
              if (gsASM3 = 'E') then Xxx2 := '011';
              if (gsASM3 = 'H') then Xxx2 := '100';
              if (gsASM3 = 'L') then Xxx2 := '101';
              if (gsASM3 = '(HL)') then Xxx2 := '110';
              if (gsASM3 = 'A') then Xxx2 := '111';
              if (Xxx2 <> '') then //CMD b,r
                begin
                  if (gsASM1 = 'BIT') then ft_ASM_TEXT_ADD('CB' + gsGetBin8ToHex8('01' + Xxx1 + Xxx2)); //-- TEXT ADD --
                  if (gsASM1 = 'SET') then ft_ASM_TEXT_ADD('CB' + gsGetBin8ToHex8('11' + Xxx1 + Xxx2)); //-- TEXT ADD --
                  if (gsASM1 = 'RES') then ft_ASM_TEXT_ADD('CB' + gsGetBin8ToHex8('10' + Xxx1 + Xxx2)); //-- TEXT ADD --
                  goto LastProc;
                end
              else //CMD b,(IX/IY+-n),?
                begin
                  if (((gmsLeft(gsASM3, 3) = '(IX') Or (gmsLeft(gsASM3, 3) = '(IY')) And (gmsRight(gsASM3, 1) = ')')) then //(IX/IY+-n)
                    begin
                      R := fs_ASM_IXY_INDEX(gsASM3, DdFd, iVal); if (R <> '') then goto LastProc;
                      if (Xxx3 = '') then //CMD b,(IX/IY+-n)
                        begin
                          if (gsASM1 = 'BIT') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('01' + Xxx1 + '110')); //-- TEXT ADD --
                          if (gsASM1 = 'SET') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('11' + Xxx1 + '110')); //-- TEXT ADD --
                          if (gsASM1 = 'RES') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('10' + Xxx1 + '110')); //-- TEXT ADD --
                        end
                      else //CMD b,(IX/IY+-n),rw
                        begin
                          if (gsASM1 = 'BIT') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('01' + Xxx1 + Xxx3)); //-- TEXT ADD --
                          if (gsASM1 = 'SET') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('11' + Xxx1 + Xxx3)); //-- TEXT ADD --
                          if (gsASM1 = 'RES') then ft_ASM_TEXT_ADD(DdFd + 'CB' + gsGetLngToHex8(iVal) + gsGetBin8ToHex8('10' + Xxx1 + Xxx3)); //-- TEXT ADD --
                        end;
                      goto LastProc;
                    end;
                end;
            end;
        end;

      R := '## 구문 오류 (BIT/SET/RES) !'; goto LastProc;
    end;

  //-- CCF --------------------------------------------------
  if (gsASM1 = 'CCF') then
    begin

      //CCF
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('3F'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (CCF) !'; goto LastProc;
    end;

  //-- SCF --------------------------------------------------
  if (gsASM1 = 'SCF') then
    begin

      //SCF
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('37'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (SCF) !'; goto LastProc;
    end;

  //-- JP nn[(HL),(IX),(IY)]/JP c,nn --------------------------------------------------
  if (gsASM1 = 'JP') then
    begin

      //JP nn/(HL)/(IX)/(IY)
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          if (gsASM2 = '(HL)') then //JP (HL)
            begin
              ft_ASM_TEXT_ADD('E9'); //-- TEXT ADD --
              goto LastProc;
            end;
          if ((gsASM2 = '(IX)') Or (gsASM2 = '(IY)')) then //JP (IX/IY)
            begin
              if (gsASM2 = '(IX)') then DdFd := 'DD' else DdFd := 'FD';
              ft_ASM_TEXT_ADD(DdFd + 'E9'); //-- TEXT ADD --
              goto LastProc;
            end;
          //JP [],nn
          gsASM3 := gsASM2;
          gsASM2 := '';
        end;

      //JP c,nn
      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          R := gtWordConvert(gsASM3, oVal); if (R <> '') then goto LastProc;
          if (gsASM2 = '') then //JP nn
            begin
              S := gsGetLngToHex16(oVal);
              ft_ASM_TEXT_ADD('C3' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
              goto LastProc;
            end;
          Xxx1 := '';
          if (gsASM2 = 'NZ,') then Xxx1 := '000'; //JP NZ,nn
          if (gsASM2 = 'Z,') then Xxx1 := '001'; //JP Z,nn
          if (gsASM2 = 'NC,') then Xxx1 := '010'; //JP NC,nn
          if (gsASM2 = 'C,') then Xxx1 := '011'; //JP C,nn
          if (gsASM2 = 'PO,') then Xxx1 := '100'; //JP PO,nn
          if (gsASM2 = 'PE,') then Xxx1 := '101'; //JP PE,nn
          if (gsASM2 = 'P,') then Xxx1 := '110'; //JP P,nn
          if (gsASM2 = 'M,') then Xxx1 := '111'; //JP M,nn
          if (Xxx1 <> '') then
            begin
              S := gsGetLngToHex16(oVal);
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Xxx1 + '010') + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (JP) !'; goto LastProc;
    end;

  //-- JR nn/JR c,nn --------------------------------------------------
  if (gsASM1 = 'JR') then
    begin

      //JR [],nn/(HL)/(IX)/(IY)
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM3 := gsASM2;
          gsASM2 := '';
        end;

      //JR c,nn
      if (gmsTrim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          R := gtWordConvert(gsASM3, oVal); if (R <> '') then goto LastProc;
          oVal := oVal - (Z80A_REG_PC_Asm + 2);
          if ((oVal < -128) Or (oVal > 127)) then
            begin
              if (Gi_Z80A_Asm = 1) then //0:Pass1, 1:Pass2)
                begin
                  R := '## 점프[JR] 범위 초과 (-128~127) !';
                  goto LastProc;
                end
              else
                begin
                  iVal := 0;
                end;
            end
          else
            begin
              iVal := oVal;
            end;
          if (gsASM2 = '') then //JR nn
            begin
              ft_ASM_TEXT_ADD('18' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;
          Xxx1 := '';
          if (gsASM2 = 'C,') then Xxx1 := '38'; //JR C,nn
          if (gsASM2 = 'NC,') then Xxx1 := '30'; //JR NC,nn
          if (gsASM2 = 'Z,') then Xxx1 := '28'; //JR Z,nn
          if (gsASM2 = 'NZ,') then Xxx1 := '20'; //JR NZ,nn
          if (Xxx1 <> '') then
            begin
              ft_ASM_TEXT_ADD(Xxx1 + gsGetLngToHex8(iVal)); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (JR) !'; goto LastProc;
    end;

  //-- DJNZ --------------------------------------------------
  if (gsASM1 = 'DJNZ') then
    begin

     //DJNZ nn
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          R := gtWordConvert(gsASM2, oVal); if (R <> '') then goto LastProc;
          oVal := oVal - (Z80A_REG_PC_Asm + 2);
          if ((oVal < -128) Or (oVal > 127)) then
            begin
              if (Gi_Z80A_Asm = 1) then //0:Pass1, 1:Pass2)
                begin
                  R := '## 점프[DJNZ] 범위 초과 (-128~127) !';
                  goto LastProc;
                end
              else
                begin
                  iVal := 0;
                end;
            end
          else
            begin
              iVal := oVal;
            end;
          ft_ASM_TEXT_ADD('10' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (DJNZ) !'; goto LastProc;
    end;

  //-- CALL nn/CALL c,nn --------------------------------------------------
  if (gsASM1 = 'CALL') then
    begin

      //CALL [],nn/(HL)/(IX)/(IY)
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM3 := gsASM2;
          gsASM2 := '';
        end;

     //CALL c,nn
      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          R := gtWordConvert(gsASM3, oVal); if (R <> '') then goto LastProc;
          if (gsASM2 = '') then //CALL nn
            begin
              S := gsGetLngToHex16(oVal);
              ft_ASM_TEXT_ADD('CD' + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
              goto LastProc;
            end;
          Xxx1 := '';
          if (gsASM2 = 'NZ,') then Xxx1 := '000'; //CALL NZ,nn
          if (gsASM2 = 'Z,') then Xxx1 := '001'; //CALL Z,nn
          if (gsASM2 = 'NC,') then Xxx1 := '010'; //CALL NC,nn
          if (gsASM2 = 'C,') then Xxx1 := '011'; //CALL C,nn
          if (gsASM2 = 'PO,') then Xxx1 := '100'; //CALL PO,nn
          if (gsASM2 = 'PE,') then Xxx1 := '101'; //CALL PE,nn
          if (gsASM2 = 'P,') then Xxx1 := '110'; //CALL P,nn
          if (gsASM2 = 'M,') then Xxx1 := '111'; //CALL M,nn
          if (Xxx1 <> '') then
            begin
              S := gsGetLngToHex16(oVal);
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Xxx1 + '100') + gmsRight(S, 2) + gmsLeft(S, 2)); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (CALL) !'; goto LastProc;
    end;

  //-- RET/RET c --------------------------------------------------
  if (gsASM1 = 'RET') then
    begin

      //RET
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('C9'); //-- TEXT ADD --
          goto LastProc;
        end;

      //RET c
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = 'NZ') then Xxx1 := '000'; //RET NZ
          if (gsASM2 = 'Z') then Xxx1 := '001'; //RET Z
          if (gsASM2 = 'NC') then Xxx1 := '010'; //RET NC
          if (gsASM2 = 'C') then Xxx1 := '011'; //RET C
          if (gsASM2 = 'PO') then Xxx1 := '100'; //RET PO
          if (gsASM2 = 'PE') then Xxx1 := '101'; //RET PE
          if (gsASM2 = 'P') then Xxx1 := '110'; //RET P
          if (gsASM2 = 'M') then Xxx1 := '111'; //RET M
          if (Xxx1 <> '') then
            begin
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Xxx1 + '000')); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (RET) !'; goto LastProc;
    end;

  //-- RETI --------------------------------------------------
  if (gsASM1 = 'RETI') then
    begin

      //RETI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + '4D'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RETI) !'; goto LastProc;
    end;

  //-- RETN --------------------------------------------------
  if (gsASM1 = 'RETN') then
    begin

      //RETN
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + '45'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (RETN) !'; goto LastProc;
    end;

  //-- RST 00H/08H/10H/18H/20H/28H/30H/38H --------------------------------------------------
  if (gsASM1 = 'RST') then
    begin

      //RST nn
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          Xxx1 := '';
          if (gsASM2 = '00H') then Xxx1 := '000'; //RST 00H
          if (gsASM2 = '08H') then Xxx1 := '001'; //RST 08H
          if (gsASM2 = '10H') then Xxx1 := '010'; //RST 10H
          if (gsASM2 = '18H') then Xxx1 := '011'; //RST 18H
          if (gsASM2 = '20H') then Xxx1 := '100'; //RST 20H
          if (gsASM2 = '28H') then Xxx1 := '101'; //RST 28H
          if (gsASM2 = '30H') then Xxx1 := '110'; //RST 30H
          if (gsASM2 = '38H') then Xxx1 := '111'; //RST 38H
          if (Xxx1 <> '') then
            begin
              ft_ASM_TEXT_ADD(gsGetBin8ToHex8('11' + Xxx1 + '111')); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 () !'; goto LastProc;
    end;

  //-- IN A,(p)[IN A,p]/IN r,(C) --------------------------------------------------
  if (gsASM1 = 'IN') then
    begin

      //IN n -> IN A,n
      if (Trim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM3 := gsASM2;
          gsASM2 := 'A,';
        end;

      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          //IN n,n
          if (gsASM3 = '(C)') then //IN r,(C)
            begin
              Xxx1 := '';
              if (gsASM2 = 'B,') then Xxx1 := '000'; //IN B,(C)
              if (gsASM2 = 'C,') then Xxx1 := '001'; //IN C,(C)
              if (gsASM2 = 'D,') then Xxx1 := '010'; //IN D,(C)
              if (gsASM2 = 'E,') then Xxx1 := '011'; //IN E,(C)
              if (gsASM2 = 'H,') then Xxx1 := '100'; //IN H,(C)
              if (gsASM2 = 'L,') then Xxx1 := '101'; //IN L,(C)
              if (gsASM2 = 'A,') then Xxx1 := '111'; //IN A,(C)
              if (Xxx1 <> '') then
                begin
                  ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx1 + '000')); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;
          if (gsASM2 = 'A,') then //IN A,(n)
            begin
              if ((gmsLeft(gsASM3, 1) = '(') And (gmsRight(gsASM3, 1) = ')')) then gsASM3 := gmsMid(gsASM3, 2, gmiLen(gsASM3) - 2);
              R := gtByteConvert(gsASM3, iVal);
              if (R = '') then
                begin
                  ft_ASM_TEXT_ADD('DB' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;
        end;

      R := '## 구문 오류 (IN) !'; goto LastProc;
    end;

  //-- OUT (p),A[OUT p,A]/OUT (C),r --------------------------------------------------
  if (gsASM1 = 'OUT') then
    begin

      //OUT n -> OUT n,A
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          gsASM2 := gsASM2 + ',';
          gsASM3 := 'A';
        end;

      if (Trim(gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          //OUT n,n
          if (gsASM2 = '(C),') then //OUT (C),r
            begin
              Xxx1 := '';
              if (gsASM3 = 'B') then Xxx1 := '000'; //OUT (C),B
              if (gsASM3 = 'C') then Xxx1 := '001'; //OUT (C),C
              if (gsASM3 = 'D') then Xxx1 := '010'; //OUT (C),D
              if (gsASM3 = 'E') then Xxx1 := '011'; //OUT (C),E
              if (gsASM3 = 'H') then Xxx1 := '100'; //OUT (C),H
              if (gsASM3 = 'L') then Xxx1 := '101'; //OUT (C),L
              if (gsASM3 = 'A') then Xxx1 := '111'; //OUT (C),A
              if (Xxx1 <> '') then
                begin
                  ft_ASM_TEXT_ADD('ED' + gsGetBin8ToHex8('01' + Xxx1 + '001')); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;
          if (gsASM3 = 'A') then //OUT (n),A
            begin
              if ((gmsLeft(gsASM2, 1) = '(') And (gmsRight(gsASM2, 2) = '),')) then gsASM2 := gmsMid(gsASM2, 2, gmiLen(gsASM2) - 2 - 1);
              R := gtByteConvert(gsASM2, iVal);
              if (R = '') then
                begin
                  ft_ASM_TEXT_ADD('D3' + gsGetLngToHex8(iVal)); //-- TEXT ADD --
                  goto LastProc;
                end;
            end;
        end;

      R := '## 구문 오류 (OUT) !'; goto LastProc;
    end;

  //-- INI --------------------------------------------------
  if (gsASM1 = 'INI') then
    begin

      //INI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A2'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (INI) !'; goto LastProc;
    end;

  //-- INIR --------------------------------------------------
  if (gsASM1 = 'INIR') then
    begin

      //INIR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B2'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (INIR) !'; goto LastProc;
    end;

  //-- IND --------------------------------------------------
  if (gsASM1 = 'IND') then
    begin

      //IND
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'AA'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (IND) !'; goto LastProc;
    end;

  //-- INDR --------------------------------------------------
  if (gsASM1 = 'INDR') then
    begin

      //INDR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'BA'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (INDR) !'; goto LastProc;
    end;

  //-- OUTI --------------------------------------------------
  if (gsASM1 = 'OUTI') then
    begin

      //OUTI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'A3'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (OUTI) !'; goto LastProc;
    end;

  //-- OTIR --------------------------------------------------
  if (gsASM1 = 'OTIR') then
    begin

      //OTIR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'B3'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (OTIR) !'; goto LastProc;
    end;

  //-- OUTD --------------------------------------------------
  if (gsASM1 = 'OUTD') then
    begin

      //OUTD
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'AB'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (OUTD) !'; goto LastProc;
    end;

  //-- OTDR --------------------------------------------------
  if (gsASM1 = 'OTDR') then
    begin

      //OTDR
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('ED' + 'BB'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (OTDR) !'; goto LastProc;
    end;

  //-- NOP --------------------------------------------------
  if (gsASM1 = 'NOP') then
    begin

      //NOP
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('00'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (NOP) !'; goto LastProc;
    end;

  //-- HALT --------------------------------------------------
  if (gsASM1 = 'HALT') then
    begin

      //HALT
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('76'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (HALT) !'; goto LastProc;
    end;

  //-- DI --------------------------------------------------
  if (gsASM1 = 'DI') then
    begin

      //DI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('F3'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (DI) !'; goto LastProc;
    end;

  //-- EI --------------------------------------------------
  if (gsASM1 = 'EI') then
    begin

      //EI
      if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          ft_ASM_TEXT_ADD('FB'); //-- TEXT ADD --
          goto LastProc;
        end;

      R := '## 구문 오류 (EI) !'; goto LastProc;
    end;

  //-- IM 0/1/2 --------------------------------------------------
  if ((gsASM1 = 'IM')) then
    begin

      //IM n
      if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) = '') then
        begin
          if (gsASM2 = '0') then //IM 0
            begin
              ft_ASM_TEXT_ADD('ED' + '46'); //-- TEXT ADD --
              goto LastProc;
            end;
          if (gsASM2 = '1') then //IM 1
            begin
              ft_ASM_TEXT_ADD('ED' + '56'); //-- TEXT ADD --
              goto LastProc;
            end;
          if (gsASM2 = '2') then //IM 2
            begin
              ft_ASM_TEXT_ADD('ED' + '5E'); //-- TEXT ADD --
              goto LastProc;
            end;
        end;

      R := '## 구문 오류 (IM) !'; goto LastProc;
    end;

  R := '## 구문 오류 !'; goto LastProc;

LastProc:
  Result := R;
end;

procedure ft_ASM_TEXT_ADD(sCmd: String);
begin
  //명령 기록
  GsASM_Data := GsASM_Data + sCmd;
  GiASM_PC_Add := GiASM_PC_Add + (gmiLen(sCmd) div 2);
end;

function fs_ASM_IXY_INDEX(sCmd: String; var DdFd: String; var iVal: Integer): String;
var
  R: String;
  S: String;
label
  LastProc;
begin
  R := '';

  DdFd := ''; iVal := 0;

  //(IX/IY+-n)
  if ((gmsLeft(sCmd, 3) = '(IX') Or (gmsLeft(sCmd, 3) = '(IY')) And (gmsRight(sCmd, 1) = ')') then
    begin
      if (gmsLeft(sCmd, 3) = '(IX') then DdFd := 'DD' else DdFd := 'FD';
      S := gmsMid(sCmd, 5, gmiLen(sCmd) - 5); //(IX+??)
      R := gtByteConvert(S, iVal); if (R <> '') then goto LastProc;
      if ((gmsMid(sCmd, 4, 1) = '+') Or (gmsMid(sCmd, 4, 1) = '-')) then
        begin
          if (gmsMid(sCmd, 4, 1) = '-') then iVal := iVal * (-1);
          if ((iVal < -128) Or (iVal > 127)) then
            begin
              R := '## IDX+값 범위 초과 (-128~127) !';
              goto LastProc;
            end;
          R := ''; //Ok
          goto LastProc;
        end;
    end;

  R := '## 구문 오류 (IX/IY+-n) !';

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "ORG"
function gs_Z80A_ASM_ORG: String;
var
  R: String;
  oVal: LongInt = 0;
label
  LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  if (gmsTrim(gsASM3 + gsASM4 + gsASM5 + gsASMx) <> '') then
    begin
      R := '## 구문 오류 !';
      goto LastProc;
    end;

  R := gtWordConvert(gsASM2, oVal); if (R <> '') then goto LastProc;

  Z80A_REG_PC_Asm := oVal;

LastProc:
  Result := R;
end;

//gsUpper(gsASM2) = "EQU"
function gs_Z80A_ASM_EQU: String;
var
  R: String;
  sLabel: String = ''; oVal: LongInt = 0;
label
  LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  if (gmsTrim(gsASM4 + gsASM5 + gsASMx) <> '') then
    begin
      R := '## 구문 오류 !';
      goto LastProc;
    end;

  R := gtLabelConvert(gsASM1, sLabel, 1);
  if (R <> '') then goto LastProc;

  R := gtWordConvert(gsASM3, oVal); if (R <> '') then goto LastProc;

  GsASM_Label := sLabel;
  GoASM_Addr := oVal;

LastProc:
  Result := R;
end;

//Right(gsASM1, 1) = ":"
function gs_Z80A_ASM_LABEL: String;
var
  R: String;
  sLabel: String = '';
label
  LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  gsASM1 := gmsTrim(gmsLeft(gsASM1, gmiLen(gsASM1) - 1));
  if (gsASM1 = '') then
    begin
      R := '## 라벨명 오류 !';
      goto LastProc;
    end;

  R := gtLabelConvert(gsASM1, sLabel, 1);
  if (R <> '') then goto LastProc;

  GsASM_Label := sLabel;

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "DEFB" - Byte
function gs_Z80A_ASM_DEFB: String;
var
  R: String;
  i, P: Integer; S: String; iVal: Integer = 0;
label
  NextProc, LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  P := giGetTxtSeparate(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx);
  if (P = 0) then
    begin
      R := '## DEFB 선언 오류 !';
      goto LastProc;
    end;

  for i := 1 to P do
    begin
      S := GsGetTxtSeparate[i];
      if (S = '') then
        begin
          R := '## DEFB 선언 오류 (수치 오류) !';
          GoTo LastProc;
        end;
      R := gtByteConvert(S, iVal); if (R <> '') then goto LastProc;
      GsASM_Data := GsASM_Data + gsGetLngToHex8(iVal);
      GiASM_PC_Add := GiASM_PC_Add + 1;
NextProc:
    end;

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "DEFW" - Word
function gs_Z80A_ASM_DEFW: String;
var
  R: String;
  i, P: Integer; S: String; oVal: LongInt = 0;
label
  NextProc, LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  P := giGetTxtSeparate(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx);
  if (P = 0) then
    begin
      R := '## DEFW 선언 오류 !';
      goto LastProc;
    end;

  for i := 1 to P do
    begin
      S := GsGetTxtSeparate[i];
      if (S = '') then
        begin
          R := '## DEFW 선언 오류 (수치 오류) !';
          goto LastProc;
        end;
      R := gtWordConvert(S, oVal); if (R <> '') then goto LastProc;
      S := gsGetLngToHex16(oVal);
      GsASM_Data := GsASM_Data + gmsRight(S, 2);
      GiASM_PC_Add := GiASM_PC_Add + 1;
      GsASM_Data := GsASM_Data + gmsLeft(S, 2);
      GiASM_PC_Add := GiASM_PC_Add + 1;
NextProc:
    end;

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "DEFM" - 문자열
function gs_Z80A_ASM_DEFM: String;
var
  R: String;
  i, j, P: Integer; S, C: String;
label
  NextProc, LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  P := giGetTxtSeparate(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx);
  if (P = 0) then
    begin
      R := '## DEFM 선언 오류 !';
      goto LastProc;
    end;

  for i := 1 to P do
    begin
      S := GsGetTxtSeparate[i];
      if (gmiLen(S) < 2) then
        begin
          R := '## DEFM 선언 오류 (문자열[''] 오류) !';
          goto LastProc;
        end;
      if ((gmsLeft(S, 1) <> '''') Or (gmsRight(S, 1) <> '''')) then  //[']
        begin
          R := '## DEFM 선언 오류 (문자열[''] 오류) !';
          goto LastProc;
        end;
      if (S = '''''') then  //['']
        begin
          GsASM_Data := GsASM_Data + '00';
          GiASM_PC_Add := GiASM_PC_Add + 1;
          goto NextProc;
        end;
      for j := 2 to (gmiLen(S) - 1) do
        begin
          C := gmsMid(S, j, 1);
          C := gmsReplace(C, '＿', ' ');
          C := gmsReplace(C, '，', ',');
          C := gmsReplace(C, '＋', '+');
          C := gmsReplace(C, '－', '-');
          C := gmsReplace(C, '＊', '*');
          C := gmsReplace(C, '／', '/');
          C := gmsReplace(C, '：', ':');
          C := gmsReplace(C, '′', ''''); //[']
          C := gmsReplace(C, '″', '"'); //["]
          GsASM_Data := GsASM_Data + gsGetLngToHex8(gmiAsc(C));
          GiASM_PC_Add := GiASM_PC_Add + 1;
        end;
NextProc:
    end;

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "DEFS" - 공간확보
function gs_Z80A_ASM_DEFS: String;
var
  R: String;
  i, j, P: Integer; S: String; oVal: LongInt = 0;
label
  NextProc, LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  P := giGetTxtSeparate(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx);
  if (P = 0) then
    begin
      R := '## DEFS 선언 오류 !';
      goto LastProc;
    end;

  for i := 1 to P do
    begin
      S := GsGetTxtSeparate[i];
      if (S = '') then
        begin
          R := '## DEFS 선언 오류 (수치 오류) !';
          goto LastProc;
        end;
      R := gtWordConvert(S, oVal); if (R <> '') then goto LastProc;
      if (oVal = 0) then
        begin
          R := '## DEFS 선언 오류 (수치 0) !';
          goto LastProc;
        end;
      for j := 1 to oVal do
        begin
          GsASM_Data := GsASM_Data + '00';
          GiASM_PC_Add := GiASM_PC_Add + 1;
        end;
NextProc:
    end;

LastProc:
  Result := R;
end;

//gsUpper(gsASM1) = "END"
function gs_Z80A_ASM_END: String;
var
  R: String;
label
  LastProc;
begin
  R := '';

  GsASM_Data := '';
  GiASM_PC_Add := 0;

  if (gmsTrim(gsASM2 + gsASM3 + gsASM4 + gsASM5 + gsASMx) <> '') then
    begin
      R := '## 구문 오류 !';
      goto LastProc;
    end;

LastProc:
  Result := R;
end;

function gs_Z80A_ASM_Label_Write(sLabel: String;  oAddr: LongInt): String;
var
  R: String;
  i: Integer;
label
  LastProc;
begin
  R := '';

  for i := 0 to Gi_Label_Tot do
    begin
      if (GsASM_Wrt_Label[i] = '') then
        begin
          GsASM_Wrt_Label[i] := sLabel;
          GsASM_Wrt_Addr[i] := oAddr;
          GoTo LastProc;
        end
      else
        begin
          if (GsASM_Wrt_Label[i] = sLabel) then
            begin
              R := '## 라벨명 중복 오류 !';
              goto LastProc;
            end;
        end;
    end;

  R := '## 라벨 ' + gmsCStr(Gi_Label_Tot) + '개 초과 오류 !';

LastProc:
  Result := R;
end;

function gs_Z80A_ASM_Label_Read(sLabel: String; var oAddr: LongInt): String;
var
  R: String;
  i: Integer;
label
  SkipProc, LastProc;
begin
  R := '';

  for i := 0 to Gi_Label_Tot do
    begin
      if (GsASM_Wrt_Label[i] = sLabel) then
        begin
          oAddr := GsASM_Wrt_Addr[i];
          goto LastProc;
        end;
      if (GsASM_Wrt_Label[i] = '') then
        begin
          goto SkipProc;
        end;
    end;

SkipProc:
  R := '## 등록된 라벨명 없음 !';

LastProc:
  Result := R;
end;

function gtLabelConvert(sVal: String; var sVal2: String; iSel: ShortInt = 0): String;
var
  R: String;
  i: Integer; C: String;
label
  LastProc;
begin
  R := '';
  sVal2 := '';

  if ((gmsLeft(sVal, 1) >= '0') And (gmsLeft(sVal, 1) <= '9')) then
    begin
      R := '## 라벨명 오류 (''0''~''9''로 시작하면 안됨) !';
      goto LastProc;
    end;

  for i := 1 to gmiLen(sVal) do
    begin
      C := gmsMid(sVal, i, 1);
      if (iSel = 0) then
        begin
          if ((C < '0') Or (C > '9')) And ((C < 'A') Or (C > 'Z')) And (C <> '?') And (C <> '@') And (C <> '_') And (C <> '$') then
            begin
              R := '## 라벨명 오류 (''0''~''9'',''A''~''Z'',''?'',''@'',''_'',''$'' 이외값) !';
              goto LastProc;
            end;
          if (C <> '$') then
            sVal2 := sVal2 + C
          else
            sVal2 := sVal2 + gmsCStr(Z80A_REG_PC_Asm)
          ;
        end
      else
        begin
          if ((C < '0') Or (C > '9')) And ((C < 'A') Or (C > 'Z')) And (C <> '?') And (C <> '@') And (C <> '_') then
            begin
              R := '## 라벨명 오류 (''0''~''9'',''A''~''Z'',''?'',''@'',''_'' 이외값) !';
              goto LastProc;
            end;
          sVal2 := sVal2 + C;
        end;
    end;

LastProc:
  Result := R;
end;

function gtWordConvert(sVal: String; var oVal: LongInt): String;
var
  R: String;
  Oo: LongInt = 0;
label
  LastProc;
begin
  R := '';
  oVal := 0;

  R := gtGetStringCompute(sVal, Oo);
  if (R <> '') then goto LastProc;

  if (Oo < 0) then Oo := Oo + 65536;
  if ((Oo < 0) Or (Oo > 65535)) then
    begin
      R := '## 수치 범위 오류 (0~65535) !';
      goto LastProc;
    end;

  oVal := Oo;

LastProc:
  Result := R;
end;

function gtByteConvert(sVal: String; var iVal: Integer): String;
var
  R: String;
  Oo: LongInt = 0;
label
  LastProc;
begin
  R := '';
  iVal := 0;

  R := gtGetStringCompute(sVal, Oo);
  if (R <> '') then goto LastProc;

  if (Oo < 0) then Oo := Oo + 256;
  if ((Oo < 0) Or (Oo > 255)) then
    begin
      R := '## 수치 범위 오류 (0~255) !';
      goto LastProc;
    end;

  iVal := Oo;

LastProc:
  Result := R;
end;

function gtGetStringCompute(sVal: String; var oVal: LongInt): String;
var
  R: String; T: LongInt;
  i, j: Integer; C: String; F: ShortInt = 0; iChk: Integer;
  S: Array[0..1000] Of String;
  Sp: String; P: Integer; Oo: LongInt = 0; SS: String = '';
label
  NextProc, LastProc;
begin
  R := ''; T := 0;

  if (sVal = '') then
    begin
      R := '## 수치 오류 (빈칸) !';
      goto LastProc;
    end;

  P := 1; S[P] := '';
  for i := 1 to gmiLen(sVal) do
    begin
      C := gmsMid(sVal, i, 1);
      if ((C = '+') Or (C = '-') Or (C = '*') Or (C = '/')) then
        begin
          P := P + 1;
          S[P] := C;
        end
      else
        begin
          S[P] := S[P] + C;
        end;
    end;

  for i := 1 to P do
    begin

      Sp := S[i];
      if ((Sp = '') Or (Sp = '+') Or (Sp = '-')) then
        begin
          R := '## 수치 오류 ([빈칸],[+],[-]) !';
          goto LastProc;
        end;
      if (i = 1) then //부호(+,-,*,/)
        begin
          F := 1;
        end
      else
        begin
          if (gmsLeft(Sp, 1) = '+') then F := 1;
          if (gmsLeft(Sp, 1) = '-') then F := -1;
          if (gmsLeft(Sp, 1) = '*') then F := 2;
          if (gmsLeft(Sp, 1) = '/') then F := 3;
          Sp := gmsMid(Sp, 2);
        end;

      Sp := gmsReplace(Sp, '＿', ' ');
      Sp := gmsReplace(Sp, '，', ',');
      Sp := gmsReplace(Sp, '＋', '+');
      Sp := gmsReplace(Sp, '－', '-');
      Sp := gmsReplace(Sp, '＊', '*');
      Sp := gmsReplace(Sp, '／', '/');
      Sp := gmsReplace(Sp, '：', ':');
      Sp := gmsReplace(Sp, '′', ''''); //[']
      Sp := gmsReplace(Sp, '″', '"'); //["]
      if (Sp = '''''') then //['']
        begin
          R := '## 수치 오류 (''빈칸'') !';
          goto LastProc;
        end;
      if ((gmsLeft(Sp, 1) = '''') Or (gmsRight(Sp, 1) = '''')) then
        begin
          if (gmiLen(Sp) < 3) then
            begin
              R := '## 수치 오류 (문자열[''] 오류) !';
              goto LastProc;
            end;
          if (gmiLen(Sp) > 3) then
            begin
              R := '## 수치 오류 (문자열[''''] 1바이트 초과) !';
              goto LastProc;
            end;
          if ((gmsLeft(Sp, 1) <> '''') Or (gmsRight(Sp, 1) <> '''')) then
            begin
              R := '## 수치 오류 (문자열[''''] 오류) !';
              goto LastProc;
            end;
          if ((F = 1) Or (F = (-1))) then
            begin
              T := T + (gmiAsc(gmsMid(Sp, 2, 1)) * F); //(+/-)값
            end
          else
            begin
              if (F = 2) then T := T * gmiAsc(gmsMid(Sp, 2, 1));
              if (F = 3) then T := T div gmiAsc(gmsMid(Sp, 2, 1));
            end;
          goto NextProc;
        end;

      if (gmsLeft(Sp, 1) = '#') then //#숫자
        begin
          Sp := '0' + gmsMid(Sp, 2) + 'H';
        end;

      if ((gmsLeft(Sp, 1) >= '0') And (gmsLeft(Sp, 1) <= '9')) then //숫자
        begin
          iChk := 0; //순서중요(B->D->H)
          if (gmsRight(Sp, 1) = 'B') then
            begin
              Sp := gmsLeft(Sp, gmiLen(Sp) - 1);
              iChk := 2; //2진수
            end;
          if (gmsRight(Sp, 1) = 'D') then
            begin
              Sp := gmsLeft(Sp, gmiLen(Sp) - 1);
              iChk := 0; //10진수
            end;
          if (gmsRight(Sp, 1) = 'H') then
            begin
              Sp := gmsLeft(Sp, gmiLen(Sp) - 1);
              iChk := 1; //16진수
            end;
        end
      else //라벨(Label)
        begin
          iChk := 4;
          R := gtLabelConvert(Sp, SS); if (R <> '') then goto LastProc;
          if ((gmsLeft(SS, 1) >= '0') And (gmsLeft(SS, 1) <= '9')) then
            begin
              Oo := gmiVal(SS);
            end
          else
            begin
              if (Gi_Z80A_Asm = 0) then //Pass 1
                begin
                  R := gs_Z80A_ASM_Label_Read(SS, Oo);
                  R := '';
                end
              else //Pass2
                begin
                  R := gs_Z80A_ASM_Label_Read(SS, Oo);
                  if (R <> '') then goto LastProc;
                end;
            end;
          if ((F = 1) Or (F = (-1))) then
            begin
              T := T + (Oo * F); //(+/-)값
            end
          else
            begin
              if (F = 2) then T := T * Oo;
              if (F = 3) then T := T div Oo;
            end;
          goto NextProc;
        end;

      while (gmsLeft(Sp, 1) = '0') do Sp := gmsMid(Sp, 2);
      if (Sp = '') then goto NextProc;

      for j := 1 to gmiLen(Sp) do
        begin
          C := gmsMid(Sp, j, 1);
          if (iChk = 0) then //10진수
            if ((C < '0') Or (C > '9')) then
              begin
                R := '## 수치 오류 (0~9이외값(10진수)) !';
                goto LastProc;
              end;
          if (iChk = 1) then //16진수
            if ((C < '0') Or (C > '9')) And ((C < 'A') Or (C > 'F')) then
              begin
                R := '## 수치 오류 (0~9,A~F이외값(16진수)) !';
                goto LastProc;
              end;
          if (iChk = 2) then //2진수
            if ((C < '0') Or (C > '1')) then
              begin
                R := '## 수치 오류 (0~1이외값(2진수)) !';
                goto LastProc;
              end;
        end;

      if (iChk = 0) then
        begin
          if ((gmiVal(Sp) < 0) Or (gmiVal(Sp) > 65535)) then
            begin
              R := '## 수치 범위 오류 (0~65535) !';
              goto LastProc;
            end;
          Oo := gmiVal(Sp);
        end;
      if (iChk = 1) then
        begin
          if (gmiLen(Sp) > 4) then
            begin
              R := '## 수치 범위 오류 (0000H~FFFFH) !';
              goto LastProc;
            end;
          Oo := goGetHex16ToLng(Sp);
        end;
      if (iChk = 2) then
        begin
          if (gmiLen(Sp) > 8) then
            begin
              R := '## 수치 범위 오류 (00000000B~11111111B) !';
              goto LastProc;
            end;
          Oo := giGetBin8ToInt(gmsRight('00000000' + Sp, 8));
        end;

      if ((F = 1) Or (F = (-1))) then
        begin
          T := T + (Oo * F); //(+/-)값
        end
      else
        begin
          if (F = 2) then T := T * Oo;
          if (F = 3) then T := T div Oo;
        end;

NextProc:
    end;

LastProc:
  oVal := T;

  Result := R;
end;

function giGetTxtSeparate(sStr: String): Integer;
var
  P: Integer;
  i: LongInt; C, V: String;
label
  LastProc;
begin
  P := 0;

  if (sStr = '') then goto LastProc;

  P := 1; V := ','; GsGetTxtSeparate[P] := '';
  for i := 1 to gmiLen(sStr) do
    begin
      C := gmsMid(sStr, i, 1);
      if (C <> V) then
        begin
          GsGetTxtSeparate[P] := GsGetTxtSeparate[P] + C;
        end
      else
        begin
          P := P + 1;
          GsGetTxtSeparate[P] := '';
        end;
    end;

  for i := 1 to P do GsGetTxtSeparate[i] := gmsTrim(GsGetTxtSeparate[i]);

LastProc:
  Result := P;
end;

//주소 입력 작업용
function gsGetStringHex4(sVal: String): String;
var
  R: String;
  C: String; i: Integer;
label
  LastProc;
begin
  R := '';

  if (sVal = '') then goto LastProc;
  sVal := gmsUpper(sVal);

  for i := 1 to gmiLen(sVal) do
    begin
      C := gmsMid(sVal, i, 1);
      if ((C >= '0') And (C <= '9')) Or ((C >= 'A') And (C <= 'F')) then R := R + C;
    end;

  if (R <> '') then R := gmsRight('0000' + R, 4);

LastProc:
  Result := R;
end;

function gsGetStringHex2(sVal: String): String;
var
  R: String;
  C: String; i: Integer;
label
  LastProc;
begin
  R := '';

  if (sVal = '') then goto LastProc;
  sVal := gmsUpper(sVal);

  for i := 1 to gmiLen(sVal) do
    begin
      C := gmsMid(sVal, i, 1);
      if ((C >= '0') And (C <= '9')) Or ((C >= 'A') And (C <= 'F')) then R := R + C;
    end;

  if (R <> '') then R := gmsRight('00' + R, 2);

LastProc:
  Result := R;
end;

//Display(16값) 전용
function gsGetLngToHex16_Disp(oVal: LongInt): String;
var
  T: String;
begin
  Go_MSX_DisASM_ADR_Ref := oVal;

  T := gsGetLngToHex16(oVal);
  if (gmsLeft(T, 1) >= 'A') then T := '0' + T;
  T := T + 'H';

  Result := T;
end;

function goGetLngToLng(oVal: LongInt): LongInt;
var
  T: LongInt;
begin
  T := oVal;
  if (T < 0) then T := T + 65536;
  if (T > 65535) then T := T - 65536;

  Result := T;
end;

function giGetIntToInt(iVal: Integer): Integer;
var
  T: Integer;
begin
  T := iVal;
  if (T < 0) then T := T + 256;
  if (T > 255) then T := T - 256;

  Result := T;
end;

function goGetIntHLToLng(iValH: Integer; iValL: Integer): LongInt;
begin
  Result := (iValH * 256) + iValL;
end;

procedure gtMoveLngToIntHL(oVal: LongInt; var iValH: Integer; var iValL: Integer);
begin
  iValH := goGetLngToLng(oVal And $FF00) div 256;
  iValL := (oVal And $FF);
end;

function giGetLngToIntH(oVal: LongInt): Integer;
begin
  Result := goGetLngToLng(oVal And $FF00) div 256;
end;

function giGetLngToIntL(oVal: LongInt): Integer;
begin
  Result := (oVal And $FF);
end;

function gsGetBin8ToHex8(sVal: String): String;
begin
  Result := gsGetLngToHex8(giGetBin8ToInt(sVal));
end;

function gsGetLngToHex16(oVal: LongInt): String;
var
  R, S: String;
begin
  S := gmsRight('00000' + gmsHex(oVal), 5);

  GsGetLngToHex16_Cry := gmsLeft(S, 1); //Dump 용 (VRAM 64KB 초과시 사용)
  R := gmsRight(S, 4);

  Result := R;
end;

function gsGetLngToHex8(oVal: LongInt): String;
begin
  Result := gmsRight('00' + gmsHex(oVal), 2);
end;

function goGetHex16ToLng(sVal: String): LongInt;
var
  T: LongInt;
begin
  T := gmiHex8ToInt(sVal);
  if (T < 0) then T := T + 65536;

  Result := T;
end;

function giGetHex8ToInt(sVal: String): Integer;
begin
  Result := gmiHex8ToInt(sVal);
end;

function giGetBin8ToInt(sBin: String; iSel: ShortInt = 0): Integer;
var
  T: Integer;
begin
  T := 0;

  if (iSel = 1) then sBin := gmsRight('00000000' + sBin, 8);

  T := 0;
  T := T + (gmiVal(gmsMid(sBin, 1, 1)) * Gi_B_Table_7);
  T := T + (gmiVal(gmsMid(sBin, 2, 1)) * Gi_B_Table_6);
  T := T + (gmiVal(gmsMid(sBin, 3, 1)) * Gi_B_Table_5);
  T := T + (gmiVal(gmsMid(sBin, 4, 1)) * Gi_B_Table_4);
  T := T + (gmiVal(gmsMid(sBin, 5, 1)) * Gi_B_Table_3);
  T := T + (gmiVal(gmsMid(sBin, 6, 1)) * Gi_B_Table_2);
  T := T + (gmiVal(gmsMid(sBin, 7, 1)) * Gi_B_Table_1);
  T := T + (gmiVal(gmsMid(sBin, 8, 1)) * Gi_B_Table_0);

  Result := T;
end;

function giGetBin4ToInt(sBin: String; iSel: ShortInt = 0): Integer;
var
  T: Integer;
begin
  T := 0;

  if (iSel = 1) then sBin := gmsRight('0000' + sBin, 4);

  T := 0;
  T := T + (gmiVal(gmsMid(sBin, 1, 1)) * Gi_B_Table_3);
  T := T + (gmiVal(gmsMid(sBin, 2, 1)) * Gi_B_Table_2);
  T := T + (gmiVal(gmsMid(sBin, 3, 1)) * Gi_B_Table_1);
  T := T + (gmiVal(gmsMid(sBin, 4, 1)) * Gi_B_Table_0);

  Result := T;
end;

function giGetBin3ToInt(sBin: String; iSel: ShortInt = 0): Integer;
var
  T: Integer;
begin
  T := 0;

  if (iSel = 1) then sBin := gmsRight('000' + sBin, 3);

  T := 0;
  T := T + (gmiVal(gmsMid(sBin, 1, 1)) * Gi_B_Table_2);
  T := T + (gmiVal(gmsMid(sBin, 2, 1)) * Gi_B_Table_1);
  T := T + (gmiVal(gmsMid(sBin, 3, 1)) * Gi_B_Table_0);

  Result := T;
end;

function giGetBin2ToInt(sBin: String; iSel: ShortInt = 0): Integer;
var
  T: Integer;
begin
  T := 0;

  if (iSel = 1) then sBin := gmsRight('00' + sBin, 2);

  T := 0;
  T := T + (gmiVal(gmsMid(sBin, 1, 1)) * Gi_B_Table_1);
  T := T + (gmiVal(gmsMid(sBin, 2, 1)) * Gi_B_Table_0);

  Result := T;
end;

function gsGetIntToBin8(iVal: Integer): String;
var
  T: String;
begin
  T := '';

  T := T + gmsIfThen((iVal And 128) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 64) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 32) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 16) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 8) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 4) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 2) = 0, '0', '1');
  T := T + gmsIfThen((iVal And 1) = 0, '0', '1');

  Result := T;
end;

procedure gtSwap16(var oVal1: LongInt; var oVal2: LongInt);
var
  oVal: LongInt;
begin
  oVal := oVal1;
  oVal1 := oVal2;
  oVal2 := oVal;
end;

procedure gtSwap8(var iVal1: Integer; var iVal2: Integer);
var
  iVal: Integer;
begin
  iVal := iVal1;
  iVal1 := iVal2;
  iVal2 := iVal;
end;

end.

