unit msxZ80A_Dis;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils;

  procedure gt_ADD_PC_Dis(iSz: Integer);
  function gb_GET_MSX_MEMORY(oAddr: Word): Byte;
  procedure gt_PUT_MSX_MEMORY(oAddr: Word; iVal: Byte);
  procedure gt_GET_PC_DATA_16(var Reg16: LongInt);
  procedure gt_GET_PC_DATA_16ToHL(var RegH: Integer; var RegL: Integer);
  procedure gt_GET_PC_DATA_8(var reg8: Integer);
  function go_GET_PC_DATA_16: LongInt;
  function gi_GET_PC_DATA_8: Integer;
  function gs_GET_PC_DATA_16_DASM: String;
  function gs_GET_PC_DATA_8_DASM(iSel: Integer = 0): String;
  function gi_GET_PC_DATA_8_DASM: Integer;
  function gs_GET_PC_DATA_IDX_8_DASM(iSel: Integer = 0): String;
  function gs_GET_HEX_8(iVal: Integer): String;
  function gi_GET_IDX_8(iVal: Integer): Integer;
  function gi_GET_16_Sign(oVal: LongInt): Integer;
  function gi_GET_8_Sign(iVal: Integer): Integer;
  function gi_GET_16_Zero(oVal: LongInt): Integer;
  function gi_GET_8_Zero(iVal: Integer): Integer;
  function gi_GET_BIT1_Even(iVal: Integer): Integer;
  procedure gt_Move_Z80A_CODE;
  procedure gt_Move_z80a_CODE_CB;
  procedure gt_Move_z80a_CODE_ED;
  procedure gt_Move_z80a_CODE_DD;
  procedure gt_Move_z80a_CODE_DD_CB;
  procedure gt_Move_z80a_CODE_FD;
  procedure gt_Move_z80a_CODE_FD_CB;

var
  Gi_MSX_DisASM_MEM_Use: Array[0..65536-1] Of Integer; //[0~65535]
  //Go_MSX_DisASM_ADR_Ref: LongInt;

  //PE/PO테이블
  Gi_P_Table: Array[0..255] Of Integer;
  //BIT테이블
  Gi_B_Table: Array[0..7] Of Integer;
  Gi_NB_Table: Array[0..7] Of Integer;

  //프로그램 카운터(16) - 디스어셈블용
  Z80A_REG_PC_DASM_ST: LongInt;
  Z80A_REG_IDX_DASM: Integer;
  Z80A_Dis_ADDR: LongInt;
  Z80A_Dis_DUMP: String;
  Z80A_Dis_ASM1: String;
  Z80A_Dis_ASM2: String;

  Z80A_REG_PC_Back: LongInt; //직전실행번지

  Go_Z80A_Dis_ADDR: LongInt;
  Gs_Z80A_Dis_DUMP: String;
  Gs_Z80A_Dis_ASM1: String;
  Gs_Z80A_Dis_ASM2: String;

  Gi_Z80A_Reg_Pc_Size: LongInt; //CALL명령만실행시다음라인번지계산용

implementation

uses
  msxZ80A_Asm, msxZ80A, msxMEM, msxVDT,
  untFunction;

procedure gt_ADD_PC_Dis(iSz: Integer);
var
  i: Integer;
begin
  Z80A_Dis_ADDR := Z80A_REG_PC_DASM_ST;
  for i := 0 to (iSz - 1) do
    Z80A_Dis_DUMP := Z80A_Dis_DUMP + gsGetLngToHex8(gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + i));
  Go_Z80A_Dis_ADDR := Z80A_REG_PC_DASM_ST;
  Gs_Z80A_Dis_DUMP := Z80A_Dis_DUMP;
  Gs_Z80A_Dis_ASM1 := Z80A_Dis_ASM1;
  Gs_Z80A_Dis_ASM2 := Z80A_Dis_ASM2;
  Z80A_REG_PC_DASM_ST := goGetLngToLng(Z80A_REG_PC_DASM_ST + iSz);
  Z80A_Dis_ADDR := 0;
  Z80A_Dis_DUMP := '';
  Z80A_Dis_ASM1 := '';
  Z80A_Dis_ASM2 := '';
end;

function gb_GET_MSX_MEMORY(oAddr: Word): Byte;
var
  iRet: Byte;
begin
  iRet := 0;

  if ((oAddr >= 0) And (oAddr <= 16383)) then //Page#0 [0000~3FFF]
    begin
      if (Gi_MSX_SLOT = 0) then iRet := MSX_MEM[Gi_MEM_PAGE0, oAddr]; //기본Slot
      if (Gi_MSX_SLOT = 1) then iRet := MSX_MEM[0, oAddr]; //Slot#0
      if (Gi_MSX_SLOT = 2) then iRet := MSX_MEM[1, oAddr]; //Slot#1
      if (Gi_MSX_SLOT = 3) then iRet := MSX_MEM[2, oAddr]; //Slot#2
      if (Gi_MSX_SLOT = 4) then iRet := MSX_MEM[3, oAddr]; //Slot#3
      if (Gi_MSX_SLOT = 5) then iRet := MSX_VRAM[oAddr]; //VRAM
    end;

  if ((oAddr >= 16384) And (oAddr <= 32767)) then //Page#1 [4000~7FFF]
    begin
      if (Gi_MSX_SLOT = 0) then iRet := MSX_MEM[Gi_MEM_PAGE1, oAddr]; //기본Slot
      if (Gi_MSX_SLOT = 1) then iRet := MSX_MEM[0, oAddr]; //Slot#0
      if (Gi_MSX_SLOT = 2) then iRet := MSX_MEM[1, oAddr]; //Slot#1
      if (Gi_MSX_SLOT = 3) then iRet := MSX_MEM[2, oAddr]; //Slot#2
      if (Gi_MSX_SLOT = 4) then iRet := MSX_MEM[3, oAddr]; //Slot#3
      if (Gi_MSX_SLOT = 5) then iRet := MSX_VRAM[oAddr]; //VRAM
    end;

  if ((oAddr >= 32768) And (oAddr <= 49151)) then //Page#2 [8000~BFFF]
    begin
      if (Gi_MSX_SLOT = 0) then iRet := MSX_MEM[Gi_MEM_PAGE2, oAddr]; //기본Slot
      if (Gi_MSX_SLOT = 1) then iRet := MSX_MEM[0, oAddr]; //Slot#0
      if (Gi_MSX_SLOT = 2) then iRet := MSX_MEM[1, oAddr]; //Slot#1
      if (Gi_MSX_SLOT = 3) then iRet := MSX_MEM[2, oAddr]; //Slot#2
      if (Gi_MSX_SLOT = 4) then iRet := MSX_MEM[3, oAddr]; //Slot#3
      if (Gi_MSX_SLOT = 5) then iRet := MSX_VRAM[oAddr]; //VRAM
    end;

  if ((oAddr >= 49152) And (oAddr <= 65535)) then //Page#3 [C000~FFFF]
    begin
      if (Gi_MSX_SLOT = 0) then iRet := MSX_MEM[Gi_MEM_PAGE3, oAddr]; //기본Slot
      if (Gi_MSX_SLOT = 1) then iRet := MSX_MEM[0, oAddr]; //Slot#0
      if (Gi_MSX_SLOT = 2) then iRet := MSX_MEM[1, oAddr]; //Slot#1
      if (Gi_MSX_SLOT = 3) then iRet := MSX_MEM[2, oAddr]; //Slot#2
      if (Gi_MSX_SLOT = 4) then iRet := MSX_MEM[3, oAddr]; //Slot#3
      if (Gi_MSX_SLOT = 5) then iRet := MSX_VRAM[oAddr]; //VRAM
    end;

  Result := iRet;
end;

procedure gt_PUT_MSX_MEMORY(oAddr: Word; iVal: Byte);
label
  ExitProc;
begin
  if ((oAddr >= 0) And (oAddr <= 16383)) then //Page#0 [0000~3FFF]
    begin
      if (Gi_MSX_SLOT = 0) then MSX_MEM[Gi_MEM_PAGE0, oAddr] := iVal; //기본Slot
      if (Gi_MSX_SLOT = 1) then MSX_MEM[0, oAddr] := iVal; //Slot#0
      if (Gi_MSX_SLOT = 2) then MSX_MEM[1, oAddr] := iVal; //Slot#1
      if (Gi_MSX_SLOT = 3) then MSX_MEM[2, oAddr] := iVal; //Slot#2
      if (Gi_MSX_SLOT = 4) then MSX_MEM[3, oAddr] := iVal; //Slot#3
      if (Gi_MSX_SLOT = 5) then MSX_VRAM[oAddr] := iVal; //VRAM
    end;

  if ((oAddr >= 16384) And (oAddr <= 32767)) then //Page#1 [4000~7FFF]
    begin
      if (Gi_MSX_SLOT = 0) then MSX_MEM[Gi_MEM_PAGE1, oAddr] := iVal; //기본Slot
      if (Gi_MSX_SLOT = 1) then MSX_MEM[0, oAddr] := iVal; //Slot#0
      if (Gi_MSX_SLOT = 2) then MSX_MEM[1, oAddr] := iVal; //Slot#1
      if (Gi_MSX_SLOT = 3) then MSX_MEM[2, oAddr] := iVal; //Slot#2
      if (Gi_MSX_SLOT = 4) then MSX_MEM[3, oAddr] := iVal; //Slot#3
      if (Gi_MSX_SLOT = 5) then MSX_VRAM[oAddr] := iVal; //VRAM
    end;

  if ((oAddr >= 32768) And (oAddr <= 49151)) then //Page#2 [8000~BFFF]
    begin
      if (Gi_MSX_SLOT = 0) then MSX_MEM[Gi_MEM_PAGE2, oAddr] := iVal; //기본Slot
      if (Gi_MSX_SLOT = 1) then MSX_MEM[0, oAddr] := iVal; //Slot#0
      if (Gi_MSX_SLOT = 2) then MSX_MEM[1, oAddr] := iVal; //Slot#1
      if (Gi_MSX_SLOT = 3) then MSX_MEM[2, oAddr] := iVal; //Slot#2
      if (Gi_MSX_SLOT = 4) then MSX_MEM[3, oAddr] := iVal; //Slot#3
      if (Gi_MSX_SLOT = 5) then MSX_VRAM[oAddr] := iVal; //VRAM
    end;

  if ((oAddr >= 49152) And (oAddr <= 65535)) then //Page#3 [C000~FFFF]
    begin
      if (Gi_MSX_SLOT = 0) then MSX_MEM[Gi_MEM_PAGE3, oAddr] := iVal; //기본Slot
      if (Gi_MSX_SLOT = 1) then MSX_MEM[0, oAddr] := iVal; //Slot#0
      if (Gi_MSX_SLOT = 2) then MSX_MEM[1, oAddr] := iVal; //Slot#1
      if (Gi_MSX_SLOT = 3) then MSX_MEM[2, oAddr] := iVal; //Slot#2
      if (Gi_MSX_SLOT = 4) then MSX_MEM[3, oAddr] := iVal; //Slot#3
      if (Gi_MSX_SLOT = 5) then MSX_VRAM[oAddr] := iVal; //VRAM
    end;

ExitProc:
end;

procedure gt_GET_PC_DATA_16(var Reg16: LongInt);
begin
  Reg16 := goGetIntHLToLng(gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 2)), gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 1)));
end;

procedure gt_GET_PC_DATA_16ToHL(var RegH: Integer; var RegL: Integer);
begin
  RegH := gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 2));
  RegL := gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 1));
end;

procedure gt_GET_PC_DATA_8(var reg8: Integer);
begin
  reg8 := gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 1));
end;

function go_GET_PC_DATA_16: LongInt;
begin
  Result := goGetIntHLToLng(gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 2)), gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 1)));
end;

function gi_GET_PC_DATA_8: Integer;
begin
  Result := gb_GET_MSX_MEMORY(goGetLngToLng(Z80A_REG_PC + 1));
end;

function gs_GET_PC_DATA_16_DASM: String;
var
  T: String;
begin
  T := gsGetLngToHex16(goGetIntHLToLng(gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM + 2), gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM + 1)));
  Go_MSX_DisASM_ADR_Ref := goGetHex16ToLng(T); //Jump&Call Label
  if (gmsLeft(T, 1) >= 'A') then T := '0' + T;
  T := T + 'H';
  Result := T;
end;

function gs_GET_PC_DATA_8_DASM(iSel: Integer = 0): String;
var
  T: String;
begin
  T := gsGetLngToHex8(gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM + 1 + iSel));
  if (gmsLeft(T, 1) >= 'A') then T := '0' + T;
  T := T + 'H';
  Result := T;
end;

function gi_GET_PC_DATA_8_DASM: Integer;
begin
  Result := gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM + 1);
end;

function gs_GET_PC_DATA_IDX_8_DASM(iSel: Integer = 0): String;
var
  T: String; idx: Integer;
begin
  idx := gi_GET_IDX_8(gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM + 1 + iSel));
  if (idx >= 0) then
    T := '+' + gmsCStr(idx)
  else
    T := gmsCStr(idx)
  ;
  Result := T;
end;

function gs_GET_HEX_8(iVal: Integer): String;
var
  T: String;
begin
  T := gsGetLngToHex8(iVal);
  if (gmsLeft(T, 1) >= 'A') then T := '0' + T;
  T := T + 'H';
  Result := T;
end;

function gi_GET_IDX_8(iVal: Integer): Integer;
begin
  if (iVal > 127) then
    Result := iVal - 256
  else
    Result := iVal
  ;
end;

function gi_GET_16_Sign(oVal: LongInt): Integer;
begin
  //Sign 16 Bit (1:음수,0:양수)
  if (oVal > 32767) then
    Result := 1
  else
    Result := 0
  ;
end;

function gi_GET_8_Sign(iVal: Integer): Integer;
begin
  //Sign 8 Bit (1:음수,0:양수)
  if (iVal > 127) then
    Result := 1
  else
    Result := 0
  ;
end;

function gi_GET_16_Zero(oVal: LongInt): Integer;
begin
  //Zero 16 Bit (1:Zero1,0:Other)
  if (oVal = 0) then
    Result := 1
  else
    Result := 0
  ;
end;

function gi_GET_8_Zero(iVal: Integer): Integer;
begin
  //Zero 8 Bit (1:Zero1,0:Other)
  if (iVal = 0) then
    Result := 1
  else
    Result := 0
  ;
end;

function gi_GET_BIT1_Even(iVal: Integer): Integer;
begin
  //Parity 8 Bit (1:Even,0:Odd)
  Result := Gi_P_Table[iVal];
end;

//Z80A 기계어 - Main instructions
procedure gt_Move_Z80A_CODE;
var
  idx, iSz: Integer; Reg16: LongInt; reg8: Integer;
begin
  Z80A_REG_PC_Back := Z80A_REG_PC; //직전실행번지
  Gi_Z80A_Reg_Pc_Size := 0; //CALL명령만실행시다음라인번지계산용
  Z80A_REG_IDX_DASM := 0;
  idx := gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM);
  iSz := 1;
  Case (idx) of
    $00: //NOP
      begin
        Z80A_Dis_ASM1 := 'NOP';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $01: //LD BC,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'BC,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $02: //LD (BC),A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(BC),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $03: //INC BC
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $04: //INC B
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $05: //DEC B
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $06: //LD B,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $07: //RLCA
      begin
        Z80A_Dis_ASM1 := 'RLCA';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $08: //EX AF,AF
      begin
        Z80A_Dis_ASM1 := 'EX';
        Z80A_Dis_ASM2 := 'AF,AF`';
        gt_ADD_PC_Dis(iSz);
      end;
    $09: //ADD HL,BC
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'HL,BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $0A: //LD A,(BC)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(BC)';
        gt_ADD_PC_Dis(iSz);
      end;
    $0B: //DEC BC
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $0C: //INC C
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $0D: //DEC C
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $0E: //LD C,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $0F: //RRCA
      begin
        Z80A_Dis_ASM1 := 'RRCA';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $10: //DJNZ idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'DJNZ';
        Z80A_Dis_ASM2 := gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $11: //LD DE,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'DE,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $12: //LD (DE),A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(DE),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $13: //INC DE
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $14: //INC D
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $15: //DEC D
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $16: //LD D,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $17: //RLA
      begin
        Z80A_Dis_ASM1 := 'RLA';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $18: //JR idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'JR';
        Z80A_Dis_ASM2 := gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //ADD HL,DE
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'HL,DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $1A: //LD A,(DE)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(DE)';
        gt_ADD_PC_Dis(iSz);
      end;
    $1B: //DEC DE
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $1C: //INC E
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $1D: //DEC E
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $1E: //LD E,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $1F: //RRA
      begin
        Z80A_Dis_ASM1 := 'RRA';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $20: //JR NZ,idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'JR';
        Z80A_Dis_ASM2 := 'NZ,' + gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //LD HL,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'HL,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //LD (nn),HL
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //INC HL
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //INC H
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $25: //DEC H
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //LD H,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $27: //DAA
      begin
        Z80A_Dis_ASM1 := 'DAA';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $28: //JR Z,idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'JR';
        Z80A_Dis_ASM2 := 'Z,' + gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //ADD HL,HL
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'HL,HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //LD HL,(nn)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'HL,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //DEC HL
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //INC L
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //DEC L
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //LD L,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $2F: //CPL
      begin
        Z80A_Dis_ASM1 := 'CPL';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $30: //JR NC,idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'JR';
        Z80A_Dis_ASM2 := 'NC,' + gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $31: //LD SP,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'SP,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $32: //LD (nn),A
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $33: //INC SP
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //INC (HL)
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //DEC (HL)
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //LD (HL),n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $37: //SCF
      begin
        Z80A_Dis_ASM1 := 'SCF';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $38: //JR C,idx
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'JR';
        Z80A_Dis_ASM2 := 'C,' + gsGetLngToHex16_Disp(Z80A_REG_PC_DASM_ST + iSz + gi_GET_IDX_8(gi_GET_PC_DATA_8_DASM));
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //ADD HL,SP
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'HL,SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $3A: //LD A,(nn)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $3B: //DEC SP
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $3C: //INC A
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $3D: //DEC A
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $3E: //LD A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $3F: //CCF
      begin
        Z80A_Dis_ASM1 := 'CCF';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $40: //LD B,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $41: //LD B,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $42: //LD B,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $43: //LD B,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //LD B,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //LD B,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //LD B,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $47: //LD B,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $48: //LD C,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $49: //LD C,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $4A: //LD C,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $4B: //LD C,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //LD C,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //LD C,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //LD C,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $4F: //LD C,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $50: //LD D,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $51: //LD D,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $52: //LD D,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $53: //LD D,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //LD D,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //LD D,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //LD D,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $57: //LD D,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $58: //LD E,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $59: //LD E,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $5A: //LD E,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $5B: //LD E,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //LD E,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //LD E,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //LD E,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $5F: //LD E,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //LD H,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //LD H,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //LD H,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //LD H,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //LD H,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //LD H,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //LD H,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //LD H,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //LD L,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //LD L,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //LD L,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //LD L,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //LD L,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //LD L,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //LD L,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //LD L,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //LD (HL),B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //LD (HL),C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //LD (HL),D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //LD (HL),E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //LD (HL),H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //LD (HL),L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $76: //HALT
      begin
        Z80A_Dis_ASM1 := 'HALT';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //LD (HL),A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(HL),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $78: //LD A,B
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $79: //LD A,C
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $7A: //LD A,D
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $7B: //LD A,E
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //LD A,H
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //LD A,L
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //LD A,(HL)
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $7F: //LD A,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $80: //ADD A,B
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $81: //ADD A,C
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $82: //ADD A,D
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $83: //ADD A,E
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //ADD A,H
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //ADD A,L
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //ADD A,(HL)
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $87: //ADD A,A
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $88: //ADC A,B
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $89: //ADC A,C
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $8A: //ADC A,D
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $8B: //ADC A,E
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //ADC A,H
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //ADC A,L
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //ADC A,(HL)
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $8F: //ADC A,A
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $90: //SUB A,B
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $91: //SUB A,C
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $92: //SUB A,D
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $93: //SUB A,E
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //SUB A,H
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //SUB A,L
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //SUB A,(HL)
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $97: //SUB A,A
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $98: //SBC A,B
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $99: //SBC A,C
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $9A: //SBC A,D
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $9B: //SBC A,E
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //SBC A,H
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //SBC A,L
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //SBC A,(HL)
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $9F: //SBC A,A
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A0: //AND A,B
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A1: //AND A,C
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $A2: //AND A,D
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $A3: //AND A,E
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //AND A,H
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //AND A,L
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //AND A,(HL)
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $A7: //AND A,A
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A8: //XOR A,B
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A9: //XOR A,C
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $AA: //XOR A,D
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $AB: //XOR A,E
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //XOR A,H
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //XOR A,L
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //XOR A,(HL)
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $AF: //XOR A,A
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B0: //OR A,B
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B1: //OR A,C
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $B2: //OR A,D
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $B3: //OR A,E
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //OR A,H
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //OR A,L
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //OR A,(HL)
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $B7: //OR A,A
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B8: //CP B
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B9: //CP C
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $BA: //CP D
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $BB: //CP E
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //CP H
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //CP L
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //CP (HL)
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $BF: //CP A
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C0: //RET NZ
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'NZ';
        gt_ADD_PC_Dis(iSz);
      end;
    $C1: //POP BC
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $C2: //JP NZ,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'NZ,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz)
      end;
    $C3: //JP nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz)
      end;
    $C4: //NZ,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'NZ,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz)
      end;
    $C5: //PUSH BC
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $C6: //ADD A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $C7: //RST 00H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '00H';
        gt_ADD_PC_Dis(iSz);
      end;
    $C8: //RET Z
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'Z';
        gt_ADD_PC_Dis(iSz);
      end;
    $C9: //RET
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $CA: //JP Z,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'Z,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //CB - Bit instructions
      begin
        gt_Move_z80a_CODE_CB;
      end;
    $CC: //Z,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'Z,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $CD: //nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $CE: //ADC A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $CF: //RST 08H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '08H';
        gt_ADD_PC_Dis(iSz);
      end;
    $D0: //RET NC
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'NC';
        gt_ADD_PC_Dis(iSz);
      end;
    $D1: //POP DE
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $D2: //JP NC,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'NC,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz)
      end;
    $D3: //OUT (p),A
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D4: //NC,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'NC,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $D5: //PUSH DE
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $D6: //SUB A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $D7: //RST 10H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '10H';
        gt_ADD_PC_Dis(iSz)
      end;
    $D8: //RET C
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $D9: //EXX
      begin
        Z80A_Dis_ASM1 := 'EXX';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $DA: //JP C,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'C,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $DB: //IN A,(p)
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'A,(' + gs_GET_PC_DATA_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $DC: //C,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'C,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $DD: //DD - IX instructions
      begin
        gt_Move_z80a_CODE_DD;
      end;
    $DE: //SBC A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $DF: //RST 18H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '18H';
        gt_ADD_PC_Dis(iSz);
      end;
    $E0: //RET PO
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'PO';
        gt_ADD_PC_Dis(iSz);
      end;
    $E1: //POP HL
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $E2: //JP PO,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'PO,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //EX (SP),HL
      begin
        Z80A_Dis_ASM1 := 'EX';
        Z80A_Dis_ASM2 := '(SP),HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $E4: //PO,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'PO,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //PUSH HL
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $E6: //AND A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $E7: //RST 20H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '20H';
        gt_ADD_PC_Dis(iSz);
      end;
    $E8: //RET PE
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'PE';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //JP (HL)
      begin
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $EA: //JP PE,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'PE,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $EB: //EX DE,HL
      begin
        Z80A_Dis_ASM1 := 'EX';
        Z80A_Dis_ASM2 := 'DE,HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $EC: //PE,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'PE,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $ED: //ED - Extended instructions
      begin
        gt_Move_z80a_CODE_ED;
      end;
    $EE: //XOR A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $EF: //RST 28H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '28H';
        gt_ADD_PC_Dis(iSz);
      end;
    $F0: //RET P
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'P';
        gt_ADD_PC_Dis(iSz);
      end;
    $F1: //POP AF
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'AF';
        gt_ADD_PC_Dis(iSz);
      end;
    $F2: //JP P,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'P,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $F3: //DI
      begin
        Z80A_Dis_ASM1 := 'DI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $F4: //P,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'P,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $F5: //PUSH AF
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'AF';
        gt_ADD_PC_Dis(iSz);
      end;
    $F6: //OR A,n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $F7: //RST 30H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '30H';
        gt_ADD_PC_Dis(iSz);
      end;
    $F8: //RET M
      begin
        Z80A_Dis_ASM1 := 'RET';
        Z80A_Dis_ASM2 := 'M';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //LD SP,HL
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'SP,HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $FA: //JP M,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := 'M,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $FB: //EI
      begin
        Z80A_Dis_ASM1 := 'EI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $FC: //M,nn
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CALL';
        Z80A_Dis_ASM2 := 'M,' + gs_GET_PC_DATA_16_DASM;
        Gi_MSX_DisASM_MEM_Use[Go_MSX_DisASM_ADR_Ref] := 1; //Jump&Label
        gt_ADD_PC_Dis(iSz);
      end;
    $FD: //FD - IY instruction
      begin
        gt_Move_z80a_CODE_FD;
      end;
    $FE: //CP n
      begin
        iSz := 2;
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $FF: //RST 38H
      begin
        Z80A_Dis_ASM1 := 'RST';
        Z80A_Dis_ASM2 := '38H';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //실행안됨
  End;
end;

//Z80A 기계어 - CB - Bit instructions
procedure gt_Move_z80a_CODE_CB;
var
  idx, iSz, reg8: Integer;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM);
  iSz := 2;
  Case (idx) of
    $00: //RLC B
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $01: //RLC C
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $02: //RLC D
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $03: //RLC E
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $04: //RLC H
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $05: //RLC L
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $06: //RLC (HL)
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $07: //RLC A
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $08: //RRC B
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $09: //RRC C
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $0A: //RRC D
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $0B: //RRC E
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $0C: //RRC H
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $0D: //RRC L
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $0E: //RRC (HL)
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $0F: //RRC A
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $10: //RL B
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $11: //RL C
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $12: //RL D
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $13: //RL E
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $14: //RL H
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $15: //RL L
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $16: //RL (HL)
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $17: //RL A
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $18: //RR B
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //RR C
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $1A: //RR D
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $1B: //RR E
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $1C: //RR H
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $1D: //RR L
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $1E: //RR (HL)
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $1F: //RR A
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $20: //SLA B
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //SLA C
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //SLA D
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //SLA E
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //SLA H
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $25: //SLA L
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //SLA (HL)
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $27: //SLA A
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $28: //SRA B
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //SRA C
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //SRA D
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //SRA E
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //SRA H
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //SRA L
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //SRA (HL)
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $2F: //SRA A
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $30: //SLL B //@@@@@ SLL,SLS
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $31: //SLL C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $32: //SLL D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $33: //SLL E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //SLL H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //SLL L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //SLL (HL) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $37: //SLL A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $38: //SRL B
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'B';
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //SRL C
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'C';
        gt_ADD_PC_Dis(iSz);
      end;
    $3A: //SRL D
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'D';
        gt_ADD_PC_Dis(iSz);
      end;
    $3B: //SRL E
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'E';
        gt_ADD_PC_Dis(iSz);
      end;
    $3C: //SRL H
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'H';
        gt_ADD_PC_Dis(iSz);
      end;
    $3D: //SRL L
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'L';
        gt_ADD_PC_Dis(iSz);
      end;
    $3E: //SRL (HL)
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $3F: //SRL A
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := 'A';
        gt_ADD_PC_Dis(iSz);
      end;
    $40: //BIT 0,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $41: //BIT 0,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $42: //BIT 0,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $43: //BIT 0,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //BIT 0,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //BIT 0,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //BIT 0,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $47: //BIT 0,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $48: //BIT 1,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $49: //BIT 1,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $4A: //BIT 1,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $4B: //BIT 1,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //BIT 1,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //BIT 1,L
      begin
         Z80A_Dis_ASM1 := 'BIT';
         Z80A_Dis_ASM2 := '1,L';
         gt_ADD_PC_Dis(iSz);
      end;
    $4E: //BIT 1,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $4F: //BIT 1,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $50: //BIT 2,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $51: //BIT 2,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $52: //BIT 2,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $53: //BIT 2,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //BIT 2,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //BIT 2,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //BIT 2,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $57: //BIT 2,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $58: //BIT 3,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $59: //BIT 3,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $5A: //BIT 3,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $5B: //BIT 3,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //BIT 3,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //BIT 3,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //BIT 3,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $5F: //BIT 3,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //BIT 4,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //BIT 4,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //BIT 4,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //BIT 4,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //BIT 4,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //BIT 4,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //BIT 4,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //BIT 4,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //BIT 5,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //BIT 5,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //BIT 5,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //BIT 5,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //BIT 5,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //BIT 5,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //BIT 5,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //BIT 5,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //BIT 6,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //BIT 6,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //BIT 6,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //BIT 6,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //BIT 6,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //BIT 6,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $76: //BIT 6,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //BIT 6,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $78: //BIT 7,B
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $79: //BIT 7,C
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $7A: //BIT 7,D
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $7B: //BIT 7,E
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //BIT 7,H
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //BIT 7,L
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //BIT 7,(HL)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $7F: //BIT 7,A
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $80: //RES 0,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $81: //RES 0,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $82: //RES 0,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $83: //RES 0,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //RES 0,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //RES 0,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //RES 0,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $87: //RES 0,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $88: //RES 1,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $89: //RES 1,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $8A: //RES 1,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $8B: //RES 1,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //RES 1,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //RES 1,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //RES 1,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $8F: //RES 1,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $90: //RES 2,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $91: //RES 2,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $92: //RES 2,D
      begin
         Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $93: //RES 2,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //RES 2,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //RES 2,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //RES 2,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $97: //RES 2,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $98: //RES 3,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $99: //RES 3,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $9A: //RES 3,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $9B: //RES 3,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //RES 3,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //RES 3,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //RES 3,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $9F: //RES 3,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A0: //RES 4,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A1: //RES 4,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $A2: //RES 4,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $A3: //RES 4,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //RES 4,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //RES 4,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //RES 4,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $A7: //RES 4,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A8: //RES 5,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A9: //RES 5,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $AA: //RES 5,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $AB: //RES 5,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //RES 5,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //RES 5,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //RES 5,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $AF: //RES 5,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B0: //RES 6,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B1: //RES 6,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $B2: //RES 6,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $B3: //RES 6,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //RES 6,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //RES 6,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //RES 6,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $B7: //RES 6,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B8: //RES 7,B
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B9: //RES 7,C
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $BA: //RES 7,D
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $BB: //RES 7,E
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //RES 7,H
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //RES 7,L
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //RES 7,(HL)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $BF: //RES 7,A
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C0: //SET 0,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C1: //SET 0,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $C2: //SET 0,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $C3: //SET 0,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $C4: //SET 0,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $C5: //SET 0,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $C6: //SET 0,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $C7: //SET 0,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C8: //SET 1,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C9: //SET 1,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $CA: //SET 1,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //SET 1,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $CC: //SET 1,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $CD: //SET 1,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $CE: //SET 1,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $CF: //SET 1,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D0: //SET 2,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D1: //SET 2,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $D2: //SET 2,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $D3: //SET 2,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $D4: //SET 2,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $D5: //SET 2,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $D6: //SET 2,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $D7: //SET 2,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D8: //SET 3,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D9: //SET 3,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $DA: //SET 3,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $DB: //SET 3,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $DC: //SET 3,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $DD: //SET 3,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $DE: //SET 3,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $DF: //SET 3,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E0: //SET 4,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E1: //SET 4,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $E2: //SET 4,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //SET 4,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $E4: //SET 4,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //SET 4,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $E6: //SET 4,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $E7: //SET 4,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E8: //SET 5,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //SET 5,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $EA: //SET 5,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $EB: //SET 5,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $EC: //SET 5,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $ED: //SET 5,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $EE: //SET 5,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $EF: //SET 5,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F0: //SET 6,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F1: //SET 6,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $F2: //SET 6,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $F3: //SET 6,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $F4: //SET 6,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $F5: //SET 6,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $F6: //SET 6,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $F7: //SET 6,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F8: //SET 7,B
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //SET 7,C
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $FA: //SET 7,D
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $FB: //SET 7,E
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $FC: //SET 7,H
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,H';
        gt_ADD_PC_Dis(iSz);
      end;
    $FD: //SET 7,L
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,L';
        gt_ADD_PC_Dis(iSz);
      end;
    $FE: //SET 7,(HL)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(HL)';
        gt_ADD_PC_Dis(iSz);
      end;
    $FF: //SET 7,A
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,A';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //실행안됨
  End;
end;

//Z80A 기계어 - ED - Extended instructions
procedure gt_Move_z80a_CODE_ED;
var
  idx, iSz: Integer; Reg16: LongInt; reg8: Integer;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := gb_GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM);
  iSz := 2;
  Case (idx) of
    $40: //IN B,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'B,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $41: //OUT (C),B
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $42: //SBC HL,BC
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'HL,BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $43: //LD (nn),BC
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //NEG
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //IM 0
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '0';
        gt_ADD_PC_Dis(iSz);
      end;
    $47: //LD I,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'I,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $48: //IN C,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'C,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $49: //OUT (C),C
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $4A: //ADC HL,BC
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'HL,BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $4B: //LD BC,(nn)
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'BC,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //RETI
      begin
        Z80A_Dis_ASM1 := 'RETI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //IM 0/1 //@@@@@
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '0/1';
        gt_ADD_PC_Dis(iSz);
      end;
    $4F: //LD R,A
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'R,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $50: //IN D,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'D,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $51: //OUT (C),D
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $52: //SBC HL,DE
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'HL,DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $53: //LD (nn),DE
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //IM 1
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '1';
        gt_ADD_PC_Dis(iSz);
      end;
    $57: //LD A,I
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,I';
        gt_ADD_PC_Dis(iSz);
      end;
    $58: //IN E,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'E,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $59: //OUT (C),E
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $5A: //ADC HL,DE
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'HL,DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $5B: //LD DE,(nn)
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'DE,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //IM 2
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '2';
        gt_ADD_PC_Dis(iSz);
      end;
    $5F: //LD A,R
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,R';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //IN H,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'H,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //OUT (C),H
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //SBC HL,HL
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'HL,HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //LD (nn),HL //@@@@@
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //IM 0
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '0';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //RRD
      begin
        Z80A_Dis_ASM1 := 'RRD';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //IN L,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'L,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //OUT (C),L
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //ADC HL,HL
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'HL,HL';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //LD HL,(nn) //@@@@@
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'HL,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //IM 0/1 //@@@@@
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '0/1';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //RLD
      begin
        Z80A_Dis_ASM1 := 'RLD';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //IN (C) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := '(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //OUT (C),0 //@@@@@
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),0';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //SBC HL,SP
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'HL,SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //LD (nn),SP
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $76: //IM 1
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '1';
        gt_ADD_PC_Dis(iSz);
      end;
    $78: //IN A,(C)
      begin
        Z80A_Dis_ASM1 := 'IN';
        Z80A_Dis_ASM2 := 'A,(C)';
        gt_ADD_PC_Dis(iSz);
      end;
    $79: //OUT (C),A
      begin
        Z80A_Dis_ASM1 := 'OUT';
        Z80A_Dis_ASM2 := '(C),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $7A: //ADC HL,SP
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'HL,SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $7B: //LD SP,(nn)
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'SP,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
     end;
    $7C: //NEG //@@@@@
      begin
        Z80A_Dis_ASM1 := 'NEG';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //RETN
      begin
        Z80A_Dis_ASM1 := 'RETN';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //IM 2
      begin
        Z80A_Dis_ASM1 := 'IM';
        Z80A_Dis_ASM2 := '2';
        gt_ADD_PC_Dis(iSz);
      end;
    $A0: //LDI
      begin
        Z80A_Dis_ASM1 := 'LDI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $A1: //CPI
      begin
        Z80A_Dis_ASM1 := 'CPI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $A2: //INI
      begin
        Z80A_Dis_ASM1 := 'INI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $A3: //OUTI
      begin
        Z80A_Dis_ASM1 := 'OUTI';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $A8: //LDD
      begin
        Z80A_Dis_ASM1 := 'LDD';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $A9: //CPD
      begin
        Z80A_Dis_ASM1 := 'CPD';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $AA: //IND
      begin
        Z80A_Dis_ASM1 := 'IND';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $AB: //OUTD
      begin
        Z80A_Dis_ASM1 := 'OUTD';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B0: //LDIR
      begin
        Z80A_Dis_ASM1 := 'LDIR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B1: //CPIR
      begin
        Z80A_Dis_ASM1 := 'CPIR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B2: //INIR
      begin
        Z80A_Dis_ASM1 := 'INIR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B3: //OTIR
      begin
        Z80A_Dis_ASM1 := 'OTIR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B8: //LDDR
      begin
        Z80A_Dis_ASM1 := 'LDDR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $B9: //CPDR
      begin
        Z80A_Dis_ASM1 := 'CPDR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $BA: //INDR
      begin
        Z80A_Dis_ASM1 := 'INDR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
    $BB: //OTDR
      begin
        Z80A_Dis_ASM1 := 'OTDR';
        Z80A_Dis_ASM2 := '';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //??
    begin
      Z80A_Dis_ASM1 := '?';
      Z80A_Dis_ASM2 := '';
      gt_ADD_PC_Dis(Z80A_REG_IDX_DASM + 1);
    end;
  End;
end;

//Z80A 기계어 - DD - IX instructions
procedure gt_Move_z80a_CODE_DD;
var
  idx, iSz: Integer; Reg16: LongInt; reg8: Integer; GetIxyIdx: LongInt;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM);
  iSz := 2;
  GetIxyIdx := goGetLngToLng(Z80A_REG_IX + gi_GET_IDX_8(gi_GET_PC_DATA_8));
  Case (idx) of
    $09: //ADD IX,BC
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IX,BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //ADD IX,DE
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IX,DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //LD IX,nn
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IX,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //LD (nn),IX
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //INC IX
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //INC IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $25: //DEC IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //LD IXH,n //@@@@@
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //ADD IX,IX
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IX,IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //LD IX,(nn)
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IX,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //DEC IX
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //INC IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //DEC IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //LD IXL,n //@@@@@
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //INC (IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //DEC (IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //LD (IX+d),n
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),' + gs_GET_PC_DATA_8_DASM(1);
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //ADD IX,SP
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IX,SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //LD B,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //LD B,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //LD B,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //LD C,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //LD C,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //LD C,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //LD D,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //LD D,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //LD D,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //LD E,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //LD E,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //LD E,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz)
      end;
    $60: //LD IXH,B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //LD IXH,C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //LD IXH,D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //LD IXH,E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //LD IXH,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //LD IXH,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //LD H,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //LD IXH,A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXH,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //LD IXL,B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //LD IXL,C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //LD IXL,D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //LD IXL,E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //LD IXL,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //LD IXL,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //LD L,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //LD IXL,A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IXL,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //LD (IX+d),B
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //LD (IX+d),C
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //LD (IX+d),D
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //LD (IX+d),E
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //LD (IX+d),H
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //LD (IX+d),L
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //LD (IX+d),A
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //LD A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //LD A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //LD A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //ADD A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //ADD A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //ADD A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //ADC A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //ADC A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //ADC A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //SUB A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //SUB A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //SUB A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //SBC A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //SBC A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //SBC A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //AND A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //AND A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //AND A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //XOR A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //XOR A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //XOR A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //OR A,IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //OR A,IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //OR A,(IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //CP IXH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'IXH';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //CP IXL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'IXL';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //CP (IX+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //DD-CB - IX bit instruction
      begin
        gt_Move_z80a_CODE_DD_CB;
      end;
    $E1: //POP IX
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //EX (SP),IX
      begin
        Z80A_Dis_ASM1 := 'EX';
        Z80A_Dis_ASM2 := '(SP),IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //PUSH IX
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'IX';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //JP (IX)
      begin
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := '(IX)';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //LD SP,IX
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'SP,IX';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //??
    begin
      Z80A_Dis_ASM1 := '?';
      Z80A_Dis_ASM2 := '';
      gt_ADD_PC_Dis(Z80A_REG_IDX_DASM + 1);
    end;
  End;
end;

//Z80A 기계어 - DD - CB  - IX bit instruction
procedure gt_Move_z80a_CODE_DD_CB;
var
  idx, iSz: Integer; GetIxyIdx: LongInt; GetIdxMem8: Integer;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + 3);
  GetIxyIdx := goGetLngToLng(Z80A_REG_IX + gi_GET_IDX_8(GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + 2)));
  iSz := 4;
  GetIdxMem8 := gb_GET_MSX_MEMORY(GetIxyIdx);
  Case (idx) of
    $00: //RLC (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $01: //RLC (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $02: //RLC (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $03: //RLC (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $04: //RLC (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $05: //RLC (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $06: //RLC (IX+d)
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $07: //RLC (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $08: //RRC (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $09: //RRC (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $0A: //RRC (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $0B: //RRC (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $0C: //RRC (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $0D: //RRC (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $0E: //RRC (IX+d)
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $0F: //RRC (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $10: //RL (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $11: //RL (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $12: //RL (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $13: //RL (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $14: //RL (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $15: //RL (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $16: //RL,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $17: //RL (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $18: //RR (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //RR (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $1A: //RR (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $1B: //RR (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $1C: //RR (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $1D: //RR (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $1E: //RR (IX+d)
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $1F: //RR (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $20: //SLA (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //SLA (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //SLA (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //SLA (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //SLA (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $25: //SLA (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //SLA,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $27: //SLA (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $28: //SRA (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //SRA (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //SRA (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //SRA (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //SRA (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //SRA (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //SRA,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $2F: //SRA (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $30: //SLL (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $31: //SLL (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $32: //SLL (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $33: //SLL (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //SLL (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //SLL (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //SLL (IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $37: //SLL (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $38: //SRL (IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //SRL (IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $3A: //SRL (IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $3B: //SRL (IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $3C: //SRL (IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $3D: //SRL (IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $3E: //SRL,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $3F: //SRL (IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $40: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $41: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $42: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $43: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //BIT 0,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz)
      end;
    $47: //BIT 0,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $48: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $49: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4A: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4B: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //BIT 1,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4F: //BIT 1,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $50: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $51: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $52: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $53: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //BIT 2,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $57: //BIT 2,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $58: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $59: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5A: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5B: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //BIT 3,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5F: //BIT 3,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //BIT 4,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //BIT 4,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //BIT 5,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //BIT 5,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $76: //BIT 6,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //BIT 6,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $78: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $79: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7A: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7B: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //BIT 7,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7F: //BIT 7,(IX+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $80: //RES 0,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $81: //RES 0,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $82: //RES 0,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $83: //RES 0,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //RES 0,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //RES 0,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //RES 0,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $87: //RES 0,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $88: //RES 1,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $89: //RES 1,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $8A: //RES 1,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $8B: //RES 1,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //RES 1,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //RES 1,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //RES 1,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $8F: //RES 1,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $90: //RES 2,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $91: //RES 2,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $92: //RES 2,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $93: //RES 2,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //RES 2,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //RES 2,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //RES 2,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $97: //RES 2,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $98: //RES 3,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $99: //RES 3,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $9A: //RES 3,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $9B: //RES 3,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //RES 3,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //RES 3,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //RES 3,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $9F: //RES 3,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A0: //RES 4,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A1: //RES 4,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $A2: //RES 4,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $A3: //RES 4,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //RES 4,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //RES 4,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //RES 4,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $A7: //RES 4,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A8: //RES 5,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A9: //RES 5,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $AA: //RES 5,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $AB: //RES 5,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //RES 5,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //RES 5,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //RES 5,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $AF: //RES 5,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B0: //RES 6,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B1: //RES 6,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $B2: //RES 6,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $B3: //RES 6,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //RES 6,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //RES 6,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //RES 6,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $B7: //RES 6,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B8: //RES 7,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B9: //RES 7,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $BA: //RES 7,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $BB: //RES 7,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //RES 7,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //RES 7,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //RES 7,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $BF: //RES 7,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C0: //SET 0,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C1: //SET 0,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $C2: //SET 0,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $C3: //SET 0,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $C4: //SET 0,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $C5: //SET 0,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $C6: //SET 0,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $C7: //SET 0,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C8: //SET 1,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C9: //SET 1,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $CA: //SET 1,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //SET 1,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $CC: //SET 1,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $CD: //SET 1,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $CE: //SET 1,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $CF: //SET 1,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D0: //SET 2,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D1: //SET 2,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $D2: //SET 2,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $D3: //SET 2,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $D4: //SET 2,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $D5: //SET 2,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $D6: //SET 2,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $D7: //SET 2,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D8: //SET 3,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D9: //SET 3,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $DA: //SET 3,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $DB: //SET 3,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $DC: //SET 3,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $DD: //SET 3,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $DE: //SET 3,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $DF: //SET 3,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E0: //SET 4,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E1: //SET 4,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $E2: //SET 4,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //SET 4,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $E4: //SET 4,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //SET 4,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $E6: //SET 4,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $E7: //SET 4,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E8: //SET 5,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //SET 5,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $EA: //SET 5,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $EB: //SET 5,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $EC: //SET 5,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $ED: //SET 5,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $EE: //SET 5,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $EF: //SET 5,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F0: //SET 6,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F1: //SET 6,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $F2: //SET 6,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $F3: //SET 6,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $F4: //SET 6,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $F5: //SET 6,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $F6: //SET 6,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $F7: //SET 6,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F8: //SET 7,(IX+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //SET 7,(IX+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $FA: //SET 7,(IX+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $FB: //SET 7,(IX+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $FC: //SET 7,(IX+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $FD: //SET 7,(IX+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $FE: //SET 7,(IX+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $FF: //SET 7,(IX+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IX' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //실행안됨
  End;
end;

//Z80A 기계어 - FD - IY instruction
procedure gt_Move_z80a_CODE_FD;
var
  idx, iSz: Integer; Reg16: LongInt; reg8: Integer; GetIxyIdx: LongInt;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + Z80A_REG_IDX_DASM);
  iSz := 2;
  GetIxyIdx := goGetLngToLng(Z80A_REG_IY + gi_GET_IDX_8(gi_GET_PC_DATA_8));
  Case (idx) of
    $09: //ADD IY,BC
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IY,BC';
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //ADD IY,DE
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IY,DE';
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //LD IY,nn
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IY,' + gs_GET_PC_DATA_16_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //LD (nn),IY
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(' + gs_GET_PC_DATA_16_DASM + '),IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //INC IY
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //INC IYH //@@@@@
      begin
         Z80A_Dis_ASM1 := 'INC';
         Z80A_Dis_ASM2 := 'IYH';
         gt_ADD_PC_Dis(iSz);
      end;
    $25: //DEC IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //LD IYH,n //@@@@@
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //ADD IY,IY
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IY,IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //LD IY,(nn)
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IY,(' + gs_GET_PC_DATA_16_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //DEC IY
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //INC IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := 'IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //DEC IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := 'IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //LD IYL,n //@@@@@
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,' + gs_GET_PC_DATA_8_DASM;
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //INC (IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'INC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //DEC (IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'DEC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //LD (IY+d),n
      begin
        iSz := 4;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),' + gs_GET_PC_DATA_8_DASM(1);
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //ADD IY,SP
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'IY,SP';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //LD B,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //LD B,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //LD B,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'B,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //LD C,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //LD C,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //LD C,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'C,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //LD D,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //LD D,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //LD D,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'D,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //LD E,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //LD E,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //LD E,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'E,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //LD IYH,B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //LD IYH,C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //LD IYH,D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //LD IYH,E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //LD IYH,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //LD IYH,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //LD H,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'H,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //LD IYH,A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYH,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //LD IYL,B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,B';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //LD IYL,C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,C';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //LD IYL,D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,D';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //LD IYL,E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,E';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //LD IYL,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //LD IYL,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //LD L,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'L,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //LD IYL,A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'IYL,A';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //LD (IY+d),B
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //LD (IY+d),C
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //LD (IY+d),D
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //LD (IY+d),E
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //LD (IY+d),H
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //LD (IY+d),L
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //LD (IY+d),A
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //LD A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //LD A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //LD A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //ADD A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //ADD A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //ADD A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'ADD';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //ADC A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //ADC A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //ADC A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'ADC';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //SUB A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //SUB A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //SUB A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'SUB';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //SBC A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //SBC A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //SBC A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'SBC';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //AND A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //AND A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //AND A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'AND';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //XOR A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //XOR A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //XOR A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'XOR';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //OR A,IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //OR A,IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //OR A,(IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'OR';
        Z80A_Dis_ASM2 := 'A,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //CP IYH //@@@@@
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'IYH';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //CP IYL //@@@@@
      begin
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := 'IYL';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //CP (IY+d)
      begin
        iSz := 3;
        Z80A_Dis_ASM1 := 'CP';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //FD-CB - IY bit instruction
      begin
        gt_Move_z80a_CODE_FD_CB;
      end;
    $E1: //POP IY
      begin
        Z80A_Dis_ASM1 := 'POP';
        Z80A_Dis_ASM2 := 'IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //EX (SP),IY
      begin
        Z80A_Dis_ASM1 := 'EX';
        Z80A_Dis_ASM2 := '(SP),IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //PUSH IY
      begin
        Z80A_Dis_ASM1 := 'PUSH';
        Z80A_Dis_ASM2 := 'IY';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //JP (IY)
      begin
        Z80A_Dis_ASM1 := 'JP';
        Z80A_Dis_ASM2 := '(IY)';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //LD SP,IY
      begin
        Z80A_Dis_ASM1 := 'LD';
        Z80A_Dis_ASM2 := 'SP,IY';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //??
    begin
      Z80A_Dis_ASM1 := '?';
      Z80A_Dis_ASM2 := '';
      gt_ADD_PC_Dis(Z80A_REG_IDX_DASM + 1);
    end;
  End;
end;

//Z80A 기계어 - FD - CB - IY bit instruction
procedure gt_Move_z80a_CODE_FD_CB;
var
  idx, iSz: Integer; GetIxyIdx: LongInt; GetIdxMem8: Integer;
begin
  Z80A_REG_IDX_DASM := 1;
  idx := GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + 3);
  GetIxyIdx := goGetLngToLng(Z80A_REG_IY + gi_GET_IDX_8(GET_MSX_MEMORY(Z80A_REG_PC_DASM_ST + 2)));
  iSz := 4;
  GetIdxMem8 := GET_MSX_MEMORY(GetIxyIdx);
  Case (idx) of
    $00: //RLC (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $01: //RLC (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $02: //RLC (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $03: //RLC (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $04: //RLC (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $05: //RLC (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $06: //RLC (IY+d)
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $07: //RLC (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RLC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $08: //RRC (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $09: //RRC (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $0A: //RRC (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $0B: //RRC (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $0C: //RRC (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $0D: //RRC (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $0E: //RRC (IY+d)
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $0F: //RRC (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RRC';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $10: //RL (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $11: //RL (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $12: //RL (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $13: //RL (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $14: //RL (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $15: //RL (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $16: //RL,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $17: //RL (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $18: //RR (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $19: //RR (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $1A: //RR (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $1B: //RR (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $1C: //RR (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $1D: //RR (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $1E: //RR (IY+d)
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $1F: //RR (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RR';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $20: //SLA (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $21: //SLA (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $22: //SLA (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $23: //SLA (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $24: //SLA (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $25: //SLA (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $26: //SLA,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $27: //SLA (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $28: //SRA (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $29: //SRA (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $2A: //SRA (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $2B: //SRA (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $2C: //SRA (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $2D: //SRA (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $2E: //SRA,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $2F: //SRA (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRA';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $30: //SLL (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $31: //SLL (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $32: //SLL (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $33: //SLL (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $34: //SLL (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $35: //SLL (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $36: //SLL (IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $37: //SLL (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SLL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $38: //SRL (IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $39: //SRL (IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $3A: //SRL (IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $3B: //SRL (IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $3C: //SRL (IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $3D: //SRL (IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $3E: //SRL,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $3F: //SRL (IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SRL';
        Z80A_Dis_ASM2 := '(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $40: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $41: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $42: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $43: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $44: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $45: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $46: //BIT 0,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $47: //BIT 0,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $48: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $49: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4A: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4B: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4C: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4D: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4E: //BIT 1,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $4F: //BIT 1,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $50: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $51: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $52: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $53: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $54: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $55: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $56: //BIT 2,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $57: //BIT 2,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $58: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $59: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5A: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5B: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5C: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5D: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5E: //BIT 3,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $5F: //BIT 3,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $60: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $61: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $62: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $63: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $64: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $65: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $66: //BIT 4,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $67: //BIT 4,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $68: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $69: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6A: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6B: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6C: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6D: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6E: //BIT 5,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $6F: //BIT 5,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $70: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $71: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $72: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $73: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $74: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $75: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $76: //BIT 6,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $77: //BIT 6,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $78: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $79: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7A: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7B: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7C: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7D: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7E: //BIT 7,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $7F: //BIT 7,(IY+d) //@@@@@
      begin
        Z80A_Dis_ASM1 := 'BIT';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $80: //RES 0,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $81: //RES 0,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $82: //RES 0,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $83: //RES 0,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $84: //RES 0,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $85: //RES 0,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $86: //RES 0,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $87: //RES 0,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $88: //RES 1,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $89: //RES 1,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $8A: //RES 1,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $8B: //RES 1,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $8C: //RES 1,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $8D: //RES 1,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $8E: //RES 1,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $8F: //RES 1,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $90: //RES 2,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $91: //RES 2,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $92: //RES 2,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $93: //RES 2,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $94: //RES 2,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $95: //RES 2,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $96: //RES 2,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $97: //RES 2,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $98: //RES 3,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $99: //RES 3,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $9A: //RES 3,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $9B: //RES 3,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $9C: //RES 3,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $9D: //RES 3,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $9E: //RES 3,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $9F: //RES 3,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A0: //RES 4,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A1: //RES 4,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $A2: //RES 4,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $A3: //RES 4,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $A4: //RES 4,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $A5: //RES 4,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $A6: //RES 4,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $A7: //RES 4,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $A8: //RES 5,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $A9: //RES 5,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $AA: //RES 5,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $AB: //RES 5,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $AC: //RES 5,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $AD: //RES 5,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $AE: //RES 5,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $AF: //RES 5,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B0: //RES 6,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B1: //RES 6,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $B2: //RES 6,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $B3: //RES 6,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $B4: //RES 6,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $B5: //RES 6,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $B6: //RES 6,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $B7: //RES 6,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $B8: //RES 7,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $B9: //RES 7,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $BA: //RES 7,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $BB: //RES 7,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $BC: //RES 7,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $BD: //RES 7,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $BE: //RES 7,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $BF: //RES 7,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'RES';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C0: //SET 0,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C1: //SET 0,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $C2: //SET 0,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $C3: //SET 0,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $C4: //SET 0,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $C5: //SET 0,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $C6: //SET 0,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $C7: //SET 0,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '0,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $C8: //SET 1,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $C9: //SET 1,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $CA: //SET 1,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $CB: //SET 1,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $CC: //SET 1,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $CD: //SET 1,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $CE: //SET 1,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $CF: //SET 1,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '1,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D0: //SET 2,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D1: //SET 2,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $D2: //SET 2,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $D3: //SET 2,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $D4: //SET 2,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $D5: //SET 2,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $D6: //SET 2,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $D7: //SET 2,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '2,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $D8: //SET 3,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $D9: //SET 3,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $DA: //SET 3,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $DB: //SET 3,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $DC: //SET 3,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $DD: //SET 3,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $DE: //SET 3,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $DF: //SET 3,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '3,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E0: //SET 4,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E1: //SET 4,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $E2: //SET 4,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $E3: //SET 4,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $E4: //SET 4,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $E5: //SET 4,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $E6: //SET 4,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $E7: //SET 4,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '4,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $E8: //SET 5,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $E9: //SET 5,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $EA: //SET 5,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $EB: //SET 5,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $EC: //SET 5,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $ED: //SET 5,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $EE: //SET 5,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $EF: //SET 5,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '5,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F0: //SET 6,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F1: //SET 6,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $F2: //SET 6,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $F3: //SET 6,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $F4: //SET 6,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $F5: //SET 6,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $F6: //SET 6,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $F7: //SET 6,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '6,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
    $F8: //SET 7,(IY+d),B //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),B';
        gt_ADD_PC_Dis(iSz);
      end;
    $F9: //SET 7,(IY+d),C //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),C';
        gt_ADD_PC_Dis(iSz);
      end;
    $FA: //SET 7,(IY+d),D //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),D';
        gt_ADD_PC_Dis(iSz);
      end;
    $FB: //SET 7,(IY+d),E //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),E';
        gt_ADD_PC_Dis(iSz);
      end;
    $FC: //SET 7,(IY+d),H //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),H';
        gt_ADD_PC_Dis(iSz);
      end;
    $FD: //SET 7,(IY+d),L //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),L';
        gt_ADD_PC_Dis(iSz);
      end;
    $FE: //SET 7,(IY+d)
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + ')';
        gt_ADD_PC_Dis(iSz);
      end;
    $FF: //SET 7,(IY+d),A //@@@@@
      begin
        Z80A_Dis_ASM1 := 'SET';
        Z80A_Dis_ASM2 := '7,(IY' + gs_GET_PC_DATA_IDX_8_DASM + '),A';
        gt_ADD_PC_Dis(iSz);
      end;
  Else //실행안됨
  End;
end;

end.

