unit untCommons;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math;

const
  GsProgramVersion = 'Ver ????.??.??';
  GsProgramVerDate = '??????';
  GsMdoPassword = '???????';
  GsMdoPassword2 = '???????';
  GiChtMaxRows = 210; //210

  GiScanTimerEvents = 0; //0:Timer, 1:Events

var
  GiRunProgramExit: Integer = 0; //0:처음실행,1:중복실행
  GiLazIs: Integer = 1; //0:델파이,1:라자루스

  GiProgramTTS: Integer; //음성지원
  //public static Process ProgramTTS;
  GiProgramTIC: Integer; //VB6IC
  //public static Process ProgramTIC;

  GiOnLineChk: Integer; //온라인체크(1->온라인,2->오프라인)
  GiDataRecSend: Integer; //0:처음실행,1:CC

  GiMdoMultiTable: Integer; //0:단일테이블,1:멀티테이블
  GiPosMultiCard: Integer; //1:멀티카드사용-구버전용
  GsPosJulBarcode: String; //저울바코드식별번호(2*6)
  GsPJBar1: String;
  GsPJBar2: String;
  GsPJBar3: String;
  GsPJBar4: String;
  GsPJBar5: String;
  GsPJBar6: String;

  GiSelectPrint: Integer; //0:영수증출력,1:안함
  GiSelectDraw: Integer; //0:돈통열기,1:안함
  GiSelectCoin: Integer; //0:동전출력,1:안함
  GiSelectSign: Integer; //0:사인패드사용,1:안함

  GiSelectPrintOnOff: Integer; //1:계산시영수증출력선택메뉴
  GiSelectSoundOff: Integer; //1:계산시음성출력안함
  GiPrintChitOnOff: Integer; //1:프린터출력(O)

  GsScanBarcode: String; //스캔바코드
  GiRow: Integer; //1~210
  GiCol: Integer; //1:바코드,2:수량,3:단가,4:금액
  GiColOn: Array[0..4] Of Integer; //1:포커스[1:바코드,2:수량,3:단가,4:금액]
  GiChtOn: Integer; //1:포커스(전표번호입력)

  GsErrMessage: String; //오류메세지

  //호출창
  GsErrTitle: String; //바코드미등록,중복 [상품,고객]
  GsErrBarcode: String;
  GiErrGdsLine: Integer;
  GsErrGdsName: String;
  GsErrGdsKyg: String;
  GcErrGdsPrice: Currency;
  GiErrCount: Integer;

  GiCashExecWrite: Integer; //0:계산하기,1:기록완료,-1:반품작업,-2:외상입금
  GiCashExecNotCommit: Integer; //1:계산미결발생
  GiCashExecWriteCard1: Integer;
  GiCashExecWriteCard2: Integer;
  GiCashExecPrintNot: Integer; //1:영수증출력안함

  GsChoiceTitle: String;
  GiChoiceYesNo: Integer; //1:확인,0:취소
  GiGdsRepYesNo: Integer; //1:확인,0:취소

  GsKeyPadString: String; //키패드-숫자문자
  GcGdsSeltectKey: Currency; //단축키-다중키

  GcGdsHelpKey: Currency;
  GsGdsHelpSeek: String;
  GcCstHelpKey: Currency;
  GsCstHelpSeek: String;
  GcTrsHelpKey: Currency;
  GsTrsHelpSeek: String;
  GoExtHelpNo: Integer;
  GsExtHelpName: String;

  GiChitSearch: Integer; //0:직접호출(영수,대기),1:상품,2:고객,3:거래처,4:전표,5:반품,6:현영,7:외입,8:점추,9:배달
  GiPrintSuSelt: Integer; //1:배달전표,2:외상전표,2:대기전표,3:화면전표
  GsPassWord: String; //비밀번호입력

  GiPanHelpSelt: Integer;
  GsPanHelpDate: String;
  GsPanHelpPrtDate: String; //발행일자변경시
  GoPanHelpChtNo: Integer;
  GiPanHelpPrint: Integer;
  GiWatHelpSelt: Integer;
  GsWatHelpDate: String;
  GoWatHelpPosNo: Integer;
  GoWatHelpChtNo: Integer;
  GiWatHelpPrint: Integer;
  GiBdlHelpSelt: Integer;
  GsBdlHelpDate: String;
  GoBdlHelpChtNo: Integer;
  GiBdlHelpPrint: Integer;
  GiPrtHelpSelt: Integer;
  GsPrtHelpDate: String;
  GoPrtHelpChtNo: Integer;
  GiPrtHelpPrint: Integer;
  GiMnyHelpSelt: Integer;
  GsMnyHelpDate: String;
  GoMnyHelpChtNo: Integer;
  GiMnyHelpPrint: Integer;
  GcKeyListGdsKey: Currency;

  GiGdsListSelt: Integer; //1:판매,2:대기,3:배달,4:화면
  GsGdsListDate: String;
  GoGdsListPosNo: Integer;
  GoGdsListChtNo: Integer;
  GcGdsListChtHab: Currency;
  GcGdsListChtCard: Currency;
  GcGdsListCstKey: Currency;
  GcGdsListTrsKey: Currency;
  GiDlvSeltFlg: Integer; //1:배달전표상품선택됨(배달상품선택작업종료시출력)

  GiTerminateForm: Integer = 0; //마감정산작업
  GiTemWaitForm: Integer = 0; //마감대기조회
  GiPanListForm: Integer = 0; //판매조회작업
  GiPanChitForm: Integer = 0; //판매전표조회
  GiPanGodsForm: Integer = 0; //판매상세조회
  GiCstGodsForm: Integer = 0; //고객상세조회
  GiPanTimeForm: Integer = 0; //시간판매조회

  //일자시간
  GsNowDateFm, GsNowDate, GsNowYoil: String; //메뉴일자
  GiNowYear, GiNowMon, GiNowDay: Integer;
  GsNowTimeFm, GsNowTime: String; //메뉴시간
  GiNowHour, GiNowMin, GiNowSec: Integer;

  GsDateFm: String; //일자
  GiYear, GiMon, GiDay: Integer;
  GsTimeFm: String; //시간
  GiHour, GiMin, GiSec: Integer;

  //로그인
  GiComputerNo: Integer;
  GsUserID: String;
  GsUserPwd: String;
  GoPsnNo: Integer;
  GcPsnKey: Currency;
  GsUserName: String;
  GsUserHp: String;

  function gsYyMm(iSel: Integer; iYear: Integer; iMon:Integer): String;
  procedure gtGetNowDate();
  procedure gtGetNowDate_Fm();
  procedure gtGetNowTime();
  procedure gtGetNowTime_Fm();
  function gsGetNowDate8(): String;
  function gsGetNowDate8_Fm(): String;
  function gsGetNowTime6(): String;
  function gsGetNowTime6_Fm(): String;
  function gsDate8To_Fm(sDate: String): String;
  function gsTime6To_Fm(sTime: String): String;
  function gsTime4To_Fm(sTime: String): String;
  procedure gtPutYMD(sDate: String; var iYear: Integer; var iMon: Integer; var iDay: Integer);
  function gsGetYMD(iYear: Integer; iMon: Integer; iDay: Integer): String;
  function gsGetDate(iYear: Integer; iMon: Integer; iDay: Integer): String;
  function gsGetDate_Fm(iYear: Integer; iMon: Integer; iDay: Integer): String;
  function gsGetTime(iHour: Integer; iMin: Integer; iSec: Integer): String;
  function gsGetTime_Fm(iHour: Integer; iMin: Integer; iSec: Integer): String;
  procedure gtYearMonAdd(var iYear: Integer; var iMon: Integer);
  procedure gtYearMonSub(var iYear: Integer; var iMon: Integer);
  function gsGetYear(iYear: Integer): String;
  function gsGetMon(iMon: Integer): String;
  function gsGetDay(iDay: Integer): String;
  function gsGetHM(iHour: Integer; iMin: Integer): String;
  function gsGetHour(iHour: Integer): String;
  function gsGetMin(iMin: Integer): String;
  function gdtEncodeDate(sDate: String): TDateTime;
  function giGetLastDay(iYear: Integer; iMon: Integer): Integer;
  function giGetYoilDay(iYear: Integer; iMon: Integer; iOdr: Integer; iYoil: Integer): Integer;
  function gsYoil(iYear: Integer; iMon: Integer; iDay: Integer): String;
  function giWeekDay(sDate: String): Integer;
  function giStDateEdDateDay(StDate: String; EdDate: String): Integer;
  function giStDateEdDateMon(StDate: String; EdDate: String): Integer;
  function giStMonEdMonCnt(iStYear: Integer; iStMon: Integer; iEdYear: Integer; iEdMon: Integer): Integer;
  function gsDateAdd(sDate: String; iCnt: Integer): String;
  function giDateToDays(sDate: String): Integer;
  function gsGetDateAddMons(sDate: String; iAdd: Integer; iSt: Integer = 0): String;
  function giMisuCircleDay(StDate: String; EdDate: String; cCarry: Currency; cNows: Currency; cMech: Currency): Integer;
  function gsSQL(sStr: String): String;
  function gsIsNullZero(sStr: String): String;
  function gbIIf(c: Boolean; a: Boolean; b: Boolean): Boolean;
  function giIIf(c: Boolean; a: Integer; b: integer): Integer;
  function gcIIf(c: Boolean; a: Currency; b: Currency): Currency;
  function gsIIf(c: Boolean; a: String; b: String): String;
  procedure gbSwap(var iVal1: Boolean; var iVal2: Boolean);
  procedure giSwap(var iVal1: Integer; var iVal2: Integer);
  procedure gcSwap(var cVal1: Currency; var cVal2: Currency);
  procedure gsSwap(var sVal1: String; var sVal2: String);
  function gsGetBarLast(GsBarcode: String): String;
  function gsCheckBarcode(GsBarcode: String): String;
  function gbCheckSaupNo(sNum: String): Boolean;
  function gsFormatSaupNo(sSno: String): String;
  function gbCheckJuminNo(sNum: String): Boolean;
  function gsFormatJuminNo(sSno: String): String;
  function gsGetTimeTitle(iVal: Integer): String;
  function gsEncodingRtn(sStr: String; iOld: Integer = 0): String;
  function gsDecodingRtn(sStr: String; iOld: Integer = 0): String;
  function fsGetStringTo36(sStr: String): String;
  function fsGetStringTo36_Sub(sStr: String): String;
  function fsGet36ToString(sStr: String): String;
  function fsGet36ToString_Sub(sStr: String): String;
  function fsGet36(iVal: Integer): String;
  function fiGet36(sVal: String): Integer;

implementation

uses
  untValues, untStrings;

function gsYyMm(iSel: Integer; iYear: Integer; iMon:Integer): String;
var
  R: String;
begin
  R := '';
  if (iSel = 0) then //Main
    begin
      if ((GiOnLineChk = 1) And (GiMdoMultiTable = 1)) then R := gsNos02i(iYear) + gsNos02i(iMon); //메인&온라인&멀티
    end;
  Result := R;
end;

procedure gtGetNowDate();
begin
  GsDateFm := FormatDateTime('YYYY-MM-DD', Now);
  GiYear := giValue(gsMid(GsDateFm, 1, 4));
  GiMon := giValue(gsMid(GsDateFm, 6, 2));
  GiDay := giValue(gsMid(GsDateFm, 9, 2));
end;

procedure gtGetNowDate_Fm();
begin
  GiYear := giValue(gsMid(GsDateFm, 1, 4));
  GiMon := giValue(gsMid(GsDateFm, 6, 2));
  GiDay := giValue(gsMid(GsDateFm, 9, 2));
end;

procedure gtGetNowTime();
begin
  GsTimeFm := FormatDateTime('HH:MM:SS', Now);
  GiHour := giValue(gsMid(GsTimeFm, 1, 2));
  GiMin := giValue(gsMid(GsTimeFm, 4, 2));
  GiSec := giValue(gsMid(GsTimeFm, 7, 2));
end;

procedure gtGetNowTime_Fm();
begin
  GiHour := giValue(gsMid(GsTimeFm, 1, 2));
  GiMin := giValue(gsMid(GsTimeFm, 4, 2));
  GiSec := giValue(gsMid(GsTimeFm, 7, 2));
end;

function gsGetNowDate8(): String;
begin
  Result := gsReplace(FormatDateTime('YYYY-MM-DD', Now), '-', '');
end;

function gsGetNowDate8_Fm(): String;
begin
  Result := FormatDateTime('YYYY-MM-DD', Now);
end;

function gsGetNowTime6(): String;
begin
  Result := gsReplace(FormatDateTime('HH:MM:SS', Now), ':', '');
end;

function gsGetNowTime6_Fm(): String;
begin
  Result := FormatDateTime('HH:MM:SS', Now);
end;

function gsDate8To_Fm(sDate: String): String;
begin
  Result := gsMid(sDate, 1, 4) + '-' + gsMid(sDate, 5, 2) + '-' + gsMid(sDate, 7, 2);
end;

function gsTime6To_Fm(sTime: String): String;
begin
  Result := gsMid(sTime, 1, 2) + ':' + gsMid(sTime, 3, 2) + ':' + gsMid(sTime, 5, 2);
end;

function gsTime4To_Fm(sTime: String): String;
begin
  Result := gsMid(sTime, 1, 2) + ':' + gsMid(sTime, 3, 2);
end;

procedure gtPutYMD(sDate: String; var iYear: Integer; var iMon: Integer; var iDay: Integer);
begin
  iYear := giValue(gsMid(sDate, 1, 4));
  iMon := giValue(gsMid(sDate, 5, 2));
  iDay := giValue(gsMid(sDate, 7, 2));
end;

function gsGetYMD(iYear: Integer; iMon: Integer; iDay: Integer): String;
var
  R: String;
begin
  R := gsGetDate(iYear, iMon, iDay);
  if (gcValue(R) = 0) then R := '';
  Result:= R;
end;

function gsGetDate(iYear: Integer; iMon: Integer; iDay: Integer): String;
begin
  Result := gsNos04i(iYear) + gsNos02i(iMon) + gsNos02i(iDay);
end;

function gsGetDate_Fm(iYear: Integer; iMon: Integer; iDay: Integer): String;
begin
  Result := gsNos04i(iYear) + '-' + gsNos02i(iMon) + '-' + gsNos02i(iDay);
end;

function gsGetTime(iHour: Integer; iMin: Integer; iSec: Integer): String;
begin
  Result := gsNos02i(iHour) + gsNos02i(iMin) + gsNos02i(iSec);
end;

function gsGetTime_Fm(iHour: Integer; iMin: Integer; iSec: Integer): String;
begin
  Result := gsNos02i(iHour) + ':' + gsNos02i(iMin) + ':' + gsNos02i(iSec);
end;

procedure gtYearMonAdd(var iYear: Integer; var iMon: Integer);
begin
  iMon := iMon + 1;
  if (iMon > 12) then
    begin
      iYear := iYear + 1;
      iMon := 1;
    end;
end;

procedure gtYearMonSub(var iYear: Integer; var iMon: Integer);
begin
  iMon := iMon - 1;
  if (iMon < 1) then
    begin
      iYear := iYear - 1;
      iMon := 12;
    end;
end;

function gsGetYear(iYear: Integer): String;
var
  R: String;
begin
  R := '';
  if ((iYear < 1900) Or (iYear > 2999)) then iYear := 0;
  R := gsNos04i(iYear, 1);
  Result := R;
end;

function gsGetMon(iMon: Integer): String;
var
  R: String;
begin
  R := '';
  if ((iMon < 1) Or (iMon > 12)) then iMon := 0;
  R := gsNos02i(iMon, 1);
  Result := R;
end;

function gsGetDay(iDay: Integer): String;
var
  R: String;
begin
  R := '';
  if ((iDay < 1) Or (iDay > 31)) then iDay := 0;
  R := gsNos02i(iDay, 1);
  Result := R;
end;

function gsGetHM(iHour: Integer; iMin: Integer): String;
var
  R: String;
begin
  R := gsNos02i(iHour) + gsNos02i(iMin);
  if (gcValue(R) = 0) then R := '';
  Result := R;
end;

function gsGetHour(iHour: Integer): String;
var
  R: String;
begin
  R := '';
  if ((iHour < 1) Or (iHour > 24)) then iHour := 0;
  R := gsNos02i(iHour, 1);
  Result := R;
end;

function gsGetMin(iMin: Integer): String;
var
  R: String;
begin
  R := '';
  if ((iMin < 1) Or (iMin > 59)) then iMin := 0;
  R := gsNos02i(iMin, 1);
  Result := R;
end;

function gdtEncodeDate(sDate: String): TDateTime;
begin
  Result := EncodeDate(giValue(gsMid(sDate, 1, 4)), giValue(gsMid(sDate, 6, 2)), giValue(gsMid(sDate, 9, 2)));
end;

//특정년월의 마직막일자 구함
function giGetLastDay(iYear: Integer; iMon: Integer): Integer;
var
  R: Integer;
label
  SmallProc, BigProc, LastProc;
begin
  R := 0;
  if (iMon = 1) then R := 31;
  if (iMon = 2) then R := 28;
  if (iMon = 3) then R := 31;
  if (iMon = 4) then R := 30;
  if (iMon = 5) then R := 31;
  if (iMon = 6) then R := 30;
  if (iMon = 7) then R := 31;
  if (iMon = 8) then R := 31;
  if (iMon = 9) then R := 30;
  if (iMon = 10) then R := 31;
  if (iMon = 11) then R := 30;
  if (iMon = 12) then R := 31;
  if (iMon <> 2) then goto LastProc;
  if ((iYear Mod 4) <> 0) then goto SmallProc;
  if ((iYear Mod 100) <> 0) then goto BigProc;
  if ((iYear Mod 400) <> 0) then goto SmallProc;
  goto BigProc;
SmallProc:
  R := 28;
  goto LastProc;
BigProc:
  R := 29;
  goto LastProc;
LastProc:
  Result := R;
end;

//특정 연,월,순번,요일로 일자구하기
//Odr -1~6,7은마지막
//Yoil-월(1)~일(7)
function giGetYoilDay(iYear: Integer; iMon: Integer; iOdr: Integer; iYoil: Integer): Integer;
var
  R: Integer;
  iStYoil, iLtDay: Integer;
  S: String;
  i, y: Integer;
label
  LastProc;
begin
  R := 0;
  if ((iYear = 0) Or (iMon = 0)) then goto LastProc;
  if ((iOdr < 1) Or (iOdr > 7)) then goto LastProc;
  if ((iYoil < 1) Or (iYoil > 7)) then goto LastProc;
  S := gsYoil(iYear, iMon, 1);
  iStYoil := 0;
  if (S = '월') then iStYoil := 1;
  if (S = '화') then iStYoil := 2;
  if (S = '수') then iStYoil := 3;
  if (S = '목') then iStYoil := 4;
  if (S = '금') then iStYoil := 5;
  if (S = '토') then iStYoil := 6;
  if (S = '일') then iStYoil := 7;
  iLtDay := giGetLastDay(iYear, iMon);
  y := iYoil - iStYoil + 1;
  if (iYoil < iStYoil) then y := y + 7;
  if (iOdr = 7) then
    begin
      for i := 1 to 5 do
        begin
          if ((y + 7) <= iLtDay) then y := y + 7;
        end;
    end
  else
    begin
      y := y + ((iOdr - 1) * 7);
    end;

  if (y <= iLtDay) then R := y;
LastProc:
  Result := R;
end;

//요일계산
function gsYoil(iYear: Integer; iMon: Integer; iDay: Integer): String;
var
  R: String;
  W: Integer;
begin
  R := '';
  if ((iYear <> 0) And (iMon <> 0) And (iDay <> 0)) then
    begin
      W := DayOfWeek(gdtEncodeDate(gsGetDate_Fm(iYear, iMon, iDay)));
      if (W = 1) then R := '일';
      if (W = 2) then R := '월';
      if (W = 3) then R := '화';
      if (W = 4) then R := '수';
      if (W = 5) then R := '목';
      if (W = 6) then R := '금';
      if (W = 7) then R := '토';
    end;
  Result := R;
end;

//요일계산 (yyyy-mm-dd) -> 1~7:1:일요일(기본값),2:월요일,3:화요일,4:수요일,5:목요일,6:금요일,7:토요일
function giWeekDay(sDate: String): Integer;
var
  W: Integer;
  iYear, iMon, iDay: Integer;
label
  LastProc;
begin
  W := 0;
  iYear := giValue(gsMid(sDate, 1, 4));
  iMon := giValue(gsMid(sDate, 6, 2));
  iDay := giValue(gsMid(sDate, 9, 2));
  if (giGetLastDay(iYear, iMon) < iDay) then goto LastProc;
  W := DayOfWeek(gdtEncodeDate(gsGetDate_Fm(iYear, iMon, iDay)));
LastProc:
  Result := W;
end;

function giStDateEdDateDay(StDate: String; EdDate: String): Integer;
var
  rnDays, stDays, edDays: Integer;
  StYear, StMon, stDay: Integer;
  EdYear, EdMon, edDay: Integer;
begin
  StYear := giValue(gsMid(StDate, 1, 4));
  StMon := giValue(gsMid(StDate, 5, 2));
  stDay := giValue(gsMid(StDate, 7, 2));
  EdYear := giValue(gsMid(EdDate, 1, 4));
  EdMon := giValue(gsMid(EdDate, 5, 2));
  edDay := giValue(gsMid(EdDate, 7, 2));
  stDays := giDateToDays(StDate);
  edDays := giDateToDays(EdDate);
  rnDays := edDays - stDays;
  Result := rnDays;
end;

function giStDateEdDateMon(StDate: String; EdDate: String): Integer;
begin
  Result := giStMonEdMonCnt(giValue(gsMid(StDate, 1, 4)), giValue(gsMid(StDate, 5, 2)), giValue(gsMid(EdDate, 1, 4)), giValue(gsMid(EdDate, 5, 2)));
end;

function giStMonEdMonCnt(iStYear: Integer; iStMon: Integer; iEdYear: Integer; iEdMon: Integer): Integer;
var
  R: Integer;
label
  LastProc;
begin
  R := 0;
  if ((iStYear = 0) Or (iStMon = 0) Or (iEdYear = 0) Or (iEdMon = 0)) then goto LastProc;
  R := (iEdYear * 12 + iEdMon) - (iStYear * 12 + iStMon);
LastProc:
  Result := R;
end;

//특정날짜에서 지정일자 전,후의 날짜 구함
function gsDateAdd(sDate: String; iCnt: Integer): String;
var
  i: Integer;
  iYear, iMon, iDay: Integer;
label
  LastProc;
begin
  iYear := giValue(gsMid(sDate, 1, 4));
  iMon := giValue(gsMid(sDate, 5, 2));
  iDay := giValue(gsMid(sDate, 7, 2));
  if ((iYear = 0) Or (iMon = 0) Or (iDay = 0)) then goto LastProc;
  if (iCnt > 0) then
    for i := 1 to iCnt do
      begin
        iDay := iDay + 1;
        if (iDay > giGetLastDay(iYear, iMon)) then
          begin
            iDay := 1;
            iMon := iMon + 1;
            if iMon > 12 then
              begin
                iMon := 1;
                iYear := iYear + 1;
              end;
          end;
      end;
  if (iCnt < 0) then
    for i := 1 to giAbs(iCnt) do
      begin
        iDay := iDay - 1;
        if (iDay = 0) then
          begin
            iMon := iMon - 1;
            if (iMon = 0) then
              begin
                iMon := 12;
                iYear := iYear - 1;
              end;
            iDay := giGetLastDay(iYear, iMon);
          end;
      end;
LastProc:
  Result := gsGetDate(iYear, iMon, iDay);
end;

function giDateToDays(sDate: String): Integer;
var
  oDays: Integer;
  iYear, iMon, iDay: Integer;
  i, T: Integer;
begin
  iYear := giValue(gsMid(sDate, 1, 4));
  iMon := giValue(gsMid(sDate, 5, 2));
  iDay := giValue(gsMid(sDate, 7, 2));
  oDays := (iYear - 1) * 365;
  oDays := oDays + giValue(gsCurToStr140((iYear - 1.0) / 4.0));
  oDays := oDays - giValue(gsCurToStr140((iYear - 1.0) / 100.0));
  oDays := oDays + giValue(gsCurToStr140((iYear - 1.0) / 400.0));
  if (iMon > 1) then
    for i := 1 to iMon - 1 do
      begin
        if (i = 1) then T := 31;
        if (i = 2) then
          begin
            T := 28;
            if ((iYear Mod 4) = 0) then
              if ((iYear Mod 100) = 0) then
                begin
                  if ((iYear Mod 400) = 0) then T := 29;
                end
              else
                T := 29
              ;
          end;
        if (i = 3) then T := 31;
        if (i = 4) then T := 30;
        if (i = 5) then T := 31;
        if (i = 6) then T := 30;
        if (i = 7) then T := 31;
        if (i = 8) then T := 31;
        if (i = 9) then T := 30;
        if (i = 10) then T := 31;
        if (i = 11) then T := 30;
        if (i = 12) then T := 31;
        oDays := oDays + T;
      end;
  oDays := oDays + iDay;
  Result := oDays;
end;

function gsGetDateAddMons(sDate: String; iAdd: Integer; iSt: Integer = 0): String;
var
  R: String;
  j, iLday: Integer;
  iYear: Integer = 0; iMon: Integer = 0; iDay: Integer = 0;
begin
  R := '';
  gtPutYMD(sDate, iYear, iMon, iDay);
  if (iAdd > 0) then
    begin
      for j := 1 to iAdd do
        begin
          iMon := iMon + 1;
          if (iMon = 13) then
            begin
              iYear := iYear + 1;
              iMon := 1;
            end;
        end;
    end;
  if (iAdd < 0) then
    begin
      for j := -1 DownTo iAdd do
        begin
          iMon := iMon - 1;
          if (iMon = 0) then
            begin
              iYear := iYear - 1;
              iMon := 12;
            end;
        end;
    end;
  iLday := giGetLastDay(iYear, iMon);
  if (iDay > iLday) then iDay := iLday ;
  if (iSt = 1) then iDay := 1;
  if (iSt = 2) then iDay := iLday;
  R := gsGetYMD(iYear, iMon, iDay);
  Result := R;
end;

//미수 회전일 계산
function giMisuCircleDay(StDate: String; EdDate: String; cCarry: Currency; cNows: Currency; cMech: Currency): Integer;
var
  R: Integer;
  V: Currency;
  cHab, cDays: Currency;
begin
  R := 0;
  V := 0;
  Try
    Try
      cHab := cCarry + cNows;
      cDays := giStDateEdDateDay(StDate, EdDate) + 1;
      V := cHab * cDays / cMech / 2;
    Except
      V := 0;
    End;
  Finally
  End;
  if ((cNows > 0) And (cMech <= 0)) then V := 1000;
  R := giRound(V);
  Result := R;
end;

function gsSQL(sStr: String): String;
var
  S: String;
begin
  //『』
  S := sStr;
  S := StringReplace(S, '『', Chr(39), [rfReplaceAll]); //[']
  S := StringReplace(S, '』', Chr(39), [rfReplaceAll]); //[']
  Result := S;
end;

function gsIsNullZero(sStr: String): String;
var
  S: String;
begin
  S := 'Case When ' + sStr + ' Is Null Then 0 Else ' + sStr + ' End';
  Result := S;
end;

//IfThen(조건, 참값, 거짓값)
function gbIIf(c: Boolean; a: Boolean; b: Boolean): Boolean;
begin
  if (c) then
      Result := a
  else
      Result := b
  ;
end;

function giIIf(c: Boolean; a: Integer; b: integer): Integer;
begin
  if (c) then
      Result := a
  else
      Result := b
  ;
end;

function gcIIf(c: Boolean; a: Currency; b: Currency): Currency;
begin
  if (c) then
      Result := a
  else
      Result := b
  ;
end;

function gsIIf(c: Boolean; a: String; b: String): String;
begin
  if (c) then
      Result := a
  else
      Result := b
  ;
end;

procedure gbSwap(var iVal1: Boolean; var iVal2: Boolean);
var
  iVal: Boolean;
begin
  iVal := iVal1;
  iVal1 := iVal2;
  iVal2 := iVal;
end;

procedure giSwap(var iVal1: Integer; var iVal2: Integer);
var
  iVal: Integer;
begin
  iVal := iVal1;
  iVal1 := iVal2;
  iVal2 := iVal;
end;

procedure gcSwap(var cVal1: Currency; var cVal2: Currency);
var
  cVal: Currency;
begin
  cVal := cVal1;
  cVal1 := cVal2;
  cVal2 := cVal;
end;

procedure gsSwap(var sVal1: String; var sVal2: String);
var
  sVal: String;
begin
  sVal := sVal1;
  sVal1 := sVal2;
  sVal2 := sVal;
end;

//바코드 마지막자리 값 얻음
//입력값: 바코드 String값 13,12자리, 8,7자리
//리턴값: Char(1) --> '0'~'9'정상, 'X'오류
function gsGetBarLast(GsBarcode: String): String;
var
  SS, S1, S2: String;
  i, j, T, T1, T2: Integer;
label
  Check13, Check08, CheckLast, LastProc;
begin
  SS := gsTrim(GsBarcode);
  S1 := '?'; S2 := 'X';
  if ((giLen(SS) = 13) Or (giLen(SS) = 12)) then S1 := 'A';
  if ((giLen(SS) = 8) Or (giLen(SS) = 7)) then S1 := 'B';
  if (S1 = 'A') then goto Check13;
  if (S1 = 'B') then goto Check08;
  goto LastProc;

Check13:
  T := 0;
  j := 2; //2,4,6,8,10,12
  for i := 1 to 6 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  T := T * 3;
  j := 1; //1,3,5,7,9,11
  for i := 1 to 6 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  goto CheckLast;

Check08:
  T := 0;
  j := 1; //1,3,5,7
  for i := 1 to 4 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  T := T * 3;
  j := 2; //2,4,6
  for i := 1 to 3 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  goto CheckLast;

CheckLast:
  T1 := giValue(gsRight(gsIStr(T), 1));
  T2 := 10 - T1;
  if (T2 = 10) then T2 := 0;

  S2 := gsRight(gsIStr(T2), 1);

LastProc:
  Result := S2;
end;

//바코드 Check
//입력값: 바코드 String값 13자리,8자리, 기타
//리턴값: Char(2) --> char1(A:13,B:8,C:?), char2(O:정상,X:오류)
function gsCheckBarcode(GsBarcode: String): String;
var
  SS, S1, S2: String;
  i, j, T, T1, T2: Integer;
label
  Check13, Check08, CheckLast, LastProc;
begin
  SS := gsTrim(GsBarcode);
  S1 := '?'; S2 := 'X';
  if (giLen(SS) = 13) then S1 := 'A';
  if (giLen(SS) = 8) then S1 := 'B';
  if (SS = '00000000') then goto LastProc;
  if (SS = '0000000000000') then goto LastProc;
  if (S1 = 'A') then goto Check13;
  if (S1 = 'B') then goto Check08;
  goto LastProc;

Check13:
  T := 0;
  j := 2; //2,4,6,8,10,12
  for i := 1 to 6 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  T := T * 3;
  j := 1; //1,3,5,7,9,11
  for i := 1 to 6 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  goto CheckLast;

Check08:
  T := 0;
  j := 1; //1,3,5,7
  for i := 1 to 4 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  T := T * 3;
  j := 2; //2,4,6
  for i := 1 to 3 do
    begin
      T := T + giValue(gsMid(SS, j, 1));
      j := j + 2;
    end;
  goto CheckLast;

CheckLast:
  T1 := giValue(gsRight(gsIStr(T), 1));
  T2 := 10 - T1;
  if (T2 = 10) then T2 := 0;

  if (gsRight(gsIStr(T2), 1) = gsRight(SS, 1)) then S2 := 'O';

LastProc:
  Result := S1 + S2;
end;

//사업자번호 확인
function gbCheckSaupNo(sNum: String): Boolean;
var
  R: Boolean;
  sWt: String;
  i, Tot, Chk, Rmd: Integer;
label
  ExitProc;
begin
  R := False;

  if (giLen(sNum) <> 10) then goto ExitProc;

  sWt := '137137135';

  Tot := 0;
  for i := 1 to 9 do
    begin
      Tot := Tot + (giValue(gsMid(sNum, i, 1)) * giValue(gsMid(sWt, i, 1)));
    end;
  Tot := Tot + giDiv((giValue(gsMid(sNum, 9, 1)) * 5), 10);

  Rmd := giMod(Tot, 10);
  if (Rmd = 0) then
      Chk := 0
  else
      Chk := 10 - Rmd
  ;

  if (Chk = giValue(gsMid(sNum, 10, 1))) then
      R := True
  else
      R := False
  ;

ExitProc:
  Result := R;
end;

function gsFormatSaupNo(sSno: String): String;
var
  R: String;
begin
  R := '';
  if (sSno <> '') then R := gsMid(sSno, 1, 3) + '-' + gsMid(sSno, 4, 2) + '-' + gsMid(sSno, 6, 5);
  Result := R;
end;

//주민등록번호 확인
function gbCheckJuminNo(sNum: String): Boolean;
var
  R: Boolean;
  sWt: String;
  i, Tot, Chk, Rmn: Integer;
label
  ExitProc;
begin
  R := False;

  if (giLen(sNum) <> 13) then goto ExitProc;

  sWt := '234567892345';
  Chk := giValue(gsRight(sNum, 1));

  Tot := 0;
  for i := 1 to 12 do
    begin
      Tot := Tot + (giValue(gsMid(sNum, i, 1)) * giValue(gsMid(sWt, i, 1)));
    end;

  Rmn := 11 - giMod(Tot, 11);
  if (Rmn > 9) then Rmn := giMod(Rmn, 10);

  if (Rmn = Chk) then
    R := True
  else
    R := False
  ;

ExitProc:
  Result := R;
end;

function gsFormatJuminNo(sSno: String): String;
var
  R: String;
begin
  R := '';
  if (sSno <> '') then R := gsMid(sSno, 1, 6) + '-' + gsMid(sSno, 7, 7);
  Result := R;
end;

function gsGetTimeTitle(iVal: Integer): String;
var
  R: String;
begin
  R := '';
  if (iVal = 1) then R := '01시~02시(Am01)';
  if (iVal = 2) then R := '02시~03시(Am02)';
  if (iVal = 3) then R := '03시~04시(Am03)';
  if (iVal = 4) then R := '04시~05시(Am04)';
  if (iVal = 5) then R := '05시~06시(Am05)';
  if (iVal = 6) then R := '06시~07시(Am06)';
  if (iVal = 7) then R := '07시~08시(Am07)';
  if (iVal = 8) then R := '08시~09시(Am08)';
  if (iVal = 9) then R := '09시~10시(Am09)';
  if (iVal = 10) then R := '10시~11시(Am10)';
  if (iVal = 11) then R := '11시~12시(Am11)';
  if (iVal = 12) then R := '12시~13시(Pm12)';
  if (iVal = 13) then R := '13시~14시(Pm01)';
  if (iVal = 14) then R := '14시~15시(Pm02)';
  if (iVal = 15) then R := '15시~16시(Pm03)';
  if (iVal = 16) then R := '16시~17시(Pm04)';
  if (iVal = 17) then R := '17시~18시(Pm05)';
  if (iVal = 18) then R := '18시~19시(Pm06)';
  if (iVal = 19) then R := '19시~20시(Pm07)';
  if (iVal = 20) then R := '20시~21시(Pm08)';
  if (iVal = 21) then R := '21시~22시(Pm09)';
  if (iVal = 22) then R := '22시~23시(Pm10)';
  if (iVal = 23) then R := '23시~24시(Pm11)';
  if ((iVal = 0) Or (iVal = 24)) then R := '24시~01시(Am12)';
  Result := R;
end;

function gsEncodingRtn(sStr: String; iOld: Integer = 0): String;
var
  R: String;
  S: String;
  T, X, P, Z: String;
  C: Char;
  V, L, i, j: Integer;
label
  NextProc, LastProc;
begin
  R := '';
  T := '';
  S := sStr;
  L := giLen(S);
  if (L = 0) then goto NextProc;
  for i := 1 to L do
    begin
      //C := S[i - 1]; //안드로이드만해당됨[-1]
      C := S[i]; //Win
      V := Integer(C);
      if (V >= 0) then
        X := '1' + gsRight('00000' + gsIStr(giAbs(V)), 5)
      else
        X := '2' + gsRight('00000' + gsIStr(giAbs(V)), 5)
      ;
      X := gsMid(X, 6, 1) + gsMid(X, 2, 1) + gsMid(X, 4, 1) + gsMid(X, 1, 1) + gsMid(X, 5, 1) + gsMid(X, 3, 1);
      P := '';
      for j := 1 to 6 do
        begin
          V := giValue(gsMid(X, j, 1));
          V := V + j;
          P := P + gsRight(gsIStr(V), 1);
        end;
      T := T + P;
    end;
  Z := '';
  for j := 1 to giLen(T) do
    begin
      V := giValue(gsMid(T, j, 1));
      V := V + giValue(gsRight(gsIStr(j), 1));
      Z := Z + gsRight(gsIStr(V), 1);
    end;
  T := Z;
  for j := 1 to L do T := gsMid(T, 3) + gsLeft(T, 2);
NextProc:
  if (iOld = 0) then
      R := fsGetStringTo36(T)
  else
      R := T
  ;
LastProc:
  Result := R;
end;

function gsDecodingRtn(sStr: String; iOld: Integer = 0): String;
var
  R: String;
  S, T, X, P, Z: String;
  V, L, i, j: Integer;
label
  NextProc, LastProc;
begin
  R := '';
  T := '';
  if (iOld = 0) then
    S := fsGet36ToString(sStr)
  else
    S := sStr
  ;
  if (giLen(S) = 0) then goto NextProc;
  L := giLen(S) div 6; //정수형나눗셈[div몫,mod나머지],실수형나눗셈은[/]
  for j := 1 to L do
    begin
      S := gsRight(S, 2) + gsLeft(S, giLen(S) - 2);
    end;
  Z := '';
  for j := 1 to giLen(S) do
    begin
      V := giValue(gsMid(S, j, 1));
      if (V > giValue(gsRight(gsIStr(j), 1))) then
        V := V - giValue(gsRight(gsIStr(j), 1))
      else
        V := (V + 10) - giValue(gsRight(gsIStr(j), 1))
      ;
      Z := Z + gsRight(gsIStr(V), 1);
    end;
  S := Z;
  for i := 1 to L do
    begin
      X := gsMid(S, (i - 1) * 6 + 1, 6);
      P := '';
      for j := 1 to 6 do
        begin
          V := giValue(gsMid(X, j, 1));
          if (V > j) then
            V := V - j
          else
            V := (V + 10) - j
          ;
          P := P + gsRight(gsIStr(V), 1);
        end;
      P := gsMid(P, 4, 1) + gsMid(P, 2, 1) + gsMid(P, 6, 1) + gsMid(P, 3, 1) + gsMid(P, 5, 1) + gsMid(P, 1, 1);
      X := gsMid(P, 2, 5);
      if (gsLeft(P, 1) = '1') then
        V := giValue(X)
      else
        V := giValue(X) * (-1)
      ;
      T := T + Chr(V);
    end;
NextProc:
  R := T;
LastProc:
  Result := R;
end;

function fsGetStringTo36(sStr: String): String;
var
  R: String;
  i: Integer;
label
  LastProc;
begin
  R := '';
  if (sStr = '') then goto LastProc;
  for i := 0 to giDiv(giLen(sStr), 3) - 1 do
    begin
      R := R + fsGetStringTo36_Sub(gsMid(sStr, i * 3 + 1, 3));
    end;
LastProc:
  Result := R;
end;

function fsGetStringTo36_Sub(sStr: String): String;
var
  R: String;
  V, V1, V2: Integer;
begin
  R := '';
  V := giValue(sStr);
  V1 := giDiv(V, 36); V2 := giDiv_Mod;
  R := fsGet36(V1) + fsGet36(V2);
  Result := R;
end;

function fsGet36ToString(sStr: String): String;
var
  R: String;
  i: Integer;
label
  LastProc;
begin
  R := '';
  if (sStr = '') then goto LastProc;
  for i := 0 to giDiv(giLen(sStr), 2) - 1 do
    begin
      R := R + fsGet36ToString_Sub(gsMid(sStr, i * 2 + 1, 2));
    end;
LastProc:
  Result := R;
end;

function fsGet36ToString_Sub(sStr: String): String;
var
  R: String;
  V: Integer;
  V1, V2: String;
begin
  R := '';
  V1 := gsLeft(sStr, 1); V2 := gsRight(sStr, 1);
  V := fiGet36(V1) * 36 + fiGet36(V2);
  R := gsNos03i(V);
  Result := R;
end;

function fsGet36(iVal: Integer): String;
var
  R: String;
begin
  R := '';
  if (iVal = 0) then R := '0';
  if (iVal = 1) then R := '1';
  if (iVal = 2) then R := '2';
  if (iVal = 3) then R := '3';
  if (iVal = 4) then R := '4';
  if (iVal = 5) then R := '5';
  if (iVal = 6) then R := '6';
  if (iVal = 7) then R := '7';
  if (iVal = 8) then R := '8';
  if (iVal = 9) then R := '9';
  if (iVal = 10) then R := 'A';
  if (iVal = 11) then R := 'B';
  if (iVal = 12) then R := 'C';
  if (iVal = 13) then R := 'D';
  if (iVal = 14) then R := 'E';
  if (iVal = 15) then R := 'F';
  if (iVal = 16) then R := 'G';
  if (iVal = 17) then R := 'H';
  if (iVal = 18) then R := 'I';
  if (iVal = 19) then R := 'J';
  if (iVal = 20) then R := 'K';
  if (iVal = 21) then R := 'L';
  if (iVal = 22) then R := 'M';
  if (iVal = 23) then R := 'N';
  if (iVal = 24) then R := 'O';
  if (iVal = 25) then R := 'P';
  if (iVal = 26) then R := 'Q';
  if (iVal = 27) then R := 'R';
  if (iVal = 28) then R := 'S';
  if (iVal = 29) then R := 'T';
  if (iVal = 30) then R := 'U';
  if (iVal = 31) then R := 'V';
  if (iVal = 32) then R := 'W';
  if (iVal = 33) then R := 'X';
  if (iVal = 34) then R := 'Y';
  if (iVal = 35) then R := 'Z';
  Result := R;
end;

function fiGet36(sVal: String): Integer;
var
  R: Integer;
begin
  R := 0;
  if (sVal = '0') then R := 0;
  if (sVal = '1') then R := 1;
  if (sVal = '2') then R := 2;
  if (sVal = '3') then R := 3;
  if (sVal = '4') then R := 4;
  if (sVal = '5') then R := 5;
  if (sVal = '6') then R := 6;
  if (sVal = '7') then R := 7;
  if (sVal = '8') then R := 8;
  if (sVal = '9') then R := 9;
  if (sVal = 'A') then R := 10;
  if (sVal = 'B') then R := 11;
  if (sVal = 'C') then R := 12;
  if (sVal = 'D') then R := 13;
  if (sVal = 'E') then R := 14;
  if (sVal = 'F') then R := 15;
  if (sVal = 'G') then R := 16;
  if (sVal = 'H') then R := 17;
  if (sVal = 'I') then R := 18;
  if (sVal = 'J') then R := 19;
  if (sVal = 'K') then R := 20;
  if (sVal = 'L') then R := 21;
  if (sVal = 'M') then R := 22;
  if (sVal = 'N') then R := 23;
  if (sVal = 'O') then R := 24;
  if (sVal = 'P') then R := 25;
  if (sVal = 'Q') then R := 26;
  if (sVal = 'R') then R := 27;
  if (sVal = 'S') then R := 28;
  if (sVal = 'T') then R := 29;
  if (sVal = 'U') then R := 30;
  if (sVal = 'V') then R := 31;
  if (sVal = 'W') then R := 32;
  if (sVal = 'X') then R := 33;
  if (sVal = 'Y') then R := 34;
  if (sVal = 'Z') then R := 35;
  Result := R;
end;

end.

