unit untFunction;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

type
  UTF8String = AnsiString;

  //ShortInt -> SmallInt -> Integer(LongInt)         -> Int64
  //Byte     -> Word     -> LongWord(Cardinal,dWord) -> qWord(uInt64)
  // -128~127 : 0~255
  // -32768~32767 : 0~65535
  // -2147483648~2147483647 : 0~4294967295
  // -9223372036854775808~9223372036854775807 : 0~18446744073709551615

  function gmiVal(V: String): Integer; //Integer=LongInt -2147483648~2147483647
  function gmsCStr(V: Integer; iSize: ShortInt = 0): String; //ShortInt -128~127
  function gmsChr(V: Byte): Char; //Byte 0~255
  function gmiAsc(S: String): SmallInt; //SmallInt -32768~32767
  function gmsSpace(iLen: Integer): String;
  function vbCrLf: String;
  function gmiLen(S: String): Integer;
  function gmsLeft(S: String; iSize: Integer): String;
  function gmsRight(S: String; iSize: Integer): String;
  function gmsMid(S: String; iSt: Integer; iSize: Integer = 0): String;
  function gmsTrim(S: String): String;
  function gmsUpper(S: String): String;
  function gmsDelete(S: String): String;
  function gmiInStr(P: Integer; S1: String; S2: String): Integer;
  function gmsGetTrim(sStr: String; iSize: Integer = 0): String;
  function gmsReplace(sStr: String; sStr2: String; sStr3: String): String;
  function gmsHex(V: Integer; iSize: ShortInt = 0): String;
  function gmsBin(V: Integer; iSize: ShortInt = 0): String;
  function gmiHex8ToInt(S: String; iByte: Integer = 0): integer;
  function gmiBin8ToInt(S: String): integer;
  function gmiLongHexToDec(Str: String): Integer; //Int64;
  procedure gmtSwap16(var A: LongInt; var B: LongInt);
  function gmoRGB(R: Byte; G: Byte; B: Byte): LongWord;
  function gmbIfThen(bCon: Boolean; bTrue: Boolean; bFalse: Boolean): Boolean;
  function gmiIfThen(bCon: Boolean; bTrue: Integer; bFalse: Integer): Integer;
  function gmsIfThen(bCon: Boolean; bTrue: String; bFalse: String): String;
  function gmsDate: String;
  function gmsTime: String;

implementation

uses
  untCommons, untStrings;

function gmiVal(V: String): Integer;
begin
  Result := giValue(V);
end;

function gmsCStr(V: Integer; iSize: ShortInt = 0): String;
var
  R: String;
begin
  R := gsCStr(V); R := gsTrim(R);
  if (iSize = 2) then R := gsRight('00' + R, 2);
  if (iSize = 3) then R := gsRight('000' + R, 3);
  if (iSize = 4) then R := gsRight('0000' + R, 4);
  if (iSize = 6) then R := gsRight('000000' + R, 6);
  if (iSize = 8) then R := gsRight('00000000' + R, 8);
  if (iSize = 10) then R := gsRight('0000000000' + R, 10);

  Result := R;
end;

function gmsChr(V: Byte): Char;
begin
  Result := Chr(V);
end;

function gmiAsc(S: String): SmallInt;
begin
  Result := giAsc(S);
end;

function gmsSpace(iLen: Integer): String;
begin
  Result := gsSpc(iLen);
end;

function vbCrLf: String;
var
  R: String;
begin
  R := gmsChr(13) + gmsChr(10);
  Result := R;
end;

function gmiLen(S: String): Integer;
begin
  Result := giLen(S);
end;

function gmsLeft(S: String; iSize: Integer): String;
begin
  Result := gsLeft(S, iSize);
end;

function gmsRight(S: String; iSize: Integer): String;
begin
  Result := gsRight(S, iSize);
end;

function gmsMid(S: String; iSt: Integer; iSize: Integer = 0): String;
begin
  Result := gsMid(S, iSt, iSize);
end;

function gmsTrim(S: String): String;
begin
  Result := gsTrim(S);
end;

function gmsUpper(S: String): String;
begin
  Result := gsUpperCase(S);
end;

function gmsDelete(S: String): String;
begin
  Result := gsGetString(S);
end;

function gmiInStr(P: Integer; S1: String; S2: String): Integer;
begin
  Result := giPos(S1, S2); //Start ?
end;

function gmsGetTrim(sStr: String; iSize: Integer = 0): String;
begin
  Result := gsGetTrim(sStr, iSize);
end;

function gmsReplace(sStr: String; sStr2: String; sStr3: String): String;
begin
  Result := gsReplace(sStr, sStr2, sStr3);
end;

function gmsHex(V: Integer; iSize: ShortInt = 0): String;
var
  R: String;
begin
  R := IntToHex(V, 1); R := gsTrim(R); //1:최소1자리이상
  if (iSize = 2) then R := gsRight('00' + R, 2);
  if (iSize = 4) then R := gsRight('0000' + R, 4);
  if (iSize = 6) then R := gsRight('000000' + R, 6);
  if (iSize = 8) then R := gsRight('00000000' + R, 8);

  Result := R;
end;

function gmsBin(V: Integer; iSize: ShortInt = 0): String;
var
  R, S, C: String;
  i, L: Integer;
begin
  R := '';
  S := IntToHex(V, 1); S := gsTrim(S); //1:최소1자리이상
  L := giLen(S);
  if (L > 0) then
    for i := 1 to L do
      begin
        C := gsMid(S, i, 1);
        if (C = '0') then R := R + '0000';
        if (C = '1') then R := R + '0001';
        if (C = '2') then R := R + '0010';
        if (C = '3') then R := R + '0011';
        if (C = '4') then R := R + '0100';
        if (C = '5') then R := R + '0101';
        if (C = '6') then R := R + '0110';
        if (C = '7') then R := R + '0111';
        if (C = '8') then R := R + '1000';
        if (C = '9') then R := R + '1001';
        if (C = 'A') then R := R + '1010';
        if (C = 'B') then R := R + '1011';
        if (C = 'C') then R := R + '1100';
        if (C = 'D') then R := R + '1101';
        if (C = 'E') then R := R + '1110';
        if (C = 'F') then R := R + '1111';
      end;
  if (iSize = 4) then R := gsRight('0000' + R, 4);
  if (iSize = 8) then R := gsRight('00000000' + R, 8);
  if (iSize = 16) then R := gsRight('0000000000000000' + R, 16);

  Result := R;
end;

function gmiHex8ToInt(S: String; iByte: Integer = 0): integer;
begin
  //StrToInt('$' + S), StrToInt64('$' + S)
  if (iByte = 1) then
    Result := StrToInt('$' + S) //?? - ASM에서 오류발생 (번지????)
  else
    Result := gmiLongHexToDec(S) //????
  ;
end;

function gmiBin8ToInt(S: String): integer;
var
  R: Integer;
  sBin: String;
begin
  R := 0;
  sBin := gmsRight('00000000' + S, 8);
  R := R + (gmiVal(gmsMid(sBin, 1, 1)) * 128);
  R := R + (gmiVal(gmsMid(sBin, 2, 1)) * 64);
  R := R + (gmiVal(gmsMid(sBin, 3, 1)) * 32);
  R := R + (gmiVal(gmsMid(sBin, 4, 1)) * 16);
  R := R + (gmiVal(gmsMid(sBin, 5, 1)) * 8);
  R := R + (gmiVal(gmsMid(sBin, 6, 1)) * 4);
  R := R + (gmiVal(gmsMid(sBin, 7, 1)) * 2);
  R := R + (gmiVal(gmsMid(sBin, 8, 1)) * 1);
  Result := R;
end;

function gmiLongHexToDec(Str: String): Integer; //Int64;
var
  Counter : Integer;
  DecValue: Integer; //Int64;
begin
  Result   := 0;
  DecValue := 1;
  Str      := AnsiUpperCase(Str);
  for Counter := Length(Str) downto 1 do
    begin
      Case (Str[Counter]) of
        '1'..'9': Result := Result + ((Ord(Str[Counter])-Ord('0')) * DecValue);
        'A'..'F': Result := Result + ((Ord(Str[Counter])-Ord('A')+10) * DecValue);
      end;
      DecValue := DecValue shl 4;
    end;
end;

procedure gmtSwap16(var A: LongInt; var B: LongInt);
var
  C: LongInt;
begin
  C := A; A := B; B := C;
end;

function gmoRGB(R: Byte; G: Byte; B: Byte): LongWord;
begin
  //return (uint)((R * 0x10000) + (G * 0x100) + B); //투명
  Result := (($FF000000) + (R * $10000) + (G * $100) + B); //불투명
end;

function gmbIfThen(bCon: Boolean; bTrue: Boolean; bFalse: Boolean): Boolean;
begin
  if (bCon) then
    Result := bTrue
  else
    Result := bFalse
  ;
end;

function gmiIfThen(bCon: Boolean; bTrue: Integer; bFalse: Integer): Integer;
begin
  if (bCon) then
    Result := bTrue
  else
    Result := bFalse
  ;
end;

function gmsIfThen(bCon: Boolean; bTrue: String; bFalse: String): String;
begin
  if (bCon) then
    Result := bTrue
  else
    Result := bFalse
  ;
end;

function gmsDate: String;
begin
  //YYYY-MM-DD
  Result := gsGetNowDate8_Fm();
end;

function gmsTime: String;
begin
  //HH:MM:SS
  Result := gsGetNowTime6_Fm();
end;

end.

