unit untRegistry;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Registry;

  function giGetRegistry(RegKey: String): Integer;
  function gsGetRegistry(RegKey: String): String;
  procedure giUpdateRegistry(RegKey: String; RegVal: Integer);
  procedure gsUpdateRegistry(RegKey: String; RegVal: String);
  function GetSetting(appName: String; section: String; key: String; sDefault: String): String;
  procedure SaveSetting(appName: String; section: String; key: String; setting: String);

implementation

uses
  untFunction;

function giGetRegistry(RegKey: String): Integer;
begin
  Result := gmiVal(GetSetting('dxMSX', 'Setting', RegKey, ''));
end;

function gsGetRegistry(RegKey: String): String;
begin
  Result := gmsTrim(GetSetting('dxMSX', 'Setting', RegKey, ''));
end;

procedure giUpdateRegistry(RegKey: String; RegVal: Integer);
begin
  SaveSetting('dxMSX', 'Setting', RegKey, gmsCStr(RegVal, 0));
end;

procedure gsUpdateRegistry(RegKey: String; RegVal: String);
begin
  SaveSetting('dxMSX', 'Setting', RegKey, RegVal);
end;

function GetSetting(appName: String; section: String; key: String; sDefault: String): String;
var
  myRegistry : TRegistry;
  sKeyValue: String;
begin
  myRegistry := TRegistry.Create;
  myRegistry.RootKey := HKEY_CURRENT_USER;

  sKeyValue := 'SOFTWARE\VB and VBA Program Settings' + '\'+ appName;
  if myRegistry.KeyExists(sKeyValue) then
    if myRegistry.OpenKey(sKeyValue, False) then
      sDefault := myRegistry.ReadString(key);

  myRegistry.Free;

  Result := sDefault;
end;

procedure SaveSetting(appName: String; section: String; key: String; setting: String);
var
  myRegistry : TRegistry;
  sKeyValue: String;
begin
  myRegistry := TRegistry.Create;
  myRegistry.RootKey := HKEY_CURRENT_USER;

  sKeyValue := 'SOFTWARE\VB and VBA Program Settings' + '\'+ appName;
  if Not myRegistry.KeyExists(sKeyValue) then myRegistry.CreateKey(sKeyValue);
  if myRegistry.OpenKey(sKeyValue, False) then
    myRegistry.WriteString(key, setting);

  myRegistry.Free;
end;

end.

