unit untStrings;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

const
  fiSpliteOn: Integer = 1; //0:수동방식,1:자동방식
  fiSpliteSize: Integer = 100000;
  fiSpliteSize1: Integer = 200;

var
  GiLazIs: Integer = 1; //0:델파이,1:라자루스

  GiSplitStr: Integer;
  GsSplitStr: Array[1..100000] Of String;
  GsSplitStr1: Array[1..200] Of String;

  function gsIStr(iVal: Integer; iDel: Integer = 0; iSize: Integer = 0): String;
  function gsOStr(iVal: LongInt; iDel: Integer = 0; iSize: Integer = 0): String;
  function gsCStr(cVal: Currency; iDel: Integer = 0; iSize: Integer = 0): String;
  function gsChr(iVal: Integer): String;
  function giAsc(sStr: String): Integer;
  function giValue(sStr: String): Integer;
  function giValue02(sStr: String): Integer;
  function giValue03(sStr: String): Integer;
  function giValue04(sStr: String): Integer;
  function goValue(sStr: String): LongInt;
  function goValue06(sStr: String): LongInt;
  function goValue08(sStr: String): LongInt;
  function gcValue(sStr: String): Currency;
  function gsLeftDot(sStr: String): String;
  function gbCharIsByte(sChr: String): Boolean;
  function giLen(sStr: String): Integer;
  function giLenH(sStr: String): Integer;
  function gsTrim(sStr: String): String;
  function gsLeft(sStr: String; iLen: Integer): String;
  function gsLeftH(sStr: String; iLen: Integer): String;
  function gsRight(sStr: String; iLen: Integer): String;
  function gsRightH(sStr: String; iLen: Integer): String;
  function gsMid(sStr: String; iPos: Integer; iLen: Integer = 0): String;
  function gsMidH(sStr: String; iPos: Integer; iLen: Integer = 0): String;
  function gsCopy(sStr: String; iPos: Integer; iLen: Integer): String;
  function giPos(sStr: String; sStr2: String): Integer;
  function gsUpperCase(sStr: String): String;
  function gsLowerCase(sStr: String): String;
  function gsReplace(sStr: String; sStr2: String; sStr3: String): String;
  function gsString(sChr: String; iLen: Integer): String;
  function gsGetNumber(sStr: String; iLen: Integer = 0): String;
  function gsGetNumeric(sStr: String; iInt: Integer = 0): String;
  function gsGetAlphaTrim(sStr: String): String;
  function gsLeftSpace(sStr: String; iLen: Integer): String;
  function gsLeftSpaceH(sStr: String; iLen: Integer): String;
  function gsRightSpace(sStr: String; iLen: Integer): String;
  function gsRightSpaceH(sStr: String; iLen: Integer): String;
  function gsDelete(sStr: String): String;
  function gsGetString(sStr: String; iLen: Integer = 0): String;
  function gsGetStringH(sStr: String; iLen: Integer): String;
  function gsGetTrim(sStr: String; iLen: Integer = 0): String;
  function gsGetTrimH(sStr: String; iLen: Integer): String;
  function gsGet_NullString(sStr: String): String;
  function gsGet_NullTrim(sStr: String): String;
  function giGet_NullValue(sStr: String): Integer;
  function goGet_NullValue(sStr: String): LongInt;
  function gcGet_NullValue(sStr: String): Currency;
  function gsSpc(iLen: Integer): String;
  function gsCrLf(): String;
  function gbIsNullString(sStr: String): Boolean;
  function gbStrIsNumeric(sStr: String; iSel: Integer = 0): Boolean;
  function giSplitString(sStr: String; sChar: String; iSel: Integer = 0): Integer;
  function gbBetweenChr(sStr: String; sStrA: String; sStrZ: String): Boolean;
  function giStrCompare(sStrA: String; sStrB: String; bChk: Boolean = True): Integer;
  function gbBetweenStr(sStr: String; sStrA: String; sStrZ: String; bChk: Boolean): Boolean;
  function gbIsHan(C: String): Boolean;
  function gbIsNotHan(C: String): Boolean;
  function giHanHelp(sStr: String): Integer;

implementation

function gsIStr(iVal: Integer; iDel: Integer = 0; iSize: Integer = 0): String;
var
  S: String;
begin
  S := '';
  Try
    Try
      S := IntToStr(iVal);
    Except
      S := '0';
    End;
  Finally
  End;
  if (iSize = 2) then S := gsRight('00' + S, 2);
  if (iSize = 3) then S := gsRight('000' + S, 3);
  if (iSize = 4) then S := gsRight('0000' + S, 4);
  if (iSize = 6) then S := gsRight('000000' + S, 6);
  if (iSize = 8) then S := gsRight('00000000' + S, 8);
  if (iSize = 10) then S := gsRight('0000000000' + S, 10);
  if ((iDel = 1) And (iVal = 0)) then S := '';
  Result := S;
end;

function gsOStr(iVal: LongInt; iDel: Integer = 0; iSize: Integer = 0): String;
var
  S: String;
begin
  S := '';
  Try
    Try
      S := IntToStr(iVal);
    Except
      S := '0';
    End;
  Finally
  End;
  if (iSize = 2) then S := gsRight('00' + S, 2);
  if (iSize = 3) then S := gsRight('000' + S, 3);
  if (iSize = 4) then S := gsRight('0000' + S, 4);
  if (iSize = 6) then S := gsRight('000000' + S, 6);
  if (iSize = 8) then S := gsRight('00000000' + S, 8);
  if (iSize = 10) then S := gsRight('0000000000' + S, 10);
  if ((iDel = 1) And (iVal = 0)) then S := '';
  Result := S;
end;

function gsCStr(cVal: Currency; iDel: Integer = 0; iSize: Integer = 0): String;
var
  S: String;
begin
  S := '';
  Try
    Try
      S := CurrToStr(cVal);
    Except
      S := '0';
    End;
  Finally
  End;
  if (iSize = 2) then S := gsRight('00' + S, 2);
  if (iSize = 3) then S := gsRight('000' + S, 3);
  if (iSize = 4) then S := gsRight('0000' + S, 4);
  if (iSize = 6) then S := gsRight('000000' + S, 6);
  if (iSize = 8) then S := gsRight('00000000' + S, 8);
  if (iSize = 10) then S := gsRight('0000000000' + S, 10);
  if ((iDel = 1) And (cVal = 0)) then S := '';
  Result := S;
end;

function gsChr(iVal: Integer): String;
var
  S: String;
begin
  S := '';
  Try
    Try
      S := Chr(iVal);
    Except
    End;
  Finally
  End;
  Result := S;
end;

function giAsc(sStr: String): Integer;
var
  V: Integer;
  C: Char;
begin
  V := 0;
  if (sStr <> '') then
    begin
      Try
        Try
          C := sStr[1]; //Win, Android(i - 1)
          V := Integer(C); //Ord(C); Byte(C);
        Except
        End;
      Finally
      End;
    end;
  Result := V;
end;

function giValue(sStr: String): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
      //if (TryStrToInt(sStr, V) <> True) then V := 0;
    Except
      V := 0;
    End;
  Finally
  End;
LastProc:
  Result := V;
end;

function giValue02(sStr: String): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
    Except
      V := 0;
    End;
  Finally
  End;
  if ((V < 0) Or (V > 99)) then V := 0;
LastProc:
  Result := V;
end;

function giValue03(sStr: String): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
    Except
      V := 0;
    End;
  Finally
  End;
  if ((V < 0) Or (V > 999)) then V := 0;
LastProc:
  Result := V;
end;

function giValue04(sStr: String): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
    Except
      V := 0;
    End;
  Finally
  End;
  if ((V < 0) Or (V > 9999)) then V := 0;
LastProc:
  Result := V;
end;

function goValue(sStr: String): LongInt;
var
  V: LongInt;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
      //if (TryStrToInt(sStr, V) <> True) then V := 0;
    Except
      V := 0;
    End;
  Finally
  End;
LastProc:
  Result := V;
end;

function goValue06(sStr: String): LongInt;
var
  V: LongInt;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
    Except
      V := 0;
    End;
  Finally
  End;
  if ((V < 0) Or (V > 999999)) then V := 0;
LastProc:
  Result := V;
end;

function goValue08(sStr: String): LongInt;
var
  V: LongInt;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  sStr := gsLeftDot(gsTrim(sStr));
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 1);
  Try
    Try
      V := StrToInt(sStr);
    Except
      V := 0;
    End;
  Finally
  End;
  if ((V < 0) Or (V > 99999999)) then V := 0;
LastProc:
  Result := V;
end;

function gcValue(sStr: String): Currency;
var
  V: Currency;
label
  LastProc;
begin
  V := 0;
  if (sStr = '') then goto LastProc;
  //if (gsUpperCase(sStr) = 'FALSE') then begin V := 0; goto LastProc; end;
  //if (gsUpperCase(sStr) = 'TRUE') then begin V := 1; goto LastProc; end;
  sStr := gsGetNumeric(sStr, 0);
  Try
    Try
      V := StrToCurr(sStr);
      //if (TryStrToCurr(sStr, V) <> True) then V := 0;
    Except
      V := 0;
    End;
  Finally
  End;
LastProc:
  Result := V;
end;

//라자루스 오류 : 1.00 -> 100 으로 변환
function gsLeftDot(sStr: String): String;
var
  R: String;
  P: Integer;
begin
  R := sStr;
  P := giPos(R, '.');
  if (P = 1) then R := '0';
  if (P > 1) then R := gsLeft(R, P - 1);
  Result := R;
end;

function gbCharIsByte(sChr: String): Boolean;
var
  R: Boolean;
  iAsc: Integer;
begin
  R := False;
  if (gbBetweenChr(sChr, ' ', '~')) then R := True;
  iAsc := giAsc(sChr);
  if ((iAsc >= 0) And (iAsc <= 31)) then R := True;
  Result := R;
end;

function giLen(sStr: String): Integer;
var
  R: Integer;
  wStr: WideString;
begin
  if (GiLazIs = 0) then //Delphi
    begin
      R := Length(sStr);
    end
  else //Lazarus
    begin
      wStr := sStr;
      R := Length(wStr);
    end;
  Result := R;
end;

function giLenH(sStr: String): Integer;
var
  R: Integer;
  i: Integer;
  C: String;
  wStr: WideString;
label
  LastProc;
begin
  R := 0;
  if (sStr = '') then goto LastProc;
  if (GiLazIs = 0) then //Delphi
    begin
      for i := 1 to giLen(sStr) do
        begin
          C := gsMid(sStr, i, 1);
          if (gbCharIsByte(C)) then
            R := R + 1
          else
            R := R + 2
          ;
        end;
    end
  else //Lazarus
    begin
      wStr := sStr;
      for i := 1 to giLen(wStr) do
        begin
          C := gsMid(wStr, i, 1);
          if (gbCharIsByte(C)) then
            R := R + 1
          else
            R := R + 2
          ;
        end;
    end;
LastProc:
  Result := R;
end;

function gsTrim(sStr : String) : String;
begin
  Result := Trim(sStr);
end;

function gsLeft(sStr: String; iLen: Integer): String;
var
  S: String;
  L: Integer;
label
  LastProc;
begin
  S := '';
  if ((sStr = '') Or (iLen < 1)) then goto LastProc;
  L := giLen(sStr);
  if (iLen > L) then iLen := L;
  S := gsCopy(sStr, 1, iLen);
LastProc:
  Result := S;
end;

function gsLeftH(sStr: String; iLen: Integer): String;
var
  R: String;
  i, L: Integer;
  C: String;
label
  LastProc;
begin
  R := '';
  if (sStr = '') then goto LastProc;
  if (iLen <= 0) then goto LastProc;
  L := 0;
  for i := 1 to giLen(sStr) do
    begin
      C := gsMid(sStr, i, 1);
      if (gbCharIsByte(C)) then
        begin
          L := L + 1;
          if (L <= iLen) then R := R + C;
        end
      else
        begin
          L := L + 2;
          if (L <= iLen) then R := R + C;
        end;
    end;
LastProc:
  Result := R;
end;

function gsRight(sStr: String; iLen: Integer): String;
var
  S: String;
  L: Integer;
label
  LastProc;
begin
  S := '';
  if ((sStr = '') Or (iLen < 1)) then goto LastProc;
  L := giLen(sStr);
  if (iLen > L) then iLen := L;
  S := gsCopy(sStr, giLen(sStr) - iLen + 1, iLen);
LastProc:
  Result := S;
end;

function gsRightH(sStr: String; iLen: Integer): String;
var
  R: String;
  i, L: Integer;
  C: String;
label
  LastProc;
begin
  R := '';
  if (sStr = '') then goto LastProc;
  if (iLen <= 0) then goto LastProc;
  L := 0;
  for i := giLen(sStr) downto 1 do
    begin
      C := gsMid(sStr, i, 1);
      if (gbCharIsByte(C)) then
        begin
          L := L + 1;
          if (L <= iLen) then R := C + R;
        end
      else
        begin
          L := L + 2;
          if (L <= iLen) then R := C + R;
        end;
    end;
LastProc:
  Result := R;
end;

function gsMid(sStr: String; iPos: Integer; iLen: Integer = 0): String;
var
  S: String;
  L, N: Integer;
label
  LastProc;
begin
  S := '';
  L := iLen;
  if (sStr = '') then goto LastProc;
  if (iPos <= 0) then goto LastProc;
  if (iPos > giLen(sStr)) then goto LastProc;
  N := giLen(sStr) - iPos + 1;
  if ((L = 0) Or (L > N)) then L := N;
  S := gsCopy(sStr, iPos, L);
LastProc:
  Result := S;
end;

function gsMidH(sStr: String; iPos: Integer; iLen: Integer = 0): String;
var
  S: String;
  wStr: WideString;
  C: WideString; //wStr, C: WideString
  p, p2, z: Integer;
  j: Integer;
label
  LastProc;
begin
  S := '';
  if (sStr = '') then goto LastProc;
  if (iPos <= 0) then goto LastProc;
  wStr := sStr;
  p := 1; z := iPos + iLen - 1;
  for j := 1 to Length(wStr) do
    begin
      C := Copy(wStr, j, 1);
      if (C <= '~') then
        begin
          p2 := p + 0;
          if (p >= iPos) then
            begin
              if ((iLen = 0) Or (p2 <= z)) then
                begin
                  S := S + C;
                end;
            end;
          p := p + 1;
        end
      else
        begin
          p2 := p + 1;
          if (p >= iPos) then
            begin
              if ((iLen = 0) Or (p2 <= z)) then
                begin
                   S := S + C;
                end;
            end;
          p := p + 2;
        end;
    end;
LastProc:
  Result := S;
end;

function gsCopy(sStr: String; iPos: Integer; iLen: Integer): String;
var
  S: String;
  L: Integer;
  wStr, wS: WideString;
label
  LastProc;
begin
  S := '';
  if (sStr = '') then goto LastProc;
  if (iPos <= 0) then goto LastProc;
  if (iLen <= 0) then goto LastProc;
  if (iPos > giLen(sStr)) then goto LastProc;
  if (GiLazIs = 0) then //Delphi
    begin
      L := iLen;
      S := Copy(sStr, iPos, giLen(sStr) - iPos + 1); //시작위치부터끝까지
      if (L > giLen(S)) then L := giLen(S);
      S := Copy(S, 1, L);
    end
  else //Lazarus
    begin
      wStr := sStr;
      L := iLen;
      wS := Copy(wStr, iPos, giLen(wStr) - iPos + 1); //시작위치부터끝까지
      if (L > giLen(wS)) then L := giLen(wS);
      S := Copy(wS, 1, L);
    end;
LastProc:
  Result := S;
end;

function giPos(sStr: String; sStr2: String): Integer;
var
  L: Integer;
  wStr, wStr2: WideString;
label
  LastProc;
begin
  L := 0;
  if (sStr = '') then goto LastProc;
  if (sStr2 = '') then goto LastProc;
  if (GiLazIs = 0) then //Delphi
    begin
      L := Pos(sStr2, sStr);
    end
  else //Lazarus
    begin
      wStr := sStr;
      wStr2 := sStr2;
      L := Pos(wStr2, wStr);
    end;
LastProc:
  Result := L;
end;

function gsUpperCase(sStr: String): String;
begin
  Result := UpperCase(sStr);
end;

function gsLowerCase(sStr: String): String;
begin
  Result := LowerCase(sStr);
end;

function gsReplace(sStr: String; sStr2: String; sStr3: String): String;
var
  S: String;
label
  LastProc;
begin
  S := '';
  if (sStr = '') then goto LastProc;
  if (sStr2 = '') then goto LastProc;
//if (sStr3 = '') then goto LastProc;
  S := StringReplace(sStr, sStr2, sStr3, [rfReplaceAll]);
LastProc:
  Result := S;
end;

function gsString(sChr: String; iLen: Integer): String;
var
  S: String;
  i: Integer;
label
  LastProc;
begin
  S := '';
  if (sChr = '') then goto LastProc;
  if (iLen <= 0) then goto LastProc;
  for i := 1 to iLen do
    begin
      S := S + sChr;
    end;
LastProc:
  Result := S;
end;

function gsGetNumber(sStr: String; iLen: Integer = 0): String;
var
  C, S: String;
  i: Integer;
label
  LastProc;
begin
  S := '';
  if (sStr = '') then goto LastProc;
  for i := 1 to giLen(sStr) do
    begin
      C := gsCopy(sStr, i, 1);
      if ((C >= '0') And (C <= '9')) then S := S + C;
      if ((iLen > 0) And (giLen(S) >= iLen)) then goto LastProc;
    end;
LastProc:
  Result := S;
end;

function gsGetNumeric(sStr: String; iInt: Integer = 0): String;
var
  C, S, S2: String;
  i, T: Integer;
label
  LastProc;
begin
  S := '';
  if (sStr = '') then goto LastProc;
  T := iInt;
  for i := 1 to giLen(sStr) do
    begin
      C := gsCopy(sStr, i, 1);
      if ((i = 1) And (C = '+')) then S := S + C;
      if ((i = 1) And (C = '-')) then S := S + C;
      if ((C >= '0') And (C <= '9')) then S := S + C;
      if ((T = 0) And (C = '.')) then begin S := S + C; T := T + 1; end;
    end;
  if (gsLeft(S, 1) ='.') then S := '0' + S;
LastProc:
  Result := S;
end;

function gsGetAlphaTrim(sStr: String): String;
var
  C, S, T: String;
  i, j: Integer;
label
  LastProc;
begin
  S := '';
  T := gsTrim(sStr);
  if (T = '') then goto LastProc;
  j := 0;
  for i := 1 to giLen(T) do
    begin
      C := gsCopy(T, i, 1);
      if ((C >= '0') And (C <= '9')) then
        j := j + 0
      else
        j := j + 1
      ;
    end;
  if (j >= 1) then S := T;
LastProc:
  Result := S;
end;

function gsLeftSpace(sStr: String; iLen: Integer): String;
var
  S, F: String;
label
  LastProc;
begin
  S := sStr;
//if (sStr = '') then goto LastProc;
  if (iLen = 0) then goto LastProc;
  S := gsLeft(S, iLen);
  if (giLen(S) >= iLen) then goto LastProc;
  F := gsSpc(iLen - giLen(S));
  S := S + F;
LastProc:
  Result := S;
end;

function gsLeftSpaceH(sStr: String; iLen: Integer): String;
var
  S, F: String;
label
  LastProc;
begin
  S := sStr;
//if (sStr = '') then goto LastProc;
  if (iLen = 0) then goto LastProc;
  S := gsLeftH(S, iLen);
  F := gsSpc(iLen - giLenH(S));
  S := S + F;
LastProc:
  Result := S;
end;

function gsRightSpace(sStr: String; iLen: Integer): String;
var
  S, F: String;
label
  LastProc;
begin
  S := sStr;
//if (sStr = '') then goto LastProc;
  if (iLen = 0) then goto LastProc;
  S := gsRight(S, iLen);
  if (giLen(S) >= iLen) then goto LastProc;
  F := gsSpc(iLen - giLen(S));
  S := F + S;
LastProc:
  Result := S;
end;

function gsRightSpaceH(sStr: String; iLen: Integer): String;
var
  S, F: String;
label
  LastProc;
begin
  S := sStr;
//if (sStr = '') then goto LastProc;
  if (iLen = 0) then goto LastProc;
  S := gsRightH(S, iLen);
  F := gsSpc(iLen - giLenH(S));
  S := F + S;
LastProc:
  Result := S;
end;

function gsDelete(sStr: String): String;
var
  S: String;
begin
  S := sStr;
  S := StringReplace(S, Chr(39), '`', [rfReplaceAll]); //[']
  S := StringReplace(S, Chr(34), '`', [rfReplaceAll]); //["]
  Result := S;
end;

function gsGetString(sStr: String; iLen: Integer = 0): String;
var
  S: String;
begin
  S := sStr;
  S := StringReplace(S, Chr(39), '`', [rfReplaceAll]); //[']
  S := StringReplace(S, Chr(34), '`', [rfReplaceAll]); //["]
  if (iLen > 0) then
    begin
      S := gsLeft(S, iLen);
    end;
  Result := S;
end;

function gsGetStringH(sStr: String; iLen: Integer): String;
var
  R: String;
begin
  R := gsGetString(sStr, iLen);
  R := gsLeftH(R, iLen);
  Result := R;
end;

function gsGetTrim(sStr: String; iLen: Integer = 0): String;
var
  S: String;
begin
  S := sStr;
  S := StringReplace(S, Chr(39), '`', [rfReplaceAll]); //[']
  S := StringReplace(S, Chr(34), '`', [rfReplaceAll]); //["]
  S := gsTrim(S);
  if (iLen > 0) then
    begin
      S := gsLeft(S, iLen);
      S := gsTrim(S);
    end;
  Result := S;
end;

function gsGetTrimH(sStr: String; iLen: Integer): String;
var
  R: String;
begin
  R := gsGetTrim(sStr, iLen);
  R := gsTrim(gsLeftH(R, iLen));
  Result := R;
end;

function gsGet_NullString(sStr: String): String;
begin
  if (sStr <> Null) then
    Result := sStr
  else
    Result := ''
  ;
end;

function gsGet_NullTrim(sStr: String): String;
begin
  if (sStr <> Null) then
    Result := gsTrim(sStr)
  else
    Result := ''
  ;
end;

function giGet_NullValue(sStr: String): Integer;
begin
  if ((sStr <> Null) And (UpperCase(sStr) <> 'NULL')) then
    Result := giValue(sStr)
  else
    Result := 0
  ;
end;

function goGet_NullValue(sStr: String): LongInt;
begin
  if ((sStr <> Null) And (UpperCase(sStr) <> 'NULL')) then
    Result := goValue(sStr)
  else
    Result := 0
  ;
end;

function gcGet_NullValue(sStr: String): Currency;
begin
  if ((sStr <> Null) And (UpperCase(sStr) <> 'NULL')) then
    Result := gcValue(sStr)
  else
    Result := 0
  ;
end;

function gsSpc(iLen: Integer): String;
var
  R: String;
  i: Integer;
begin
  R := '';
  if (iLen > 0) then
    for i := 1 to iLen do R := R + ' ';
  Result := R;
end;

function gsCrLf(): String;
var
  R: String;
begin
  R := gsChr(13) + gsChr(10);
  Result := R;
end;

function gbIsNullString(sStr: String): Boolean;
var
  R: Boolean;
begin
  R := False;
  if ((sStr = Null) Or (sStr = '')) then R := True;
  Result := R;
end;

function gbStrIsNumeric(sStr: String; iSel: Integer = 0): Boolean;
var
  R: Boolean;
  i, L: integer;
  C: String;
  CntCom, CntMin: Integer;
label
  LastProc;
begin
  R := False;
  CntCom := 0; CntMin := 0;
  L := giLen(sStr);
  if (L = 0) then
    begin
      if (iSel = 1) then R := True;
      goto LastProc;
    end;

  for i := 1 to L do
    begin
      C := gsMid(sStr, i, 1);
      if (((C >= '0') And (C <= '9')) Or (C = '.') Or (C = ',') Or (C = '-')) then
        begin
          if (C = '.') then CntCom := CntCom + 1;
          if (C = '-') then
            begin
              CntMin := CntMin + 1;
              if (i > 1) then goto LastProc;
            end;
        end
      else
        goto LastProc
      ;
    end;
  if (CntCom > 1) then goto LastProc;
  if (CntMin > 1) then goto LastProc;
  R := True;
LastProc:
  Result := R;
end;

function giSplitString(sStr: String; sChar: String; iSel: Integer = 0): Integer;
var
  SL: TStringList;
  i: Integer;
  C: String;
label
  LastProc;
begin
  GiSplitStr := 0;
  if (giLen(sStr) = 0) then goto LastProc;
  if (fiSpliteOn = 0) then //0:수동방식
    begin
      GiSplitStr := 1;
      if (iSel = 0) then
        GsSplitStr[GiSplitStr] := '' //0
      else
        GsSplitStr1[GiSplitStr] := '' //1
      ;
      for i := 1 to giLen(sStr) do
        begin
          C := gsMid(sStr, i, 1);
          if (C <> sChar) then
            begin
              if iSel = 0 then
                GsSplitStr[GiSplitStr] := GsSplitStr[GiSplitStr] + C //0
              else
                GsSplitStr1[GiSplitStr] := GsSplitStr1[GiSplitStr] + C //1
              ;
            end
          else
            begin
              if ((iSel = 0) And (GiSplitStr >= fiSpliteSize)) then goto LastProc;
              if ((iSel <> 0) And (GiSplitStr >= fiSpliteSize1)) then goto LastProc;
              GiSplitStr := GiSplitStr + 1;
              if (iSel = 0) then
                GsSplitStr[GiSplitStr] := '' //0
              else
                GsSplitStr1[GiSplitStr] := '' //1
              ;
            end;
        end;
    end
  else //1:자동방식
    begin
      SL := TStringList.Create;
      SL.Delimiter := sChar[1];
      SL.StrictDelimiter := True; //Space분리금지
      SL.DelimitedText := sStr;
      GiSplitStr := SL.Count;
      for i := 0 to GiSplitStr - 1 do
        begin
          if (iSel = 0) then
            begin
              if ((i + 1) <= fiSpliteSize) then GsSplitStr[i + 1] := SL[i]; //0
            end
          else
            begin
              if ((i + 1) <= fiSpliteSize1) then GsSplitStr1[i + 1] := SL[i]; //1
            end;
        end;
      SL.Free;
    end;
LastProc:
  if ((iSel = 0) And (GiSplitStr > fiSpliteSize)) then GiSplitStr := fiSpliteSize;
  if ((iSel = 1) And (GiSplitStr > fiSpliteSize1)) then GiSplitStr := fiSpliteSize1;
  Result := GiSplitStr;
end;

function gbBetweenChr(sStr: String; sStrA: String; sStrZ: String): Boolean;
var
  R: Boolean;
begin
  R := False;
  if ((giAsc(sStr) >= giAsc(sStrA)) And (giAsc(sStr) <= giAsc(sStrZ))) then
    R := True
  else
    R := False
  ;
  Result := R;
end;

//문자열비교->0:a==b,1:a>b,-1:a<b
//true[기본-생략가능]:대소문자무시,false:대소문자구분
function giStrCompare(sStrA: String; sStrB: String; bChk: Boolean = True): Integer;
var
  R: Integer;
begin
  if (bChk = True) then
    begin
      sStrA := gsUpperCase(sStrA);
      sStrB := gsUpperCase(sStrB);
    end;
  R := 0;
  if (sStrA > sStrB) then R := 1;
  if (sStrA < sStrB) then R := -1;
  Result := R;
end;

function gbBetweenStr(sStr: String; sStrA: String; sStrZ: String; bChk: Boolean): Boolean;
var
  R: Boolean;
  C1, C2: Integer;
begin
  R := False;
  C1 := giStrCompare(sStr, sStrA, bChk);
  C2 := giStrCompare(sStr, sStrZ, bChk);
  if ((C1 >= 0) And (C2 <= 0)) then
    R := True
  else
    R := False
  ;
  Result := R;
end;

function gbIsHan(C: String): Boolean;
begin
  if (gbCharIsByte(C)) then
    Result := False
  else
    Result := True
  ;
end;

function gbIsNotHan(C: String): Boolean;
begin
  if (gbCharIsByte(C)) then
    Result := True
  else
    Result := False
  ;
end;

function giHanHelp(sStr: String): Integer;
var
  R: Integer;
  S: String;
label
  LastProc;
begin
  R := 0;
  S := gsTrim(sStr);
  if (S = '') then goto LastProc;
  S := gsLeft(S, 1);
  if ((S = 'ㄱ') Or (S = 'ㄴ') Or (S = 'ㄷ') Or (S = 'ㄹ') Or (S = 'ㅁ') Or (S = 'ㅂ') Or (S = 'ㅅ') Or (S = 'ㅇ') Or (S = 'ㅈ') Or (S = 'ㅊ') Or (S = 'ㅋ') Or (S = 'ㅌ') Or (S = 'ㅍ') Or (S = 'ㅎ') Or (S = 'ㄲ') Or (S = 'ㄸ') Or (S = 'ㅃ') Or (S = 'ㅆ') Or (S = 'ㅉ')) then R := 1;
LastProc:
  Result := R;
end;

end.

