unit untValues;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

var
  GcGetTaxTo_Tax: Currency;
  GcGetTaxTo_Gum: Currency;
  GcGetTaxTo_Buga: Currency;

  giDiv_Mod: Integer;

  function gcAdd(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
  function gcSub(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
  function gcMul(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
  function gcDiv(cVal1: Currency; cVal2: Currency; iInt: Integer = 0; iRnd: Integer = 0): Currency;
  function gcDivInt(cVal1: Currency; cVal2: Currency): Currency;
  function gcRound10(cVal: Currency): Currency;
  function giDiv(iVal1: Integer; iVal2: Integer): Integer;
  function giMod(iVal1: Integer; iVal2: Integer): Integer;
  function giAbs(iVal: Integer): Integer;
  function gcAbs(cVal: Currency): Currency;
  function gcGum(cVal: Currency): Currency;
  function giRound(cVal: Currency): Integer;
  function giTrunc(cVal: Currency): Integer;
  function gsCurToStr122(cVal: Currency; iDel: Integer = 0): String;
  function gsCurToStr122Int(cVal: Currency; iDel: Integer = 0): String;
  function gsCurToStr140(cVal: Currency; iDel: Integer = 0): String;
  function gcStrToCur122(sStr: String): Currency;
  function gcStrToCur140(sStr: String): Currency;
  function gsNos02i(iVal: Integer; iDel: Integer = 0): String;
  function gsNos03i(iVal: Integer; iDel: Integer = 0): String;
  function gsNos04i(iVal: Integer; iDel: Integer = 0): String;
  function gsNos06o(iVal: LongInt; iDel: Integer = 0): String;
  function gsNos06c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos06s(sStr: String; iDel: Integer = 0): String;
  function gsNos08o(iVal: Integer; iDel: Integer = 0): String;
  function gsNos08c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos08s(sStr: String; iDel: Integer = 0): String;
  function gsNos09c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos09s(sStr: String; iDel: Integer = 0): String;
  function gsNos10c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos10s(sStr: String; iDel: Integer = 0): String;
  function gsNos11c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos11s(sStr: String; iDel: Integer = 0): String;
  function gsNos12c(cVal: Currency; iDel: Integer = 0): String;
  function gsNos12s(sStr: String; iDel: Integer = 0): String;
  function gcNos10T3(iVal0: Integer; iVal1: Integer; iVal2: Integer): Currency;
  function gsNos10T3(iVal0: Integer; iVal1: Integer; iVal2: Integer; iDel: Integer = 0): String;
  function gsNos334(sStr: String; iSel: Integer = 0): String;
  procedure gtGet334(cNo: Currency; var iNo0: Integer; var iNo1: Integer; var iNo2: Integer);
  function gcGetGumToTax(cGum: Currency; iInt: Integer = 0): Currency;
  function gcGetTaxToGum(cTax: Currency; iInt: Integer = 0): Currency;
  function gcPiik1(cIik: Currency; cPanme: Currency): Currency;
  function gcPiik2(cIik: Currency; cPanme: Currency): Currency;
  function gcWiik1(cIik: Currency; cWonga: Currency): Currency;
  function gcWiik2(cIik: Currency; cWonga: Currency): Currency;
  function gcXiik1(cWonga: Currency; cPanme: Currency): Currency;
  function gcXiik2(cWonga: Currency; cPanme: Currency): Currency;
  function gcComputeAddIik1(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
  function gcComputeAddIik2(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
  function gcComputeIik2(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
  function gcComputeMonPayGum(sStDate: String;  sEdDate: String; cMonPay: Currency): Currency;

  function fsNumToStr140(sStr : String) : String;

implementation

uses
  untCommons, untStrings;

function gcAdd(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
var
  V: Currency;
  S: String;
begin
  V := 0;
  Try
    Try
      V := cVal1 + cVal2;
    Except
      V := 0;
    End;
  Finally
  End;
  if (iInt <> -1) then
    begin
      if (iInt = 0) then
        begin
          S := gsCurToStr122(V);
          V := gcStrToCur122(S);
        end
      else
        begin
          S := gsCurToStr140(V);
          V := gcStrToCur140(S);
        end;
    end;
  Result := V;
end;

function gcSub(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
var
  V: Currency;
  S: String;
begin
  V := 0;
  Try
    Try
      V := cVal1 - cVal2;
    Except
      V := 0;
    End;
  Finally
  End;
  if (iInt <> -1) then
    begin
      if (iInt = 0) then
        begin
          S := gsCurToStr122(V);
          V := gcStrToCur122(S);
        end
      else
        begin
          S := gsCurToStr140(V);
          V := gcStrToCur140(S);
        end;
    end;
  Result := V;
end;

function gcMul(cVal1: Currency; cVal2: Currency; iInt: Integer = 0): Currency;
var
  V: Currency;
  S: String;
begin
  V := 0;
  Try
    Try
      V := cVal1 * cVal2;
    Except
      V := 0;
    End;
  Finally
  End;
  if (iInt <> -1) then
    begin
      if (iInt = 0) then
        begin
          S := gsCurToStr122(V);
          V := gcStrToCur122(S);
        end
      else
        begin
          S := gsCurToStr140(V);
          V := gcStrToCur140(S);
        end;
    end;
  Result := V;
end;

function gcDiv(cVal1: Currency; cVal2: Currency; iInt: Integer = 0; iRnd: Integer = 0): Currency;
var
  V: Currency;
  S: String;
label
  LastProc;
begin
  V := 0;
  if (cVal2 = 0) then goto LastProc;
  Try
    Try
      V := cVal1 / cVal2; //정수형나눗셈[div몫,mod나머지],실수형나눗셈은[/]
    Except
      V := 0;
    End;
  Finally
  End;
  if (iInt <> -1) then
    begin
      if (iInt = 0) then
        begin
          if (iRnd = 0) then
            begin
              if (V >= 0) then
                V := V + 0.005
              else
                V := V - 0.005
              ;
            end;
          S := gsCurToStr122(V);
          V := gcStrToCur122(S);
        end
      else
        begin
          if (iRnd = 0) then
            begin
              if (V >= 0) then
                V := V + 0.5
              else
                V := V - 0.5
              ;
            end;
          S := gsCurToStr140(V);
          V := gcStrToCur140(S);
        end;
    end;
LastProc:
  Result := V;
end;

function gcDivInt(cVal1: Currency; cVal2: Currency): Currency;
var
  V: Currency;
  S: String;
label
  LastProc;
begin
  V := 0;
  if (cVal2 = 0) then goto LastProc;
  Try
    Try
      V := cVal1 / cVal2; //정수형나눗셈[div몫,mod나머지],실수형나눗셈은[/]
    Except
      V := 0;
    End;
  Finally
  End;
  S := gsCurToStr140(V);
  V := gcStrToCur140(S);
LastProc:
  Result := V;
end;

function gcRound10(cVal: Currency): Currency;
var
  V: Currency;
begin
  V := cVal;
  if (V > 0) then
    V := V + 0.5
  else
    V := V - 0.5
  ;
  V := gcDiv(V, 10, 1);
  V := gcMul(V, 10, 1);
  Result := V;
end;

function giDiv(iVal1: Integer; iVal2: Integer): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  giDiv_Mod := 0;
  if (iVal2 = 0) then goto LastProc;
  Try
    Try
      V := iVal1 Div iVal2; //정수형나눗셈[div몫,mod나머지],실수형나눗셈은[/]
      giDiv_Mod := iVal1 Mod iVal2;
    Except
      V := 0;
      giDiv_Mod := 0;
    End;
  Finally
  End;
LastProc:
  Result := V;
end;

function giMod(iVal1: Integer; iVal2: Integer): Integer;
var
  V: Integer;
label
  LastProc;
begin
  V := 0;
  if (iVal2 = 0) then goto LastProc;
  Try
    Try
      V := iVal1 Mod iVal2; //정수형나눗셈[div몫,mod나머지],실수형나눗셈은[/]
    Except
      V := 0;
    End;
  Finally
  End;
LastProc:
  Result := V;
end;

function giAbs(iVal: Integer): Integer;
var
  V: Integer;
begin
  V := 0;
  if (iVal < 0) then
    V := iVal * (-1)
  else
    V := iVal
  ;
  Result := V;
end;

function gcAbs(cVal: Currency): Currency;
var
  V: Currency;
begin
  V := 0;
  if (cVal < 0) then
    V := cVal * (-1)
  else
    V := cVal
  ;
  Result := V;
end;

function gcGum(cVal: Currency): Currency;
var
  V: Currency;
begin
  V := 0;
  if (cVal >= 0) then
    begin
      V := gcAdd(gcDiv(cVal, 1.1, 0), 0.5, 1);
    end
  else
    begin
      V := gcAdd(gcDiv(gcAbs(cVal), 1.1, 0), 0.5, 1);
      V := V * (-1);
    end;
  Result := V;
end;

//Round(X: Real): Int64; - 실수를 반올림 후 정수 반환
//Trunc(X: Real): Int64; - 실수의 소수점 절삭 후 정수 반환
//Ceil(S: Single): Integer; - 실수의 소수점 올림 정수 반환
//Floor(S: Single): Integer; - 실수의 소수점 절삭 후 정수 반환

//실수를정수로변환(반올림)
function giRound(cVal: Currency): Integer;
begin
  Result := Round(cVal);
end;

//실수를정수로변환(절사)
function giTrunc(cVal: Currency): Integer;
begin
  Result := Trunc(cVal);
end;

function gsCurToStr122(cVal: Currency; iDel: Integer = 0): String;
var
  R: String;
  S, S1, S2: String;
  P: Integer;
label
  LastProc;
begin
  R := '';
  if ((iDel = 1) And (cVal = 0)) then goto LastProc;
  S := gsCStr(cVal);
  P := giPos(S, '.');
  S1 := ''; S2 := '';
  if (P >= 1) then
    begin
      S1 := gsLeft(S, P - 1);
      S2 := gsMid(S, P + 1);
    end
  else
    begin
      S1 := S;
    end;
  S1 := fsNumToStr140(S1);
  S2 := gsLeft(S2 + '00', 2);
  R := S1 + '.' + S2;
  if ((iDel = 1) And (R = '0.00')) then R := '';
LastProc:
  Result := R;
end;

function gsCurToStr122Int(cVal: Currency; iDel: Integer = 0): String;
var
  R: String;
  S, S1, S2: String;
  P: Integer;
label
  LastProc;
begin
  R := '';
  if ((iDel = 1) And (cVal = 0)) then goto LastProc;
  S := gsCStr(cVal);
  P := giPos(S, '.');
  S1 := ''; S2 := '';
  if (P >= 1) then
    begin
      S1 := gsLeft(S, P - 1);
      S2 := gsMid(S, P + 1);
    end
  else
    begin
      S1 := S;
    end;
  S1 := fsNumToStr140(S1);
  S2 := gsLeft(S2 + '00', 2);
  if (S2 = '00') then S2 := '';
  R := S1;
  if (S2 <> '') then R := R + '.' + S2;
  if ((iDel = 1) And ((R = '0') Or (R = '0.00'))) then R := '';
LastProc:
  Result := R;
end;

function gsCurToStr140(cVal: Currency; iDel: Integer = 0): String;
var
  R: String;
  S, S1, S2: String;
  P: Integer;
label
  LastProc;
begin
  R := '';
  if ((iDel = 1) And (cVal = 0)) then goto LastProc;
  S := gsCStr(cVal);
  P := giPos(S, '.');
  S1 := ''; S2 := '';
  if (P >= 1) then
    begin
      S1 := gsLeft(S, P - 1);
      S2 := gsMid(S, P + 1);
    end
  else
    begin
      S1 := S;
    end;
  R := fsNumToStr140(S1);
  if ((iDel = 1) And (R = '0')) then R := '';
LastProc:
  Result := R;
end;

function gcStrToCur122(sStr: String): Currency;
var
  V: Currency;
  S, S1, S2: String;
  P: Integer;
label
  LastProc;
begin
  V := 0;
  S := GsGetNumeric(sStr);
  if (S = '') then goto LastProc;
  P := giPos(S, '.');
  S1 := ''; S2 := '';
  if (P >= 1) then
    begin
      S1 := gsLeft(S, P - 1);
      S2 := gsMid(S, P + 1);
    end
  else
    begin
      S1 := S;
    end;
  if (gsLeft(S1, 1) = '-') then
    V := gcValue(gsRight(S1, 13) + '.' + gsLeft(S2, 2))
  else
    V := gcValue(gsRight(S1, 12) + '.' + gsLeft(S2, 2))
  ;
LastProc:
  Result := V;
end;

function gcStrToCur140(sStr: String): Currency;
var
  V: Currency;
  S, S1, S2: String;
  P: Integer;
label
  LastProc;
begin
  V := 0;
  S := GsGetNumeric(sStr);
  if (S = '') then goto LastProc;
  P := giPos(S, '.');
  S1 := ''; S2 := '';
  if (P >= 1) then
    begin
      S1 := gsLeft(S, P - 1);
      S2 := gsMid(S, P + 1);
    end
  else
    begin
      S1 := S;
    end;
  if (gsLeft(S1, 1) = '-') then
    V := gcValue(gsRight(S1, 13))
  else
    V := gcValue(gsRight(S1, 12))
  ;
LastProc:
  Result := V;
end;

function fsNumToStr140(sStr: String): String;
//123,456,789,012,345,678,901
var
  R: String;
  S, C: String;
begin
  R := '';
  S := gsRight(gsString(' ', 21) + sStr, 21);
  C := gsTrim(gsMid(S, 19 ,3));
  if (C <> '') then R := C + R;
  C := gsTrim(gsMid(S, 16 ,3));
  if (C <> '') then R := C + ',' + R;
  C := gsTrim(gsMid(S, 13 ,3));
  if (C <> '') then R := C + ',' + R;
  C := gsTrim(gsMid(S, 10 ,3));
  if (C <> '') then R := C + ',' + R;
  C := gsTrim(gsMid(S, 7 ,3));
  if (C <> '') then R := C + ',' + R;
  C := gsTrim(gsMid(S, 4 ,3));
  if (C <> '') then R := C + ',' + R;
  C := gsTrim(gsMid(S, 1 ,3));
  if (C <> '') then R := C + ',' + R;
  R := gsReplace(R, '-,', '-');
  Result := R;
end;

function gsNos02i(iVal: Integer; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('00' + gsIStr(iVal), 2);
  if ((iDel = 1) And (S = '00')) then S := '';
  Result := S;
end;

function gsNos03i(iVal: Integer; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000' + gsIStr(iVal), 3);
  if ((iDel = 1) And (S = '000')) then S := '';
  Result := S;
end;

function gsNos04i(iVal: Integer; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('0000' + gsIStr(iVal), 4);
  if ((iDel = 1) And (S = '0000')) then S := '';
  Result := S;
end;

function gsNos06o(iVal: LongInt; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000000' + gsOStr(iVal), 6);
  if ((iDel = 1) And (S = '000000')) then S := '';
  Result := S;
end;

function gsNos06c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000000' + gsCStr(cVal), 6);
  if ((iDel = 1) And (S = '000000')) then S := '';
  Result := S;
end;

function gsNos06s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000000' + gsTrim(sStr), 6);
  if ((iDel = 1) And (S = '000000')) then S := '';
  Result := S;
end;

function gsNos08o(iVal: Integer; iDel: Integer = 0): String;
var
  S: String;
begin
    S := gsRight('00000000' + gsOStr(iVal), 8);
    if ((iDel = 1) And (S = '00000000')) then S := '';
    Result := S;
end;

function gsNos08c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
    S := gsRight('00000000' + gsCStr(cVal), 8);
    if ((iDel = 1) And (S = '00000000')) then S := '';
    Result := S;
end;

function gsNos08s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
    S := gsRight('00000000' + gsTrim(sStr), 8);
    if ((iDel = 1) And (S = '00000000')) then S := '';
    Result := S;
end;

function gsNos09c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
    S := gsRight('000000000' + gsCStr(cVal), 9);
    if ((iDel = 1) And (S = '000000000')) then S := '';
    Result := S;
end;

function gsNos09s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
    S := gsRight('000000000' + gsTrim(sStr), 9);
    if ((iDel = 1) And (S = '000000000')) then S := '';
    Result := S;
end;

function gsNos10c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('0000000000' + gsCStr(cVal), 10);
  if ((iDel = 1) And (S = '0000000000')) then S := '';
  Result := S;
end;

function gsNos10s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('0000000000' + gsTrim(sStr), 10);
  if ((iDel = 1) And (S = '0000000000')) then S := '';
  Result := S;
end;

function gsNos11c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('00000000000' + gsCStr(cVal), 11);
  if ((iDel = 1) And (S = '00000000000')) then S := '';
  Result := S;
end;

function gsNos11s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('00000000000' + gsTrim(sStr), 11);
  if ((iDel = 1) And (S = '00000000000')) then S := '';
  Result := S;
end;

function gsNos12c(cVal: Currency; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000000000000' + gsCStr(cVal), 12);
  if ((iDel = 1) And (S = '000000000000')) then S := '';
  Result := S;
end;

function gsNos12s(sStr: String; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsRight('000000000000' + gsTrim(sStr), 12);
  if ((iDel = 1) And (S = '000000000000')) then S := '';
  Result := S;
end;

function gcNos10T3(iVal0: Integer; iVal1: Integer; iVal2: Integer): Currency;
begin
  Result := gcValue(gsNos03i(iVal0) + gsNos03i(iVal1) + gsNos04i(iVal2));
end;

function gsNos10T3(iVal0: Integer; iVal1: Integer; iVal2: Integer; iDel: Integer = 0): String;
var
  S: String;
begin
  S := gsNos10c(gcNos10T3(iVal0, iVal1, iVal2), iDel);
  Result := S;
end;

function gsNos334(sStr: String; iSel: Integer = 0): String;
var
  S: String;
  S0, S1, S2: String;
begin
  S := gsRight(gsString('0', 10) + sStr, 10);
  S0 := gsMid(S, 1, 3);
  S1 := gsMid(S, 4, 3);
  S2 := gsMid(S, 7, 4);
  if (iSel = 1) then
    begin
      S0 := gsIStr(GiValue(S0));
      S1 := gsIStr(GiValue(S1));
      S2 := gsIStr(GiValue(S2));
    end;
  Result := S0 + '-' + S1 + '-' + S2;
end;

procedure gtGet334(cNo: Currency; var iNo0: Integer; var iNo1: Integer; var iNo2: Integer);
var
  S: String;
begin
  S := gsCStr(cNo, 0, 10);
  iNo0 := giValue(gsMid(S, 1, 3));
  iNo1 := giValue(gsMid(S, 4, 3));
  iNo2 := giValue(gsMid(S, 7, 4));
end;

function gcGetGumToTax(cGum: Currency; iInt: Integer = 0): Currency;
var
  R: Currency;
  iSgn: Integer;
  cTax, cBuga: Currency;
begin
  if (cGum <> 0) then
    begin
      if (cGum < 0) then iSgn := -1 else iSgn := 1;
      cGum := gcAbs(cGum);
      if (iInt = 0) then
        cBuga := gcAdd(gcMul(cGum, 0.1), 0.005, 0)
      else
        cBuga := gcAdd(gcMul(cGum, 0.1), 0.5, 1)
      ;
      cTax := gcAdd(cGum, cBuga);
      cTax := cTax * iSgn;
      cBuga := cBuga * iSgn;
    end
  else
    begin
      cTax := 0;
      cBuga := 0;
    end;
  GcGetTaxTo_Tax := cTax;
  GcGetTaxTo_Buga := cBuga;
  R := cTax;
  Result := R;
end;

function gcGetTaxToGum(cTax: Currency; iInt: Integer = 0): Currency;
var
  R: Currency;
  iSgn: Integer;
  cGum, cBuga: Currency;
begin
  R := 0;
  if (cTax <> 0) then
    begin
      if (cTax < 0) then iSgn := -1 else iSgn := 1;
      cTax := gcAbs(cTax);
      if (iInt = 0) then
        cGum := gcAdd(gcDiv(cTax, 1.1), 0.005, 0)
      else
        cGum := gcAdd(gcDiv(cTax, 1.1), 0.5, 1)
      ;
      cBuga := gcSub(cTax, cGum);
      cGum := cGum * iSgn;
      cBuga := cBuga * iSgn;
    end
  else
    begin
      cGum := 0;
      cBuga := 0;
    end;
  GcGetTaxTo_Gum := cGum;
  GcGetTaxTo_Buga := cBuga;
  R := cGum;
  Result := R;
end;

//매출:매익율
function gcPiik1(cIik: Currency; cPanme: Currency): Currency;
var
  R: Currency;
begin
  R := gcMul(gcDiv(cIik, cPanme, -1), 100);
  if ((cIik = 0) Or (cPanme = 0)) then R := 0;
  Result := R;
end;

//매출:이익율
function gcPiik2(cIik: Currency; cPanme: Currency): Currency;
var
  R: Currency;
  cWonga: Currency;
begin
  cWonga := gcSub(cPanme, cIik);
  R := gcMul(gcDiv(cIik, cWonga, -1), 100);
  if ((cIik = 0) Or (cPanme = 0)) then R := 0;
  Result := R;
end;

//매입:매익율
function gcWiik1(cIik: Currency; cWonga: Currency): Currency;
var
  R: Currency;
  cPanme: Currency;
begin
  cPanme := gcAdd(cWonga, cIik);
  R := gcMul(gcDiv(cIik, cPanme, -1), 100);
  if ((cIik = 0) Or (cWonga = 0)) then R := 0;
  Result := R;
end;

//매입:이익율
function gcWiik2(cIik: Currency; cWonga: Currency): Currency;
var
  R: Currency;
begin
  R := gcMul(gcDiv(cIik, cWonga, -1), 100);
  if ((cIik = 0) Or (cWonga = 0)) then R := 0;
  Result := R;
end;

//기타:매익율
function gcXiik1(cWonga: Currency; cPanme: Currency): Currency;
var
  R: Currency;
  cIik: Currency;
begin
  cIik := gcSub(cPanme, cWonga);
  R := gcMul(gcDiv(cIik, cPanme, -1), 100);
  if ((cWonga = 0) Or (cPanme = 0)) then R := 0;
  Result := R;
end;

//기타:이익율
function gcXiik2(cWonga: Currency; cPanme: Currency): Currency;
var
  R: Currency;
  cIik: Currency;
begin
  cIik := gcSub(cPanme, cWonga);
  R := gcMul(gcDiv(cIik, cWonga, -1), 100);
  if ((cWonga = 0) Or (cPanme = 0)) then R := 0;
  Result := R;
end;

//매익율-더한금액구하기
function gcComputeAddIik1(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
var
  R: Currency;
begin
  R := gcDiv(cGum, gcDiv(gcSub(100, cIrt), 100, -1), iInt); //매익율
  Result := R;
end;

//이익율-더한금액구하기
function gcComputeAddIik2(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
var
  R: Currency;
begin
  R := gcAdd(cGum, gcMul(cGum, gcDiv(cIrt, 100, -1)), iInt); //이익율
  Result := R;
end;

//이익율-금액구하기
function gcComputeIik2(cGum: Currency; cIrt: Currency; iInt: Integer = 0): Currency;
var
  R: Currency;
begin
  R := gcMul(cGum, gcDiv(cIrt, 100, -1), iInt); //이익율
  Result := R;
end;

//월세계산
function gcComputeMonPayGum(sStDate: String;  sEdDate: String; cMonPay: Currency): Currency;
var
  R: Currency;
  iMons, iMCnt, iSt1, iLt1, iEd2, iLt2: Integer;
label
  LastProc;
begin
  R := 0;
  if (cMonPay = 0) then goto LastProc;
  if (sStDate > sEdDate) then goto LastProc;
  iMons := giStDateEdDateMon(sStDate, sEdDate);
  if (iMons < 0) then goto LastProc;
  iSt1 := giValue(gsMid(sStDate, 7, 2));
  iLt1 := giGetLastDay(giValue(gsMid(sStDate, 1, 4)), giValue(gsMid(sStDate, 5, 2)));
  iEd2 := giValue(gsMid(sEdDate, 7, 2));
  iLt2 := giGetLastDay(giValue(gsMid(sEdDate, 1, 4)), giValue(gsMid(sEdDate, 5, 2)));
  iMCnt := 0;
  if (iMons >= 2) then begin iMCnt := iMons - 1; iMons := 1; end;
  if (iMons = 0) then //1-Mons
    begin
      if (iSt1 = 1) And (iEd2 = iLt2) then //현재Full
        iMCnt := iMCnt + 1
      else
        R := R + gcMul(cMonPay, gcDiv((iEd2 - iSt1 + 1), iLt2, 0), 1)
      ;
    end
  else //2-Mons
    begin
      if (iSt1 = 1) then //전월Full
        iMCnt := iMCnt + 1
      else
        R := R + gcMul(cMonPay, gcDiv((iLt1 - iSt1 + 1), iLt1, 0), 1)
      ;
      if (iEd2 = iLt2) then //당월Full
          iMCnt := iMCnt + 1
      else
          R := R + gcMul(cMonPay, gcDiv(iEd2, iLt2, 0), 1)
      ;
    end;
  R := R + gcMul(cMonPay, iMCnt, 1);
LastProc:
  Result := R;
end;

end.

