﻿Imports System.IO

Public Class SetsFrm

    Private Sub SetsFrm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        If FN.gsRight(Msx1Lbl.Text, 1) = " " Then Msx1Lbl.Text = Msx1Lbl.Text + MSX.vnMSX_Version '+[&]

        If (MSX.Gi_MSX2_Sets = 0) Then MsxSelt0Opt.Checked = True Else MsxSelt1Opt.Checked = True
        If (MSX.Gi_DISK_Sets = 0) Then DiskSelt0Opt.Checked = True Else DiskSelt1Opt.Checked = True
        If (MSX.Gi_CHAR_Sets = 0) Then FontSelt0Opt.Checked = True Else FontSelt1Opt.Checked = True

        TimerTxt.Text = FN.gsCStr(MSX.Gi_MSX_Int_Timer, 0)
        If (MSX.Gi_MSX_Int_Timer = 0) Then TimerTxt.Text = ""
        If ((MSX.Gi_MSX_DisplayFrame < 0) Or (MSX.Gi_MSX_DisplayFrame > 3)) Then MSX.Gi_MSX_DisplayFrame = 0
        If (MSX.Gi_MSX_DisplayFrame = 0) Then DspFrame0Opt.Checked = True
        If (MSX.Gi_MSX_DisplayFrame = 1) Then DspFrame1Opt.Checked = True
        If (MSX.Gi_MSX_DisplayFrame = 2) Then DspFrame2Opt.Checked = True
        If (MSX.Gi_MSX_DisplayFrame = 3) Then DspFrame3Opt.Checked = True

        IntDupeChk.Checked = IIf(MSX.Gi_MSX_InterruptDup = 0, False, True)
        AutoSpeedChk.Checked = IIf(MSX.Gi_MSX_Auto_Speed = 0, False, True)
        KeyChangeChk.Checked = IIf(MSX.Gi_MSX_KeyChange = 0, False, True)
        JoyStickChk.Checked = IIf(MSX.Gi_MSX_JoyOn = 0, False, True)
        SpaceOnChk.Checked = IIf(MSX.Gi_MSX_SpaceOn = 0, False, True)
        VdtStFfChk.Checked = IIf(MSX.Gi_MSX_VDT_ST_FF = 0, False, True)

        CasFileTxt.Text = MSX.Gs_CAS_FILE
        RomFileTxt.Text = MSX.Gs_ROM_FILE
        If ((MSX.Gi_ROM_TYPE < 0) Or (MSX.Gi_ROM_TYPE > 5)) Then MSX.Gi_ROM_TYPE = 0
        If (MSX.Gi_ROM_TYPE = 0) Then RomSelt0Opt.Checked = True
        If (MSX.Gi_ROM_TYPE = 1) Then RomSelt1Opt.Checked = True
        If (MSX.Gi_ROM_TYPE = 2) Then RomSelt2Opt.Checked = True
        If (MSX.Gi_ROM_TYPE = 3) Then RomSelt3Opt.Checked = True
        If (MSX.Gi_ROM_TYPE = 4) Then RomSelt4Opt.Checked = True
        If (MSX.Gi_ROM_TYPE = 5) Then RomSelt5Opt.Checked = True
        DskAFileTxt.Text = MSX.Gs_DSK_A_FILE
        DskBFileTxt.Text = MSX.Gs_DSK_B_FILE
        DskAOnChk.Checked = IIf(MSX.Gi_DSK_A_ON = 0, False, True)
        DskBOnChk.Checked = IIf(MSX.Gi_DSK_B_ON = 0, False, True)

    End Sub

    Private Sub SetsFrm_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        '
    End Sub

    Private Sub SetEnterCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetEnterCmd.Click

        Call WRITE_MSX_SETTING()
        Me.Close()

    End Sub

    Private Sub SetExitCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetExitCmd.Click

        Me.Close()

    End Sub

    Private Sub CasFileTxt_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles CasFileTxt.Leave

        CasFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(CasFileTxt.Text, 100)))
        CasFileTxt.Text = MSX.gsGetCasFileName(CasFileTxt.Text)

    End Sub

    Private Sub RomFileTxt_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles RomFileTxt.Leave

        RomFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(RomFileTxt.Text, 100)))
        RomFileTxt.Text = MSX.gsGetRomFileName(RomFileTxt.Text)

    End Sub

    Private Sub DskAFileTxt_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles DskAFileTxt.Leave

        DskAFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(DskAFileTxt.Text, 100)))
        DskAFileTxt.Text = MSX.gsGetDskFileName(DskAFileTxt.Text)

    End Sub

    Private Sub DskBFileTxt_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles DskBFileTxt.Leave

        DskBFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(DskBFileTxt.Text, 100)))
        DskBFileTxt.Text = MSX.gsGetDskFileName(DskBFileTxt.Text)

    End Sub

    Private Sub CasWriteCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CasWriteCmd.Click

        Dim WriteStream As FileStream

        Dim FileName As String
        Dim TXT_TAB As Integer, VAR_TAB As Integer, ARY_TAB As Integer, STR_END As Integer
        Dim L As Integer

        SetEnterCmd.Focus()

        FileName = "C:\MSX-" + DateTime.Now.ToString("yyyyMMdd") + "-" + DateTime.Now.ToString("HHmmss") + ".CAS"

        Cursor = Cursors.WaitCursor
        CasWriteCmd.Enabled = False

        TXT_TAB = MEM.GET_MSX_MEMORY_16(&HF676)
        VAR_TAB = MEM.GET_MSX_MEMORY_16(&HF6C2)
        ARY_TAB = MEM.GET_MSX_MEMORY_16(&HF6C4)
        STR_END = MEM.GET_MSX_MEMORY_16(&HF6C6)

        WriteStream = New FileStream(FileName, FileMode.Create)
        Dim bw As New BinaryWriter(WriteStream)

        bw.BaseStream.WriteByte(Z80A.giGetLngToIntL(TXT_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntH(TXT_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntL(VAR_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntH(VAR_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntL(ARY_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntH(ARY_TAB))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntL(STR_END))
        bw.BaseStream.WriteByte(Z80A.giGetLngToIntH(STR_END))

        For L = TXT_TAB To (VAR_TAB - 1)
            bw.BaseStream.WriteByte(MEM.GET_MSX_MEMORY(L))
        Next L

        bw.Close()

        CasWriteCmd.Enabled = True
        Cursor = Cursors.Default

    End Sub

    Private Sub CasHelpCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CasHelpCmd.Click

        CasFileTxt.Text = ShowFileOpenDialog()
        CasFileTxt.Focus()

    End Sub

    Private Sub CasEnterCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CasEnterCmd.Click

        Dim ReadStream As FileStream

        Dim FileName As String
        Dim TXT_TAB As Integer, VAR_TAB As Integer, ARY_TAB As Integer, STR_END As Integer
        Dim RecordCount As Integer
        Dim StartNo As Integer = 0
        Dim B As Integer, S As String

        SetEnterCmd.Focus()

        FDC.Gi_MSX_TAPE_Work = 0 'Tape Read 초기화

        FileName = FN.gsTrim(CasFileTxt.Text)
        If (FileName = "") Then GoTo ExitProc
        If (FN.giInStr(1, FileName, "MSX-") = 0) Then GoTo ExitProc

        Cursor = Cursors.WaitCursor
        CasEnterCmd.Enabled = False

        TXT_TAB = 0 : VAR_TAB = 0 : ARY_TAB = 0 : STR_END = 0
        ReadStream = New FileStream(FileName, FileMode.Open)
        Dim br As New BinaryReader(ReadStream)

        RecordCount = 0

        While (True)
            Try
                B = br.ReadByte()
                If (RecordCount = 0) Then TXT_TAB = TXT_TAB + B
                If (RecordCount = 1) Then TXT_TAB = TXT_TAB + (B * 256) : StartNo = TXT_TAB
                If (RecordCount = 2) Then VAR_TAB = VAR_TAB + B
                If (RecordCount = 3) Then VAR_TAB = VAR_TAB + (B * 256)
                If (RecordCount = 4) Then ARY_TAB = ARY_TAB + B
                If (RecordCount = 5) Then ARY_TAB = ARY_TAB + (B * 256)
                If (RecordCount = 6) Then STR_END = STR_END + B
                If (RecordCount = 7) Then STR_END = STR_END + (B * 256)
                If (RecordCount >= 8) Then Call MEM.PUT_MSX_MEMORY(StartNo, B) : StartNo += 1
                RecordCount += 1
            Catch ex As Exception
                S = ex.ToString()
                br.Close()
                GoTo BreakProc
            End Try
        End While

BreakProc:
        Call MEM.PUT_MSX_MEMORY_16(&HF6C2, VAR_TAB)
        Call MEM.PUT_MSX_MEMORY_16(&HF6C4, VAR_TAB)
        Call MEM.PUT_MSX_MEMORY_16(&HF6C6, VAR_TAB)

        br.Close()

        CasEnterCmd.Enabled = True
        Cursor = Cursors.Default

ExitProc:

    End Sub

    Private Sub RomHelpCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RomHelpCmd.Click

        RomFileTxt.Text = ShowFileOpenDialog()
        RomFileTxt.Focus()

    End Sub

    Private Sub RomEnterCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RomEnterCmd.Click

        Dim ReadStream As FileStream

        Dim FileName As String
        Dim RecordCount As Integer
        Dim StartNo As Integer
        Dim B As Integer, B0 As Integer = 0, B1 As Integer = 0, B2 As Integer = 0, B3 As Integer = 0, S As String
        Dim fl As Long

        SetEnterCmd.Focus()

        FileName = FN.gsTrim(RomFileTxt.Text)
        If (FileName = "") Then GoTo ExitProc

        Cursor = Cursors.WaitCursor
        RomEnterCmd.Enabled = False

        MEM.Gi_Big32K_ROM = 0
        fl = New System.IO.FileInfo(FileName).Length
        If (fl > 32768) Then MEM.Gi_Big32K_ROM = 1

        ReadStream = New FileStream(FileName, FileMode.Open)
        Dim br As New BinaryReader(ReadStream)
        StartNo = &H4000
        RecordCount = 0

        While (True)
            Try
                B = br.ReadByte()
                If (RecordCount = 0) Then B0 = MEM.MSX_MEM(1, StartNo)
                If (RecordCount = 1) Then B1 = MEM.MSX_MEM(1, StartNo)
                If (RecordCount = 2) Then B2 = MEM.MSX_MEM(1, StartNo)
                If (RecordCount = 3) Then B3 = MEM.MSX_MEM(1, StartNo)
                If (StartNo <= 49151) Then MEM.MSX_MEM(1, StartNo) = B 'Slot#1 MEM [4000~7FFF]
                MEM.MSX_ROM(RecordCount) = B 'Mega ROM [0000~4MB]
                If ((MEM.Gi_Big32K_ROM = 0) And (RecordCount = 3) And (B >= &H80)) Then
                    MEM.MSX_MEM(1, &H8000) = MEM.MSX_MEM(1, &H4000)
                    MEM.MSX_MEM(1, &H8001) = MEM.MSX_MEM(1, &H4001)
                    MEM.MSX_MEM(1, &H8002) = MEM.MSX_MEM(1, &H4002)
                    MEM.MSX_MEM(1, &H8003) = MEM.MSX_MEM(1, &H4003)
                    MEM.MSX_MEM(1, &H4000) = B0
                    MEM.MSX_MEM(1, &H4001) = B1
                    MEM.MSX_MEM(1, &H4002) = B2
                    MEM.MSX_MEM(1, &H4003) = B3
                    StartNo = (StartNo + &H4000) '8000~
                End If
                StartNo += 1
                RecordCount += 1
            Catch ex As Exception
                S = ex.ToString()
                br.Close()
                GoTo BreakProc
            End Try
        End While

BreakProc:
        br.Close()

        RomEnterCmd.Enabled = True
        Cursor = Cursors.Default

ExitProc:

    End Sub

    Private Sub DskAHelpCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DskAHelpCmd.Click

        DskAFileTxt.Text = ShowFileOpenDialog()
        DskAFileTxt.Focus()

    End Sub

    Private Sub DskBHelpCmd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DskBHelpCmd.Click

        DskBFileTxt.Text = ShowFileOpenDialog()
        DskBFileTxt.Focus()

    End Sub

    Private Sub TimerTxt_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles TimerTxt.Leave

        Dim iVal As Integer

        iVal = FN.giVal(FN.gsRight(FN.gsTrim(TimerTxt.Text), 5))
        If ((iVal < 10) Or (iVal > 100)) Then iVal = 0
        TimerTxt.Text = FN.gsCStr(iVal, 0)
        If (iVal = 0) Then TimerTxt.Text = ""

    End Sub

    Private Function ShowFileOpenDialog() As String

        Dim R As String

        Dim OpenFileDialog1 As New OpenFileDialog

        R = ""

        OpenFileDialog1.Title = "열기"
        OpenFileDialog1.FileName = ""
        OpenFileDialog1.Filter = "모든 파일 (*.*)|*.*|CAS 파일|*.CAS|ROM 파일|*.ROM|DISK 파일|*.DSK"

        OpenFileDialog1.ShowDialog()

        R = OpenFileDialog1.FileName

        ShowFileOpenDialog = R

    End Function

    Private Sub WRITE_MSX_SETTING()

        If (MsxSelt0Opt.Checked = True) Then MSX.Gi_MSX2_Sets = 0 Else MSX.Gi_MSX2_Sets = 1
        If (DiskSelt0Opt.Checked = True) Then MSX.Gi_DISK_Sets = 0 Else MSX.Gi_DISK_Sets = 1
        If (FontSelt0Opt.Checked = True) Then MSX.Gi_CHAR_Sets = 0 Else MSX.Gi_CHAR_Sets = 1

        MSX.Gi_MSX_Int_Timer = FN.giVal(FN.gsRight(FN.gsTrim(TimerTxt.Text), 5))
        If ((MSX.Gi_MSX_Int_Timer < 10) Or (MSX.Gi_MSX_Int_Timer > 100)) Then MSX.Gi_MSX_Int_Timer = 0
        MSX.Gi_MSX_DisplayFrame = 0
        If (DspFrame0Opt.Checked = True) Then MSX.Gi_MSX_DisplayFrame = 0
        If (DspFrame1Opt.Checked = True) Then MSX.Gi_MSX_DisplayFrame = 1
        If (DspFrame2Opt.Checked = True) Then MSX.Gi_MSX_DisplayFrame = 2
        If (DspFrame3Opt.Checked = True) Then MSX.Gi_MSX_DisplayFrame = 3

        MSX.Gi_MSX_InterruptDup = IIf(IntDupeChk.Checked = False, 0, 1)
        MSX.Gi_MSX_Auto_Speed = IIf(AutoSpeedChk.Checked = False, 0, 1)
        MSX.Gi_MSX_KeyChange = IIf(KeyChangeChk.Checked = False, 0, 1)
        MSX.Gi_MSX_JoyOn = IIf(JoyStickChk.Checked = False, 0, 1)
        MSX.Gi_MSX_SpaceOn = IIf(SpaceOnChk.Checked = False, 0, 1)
        MSX.Gi_MSX_VDT_ST_FF = IIf(VdtStFfChk.Checked = False, 0, 1)

        MSX.Gs_CAS_FILE = FN.gsTrim(FN.gsLeft(CasFileTxt.Text, 100))
        MSX.Gs_ROM_FILE = FN.gsTrim(FN.gsLeft(RomFileTxt.Text, 100))
        MSX.Gi_ROM_TYPE = 0
        If (RomSelt0Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 0
        If (RomSelt1Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 1
        If (RomSelt2Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 2
        If (RomSelt3Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 3
        If (RomSelt4Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 4
        If (RomSelt5Opt.Checked = True) Then MSX.Gi_ROM_TYPE = 5
        MSX.Gs_DSK_A_FILE = FN.gsTrim(FN.gsLeft(DskAFileTxt.Text, 100))
        MSX.Gs_DSK_B_FILE = FN.gsTrim(FN.gsLeft(DskBFileTxt.Text, 100))
        MSX.Gi_DSK_A_ON = IIf(DskAOnChk.Checked = False, 0, 1)
        MSX.Gi_DSK_B_ON = IIf(DskBOnChk.Checked = False, 0, 1)
        If (MSX.Gs_DSK_A_FILE = "") Then MSX.Gi_DSK_A_ON = 0
        If (MSX.Gs_DSK_B_FILE = "") Then MSX.Gi_DSK_B_ON = 0

        Call REG.giUpdateRegistry("MSX_Machine", MSX.Gi_MSX2_Sets)
        Call REG.giUpdateRegistry("MSX_DiskRom", MSX.Gi_DISK_Sets)
        Call REG.giUpdateRegistry("MSX_CharFont", MSX.Gi_CHAR_Sets)

        Call REG.giUpdateRegistry("MSX_IntTimer", MSX.Gi_MSX_Int_Timer)
        Call REG.giUpdateRegistry("MSX_DisplayFrame", MSX.Gi_MSX_DisplayFrame)

        Call REG.giUpdateRegistry("MSX_InterruptDup", MSX.Gi_MSX_InterruptDup)
        Call REG.giUpdateRegistry("MSX_AutoSpeed", MSX.Gi_MSX_Auto_Speed)
        Call REG.giUpdateRegistry("MSX_KeyChange", MSX.Gi_MSX_KeyChange)
        Call REG.giUpdateRegistry("MSX_JoyOn", MSX.Gi_MSX_JoyOn)
        Call REG.giUpdateRegistry("MSX_SpaceOn", MSX.Gi_MSX_SpaceOn)
        Call REG.giUpdateRegistry("MSX_VdtStFf", MSX.Gi_MSX_VDT_ST_FF)

        Call REG.gsUpdateRegistry("MSX_CasFile", MSX.Gs_CAS_FILE)
        Call REG.gsUpdateRegistry("MSX_RomFile", MSX.Gs_ROM_FILE)
        Call REG.giUpdateRegistry("MSX_RomType", MSX.Gi_ROM_TYPE)
        Call REG.gsUpdateRegistry("MSX_DiskAFile", MSX.Gs_DSK_A_FILE)
        Call REG.gsUpdateRegistry("MSX_DiskBFile", MSX.Gs_DSK_B_FILE)

    End Sub
End Class
