﻿Namespace INT

    Module msxINT

        Public Gi_MSX_Interrupt As Integer '1:인터럽트수행중
        Public Go_MSX_InterruptBack As Integer '0~65535
        Public Gi_Z80A_EI_Chk As Integer '1:직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)
        Public Const Gi_Z80A_EI_Cnt As Integer = 2

        Public Z80A_INT_MODE As Integer
        Public Z80A_HALT As Integer

        Public Sub MSX_INIT_INT()

            Gi_MSX_Interrupt = 0 '1:인터럽트수행중
            Go_MSX_InterruptBack = 0
            Gi_Z80A_EI_Chk = 0

            Z80A_INT_MODE = 0
            Z80A_HALT = 0

        End Sub

        Public Sub gt_NOP()
            '            '
        End Sub

        Public Sub gt_HALT()

            'MsgBox ("* SYSTEM HALT !")

        End Sub

        Public Sub gt_DI()

            Z80A.Z80A_REG_IFF1 = 0
            Z80A.Z80A_REG_IFF2 = 0

        End Sub

        Public Sub gt_EI()

            Z80A.Z80A_REG_IFF1 = 1
            Z80A.Z80A_REG_IFF2 = 1

        End Sub

        Public Sub gt_LD_I_A()

            Z80A.Z80A_REG_I = Z80A.Z80A_REG_A

        End Sub

        Public Sub gt_LD_R_A()

            Z80A.Z80A_REG_R = Z80A.Z80A_REG_A

        End Sub

        Public Sub gt_LD_A_I()

            'A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
            'If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
            Call Z80A.PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Z80A.Z80A_REG_A = Z80A.Z80A_REG_I
            'Z80A_FLAG_C = ? '캐리
            Call Z80A.PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call Z80A.PUT_Z80A_FLAG_PV(Z80A.Z80A_REG_IFF2) '오버플로
            Call Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Z80A.Z80A_REG_A)) 'Sign
            Call Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Z80A.Z80A_REG_A)) 'Zero

        End Sub

        Public Sub gt_LD_A_R()

            'A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
            'If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
            Call Z80A.PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Z80A.Z80A_REG_A = Z80A.Z80A_REG_R
            'Z80A_FLAG_C = ? '캐리
            Call Z80A.PUT_Z80A_FLAG_H(0) '하프캐리
            Call Z80A.PUT_Z80A_FLAG_PV(Z80A.Z80A_REG_IFF2) '오버플로
            Call Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Z80A.Z80A_REG_A)) 'Sign
            Call Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Z80A.Z80A_REG_A)) 'Zero

        End Sub

        Public Sub gt_IM_0()

            INT.Z80A_INT_MODE = 0

        End Sub

        Public Sub gt_IM_1()

            INT.Z80A_INT_MODE = 1

        End Sub

        Public Sub gt_IM_2()

            INT.Z80A_INT_MODE = 2

        End Sub

        Public Sub gt_IM_0_1()

            '??? 알려지지않음

        End Sub

        Public Sub gt_RETI()

            'RET

        End Sub

        Public Sub gt_RETN()

            Z80A.Z80A_REG_IFF1 = Z80A.Z80A_REG_IFF2
            'RET

        End Sub

        Public Sub gt_RST_00()

            Call gt_RST(&H0)

        End Sub

        Public Sub gt_RST_08()

            Call gt_RST(&H8)

        End Sub

        Public Sub gt_RST_10()

            Call gt_RST(&H10)

        End Sub

        Public Sub gt_RST_18()

            Call gt_RST(&H18)

        End Sub

        Public Sub gt_RST_20()

            Call gt_RST(&H20)

        End Sub

        Public Sub gt_RST_28()

            Call gt_RST(&H28)

        End Sub

        Public Sub gt_RST_30()

            Call gt_RST(&H30)

        End Sub

        Public Sub gt_RST_38()

            Call gt_RST(&H38)

        End Sub

        Public Sub gt_RST(ByVal iVal As Integer) 'Call 명령과 동일

            Call Z80A.gt_PUSH_16(((Z80A.Z80A_REG_PC + 1) And &HFFFF))
            Z80A.Z80A_REG_PC = iVal

        End Sub
    End Module

End Namespace
