﻿Namespace IO

    Module msxIO

        Public MSX_PORT(256 - 1) As Integer '0~255 (0~255)

        'MSX2, CLOCK-IC, 레지스터4비트 - 배터리로백업됨
        'BLOCK0 - 0~12(CLOCK), 13(MODE), 14(TEST-기록전용), 15(RESET-기록전용)
        'LOCK1 - 0~12(ALARM)
        'LOCK2 - 0~12(RAM-1)
        'LOCK3 - 0~12(RAM-2)
        'ODE(0:Clock카운트의정지(초이상),1:개시/0:알람출력Off,1:On/00~11:블럭0~3선택)
        Public MSX_CLOCK_REG(4 - 1, 16 - 1) As Integer '0~255 (0~3, 0~15)

        Public Gi_MSX_PortWrite As Integer '1:Port Write (Test용)

        Public Sub MSX_INIT_IO()

            Dim i As Integer, j As Integer

            For i = 0 To 255
                MSX_PORT(i) = 0
            Next i

            For i = 0 To 3 'MSX2
                For j = 0 To 15
                    MSX_CLOCK_REG(i, j) = 0
                Next j
            Next i

        End Sub

        Public Function GET_MSX_PORT(ByVal iAddress As Integer) As Integer

            Dim GET_PORT_VAL As Integer, C As Integer

            GET_PORT_VAL = 0 'Default

            'RS-232C (8251A)
            'If (iAddress = &H80) Then 'Data Read
            'If (iAddress = &H81) Then 'Status Read

            '프린터
            If (iAddress = &H90) Then GET_PORT_VAL = MSX_PORT(iAddress) 'Status Read (b1)

            'VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
            'MAIN-ROM (6번지)값 참조
            If (iAddress = &H98) Then 'Video 램에서의 Data Read / VRAM data read/write port
                'if (VDT.Gi_MSX_VRAM_IO = 1)
                '{
                GET_PORT_VAL = VDT.MSX_VRAM(VDT.Go_MSX_VRAM_ADDRESS)
                VDT.Go_MSX_VRAM_ADDRESS += 1
                If (MSX.GiMSX2 = 0) Then 'MSX1
                    If (VDT.Go_MSX_VRAM_ADDRESS > 16383) Then VDT.Go_MSX_VRAM_ADDRESS = 0
                Else 'MSX2
                    If (VDT.Go_MSX_VRAM_ADDRESS > 131071) Then VDT.Go_MSX_VRAM_ADDRESS = 0
                End If
                '};
            End If
            'VDP 포트 #1
            'MAIN-ROM (6번지)값+1
            If (iAddress = &H99) Then 'Status Read / Status register read port
                If (MSX.GiMSX2 = 0) Then 'MSX1
                    GET_PORT_VAL = VDT.MSX_VDT_REG_ST() : VDT.MSX_VDT_ST_REG_FF = 0 'Clear
                Else 'MSX2
                    If (VDT.MSX_VDT_REG(15) = 0) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST() : VDT.MSX_VDT_ST_REG_FF = 0 'Clear '1(4)=0000
                    If (VDT.MSX_VDT_REG(15) = 1) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST1() : VDT.MSX_VDT_ST_REG_FH = 0 'Clear
                    If (VDT.MSX_VDT_REG(15) = 2) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST2()
                    If (VDT.MSX_VDT_REG(15) = 3) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST3()
                    If (VDT.MSX_VDT_REG(15) = 4) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST4()
                    If (VDT.MSX_VDT_REG(15) = 5) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST5()
                    If (VDT.MSX_VDT_REG(15) = 6) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST6()
                    If (VDT.MSX_VDT_REG(15) = 7) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST7()
                    If (VDT.MSX_VDT_REG(15) = 8) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST8()
                    If (VDT.MSX_VDT_REG(15) = 9) Then GET_PORT_VAL = VDT.MSX_VDT_REG_ST9()
                End If
            End If

            'PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
            If (iAddress = &HA2) Then '지정된 Register에서 읽기
                C = MSX_PORT(&HA0)
                If (C = 0) Then GET_PORT_VAL = PSG.MSX_PSG_REG(0)
                If (C = 1) Then GET_PORT_VAL = PSG.MSX_PSG_REG(1)
                If (C = 2) Then GET_PORT_VAL = PSG.MSX_PSG_REG(2)
                If (C = 3) Then GET_PORT_VAL = PSG.MSX_PSG_REG(3)
                If (C = 4) Then GET_PORT_VAL = PSG.MSX_PSG_REG(4)
                If (C = 5) Then GET_PORT_VAL = PSG.MSX_PSG_REG(5)
                If (C = 6) Then GET_PORT_VAL = PSG.MSX_PSG_REG(6)
                If (C = 7) Then GET_PORT_VAL = PSG.MSX_PSG_REG(7)
                If (C = 8) Then GET_PORT_VAL = PSG.MSX_PSG_REG(8)
                If (C = 9) Then GET_PORT_VAL = PSG.MSX_PSG_REG(9)
                If (C = 10) Then GET_PORT_VAL = PSG.MSX_PSG_REG(10)
                If (C = 11) Then GET_PORT_VAL = PSG.MSX_PSG_REG(11)
                If (C = 12) Then GET_PORT_VAL = PSG.MSX_PSG_REG(12)
                If (C = 13) Then GET_PORT_VAL = PSG.MSX_PSG_REG(13)
                If (C = 14) Then PSG.SET_MSX_PSG_STATUS() : GET_PORT_VAL = PSG.MSX_PSG_REG(14) 'I/O포트A(Read),Cas, Jis, Trigger B, A, R, L, D, U (1:안눌림)
                If (C = 15) Then GET_PORT_VAL = PSG.MSX_PSG_REG(15) 'I/O포트B(Write)
            End If

            'PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
            If (iAddress = &HA8) Then 'PPI-register A / Primary slot select register
                GET_PORT_VAL = PPI.GET_MSX_PPI_REG_A()
            End If
            If (iAddress = &HA9) Then 'PPI-register B / Keyboard matrix row input register
                PPI.SET_MSX_KEY_STATUS()
                GET_PORT_VAL = PPI.MSX_PPI_REG_B 'Keyboard matrix row input register
            End If
            If (iAddress = &HAA) Then 'PPI-register C / Keyboard and cassette interface
                GET_PORT_VAL = PPI.GET_MSX_PPI_REG_C()
            End If

            If (iAddress = &HB5) Then '지정된 Clock 블록+Reg 읽기
                C = MSX_PORT(&HB4)
                If (C <= 13) Then GET_PORT_VAL = MSX_CLOCK_REG(IIf(C <= 12, MSX_CLOCK_REG(0, 13) And 3, 0), C)
            End If

            GET_MSX_PORT = GET_PORT_VAL

        End Function

        Public Sub PUT_MSX_PORT(ByVal iAddress As Integer, ByVal iVal As Integer)

            Dim C As Integer, iBit As Integer, iReg As Integer, iRegH As Integer

            'RS-232C (8251A)
            'If (iAddress = &H80) Then 'Data Write
            'If (iAddress = &H81) Then 'Mode Set

            '프린터
            If (iAddress = &H90) Then MSX_PORT(iAddress) = iVal 'Status Write (b0)
            'If (iAddress = &H91) Then 'Print Data

            'VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
            'MAIN-ROM (7번지)값 참조
            If (iAddress = &H98) Then 'Video 램으로의 Data Write / VRAM data read/write port
                'if (VDT.Gi_MSX_VRAM_IO = 2)
                '{
                VDT.MSX_VRAM(VDT.Go_MSX_VRAM_ADDRESS) = iVal
                VDT.Go_MSX_VRAM_ADDRESS += 1
                If (MSX.GiMSX2 = 0) Then 'MSX1
                    If (VDT.Go_MSX_VRAM_ADDRESS > 16383) Then VDT.Go_MSX_VRAM_ADDRESS = 0
                Else 'MSX2
                    If (VDT.Go_MSX_VRAM_ADDRESS > 131071) Then VDT.Go_MSX_VRAM_ADDRESS = 0
                End If
                VDT.Gi_MSX_Screen_Out = 1 '화면표시작업
                '};
            End If
                'VDP 포트 #1
                'MAIN-ROM (7번지)값+1
            If (iAddress = &H99) Then 'Command, Address Set / VDP register write port (bit 7=1 in second write), VRAM address register (bit 7=0 in second write, bit 6: read/write access (0=read))
                If (VDT.Gi_MSX_VRAM_Flg = 0) Then '첫번째전송
                    VDT.Gi_MSX_VRAM_Flg = 1
                    MSX_PORT(iAddress) = iVal
                Else                          '두번째전송
                    VDT.Gi_MSX_VRAM_Flg = 0
                    C = MSX_PORT(iAddress)
                    If ((iVal And 128) > 0) Then '1(1)=1 : 레지스트리에 기록
                        If (MSX.GiMSX2 = 0) Then 'MSX1
                            iReg = (iVal And 7) '6(3) - Reg번호
                        Else 'MSX2
                            iReg = (iVal And 63) '3(6) - Reg번호
                        End If
                        VDT.MSX_VDT_REG(iReg) = C
                        If ((iReg = 0) Or (iReg = 1)) Then Call VDT.MSX_SCREEN_MODE_SET() 'MSX1
                        If ((iReg = 8) Or (iReg = 9)) Then Call VDT.MSX_SCREEN_MODE_SET() 'MSX2
                        If (iReg = 2) Then Call VDT.MSX_SCREEN_MODE_SET2() 'MSX2
                        If (iReg = 8) Then Call VDT.MSX_SCREEN_MODE_SET8() 'MSX2
                        If (iReg = 9) Then Call VDT.MSX_SCREEN_MODE_SET9() 'MSX2
                        If (iReg = 14) Then Call MSX_VDT_ADDRESS_HIGH() 'MSX2
                        If (iReg = 32) Then Call VDT.MSX_VDT_CMD_REG32_SET()
                        If (iReg = 33) Then Call VDT.MSX_VDT_CMD_REG33_SET()
                        If (iReg = 34) Then Call VDT.MSX_VDT_CMD_REG34_SET()
                        If (iReg = 35) Then Call VDT.MSX_VDT_CMD_REG35_SET()
                        If (iReg = 36) Then Call VDT.MSX_VDT_CMD_REG36_SET()
                        If (iReg = 37) Then Call VDT.MSX_VDT_CMD_REG37_SET()
                        If (iReg = 38) Then Call VDT.MSX_VDT_CMD_REG38_SET()
                        If (iReg = 39) Then Call VDT.MSX_VDT_CMD_REG39_SET()
                        If (iReg = 40) Then Call VDT.MSX_VDT_CMD_REG40_SET()
                        If (iReg = 41) Then Call VDT.MSX_VDT_CMD_REG41_SET()
                        If (iReg = 42) Then Call VDT.MSX_VDT_CMD_REG42_SET()
                        If (iReg = 43) Then Call VDT.MSX_VDT_CMD_REG43_SET()
                        If (iReg = 44) Then Call VDT.MSX_VDT_CMD_REG44_SET()
                        If (iReg = 45) Then Call VDT.MSX_VDT_CMD_REG45_SET()
                        If (iReg = 46) Then Call VDT.MSX_VDT_CMD_REG46_SET()
                        VDT.Gi_MSX_Screen_Out = 1 '화면표시작업
                    Else                  '1(1)=0 : 상위 메모리번지 지정
                        iRegH = (iVal And 63) '3(6) - 상위번지(VRAM), 63=3Fh=0011 1111
                        If ((iVal And 64) = 0) Then 'Read  : 2(1)=0, 00?? ????
                            VDT.Gi_MSX_VRAM_IO = 1 'Read
                        Else                  'Write : 2(1)=1, 01?? ????
                            VDT.Gi_MSX_VRAM_IO = 2 'Write
                        End If
                        VDT.Go_MSX_VRAM_ADDRESS = Z80A.goGetIntHLToLng(iRegH, C)
                        If (MSX.GiMSX2 = 1) Then Call MSX_VDT_ADDRESS_HIGH() 'MSX2 - 상위번지
                    End If
                End If
            End If
            'VDP 포트 #2
            'MAIN-ROM (7번지)값+2
            If (iAddress = &H9A) Then '팔레트 레지스터에의 기입
                If (MSX.GiMSX2 = 1) Then 'MSX2
                    C = (VDT.MSX_VDT_REG(16) And 15) '1(4)=0000
                    If (VDT.Gi_MSX2_VRAM_Flg = 0) Then
                        VDT.MSX_VDT_REG_PAL_Red(C) = TBL.Gi_M_Table36(TBL.Gi_D_Table16(iVal And &H70)) '2(3)
                        VDT.MSX_VDT_REG_PAL_Blue(C) = TBL.Gi_M_Table36(iVal And 7) '6(3)
                        VDT.Gi_MSX2_VRAM_Flg = 1
                    Else
                        VDT.MSX_VDT_REG_PAL_Green(C) = TBL.Gi_M_Table36(iVal And 7) '6(3)
                        VDT.MSX_VDT_REG(16) = ((VDT.MSX_VDT_REG(16) + 1) And 15)
                        VDT.Gi_MSX2_VRAM_Flg = 0
                    End If
                    Call VDT.MSX_COLOR_PALETTE(C, VDT.MSX_VDT_REG_PAL_Red(C), VDT.MSX_VDT_REG_PAL_Green(C), VDT.MSX_VDT_REG_PAL_Blue(C))
                    VDT.Gi_MSX_Screen_Out = 1 '화면표시작업
                End If
            End If
            'VDP 포트 #3
            'MAIN-ROM (7번지)값+3
            If (iAddress = &H9B) Then '간접지정된 레지스터에의 기입
                If (MSX.GiMSX2 = 1) Then 'MSX2
                    iReg = (VDT.MSX_VDT_REG(17) And 63)
                    If ((iReg <> 17) And (iReg <= 46)) Then VDT.MSX_VDT_REG(iReg) = iVal 'Reg17-금지
                    If ((iReg = 0) Or (iReg = 1)) Then Call VDT.MSX_SCREEN_MODE_SET() 'MSX1
                    If (iReg = 2) Then Call VDT.MSX_SCREEN_MODE_SET2() 'MSX2
                    If (iReg = 8) Then Call VDT.MSX_SCREEN_MODE_SET8() 'MSX2
                    If (iReg = 9) Then Call VDT.MSX_SCREEN_MODE_SET9() 'MSX2
                    If (iReg = 14) Then Call MSX_VDT_ADDRESS_HIGH() 'MSX2
                    If (iReg = 32) Then Call VDT.MSX_VDT_CMD_REG32_SET()
                    If (iReg = 33) Then Call VDT.MSX_VDT_CMD_REG33_SET()
                    If (iReg = 34) Then Call VDT.MSX_VDT_CMD_REG34_SET()
                    If (iReg = 35) Then Call VDT.MSX_VDT_CMD_REG35_SET()
                    If (iReg = 36) Then Call VDT.MSX_VDT_CMD_REG36_SET()
                    If (iReg = 37) Then Call VDT.MSX_VDT_CMD_REG37_SET()
                    If (iReg = 38) Then Call VDT.MSX_VDT_CMD_REG38_SET()
                    If (iReg = 39) Then Call VDT.MSX_VDT_CMD_REG39_SET()
                    If (iReg = 40) Then Call VDT.MSX_VDT_CMD_REG40_SET()
                    If (iReg = 41) Then Call VDT.MSX_VDT_CMD_REG41_SET()
                    If (iReg = 42) Then Call VDT.MSX_VDT_CMD_REG42_SET()
                    If (iReg = 43) Then Call VDT.MSX_VDT_CMD_REG43_SET()
                    If (iReg = 44) Then Call VDT.MSX_VDT_CMD_REG44_SET()
                    If (iReg = 45) Then Call VDT.MSX_VDT_CMD_REG45_SET()
                    If (iReg = 46) Then Call VDT.MSX_VDT_CMD_REG46_SET()
                    If ((VDT.MSX_VDT_REG(17) And 128) = 0) Then '1(2)=10 -> Not Auto Increment
                        VDT.MSX_VDT_REG(17) = (iReg + 1) '1(2)=00 -> Auto Increment
                    End If
                    VDT.Gi_MSX_Screen_Out = 1 '화면표시작업
                End If
            End If

            'PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
            If (iAddress = &HA0) Then 'Read Write Register 번호지정
                MSX_PORT(iAddress) = iVal 'Reg(iVal)번을 포트(A0h)로 출력
            End If
            If (iAddress = &HA1) Then '지정된 Register로 기록
                C = MSX_PORT(&HA0)
                If (C = 0) Then PSG.MSX_PSG_REG(0) = iVal : Call PSG.MSX_PSG_REG_R00_WRITE()
                If (C = 1) Then PSG.MSX_PSG_REG(1) = iVal : Call PSG.MSX_PSG_REG_R01_WRITE()
                If (C = 2) Then PSG.MSX_PSG_REG(2) = iVal : Call PSG.MSX_PSG_REG_R02_WRITE()
                If (C = 3) Then PSG.MSX_PSG_REG(3) = iVal : Call PSG.MSX_PSG_REG_R03_WRITE()
                If (C = 4) Then PSG.MSX_PSG_REG(4) = iVal : Call PSG.MSX_PSG_REG_R04_WRITE()
                If (C = 5) Then PSG.MSX_PSG_REG(5) = iVal : Call PSG.MSX_PSG_REG_R05_WRITE()
                If (C = 6) Then PSG.MSX_PSG_REG(6) = iVal : Call PSG.MSX_PSG_REG_R06_WRITE()
                If (C = 7) Then PSG.MSX_PSG_REG(7) = iVal : Call PSG.MSX_PSG_REG_R07_WRITE()
                If (C = 8) Then PSG.MSX_PSG_REG(8) = iVal : Call PSG.MSX_PSG_REG_R08_WRITE()
                If (C = 9) Then PSG.MSX_PSG_REG(9) = iVal : Call PSG.MSX_PSG_REG_R09_WRITE()
                If (C = 10) Then PSG.MSX_PSG_REG(10) = iVal : Call PSG.MSX_PSG_REG_R10_WRITE()
                If (C = 11) Then PSG.MSX_PSG_REG(11) = iVal : Call PSG.MSX_PSG_REG_R11_WRITE()
                If (C = 12) Then PSG.MSX_PSG_REG(12) = iVal : Call PSG.MSX_PSG_REG_R12_WRITE()
                If (C = 13) Then PSG.MSX_PSG_REG(13) = iVal : Call PSG.MSX_PSG_REG_R13_WRITE()
                If (C = 14) Then PSG.MSX_PSG_REG(14) = iVal 'I/O포트A(Read)
                If (C = 15) Then PSG.MSX_PSG_REG(15) = iVal 'I/O포트B(Write)
            End If

            'PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
            If (iAddress = &HA8) Then 'PPI-register A / Primary slot select register
                MEM.Gi_MEM_PAGE3 = ((iVal And 192) >> 6) '7~6Bit
                MEM.Gi_MEM_PAGE2 = ((iVal And 48) >> 4)  '5~4Bit
                MEM.Gi_MEM_PAGE1 = ((iVal And 12) >> 2)  '3~2Bit
                MEM.Gi_MEM_PAGE0 = ((iVal And 3))        '1~0Bit
            End If
            If (iAddress = &HAA) Then 'PPI-register C / Keyboard and cassette interface
                Call PPI.PUT_MSX_PPI_REG_C(iVal)
            End If
            If (iAddress = &HAB) Then 'Mode Set / Command register : bit0<-1
                iBit = ((iVal And 14) >> 1) '5(3)
                If ((iVal And 1) = 1) Then '1(1)=1 Set
                    Call PPI.PUT_MSX_PPI_REG_C(((PPI.GET_MSX_PPI_REG_C() Or TBL.Gi_B_Table(iBit))))
                Else 'Res
                    Call PPI.PUT_MSX_PPI_REG_C(((PPI.GET_MSX_PPI_REG_C() And TBL.Gi_NB_Table(iBit))))
                End If
            End If

            'MSX2 - Clock
            If (iAddress = &HB4) Then 'Clock Reg 지정
                MSX_PORT(&HB4) = (iVal And 15)
            End If
            If (iAddress = &HB5) Then '지정된 Clock 블록+Reg 기록
                C = MSX_PORT(&HB4)
                If (C <= 15) Then MSX_CLOCK_REG(IIf(C <= 12, MSX_CLOCK_REG(0, 13) And 3, 0), C) = iVal
            End If

            'MSX2 - Memory Mapper registers
            If (MSX.GiMSX2 = 1) Then 'MSX2
                If (iAddress = &HFC) Then
                    MSX_PORT(&HFC) = iVal
                    Call MEM.MSX_MEMORY_CHANGE(0, iVal) 'Memory Page0(2) Change
                End If
                If (iAddress = &HFD) Then
                    MSX_PORT(&HFD) = iVal
                    Call MEM.MSX_MEMORY_CHANGE(1, iVal) 'Memory Page1(2) Change
                End If
                If (iAddress = &HFE) Then
                    MSX_PORT(&HFE) = iVal
                    Call MEM.MSX_MEMORY_CHANGE(2, iVal) 'Memory Page2(2) Change
                End If
                If (iAddress = &HFF) Then
                    MSX_PORT(&HFF) = iVal
                    Call MEM.MSX_MEMORY_CHANGE(3, iVal) 'Memory Page3(2) Change
                End If
            End If

        End Sub

        Public Sub MSX_VDT_ADDRESS_HIGH()

            VDT.Go_MSX_VRAM_ADDRESS = (VDT.Go_MSX_VRAM_ADDRESS And 16383) + ((VDT.MSX_VDT_REG(14) And 7) * 16384) 'Bit16~14, 3FFFh

        End Sub

        Public Sub gt_PORT_IN_A(ByVal iPort As Integer)

            Z80A.Z80A_REG_A = GET_MSX_PORT(iPort)

        End Sub

        Public Sub gt_PORT_OUT_A(ByVal iPort As Integer)

            Call PUT_MSX_PORT(iPort, Z80A.Z80A_REG_A)

        End Sub

        Public Sub gt_PORT_IN(ByRef Reg8 As Integer)

            Call Z80A.PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Reg8 = GET_MSX_PORT(Z80A.Z80A_REG_C)
            'Z80A_FLAG_C = ? '캐리
            Call Z80A.PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call Z80A.PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Reg8)) 'Sign
            Call Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_PORT_OUT(ByVal Reg8 As Integer)

            Call PUT_MSX_PORT(Z80A.Z80A_REG_C, Reg8)

        End Sub

        Public Sub gt_INI()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
            Call MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C))
            Call Z80A.PUT_Z80A_REG_HL(((Z80A.GET_Z80A_REG_HL() + 1) And &HFFFF))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            Call Z80A.PUT_Z80A_FLAG_Z(IIf(Z80A.Z80A_REG_B = 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_INIR()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
LoopProc:
            Call MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C))
            Call Z80A.PUT_Z80A_REG_HL(((Z80A.GET_Z80A_REG_HL() + 1) And &HFFFF))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            If (Z80A.Z80A_REG_B <> 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call Z80A.PUT_Z80A_FLAG_Z(1) 'Zero

        End Sub

        Public Sub gt_IND()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
            Call MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C))
            Call Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            Call Z80A.PUT_Z80A_FLAG_Z(IIf(Z80A.Z80A_REG_B = 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_INDR()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
LoopProc:
            Call MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C))
            Call Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            If (Z80A.Z80A_REG_B <> 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call Z80A.PUT_Z80A_FLAG_Z(1) 'Zero

        End Sub

        Public Sub gt_OUTI()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
            Call PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
            Call Z80A.PUT_Z80A_REG_HL(((Z80A.GET_Z80A_REG_HL() + 1) And &HFFFF))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            Call Z80A.PUT_Z80A_FLAG_Z(IIf(Z80A.Z80A_REG_B = 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_OTIR()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
LoopProc:
            Call PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
            Call Z80A.PUT_Z80A_REG_HL(((Z80A.GET_Z80A_REG_HL() + 1) And &HFFFF))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            If (Z80A.Z80A_REG_B <> 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call Z80A.PUT_Z80A_FLAG_Z(1) 'Zero

        End Sub

        Public Sub gt_OUTD()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
            Call PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
            Call Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            Call Z80A.PUT_Z80A_FLAG_Z(IIf(Z80A.Z80A_REG_B = 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_OTDR()

            Call Z80A.PUT_Z80A_FLAG_N(1) '뺄셈
LoopProc:
            Call PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
            Call Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1))
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
            If (Z80A.Z80A_REG_B <> 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call Z80A.PUT_Z80A_FLAG_Z(1) 'Zero

        End Sub
    End Module

End Namespace
