﻿Namespace MEM

    Module msxMEM
        '메모리(0000h~FFFFh)
        Public MSX_MEM(4 - 1, 65536 - 1) As Integer '0~255 (0~3, 0~65535)

        'Memory Page
        Public Gi_MEM_PAGE0 As Integer '-128~127
        Public Gi_MEM_PAGE1 As Integer
        Public Gi_MEM_PAGE2 As Integer
        Public Gi_MEM_PAGE3 As Integer

        'MSX2 - 확장 Page
        Public Gi_MEM_EXT_PAGE0 As Integer
        Public Gi_MEM_EXT_PAGE1 As Integer
        Public Gi_MEM_EXT_PAGE2 As Integer
        Public Gi_MEM_EXT_PAGE3 As Integer

        'Mega ROM Slot#1
        Public MSX_ROM(4194304 - 1) As Integer '0~255 (0~4194303(4MB))
        Public Gi_Big32K_ROM As Integer

        'MSX2 - Mapper Memory RAM Slot#2
        Public MSX_RAM(4194304 - 1) As Integer '0~255 (0~4194303(4MB))
        Public Gi_RAM_PAGE0 As Integer
        Public Gi_RAM_PAGE1 As Integer
        Public Gi_RAM_PAGE2 As Integer
        Public Gi_RAM_PAGE3 As Integer

        Public Sub MSX_INIT_MEM()

            Dim i As Integer, j As Integer

            For i = 0 To 3
                For j = 0 To 65535
                    MSX_MEM(i, j) = 0
                Next j
            Next i

            Gi_MEM_PAGE0 = 0
            Gi_MEM_PAGE1 = 0
            Gi_MEM_PAGE2 = 0
            Gi_MEM_PAGE3 = 0

            Gi_MEM_EXT_PAGE0 = 0
            Gi_MEM_EXT_PAGE1 = 0
            Gi_MEM_EXT_PAGE2 = 0
            Gi_MEM_EXT_PAGE3 = 0

            For i = 0 To 4194303
                MSX_ROM(i) = 0
            Next i

            Gi_Big32K_ROM = 0

            For i = 0 To 4194303
                MSX_RAM(i) = 0
            Next i

            Gi_RAM_PAGE0 = 3
            Gi_RAM_PAGE1 = 2
            Gi_RAM_PAGE2 = 1
            Gi_RAM_PAGE3 = 0

        End Sub

        Public Function GET_MSX_MEMORY_SLOT2(ByVal oAddr As Integer) As Integer

            If (MSX.GiMSX2 = 0) Then 'MSX1
                GET_MSX_MEMORY_SLOT2 = MSX_MEM(2, oAddr)
            Else 'MSX2
                GET_MSX_MEMORY_SLOT2 = GET_MSX_MEMORY_MAPPER(oAddr, -1)
            End If

        End Function

        Public Sub PUT_MSX_MEMORY_SLOT2(ByVal oAddr As Integer, ByVal iVal As Integer)

            If (MSX.GiMSX2 = 0) Then 'MSX1
                MSX_MEM(2, oAddr) = iVal
            Else 'MSX2
                Call PUT_MSX_MEMORY_MAPPER(oAddr, iVal, -1)
            End If

        End Sub

        Public Function GET_MSX_MEMORY(ByVal oAddr As Integer) As Integer

            Dim iRet As Integer = 0

            If ((oAddr >= 0) And (oAddr <= 16383)) Then 'Page#0 (0000~3FFF)
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE0 = 2)) Then 'MSX2 Mapper RAM
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 0)
                Else 'RAM
                    iRet = MSX_MEM(Gi_MEM_PAGE0, oAddr)
                End If
            End If

            If ((oAddr >= 16384) And (oAddr <= 32767)) Then 'Page#1 (4000~7FFF)
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE1 = 2)) Then 'MSX2 Mapper RAM
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 1)
                Else 'RAM
                    iRet = MSX_MEM(Gi_MEM_PAGE1, oAddr)
                End If
            End If

            If ((oAddr >= 32768) And (oAddr <= 49151)) Then 'Page#2 (8000~BFFF)
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE2 = 2)) Then 'MSX2 Mapper RAM
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 2)
                Else 'RAM
                    iRet = MSX_MEM(Gi_MEM_PAGE2, oAddr)
                End If
            End If

            If ((oAddr >= 49152) And (oAddr <= 65535)) Then 'Page#3 (C000~FFFF)
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE3 = 2)) Then 'MSX2 Mapper RAM
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 3)
                Else 'RAM
                    iRet = MSX_MEM(Gi_MEM_PAGE3, oAddr)
                End If
            End If

            GET_MSX_MEMORY = iRet

        End Function

        Public Sub PUT_MSX_MEMORY(ByVal oAddr As Integer, ByVal iVal As Integer)

            If (Gi_Big32K_ROM = 1) Then 'Mega Rom Mapper
                If (MSX.Gi_ROM_TYPE = 0) Then
                    'Konami without SCC (a.k.a.Konami4) - (8KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If ((oAddr >= &H4000) And (oAddr <= &H5FFF)) Then Call Move_Rom_To_Page_Konami4(1, iVal)
                        If ((oAddr >= &H6000) And (oAddr <= &H7FFF)) Then Call Move_Rom_To_Page_Konami4(2, iVal)
                    End If
                    If (Gi_MEM_PAGE2 = 1) Then
                        If ((oAddr >= &H8000) And (oAddr <= &H9FFF)) Then Call Move_Rom_To_Page_Konami4(3, iVal)
                        If ((oAddr >= &HA000) And (oAddr <= &HBFFF)) Then Call Move_Rom_To_Page_Konami4(4, iVal)
                    End If
                End If
                If (MSX.Gi_ROM_TYPE = 1) Then
                    'Konami with SCC (a.k.a.Konami5) - (8KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If ((oAddr >= &H5000) And (oAddr <= &H57FF)) Then Call Move_Rom_To_Page_Konami5(1, iVal)
                        If ((oAddr >= &H7000) And (oAddr <= &H77FF)) Then Call Move_Rom_To_Page_Konami5(2, iVal)
                    End If
                    If (Gi_MEM_PAGE2 = 1) Then
                        If ((oAddr >= &H9000) And (oAddr <= &H97FF)) Then Call Move_Rom_To_Page_Konami5(3, iVal)
                        If ((oAddr >= &HB000) And (oAddr <= &HB7FF)) Then Call Move_Rom_To_Page_Konami5(4, iVal)
                    End If
                End If
                If (MSX.Gi_ROM_TYPE = 2) Then
                    'ASCII 8Kb - (8KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If ((oAddr >= &H6000) And (oAddr <= &H67FF)) Then Call Move_Rom_To_Page_Ascii8(1, iVal)
                        If ((oAddr >= &H6800) And (oAddr <= &H6FFF)) Then Call Move_Rom_To_Page_Ascii8(2, iVal)
                        If ((oAddr >= &H7000) And (oAddr <= &H77FF)) Then Call Move_Rom_To_Page_Ascii8(3, iVal)
                        If ((oAddr >= &H7800) And (oAddr <= &H7FFF)) Then Call Move_Rom_To_Page_Ascii8(4, iVal)
                    End If
                End If
                If (MSX.Gi_ROM_TYPE = 3) Then
                    'ASCII 16Kb - (16KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If ((oAddr >= &H6000) And (oAddr <= &H67FF)) Then Call Move_Rom_To_Page_Ascii16(1, iVal)
                        If ((oAddr >= &H7000) And (oAddr <= &H77FF)) Then Call Move_Rom_To_Page_Ascii16(3, iVal)
                    End If
                End If
                If (MSX.Gi_ROM_TYPE = 4) Then
                    '64-in-1 and 80-in-1 - (8KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If (oAddr = &H4000) Then Call Move_Rom_To_Page_80_in_1(1, iVal)
                        If (oAddr = &H4001) Then Call Move_Rom_To_Page_80_in_1(2, iVal)
                        If (oAddr = &H4002) Then Call Move_Rom_To_Page_80_in_1(3, iVal)
                        If (oAddr = &H4003) Then Call Move_Rom_To_Page_80_in_1(4, iVal)
                    End If
                End If
                If (MSX.Gi_ROM_TYPE = 5) Then
                    '126-in-1 - (16KB)
                    If (Gi_MEM_PAGE1 = 1) Then
                        If (oAddr = &H4000) Then Call Move_Rom_To_Page_126_in_1(1, iVal)
                        If (oAddr = &H4001) Then Call Move_Rom_To_Page_126_in_1(3, iVal)
                    End If
                End If
            End If

            If ((oAddr >= 0) And (oAddr <= 16383)) Then 'Page#0 (0000~3FFF)
                If (Gi_MEM_PAGE0 = 0) Then GoTo ExitProc 'Slot#0 ROM
                If (Gi_MEM_PAGE0 = 1) Then GoTo ExitProc 'Slot#1 ROM
                If (Gi_MEM_PAGE0 = 3) Then GoTo ExitProc 'Slot#3 ROM
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE0 = 2)) Then 'MSX2 Mapper RAM
                    Call PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 0)
                Else 'RAM
                    If (Gi_MEM_PAGE0 = 2) Then MSX_MEM(Gi_MEM_PAGE0, oAddr) = iVal
                End If
            End If

            If ((oAddr >= 16384) And (oAddr <= 32767)) Then 'Page#1 (4000~7FFF)
                If (Gi_MEM_PAGE1 = 0) Then GoTo ExitProc 'Slot#0 ROM
                If (Gi_MEM_PAGE1 = 1) Then GoTo ExitProc 'Slot#1 ROM
                If (Gi_MEM_PAGE1 = 3) Then GoTo ExitProc 'Slot#3 ROM
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE1 = 2)) Then 'MSX2 Mapper RAM
                    Call PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 1)
                Else 'RAM
                    If (Gi_MEM_PAGE1 = 2) Then MSX_MEM(Gi_MEM_PAGE1, oAddr) = iVal
                End If
            End If

            If ((oAddr >= 32768) And (oAddr <= 49151)) Then 'Page#2 (8000~BFFF)
                If (Gi_MEM_PAGE2 = 0) Then GoTo ExitProc 'Slot#0 ROM
                If (Gi_MEM_PAGE2 = 1) Then GoTo ExitProc 'Slot#1 ROM
                If (Gi_MEM_PAGE2 = 3) Then GoTo ExitProc 'Slot#3 ROM
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE2 = 2)) Then 'MSX2 Mapper RAM
                    Call PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 2)
                Else 'RAM
                    If (Gi_MEM_PAGE2 = 2) Then MSX_MEM(Gi_MEM_PAGE2, oAddr) = iVal
                End If
            End If

            If ((oAddr >= 49152) And (oAddr <= 65535)) Then 'Page#3 (C000~FFFF)
                If (Gi_MEM_PAGE3 = 0) Then GoTo ExitProc 'Slot#0 ROM
                If (Gi_MEM_PAGE3 = 1) Then GoTo ExitProc 'Slot#1 ROM
                If (Gi_MEM_PAGE3 = 3) Then GoTo ExitProc 'Slot#3 ROM
                If ((MSX.GiMSX2 = 1) And (Gi_MEM_PAGE3 = 2)) Then 'MSX2 Mapper RAM
                    Call PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 3)
                Else 'RAM
                    If (Gi_MEM_PAGE3 = 2) Then MSX_MEM(Gi_MEM_PAGE3, oAddr) = iVal
                End If
            End If

ExitProc:

        End Sub

        Public Function GET_MSX_MEMORY_16(ByVal oAddr As Integer) As Integer

            Dim h As Integer = 0
            Dim l As Integer = 0

            l = GET_MSX_MEMORY(oAddr) : oAddr = ((oAddr + 1) And &HFFFF)
            h = GET_MSX_MEMORY(oAddr)

            GET_MSX_MEMORY_16 = ((h << 8) Or l)

        End Function

        Public Sub PUT_MSX_MEMORY_16(ByVal oAddr As Integer, ByVal oVal As Integer)

            Dim h As Integer = (oVal >> 8)
            Dim l As Integer = (oVal And &HFF)

            Call PUT_MSX_MEMORY(oAddr, l) : oAddr = ((oAddr + 1) And &HFFFF)
            Call PUT_MSX_MEMORY(oAddr, h)

        End Sub

        Public Sub MSX_MEMORY_CHANGE(ByVal iPage As Integer, ByVal iSeg As Integer)

            If (iPage = 0) Then Gi_RAM_PAGE0 = iSeg
            If (iPage = 1) Then Gi_RAM_PAGE1 = iSeg
            If (iPage = 2) Then Gi_RAM_PAGE2 = iSeg
            If (iPage = 3) Then Gi_RAM_PAGE3 = iSeg

        End Sub

        Public Function GET_MSX_MEMORY_MAPPER(ByVal oAddr As Integer, ByVal iPage As Integer) As Integer

            Dim iMapPage As Integer = 0

            If (iPage = (-1)) Then
                If ((oAddr >= 0) And (oAddr <= 16383)) Then iPage = 0 'Page#0 (0000~3FFF)
                If ((oAddr >= 16384) And (oAddr <= 32767)) Then iPage = 1 'Page#1 (4000~7FFF)
                If ((oAddr >= 32768) And (oAddr <= 49151)) Then iPage = 2 'Page#2 (8000~BFFF)
                If ((oAddr >= 49152) And (oAddr <= 65535)) Then iPage = 3 'Page#3 (C000~FFFF)
            End If

            If (iPage = 0) Then oAddr = (oAddr - 0) : iMapPage = Gi_RAM_PAGE0 'Page#0 (0000h~3FFFh)
            If (iPage = 1) Then oAddr = (oAddr - 16384) : iMapPage = Gi_RAM_PAGE1 'Page#1 (4000h~7FFFh)
            If (iPage = 2) Then oAddr = (oAddr - 32768) : iMapPage = Gi_RAM_PAGE2 'Page#2 (8000h~BFFFh)
            If (iPage = 3) Then oAddr = (oAddr - 49152) : iMapPage = Gi_RAM_PAGE3 'Page#3 (C000h~FFFFh)

            GET_MSX_MEMORY_MAPPER = MSX_RAM(oAddr + TBL.Go_M_Table16384(iMapPage)) '4000h

        End Function

        Public Sub PUT_MSX_MEMORY_MAPPER(ByVal oAddr As Integer, ByVal iVal As Integer, ByVal iPage As Integer)

            Dim iMapPage As Integer = 0

            If (iPage = (-1)) Then
                If ((oAddr >= 0) And (oAddr <= 16383)) Then iPage = 0 'Page#0 (0000~3FFF)
                If ((oAddr >= 16384) And (oAddr <= 32767)) Then iPage = 1 'Page#1 (4000~7FFF)
                If ((oAddr >= 32768) And (oAddr <= 49151)) Then iPage = 2 'Page#2 (8000~BFFF)
                If ((oAddr >= 49152) And (oAddr <= 65535)) Then iPage = 3 'Page#3 (C000~FFFF)
            End If

            If (iPage = 0) Then oAddr = (oAddr - 0) : iMapPage = Gi_RAM_PAGE0 'Page#0 (0000h~3FFFh)
            If (iPage = 1) Then oAddr = (oAddr - 16384) : iMapPage = Gi_RAM_PAGE1 'Page#1 (4000h~7FFFh)
            If (iPage = 2) Then oAddr = (oAddr - 32768) : iMapPage = Gi_RAM_PAGE2 'Page#2 (8000h~BFFFh)
            If (iPage = 3) Then oAddr = (oAddr - 49152) : iMapPage = Gi_RAM_PAGE3 'Page#3 (C000h~FFFFh)

            MSX_RAM(oAddr + TBL.Go_M_Table16384(iMapPage)) = iVal '4000h

        End Sub

        'Konami without SCC (a.k.a.Konami4)
        '8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
        'Chg - Bank1:None, Bank2:6000h~7FFFh(6000h), Bank3:8000h~9FFFh(8000h), Bank4:A000h~BFFFh(A000h)
        Public Sub Move_Rom_To_Page_Konami4(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress8(iPage)

            For i = 0 To 8191
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~1FFFh
            Next i

        End Sub

        'Konami with SCC (a.k.a.Konami5)
        '8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
        'Chg - Bank1:5000h~57FFh(5000h), Bank2:7000h~77FFh(7000h), Bank3:9000h~97FFh(9000h), Bank4:B000h~B7FFh(B000h)
        Public Sub Move_Rom_To_Page_Konami5(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress8(iPage)

            For i = 0 To 8191
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~1FFFh
            Next i

        End Sub

        'ASCII 8Kb
        '8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
        'Chg - Bank1:6000h~67FFh(6000h), Bank2:6800h~6FFFh(6800h), Bank3:7000h~77FFh(7000h), Bank4:7800h~7FFFh(7800h)
        Public Sub Move_Rom_To_Page_Ascii8(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress8(iPage)

            For i = 0 To 8191
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~1FFFh
            Next i

        End Sub

        'ASCII 16Kb
        '16Kb - Bank1:4000h~7FFFh, Bank3:8000h~BFFFh
        'Chg - Bank1:6000h~67FFh(6000h), Bank3:7000h~77FFh(7000h+77FFh)
        Public Sub Move_Rom_To_Page_Ascii16(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress16(iPage)

            For i = 0 To 16383
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~3FFFh
            Next i

        End Sub

        '64-in-1 and 80-in-1
        '8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
        'Chg - Bank1:(4000h), Bank2:(4001h), Bank3:(4002h), Bank4:(4003h)
        Public Sub Move_Rom_To_Page_80_in_1(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress8(iPage)

            For i = 0 To 8191
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~1FFFh
            Next i

        End Sub

        '126-in-1
        '16Kb - Bank1:4000h~7FFFh, Bank3:8000h~BFFFh
        'Chg - Bank1:(4000h), Bank3:(4001h)
        Public Sub Move_Rom_To_Page_126_in_1(ByVal iBank As Integer, ByVal iPage As Integer)

            Dim oAddr As Integer, oRom As Integer
            Dim i As Integer

            oAddr = foGetBankAddress8(iBank)
            oRom = foGetPageAddress16(iPage)

            For i = 0 To 16383
                MSX_MEM(1, oAddr + i) = MSX_ROM(oRom + i) '0000h~3FFFh
            Next i

        End Sub

        Public Function foGetBankAddress8(ByVal iBank As Integer) As Integer

            Dim R As Integer

            R = 0
            If (iBank = 1) Then R = &H4000
            If (iBank = 2) Then R = &H6000
            If (iBank = 3) Then R = &H8000
            If (iBank = 4) Then R = &HA000

            foGetBankAddress8 = R

        End Function

        Public Function foGetPageAddress8(ByVal iPage As Integer) As Integer

            foGetPageAddress8 = (iPage * 8192) '2000h

        End Function

        Public Function foGetPageAddress16(ByVal iPage As Integer) As Integer

            foGetPageAddress16 = (iPage * 16384) '4000h

        End Function
    End Module

End Namespace
