﻿Namespace MI

    Module msxMI

        Public Sub EXEC_Z80A_CODE()
        
            dim idx As Integer '0~255
            dim iSz As Integer 
            dim Reg8 As Integer = 0
            dim Reg16 As Integer = 0
            dim PC1p As Integer

            Z80A.Z80A_REG_R+=1: Z80A.Z80A_REG_R = (Z80A.Z80A_REG_R and 127) '0111 1111

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC)
            iSz = 1

            PC1p = ((Z80A.Z80A_REG_PC + 1) and &HFFFF)

            Select Case idx
            
                case &H00: 'NOP
                    MSX.Gi_Z80A_CLOCK = 4
                    INT.gt_NOP()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H01: 'LD BC,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.PUT_Z80A_REG_BC(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H02: 'LD (BC),A
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_BC(), Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H03: 'INC BC
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_B,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H04: 'INC B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_B,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H05: 'DEC B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_B,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H06: 'LD B,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H07: 'RLCA
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_RLCA()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H08: 'EX AF,AF
                    MSX.Gi_Z80A_CLOCK = 4
                    Reg8 = Z80A.Z80A_REG_A :Z80A.Z80A_REG_A = Z80A.Z80A_REG_A2 :Z80A.Z80A_REG_A2 = Reg8
                    Reg8 = Z80A.Z80A_REG_F :Z80A.Z80A_REG_F = Z80A.Z80A_REG_F2 :Z80A.Z80A_REG_F2 = Reg8
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H09: 'ADD HL,BC
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0A: 'LD A,(BC)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_BC())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0B: 'DEC BC
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_B,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0C: 'INC C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_C,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0D: 'DEC C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_C,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0E: 'LD C,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H0F: 'RRCA
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_RRCA()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H10: 'DJNZ idx
                    iSz = 2
                    Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1)
                    if (Z80A.Z80A_REG_B <> 0) then
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                        MSX.Gi_Z80A_CLOCK = 13
                     Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 8
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H11: 'LD DE,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.PUT_Z80A_REG_DE(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H12: 'LD (DE),A
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_DE(), Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H13: 'INC DE
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_D,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H14: 'INC D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_D,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H15: 'DEC D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_D,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H16: 'LD D,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H17: 'RLA
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_RLA()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H18: 'JR idx
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 12
                    Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H19: 'ADD HL,DE
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1A: 'LD A,(DE)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_DE())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1B: 'DEC DE
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_D,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1C: 'INC E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_E,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1D: 'DEC E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_E,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1E: 'LD E,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H1F: 'RRA
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_RRA()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H20: 'JR NZ,idx
                    iSz = 2
                    if (Z80A.GET_Z80A_FLAG_Z() = 0) then 
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                        MSX.Gi_Z80A_CLOCK = 12
                    else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 7
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H21: 'LD HL,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H22: 'LD (nn),HL
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 16
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H23: 'INC HL
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_HL(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H24: 'INC H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_H,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H25: 'DEC H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_H,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H26: 'LD H,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H27: 'DAA
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DAA()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H28: 'JR Z,idx
                    iSz = 2
                    if (Z80A.GET_Z80A_FLAG_Z() = 1) then
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                        MSX.Gi_Z80A_CLOCK = 12
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 7
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H29: 'ADD HL,HL
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2A: 'LD HL,(nn)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 16
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2B: 'DEC HL
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_HL(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2C: 'INC L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_L,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2D: 'DEC L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_L,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2E: 'LD L,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H2F: 'CPL
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CPL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H30: 'JR NC,idx
                    iSz = 2
                    if (Z80A.GET_Z80A_FLAG_C() = 0) then
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                        MSX.Gi_Z80A_CLOCK = 12
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 7
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H31: 'LD SP,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.Z80A_REG_SP = MEM.GET_MSX_MEMORY_16(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H32: 'LD (nn),A
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 13
                    MEM.PUT_MSX_MEMORY(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H33: 'INC SP
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_SP,Z80A.Z80A_REG_SP)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H34: 'INC (HL)
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H35: 'DEC (HL)
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H36: 'LD (HL),n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 10
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H37: 'SCF
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SCF()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H38: 'JR C,idx
                    iSz = 2
                    if (Z80A.GET_Z80A_FLAG_C() = 1) then 
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)))
                        MSX.Gi_Z80A_CLOCK = 12
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 7
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &H39: 'ADD HL,SP
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP,Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3A: 'LD A,(nn)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 13
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3B: 'DEC SP
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_SP,Z80A.Z80A_REG_SP)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3C: 'INC A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_A,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3D: 'DEC A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_A,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3E: 'LD A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H3F: 'CCF
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CCF()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H40: 'LD B,B
                    MSX.Gi_Z80A_CLOCK = 4
                  'Z80A.Z80A_REG_B = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H41: 'LD B,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H42: 'LD B,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H43: 'LD B,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H44: 'LD B,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H45: 'LD B,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H46: 'LD B,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H47: 'LD B,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H48: 'LD C,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H49: 'LD C,C
                    MSX.Gi_Z80A_CLOCK = 4
                  'Z80A.Z80A_REG_C = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4A: 'LD C,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4B: 'LD C,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4C: 'LD C,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4D: 'LD C,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4E: 'LD C,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H4F: 'LD C,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H50: 'LD D,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H51: 'LD D,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H52: 'LD D,D
                    MSX.Gi_Z80A_CLOCK = 4
                   'Z80A.Z80A_REG_D = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H53: 'LD D,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H54: 'LD D,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H55: 'LD D,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H56: 'LD D,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H57: 'LD D,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H58: 'LD E,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H59: 'LD E,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5A: 'LD E,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5B: 'LD E,E
                    MSX.Gi_Z80A_CLOCK = 4
                   'Z80A.Z80A_REG_E = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5C: 'LD E,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5D: 'LD E,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5E: 'LD E,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H5F: 'LD E,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H60: 'LD H,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H61: 'LD H,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H62: 'LD H,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H63: 'LD H,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H64: 'LD H,H
                    MSX.Gi_Z80A_CLOCK = 4
                   'Z80A.Z80A_REG_H = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H65: 'LD H,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H66: 'LD H,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H67: 'LD H,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H68: 'LD L,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H69: 'LD L,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6A: 'LD L,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6B: 'LD L,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6C: 'LD L,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6D: 'LD L,L
                    MSX.Gi_Z80A_CLOCK = 4
                   'Z80A.Z80A_REG_L = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6E: 'LD L,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H6F: 'LD L,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H70: 'LD (HL),B
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H71: 'LD (HL),C
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H72: 'LD (HL),D
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H73: 'LD (HL),E
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H74: 'LD (HL),H
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H75: 'LD (HL),L
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H76: 'HALT
                    INT.gt_HALT()
                    if (INT.Z80A_HALT = 0) then 
                        MSX.Gi_Z80A_CLOCK = 4
                        Z80A.EXEC_Z80A_ADD_PC(0, iSz)
                    Else
                        INT.Z80A_HALT = 0
                        MSX.Gi_Z80A_CLOCK = 4
                        Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    End If 
                    
                case &H77: 'LD (HL),A
                    MSX.Gi_Z80A_CLOCK = 7
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H78: 'LD A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_B
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H79: 'LD A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_C
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7A: 'LD A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_D
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7B: 'LD A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_E
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7C: 'LD A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_H
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7D: 'LD A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_L
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7E: 'LD A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H7F: 'LD A,A
                    MSX.Gi_Z80A_CLOCK = 4
                   'Z80A.Z80A_REG_A = Z80A.Z80A_REG_A
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H80: 'ADD A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H81: 'ADD A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H82: 'ADD A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H83: 'ADD A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H84: 'ADD A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H85: 'ADD A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H86: 'ADD A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H87: 'ADD A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H88: 'ADC A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H89: 'ADC A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8A: 'ADC A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8B: 'ADC A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8C: 'ADC A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8D: 'ADC A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8E: 'ADC A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H8F: 'ADC A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H90: 'SUB A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H91: 'SUB A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H92: 'SUB A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H93: 'SUB A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H94: 'SUB A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H95: 'SUB A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H96: 'SUB A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H97: 'SUB A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H98: 'SBC A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H99: 'SBC A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9A: 'SBC A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9B: 'SBC A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9C: 'SBC A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9D: 'SBC A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9E: 'SBC A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &H9F: 'SBC A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA0: 'AND A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA1: 'AND A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA2: 'AND A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA3: 'AND A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA4: 'AND A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA5: 'AND A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA6: 'AND A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA7: 'AND A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA8: 'XOR A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HA9: 'XOR A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAA: 'XOR A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAB: 'XOR A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAC: 'XOR A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAD: 'XOR A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAE: 'XOR A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HAF: 'XOR A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB0: 'OR A,B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB1: 'OR A,C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB2: 'OR A,D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB3: 'OR A,E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB4: 'OR A,H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB5: 'OR A,L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB6: 'OR A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB7: 'OR A,A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB8: 'CP B
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HB9: 'CP C
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBA: 'CP D
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBB: 'CP E
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBC: 'CP H
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBD: 'CP L
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBE: 'CP (HL)
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HBF: 'CP A
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.gt_CP(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HC0: 'RET NZ
                    if (Z80A.GET_Z80A_FLAG_Z() = 0) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HC1: 'POP BC
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_POP_16TO2(Z80A.Z80A_REG_B,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HC2: 'JP NZ,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_Z() = 0) then 
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HC3: 'JP nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HC4: 'CALL NZ,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_Z() = 0) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HC5: 'PUSH BC
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_BC())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HC6: 'ADD A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HC7: 'RST 00H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_00()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HC8: 'RET Z
                    if (Z80A.GET_Z80A_FLAG_Z() = 1) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HC9: 'RET
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HCA: 'JP Z,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_Z() = 1) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HCB: 'CB - Bit instructions
                    Z80A.Z80A_REG_R += 1 : Z80A.Z80A_REG_R = (Z80A.Z80A_REG_R and 127) '0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MICB.EXEC_Z80A_CODE_CB()
                    
                case &HCC: 'CALL Z,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_Z() = 1) then 
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HCD: 'CALL nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 17
                    Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                    Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HCE: 'ADC A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HCF: 'RST 08H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_08()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HD0: 'RET NC
                    if (Z80A.GET_Z80A_FLAG_C() = 0) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HD1: 'POP DE
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_POP_16TO2(Z80A.Z80A_REG_D,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HD2: 'JP NC,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_C() = 0) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HD3: 'OUT (p),A
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 11
                    IO.gt_PORT_OUT_A(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HD4: 'CALL NC,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_C() = 0) then 
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HD5: 'PUSH DE
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_DE())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HD6: 'SUB A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HD7: 'RST 10H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_10()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HD8: 'RET C
                    if (Z80A.GET_Z80A_FLAG_C() = 1) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HD9: 'EXX
                    MSX.Gi_Z80A_CLOCK = 4
                    Reg8 = Z80A.Z80A_REG_B: Z80A.Z80A_REG_B = Z80A.Z80A_REG_B2: Z80A.Z80A_REG_B2 = Reg8
                    Reg8 = Z80A.Z80A_REG_C: Z80A.Z80A_REG_C = Z80A.Z80A_REG_C2: Z80A.Z80A_REG_C2 = Reg8
                    Reg8 = Z80A.Z80A_REG_D: Z80A.Z80A_REG_D = Z80A.Z80A_REG_D2: Z80A.Z80A_REG_D2 = Reg8
                    Reg8 = Z80A.Z80A_REG_E: Z80A.Z80A_REG_E = Z80A.Z80A_REG_E2: Z80A.Z80A_REG_E2 = Reg8
                    Reg8 = Z80A.Z80A_REG_H: Z80A.Z80A_REG_H = Z80A.Z80A_REG_H2: Z80A.Z80A_REG_H2 = Reg8
                    Reg8 = Z80A.Z80A_REG_L: Z80A.Z80A_REG_L = Z80A.Z80A_REG_L2: Z80A.Z80A_REG_L2 = Reg8
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HDA: 'JP C,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_C() = 1) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HDB: 'IN A,(p)
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 11
                    IO.gt_PORT_IN_A(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HDC: 'CALL C,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_C() = 1) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HDD: 'DD - IX instructions
                    Z80A.Z80A_REG_R += 1 :Z80A.Z80A_REG_R = (Z80A.Z80A_REG_R and 127) '0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MIDD.EXEC_Z80A_CODE_DD()
                    
                case &HDE: 'SBC A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HDF: 'RST 18H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_18()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HE0: 'RET PO
                    if (Z80A.GET_Z80A_FLAG_PV() = 0) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HE1: 'POP HL
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_POP_16TO2(Z80A.Z80A_REG_H,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HE2: 'JP PO,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_PV() = 0) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HE3: 'EX (SP),HL
                    MSX.Gi_Z80A_CLOCK = 19
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP)
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.GET_Z80A_REG_HL())
                    Z80A.PUT_Z80A_REG_HL(Reg16)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HE4: 'CALL PO,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_PV() = 0) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HE5: 'PUSH HL
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HE6: 'AND A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HE7: 'RST 20H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_20()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HE8: 'RET PE
                    if (Z80A.GET_Z80A_FLAG_PV() = 1) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HE9: 'JP (HL)
                    MSX.Gi_Z80A_CLOCK = 4
                    Z80A.Z80A_REG_PC = Z80A.GET_Z80A_REG_HL() 'PC<-HL
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HEA: 'JP PE,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_PV() = 1) then 
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HEB: 'EX DE,HL
                    MSX.Gi_Z80A_CLOCK = 4
                    Reg8 = Z80A.Z80A_REG_D: Z80A.Z80A_REG_D = Z80A.Z80A_REG_H: Z80A.Z80A_REG_H = Reg8
                    Reg8 = Z80A.Z80A_REG_E: Z80A.Z80A_REG_E = Z80A.Z80A_REG_L: Z80A.Z80A_REG_L = Reg8
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HEC: 'CALL PE,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_PV() = 1) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HED: 'ED - Extended instructions
                    Z80A.Z80A_REG_R += 1: Z80A.Z80A_REG_R = (Z80A.Z80A_REG_R and 127) '0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MIED.EXEC_Z80A_CODE_ED()
                    
                case &HEE: 'XOR A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HEF: 'RST 28H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_28()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HF0: 'RET P
                    if (Z80A.GET_Z80A_FLAG_S() = 0) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HF1: 'POP AF
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_POP_16TO2(Z80A.Z80A_REG_A,Z80A.Z80A_REG_F)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HF2: 'JP P,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_S() = 0) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HF3: 'DI
                    MSX.Gi_Z80A_CLOCK = 4
                    INT.gt_DI()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HF4: 'CALL P,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_S() = 0) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HF5: 'PUSH AF
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_AF())
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HF6: 'OR A,n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HF7: 'RST 30H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_30()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HF8: 'RET M
                    if (Z80A.GET_Z80A_FLAG_S() = 1) then
                        Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                        MSX.Gi_Z80A_CLOCK = 11
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 5
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                case &HF9: 'LD SP,HL
                    MSX.Gi_Z80A_CLOCK = 6
                    Z80A.Z80A_REG_SP = Z80A.GET_Z80A_REG_HL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HFA: 'JP M,nn
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 10
                    if (Z80A.GET_Z80A_FLAG_S() = 1) then
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HFB: 'EI
                    MSX.Gi_Z80A_CLOCK = 4
                    INT.gt_EI()
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HFC: 'CALL M,nn
                    iSz = 3
                    if (Z80A.GET_Z80A_FLAG_S() = 1) then
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz))
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p)
                        MSX.Gi_Z80A_CLOCK = 17
                    Else
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz)
                        MSX.Gi_Z80A_CLOCK = 10
                    End If 
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '3
                    
                case &HFD: 'FD - IY instruction
                    Z80A.Z80A_REG_R += 1: Z80A.Z80A_REG_R = (Z80A.Z80A_REG_R and 127) '0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MIFD.EXEC_Z80A_CODE_FD()
                    
                case &HFE: 'CP n
                    iSz = 2
                    MSX.Gi_Z80A_CLOCK = 7
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0)
                    
                case &HFF: 'RST 38H
                    MSX.Gi_Z80A_CLOCK = 11
                    INT.gt_RST_38()
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1
                    
                Case Else: '실행안됨
                    
            End Select

        End Sub 
    End Module

End Namespace
