﻿Namespace MICB

    Module msxMI_CB

        Public Sub EXEC_Z80A_CODE_CB()
        
            dim idx As Integer '0~255
            dim iSz As Integer  
            dim Reg8 As Integer = 0
 
            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC)
            iSz = 2

            MSX.Gi_Z80A_CLOCK = 8

            Select Case idx
            
                case &H00: 'RLC B
                    Z80A.gt_RLC(Z80A.Z80A_REG_B, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H01: 'RLC C                     
                    Z80A.gt_RLC(Z80A.Z80A_REG_C, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H02: 'RLC D                    
                    Z80A.gt_RLC(Z80A.Z80A_REG_D, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H03: 'RLC E                   
                    Z80A.gt_RLC(Z80A.Z80A_REG_E, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H04: 'RLC H                    
                    Z80A.gt_RLC(Z80A.Z80A_REG_H, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H05: 'RLC L                    
                    Z80A.gt_RLC(Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H06: 'RLC (HL)                    
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RLC(Reg8, 0)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H07: 'RLC A                     
                    Z80A.gt_RLC(Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H08: 'RRC B                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_B, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H09: 'RRC C
                    Z80A.gt_RRC(Z80A.Z80A_REG_C, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0A: 'RRC D                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_D, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0B: 'RRC E                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_E, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0C: 'RRC H                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_H, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0D: 'RRC L                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0E: 'RRC (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RRC(Reg8, 0)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H0F: 'RRC A                     
                    Z80A.gt_RRC(Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H10: 'RL B                     
                    Z80A.gt_RL(Z80A.Z80A_REG_B, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H11: 'RL C                     
                    Z80A.gt_RL(Z80A.Z80A_REG_C, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H12: 'RL D                     
                    Z80A.gt_RL(Z80A.Z80A_REG_D, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H13: 'RL E                     
                    Z80A.gt_RL(Z80A.Z80A_REG_E, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H14: 'RL H                     
                    Z80A.gt_RL(Z80A.Z80A_REG_H, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H15: 'RL L                     
                    Z80A.gt_RL(Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H16: 'RL (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RL(Reg8, 0)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H17: 'RL A                     
                    Z80A.gt_RL(Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H18: 'RR B                     
                    Z80A.gt_RR(Z80A.Z80A_REG_B, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H19: 'RR C                     
                    Z80A.gt_RR(Z80A.Z80A_REG_C, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1A: 'RR D                     
                    Z80A.gt_RR(Z80A.Z80A_REG_D, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1B: 'RR E                     
                    Z80A.gt_RR(Z80A.Z80A_REG_E, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1C: 'RR H                     
                    Z80A.gt_RR(Z80A.Z80A_REG_H, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1D: 'RR L                     
                    Z80A.gt_RR(Z80A.Z80A_REG_L, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1E: 'RR (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RR(Reg8, 0)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H1F: 'RR A                     
                    Z80A.gt_RR(Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H20: 'SLA B                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H21: 'SLA C                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H22: 'SLA D                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H23: 'SLA E                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H24: 'SLA H                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H25: 'SLA L                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H26: 'SLA (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SLA(Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H27: 'SLA A                     
                    Z80A.gt_SLA(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H28: 'SRA B                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H29: 'SRA C                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2A: 'SRA D                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2B: 'SRA E                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2C: 'SRA H                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2D: 'SRA L                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2E: 'SRA (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SRA(Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2F: 'SRA A                     
                    Z80A.gt_SRA(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H30: 'SLL B '@@@@@ SLL,SLS                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H31: 'SLL C '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H32: 'SLL D '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H33: 'SLL E '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H34: 'SLL H '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H35: 'SLL L '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H36: 'SLL (HL) '@@@@@                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SLL(Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H37: 'SLL A '@@@@@                     
                    Z80A.gt_SLL(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H38: 'SRL B                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H39: 'SRL C                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3A: 'SRL D                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3B: 'SRL E                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3C: 'SRL H                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3D: 'SRL L                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3E: 'SRL (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SRL(Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H3F: 'SRL A                     
                    Z80A.gt_SRL(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H40: 'BIT 0,B                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H41: 'BIT 0,C                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H42: 'BIT 0,D                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H43: 'BIT 0,E                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H44: 'BIT 0,H                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H45: 'BIT 0,L                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H46: 'BIT 0,(HL)                     
                    Z80A.gt_BIT(0, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H47: 'BIT 0,A                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H48: 'BIT 1,B                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H49: 'BIT 1,C                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4A: 'BIT 1,D                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4B: 'BIT 1,E                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4C: 'BIT 1,H                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4D: 'BIT 1,L                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4E: 'BIT 1,(HL)                     
                    Z80A.gt_BIT(1, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4F: 'BIT 1,A                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H50: 'BIT 2,B                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H51: 'BIT 2,C                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H52: 'BIT 2,D                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H53: 'BIT 2,E                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H54: 'BIT 2,H                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H55: 'BIT 2,L                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H56: 'BIT 2,(HL)                     
                    Z80A.gt_BIT(2, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H57: 'BIT 2,A                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H58: 'BIT 3,B                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H59: 'BIT 3,C                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5A: 'BIT 3,D                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5B: 'BIT 3,E                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5C: 'BIT 3,H                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5D: 'BIT 3,L                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5E: 'BIT 3,(HL)                     
                    Z80A.gt_BIT(3, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5F: 'BIT 3,A                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H60: 'BIT 4,B                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H61: 'BIT 4,C                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H62: 'BIT 4,D                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H63: 'BIT 4,E                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H64: 'BIT 4,H                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H65: 'BIT 4,L                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H66: 'BIT 4,(HL)                     
                    Z80A.gt_BIT(4, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H67: 'BIT 4,A                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H68: 'BIT 5,B                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H69: 'BIT 5,C                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6A: 'BIT 5,D                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6B: 'BIT 5,E                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6C: 'BIT 5,H                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6D: 'BIT 5,L                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6E: 'BIT 5,(HL)                     
                    Z80A.gt_BIT(5, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6F: 'BIT 5,A                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H70: 'BIT 6,B                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H71: 'BIT 6,C                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H72: 'BIT 6,D                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H73: 'BIT 6,E                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H74: 'BIT 6,H                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H75: 'BIT 6,L                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H76: 'BIT 6,(HL)                     
                    Z80A.gt_BIT(6, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H77: 'BIT 6,A                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H78: 'BIT 7,B                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H79: 'BIT 7,C                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7A: 'BIT 7,D                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7B: 'BIT 7,E                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7C: 'BIT 7,H
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7D: 'BIT 7,L                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7E: 'BIT 7,(HL)                     
                    Z80A.gt_BIT(7, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7F: 'BIT 7,A                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H80: 'RES 0,B                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H81: 'RES 0,C                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H82: 'RES 0,D                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H83: 'RES 0,E                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H84: 'RES 0,H                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H85: 'RES 0,L                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H86: 'RES 0,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(0,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H87: 'RES 0,A                     
                    Z80A.gt_RES(0,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H88: 'RES 1,B                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H89: 'RES 1,C                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8A: 'RES 1,D                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8B: 'RES 1,E                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8C: 'RES 1,H                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8D: 'RES 1,L                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8E: 'RES 1,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(1,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8F: 'RES 1,A                     
                    Z80A.gt_RES(1,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H90: 'RES 2,B                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H91: 'RES 2,C                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H92: 'RES 2,D                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H93: 'RES 2,E                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H94: 'RES 2,H                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H95: 'RES 2,L                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H96: 'RES 2,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(2,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H97: 'RES 2,A                     
                    Z80A.gt_RES(2,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H98: 'RES 3,B                     
                    Z80A.gt_RES(3,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H99: 'RES 3,C                     
                    Z80A.gt_RES(3,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9A: 'RES 3,D                     
                    Z80A.gt_RES(3,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9B: 'RES 3,E                     
                    Z80A.gt_RES(3,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9C: 'RES 3,H
                    Z80A.gt_RES(3,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9D: 'RES 3,L
                    Z80A.gt_RES(3,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9E: 'RES 3,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(3,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9F: 'RES 3,A
                    Z80A.gt_RES(3,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA0: 'RES 4,B
                    Z80A.gt_RES(4,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA1: 'RES 4,C
                    Z80A.gt_RES(4,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA2: 'RES 4,D
                    Z80A.gt_RES(4,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA3: 'RES 4,E
                    Z80A.gt_RES(4,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA4: 'RES 4,H
                    Z80A.gt_RES(4,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA5: 'RES 4,L
                    Z80A.gt_RES(4,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA6: 'RES 4,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(4,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA7: 'RES 4,A
                    Z80A.gt_RES(4,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA8: 'RES 5,B
                    Z80A.gt_RES(5,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA9: 'RES 5,C
                    Z80A.gt_RES(5,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAA: 'RES 5,D
                    Z80A.gt_RES(5,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAB: 'RES 5,E
                    Z80A.gt_RES(5,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAC: 'RES 5,H
                    Z80A.gt_RES(5,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAD: 'RES 5,L
                    Z80A.gt_RES(5,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAE: 'RES 5,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(5,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAF: 'RES 5,A
                    Z80A.gt_RES(5,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB0: 'RES 6,B
                    Z80A.gt_RES(6,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB1: 'RES 6,C
                    Z80A.gt_RES(6,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB2: 'RES 6,D
                    Z80A.gt_RES(6,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB3: 'RES 6,E
                    Z80A.gt_RES(6,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB4: 'RES 6,H
                    Z80A.gt_RES(6,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB5: 'RES 6,L
                    Z80A.gt_RES(6,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB6: 'RES 6,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(6,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB7: 'RES 6,A
                    Z80A.gt_RES(6,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB8: 'RES 7,B
                    Z80A.gt_RES(7,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB9: 'RES 7,C
                    Z80A.gt_RES(7,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBA: 'RES 7,D
                    Z80A.gt_RES(7,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBB: 'RES 7,E
                    Z80A.gt_RES(7,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBC: 'RES 7,H
                    Z80A.gt_RES(7,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBD: 'RES 7,L
                    Z80A.gt_RES(7,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBE: 'RES 7,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_RES(7,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBF: 'RES 7,A
                    Z80A.gt_RES(7,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC0: 'SET 0,B
                    Z80A.gt_SET(0,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC1: 'SET 0,C
                    Z80A.gt_SET(0,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC2: 'SET 0,D
                    Z80A.gt_SET(0,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC3: 'SET 0,E
                    Z80A.gt_SET(0,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC4: 'SET 0,H
                    Z80A.gt_SET(0,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC5: 'SET 0,L
                    Z80A.gt_SET(0,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC6: 'SET 0,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(0,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC7: 'SET 0,A
                    Z80A.gt_SET(0,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC8: 'SET 1,B
                    Z80A.gt_SET(1,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HC9: 'SET 1,C
                    Z80A.gt_SET(1,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCA: 'SET 1,D
                    Z80A.gt_SET(1,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCB: 'SET 1,E
                    Z80A.gt_SET(1,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCC: 'SET 1,H
                    Z80A.gt_SET(1,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCD: 'SET 1,L
                    Z80A.gt_SET(1,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCE: 'SET 1,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(1,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCF: 'SET 1,A
                    Z80A.gt_SET(1,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD0: 'SET 2,B
                    Z80A.gt_SET(2,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD1: 'SET 2,C
                    Z80A.gt_SET(2,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD2: 'SET 2,D
                    Z80A.gt_SET(2,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD3: 'SET 2,E
                    Z80A.gt_SET(2,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD4: 'SET 2,H
                    Z80A.gt_SET(2,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD5: 'SET 2,L
                    Z80A.gt_SET(2,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD6: 'SET 2,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(2,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD7: 'SET 2,A
                    Z80A.gt_SET(2,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD8: 'SET 3,B
                    Z80A.gt_SET(3,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HD9: 'SET 3,C
                    Z80A.gt_SET(3,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDA: 'SET 3,D
                    Z80A.gt_SET(3,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDB: 'SET 3,E
                    Z80A.gt_SET(3,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDC: 'SET 3,H
                    Z80A.gt_SET(3,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDD: 'SET 3,L
                    Z80A.gt_SET(3,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDE: 'SET 3,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(3,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HDF: 'SET 3,A
                    Z80A.gt_SET(3,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE0: 'SET 4,B
                    Z80A.gt_SET(4,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE1: 'SET 4,C
                    Z80A.gt_SET(4,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE2: 'SET 4,D
                    Z80A.gt_SET(4,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE3: 'SET 4,E
                    Z80A.gt_SET(4,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE4: 'SET 4,H
                    Z80A.gt_SET(4,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE5: 'SET 4,L
                    Z80A.gt_SET(4,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE6: 'SET 4,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(4,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE7: 'SET 4,A
                    Z80A.gt_SET(4,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE8: 'SET 5,B
                    Z80A.gt_SET(5,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE9: 'SET 5,C
                    Z80A.gt_SET(5,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HEA: 'SET 5,D
                    Z80A.gt_SET(5, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HEB: 'SET 5,E
                    Z80A.gt_SET(5,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HEC: 'SET 5,H
                    Z80A.gt_SET(5,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HED: 'SET 5,L
                    Z80A.gt_SET(5,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HEE: 'SET 5,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(5,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HEF: 'SET 5,A
                    Z80A.gt_SET(5,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF0: 'SET 6,B
                    Z80A.gt_SET(6,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF1: 'SET 6,C
                    Z80A.gt_SET(6,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF2: 'SET 6,D
                    Z80A.gt_SET(6,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF3: 'SET 6,E
                    Z80A.gt_SET(6,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF4: 'SET 6,H
                    Z80A.gt_SET(6,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF5: 'SET 6,L
                    Z80A.gt_SET(6,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF6: 'SET 6,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(6,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF7: 'SET 6,A
                    Z80A.gt_SET(6,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF8: 'SET 7,B
                    Z80A.gt_SET(7,Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HF9: 'SET 7,C
                    Z80A.gt_SET(7,Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFA: 'SET 7,D
                    Z80A.gt_SET(7,Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFB: 'SET 7,E
                    Z80A.gt_SET(7,Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFC: 'SET 7,H
                    Z80A.gt_SET(7,Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFD: 'SET 7,L
                    Z80A.gt_SET(7,Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFE: 'SET 7,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL())
                    Z80A.gt_SET(7,Reg8)
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HFF: 'SET 7,A
                    Z80A.gt_SET(7,Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                Case Else: '실행안됨
                    
            End Select
        
        End Sub 
    End Module

End Namespace
