﻿Namespace MIDD

    Module msxMI_DD

        Public Sub EXEC_Z80A_CODE_DD()
        
            dim idx As Integer '0~255
            dim iSz As Integer
            dim Reg8 As Integer= 0
            dim Reg16 As Integer= 0
            dim GetIxyIdx As Integer
            dim PC1p As Integer
            dim PC2p As Integer

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC)
            iSz = 2

            GetIxyIdx = Z80A.goGetLngToLng(Z80A.Z80A_REG_IX + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(((Z80A.Z80A_REG_PC + 1) and &HFFFF))))
            PC1p = ((Z80A.Z80A_REG_PC + 1) and &HFFFF)
            PC2p = ((Z80A.Z80A_REG_PC + 2) and &HFFFF)

            Select Case idx
            
                case &H09: 'ADD IX,BC
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_IX, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H19: 'ADD IX,DE
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_IX, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H21: 'LD IX,nn
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 14
                    Z80A.Z80A_REG_IX = MEM.GET_MSX_MEMORY_16(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H22: 'LD (nn),IX
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_IX)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H23: 'INC IX
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_IX,Z80A.Z80A_REG_IX)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H24: 'INC IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IXH(),Reg8)
                    Z80A.PUT_Z80A_REG_IXH(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H25: 'DEC IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IXH(),Reg8)
                    Z80A.PUT_Z80A_REG_IXH(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H26: 'LD IXH,n '@@@@@
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.PUT_Z80A_REG_IXH(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H29: 'ADD IX,IX
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.Z80A_REG_IX,Z80A.Z80A_REG_IX, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2A: 'LD IX,(nn)
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.Z80A_REG_IX = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2B: 'DEC IX
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_IX,Z80A.Z80A_REG_IX)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2C: 'INC IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IXL(),Reg8)
                    Z80A.PUT_Z80A_REG_IXL(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2D: 'DEC IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IXL(),Reg8)
                    Z80A.PUT_Z80A_REG_IXL(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2E: 'LD IXL,n '@@@@@
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.PUT_Z80A_REG_IXL(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H34: 'INC (IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 23
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx),Reg8)
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H35: 'DEC (IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 23
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx),Reg8)
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H36: 'LD (IX+d),n
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, MEM.GET_MSX_MEMORY(PC2p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H39: 'ADD IX,SP
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.Z80A_REG_SP,Z80A.Z80A_REG_IX, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H44: 'LD B,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IXH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H45: 'LD B,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IXL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H46: 'LD B,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4C: 'LD C,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IXH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4D: 'LD C,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IXL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4E: 'LD C,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H54: 'LD D,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IXH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H55: 'LD D,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IXL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H56: 'LD D,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5C: 'LD E,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IXH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5D: 'LD E,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IXL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5E: 'LD E,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H60: 'LD IXH,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H61: 'LD IXH,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H62: 'LD IXH,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H63: 'LD IXH,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H64: 'LD IXH,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                  'Z80A.PUT_Z80A_REG_IXH(Z80A.GET_Z80A_REG_IXH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H65: 'LD IXH,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.GET_Z80A_REG_IXL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H66: 'LD H,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H67: 'LD IXH,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H68: 'LD IXL,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H69: 'LD IXL,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6A: 'LD IXL,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6B: 'LD IXL,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6C: 'LD IXL,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.GET_Z80A_REG_IXH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6D: 'LD IXL,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                  'Z80A.PUT_Z80A_REG_IXL(Z80A.GET_Z80A_REG_IXL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6E: 'LD L,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6F: 'LD IXL,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H70: 'LD (IX+d),B
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H71: 'LD (IX+d),C
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H72: 'LD (IX+d),D
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H73: 'LD (IX+d),E
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H74: 'LD (IX+d),H
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H75: 'LD (IX+d),L
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H77: 'LD (IX+d),A
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7C: 'LD A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IXH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7D: 'LD A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IXL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7E: 'LD A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H84: 'ADD A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H85: 'ADD A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H86: 'ADD A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8C: 'ADC A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8D: 'ADC A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8E: 'ADC A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H94: 'SUB A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H95: 'SUB A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H96: 'SUB A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9C: 'SBC A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9D: 'SBC A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9E: 'SBC A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA4: 'AND A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA5: 'AND A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA6: 'AND A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAC: 'XOR A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAD: 'XOR A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAE: 'XOR A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB4: 'OR A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB5: 'OR A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB6: 'OR A,(IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBC: 'CP IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IXH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBD: 'CP IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IXL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBE: 'CP (IX+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(GetIxyIdx))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCB: 'DD-CB - IX bit instruction
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MIDDCB.EXEC_Z80A_CODE_DD_CB()
                    
                case &HE1: 'POP IX
                    MSX.Gi_Z80A_CLOCK = 14
                    Z80A.gt_POP_16(Z80A.Z80A_REG_IX)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE3: 'EX (SP),IX
                    MSX.Gi_Z80A_CLOCK = 23
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP)
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.Z80A_REG_IX)
                    Z80A.Z80A_REG_IX = Reg16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE5: 'PUSH IX
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_PUSH_16(Z80A.Z80A_REG_IX)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE9: 'JP (IX)
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_PC = Z80A.Z80A_REG_IX 'PC<-IX
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &HF9: 'LD SP,IX
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.Z80A_REG_SP = Z80A.Z80A_REG_IX
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                Case Else:
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.EXEC_Z80A_ADD_PC(0, 0) '없는명령은취소됨
                    
            End Select
        
        End Sub 
    End Module

End Namespace
