﻿Namespace MIED

    Module msxMI_ED

        Public Sub EXEC_Z80A_CODE_ED()
        
            dim idx As Integer '0~255
            dim iSz As Integer
            dim Reg8 As Integer = 0
            dim PC1p As Integer

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC)
            iSz = 2

            PC1p = ((Z80A.Z80A_REG_PC + 1) and &HFFFF)

            Select Case idx
            
                case &H40: 'IN B,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H41: 'OUT (C),B
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H42: 'SBC HL,BC
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H43: 'LD (nn),BC
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_BC())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H44: 'NEG
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H45: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    'Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H46: 'IM 0
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_0()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H47: 'LD I,A
                    MSX.Gi_Z80A_CLOCK = 9
                    INT.gt_LD_I_A()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H48: 'IN C,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H49: 'OUT (C),C
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4A: 'ADC HL,BC
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4B: 'LD BC,(nn)
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.PUT_Z80A_REG_BC(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4C: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4D: 'RETI
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETI()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H4E: 'IM 0/1 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_0_1()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4F: 'LD R,A
                    MSX.Gi_Z80A_CLOCK = 9
                    INT.gt_LD_R_A()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H50: 'IN D,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H51: 'OUT (C),D
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H52: 'SBC HL,DE
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H53: 'LD (nn),DE
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_DE())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H54: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H55: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H56: 'IM 1
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_1()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H57: 'LD A,I
                    MSX.Gi_Z80A_CLOCK = 9
                    INT.gt_LD_A_I()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H58: 'IN E,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H59: 'OUT (C),E
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5A: 'ADC HL,DE
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5B: 'LD DE,(nn)
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.PUT_Z80A_REG_DE(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5C: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5D: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H5E: 'IM 2
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_2()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5F: 'LD A,R
                    MSX.Gi_Z80A_CLOCK = 9
                    INT.gt_LD_A_R()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H60: 'IN H,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H61: 'OUT (C),H
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H62: 'SBC HL,HL
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H63: 'LD (nn),HL '@@@@@
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_HL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H64: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H65: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H66: 'IM 0
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_0()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H67: 'RRD
                    MSX.Gi_Z80A_CLOCK = 18
                    Z80A.gt_RRD()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H68: 'IN L,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H69: 'OUT (C),L
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6A: 'ADC HL,HL
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(),Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6B: 'LD HL,(nn) '@@@@@
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6C: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6D: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H6E: 'IM 0/1 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_0_1()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6F: 'RLD
                    MSX.Gi_Z80A_CLOCK = 18
                    Z80A.gt_RLD()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H70: 'IN (C) '@@@@@
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H71: 'OUT (C),0 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 12
                    Reg8 = 0
                    IO.gt_PORT_OUT(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H72: 'SBC HL,SP
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP,Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H73: 'LD (nn),SP
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_SP)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H74: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H75: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    'Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H76: 'IM 1
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_1()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H78: 'IN A,(C)
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_IN(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H79: 'OUT (C),A
                    MSX.Gi_Z80A_CLOCK = 12
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7A: 'ADC HL,SP
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP,Z80A.Z80A_REG_H,Z80A.Z80A_REG_L, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7B: 'LD SP,(nn)
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.Z80A_REG_SP = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7C: 'NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_NEG()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7D: 'RETN
                    MSX.Gi_Z80A_CLOCK = 14
                    INT.gt_RETN()
                    Z80A.gt_POP_16(Z80A.Z80A_REG_PC)
                    'Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt 'EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1) '2
                    
                case &H7E: 'IM 2
                    MSX.Gi_Z80A_CLOCK = 8
                    INT.gt_IM_2()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA0: 'LDI
                    MSX.Gi_Z80A_CLOCK = 16
                    Z80A.gt_LDI()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA1: 'CPI
                    MSX.Gi_Z80A_CLOCK = 16
                    Z80A.gt_CPI()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA2: 'INI
                    MSX.Gi_Z80A_CLOCK = 16
                    IO.gt_INI()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA3: 'OUTI
                    MSX.Gi_Z80A_CLOCK = 16
                    IO.gt_OUTI()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA8: 'LDD
                    MSX.Gi_Z80A_CLOCK = 16
                    Z80A.gt_LDD()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA9: 'CPD
                    MSX.Gi_Z80A_CLOCK = 16
                    Z80A.gt_CPD()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAA: 'IND
                    MSX.Gi_Z80A_CLOCK = 16
                    IO.gt_IND()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAB: 'OUTD
                    MSX.Gi_Z80A_CLOCK = 16
                    IO.gt_OUTD()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB0: 'LDIR
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.gt_LDIR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB1: 'CPIR
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.gt_CPIR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB2: 'INIR
                    MSX.Gi_Z80A_CLOCK = 0
                    IO.gt_INIR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB3: 'OTIR
                    MSX.Gi_Z80A_CLOCK = 0
                    IO.gt_OTIR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB8: 'LDDR
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.gt_LDDR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB9: 'CPDR
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.gt_CPDR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBA: 'INDR
                    MSX.Gi_Z80A_CLOCK = 0
                    IO.gt_INDR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBB: 'OTDR
                    MSX.Gi_Z80A_CLOCK = 0
                    IO.gt_OTDR() '21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                Case Else:
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.EXEC_Z80A_ADD_PC(1, 0) '없는명령은NOP
                    
            End Select
        
        End Sub 
    End Module

End Namespace
