﻿Namespace MIFD

    Module msxMI_FD

        Public Sub EXEC_Z80A_CODE_FD()
        
            dim idx As Integer '0~255
            dim iSz As Integer
            dim Reg8 As Integer= 0
            dim Reg16 As Integer= 0
            dim GetIxyIdx As Integer
            dim PC1p As Integer
            dim PC2p As Integer

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC)
            iSz = 2

            GetIxyIdx = Z80A.goGetLngToLng(Z80A.Z80A_REG_IY + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(((Z80A.Z80A_REG_PC + 1) and &HFFFF))))
            PC1p = ((Z80A.Z80A_REG_PC + 1) and &HFFFF)
            PC2p = ((Z80A.Z80A_REG_PC + 2) and &HFFFF)

            Select Case idx
            
                case &H09: 'ADD IY,BC
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.GET_Z80A_REG_BC(),Z80A.Z80A_REG_IY, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H19: 'ADD IY,DE
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.GET_Z80A_REG_DE(),Z80A.Z80A_REG_IY, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H21: 'LD IY,nn
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 14
                    Z80A.Z80A_REG_IY = MEM.GET_MSX_MEMORY_16(PC1p)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H22: 'LD (nn),IY
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_IY)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H23: 'INC IY
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_IY,Z80A.Z80A_REG_IY)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H24: 'INC IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IYH(),Reg8)
                    Z80A.PUT_Z80A_REG_IYH(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H25: 'DEC IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IYH(),Reg8)
                    Z80A.PUT_Z80A_REG_IYH(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H26: 'LD IYH,n '@@@@@
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.PUT_Z80A_REG_IYH(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H29: 'ADD IY,IY
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.Z80A_REG_IY,Z80A.Z80A_REG_IY, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2A: 'LD IY,(nn)
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 20
                    Z80A.Z80A_REG_IY = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2B: 'DEC IY
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_IY,Z80A.Z80A_REG_IY)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2C: 'INC IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IYL(),Reg8)
                    Z80A.PUT_Z80A_REG_IYL(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2D: 'DEC IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IYL(),Reg8)
                    Z80A.PUT_Z80A_REG_IYL(Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H2E: 'LD IYL,n '@@@@@
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 11
                    Z80A.PUT_Z80A_REG_IYL(MEM.GET_MSX_MEMORY(PC1p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H34: 'INC (IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 23
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx),Reg8)
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H35: 'DEC (IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 23
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx),Reg8)
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H36: 'LD (IY+d),n
                    iSz = 4
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, MEM.GET_MSX_MEMORY(PC2p))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H39: 'ADD IY,SP
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.Z80A_REG_SP,Z80A.Z80A_REG_IY, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H44: 'LD B,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IYH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H45: 'LD B,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IYL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H46: 'LD B,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4C: 'LD C,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IYH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4D: 'LD C,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IYL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H4E: 'LD C,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H54: 'LD D,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IYH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H55: 'LD D,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IYL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H56: 'LD D,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5C: 'LD E,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IYH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5D: 'LD E,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IYL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H5E: 'LD E,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H60: 'LD IYH,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H61: 'LD IYH,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H62: 'LD IYH,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H63: 'LD IYH,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H64: 'LD IYH,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                  'Z80A.PUT_Z80A_REG_IYH(Z80A.GET_Z80A_REG_IYH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H65: 'LD IYH,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.GET_Z80A_REG_IYL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H66: 'LD H,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H67: 'LD IYH,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H68: 'LD IYL,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H69: 'LD IYL,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6A: 'LD IYL,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6B: 'LD IYL,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6C: 'LD IYL,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.GET_Z80A_REG_IYH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6D: 'LD IYL,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                  'Z80A.PUT_Z80A_REG_IYL(Z80A.GET_Z80A_REG_IYL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6E: 'LD L,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H6F: 'LD IYL,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H70: 'LD (IY+d),B
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_B)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H71: 'LD (IY+d),C
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_C)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H72: 'LD (IY+d),D
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_D)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H73: 'LD (IY+d),E
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_E)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H74: 'LD (IY+d),H
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_H)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H75: 'LD (IY+d),L
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_L)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H77: 'LD (IY+d),A
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7C: 'LD A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IYH()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7D: 'LD A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IYL()
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H7E: 'LD A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(GetIxyIdx)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H84: 'ADD A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H85: 'ADD A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H86: 'ADD A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8C: 'ADC A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8D: 'ADC A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H8E: 'ADC A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H94: 'SUB A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H95: 'SUB A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H96: 'SUB A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 0)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9C: 'SBC A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9D: 'SBC A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &H9E: 'SBC A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A, 1)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA4: 'AND A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA5: 'AND A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HA6: 'AND A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAC: 'XOR A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAD: 'XOR A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HAE: 'XOR A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB4: 'OR A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB5: 'OR A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HB6: 'OR A,(IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx),Z80A.Z80A_REG_A)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBC: 'CP IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IYH())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBD: 'CP IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IYL())
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HBE: 'CP (IY+d)
                    iSz = 3
                    MSX.Gi_Z80A_CLOCK = 19
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(GetIxyIdx))
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HCB: 'FD-CB - IY bit instruction
                    Z80A.EXEC_Z80A_ADD_PC(1, 0)
                    MIFDCB.EXEC_Z80A_CODE_FD_CB()
                    
                case &HE1: 'POP IY
                    MSX.Gi_Z80A_CLOCK = 14
                    Z80A.gt_POP_16(Z80A.Z80A_REG_IY)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE3: 'EX (SP),IY
                    MSX.Gi_Z80A_CLOCK = 23
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP)
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.Z80A_REG_IY)
                    Z80A.Z80A_REG_IY = Reg16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE5: 'PUSH IY
                    MSX.Gi_Z80A_CLOCK = 15
                    Z80A.gt_PUSH_16(Z80A.Z80A_REG_IY)
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                case &HE9: 'JP (IY)
                    MSX.Gi_Z80A_CLOCK = 8
                    Z80A.Z80A_REG_PC = Z80A.Z80A_REG_IY 'PC<-IY
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz) '2
                    
                case &HF9: 'LD SP,IY
                    MSX.Gi_Z80A_CLOCK = 10
                    Z80A.Z80A_REG_SP = Z80A.Z80A_REG_IY
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0)
                    
                Case Else:
                    MSX.Gi_Z80A_CLOCK = 0
                    Z80A.EXEC_Z80A_ADD_PC(0, 0) '없는명령은취소됨
                     
            End Select
        
        End Sub 
    End Module

End Namespace
