﻿Namespace MSX

    Module msxMSX

        Public GiMENU As Integer '0:초기,1:시작,2:중지
        Public Const vnMSX_Version As String = "2019.06.06"

        Public GiMSX2 As Integer '0:MSX,1:MSX2
        Public GiDISK As Integer '1:Disk Rom Load
        Public GiCHAR As Integer 'Font - 0:8*8,1:6*8

        Public Gi_MSX2_Sets As Integer
        Public Gi_DISK_Sets As Integer
        Public Gi_CHAR_Sets As Integer

        Public Gi_MSX_Int_Timer As Integer 'Timer 속도 (10~100)
        Public Gi_MSX_DisplayFrame As Integer '1초에 0:60번[16],1:30번[33],2:22번[45],3:16번[62]

        Public Gi_MSX_InterruptDup As Integer '1:인터럽트중복허용
        Public Gi_MSX_Auto_Speed As Integer '1:Auto Speed
        Public Gi_MSX_KeyChange As Integer '1:Key Change
        Public Gi_MSX_JoyOn As Integer '1:조이스틱사용
        Public Gi_MSX_SpaceOn As Integer '1:Space On
        Public Gi_MSX_VDT_ST_FF As Integer

        Public Gs_CAS_FILE As String
        Public Gs_ROM_FILE As String
        Public Gi_ROM_TYPE As Integer
        Public Gs_DSK_A_FILE As String
        Public Gs_DSK_B_FILE As String
        Public Gi_DSK_A_ON As Integer
        Public Gi_DSK_B_ON As Integer

        Public Gi_MSX_Execute As Integer '0:중지,1:실행중 '-128~127
        Public Gi_MSX_GotFocus As Integer '0:없음,1:포커스

        Public Gi_Z80A_CLOCK As Integer '-2,147,483,648 ~ 2,147,483,647
        Public Gi_Z80A_ClockSize As Integer

        Public Gi_MSX_Timer_60_INT As Integer '1초60번확인(INT)
        Public Gi_MSX_Timer_16_VDP As Integer '1초16번확인(VDP)

        Public Gi_TEST As Integer '1:Test
        Public TEST_0_oAddr As Integer
        Public TEST_0_iVal As Integer
        Public TEST_1_oAddr As Integer
        Public TEST_1_iVal As Integer
        Public TEST_2_oAddr As Integer
        Public TEST_2_iVal As Integer
        Public TEST_3_oAddr As Integer
        Public TEST_3_iVal As Integer

        Public Sub MSX_INIT()

            Call Z80A.MSX_INIT_Z80A()
            Call INT.MSX_INIT_INT()
            Call MEM.MSX_INIT_MEM()
            Call IO.MSX_INIT_IO()
            Call PPI.MSX_INIT_PPI()
            Call VDT.MSX_INIT_VDT()
            Call PSG.MSX_INIT_PSG()
            Call FDC.MSX_INIT_FDC()

            Call TBL.MSX_INIT_P_Table()
            Call TBL.MSX_INIT_B_Table()
            Call TBL.MSX_INIT_MD_Table()

            Call VDT.MSX_Color_Setting()
            Call PSG.MSX_Compute_Oct_Hz()

            If (GiMSX2 = 0) Then 'MSX1
                Call MSXInit.Get_MSX1_ROM()
            Else 'MSX2
                Call MSXInit.Get_MSX2_ROM()
            End If
            If (GiDISK = 1) Then Call MSXInit.Get_MSX_DISK_ROM() 'DISK

        End Sub

        Public Function gsGetRomFileName(ByVal fName As String) As String

            Dim R As String

            R = ""
            fName = FN.gsTrim(fName)
            If (fName = "") Then GoTo LastProc
            If (FN.gsUpper(FN.gsRight(fName, 4)) = ".ROM") Then R = fName
LastProc:
            gsGetRomFileName = R

        End Function

        Public Function gsGetDskFileName(ByVal fName As String) As String

            Dim R As String

            R = ""
            fName = FN.gsTrim(fName)
            If (fName = "") Then GoTo LastProc
            If (FN.gsUpper(FN.gsRight(fName, 4)) = ".DSK") Then R = fName
LastProc:
            gsGetDskFileName = R

        End Function

        Public Function gsGetCasFileName(ByVal fName As String) As String

            Dim R As String

            R = ""
            fName = FN.gsTrim(fName)
            If (fName = "") Then GoTo LastProc
            If (FN.gsUpper(FN.gsRight(fName, 4)) = ".CAS") Then R = fName
LastProc:
            gsGetCasFileName = R

        End Function

        Public Function gsGetMsxFileName(ByVal fName As String) As String

            Dim R As String

            R = ""
            fName = FN.gsTrim(fName)
            If (fName = "") Then GoTo LastProc
            If (FN.gsUpper(FN.gsRight(fName, 4)) = ".MSX") Then R = fName
LastProc:
            gsGetMsxFileName = R

        End Function
    End Module

End Namespace
