﻿Namespace PPI

    Module msxPPI

        Private Declare Function GetAsyncKeyState Lib "user32.dll" (ByVal vKey As Integer) As Integer

        'Public MSX_PPI_REG_A As Integer 'Slot Page
        'Public Gi_MEM_PAGE0 As Integer '-128~127
        'Public Gi_MEM_PAGE1 As Integer
        'Public Gi_MEM_PAGE2 As Integer
        'Public Gi_MEM_PAGE3 As Integer

        Public MSX_PPI_REG_B As Integer 'RegC(KMT) 에서 지정된 키매트릭스 상태값

        'Public MSX_PPI_REG_C As Integer
        Public MSX_PPI_REG_C_KSO As Integer '7 bit - 1-bit Sound output, 1:on, 0:off - 비트사운드출력
        Public MSX_PPI_REG_C_KCL As Integer '6 bit - Keyboard CAPS LED, 1:off, 0:on
        Public MSX_PPI_REG_C_CWT As Integer '5 bit - Cassette Write Signal, 1:on, 0:off
        Public MSX_PPI_REG_C_CMT As Integer '4 bit - Cassette Motor, 1:off, 0:on
        Public MSX_PPI_REG_C_KMT As Integer '3~0 bit - Keyboard Matrix의 지정행번호 (0~10)

        Public Sub MSX_INIT_PPI()

            'MSX_PPI_REG_A = 0
            MSX_PPI_REG_B = 0
            'MSX_PPI_REG_C = 0

            MSX_PPI_REG_C_KSO = 0
            MSX_PPI_REG_C_KCL = 0
            MSX_PPI_REG_C_CWT = 0
            MSX_PPI_REG_C_CMT = 0
            MSX_PPI_REG_C_KMT = 0

        End Sub

        Public Function GET_MSX_PPI_REG_A() As Integer

            Dim R As Integer

            R = 0
            R = (R + TBL.Gi_M_Table64(MEM.Gi_MEM_PAGE3))
            R = (R + TBL.Gi_M_Table16(MEM.Gi_MEM_PAGE2))
            R = (R + TBL.Gi_M_Table4(MEM.Gi_MEM_PAGE1))
            R = (R + MEM.Gi_MEM_PAGE0)

            GET_MSX_PPI_REG_A = R

        End Function

        Public Function GET_MSX_PPI_REG_C() As Integer

            Dim R As Integer

            R = 0
            R = (R + TBL.Go_M_Table128(MSX_PPI_REG_C_KSO))
            R = (R + TBL.Gi_M_Table64(MSX_PPI_REG_C_KCL))
            R = (R + TBL.Gi_M_Table32(MSX_PPI_REG_C_CWT))
            R = (R + TBL.Gi_M_Table16(MSX_PPI_REG_C_CMT))
            R = (R + MSX_PPI_REG_C_KMT)

            GET_MSX_PPI_REG_C = R

        End Function

        Public Sub PUT_MSX_PPI_REG_C(ByVal iVal As Integer)

            MSX_PPI_REG_C_KSO = IIf((iVal And 128) = 0, 0, 1) '1-bit Sound output, 1:on - 비트사운드출력
            MSX_PPI_REG_C_KCL = IIf((iVal And 64) = 0, 0, 1)  'Keyboard CAPS LED, 0:on
            MSX_PPI_REG_C_CWT = IIf((iVal And 32) = 0, 0, 1)  'Cassette Write Signal, 1:on
            MSX_PPI_REG_C_CMT = IIf((iVal And 16) = 0, 0, 1)  'Cassette Motor, 0:on
            MSX_PPI_REG_C_KMT = (iVal And 15)                 'Keyboard Matrix의 지정행번호 (0~10)

        End Sub

        Public Function Gb_MSX_KEY_X() As Boolean

            Gb_MSX_KEY_X = IIf(((GetAsyncKeyState(88) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Function Gb_MSX_KEY_Z() As Boolean

            Gb_MSX_KEY_Z = IIf(((GetAsyncKeyState(90) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Function Gb_MSX_KEY_Left() As Boolean

            Gb_MSX_KEY_Left = IIf(((GetAsyncKeyState(37) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Function Gb_MSX_KEY_Right() As Boolean

            Gb_MSX_KEY_Right = IIf(((GetAsyncKeyState(39) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Function Gb_MSX_KEY_Up() As Boolean

            Gb_MSX_KEY_Up = IIf(((GetAsyncKeyState(38) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Function Gb_MSX_KEY_Down() As Boolean

            Gb_MSX_KEY_Down = IIf(((GetAsyncKeyState(40) And 32768) > 0) And (MSX.Gi_MSX_GotFocus = 1), True, False)

        End Function

        Public Sub SET_MSX_KEY_STATUS()

            Dim T As Integer

            Dim Key7 As Integer = 0, Key6 As Integer = 0, Key5 As Integer = 0, Key4 As Integer = 0, Key3 As Integer = 0, Key2 As Integer = 0, Key1 As Integer = 0, Key0 As Integer = 0

            Dim iRet0 As Integer, iRet1 As Integer, iBreak As Integer, iTab As Integer
            Dim iSpc As Integer, iF09 As Integer, iF12 As Integer
            Dim NumS As Integer, NumP As Integer, NumA As Integer, NumK As Integer

            '002C: 11 0001 0 001(1:International (QWERTY/other) Keyboard)
            'GetAsyncKeyState
            '0000h: 이전에 누른 적이 없고 호출 시점에 안 눌린 상태
            '0001h: 이전에 누른 적이 있고 호출 시점에 안 눌린 상태
            '8000h: 이전에 누른 적이 없고 호출 시점에 눌린 상태
            '8001h: 이전에 누른 적이 있고 호출 시점에 눌린 상태

            NumS = IIf((GetAsyncKeyState(111) And 32768) > 0, 1, 0) '(/)
            NumP = IIf((GetAsyncKeyState(107) And 32768) > 0, 1, 0) '(+)
            NumA = IIf((GetAsyncKeyState(106) And 32768) > 0, 1, 0) '(*)
            NumK = (NumP Or NumA)

            T = 0

            If (MSX.Gi_MSX_GotFocus <> 1) Then GoTo LastProc

            '7,6,5,4,3,2,1,0
            If (MSX_PPI_REG_C_KMT = 0) Then
                Key7 = IIf((GetAsyncKeyState(55) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(54) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(53) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(52) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(51) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(50) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(49) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(48) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            ',),(,\,=,-,9,8
            If (MSX_PPI_REG_C_KMT = 1) Then
                Key7 = IIf((GetAsyncKeyState(186) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(221) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(219) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(220) And 32768) > 0, 1, 0)
                If (MSX.GiMSX2 = 0) Then
                    Key3 = (IIf((GetAsyncKeyState(187) And 32768) > 0, 1, 0) Or (NumP)) '(+)
                Else
                    Key3 = IIf((GetAsyncKeyState(187) And 32768) > 0, 1, 0) '(+)
                End If
                Key2 = IIf((GetAsyncKeyState(189) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(57) And 32768) > 0, 1, 0)
                If (MSX.GiMSX2 = 0) Then
                    Key0 = (IIf((GetAsyncKeyState(56) And 32768) > 0, 1, 0) Or (NumA)) '(*)
                Else
                    Key0 = IIf((GetAsyncKeyState(56) And 32768) > 0, 1, 0) '(*)
                End If
                GoTo NextProc
            End If

            'B,A,DEAD-END,/,.>,,<,`~,'"
            If (MSX_PPI_REG_C_KMT = 2) Then
                Key7 = IIf((GetAsyncKeyState(66) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 0) Then Key6 = IIf((GetAsyncKeyState(65) And 32768) > 0, 1, 0) 'A
                Key5 = IIf((GetAsyncKeyState(35) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 1) Then Key5 = IIf((GetAsyncKeyState(68) And 32768) > 0, 1, 0) 'D->-(DEAD)
                If (MSX.GiMSX2 = 0) Then
                    Key4 = (IIf((GetAsyncKeyState(191) And 32768) > 0, 1, 0) Or (NumS))
                Else
                    Key4 = IIf((GetAsyncKeyState(191) And 32768) > 0, 1, 0)
                End If
                If (MSX.Gi_MSX_KeyChange = 1) Then Key4 = IIf((GetAsyncKeyState(83) And 32768) > 0, 1, 0) '->/?
                Key3 = IIf((GetAsyncKeyState(190) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 1) Then Key3 = IIf((GetAsyncKeyState(65) And 32768) > 0, 1, 0) 'A->.>
                Key2 = IIf((GetAsyncKeyState(188) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(192) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(222) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            'J,I,H,G,F,E,D,C
            If (MSX_PPI_REG_C_KMT = 3) Then
                Key7 = IIf((GetAsyncKeyState(74) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(73) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(72) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(71) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 0) Then Key3 = IIf((GetAsyncKeyState(70) And 32768) > 0, 1, 0) 'F
                Key2 = IIf((GetAsyncKeyState(69) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 0) Then Key1 = IIf((GetAsyncKeyState(68) And 32768) > 0, 1, 0) 'D
                Key0 = IIf((GetAsyncKeyState(67) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            'R,Q,P,O,N,M,L,K
            If (MSX_PPI_REG_C_KMT = 4) Then
                Key7 = IIf((GetAsyncKeyState(82) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(81) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(80) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(79) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(78) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(77) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(76) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(75) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            'Z,Y,X,W,V,U,T,S
            If (MSX_PPI_REG_C_KMT = 5) Then
                Key7 = IIf((GetAsyncKeyState(90) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(89) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(88) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(87) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(86) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(85) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(84) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 0) Then Key0 = IIf((GetAsyncKeyState(83) And 32768) > 0, 1, 0) 'S
                GoTo NextProc
            End If

            'F3(F8),F2(F7),F1(F6),CODE-F07,CAPLOCK,GRAPH-F08,CTRL,SHIFT
            If (MSX_PPI_REG_C_KMT = 6) Then
                'iF08 = ((GetAsyncKeyState(119) and 32768) > 0,1,0) 'F08
                'iHanEng = ((GetAsyncKeyState(229) and 32768) > 0,1,0) '한/영
                'iHanJa = ((GetAsyncKeyState(25) and 32768) > 0,1,0) '한자
                Key7 = IIf((GetAsyncKeyState(114) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(113) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(112) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(118) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(20) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(119) And 32768) > 0, 1, 0)
                If (MSX.Gi_MSX_KeyChange = 1) Then Key2 = IIf((GetAsyncKeyState(70) And 32768) > 0, 1, 0) 'F->GRAPH
                Key1 = IIf((GetAsyncKeyState(17) And 32768) > 0, 1, 0)
                If (MSX.GiMSX2 = 0) Then
                    Key0 = (IIf((GetAsyncKeyState(16) And 32768) > 0, 1, 0) Or (NumK)) 'Shift
                Else
                    Key0 = IIf((GetAsyncKeyState(16) And 32768) > 0, 1, 0) 'Shift
                End If
                GoTo NextProc
            End If

            'RETURN,SELECT-F11,BS,STOP-BREAK/PAUSE/F12,TAB-F9,ESC,F5(F10),F4(F9)
            If (MSX_PPI_REG_C_KMT = 7) Then
                iRet0 = IIf((GetAsyncKeyState(13) And 32768) > 0, 1, 0) 'Enter
                iRet1 = IIf((GetAsyncKeyState(108) And 32768) > 0, 1, 0) 'Num Enter
                iBreak = IIf((GetAsyncKeyState(19) And 32768) > 0, 1, 0) 'Pause/Break
                iTab = IIf((GetAsyncKeyState(9) And 32768) > 0, 1, 0) 'Tab
                iF09 = IIf((GetAsyncKeyState(120) And 32768) > 0, 1, 0) 'F09
                iF12 = IIf((GetAsyncKeyState(123) And 32768) > 0, 1, 0) 'F12
                Key7 = (iRet0 Or iRet1)
                Key6 = IIf((GetAsyncKeyState(122) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(8) And 32768) > 0, 1, 0)
                Key4 = (iBreak Or iF12)
                Key3 = (iTab Or iF09)
                Key2 = IIf((GetAsyncKeyState(27) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(116) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(115) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            'RIGHT,DOWN,UP,LEFT,DEL,INS,HOME(CLS),SPACE
            If (MSX_PPI_REG_C_KMT = 8) Then
                iSpc = IIf((GetAsyncKeyState(32) And 32768) > 0, 1, 0) 'Space
                Key7 = IIf((GetAsyncKeyState(39) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(40) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(38) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(37) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(46) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(45) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(36) And 32768) > 0, 1, 0)
                Key0 = (iSpc Or MSX.Gi_MSX_SpaceOn)
                GoTo NextProc
            End If

            '키패드 4,3,2,1,0,/,+,*
            If (MSX_PPI_REG_C_KMT = 9) Then
                Key7 = IIf((GetAsyncKeyState(100) And 32768) > 0, 1, 0)
                Key6 = IIf((GetAsyncKeyState(99) And 32768) > 0, 1, 0)
                Key5 = IIf((GetAsyncKeyState(98) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(97) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(96) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(111) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(107) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(106) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

            '키피드 .,,-NOT,-,9,8,7,6,5
            If (MSX_PPI_REG_C_KMT = 10) Then
                Key7 = IIf((GetAsyncKeyState(110) And 32768) > 0, 1, 0)
                Key6 = 0
                Key5 = IIf((GetAsyncKeyState(109) And 32768) > 0, 1, 0)
                Key4 = IIf((GetAsyncKeyState(105) And 32768) > 0, 1, 0)
                Key3 = IIf((GetAsyncKeyState(104) And 32768) > 0, 1, 0)
                Key2 = IIf((GetAsyncKeyState(103) And 32768) > 0, 1, 0)
                Key1 = IIf((GetAsyncKeyState(102) And 32768) > 0, 1, 0)
                Key0 = IIf((GetAsyncKeyState(101) And 32768) > 0, 1, 0)
                GoTo NextProc
            End If

NextProc:
            If (Key7 = 1) Then T = (T Or 128)
            If (Key6 = 1) Then T = (T Or 64)
            If (Key5 = 1) Then T = (T Or 32)
            If (Key4 = 1) Then T = (T Or 16)
            If (Key3 = 1) Then T = (T Or 8)
            If (Key2 = 1) Then T = (T Or 4)
            If (Key1 = 1) Then T = (T Or 2)
            If (Key0 = 1) Then T = (T Or 1)

LastProc:
            MSX_PPI_REG_B = Z80A.giGetIntToInt(Not T) '부정NOT

        End Sub
    End Module

End Namespace

'Home = 6
'BackSpace = 8
'Tab = 9
'Enter = 13
'Shift = 16
'Ctrl = 17
'Alt = 18
'Cap Lock = 20
'한자 = 25
'Esc = 27
'Space = 32
'PageUp = 33
'PageDown = 34
'End = 35
'Left = 37
'Up = 38
'Right = 39
'Down = 40
'Insert = 45
'Delete = 46
'A~ = 65~
'0~ = 96~
'F1 ~ = 112~
'한/영 = 229

'Home = 6
'BackSpace = 8
'Tab = 9
'Enter = 13
'Shift = 16
'Ctrl = 17
'Alt = 18
'Cap Lock = 20
'한자 = 25
'Esc = 27
'Space = 32
'PageUp = 33
'PageDown = 34
'End = 35
'Left = 37
'Up = 38
'Right = 39
'Down = 40
'Insert = 45
'Delete = 46
'A~ = 65~
'0~ = 96~
'F1 ~ = 112~
'한/영 = 229
