﻿Namespace PSG

    Module msxPSG

        Public MSX_PSG_REG(16 - 1) As Integer '0~255 (0~15)

        'PSG 레지스터
        'R00-채널A음성분주기-하위8비트
        'R01-채널A음성분주기-상위4비트
        'R02-채널B음성분주기-하위8비트
        'R03-채널B음성분주기-상위4비트
        'R04-채널C음성분주기-하위8비트
        'R05-채널C음성분주기-상위4비트
        'R06-노이즈분주기
        'R07-음의믹싱
        'R08-채널A음량
        'R09-채널B음량
        'R10-채널C음량
        'R11-엔빌로프주기-하위8비트
        'R12-엔빌로프주기-상위8비트
        'R13-엔빌로프파형
        'R14-I/O포트A(Read) - 7bit:카세트입력비트데이터, 6bit:0(키보드50음배열),1(Jis배열),5~0bit:범용입출력인터페이스접속7,6,4,3,2,1
        'R15-I/O포트B(Write) - 7bit:1(가나모드표시램프소등), 6bit:범용입출력인터페이스#1(0)/#2(1)와접속, bit5:인터페이스2의8번단자, bit4:인터페이스1의8번단자

        Public Gd_MSX_PSG_Oct_Hz(128 - 1) As Double 'Double (0~127)

        Public Go_MSX_PSG_TONE_A As Integer
        Public Gi_MSX_PSG_VEV_A As Integer
        Public Gi_MSX_PSG_VOL_A As Integer
        Public Go_MSX_PSG_TONE_B As Integer
        Public Gi_MSX_PSG_VEV_B As Integer
        Public Gi_MSX_PSG_VOL_B As Integer
        Public Go_MSX_PSG_TONE_C As Integer
        Public Gi_MSX_PSG_VEV_C As Integer
        Public Gi_MSX_PSG_VOL_C As Integer
        Public Go_MSX_PSG_NOISE As Integer
        Public Go_MSX_PSG_TONE_EV As Integer
        Public Gi_MSX_PSG_PATN_EV As Integer

        Public Gi_MSX_PSG_T_ON_A As Integer
        Public Gi_MSX_PSG_T_ON_B As Integer
        Public Gi_MSX_PSG_T_ON_C As Integer

        Public Gi_MSX_PSG_N_ON_A As Integer
        Public Gi_MSX_PSG_N_ON_B As Integer
        Public Gi_MSX_PSG_N_ON_C As Integer

        Public Gi_MIDI_TON_A As Integer
        Public Gi_MIDI_TON_B As Integer
        Public Gi_MIDI_TON_C As Integer
        Public Gi_MIDI_TON_NS As Integer

        Public Gi_MIDI_VOL_A As Integer
        Public Gi_MIDI_VOL_B As Integer
        Public Gi_MIDI_VOL_C As Integer

        Public Gi_MSX_PSG_T_ON_A_Bak As Integer
        Public Gi_MSX_PSG_T_ON_B_Bak As Integer
        Public Gi_MSX_PSG_T_ON_C_Bak As Integer

        Public Gi_MIDI_TON_A_Bak As Integer
        Public Gi_MIDI_TON_B_Bak As Integer
        Public Gi_MIDI_TON_C_Bak As Integer

        Public Gi_MIDI_VEV_A_Bak As Integer
        Public Gi_MIDI_VEV_B_Bak As Integer
        Public Gi_MIDI_VEV_C_Bak As Integer

        Public Gi_MIDI_VOL_A_Bak As Integer
        Public Gi_MIDI_VOL_B_Bak As Integer
        Public Gi_MIDI_VOL_C_Bak As Integer

        Public Sub MSX_INIT_PSG()

            Dim i As Integer

            for  i = 0 to 15
                MSX_PSG_REG(i) = 0
            Next i

            for  i = 0 to 127 
                Gd_MSX_PSG_Oct_Hz(i) = 0
            Next i

            Go_MSX_PSG_TONE_A = 0
            Gi_MSX_PSG_VEV_A = 0
            Gi_MSX_PSG_VOL_A = 0
            Go_MSX_PSG_TONE_B = 0
            Gi_MSX_PSG_VEV_B = 0
            Gi_MSX_PSG_VOL_B = 0
            Go_MSX_PSG_TONE_C = 0
            Gi_MSX_PSG_VEV_C = 0
            Gi_MSX_PSG_VOL_C = 0
            Go_MSX_PSG_NOISE = 0
            Go_MSX_PSG_TONE_EV = 0
            Gi_MSX_PSG_PATN_EV = 0
            Gi_MSX_PSG_T_ON_A = 1
            Gi_MSX_PSG_T_ON_B = 1
            Gi_MSX_PSG_T_ON_C = 1
            Gi_MSX_PSG_N_ON_A = 1
            Gi_MSX_PSG_N_ON_B = 1
            Gi_MSX_PSG_N_ON_C = 1

            Gi_MIDI_TON_A = 0
            Gi_MIDI_TON_B = 0
            Gi_MIDI_TON_C = 0
            Gi_MIDI_TON_NS = 0
            Gi_MIDI_VOL_A = 0
            Gi_MIDI_VOL_B = 0
            Gi_MIDI_VOL_C = 0

            Gi_MSX_PSG_T_ON_A_Bak = 0
            Gi_MSX_PSG_T_ON_B_Bak = 0
            Gi_MSX_PSG_T_ON_C_Bak = 0
            Gi_MIDI_TON_A_Bak = 0
            Gi_MIDI_TON_B_Bak = 0
            Gi_MIDI_TON_C_Bak = 0
            Gi_MIDI_VEV_A_Bak = 0
            Gi_MIDI_VEV_B_Bak = 0
            Gi_MIDI_VEV_C_Bak = 0
            Gi_MIDI_VOL_A_Bak = 0
            Gi_MIDI_VOL_B_Bak = 0
            Gi_MIDI_VOL_C_Bak = 0

        End Sub

        Public Sub SET_MSX_PSG_STATUS()

            Dim R As Integer
            Dim CasMotor As Integer
            Dim CasRead As Integer, KbdType As Integer
            Dim JoyBtnB As Integer, JoyBtnA As Integer
            Dim JoyRight As Integer, JoyLeft As Integer, JoyDown As Integer, JoyUp As Integer
            'A포트-R14
            'I/O포트A (Read)
            'MSX_PSG_REG_R14 'I/O포트A(Read)  b7:(카세트데이터입력),b6:(0:키50음배열,1:JIS배열),b5:(7번단자),b4:(6),b3:(4),b2:(3),b1:(2),b0(1) - 범용입출력인터페이스접속
            'MSX_PSG_REG_R15 'I/O포트B(Write) b7:(0:한글키LED-On,1:Off),b6:(0:포트A의5~0가법용입출력인터페이스1번과접속,1:2번과접속),b:(범용입출력인터페이스2의8번단자에접속),b4:(1의8번단자접속),b3~b0(사용안함)
            CasMotor = PPI.MSX_PPI_REG_C_CMT '0:On,1:Off
            CasRead = 0 '0:Low,1:High
            KbdType = 0 '0:50음배열,JIS배열
            JoyBtnB = IIf((PPI.Gb_MSX_KEY_Z() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            JoyBtnA = IIf((PPI.Gb_MSX_KEY_X() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            JoyRight = IIf((PPI.Gb_MSX_KEY_Right() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            JoyLeft = IIf((PPI.Gb_MSX_KEY_Left() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            JoyDown = IIf((PPI.Gb_MSX_KEY_Down() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            JoyUp = IIf((PPI.Gb_MSX_KEY_Up() = True) And (MSX.Gi_MSX_JoyOn = 1), 0, 1) '0:On,1:Off
            R = 0
            If (CasRead = 1) Then R = (R + 128)
            If (KbdType = 1) Then R = (R + 64)
            If (JoyBtnB = 1) Then R = (R + 32)
            If (JoyBtnA = 1) Then R = (R + 16)
            If (JoyRight = 1) Then R = (R + 8)
            If (JoyLeft = 1) Then R = (R + 4)
            If (JoyDown = 1) Then R = (R + 2)
            If (JoyUp = 1) Then R = (R + 1)
            PSG.MSX_PSG_REG(14) = (R)

        End Sub

        Public Sub MSX_PSG_REG_R00_WRITE()

            'MSX_PSG_REG_R00 '채널A음성분주기-하위8비트
            Go_MSX_PSG_TONE_A = Z80A.goGetIntHLToLng((MSX_PSG_REG(1) And 15), MSX_PSG_REG(0))
            Call MSX_PSG_MIDI_TONE_A()

        End Sub

        Public Sub MSX_PSG_REG_R01_WRITE()

            'MSX_PSG_REG_R01 '채널A음성분주기-상위4비트
            Go_MSX_PSG_TONE_A = Z80A.goGetIntHLToLng((MSX_PSG_REG(1) And 15), MSX_PSG_REG(0))
            Call MSX_PSG_MIDI_TONE_A()

        End Sub

        Public Sub MSX_PSG_REG_R02_WRITE()

            'MSX_PSG_REG_R02 '채널B음성분주기-하위8비트
            Go_MSX_PSG_TONE_B = Z80A.goGetIntHLToLng((MSX_PSG_REG(3) And 15), MSX_PSG_REG(2))
            Call MSX_PSG_MIDI_TONE_B()

        End Sub

        Public Sub MSX_PSG_REG_R03_WRITE()

            'MSX_PSG_REG_R03 '채널B음성분주기-상위4비트
            Go_MSX_PSG_TONE_B = Z80A.goGetIntHLToLng((MSX_PSG_REG(3) And 15), MSX_PSG_REG(2))
            Call MSX_PSG_MIDI_TONE_B()

        End Sub

        Public Sub MSX_PSG_REG_R04_WRITE()

            'MSX_PSG_REG_R04 '채널C음성분주기-하위8비트
            Go_MSX_PSG_TONE_C = Z80A.goGetIntHLToLng((MSX_PSG_REG(5) And 15), MSX_PSG_REG(4))
            Call MSX_PSG_MIDI_TONE_C()

        End Sub

        Public Sub MSX_PSG_REG_R05_WRITE()

            'MSX_PSG_REG_R05 '채널C음성분주기-상위4비트
            Go_MSX_PSG_TONE_C = Z80A.goGetIntHLToLng((MSX_PSG_REG(5) And 15), MSX_PSG_REG(4))
            Call MSX_PSG_MIDI_TONE_C()

        End Sub

        Public Sub MSX_PSG_REG_R06_WRITE()

            'MSX_PSG_REG_R06 '노이즈분주기-하위5비트
            Go_MSX_PSG_NOISE = (MSX_PSG_REG(6) And 31)
            Call MSX_PSG_MIDI_NOISE()

        End Sub

        Public Sub MSX_PSG_REG_R07_WRITE()

            'MSX_PSG_REG_R07 '음의믹싱-In/Out(1:B포트출력),(0:A포트입력),Noise(C),(B),(A),Tone(C),(B),(A)-0:On,1:Off
            Gi_MSX_PSG_N_ON_C = IIf((MSX_PSG_REG(7) And 32) = 0, 0, 1)
            Gi_MSX_PSG_N_ON_B = IIf((MSX_PSG_REG(7) And 16) = 0, 0, 1)
            Gi_MSX_PSG_N_ON_A = IIf((MSX_PSG_REG(7) And 8) = 0, 0, 1)
            Gi_MSX_PSG_T_ON_C = IIf((MSX_PSG_REG(7) And 4) = 0, 0, 1)
            Gi_MSX_PSG_T_ON_B = IIf((MSX_PSG_REG(7) And 2) = 0, 0, 1)
            Gi_MSX_PSG_T_ON_A = IIf((MSX_PSG_REG(7) And 1) = 0, 0, 1)

        End Sub

        Public Sub MSX_PSG_REG_R08_WRITE()

            'MSX_PSG_REG_R08 '채널A음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
            Gi_MSX_PSG_VEV_A = IIf((MSX_PSG_REG(8) And 16) = 0, 0, 1)
            Gi_MSX_PSG_VOL_A = ((MSX_PSG_REG(8) And 15))
            Call MSX_PSG_MIDI_VOL_A()

        End Sub

        Public Sub MSX_PSG_REG_R09_WRITE()

            'MSX_PSG_REG_R09 '채널B음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
            Gi_MSX_PSG_VEV_B = IIf((MSX_PSG_REG(9) And 16) = 0, 0, 1)
            Gi_MSX_PSG_VOL_B = ((MSX_PSG_REG(9) And 15))
            Call MSX_PSG_MIDI_VOL_B()

        End Sub

        Public Sub MSX_PSG_REG_R10_WRITE()

            'MSX_PSG_REG_R10 '채널C음량-M(0:음량사용,1:엔빌로프사용음량무시)+하위4비트
            Gi_MSX_PSG_VEV_C = IIf((MSX_PSG_REG(10) And 16) = 0, 0, 1)
            Gi_MSX_PSG_VOL_C = ((MSX_PSG_REG(10) And 15))
            Call MSX_PSG_MIDI_VOL_C()

        End Sub

        Public Sub MSX_PSG_REG_R11_WRITE()

            'MSX_PSG_REG_R11 '엔빌로프주기-하위8비트
            Go_MSX_PSG_TONE_EV = Z80A.goGetIntHLToLng(MSX_PSG_REG(12), MSX_PSG_REG(11))

        End Sub

        Public Sub MSX_PSG_REG_R12_WRITE()

            'MSX_PSG_REG_R12 '엔빌로프주기-상위8비트
            Go_MSX_PSG_TONE_EV = Z80A.goGetIntHLToLng(MSX_PSG_REG(12), MSX_PSG_REG(11))

        End Sub

        Public Sub MSX_PSG_REG_R13_WRITE()

            'MSX_PSG_REG_R13 '엔빌로프패턴-하위4비트
            Gi_MSX_PSG_PATN_EV = ((MSX_PSG_REG(13) And 15))

        End Sub

        Public Sub MSX_PSG_MIDI_TONE_A()

            Gi_MIDI_TON_A = fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_A, 0)

        End Sub

        Public Sub MSX_PSG_MIDI_TONE_B()


            Gi_MIDI_TON_B = fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_B, 0)

        End Sub

        Public Sub MSX_PSG_MIDI_TONE_C()


            Gi_MIDI_TON_C = fi_GET_TON_TO_MIDI(Go_MSX_PSG_TONE_C, 0)

        End Sub

        Public Sub MSX_PSG_MIDI_NOISE()

            Gi_MIDI_TON_NS = fi_GET_TON_TO_MIDI(Go_MSX_PSG_NOISE, 1) '?

        End Sub

        Public Sub MSX_PSG_MIDI_VOL_A()

            Gi_MIDI_VOL_A = fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_A)

        End Sub

        Public Sub MSX_PSG_MIDI_VOL_B()

            Gi_MIDI_VOL_B = fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_B)

        End Sub

        Public Sub MSX_PSG_MIDI_VOL_C()

            Gi_MIDI_VOL_C = fi_GET_VOL_TO_MIDI(Gi_MSX_PSG_VOL_C)

        End Sub

        Private Function fi_GET_TON_TO_MIDI(ByVal oTon As Integer, ByVal iNos As Integer) As Integer

            Dim R As Integer, Hz As Double, cHz As Double, bHz As Double
            Dim i As Integer

            If (oTon = 0) Then R = -1 : GoTo LastProc
            If (iNos = 0) Then
                Hz = 111860.78125 / oTon '주파수계산(27(FFFh)~111860(001h))
            Else
                'Hz = 111860.78125 / oTon / 1000 '주파수계산(3.6(31)~111.9(1))
                Hz = 111860.78125 / oTon / 10 '360~11,190
            End If
            R = 0
            bHz = 12545
            For i = 0 To 127
                cHz = System.Math.Abs(Hz - Gd_MSX_PSG_Oct_Hz(i))
                If (cHz < bHz) Then
                    bHz = cHz
                    R = i
                Else
                    GoTo LastProc
                End If
            Next i

LastProc:
            fi_GET_TON_TO_MIDI = R

        End Function

        Private Function fi_GET_VOL_TO_MIDI(ByVal iVol As Integer) As Integer

            Dim R As Integer

            R = (iVol * 8.5)
            If (R > PSGOUT.fiMaxVol) Then R = PSGOUT.fiMaxVol

            fi_GET_VOL_TO_MIDI = R

        End Function

        Public Sub MSX_Compute_Oct_Hz()

            Dim j As Integer, Hz As Double
            Dim i As Integer

            Gd_MSX_PSG_Oct_Hz(69) = 440
            j = 0
            For i = 70 To 127
                j += 1
                Hz = 440 * (System.Math.Pow(2, (j / 12.0))) 'Gd_MSX_PSG_Oct_Hz(i) = 440 * (2 ^ (j / 12))
                Gd_MSX_PSG_Oct_Hz(i) = Hz
            Next i
            j = 0
            For i = 68 To 0 Step -1
                j -= 1
                Hz = 440 * (System.Math.Pow(2, (j / 12.0))) 'Gd_MSX_PSG_Oct_Hz(i) = 440 * (2 ^ (j / 12))
                Gd_MSX_PSG_Oct_Hz(i) = Hz
            Next i

        End Sub
    End Module

End Namespace

'Gd_MSX_PSG_Oct_Hz(127)

'Hz     1    2   3   4   5   6   7   8
'----------------------------------------------
'C   32.7032 65.4064               ~> 2 배 증가
'C#  34.6478 69.2957
'D   36.7081 73.4162
'D#  38.8909 77.7817
'E   41.2034
'F   43.6535
'F#  46.2493         440*(2^(-n~0~+n/12))
'G   48.9994
'G#  51.9130
'A   55.0000         A4기준(440.0000Hz)-정중앙
'A#  58.2705
'B   61.7354                         7902.133

'MIDI 1   2   3   4   5   6   7   8   9  10  11
'----------------------------------------------
'C    0  12  24  36  48  60  72  84  96 108 120
'C#   1  13  25  37  49  61  73  85  97 109 121
'D    2  14  26  38  50  62  74  86  98 110 122
'D#   3  15  27  39  51  63  75  87  99 111 123
'E    4  16  28  40  52  64  76  88 100 112 124
'F    5  17  29  41  53  65  77  89 101 113 125
'F#   6  18  30  42  54  66  78  90 102 114 126
'G    7  19  31  43  55  67  79  91 103 115 127
'G#   8  20  32  44  56  68  80  92 104 116
'A    9  21  33  45  57 (69) 81  93 105 117
'A#  10  22  34  46  58  70  82  94 106 118
'B   11  23  35  47  59  71  83  95 107 119

'001h->111860.78125
'009h->12428.9756944444
'FFFh->27.3164300976801

'0 : 8.17579891564371
'1 : 8.66195721802725
'2 : 9.17702399741899
'3 : 9.72271824131503
'4 : 10.3008611535272
'5 : 10.9133822322814
'6 : 11.5623257097386
'7 : 12.2498573744297
'8 : 12.9782717993733
'9 : 13.75
'10 : 14.5676175474403
'11 : 15.4338531642539
'12 : 16.3515978312874
'13 : 17.3239144360545
'14 : 18.354047994838
'15 : 19.4454364826301
'16 : 20.6017223070544
'17 : 21.8267644645627
'18 : 23.1246514194772
'19 : 24.4997147488593
'20 : 25.9565435987466
'21 : 27.5
'22 : 29.1352350948806
'23 : 30.8677063285078
'24 : 32.7031956625748
'25 : 34.647828872109
'26 : 36.7080959896759
'27 : 38.8908729652601
'28 : 41.2034446141087
'29 : 43.6535289291255
'30 : 46.2493028389543
'31 : 48.9994294977187
'32 : 51.9130871974931
'33 : 55
'34 : 58.2704701897612
'35 : 61.7354126570155
'36 : 65.4063913251497
'37 : 69.295657744218
'38 : 73.4161919793519
'39 : 77.7817459305202
'40 : 82.4068892282175
'41 : 87.307057858251
'42 : 92.4986056779086
'43 : 97.9988589954373
'44 : 103.826174394986
'45 : 110
'46 : 116.540940379522
'47 : 123.470825314031
'48 : 130.812782650299
'49 : 138.591315488436
'50 : 146.832383958704
'51 : 155.56349186104
'52 : 164.813778456435
'53 : 174.614115716502
'54 : 184.997211355817
'55 : 195.997717990875
'56 : 207.652348789973
'57 : 220
'58 : 233.081880759045
'59 : 246.941650628062
'60 : 261.625565300599
'61 : 277.182630976872
'62 : 293.664767917408
'63 : 311.126983722081
'64 : 329.62755691287
'65 : 349.228231433004
'66 : 369.994422711634
'67 : 391.995435981749
'68 : 415.304697579945
'69 : 440
'70 : 466.16376151809
'71 : 493.883301256124
'72 : 523.251130601197
'73 : 554.365261953744
'74 : 587.329535834815
'75 : 622.253967444162
'76 : 659.25511382574
'77 : 698.456462866008
'78 : 739.988845423269
'79 : 783.990871963499
'80 : 830.60939515989
'81 : 880
'82 : 932.32752303618
'83 : 987.766602512248
'84 : 1046.50226120239
'85 : 1108.73052390749
'86 : 1174.65907166963
'87 : 1244.50793488832
'88 : 1318.51022765148
'89 : 1396.91292573202
'90 : 1479.97769084654
'91 : 1567.981743927
'92 : 1661.21879031978
'93 : 1760
'94 : 1864.65504607236
'95 : 1975.5332050245
'96 : 2093.00452240479
'97 : 2217.46104781498
'98 : 2349.31814333926
'99 : 2489.01586977665
'100 : 2637.02045530296
'101 : 2793.82585146403
'102 : 2959.95538169308
'103 : 3135.96348785399
'104 : 3322.43758063956
'105 : 3520
'106 : 3729.31009214472
'107 : 3951.06641004899
'108 : 4186.00904480958
'109 : 4434.92209562995
'110 : 4698.63628667852
'111 : 4978.03173955329
'112 : 5274.04091060592
'113 : 5587.65170292806
'114 : 5919.91076338615
'115 : 6271.92697570799
'116 : 6644.87516127912
'117 : 7040
'118 : 7458.62018428944
'119 : 7902.13282009799
'120 : 8372.01808961916
'121 : 8869.84419125991
'122 : 9397.27257335704
'123 : 9956.06347910659
'124 : 10548.0818212118
'125 : 11175.3034058561
'126 : 11839.8215267723
'127 : 12543.853951416

'000-"Grand Piano", "Bright Grand", "Electric Grand", "Honky Tonk", "Rhodes",
'005-"Chorus Piano", "Harpsichord", "Clavichord", "Celesta", "Glockenspiel",
'010-"Music Box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells",
'015-"Dulcimer", "Hammond Organ", "Percussion Organ", "Rock Organ", "Church Organ",
'020-"Reed Organ", "Accordian", "Harmonica", "Tango Accordian", "Acoustic Nylon Guitar",
'025-"Acoustic Steel Guitar", "Electric Jazz Guitar", "Electric Clean Guitar", "Electric Mute Guitar", "Overdrive Guitar",
'030-"Distorted Guitar", "Guitar Harmonic", "Acoustic Bass", "Electric Bass Finger", "Electric Bass Pick",
'035-"Fretless Bass", "Slap Bass One", "Slap Bass Two", "Synth Bass One", "Synth Bass Two",
'040-"Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings",
'045-"Pizzicato Strings", "Orchestra Harp", "Timpani", "String Ensemble One", "String Ensemble Two",
'050-"Synth Strings One", "Synth Strings Two", "Choir Ahhs", "Voice Oohs", "Synth Voice",
'055-"Orchestra Hit", "Trumpet", "Trombone", "Tuba", "Mute Trumpet",
'060-"French Horn", "Brass Section", "Synth Brass One", "Synth Brass Two", "Soprano Sax",
'065-"Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn",
'070-"Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder",
'075-"Pan Flute", "Bottle Blow", "Shakuhachi", "Whistle", "Ocarina",
'080-"Square Wave", "Sawtooth", "Calliope", "Chiff Lead", "Charang",
'085-"Solo Synth VX", "Brite Saw", "Brass and Lead", "Fantasia Pad", "Warm Pad",
'090-"Poly Synth Pad", "Space Vox Pad", "Bowed Glass Pad", "Metal Pad", "Halo Pad",
'095-"Sweep Pad", "Ice Rain", "Sound Track", "Crystal", "Atmosphere",
'100-"Brightness", "Goblin", "Echo Drops", "Star Theme", "Sitar",
'105-"Banjo", "Shamisen", "Koto", "Kalimba", "Bagpipe",
'110-"Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums",
'115-"Wood Block", "Taiko Drum", "Melodic Tom", "Synth Drum", "Rev Cymbal",
'120-"Guitar Fret Noise", "Breath Noise", "Sea Shore", "Bird Tweet", "Phone Ring",
'125-"Helicopter", "Applause", "Gunshot"
