﻿Namespace PSGOUT

    Module msxPSG_OUT

        Private Declare Function midiOutOpen Lib "winmm.dll" (ByRef lphMidiOut As Integer, ByVal uDeviceID As Integer, ByVal dwCallback As Integer, ByVal dwInstance As Integer, ByVal dwFlags As Integer) As Integer
        Private Declare Function midiOutClose Lib "winmm.dll" (ByVal hMidiOut As Integer) As Integer
        Private Declare Function midiOutReset Lib "winmm.dll" (ByVal hMidiOut As Integer) As Integer
        Private Declare Function midiOutShortMsg Lib "winmm.dll" (ByVal hMidiOut As Integer, ByVal dwMsg As Integer) As Integer

        Public Gi_MDH As Integer
        Public Gb_MidiOpened As Boolean

        Public Const fiMaxVol As Integer = 127

        Public Const fiMidi As Integer = 71   '71:Clarinet, 80:Square Wave
        Public Const fiMidi2 As Integer = 0   '0:Grand Piano
        Public Const fiNoise As Integer = 127 '127:Gunshot

        Public Sub gt_MSX_Midi_Open()

            '핸들,Mapper,0,0,CallBack_Null
            If (midiOutOpen(Gi_MDH, 0, 0, 0, 0) = 0) Then 'Gi_MDH<-미디를열고핸들을저장
                Gb_MidiOpened = True
                Call gt_MSX_Midi_Out(&HC0, 1, fiMidi, 0) '악기선택
                Call gt_MSX_Midi_Out(&HC0, 2, fiMidi, 0)
                Call gt_MSX_Midi_Out(&HC0, 3, fiMidi, 0)
                Call gt_MSX_Midi_Out(&HC0, 4, fiNoise, 0) '악기선택
                Call gt_MSX_Midi_Out(&HC0, 5, fiNoise, 0)
                Call gt_MSX_Midi_Out(&HC0, 6, fiNoise, 0)
            End If

        End Sub

        Public Sub gt_MSX_Midi_Close()

            '핸들
            If (Gb_MidiOpened) Then
                Call midiOutReset(Gi_MDH)
                Call midiOutClose(Gi_MDH) '미디닫기(Gi_MDH핸들)
                Gb_MidiOpened = False
            End If

        End Sub

        Public Sub gt_MSX_Midi_Out(ByVal iCmd As Integer, ByVal iChannel As Integer, ByVal iTone As Integer, ByVal iVolume As Integer)

            '핸들,명령코드,채널(0~15),파라미터1(톤0~127),파라미터2(볼륨0~127)
            '명령코드 90h~9Fh(채널1~16)-노트On, 80h~8Fh(채널1~16)-노트Off
            '         C0h~CFh(채널1~16)-악기변경,D0h~DFh-ChannelAfterTouch,E0h~EFh-ChannelPitchWheel
            '60=도,61=도#,62=레
            If (Gb_MidiOpened) Then
                Call midiOutShortMsg(Gi_MDH, ((iCmd + iChannel - 1) Or (iTone * 256) Or (iVolume * 65536)))
            End If

        End Sub

        Public Sub MSX_PSG_TONE_OUT_A(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_A >= 0)) Then
                If ((PSG.Gi_MSX_PSG_T_ON_A_Bak = 0) Or (PSG.Gi_MIDI_TON_A_Bak <> PSG.Gi_MIDI_TON_A) Or (PSG.Gi_MIDI_VEV_A_Bak <> PSG.Gi_MSX_PSG_VEV_A) Or (PSG.Gi_MIDI_VOL_A_Bak <> PSG.Gi_MIDI_VOL_A)) Then
                    If (PSG.Gi_MSX_PSG_T_ON_A_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 1, PSG.Gi_MIDI_TON_A_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_A_Bak = 0
                    If ((PSG.Gi_MIDI_VEV_A_Bak <> PSG.Gi_MSX_PSG_VEV_A)) Then
                        If ((PSG.Gi_MSX_PSG_VEV_A = 0)) Then
                            Call gt_MSX_Midi_Out(&HC0, 1, fiMidi, 0) '악기선택
                        Else
                            Call gt_MSX_Midi_Out(&HC0, 1, fiMidi2, 0) '악기선택
                        End If
                    End If
                    If ((PSG.Gi_MSX_PSG_VEV_A = 0) And (PSG.Gi_MIDI_VOL_A > 0)) Then gt_MSX_Midi_Out(&H90, 1, PSG.Gi_MIDI_TON_A, PSG.Gi_MIDI_VOL_A) : PSG.Gi_MSX_PSG_T_ON_A_Bak = 1
                    If (PSG.Gi_MSX_PSG_VEV_A = 1) Then Call gt_MSX_Midi_Out(&H90, 1, PSG.Gi_MIDI_TON_A, fiMaxVol) : PSG.Gi_MSX_PSG_T_ON_A_Bak = 1
                End If
                PSG.Gi_MIDI_TON_A_Bak = PSG.Gi_MIDI_TON_A
                PSG.Gi_MIDI_VEV_A_Bak = PSG.Gi_MSX_PSG_VEV_A
                PSG.Gi_MIDI_VOL_A_Bak = PSG.Gi_MIDI_VOL_A
            Else
                If (PSG.Gi_MSX_PSG_T_ON_A_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 1, PSG.Gi_MIDI_TON_A_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_A_Bak = 0
            End If

        End Sub

        Public Sub MSX_PSG_TONE_OUT_B(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_B >= 0)) Then
                If ((PSG.Gi_MSX_PSG_T_ON_B_Bak = 0) Or (PSG.Gi_MIDI_TON_B_Bak <> PSG.Gi_MIDI_TON_B) Or (PSG.Gi_MIDI_VEV_B_Bak <> PSG.Gi_MSX_PSG_VEV_B) Or (PSG.Gi_MIDI_VOL_B_Bak <> PSG.Gi_MIDI_VOL_B)) Then
                    If (PSG.Gi_MSX_PSG_T_ON_B_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 2, PSG.Gi_MIDI_TON_B_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_B_Bak = 0
                    If ((PSG.Gi_MIDI_VEV_B_Bak <> PSG.Gi_MSX_PSG_VEV_B)) Then
                        If ((PSG.Gi_MSX_PSG_VEV_B = 0)) Then
                            Call gt_MSX_Midi_Out(&HC0, 2, fiMidi, 0) '악기선택
                        Else
                            Call gt_MSX_Midi_Out(&HC0, 2, fiMidi2, 0) '악기선택
                        End If
                    End If
                    If ((PSG.Gi_MSX_PSG_VEV_B = 0) And (PSG.Gi_MIDI_VOL_B > 0)) Then gt_MSX_Midi_Out(&H90, 2, PSG.Gi_MIDI_TON_B, PSG.Gi_MIDI_VOL_B) : PSG.Gi_MSX_PSG_T_ON_B_Bak = 1
                    If (PSG.Gi_MSX_PSG_VEV_B = 1) Then Call gt_MSX_Midi_Out(&H90, 2, PSG.Gi_MIDI_TON_B, fiMaxVol) : PSG.Gi_MSX_PSG_T_ON_B_Bak = 1
                End If
                PSG.Gi_MIDI_TON_B_Bak = PSG.Gi_MIDI_TON_B
                PSG.Gi_MIDI_VEV_B_Bak = PSG.Gi_MSX_PSG_VEV_B
                PSG.Gi_MIDI_VOL_B_Bak = PSG.Gi_MIDI_VOL_B
            Else
                If (PSG.Gi_MSX_PSG_T_ON_B_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 2, PSG.Gi_MIDI_TON_B_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_B_Bak = 0
            End If

        End Sub

        Public Sub MSX_PSG_TONE_OUT_C(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_C >= 0)) Then
                If ((PSG.Gi_MSX_PSG_T_ON_C_Bak = 0) Or (PSG.Gi_MIDI_TON_C_Bak <> PSG.Gi_MIDI_TON_C) Or (PSG.Gi_MIDI_VEV_C_Bak <> PSG.Gi_MSX_PSG_VEV_C) Or (PSG.Gi_MIDI_VOL_C_Bak <> PSG.Gi_MIDI_VOL_C)) Then
                    If (PSG.Gi_MSX_PSG_T_ON_C_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 3, PSG.Gi_MIDI_TON_C_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_C_Bak = 0
                    If ((PSG.Gi_MIDI_VEV_C_Bak <> PSG.Gi_MSX_PSG_VEV_C)) Then
                        If ((PSG.Gi_MSX_PSG_VEV_C = 0)) Then
                            Call gt_MSX_Midi_Out(&HC0, 3, fiMidi, 0) '악기선택
                        Else
                            Call gt_MSX_Midi_Out(&HC0, 3, fiMidi2, 0) '악기선택                    
                        End If
                    End If
                    If ((PSG.Gi_MSX_PSG_VEV_C = 0) And (PSG.Gi_MIDI_VOL_C > 0)) Then gt_MSX_Midi_Out(&H90, 3, PSG.Gi_MIDI_TON_C, PSG.Gi_MIDI_VOL_C) : PSG.Gi_MSX_PSG_T_ON_C_Bak = 1
                    If (PSG.Gi_MSX_PSG_VEV_C = 1) Then Call gt_MSX_Midi_Out(&H90, 3, PSG.Gi_MIDI_TON_C, fiMaxVol) : PSG.Gi_MSX_PSG_T_ON_C_Bak = 1
                End If
                PSG.Gi_MIDI_TON_C_Bak = PSG.Gi_MIDI_TON_C
                PSG.Gi_MIDI_VEV_C_Bak = PSG.Gi_MSX_PSG_VEV_C
                PSG.Gi_MIDI_VOL_C_Bak = PSG.Gi_MIDI_VOL_C
            Else
                If (PSG.Gi_MSX_PSG_T_ON_C_Bak = 1) Then Call gt_MSX_Midi_Out(&H80, 3, PSG.Gi_MIDI_TON_C_Bak, 0) : PSG.Gi_MSX_PSG_T_ON_C_Bak = 0
            End If

        End Sub

        Public Sub MSX_PSG_NOISE_OUT_A(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_NS >= 0)) Then
                If ((PSG.Gi_MSX_PSG_VEV_A = 0) And (PSG.Gi_MIDI_VOL_A > 0)) Then Call gt_MSX_Midi_Out(&H90, 4, PSG.Gi_MIDI_TON_NS, PSG.Gi_MIDI_VOL_A)
                If ((PSG.Gi_MSX_PSG_VEV_A = 1)) Then Call gt_MSX_Midi_Out(&H90, 4, PSG.Gi_MIDI_TON_NS, fiMaxVol)
            End If

        End Sub

        Public Sub MSX_PSG_NOISE_OUT_B(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_NS >= 0)) Then
                If ((PSG.Gi_MSX_PSG_VEV_B = 0) And (PSG.Gi_MIDI_VOL_B > 0)) Then Call gt_MSX_Midi_Out(&H90, 5, PSG.Gi_MIDI_TON_NS, PSG.Gi_MIDI_VOL_B)
                If ((PSG.Gi_MSX_PSG_VEV_B = 1)) Then Call gt_MSX_Midi_Out(&H90, 5, PSG.Gi_MIDI_TON_NS, fiMaxVol)
            End If

        End Sub

        Public Sub MSX_PSG_NOISE_OUT_C(ByVal iOn As Integer)

            If ((iOn = 0) And (PSG.Gi_MIDI_TON_NS >= 0)) Then
                If ((PSG.Gi_MSX_PSG_VEV_C = 0) And (PSG.Gi_MIDI_VOL_C > 0)) Then Call gt_MSX_Midi_Out(&H90, 6, PSG.Gi_MIDI_TON_NS, PSG.Gi_MIDI_VOL_C)
                If ((PSG.Gi_MSX_PSG_VEV_C = 1)) Then Call gt_MSX_Midi_Out(&H90, 6, PSG.Gi_MIDI_TON_NS, fiMaxVol)
            End If

        End Sub
    End Module

End Namespace
