﻿Imports System.IO

Namespace MSL

    Module msxSaveLoad

        Public Sub MsxSaveStatus()

            Dim WriteStream As FileStream

            Dim FileName As String
            Dim b As byte, bh As Integer = 0, bl As Integer = 0

            Dim i As Integer, j As Integer

            FileName = "C:\MSX-" + DateTime.Now.ToString("yyyyMMdd") + "-" + DateTime.Now.ToString("HHmmss") + ".MSX"

            WriteStream = New FileStream(FileName, FileMode.Create)
            Dim bw As New BinaryWriter(WriteStream)

            'dim b As 아무타입(Integer 등등), bw.BaseStream.WriteByte(b) -> 속도느림
            'dim b As byte,                   bw.Write(b)                -> 속도빠름

            'Z80A
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_PC, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_SP, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_IX, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_IY, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = Z80A.Z80A_REG_A : bw.Write(b)
            b = Z80A.Z80A_REG_F : bw.Write(b)
            b = Z80A.Z80A_REG_B : bw.Write(b)
            b = Z80A.Z80A_REG_C : bw.Write(b)
            b = Z80A.Z80A_REG_D : bw.Write(b)
            b = Z80A.Z80A_REG_E : bw.Write(b)
            b = Z80A.Z80A_REG_H : bw.Write(b)
            b = Z80A.Z80A_REG_L : bw.Write(b)
            b = Z80A.Z80A_REG_A2 : bw.Write(b)
            b = Z80A.Z80A_REG_F2 : bw.Write(b)
            b = Z80A.Z80A_REG_B2 : bw.Write(b)
            b = Z80A.Z80A_REG_C2 : bw.Write(b)
            b = Z80A.Z80A_REG_D2 : bw.Write(b)
            b = Z80A.Z80A_REG_E2 : bw.Write(b)
            b = Z80A.Z80A_REG_H2 : bw.Write(b)
            b = Z80A.Z80A_REG_L2 : bw.Write(b)
            b = Z80A.Z80A_REG_I : bw.Write(b)
            b = Z80A.Z80A_REG_R : bw.Write(b)
            b = Z80A.Z80A_REG_IFF1 : bw.Write(b)
            b = Z80A.Z80A_REG_IFF2 : bw.Write(b)

            'INT
            b = INT.Gi_MSX_Interrupt : bw.Write(b)
            Z80A.gtMoveLngToIntHL(INT.Go_MSX_InterruptBack, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = INT.Z80A_INT_MODE : bw.Write(b)
            b = INT.Z80A_HALT : bw.Write(b)

            'MEM
            For i = 0 To 4 - 1
                For j = 0 To 65536 - 1
                    b = MEM.MSX_MEM(i, j) : bw.Write(b)
                Next j
            Next i
            b = MEM.Gi_MEM_PAGE0 : bw.Write(b)
            b = MEM.Gi_MEM_PAGE1 : bw.Write(b)
            b = MEM.Gi_MEM_PAGE2 : bw.Write(b)
            b = MEM.Gi_MEM_PAGE3 : bw.Write(b)
            b = MEM.Gi_MEM_EXT_PAGE0 : bw.Write(b)
            b = MEM.Gi_MEM_EXT_PAGE1 : bw.Write(b)
            b = MEM.Gi_MEM_EXT_PAGE2 : bw.Write(b)
            b = MEM.Gi_MEM_EXT_PAGE3 : bw.Write(b)
            For i = 0 To 4194304 - 1
                b = MEM.MSX_ROM(i) : bw.Write(b)
            Next i
            b = MEM.Gi_Big32K_ROM : bw.Write(b)
            For i = 0 To 4194304 - 1
                b = MEM.MSX_RAM(i) : bw.Write(b)
            Next i
            b = MEM.Gi_RAM_PAGE0 : bw.Write(b)
            b = MEM.Gi_RAM_PAGE1 : bw.Write(b)
            b = MEM.Gi_RAM_PAGE2 : bw.Write(b)
            b = MEM.Gi_RAM_PAGE3 : bw.Write(b)

            'IO
            For i = 0 To 256 - 1
                b = IO.MSX_PORT(i) : bw.Write(b)
            Next i
            For i = 0 To 4 - 1
                For j = 0 To 16 - 1
                    b = IO.MSX_CLOCK_REG(i, j) : bw.Write(b)
                Next j
            Next i
            b = IO.Gi_MSX_PortWrite : bw.Write(b)

            'PPI
            b = PPI.MSX_PPI_REG_B : bw.Write(b)
            b = PPI.MSX_PPI_REG_C_KSO : bw.Write(b)
            b = PPI.MSX_PPI_REG_C_KCL : bw.Write(b)
            b = PPI.MSX_PPI_REG_C_CWT : bw.Write(b)
            b = PPI.MSX_PPI_REG_C_CMT : bw.Write(b)
            b = PPI.MSX_PPI_REG_C_KMT : bw.Write(b)

            'VDT
            For i = 0 To 131072 - 1
                b = VDT.MSX_VRAM(i) : bw.Write(b)
            Next i
            For i = 0 To 47 - 1
                b = VDT.MSX_VDT_REG(i) : bw.Write(b)
            Next i
            b = VDT.MSX_VDT_REG_IE1 : bw.Write(b)
            b = VDT.MSX_VDT_REG_EV : bw.Write(b)
            b = VDT.MSX_VDT_REG_16K : bw.Write(b)
            b = VDT.MSX_VDT_REG_ON : bw.Write(b)
            b = VDT.MSX_VDT_REG_IE0 : bw.Write(b)
            b = VDT.MSX_VDT_REG_SZ : bw.Write(b)
            b = VDT.MSX_VDT_REG_SM : bw.Write(b)
            b = VDT.MSX_VDT_REG_TP : bw.Write(b)
            b = VDT.MSX_VDT_REG_SPD : bw.Write(b)
            b = VDT.MSX_VDT_REG_LN : bw.Write(b)
            b = VDT.MSX_VDT_REG_IL : bw.Write(b)
            b = VDT.MSX_VDT_REG_EO : bw.Write(b)
            For i = 0 To 131072 - 1
                b = VDT.MSX_VRAM_Buff(i) : bw.Write(b)
            Next i
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VRAM_Buff_Size, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VRAM_Buff_Count, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_SX, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_SY, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_DX, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_DY, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_NX, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_Mjg, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_NY, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_Min, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = VDT.Gi_MSX_VDT_CMD_REG_Color : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_MXC : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_MXD : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_MXS : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_DIY : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_DIX : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_EQ : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_MAJ : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_CMD : bw.Write(b)
            b = VDT.MSX_VDT_CMD_REG_LO : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_FF : bw.Write(b)
            b = VDT.Gi_MSX_VDT_ST_REG_FF : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_5S : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_C : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_5SN : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_FL : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_LPS : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_ID : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_FH : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_TR : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_VR : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_HR : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_BD : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_EO : bw.Write(b)
            b = VDT.MSX_VDT_ST_REG_CE : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_ST_REG_Column, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_ST_REG_Row, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = VDT.Gi_MSX_VDT_ST_REG_Color : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_ST_REG_BX, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = VDT.Gi_MSX_SCREEN_MODE : bw.Write(b)
            b = VDT.Gi_MSX_VRAM_IO : bw.Write(b)
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VRAM_ADDRESS, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = VDT.Gi_MSX_VRAM_Flg : bw.Write(b)
            b = VDT.Gi_MSX2_VRAM_Flg : bw.Write(b)
            For i = 0 To 16 - 1
                b = VDT.MSX_VDT_REG_PAL_Red(i) : bw.Write(b)
                b = VDT.MSX_VDT_REG_PAL_Green(i) : bw.Write(b)
                b = VDT.MSX_VDT_REG_PAL_Blue(i) : bw.Write(b)
            Next i

            'PSG
            For i = 0 To 16 - 1
                b = PSG.MSX_PSG_REG(i) : bw.Write(b)
            Next i
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_A, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VEV_A : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VOL_A : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_B, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VEV_B : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VOL_B : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_C, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VEV_C : bw.Write(b)
            b = PSG.Gi_MSX_PSG_VOL_C : bw.Write(b)
            b = PSG.Go_MSX_PSG_NOISE : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_EV, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MSX_PSG_PATN_EV : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_A : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_B : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_C : bw.Write(b)
            b = PSG.Gi_MSX_PSG_N_ON_A : bw.Write(b)
            b = PSG.Gi_MSX_PSG_N_ON_B : bw.Write(b)
            b = PSG.Gi_MSX_PSG_N_ON_C : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_A, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_B, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_C, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_NS, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_A : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_B : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_C : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_A_Bak : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_B_Bak : bw.Write(b)
            b = PSG.Gi_MSX_PSG_T_ON_C_Bak : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_A_Bak, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_B_Bak, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            Z80A.gtMoveLngToIntHL(PSG.Gi_MIDI_TON_C_Bak, bh, bl)
            b = bl : bw.Write(b)
            b = bh : bw.Write(b)
            b = PSG.Gi_MIDI_VEV_A_Bak : bw.Write(b)
            b = PSG.Gi_MIDI_VEV_B_Bak : bw.Write(b)
            b = PSG.Gi_MIDI_VEV_C_Bak : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_A_Bak : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_B_Bak : bw.Write(b)
            b = PSG.Gi_MIDI_VOL_C_Bak : bw.Write(b)

            bw.Close()

        End Sub

        Public Sub MsxLoadStatus(ByVal FileName As String)

            Dim ReadStream As FileStream

            Dim bh As Integer = 0, bl As Integer = 0

            ReadStream = New FileStream(FileName, FileMode.Open)
            Dim br As New BinaryReader(ReadStream)

            Dim i As Integer, j As Integer

            'Z80A
            bl = br.ReadByte()
            bh = br.ReadByte()
            Z80A.Z80A_REG_PC = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            Z80A.Z80A_REG_SP = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            Z80A.Z80A_REG_IX = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            Z80A.Z80A_REG_IY = Z80A.goGetIntHLToLng(bh, bl)
            Z80A.Z80A_REG_A = br.ReadByte()
            Z80A.Z80A_REG_F = br.ReadByte()
            Z80A.Z80A_REG_B = br.ReadByte()
            Z80A.Z80A_REG_C = br.ReadByte()
            Z80A.Z80A_REG_D = br.ReadByte()
            Z80A.Z80A_REG_E = br.ReadByte()
            Z80A.Z80A_REG_H = br.ReadByte()
            Z80A.Z80A_REG_L = br.ReadByte()
            Z80A.Z80A_REG_A2 = br.ReadByte()
            Z80A.Z80A_REG_F2 = br.ReadByte()
            Z80A.Z80A_REG_B2 = br.ReadByte()
            Z80A.Z80A_REG_C2 = br.ReadByte()
            Z80A.Z80A_REG_D2 = br.ReadByte()
            Z80A.Z80A_REG_E2 = br.ReadByte()
            Z80A.Z80A_REG_H2 = br.ReadByte()
            Z80A.Z80A_REG_L2 = br.ReadByte()
            Z80A.Z80A_REG_I = br.ReadByte()
            Z80A.Z80A_REG_R = br.ReadByte()
            Z80A.Z80A_REG_IFF1 = br.ReadByte()
            Z80A.Z80A_REG_IFF2 = br.ReadByte()

            'INT
            INT.Gi_MSX_Interrupt = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            INT.Go_MSX_InterruptBack = Z80A.goGetIntHLToLng(bh, bl)
            INT.Z80A_INT_MODE = br.ReadByte()
            INT.Z80A_HALT = br.ReadByte()

            'MEM
            For i = 0 To 4 - 1
                For j = 0 To 65536 - 1
                    MEM.MSX_MEM(i, j) = br.ReadByte()
                Next j
            Next i
            MEM.Gi_MEM_PAGE0 = br.ReadByte()
            MEM.Gi_MEM_PAGE1 = br.ReadByte()
            MEM.Gi_MEM_PAGE2 = br.ReadByte()
            MEM.Gi_MEM_PAGE3 = br.ReadByte()
            MEM.Gi_MEM_EXT_PAGE0 = br.ReadByte()
            MEM.Gi_MEM_EXT_PAGE1 = br.ReadByte()
            MEM.Gi_MEM_EXT_PAGE2 = br.ReadByte()
            MEM.Gi_MEM_EXT_PAGE3 = br.ReadByte()
            For i = 0 To 4194304 - 1
                MEM.MSX_ROM(i) = br.ReadByte()
            Next i
            MEM.Gi_Big32K_ROM = br.ReadByte()
            For i = 0 To 4194304 - 1
                MEM.MSX_RAM(i) = br.ReadByte()
            Next i
            MEM.Gi_RAM_PAGE0 = br.ReadByte()
            MEM.Gi_RAM_PAGE1 = br.ReadByte()
            MEM.Gi_RAM_PAGE2 = br.ReadByte()
            MEM.Gi_RAM_PAGE3 = br.ReadByte()

            'IO
            For i = 0 To 256 - 1
                IO.MSX_PORT(i) = br.ReadByte()
            Next i
            For i = 0 To 4 - 1
                For j = 0 To 16 - 1
                    IO.MSX_CLOCK_REG(i, j) = br.ReadByte()
                Next j
            Next i
            IO.Gi_MSX_PortWrite = br.ReadByte()

            'PPI
            PPI.MSX_PPI_REG_B = br.ReadByte()
            PPI.MSX_PPI_REG_C_KSO = br.ReadByte()
            PPI.MSX_PPI_REG_C_KCL = br.ReadByte()
            PPI.MSX_PPI_REG_C_CWT = br.ReadByte()
            PPI.MSX_PPI_REG_C_CMT = br.ReadByte()
            PPI.MSX_PPI_REG_C_KMT = br.ReadByte()

            'VDT
            For i = 0 To 131072 - 1
                VDT.MSX_VRAM(i) = br.ReadByte()
            Next i
            For i = 0 To 47 - 1
                VDT.MSX_VDT_REG(i) = br.ReadByte()
            Next i
            VDT.MSX_VDT_REG_IE1 = br.ReadByte()
            VDT.MSX_VDT_REG_EV = br.ReadByte()
            VDT.MSX_VDT_REG_16K = br.ReadByte()
            VDT.MSX_VDT_REG_ON = br.ReadByte()
            VDT.MSX_VDT_REG_IE0 = br.ReadByte()
            VDT.MSX_VDT_REG_SZ = br.ReadByte()
            VDT.MSX_VDT_REG_SM = br.ReadByte()
            VDT.MSX_VDT_REG_TP = br.ReadByte()
            VDT.MSX_VDT_REG_SPD = br.ReadByte()
            VDT.MSX_VDT_REG_LN = br.ReadByte()
            VDT.MSX_VDT_REG_IL = br.ReadByte()
            VDT.MSX_VDT_REG_EO = br.ReadByte()
            For i = 0 To 131072 - 1
                VDT.MSX_VRAM_Buff(i) = br.ReadByte()
            Next i
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VRAM_Buff_Size = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VRAM_Buff_Count = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng(bh, bl)
            VDT.Gi_MSX_VDT_CMD_REG_Color = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_MXC = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_MXD = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_MXS = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_DIY = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_DIX = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_EQ = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_MAJ = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_CMD = br.ReadByte()
            VDT.MSX_VDT_CMD_REG_LO = br.ReadByte()
            VDT.MSX_VDT_ST_REG_FF = br.ReadByte()
            VDT.Gi_MSX_VDT_ST_REG_FF = br.ReadByte()
            VDT.MSX_VDT_ST_REG_5S = br.ReadByte()
            VDT.MSX_VDT_ST_REG_C = br.ReadByte()
            VDT.MSX_VDT_ST_REG_5SN = br.ReadByte()
            VDT.MSX_VDT_ST_REG_FL = br.ReadByte()
            VDT.MSX_VDT_ST_REG_LPS = br.ReadByte()
            VDT.MSX_VDT_ST_REG_ID = br.ReadByte()
            VDT.MSX_VDT_ST_REG_FH = br.ReadByte()
            VDT.MSX_VDT_ST_REG_TR = br.ReadByte()
            VDT.MSX_VDT_ST_REG_VR = br.ReadByte()
            VDT.MSX_VDT_ST_REG_HR = br.ReadByte()
            VDT.MSX_VDT_ST_REG_BD = br.ReadByte()
            VDT.MSX_VDT_ST_REG_EO = br.ReadByte()
            VDT.MSX_VDT_ST_REG_CE = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_ST_REG_Column = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_ST_REG_Row = Z80A.goGetIntHLToLng(bh, bl)
            VDT.Gi_MSX_VDT_ST_REG_Color = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VDT_ST_REG_BX = Z80A.goGetIntHLToLng(bh, bl)
            VDT.Gi_MSX_SCREEN_MODE = br.ReadByte()
            VDT.Gi_MSX_VRAM_IO = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            VDT.Go_MSX_VRAM_ADDRESS = Z80A.goGetIntHLToLng(bh, bl)
            VDT.Gi_MSX_VRAM_Flg = br.ReadByte()
            VDT.Gi_MSX2_VRAM_Flg = br.ReadByte()
            For i = 0 To 16 - 1
                VDT.MSX_VDT_REG_PAL_Red(i) = br.ReadByte()
                VDT.MSX_VDT_REG_PAL_Green(i) = br.ReadByte()
                VDT.MSX_VDT_REG_PAL_Blue(i) = br.ReadByte()
                VDT.MSX_COLOR_PALETTE(i, VDT.MSX_VDT_REG_PAL_Red(i), VDT.MSX_VDT_REG_PAL_Green(i), VDT.MSX_VDT_REG_PAL_Blue(i))
            Next i

            'PSG
            For i = 0 To 16 - 1
                PSG.MSX_PSG_REG(i) = br.ReadByte()
            Next i
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Go_MSX_PSG_TONE_A = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MSX_PSG_VEV_A = br.ReadByte()
            PSG.Gi_MSX_PSG_VOL_A = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Go_MSX_PSG_TONE_B = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MSX_PSG_VEV_B = br.ReadByte()
            PSG.Gi_MSX_PSG_VOL_B = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Go_MSX_PSG_TONE_C = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MSX_PSG_VEV_C = br.ReadByte()
            PSG.Gi_MSX_PSG_VOL_C = br.ReadByte()
            PSG.Go_MSX_PSG_NOISE = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Go_MSX_PSG_TONE_EV = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MSX_PSG_PATN_EV = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_A = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_B = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_C = br.ReadByte()
            PSG.Gi_MSX_PSG_N_ON_A = br.ReadByte()
            PSG.Gi_MSX_PSG_N_ON_B = br.ReadByte()
            PSG.Gi_MSX_PSG_N_ON_C = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_A = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_B = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_C = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_NS = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MIDI_VOL_A = br.ReadByte()
            PSG.Gi_MIDI_VOL_B = br.ReadByte()
            PSG.Gi_MIDI_VOL_C = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_A_Bak = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_B_Bak = br.ReadByte()
            PSG.Gi_MSX_PSG_T_ON_C_Bak = br.ReadByte()
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_A_Bak = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_B_Bak = Z80A.goGetIntHLToLng(bh, bl)
            bl = br.ReadByte()
            bh = br.ReadByte()
            PSG.Gi_MIDI_TON_C_Bak = Z80A.goGetIntHLToLng(bh, bl)
            PSG.Gi_MIDI_VEV_A_Bak = br.ReadByte()
            PSG.Gi_MIDI_VEV_B_Bak = br.ReadByte()
            PSG.Gi_MIDI_VEV_C_Bak = br.ReadByte()
            PSG.Gi_MIDI_VOL_A_Bak = br.ReadByte()
            PSG.Gi_MIDI_VOL_B_Bak = br.ReadByte()
            PSG.Gi_MIDI_VOL_C_Bak = br.ReadByte()

            br.Close()

        End Sub
    End Module

End Namespace
