﻿Namespace TBL

    Module msxTBL

        'PE/PO테이블
        Public Gi_P_Table(256 - 1) As Integer '-128~127 (0~255)
        'BIT테이블
        Public Gi_B_Table(8 - 1) As Integer '0~255 (0~7)
        Public Gi_NB_Table(8 - 1) As Integer '0~255 (0~7)

        'Text테이블
        Public Gi_T_TableY(960 - 1) As Integer
        Public Gi_T_TableX(960 - 1) As Integer
        Public Go_T_VRamTable(960 - 1) As Integer
        'Text2테이블
        Public Gi_T2_TableY(2160 - 1) As Integer
        Public Gi_T2_TableX(2160 - 1) As Integer
        Public Go_T2_VRamTable(2160 - 1) As Integer
        'Graphic테이블
        Public Gi_G_TableY(768 - 1) As Integer
        Public Gi_G_TableX(768 - 1) As Integer
        Public Go_G_VRamTable(768 - 1) As Integer
        'Sprite-Test
        Public Gi_S_Table8(1024 - 1) As Integer
        Public Gi_S_TableY(1024 - 1) As Integer
        Public Gi_S_TableX(1024 - 1) As Integer
        Public Go_S_VRamTable(1024 - 1) As Integer
        'Color테이블
        Public Gi_MSX_ForeColors(256 - 1) As Integer
        Public Gi_MSX_BackColors(256 - 1) As Integer
        Public Gi_Spr_TableStart(256 - 1) As Integer 'Sprite
        Public Gi_Col_Pos2(512 - 1) As Integer '16색상위치(0~1)
        Public Gi_Col_Pos4(512 - 1) As Integer '04색상위치(0~4)
        'Mul,Div테이블
        Public Gi_M_Table2(256 - 1) As Integer
        Public Gi_M_Table4(256 - 1) As Integer
        Public Gi_M_Table8(256 - 1) As Integer
        Public Gi_M_Table16(256 - 1) As Integer
        Public Gi_M_Table32(256 - 1) As Integer
        Public Gi_M_Table36(256 - 1) As Integer
        Public Gi_M_Table64(256 - 1) As Integer
        Public Go_M_Table128(1024 - 1) As Integer
        Public Go_M_Table256(1024 - 1) As Integer
        Public Go_M_Table512(1024 - 1) As Integer
        Public Go_M_Table1024(256 - 1) As Integer
        Public Go_M_Table2048(256 - 1) As Integer
        Public Go_M_Table2560(256 - 1) As Integer
        Public Go_M_Table4096(256 - 1) As Integer
        Public Go_M_Table8192(256 - 1) As Integer
        Public Go_M_Table16384(256 - 1) As Integer
        Public Go_M_Table32768(256 - 1) As Integer
        Public Go_M_Table65536(256 - 1) As Integer
        Public Gi_D_Table2(512 - 1) As Integer
        Public Gi_D_Table4(512 - 1) As Integer
        Public Gi_D_Table8(256 - 1) As Integer
        Public Gi_D_Table16(256 - 1) As Integer
        Public Gi_D_Table32(768 - 1) As Integer
        Public Gi_D_Table64(256 - 1) As Integer
        Public Gi_D_Table128(256 - 1) As Integer
        Public Gi_D_Table256(65536 - 1) As Integer

        Public Sub MSX_INIT_P_Table()

            Dim P As Integer, i As Integer

            For i = 0 To 255
                P = 0
                If ((i And 128) <> 0) Then P += 1
                If ((i And 64) <> 0) Then P += 1
                If ((i And 32) <> 0) Then P += 1
                If ((i And 16) <> 0) Then P += 1
                If ((i And 8) <> 0) Then P += 1
                If ((i And 4) <> 0) Then P += 1
                If ((i And 2) <> 0) Then P += 1
                If ((i And 1) <> 0) Then P += 1
                If ((P = 0) Or (P = 2) Or (P = 4) Or (P = 6) Or (P = 8)) Then
                    Gi_P_Table(i) = 1
                Else
                    Gi_P_Table(i) = 0
                End If
            Next i

        End Sub

        Public Sub MSX_INIT_B_Table()

            Gi_B_Table(0) = 1
            Gi_B_Table(1) = 2
            Gi_B_Table(2) = 4
            Gi_B_Table(3) = 8
            Gi_B_Table(4) = 16
            Gi_B_Table(5) = 32
            Gi_B_Table(6) = 64
            Gi_B_Table(7) = 128
            Gi_NB_Table(0) = &HFE '1111 1110
            Gi_NB_Table(1) = &HFD '1111 1101
            Gi_NB_Table(2) = &HFB '1111 1011
            Gi_NB_Table(3) = &HF7 '1111 0111
            Gi_NB_Table(4) = &HEF '1110 1111
            Gi_NB_Table(5) = &HDF '1101 1111
            Gi_NB_Table(6) = &HBF '1011 1111
            Gi_NB_Table(7) = &H7F '0111 1111

        End Sub

        Public Sub MSX_INIT_MD_Table()

            Dim i As Integer

            For i = 0 To 959
                Gi_T_TableY(i) = FN.giInt(i / 40)
                Gi_T_TableX(i) = i - (Gi_T_TableY(i) * 40)
                If (MSX.GiCHAR = 0) Then
                    Go_T_VRamTable(i) = (Gi_T_TableY(i) * 2560) + (Gi_T_TableX(i) * 8) '8*8=64*40=2560, 8Dot
                Else
                    Go_T_VRamTable(i) = (Gi_T_TableY(i) * 1920) + (Gi_T_TableX(i) * 6) '8*6=48*40=1920, 8Dot
                End If
             Next i

            For i = 0 To 2159
                Gi_T2_TableY(i) = FN.giInt(i / 80)
                Gi_T2_TableX(i) = i - (Gi_T2_TableY(i) * 80)
                If (MSX.GiCHAR = 0) Then
                    Go_T2_VRamTable(i) = (Gi_T2_TableY(i) * 5120) + (Gi_T2_TableX(i) * 8) '8*8=64*80=5120, 8Dot
                Else
                    Go_T2_VRamTable(i) = (Gi_T2_TableY(i) * 3840) + (Gi_T2_TableX(i) * 6) '8*6=48*80=3840, 8Dot
                End If
             Next i

            For i = 0 To 767
                Gi_G_TableY(i) = FN.giInt(i / 32)
                Gi_G_TableX(i) = i - (Gi_G_TableY(i) * 32)
                Go_G_VRamTable(i) = (Gi_G_TableY(i) * 2048) + (Gi_G_TableX(i) * 8) '8*8=64*32=2048, 8Dot
            Next i

            For i = 0 To 1023
                Gi_S_Table8(i) = i * 8
                Gi_S_TableY(i) = FN.giInt(i / 32)
                Gi_S_TableX(i) = i - (Gi_S_TableY(i) * 32)
                Go_S_VRamTable(i) = (Gi_S_TableY(i) * 2048) + (Gi_S_TableX(i) * 8)
            Next i

            For i = 0 To 255
                Gi_MSX_ForeColors(i) = FN.giInt((i And &HF0) / 16)
                Gi_MSX_BackColors(i) = (i And &HF)
                Gi_Spr_TableStart(i) = FN.giInt(i / 4) * 4
                Gi_M_Table2(i) = i * 2
                Gi_M_Table4(i) = i * 4
                Gi_M_Table8(i) = i * 8
                Gi_M_Table16(i) = i * 16
                Gi_M_Table32(i) = i * 32
                Gi_M_Table36(i) = i * 36
                Gi_M_Table64(i) = i * 64
                Go_M_Table512(i) = i * 512
                Go_M_Table1024(i) = i * 1024
                Go_M_Table2048(i) = i * 2048
                Go_M_Table2560(i) = i * 2560
                Go_M_Table4096(i) = i * 4096
                Go_M_Table8192(i) = i * 8192
                Go_M_Table16384(i) = i * 16384
                Go_M_Table32768(i) = i * 32768
                Go_M_Table65536(i) = i * 65536
                Gi_D_Table8(i) = FN.giInt(i / 8)
                Gi_D_Table16(i) = FN.giInt(i / 16)
                Gi_D_Table64(i) = FN.giInt(i / 64)
                Gi_D_Table128(i) = FN.giInt(i / 128)
            Next i

            For i = 0 To 511
                Gi_Col_Pos2(i) = i Mod 2
                Gi_Col_Pos4(i) = i Mod 4
                Gi_D_Table2(i) = FN.giInt(i / 2)
                Gi_D_Table4(i) = FN.giInt(i / 4)
            Next i

            For i = 0 To 767
                Gi_D_Table32(i) = FN.giInt(i / 32)
            Next i

            For i = 0 To 1023
                Go_M_Table128(i) = i * 128
                Go_M_Table256(i) = i * 256
            Next i

            For i = 0 To 65535
                Gi_D_Table256(i) = FN.giInt(Z80A.goGetLngToLng(i And &HFF00) / 256)
            Next i

        End Sub
    End Module

End Namespace
