﻿Namespace VDT

    Module msxVDT

        'VRAM - MSX1(3FFFh(16383))16KB, MSX2(0~1FFFFh(131071))128KB
        Public MSX_VRAM(131072 - 1) As Integer '0~255 (0~16383 or 0~131071)

        Public MSX_VDT_REG(47 - 1) As Integer '0~255 (0~46)
        'MSX1, #00~#07
        '#00-모드레지스터#0, Graphics Mode(7,1)
        '    '0'
        '     DG : Digitize mode: sets the color bus to the input or output mode
        '     IE2 : Enables interrupts from Light pen
        '     IE1 : Enabled interrupt from horizontal retrace
        '     M5 : Screen mode flag
        '     M4 : Screen mode flag
        '     M3 : Screen mode flag
        '     '0'
        Public MSX_VDT_REG_IE1 As Integer ' bit - Enables interrupt from horizontal retrace
        Public MSX_VDT_REG_EV As Integer  ' bit - EXT VID
        '#01-모드레지스터#1, VRAM Size(1,1:4?16K), Enable(2,1/1:표시), IE(3,1), Graphics Mode(4,2), Spr Size(7,1), Spr Mag(8,1)
        '    '0'
        '    BL : Blank screen: (1:Display Enable, 0:Disable)
        '    IE0 : Enables interrupt from vertical retrace
        '    M1 : Screen mode flag
        '    M2 : Screen mode flag
        '    '0'
        '    SI : Sprite size: (1:16*16,0:8*8)
        '    MAG : Sprite enlarging: (1:Double size)
        Public MSX_VDT_REG_16K As Integer '7 bit - VRAM 4K/16K
        Public MSX_VDT_REG_ON As Integer  '6 bit - 1:화면표시 / BL
        Public MSX_VDT_REG_IE0 As Integer '5 bit - Enables interrupt from vertical retrace
        Public MSX_VDT_REG_SZ As Integer  '1 bit - SPR SIZE (0:8*8,1:16*16) / SI
        Public MSX_VDT_REG_SM As Integer  '0 bit - SPR MAG (0:기본,1:가로세로2배확대) / MAG
        '#02-Pattern Name Table (화면문자0~255) - 0A16~A10지정, A9~A0은0
        '#03-Color Table (4bit:bit1색+4bit:bit0색)
        '#04-Pattern Generate Table (폰트8(우측2bit표시안함)*0~255) - 00A16~A11지정, A10~A0은0
        '#05-Sprite Attribute Table
        '#06-Sprite Pattern Table
        '#07-Backdrop Color (4bit:전경색+4bit:배경색)
        'MSX2, #08~#23
        '#08-모드레지스터#2
        '    MS : Mouse
        '    LP : Light pen
        '    TP : Sets the color of code 0 to the color of the palette
        '    CB : Color bus
        '    VR : Selects the type and organization of VRAM
        '    '0'
        '    SPD : Sprite disable
        '    BW : Black/White
        Public MSX_VDT_REG_TP As Integer  '5 bit - MSX2, Sets Color 0
        Public MSX_VDT_REG_SPD As Integer '1 bit - MSX2, 1:소프라이트 비표시
        '#09-모드레지스터#3
        '    LN : Line: (1:212, 0:192)
        '    '0'
        '    S1 : Selects simultaneous mode
        '    S2 : Selects simultaneous mode
        '    IL : Interlace (0:1매의화면만표,1:2매의화면의교대표시)
        '    EO : Event/Odd screens (0:논인터레이스모드(보통모드),1:인터레이스모드)
        '    *NT : RGB output only: (1:PAL mode,0:NTSC mode)
        '    DC : Dot clock
        Public MSX_VDT_REG_LN As Integer '7 bit - MSX2, Graphic Line - 0:192,1:212
        Public MSX_VDT_REG_IL As Integer '3 bit
        Public MSX_VDT_REG_EO As Integer '2 bit
        '#10-Color Table (High)
        '#11-소프라이트으트리뷰트테이블(High)
        '#12-텍스트 블링크시 문자색
        '#13-짝수페이지표시Even/6초(7~4),홀수페이지표시Odd/6초(3~0)
        '#14-VRAM의 어드레스 설정 (상위:3비트)
        '#15-S#n의 간접지정
        '#16-P#n의 간접지정
        '#17-R#n의 간접지정
        '#18-화면위치의 보정
        '#19-주사선번호, CRT가 특별한 주사선의 표시를 끝낸 순간에 가로채기를 발생시킴 (IE1=1일경우)
        '#20-컬러버스트신호1
        '#21-컬러버스트신호2
        '#22-컬러버스트신호3
        '#23-화면의 표시개시 라인을 설정 (화면의 세로방향 스크롤)

        'VRAM - MSX2, Command
        Public MSX_VRAM_Buff(131072 - 1) As Integer '0~255 ('0~1FFFFh(131071))
        Public Go_MSX_VRAM_Buff_Size As Integer
        Public Go_MSX_VRAM_Buff_Count As Integer

        'VDT Command 레지스터 - Write Only
        'MSX2, #32~#46(VDT커맨드실행시사용)
        '#32-SX: Source X - 7~0
        '#33-SX:              8
        Public Go_MSX_VDT_CMD_REG_SX As Integer
        '#34-SY: Source Y - 7~0
        '#35-SY:            9,8
        Public Go_MSX_VDT_CMD_REG_SY As Integer
        '#36-DX: Destination X - 7~0
        '#37-DX:                   8
        Public Go_MSX_VDT_CMD_REG_DX As Integer
        '#38-DY: Destination Y - 7~0
        '#39-DY:                 9,8
        Public Go_MSX_VDT_CMD_REG_DY As Integer
        '#40-NX: Number of dots in X-axis - 7~0
        '#41-NX:                              8
        Public Go_MSX_VDT_CMD_REG_NX As Integer
        Public Go_MSX_VDT_CMD_REG_Mjg As Integer
        '#42-NY: Number of dots in Y=axis - 7~0
        '#43-NY:                            9,8
        Public Go_MSX_VDT_CMD_REG_NY As Integer
        Public Go_MSX_VDT_CMD_REG_Min As Integer
        '#44-Color: X=2N(7~4), X=2N+1(3~0)                           - G4,G6 (N=0..127)
        '           X=4N(7~6), X=4N+1(5~4), X=4N+2(3~2), X=4N+3(1~0) - G5 (N=0..127)
        '           X=N(One dot)(7~0)                                - G7
        Public Gi_MSX_VDT_CMD_REG_Color As Integer
        '#45-뱅크변환(Bit6-0:VRAM,1:확장RAM(사용안함))
        '    Select destination memory and direction from base coordinate
        Public MSX_VDT_CMD_REG_MXC As Integer 'Bit6 - MSX2, 0:VRAM, 1:확장RAM
        '    MXD - Bit5-0:VRAM,1:ExpRam - Destination select
        Public MSX_VDT_CMD_REG_MXD As Integer 'Bit5
        Public MSX_VDT_CMD_REG_MXS As Integer 'Bit4
        '    DIY - Bit3-0:Down,1:Up     - Y Transfer direction
        Public MSX_VDT_CMD_REG_DIY As Integer 'Bit3
        '    DIX - Bit2-0:Right,1:Left  - X Transfer direction
        Public MSX_VDT_CMD_REG_DIX As Integer 'Bit2
        Public MSX_VDT_CMD_REG_EQ As Integer  'Bit1
        Public MSX_VDT_CMD_REG_MAJ As Integer 'Bit0 - Line 긴변선택
        '#46-Execute the command (7~0:11110000)
        Public MSX_VDT_CMD_REG_CMD As Integer 'Bit7~4
        Public MSX_VDT_CMD_REG_LO As Integer  'Bit3~0

        'public  byte() MSX_VDT_ST_REG = new byte(10); '0~255 (0~9)
        'MSX1, #0
        'MSX_VDT_REG_ST - 가로채기정보
        Public MSX_VDT_ST_REG_FF As Integer  '7 bit - End of the raster scan of the last line of the active display, 1초에60번발생(60Hz), 1초에50번발행(50Hz)
        Public Gi_MSX_VDT_ST_REG_FF As Integer
        Public MSX_VDT_ST_REG_5S As Integer  '6 bit - 소프라이트 1줄에 5개이상 표시로, 5번째이상 표시안되는 상태
        Public MSX_VDT_ST_REG_C As Integer   '5 bit - 소프라이트 충돌
        Public MSX_VDT_ST_REG_5SN As Integer '4~0 bit - 표시안되는 첫번째 소프라이트 번호
        'MSX2, #1~#9
        'MSX_VDT_REG_ST1 - 가로채기정보
        Public MSX_VDT_ST_REG_FL As Integer  ''7 bit - Light Pen
        Public MSX_VDT_ST_REG_LPS As Integer '6 bit - Light Pen Button
        Public MSX_VDT_ST_REG_ID As Integer  '5~1 bit - VDT Chip
        Public MSX_VDT_ST_REG_FH As Integer  '0 bit - Horizontal scan interrup flag
        'MSX_VDT_REG_ST2
        Public MSX_VDT_ST_REG_TR As Integer  '7 bit - Transfer ready flag
        Public MSX_VDT_ST_REG_VR As Integer  '6 bit - Vertical retrace flag
        Public MSX_VDT_ST_REG_HR As Integer  '5 bit - Horizontal retrace flag
        Public MSX_VDT_ST_REG_BD As Integer  '4 bit - Color detect flag
        Public MSX_VDT_ST_REG_EO As Integer  '1 bit - Display field flag
        Public MSX_VDT_ST_REG_CE As Integer  '0 bit - Command execution flag
        'MSX_VDT_REG_ST3 - Column register low
        'MSX_VDT_REG_ST4 - Column register high (1111111 8)
        Public Go_MSX_VDT_ST_REG_Column As Integer
        'MSX_VDT_REG_ST5 - Row register row
        'MSX_VDT_REG_ST6 - Row register high (111111 9,8)
        Public Go_MSX_VDT_ST_REG_Row As Integer
        'MSX_VDT_REG_ST7 - Color register
        Public Gi_MSX_VDT_ST_REG_Color As Integer
        'MSX_VDT_REG_ST8 - Coded color X register low
        'MSX_VDT_REG_ST9 - Coded color Y register high (1111111 8)
        Public Go_MSX_VDT_ST_REG_BX As Integer

        Public Gi_MSX_Screen_Out As Integer '1:화면출력필요
        Public Gi_MSX_ForeColor As Integer
        Public Gi_MSX_BackColor As Integer
        Public Gi_MSX_OutColor As Integer
        Public Gi_MSX_ForeColor_Blink As Integer
        Public Gi_MSX_BackColor_Blink As Integer
        Public Gi_MSX_Blink_Time_Bl As Integer
        Public Gi_MSX_Blink_Time_Co As Integer

        Public Gi_MSX_SCREEN_MODE As Integer '0:TEXT, 1:GRAPHIC_1, 2:GRAPHIC_2, 3:MULTI_COLOR, 10:TEXT 80
        Public Gi_MSX_Screen_Mode_Prv As Integer
        Public Gi_MSX_VDT_Reg_LN_Prv As Integer
        Public Gi_MSX_Graphic_Page As Integer

        Public Gi_MSX_VRAM_IO As Integer '1:Read,2:Write
        Public Go_MSX_VRAM_ADDRESS As Integer
        Public Gi_MSX_VRAM_Flg As Integer
        Public Gi_MSX2_VRAM_Flg As Integer

        Public Go_MSX_SCR_CHAR_ADDR As Integer
        Public Go_MSX_SCR_COLR_ADDR As Integer
        Public Go_MSX_SCR_FONT_ADDR As Integer
        Public Go_MSX_SCR_BLNK_ADDR As Integer 'MSX2 - Text 80 Blink
        Public Go_MSX_SPR_ATRB_ADDR As Integer
        Public Go_MSX_SPR_FONT_ADDR As Integer
        Public Go_MSX_SPR_COLR_ADDR As Integer 'MSX2 - Screen 8 Sprite Color

        'VDT Palette 레지스터 - MSX1(기본설정), MSX2(팔레트레지스터로지정)
        Public MSX_VDT_REG_PAL_Red(16 - 1) As Integer '0~255 (0~15)
        Public MSX_VDT_REG_PAL_Green(16 - 1) As Integer '0~255 (0~15)
        Public MSX_VDT_REG_PAL_Blue(16 - 1) As Integer '0~255 (0~15)
        Public Go_MSX_Color(16 - 1) As UInteger 'BitMap(PictureBox) 표시용
        Public Go_MSX_Color_RGB(16 - 1) As UInteger '화면표시용
        Public Go_MSX_Color_G7(16 - 1) As UInteger 'Screen 8, Graphic7용 소프라이트 고정색상
        Public Go_MSX_Color_G7_RGB(16 - 1) As UInteger '화면표시용
        Public Gc_MSX_Color(16 - 1) As Color 'BitMap(PictureBox) 표시용
        Public Gc_MSX_Color_RGB(16 - 1) As Color '화면표시용
        Public Gc_MSX_Color_G7(16 - 1) As Color 'Screen 8, Graphic7용 소프라이트 고정색상
        Public Gc_MSX_Color_G7_RGB(16 - 1) As Color '화면표시용

        Public Sub MSX_INIT_VDT()

            Dim i As Integer

            For i = 0 To 131071
                MSX_VRAM(i) = 0
            Next i

            For i = 0 To 46
                MSX_VDT_REG(i) = 0
            Next i

            Gi_MSX_Screen_Out = 0

            Gi_MSX_SCREEN_MODE = 0
            MSX_VDT_REG_LN = 0
            Gi_MSX_Screen_Mode_Prv = -1
            Gi_MSX_VDT_Reg_LN_Prv = 0
            Gi_MSX_Graphic_Page = 0

            MSX_VDT_REG_IE1 = 0
            MSX_VDT_REG_EV = 0
            MSX_VDT_REG_16K = 0
            MSX_VDT_REG_ON = 1
            MSX_VDT_REG_IE0 = 0
            MSX_VDT_REG_SZ = 0
            MSX_VDT_REG_SM = 0
            MSX_VDT_REG_TP = 0
            MSX_VDT_REG_SPD = 0
            MSX_VDT_REG_IL = 0
            MSX_VDT_REG_EO = 0

            for  i = 0 to 131071
                MSX_VRAM_Buff(i) = 0
            Next i
            Go_MSX_VRAM_Buff_Size = 0
            Go_MSX_VRAM_Buff_Count = 0

            Go_MSX_VDT_CMD_REG_SX = 0
            Go_MSX_VDT_CMD_REG_SY = 0
            Go_MSX_VDT_CMD_REG_DX = 0
            Go_MSX_VDT_CMD_REG_DY = 0
            Go_MSX_VDT_CMD_REG_NX = 0
            Go_MSX_VDT_CMD_REG_NY = 0
            Go_MSX_VDT_CMD_REG_Mjg = 0
            Go_MSX_VDT_CMD_REG_Min = 0
            Gi_MSX_VDT_CMD_REG_Color = 0
            MSX_VDT_CMD_REG_MXC = 0
            MSX_VDT_CMD_REG_MXD = 0
            MSX_VDT_CMD_REG_MXS = 0
            MSX_VDT_CMD_REG_DIY = 0
            MSX_VDT_CMD_REG_DIX = 0
            MSX_VDT_CMD_REG_EQ = 0
            MSX_VDT_CMD_REG_MAJ = 0
            MSX_VDT_CMD_REG_CMD = 0
            MSX_VDT_CMD_REG_LO = 0

            Go_MSX_VDT_CMD_REG_SX = 0
            Go_MSX_VDT_CMD_REG_SY = 0
            Go_MSX_VDT_CMD_REG_DX = 0
            Go_MSX_VDT_CMD_REG_DY = 0
            Go_MSX_VDT_CMD_REG_NX = 0
            Go_MSX_VDT_CMD_REG_NY = 0
            Go_MSX_VDT_CMD_REG_Mjg = 0
            Go_MSX_VDT_CMD_REG_Min = 0
            Gi_MSX_VDT_CMD_REG_Color = 0
            MSX_VDT_CMD_REG_MXC = 0
            MSX_VDT_CMD_REG_MXD = 0
            MSX_VDT_CMD_REG_MXS = 0
            MSX_VDT_CMD_REG_DIY = 0
            MSX_VDT_CMD_REG_DIX = 0
            MSX_VDT_CMD_REG_EQ = 0
            MSX_VDT_CMD_REG_MAJ = 0
            MSX_VDT_CMD_REG_CMD = 0
            MSX_VDT_CMD_REG_LO = 0

            MSX_VDT_ST_REG_FF = 0
            Gi_MSX_VDT_ST_REG_FF = 0
            MSX_VDT_ST_REG_5S = 0
            MSX_VDT_ST_REG_C = 0
            MSX_VDT_ST_REG_5SN = 0
            MSX_VDT_ST_REG_FL = 0
            MSX_VDT_ST_REG_LPS = 0
            MSX_VDT_ST_REG_ID = 0
            MSX_VDT_ST_REG_FH = 0
            MSX_VDT_ST_REG_TR = 0
            MSX_VDT_ST_REG_VR = 0
            MSX_VDT_ST_REG_HR = 0
            MSX_VDT_ST_REG_BD = 0
            MSX_VDT_ST_REG_EO = 0
            MSX_VDT_ST_REG_CE = 0
            Go_MSX_VDT_ST_REG_Column = 0
            Go_MSX_VDT_ST_REG_Row = 0
            Gi_MSX_VDT_ST_REG_Color = 0
            Go_MSX_VDT_ST_REG_BX = 0

            Gi_MSX_VRAM_IO = 0
            Go_MSX_VRAM_ADDRESS = 0
            Gi_MSX_VRAM_Flg = 0
            Gi_MSX2_VRAM_Flg = 0

            Go_MSX_SCR_CHAR_ADDR = 0
            Go_MSX_SCR_COLR_ADDR = 0
            Go_MSX_SCR_FONT_ADDR = 0
            Go_MSX_SCR_BLNK_ADDR = 0
            Go_MSX_SPR_ATRB_ADDR = 0
            Go_MSX_SPR_FONT_ADDR = 0
            Go_MSX_SPR_COLR_ADDR = 0

            for  i = 0 to 15
                MSX_VDT_REG_PAL_Red(i) = 0
                MSX_VDT_REG_PAL_Green(i) = 0
                MSX_VDT_REG_PAL_Blue(i) = 0
                Go_MSX_Color(i) = 0
                Go_MSX_Color_RGB(i) = 0
                Go_MSX_Color_G7(i) = 0
                Go_MSX_Color_G7_RGB(i) = 0
            Next i

        End Sub

        Public Sub MSX_SCREEN_MODE_SET()

            Dim M1 As Integer, M0 As Integer

            If (MSX.GiMSX2 = 0) Then 'MSX1
                M0 = TBL.Gi_D_Table2(MSX_VDT_REG(0) And 2) 'R0(7,1)
            Else 'MSX2
                M0 = TBL.Gi_D_Table2(MSX_VDT_REG(0) And 14) 'R0(5,3)
            End If
            M1 = TBL.Gi_D_Table8(MSX_VDT_REG(1) And &H18) 'R1(4,2)
            If ((M1 = 2) And (M0 = 0)) Then Gi_MSX_SCREEN_MODE = 0 '10+000-TEXT - MSX1
            If ((M1 = 0) And (M0 = 0)) Then Gi_MSX_SCREEN_MODE = 1 '00+000-GRAPHIC_1 - MSX1
            If ((M1 = 0) And (M0 = 1)) Then Gi_MSX_SCREEN_MODE = 2 '00+001-GRAPHIC_2 - MSX1
            If ((M1 = 1) And (M0 = 0)) Then Gi_MSX_SCREEN_MODE = 3 '01+000-MULTI_COLOR - MSX1
            If ((M1 = 2) And (M0 = 2)) Then Gi_MSX_SCREEN_MODE = 10 '10+010-TEXT2 - MSX2
            If ((M1 = 0) And (M0 = 2)) Then Gi_MSX_SCREEN_MODE = 4 '00+010-GRAPHIC_3 - MSX2
            If ((M1 = 0) And (M0 = 3)) Then
                Gi_MSX_SCREEN_MODE = 5 '00+011-GRAPHIC_4 - MSX2
                Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 127) '0~3 * 8000h
            End If
            If ((M1 = 0) And (M0 = 4)) Then
                Gi_MSX_SCREEN_MODE = 6 '00+100-GRAPHIC_5 - MSX2
                Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 127) '0~3 * 8000h
            End If
            If ((M1 = 0) And (M0 = 5)) Then
                Gi_MSX_SCREEN_MODE = 7 '00+101-GRAPHIC_6 - MSX2
                Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 63) '0~1 * 10000h
            End If
            If ((M1 = 0) And (M0 = 7)) Then
                Gi_MSX_SCREEN_MODE = 8 '00+111-GRAPHIC_7 - MSX2
                Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 63) '0~1 * 10000h
            End If
            MSX_VDT_REG_EV = (MSX_VDT_REG(0) And 1) 'R0(8,1), EXT VID
            If (MSX.GiMSX2 = 1) Then 'MSX2
                MSX_VDT_REG_IE1 = IIf((MSX_VDT_REG(0) And 16) = 0, 0, 1)
            End If
            MSX_VDT_REG_16K = IIf((MSX_VDT_REG(1) And 128) = 0, 0, 1) 'R1(1,1), 4/16K
            MSX_VDT_REG_ON = IIf((MSX_VDT_REG(1) And 64) = 0, 0, 1)   'R1(2,1), 1:화면표시
            MSX_VDT_REG_IE0 = IIf((MSX_VDT_REG(1) And 32) = 0, 0, 1)  'R1(3,1), IE
            MSX_VDT_REG_SZ = IIf((MSX_VDT_REG(1) And 2) = 0, 0, 1)    'R1(7,1), SPR SIZE
            MSX_VDT_REG_SM = (MSX_VDT_REG(1) And 1)                   'R1(8,1), SPR MAG

        End Sub

        Public Sub MSX_SCREEN_MODE_SET2()

            If (Gi_MSX_SCREEN_MODE = 5) Then Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 127) '0~3 * 8000h
            If (Gi_MSX_SCREEN_MODE = 6) Then Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 127) '0~3 * 8000h
            If (Gi_MSX_SCREEN_MODE = 7) Then Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 63) '0~1 * 10000h
            If (Gi_MSX_SCREEN_MODE = 8) Then Gi_MSX_Graphic_Page = TBL.Gi_D_Table32(MSX_VDT_REG(2) And 63) '0~1 * 10000h

        End Sub

        Public Sub MSX_SCREEN_MODE_SET8()

            MSX_VDT_REG_TP = IIf((MSX_VDT_REG(8) And 32) = 0, 0, 1)
            MSX_VDT_REG_SPD = IIf((MSX_VDT_REG(8) And 2) = 0, 0, 1)

        End Sub

        Public Sub MSX_SCREEN_MODE_SET9()

            MSX_VDT_REG_LN = IIf((MSX_VDT_REG(9) And 128) = 0, 0, 1) 'R9(1,1), 192/212
            MSX_VDT_REG_IL = IIf((MSX_VDT_REG(9) And 8) = 0, 0, 1)
            MSX_VDT_REG_EO = IIf((MSX_VDT_REG(9) And 4) = 0, 0, 1)

        End Sub

        Public Function MSX_VDT_REG_ST() As Integer

            Dim R As Integer
            '확인요망(부팅관련) ???
            If (MSX.Gi_MSX_VDT_ST_FF = 0) Then
                MSX_VDT_ST_REG_FF = 1
            Else
                If (Gi_MSX_VDT_ST_REG_FF = 0) Then '화변표시후Set, 1초에60번(60Hz)
                    Gi_MSX_VDT_ST_REG_FF = 1
                Else
                    Gi_MSX_VDT_ST_REG_FF = 0
                End If
                MSX_VDT_ST_REG_FF = Gi_MSX_VDT_ST_REG_FF
            End If
            R = 0
            R = (R + TBL.Go_M_Table128(MSX_VDT_ST_REG_FF))
            R = (R + TBL.Gi_M_Table64(MSX_VDT_ST_REG_5S))
            R = (R + TBL.Gi_M_Table32(MSX_VDT_ST_REG_C))
            R = (R + MSX_VDT_ST_REG_5SN)

            MSX_VDT_REG_ST = R

        End Function

        Public Function MSX_VDT_REG_ST1() As Integer

            Dim R As Integer

            R = 0
            R = (R + TBL.Go_M_Table128(MSX_VDT_ST_REG_FL))
            R = (R + TBL.Gi_M_Table64(MSX_VDT_ST_REG_LPS))
            R = (R + TBL.Gi_M_Table2(MSX_VDT_ST_REG_ID))
            R = (R + MSX_VDT_ST_REG_FH)

            MSX_VDT_REG_ST1 = R

        End Function

        Public Function MSX_VDT_REG_ST2() As Integer

            Dim R As Integer

            R = 0
            R = (R + TBL.Go_M_Table128(MSX_VDT_ST_REG_TR))
            R = (R + TBL.Gi_M_Table64(MSX_VDT_ST_REG_VR))
            R = (R + TBL.Gi_M_Table32(MSX_VDT_ST_REG_HR))
            R = (R + TBL.Gi_M_Table16(MSX_VDT_ST_REG_BD))
            R = (R + TBL.Gi_M_Table2(MSX_VDT_ST_REG_EO))
            R = (R + MSX_VDT_ST_REG_CE)
            '확인요망(부팅관련) ???
            'If MSX_VDT_REG_IE0 = 1 Then
            If (MSX_VDT_ST_REG_VR = 0) Then
                MSX_VDT_ST_REG_VR = 1
            Else
                MSX_VDT_ST_REG_VR = 0
            End If
            'If MSX_VDT_REG_IE0 = 1 Then
            If (MSX_VDT_ST_REG_HR = 0) Then
                MSX_VDT_ST_REG_HR = 1
            Else
                MSX_VDT_ST_REG_HR = 0
            End If

            MSX_VDT_REG_ST2 = R

        End Function

        Public Function MSX_VDT_REG_ST3() As Integer

            MSX_VDT_REG_ST3 = (Go_MSX_VDT_ST_REG_Column And 255)

        End Function

        Public Function MSX_VDT_REG_ST4() As Integer

            MSX_VDT_REG_ST4 = TBL.Gi_D_Table256(Go_MSX_VDT_ST_REG_Column)

        End Function

        Public Function MSX_VDT_REG_ST5() As Integer

            MSX_VDT_REG_ST5 = (Go_MSX_VDT_ST_REG_Row And 255)

        End Function

        Public Function MSX_VDT_REG_ST6() As Integer

            MSX_VDT_REG_ST6 = TBL.Gi_D_Table256(Go_MSX_VDT_ST_REG_Row)

        End Function

        Public Function MSX_VDT_REG_ST7() As Integer

            If ((MSX_VDT_ST_REG_CE = 1) And (MSX_VDT_ST_REG_TR = 1)) Then
                If (Go_MSX_VRAM_Buff_Count > 0) Then
                    Go_MSX_VRAM_Buff_Count = Go_MSX_VRAM_Buff_Count - 1
                    Gi_MSX_VDT_ST_REG_Color = MSX_VRAM_Buff(Go_MSX_VRAM_Buff_Count)
                    If (Go_MSX_VRAM_Buff_Count = 0) Then
                        MSX_VDT_ST_REG_CE = 0
                        MSX_VDT_ST_REG_TR = 0
                    End If
                Else
                    MSX_VDT_ST_REG_CE = 0
                    MSX_VDT_ST_REG_TR = 0
                End If
            End If

            MSX_VDT_REG_ST7 = Gi_MSX_VDT_ST_REG_Color

        End Function

        Public Function MSX_VDT_REG_ST8() As Integer

            MSX_VDT_REG_ST8 = (Go_MSX_VDT_ST_REG_BX And 255)

        End Function

        Public Function MSX_VDT_REG_ST9() As Integer

            MSX_VDT_REG_ST9 = TBL.Gi_D_Table256(Go_MSX_VDT_ST_REG_BX)

        End Function

        Public Sub MSX_VDT_CMD_REG_SX()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SX, MSX_VDT_REG(33), MSX_VDT_REG(32))

        End Sub

        Public Sub MSX_VDT_CMD_REG32_SET()

            Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng((MSX_VDT_REG(33) And 1), MSX_VDT_REG(32))

        End Sub

        Public Sub MSX_VDT_CMD_REG33_SET()

            Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng((MSX_VDT_REG(33) And 1), MSX_VDT_REG(32))

        End Sub

        Public Sub MSX_VDT_CMD_REG_SY()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SY, MSX_VDT_REG(35), MSX_VDT_REG(34))

        End Sub

        Public Sub MSX_VDT_CMD_REG34_SET()

            Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng((MSX_VDT_REG(35) And 3), MSX_VDT_REG(34))

        End Sub

        Public Sub MSX_VDT_CMD_REG35_SET()

            Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng((MSX_VDT_REG(35) And 3), MSX_VDT_REG(34))

        End Sub

        Public Sub MSX_VDT_CMD_REG_DX()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DX, MSX_VDT_REG(37), MSX_VDT_REG(36))

        End Sub

        Public Sub MSX_VDT_CMD_REG36_SET()

            Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng((MSX_VDT_REG(37) And 1), MSX_VDT_REG(36))

        End Sub

        Public Sub MSX_VDT_CMD_REG37_SET()

            Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng((MSX_VDT_REG(37) And 1), MSX_VDT_REG(36))

        End Sub

        Public Sub MSX_VDT_CMD_REG_DY()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DY, MSX_VDT_REG(39), MSX_VDT_REG(38))

        End Sub

        Public Sub MSX_VDT_CMD_REG38_SET()

            Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng((MSX_VDT_REG(39) And 3), MSX_VDT_REG(38))

        End Sub

        Public Sub MSX_VDT_CMD_REG39_SET()

            Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng((MSX_VDT_REG(39) And 3), MSX_VDT_REG(38))

        End Sub

        Public Sub MSX_VDT_CMD_REG_NX()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NX, MSX_VDT_REG(41), MSX_VDT_REG(40))

        End Sub

        Public Sub MSX_VDT_CMD_REG40_SET()

            Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng((MSX_VDT_REG(41) And 1), MSX_VDT_REG(40))
            Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng((MSX_VDT_REG(41) And 3), MSX_VDT_REG(40))

        End Sub

        Public Sub MSX_VDT_CMD_REG41_SET()

            Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng((MSX_VDT_REG(41) And 1), MSX_VDT_REG(40))
            Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng((MSX_VDT_REG(41) And 3), MSX_VDT_REG(40))

        End Sub

        Public Sub MSX_VDT_CMD_REG_NY()

            Call Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NY, MSX_VDT_REG(43), MSX_VDT_REG(42))

        End Sub

        Public Sub MSX_VDT_CMD_REG42_SET()

            Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng((MSX_VDT_REG(43) And 3), MSX_VDT_REG(42))
            Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng((MSX_VDT_REG(43) And 1), MSX_VDT_REG(42))

        End Sub

        Public Sub MSX_VDT_CMD_REG43_SET()

            Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng((MSX_VDT_REG(43) And 3), MSX_VDT_REG(42))
            Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng((MSX_VDT_REG(43) And 1), MSX_VDT_REG(42))

        End Sub

        Public Sub MSX_VDT_CMD_REG_CLR()

            MSX_VDT_REG(44) = Gi_MSX_VDT_CMD_REG_Color

        End Sub

        Public Sub MSX_VDT_CMD_REG44_SET()

            Gi_MSX_VDT_CMD_REG_Color = MSX_VDT_REG(44)

            If (MSX_VDT_ST_REG_CE = 1) Then
                If ((MSX_VDT_CMD_REG_CMD = &HF) Or (MSX_VDT_CMD_REG_CMD = &HB)) Then
                    MSX_VRAM_Buff(Go_MSX_VRAM_Buff_Count) = MSX_VDT_REG(44)
                    Go_MSX_VRAM_Buff_Count += 1
                    If (Go_MSX_VRAM_Buff_Count >= Go_MSX_VRAM_Buff_Size) Then
                        MSX_VDT_ST_REG_CE = 0
                        MSX_VDT_ST_REG_TR = 0
                        If (MSX_VDT_CMD_REG_CMD = &HF) Then Call VDTCMD.MSX_VDT_CMD_REG46_HMMC()
                        If (MSX_VDT_CMD_REG_CMD = &HB) Then Call VDTCMD.MSX_VDT_CMD_REG46_LMMC()
                    End If
                End If
            End If

        End Sub

        Public Sub MSX_VDT_CMD_REG45_SET()

            MSX_VDT_CMD_REG_MXC = IIf((MSX_VDT_REG(45) And 64) = 0, 0, 1)
            MSX_VDT_CMD_REG_MXD = IIf((MSX_VDT_REG(45) And 32) = 0, 0, 1)
            MSX_VDT_CMD_REG_MXS = IIf((MSX_VDT_REG(45) And 16) = 0, 0, 1)
            MSX_VDT_CMD_REG_DIY = IIf((MSX_VDT_REG(45) And 8) = 0, 0, 1)
            MSX_VDT_CMD_REG_DIX = IIf((MSX_VDT_REG(45) And 4) = 0, 0, 1)
            MSX_VDT_CMD_REG_EQ = IIf((MSX_VDT_REG(45) And 2) = 0, 0, 1)
            MSX_VDT_CMD_REG_MAJ = IIf((MSX_VDT_REG(45) And 1) = 0, 0, 1)

        End Sub

        Public Sub MSX_VDT_CMD_REG46_SET()

            Dim Nx As Integer, Ny As Integer

            Nx = GET_VDT_CMD_REG_NX()
            Ny = GET_VDT_CMD_REG_NY()

            MSX_VDT_ST_REG_CE = 0
            MSX_VDT_ST_REG_TR = 0

            'Destination, Source, Unint, Mnemonic
            MSX_VDT_CMD_REG_CMD = TBL.Gi_D_Table16(MSX_VDT_REG(46) And &HF0)
            MSX_VDT_CMD_REG_LO = (MSX_VDT_REG(46) And &HF)

            'High-speed move
            If (MSX_VDT_CMD_REG_CMD = &HF) Then
                MSX_VDT_ST_REG_CE = 1
                Go_MSX_VRAM_Buff_Size = Nx * Ny
                If (Gi_MSX_SCREEN_MODE = 5) Then Go_MSX_VRAM_Buff_Size = FN.goInt(Go_MSX_VRAM_Buff_Size / 2)
                If (Gi_MSX_SCREEN_MODE = 6) Then Go_MSX_VRAM_Buff_Size = FN.goInt(Go_MSX_VRAM_Buff_Size / 4)
                If (Gi_MSX_SCREEN_MODE = 7) Then Go_MSX_VRAM_Buff_Size = FN.goInt(Go_MSX_VRAM_Buff_Size / 2)
                MSX_VRAM_Buff(0) = MSX_VDT_REG(44)
                Go_MSX_VRAM_Buff_Count = 1
                If (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size) Then
                    MSX_VDT_ST_REG_TR = 1
                Else
                    MSX_VDT_ST_REG_CE = 0
                End If
            End If
            If (MSX_VDT_CMD_REG_CMD = &HE) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_YMMM() 'D:VRAM, S:VRAM, U:Byte, YMMM
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &HD) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_HMMM(0) 'D:VRAM, S:VRAM, U:Byte, HMMM
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &HC) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_HMMV() 'D:VRAM, S:VDP, U:Byte, HMMV
                MSX_VDT_ST_REG_CE = 0
            End If

            'Logical Move
            If (MSX_VDT_CMD_REG_CMD = &HB) Then
                MSX_VDT_ST_REG_CE = 1
                Go_MSX_VRAM_Buff_Size = Nx * Ny
                MSX_VRAM_Buff(0) = MSX_VDT_REG(44)
                Go_MSX_VRAM_Buff_Count = 1
                If (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size) Then
                    MSX_VDT_ST_REG_TR = 1
                Else
                    MSX_VDT_ST_REG_CE = 0
                End If
            End If
            If (MSX_VDT_CMD_REG_CMD = &HA) Then
                MSX_VDT_ST_REG_CE = 1
                MSX_VDT_ST_REG_TR = 0
                Call VDTCMD.MSX_VDT_CMD_REG46_LMCM() 'D:CPU, S:VRAM, U:Dot, LMCM
                MSX_VDT_ST_REG_TR = 1
            End If
            If (MSX_VDT_CMD_REG_CMD = &H9) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_LMMM() 'D:VRAM, S:VRAM, U:Dot, LMMM
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &H8) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_LMMV() 'D:VRAM, S:VDP, U:Dot, LMMV
                MSX_VDT_ST_REG_CE = 0
            End If

                'Line,Search,Pset,Point
            If (MSX_VDT_CMD_REG_CMD = &H7) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_LINE() 'D:VRAM, S:VDP, U:Dot, LINE
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &H6) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_SRCH() 'D:VRAM, S:VDP, U:Dot, SRCH
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &H5) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_PSET() 'D:VRAM, S:VDP, U:Dot, PSET
                MSX_VDT_ST_REG_CE = 0
            End If
            If (MSX_VDT_CMD_REG_CMD = &H4) Then
                MSX_VDT_ST_REG_CE = 1
                Call VDTCMD.MSX_VDT_CMD_REG46_POINT() 'D:VDT, S:VRAM, U:Dot, POINT
                MSX_VDT_ST_REG_CE = 0
            End If

            'Invalid
            'If MSX_VDT_CMD_REG_CMD = &H3 Then 'Invalid
            'If MSX_VDT_CMD_REG_CMD = &H2 Then 'Invalid
            'If MSX_VDT_CMD_REG_CMD = &H1 Then 'Invalid

            'Stop
            If (MSX_VDT_CMD_REG_CMD = 0) Then 'STOP
                MSX_VDT_ST_REG_CE = 0
                MSX_VDT_ST_REG_TR = 0
            End If

        End Sub

        Public Function GET_VDT_CMD_REG_NX() As Integer

            Dim R As Integer

            R = Go_MSX_VDT_CMD_REG_NX
            If (R = 0) Then
                If (Gi_MSX_SCREEN_MODE = 5) Then R = 256
                If (Gi_MSX_SCREEN_MODE = 6) Then R = 512
                If (Gi_MSX_SCREEN_MODE = 7) Then R = 512
                If (Gi_MSX_SCREEN_MODE = 8) Then R = 256
            End If

            GET_VDT_CMD_REG_NX = R

        End Function

        Public Function GET_VDT_CMD_REG_NY() As Integer

            Dim R As Integer

            R = Go_MSX_VDT_CMD_REG_NY
            'If (R = 0) Then
            '    If (Gi_MSX_SCREEN_MODE = 5) Then R = 1024
            '    If (Gi_MSX_SCREEN_MODE = 6) Then R = 1024
            '    If (Gi_MSX_SCREEN_MODE = 7) Then R = 512
            '    If (Gi_MSX_SCREEN_MODE = 8) Then R = 512
            'End If

            GET_VDT_CMD_REG_NY = R

        End Function

        Public Sub MSX_Color_Setting()

            Dim i As Integer, iGreen As Integer = 0, iRed As Integer = 0, iBlue As Integer = 0
            'MSX1 기본색상 - MSX2 에서는 약간 달라짐(특히White색상이더밝아짐)
            'Tranparent (투명)
            MSX_VDT_REG_PAL_Red(0) = &H0
            MSX_VDT_REG_PAL_Green(0) = &H0
            MSX_VDT_REG_PAL_Blue(0) = &H0
            'Black
            MSX_VDT_REG_PAL_Red(1) = &H0
            MSX_VDT_REG_PAL_Green(1) = &H0
            MSX_VDT_REG_PAL_Blue(1) = &H0
            'Medium Green
            MSX_VDT_REG_PAL_Red(2) = &H20
            MSX_VDT_REG_PAL_Green(2) = &HC0
            MSX_VDT_REG_PAL_Blue(2) = &H20
            'Light Green
            MSX_VDT_REG_PAL_Red(3) = &H60
            MSX_VDT_REG_PAL_Green(3) = &HE0
            MSX_VDT_REG_PAL_Blue(3) = &H60
            'Dark Blue
            MSX_VDT_REG_PAL_Red(4) = &H20
            MSX_VDT_REG_PAL_Green(4) = &H20
            MSX_VDT_REG_PAL_Blue(4) = &HE0
            'Light Blue
            MSX_VDT_REG_PAL_Red(5) = &H40
            MSX_VDT_REG_PAL_Green(5) = &H60
            MSX_VDT_REG_PAL_Blue(5) = &HE0
            'Dark Red
            MSX_VDT_REG_PAL_Red(6) = &HA0
            MSX_VDT_REG_PAL_Green(6) = &H20
            MSX_VDT_REG_PAL_Blue(6) = &H20
            'Cyan (Aqua Blue)
            MSX_VDT_REG_PAL_Red(7) = &H40
            MSX_VDT_REG_PAL_Green(7) = &HC0
            MSX_VDT_REG_PAL_Blue(7) = &HE0
            'Medium Red
            MSX_VDT_REG_PAL_Red(8) = &HE0
            MSX_VDT_REG_PAL_Green(8) = &H20
            MSX_VDT_REG_PAL_Blue(8) = &H20
            'Light Red
            MSX_VDT_REG_PAL_Red(9) = &HE0
            MSX_VDT_REG_PAL_Green(9) = &H60
            MSX_VDT_REG_PAL_Blue(9) = &H60
            'Dark Yellow
            MSX_VDT_REG_PAL_Red(10) = &HC0
            MSX_VDT_REG_PAL_Green(10) = &HC0
            MSX_VDT_REG_PAL_Blue(10) = &H20
            'Light Yellow
            MSX_VDT_REG_PAL_Red(11) = &HC0
            MSX_VDT_REG_PAL_Green(11) = &HC0
            MSX_VDT_REG_PAL_Blue(11) = &H80
            'Dark Green
            MSX_VDT_REG_PAL_Red(12) = &H20
            MSX_VDT_REG_PAL_Green(12) = &H80
            MSX_VDT_REG_PAL_Blue(12) = &H20
            'agenta (Purple)
            MSX_VDT_REG_PAL_Red(13) = &HC0
            MSX_VDT_REG_PAL_Green(13) = &H40
            MSX_VDT_REG_PAL_Blue(13) = &HA0
            'ray
            MSX_VDT_REG_PAL_Red(14) = &HA0
            MSX_VDT_REG_PAL_Green(14) = &HA0
            MSX_VDT_REG_PAL_Blue(14) = &HA0
            'hite
            MSX_VDT_REG_PAL_Red(15) = &HE0
            MSX_VDT_REG_PAL_Green(15) = &HE0
            MSX_VDT_REG_PAL_Blue(15) = &HE0

            For i = 0 To 15
                Call MSX_COLOR_PALETTE(i, MSX_VDT_REG_PAL_Red(i), MSX_VDT_REG_PAL_Green(i), MSX_VDT_REG_PAL_Blue(i))
            Next i

            'MSX2 - Screen 8 소프라이트 색상
            For i = 0 To 15
                If (i = 0) Then iGreen = 0 : iRed = 0 : iBlue = 0 '흑색
                If (i = 1) Then iGreen = 0 : iRed = 0 : iBlue = 2 '어두운청색
                If (i = 2) Then iGreen = 0 : iRed = 3 : iBlue = 0 '어두운적색
                If (i = 3) Then iGreen = 0 : iRed = 3 : iBlue = 2 '어두운자색
                If (i = 4) Then iGreen = 3 : iRed = 0 : iBlue = 0 '어두운녹색
                If (i = 5) Then iGreen = 3 : iRed = 0 : iBlue = 2 '어두운물색
                If (i = 6) Then iGreen = 3 : iRed = 3 : iBlue = 0 '어두운황색
                If (i = 7) Then iGreen = 3 : iRed = 3 : iBlue = 2 '회색
                If (i = 8) Then iGreen = 4 : iRed = 7 : iBlue = 2 '살색?
                If (i = 9) Then iGreen = 0 : iRed = 0 : iBlue = 7 '청색
                If (i = 10) Then iGreen = 0 : iRed = 7 : iBlue = 0 '적색
                If (i = 11) Then iGreen = 0 : iRed = 7 : iBlue = 7 '자색
                If (i = 12) Then iGreen = 7 : iRed = 0 : iBlue = 0 '녹색
                If (i = 13) Then iGreen = 7 : iRed = 0 : iBlue = 7 '물색
                If (i = 14) Then iGreen = 7 : iRed = 7 : iBlue = 0 '황색
                If (i = 15) Then iGreen = 7 : iRed = 7 : iBlue = 7 '백색
                Call MSX_COLOR_PALETTE_G7(i, iRed, iGreen, iBlue)
            Next i

        End Sub

        Public Sub MSX_COLOR_PALETTE(ByVal iReg As Integer, ByVal iRed As Integer, ByVal iGreen As Integer, ByVal iBlue As Integer)

            'Go_MSX_Color(iReg) = FN.goRGB(iBlue, iGreen, iRed) 'VB6
            Go_MSX_Color(iReg) = FN.goRGB(iRed, iGreen, iBlue)
            Go_MSX_Color_RGB(iReg) = FN.goRGB(iRed, iGreen, iBlue)
            'Gc_MSX_Color(iReg) = Color.FromArgb(iBlue, iGreen, iRed) 'VB6
            Gc_MSX_Color(iReg) = Color.FromArgb(iRed, iGreen, iBlue)
            Gc_MSX_Color_RGB(iReg) = Color.FromArgb(iRed, iGreen, iBlue)

        End Sub

        Public Sub MSX_COLOR_PALETTE_G7(ByVal iReg As Integer, ByVal iRed As Integer, ByVal iGreen As Integer, ByVal iBlue As Integer)

            'Go_MSX_Color_G7(iReg) = FN.goRGB(TBL.Gi_M_Table36(iBlue), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iRed)) 'VB6
            Go_MSX_Color_G7(iReg) = FN.goRGB(TBL.Gi_M_Table36(iRed), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iBlue))
            Go_MSX_Color_G7_RGB(iReg) = FN.goRGB(TBL.Gi_M_Table36(iRed), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iBlue))
            'Gc_MSX_Color_G7(iReg) = Color.FromArgb(TBL.Gi_M_Table36(iBlue), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iRed)) 'VB6
            Gc_MSX_Color_G7(iReg) = Color.FromArgb(TBL.Gi_M_Table36(iRed), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iBlue))
            Gc_MSX_Color_G7_RGB(iReg) = Color.FromArgb(TBL.Gi_M_Table36(iRed), TBL.Gi_M_Table36(iGreen), TBL.Gi_M_Table36(iBlue))

        End Sub
    End Module

End Namespace
