﻿Namespace VDTCMD

    Module msxVDT_CMD

        Public Sub MSX_VDT_CMD_REG46_HMMC()

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim oAddrY As Integer, oAddrX As Integer
            Dim iFlg As Integer
            Dim Xp As Integer

            Dim fo_MSX_VRAM_Buff_Count As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            X1 = VDT.Go_MSX_VDT_CMD_REG_DX
            Y1 = VDT.Go_MSX_VDT_CMD_REG_DY
            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                X2 = X1 + (Nx - 1) : StX = 1
            Else
                X2 = X1 - (Nx - 1) : StX = -1
            End If
            If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                Y2 = Y1 + (Ny - 1) : StY = 1
            Else
                Y2 = Y1 - (Ny - 1) : StY = -1
            End If

            fo_MSX_VRAM_Buff_Count = 0

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 5) Then '4 Page, 0~255*0~1023, 16색상
                oAddrY = TBL.Go_M_Table128(Y1) '(256 / 2)
                For Y = Y1 To Y2 Step StY
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 256
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table2(Xp)
                            VDT.MSX_VRAM(oAddrY + oAddrX) = VDT.MSX_VRAM_Buff(fo_MSX_VRAM_Buff_Count) '16Color+16Color
                            fo_MSX_VRAM_Buff_Count += 1
                            iFlg = 1
                        Else
                            iFlg = 0
                        End If
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 128
                    Else
                        oAddrY = oAddrY - 128 : If (oAddrY < 0) Then oAddrY = oAddrY + 128
                    End If
                Next Y
            End If

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 6) Then '4 Page, 0~511*0~1023, 4색상
                oAddrY = TBL.Go_M_Table128(Y1) '(512 / 4)
                For Y = Y1 To Y2 Step StY
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 512
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table4(Xp)
                            VDT.MSX_VRAM(oAddrY + oAddrX) = VDT.MSX_VRAM_Buff(fo_MSX_VRAM_Buff_Count) '4Color+4Color+4Color+4Color
                            fo_MSX_VRAM_Buff_Count += 1
                        End If
                        iFlg = (iFlg + 1)
                        If (iFlg = 4) Then iFlg = 0
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 128
                    Else
                        oAddrY = oAddrY - 128 : If (oAddrY < 0) Then oAddrY = oAddrY + 128
                    End If
                Next Y
            End If

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 7) Then '2 Page, 0~511*0~511, 16색상
                oAddrY = TBL.Go_M_Table256(Y1) '(512 / 2)
                For Y = Y1 To Y2 Step StY
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 512
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table2(Xp)
                            VDT.MSX_VRAM(oAddrY + oAddrX) = VDT.MSX_VRAM_Buff(fo_MSX_VRAM_Buff_Count) '16Color+16Color
                            fo_MSX_VRAM_Buff_Count += 1
                            iFlg = 1
                        Else
                            iFlg = 0
                        End If
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 256
                    Else
                        oAddrY = oAddrY - 256 : If (oAddrY < 0) Then oAddrY = oAddrY + 256
                    End If
                Next Y
            End If

            If (VDT.Gi_MSX_SCREEN_MODE = 8) Then '2 Page, 0~255*0~511, 256색상
                oAddrY = TBL.Go_M_Table256(Y1)
                For Y = Y1 To Y2 Step StY
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 256
                        oAddrX = Xp
                        VDT.MSX_VRAM(oAddrY + oAddrX) = VDT.MSX_VRAM_Buff(fo_MSX_VRAM_Buff_Count) '256Color
                        fo_MSX_VRAM_Buff_Count += 1
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 256
                    Else
                        oAddrY = oAddrY - 256 : If (oAddrY < 0) Then oAddrY = oAddrY + 256
                    End If
                Next Y
            End If

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_DY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()

            VDT.Gi_MSX_Screen_Out = 1 '화면표시작업

        End Sub

        Public Sub MSX_VDT_CMD_REG46_YMMM()

            Call MSX_VDT_CMD_REG46_HMMM(1)

        End Sub

        Public Sub MSX_VDT_CMD_REG46_HMMM(ByVal iSel As Integer)

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim oAddrY As Integer, oAddrX As Integer
            Dim oAddrY2 As Integer, oAddrX2 As Integer, Dx2 As Integer
            Dim iFlg As Integer, iNx As Integer
            Dim Xp As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            If (iSel = 0) Then
                X1 = VDT.Go_MSX_VDT_CMD_REG_SX
                Y1 = VDT.Go_MSX_VDT_CMD_REG_SY
                If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                    X2 = X1 + (Nx - 1) : StX = 1
                Else
                    X2 = X1 - (Nx - 1) : StX = -1
                End If
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    Y2 = Y1 + (Ny - 1) : StY = 1
                Else
                    Y2 = Y1 - (Ny - 1) : StY = -1
                End If
            Else
                X1 = VDT.Go_MSX_VDT_CMD_REG_DX
                Y1 = VDT.Go_MSX_VDT_CMD_REG_SY
                If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                    If ((VDT.Gi_MSX_SCREEN_MODE = 5) Or (VDT.Gi_MSX_SCREEN_MODE = 8)) Then
                        iNx = 255 - X1 + 1
                    Else
                        iNx = 511 - X1 + 1
                    End If
                    X2 = X1 + (iNx - 1) : StX = 1
                Else
                    If ((VDT.Gi_MSX_SCREEN_MODE = 5) Or (VDT.Gi_MSX_SCREEN_MODE = 8)) Then
                        iNx = X1 + 1
                    Else
                        iNx = X1 + 1
                    End If
                    X2 = X1 - (iNx - 1) : StX = -1
                End If
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    Y2 = Y1 + (Ny - 1) : StY = 1
                Else
                    Y2 = Y1 - (Ny - 1) : StY = -1
                End If
            End If

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 5) Then '4 Page, 0~255*0~1023, 16색상
                oAddrY = TBL.Go_M_Table128(Y1) '(256 / 2)
                oAddrY2 = TBL.Go_M_Table128(VDT.Go_MSX_VDT_CMD_REG_DY)
                For Y = Y1 To Y2 Step StY
                    Dx2 = 0
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 256
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table2(Xp)
                            oAddrX2 = TBL.Gi_D_Table2(VDT.Go_MSX_VDT_CMD_REG_DX + Dx2)
                            VDT.MSX_VRAM(oAddrY2 + oAddrX2) = VDT.MSX_VRAM(oAddrY + oAddrX) '16Color+16Color
                            iFlg = 1
                        Else
                            iFlg = 0
                        End If
                        Dx2 = Dx2 + 1
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 128
                        oAddrY2 = oAddrY2 + 128
                    Else
                        oAddrY = oAddrY - 128 : If (oAddrY < 0) Then oAddrY = oAddrY + 128
                        oAddrY2 = oAddrY2 - 128 : If (oAddrY2 < 0) Then oAddrY2 = oAddrY2 + 128
                    End If
                Next Y
            End If

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 6) Then '4 Page, 0~511*0~1023, 4색상
                oAddrY = TBL.Go_M_Table128(Y1) '(512 / 4)
                oAddrY2 = TBL.Go_M_Table128(VDT.Go_MSX_VDT_CMD_REG_DY)
                For Y = Y1 To Y2 Step StY
                    Dx2 = 0
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 512
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table4(Xp)
                            oAddrX2 = TBL.Gi_D_Table4(VDT.Go_MSX_VDT_CMD_REG_DX + Dx2)
                            VDT.MSX_VRAM(oAddrY2 + oAddrX2) = VDT.MSX_VRAM(oAddrY + oAddrX) '4Color+4Color+4Color+4Color
                        End If
                        iFlg = (iFlg + 1)
                        If (iFlg = 4) Then iFlg = 0
                        Dx2 = Dx2 + 1
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 128
                        oAddrY2 = oAddrY2 + 128
                    Else
                        oAddrY = oAddrY - 128 : If (oAddrY < 0) Then oAddrY = oAddrY + 128
                        oAddrY2 = oAddrY2 - 128 : If (oAddrY2 < 0) Then oAddrY2 = oAddrY2 + 128
                    End If
                Next Y
            End If

            iFlg = 0
            If (VDT.Gi_MSX_SCREEN_MODE = 7) Then '2 Page, 0~511*0~511, 16색상
                oAddrY = TBL.Go_M_Table256(Y1) '(512 / 2)
                oAddrY2 = TBL.Go_M_Table256(VDT.Go_MSX_VDT_CMD_REG_DY)
                For Y = Y1 To Y2 Step StY
                    Dx2 = 0
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 512
                        If (iFlg = 0) Then
                            oAddrX = TBL.Gi_D_Table2(Xp)
                            oAddrX2 = TBL.Gi_D_Table2(VDT.Go_MSX_VDT_CMD_REG_DX + Dx2)
                            VDT.MSX_VRAM(oAddrY2 + oAddrX2) = VDT.MSX_VRAM(oAddrY + oAddrX) '16Color+16Color
                            iFlg = 1
                        Else
                            iFlg = 0
                        End If
                        Dx2 = Dx2 + 1
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 256
                        oAddrY2 = oAddrY2 + 256
                    Else
                        oAddrY = oAddrY - 256 : If (oAddrY < 0) Then oAddrY = oAddrY + 256
                        oAddrY2 = oAddrY2 - 256 : If (oAddrY2 < 0) Then oAddrY2 = oAddrY2 + 256
                    End If
                Next Y
            End If

            If (VDT.Gi_MSX_SCREEN_MODE = 8) Then '2 Page, 0~255*0~511, 256색상
                oAddrY = TBL.Go_M_Table256(Y1)
                oAddrY2 = TBL.Go_M_Table256(VDT.Go_MSX_VDT_CMD_REG_DY)
                For Y = Y1 To Y2 Step StY
                    Dx2 = 0
                    For X = X1 To X2 Step StX
                        Xp = X : If (Xp < 0) Then Xp = Xp + 256
                        oAddrX = Xp
                        oAddrX2 = VDT.Go_MSX_VDT_CMD_REG_DX + Dx2
                        VDT.MSX_VRAM(oAddrY2 + oAddrX2) = VDT.MSX_VRAM(oAddrY + oAddrX) '256Color
                        Dx2 = Dx2 + 1
                    Next X
                    If (StY = 1) Then
                        oAddrY = oAddrY + 256
                        oAddrY2 = oAddrY2 + 256
                    Else
                        oAddrY = oAddrY - 256 : If (oAddrY < 0) Then oAddrY = oAddrY + 256
                        oAddrY2 = oAddrY2 - 256 : If (oAddrY2 < 0) Then oAddrY2 = oAddrY2 + 256
                    End If
                Next Y
            End If

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY)
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY)
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_SY()
            Call VDT.MSX_VDT_CMD_REG_DY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()

        End Sub

        Public Sub MSX_VDT_CMD_REG46_HMMV()

            Dim iBak As Integer

            iBak = VDT.MSX_VDT_CMD_REG_LO

            VDT.MSX_VDT_CMD_REG_LO = 0
            Call MSX_VDT_CMD_REG46_LMMV()

            VDT.MSX_VDT_CMD_REG_LO = iBak

        End Sub

        Public Sub MSX_VDT_CMD_REG46_LMMC()

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim iColS As Integer
            Dim Dx As Integer, Dy As Integer
            Dim Xp As Integer

            Dim fo_MSX_VRAM_Buff_Count As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            X1 = 0
            Y1 = 0
            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                X2 = (Nx - 1) : StX = 1
            Else
                X2 = (Nx - 1) * (-1) : StX = -1
            End If
            If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                Y2 = (Ny - 1) : StY = 1
            Else
                Y2 = (Ny - 1) * (-1) : StY = -1
            End If

            fo_MSX_VRAM_Buff_Count = 0

            For Y = Y1 To Y2 Step StY
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY
                For X = X1 To X2 Step StX
                    Xp = X
                    If (Xp < 0) Then
                        If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Xp = Xp + 256
                        If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Xp = Xp + 256
                    End If
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX
                    iColS = VDT.MSX_VRAM_Buff(fo_MSX_VRAM_Buff_Count)
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, iColS)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, iColS)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, iColS)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, iColS)
                    fo_MSX_VRAM_Buff_Count += 1
                Next X
            Next Y

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_DY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()

            VDT.Gi_MSX_Screen_Out = 1 '화면표시작업

        End Sub

        Public Sub MSX_VDT_CMD_REG46_LMCM()

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim Sx As Integer, Sy As Integer
            Dim Xp As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            X1 = 0
            Y1 = 0
            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                X2 = (Nx - 1) : StX = 1
            Else
                X2 = (Nx - 1) * (-1) : StX = -1
            End If
            If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                Y2 = (Ny - 1) : StY = 1
            Else
                Y2 = (Ny - 1) * (-1) : StY = -1
            End If

            VDT.Go_MSX_VRAM_Buff_Count = 0

            For Y = Y1 To Y2 Step StY
                Sy = Y + VDT.Go_MSX_VDT_CMD_REG_SY
                For X = X1 To X2 Step StX
                    Xp = X
                    If (Xp < 0) Then
                        If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Xp = Xp + 256
                        If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Xp = Xp + 256
                    End If
                    Sx = Xp + VDT.Go_MSX_VDT_CMD_REG_SX
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMCM_5(Sx, Sy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMCM_6(Sx, Sy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMCM_7(Sx, Sy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMCM_8(Sx, Sy)
                    VDT.Go_MSX_VRAM_Buff_Count += 1
                Next X
            Next Y

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_SY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()
            Call VDT.MSX_VDT_CMD_REG_CLR()

        End Sub

        '4 Page, 0~255*0~1023, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMCM_5(ByVal Sx As Integer, ByVal Sy As Integer)

            Dim iPosS As Integer
            Dim iColS As Integer = 0
            Dim iColS2 As Integer
            Dim oAddrS As Integer

            iPosS = TBL.Gi_Col_Pos2(Sx)
            oAddrS = TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table2(Sx) '256/2*1024/2

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table16(iColS2 And &HF0)
            If (iPosS = 1) Then iColS = (iColS2 And &HF)

            VDT.MSX_VRAM_Buff(VDT.Go_MSX_VRAM_Buff_Count) = iColS

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS

        End Sub

        '4 Page, 0~511*0~1023, 4색상
        Public Sub MSX_VDT_CMD_REG46_LMCM_6(ByVal Sx As Integer, ByVal Sy As Integer)

            Dim iPosS As Integer
            Dim iColS As Integer = 0
            Dim iColS2 As Integer
            Dim oAddrS As Integer

            iPosS = TBL.Gi_Col_Pos4(Sx)
            oAddrS = TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table4(Sx) '512/4*1024/4

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table64(iColS2)
            If (iPosS = 1) Then iColS = TBL.Gi_D_Table16(iColS2 And 63)
            If (iPosS = 2) Then iColS = TBL.Gi_D_Table4(iColS2 And 15)
            If (iPosS = 3) Then iColS = (iColS2 And 3)

            VDT.MSX_VRAM_Buff(VDT.Go_MSX_VRAM_Buff_Count) = iColS

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS

        End Sub

        '2 Page, 0~511*0~511, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMCM_7(ByVal Sx As Integer, ByVal Sy As Integer)

            Dim iPosS As Integer
            Dim iColS As Integer = 0
            Dim iColS2 As Integer
            Dim oAddrS As Integer

            iPosS = TBL.Gi_Col_Pos2(Sx)
            oAddrS = TBL.Go_M_Table256(Sy) + TBL.Gi_D_Table2(Sx) '512/2*512/2

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table16(iColS2 And &HF0)
            If (iPosS = 1) Then iColS = (iColS2 And &HF)

            VDT.MSX_VRAM_Buff(VDT.Go_MSX_VRAM_Buff_Count) = iColS

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS

        End Sub

        '2 Page, 0~255*0~511, 256색상
        Public Sub MSX_VDT_CMD_REG46_LMCM_8(ByVal Sx As Integer, ByVal Sy As Integer)

            Dim iColS As Integer
            Dim oAddrS As Integer

            oAddrS = TBL.Go_M_Table256(Sy) + Sx '256*512

            iColS = VDT.MSX_VRAM(oAddrS)

            VDT.MSX_VRAM_Buff(VDT.Go_MSX_VRAM_Buff_Count) = iColS

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS

        End Sub

        Public Sub MSX_VDT_CMD_REG46_LMMM()

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim Sx As Integer, Sy As Integer
            Dim Dx As Integer, Dy As Integer
            Dim Xp As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            X1 = 0
            Y1 = 0
            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                X2 = (Nx - 1) : StX = 1
            Else
                X2 = (Nx - 1) * (-1) : StX = -1
            End If
            If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                Y2 = (Ny - 1) : StY = 1
            Else
                Y2 = (Ny - 1) * (-1) : StY = -1
            End If

            For Y = Y1 To Y2 Step StY
                Sy = Y + VDT.Go_MSX_VDT_CMD_REG_SY
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY
                For X = X1 To X2 Step StX
                    Xp = X
                    If (Xp < 0) Then
                        If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Xp = Xp + 256
                        If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Xp = Xp + 256
                    End If
                    Sx = Xp + VDT.Go_MSX_VDT_CMD_REG_SX
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMM_5(Sx, Sy, Dx, Dy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMM_6(Sx, Sy, Dx, Dy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMM_7(Sx, Sy, Dx, Dy)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMM_8(Sx, Sy, Dx, Dy)
                Next X
            Next Y

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY)
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY)
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_SY()
            Call VDT.MSX_VDT_CMD_REG_DY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()

        End Sub

        '4 Page, 0~255*0~1023, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMMM_5(ByVal Sx As Integer, ByVal Sy As Integer, ByVal Dx As Integer, ByVal Dy As Integer)

            Dim iPosS As Integer, iPosD As Integer
            Dim iColS As Integer = 0, iColD As Integer = 0, iColT As Integer
            Dim iColS2 As Integer, iColD2 As Integer
            Dim oAddrS As Integer, oAddrD As Integer

            iPosS = TBL.Gi_Col_Pos2(Sx)
            oAddrS = (TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table2(Sx)) '256/2*1024/2
            iPosD = TBL.Gi_Col_Pos2(Dx)
            oAddrD = (TBL.Go_M_Table128(Dy) + TBL.Gi_D_Table2(Dx)) '256/2*1024/2

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table16(iColS2 And &HF0)
            If (iPosS = 1) Then iColS = (iColS2 And &HF)
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table16(iColD2 And &HF0)
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF) Or TBL.Gi_M_Table16(iColT))
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF0) Or iColT)

        End Sub

        '4 Page, 0~511*0~1023, 4색상
        Public Sub MSX_VDT_CMD_REG46_LMMM_6(ByVal Sx As Integer, ByVal Sy As Integer, ByVal Dx As Integer, ByVal Dy As Integer)

            Dim iPosS As Integer, iPosD As Integer
            Dim iColS As Integer = 0, iColD As Integer = 0, iColT As Integer
            Dim iColS2 As Integer, iColD2 As Integer
            Dim oAddrS As Integer, oAddrD As Integer

            iPosS = TBL.Gi_Col_Pos4(Sx)
            oAddrS = TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table4(Sx) '512/4*1024/4
            iPosD = TBL.Gi_Col_Pos4(Dx)
            oAddrD = TBL.Go_M_Table128(Dy) + TBL.Gi_D_Table4(Dx) '512/4*1024/4

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table64(iColS2 >> 6) '(/)64
            If (iPosS = 1) Then iColS = TBL.Gi_D_Table16((iColS2 And 63) >> 4) '(/)16
            If (iPosS = 2) Then iColS = TBL.Gi_D_Table4((iColS2 And 15) >> 2) '(/)4
            If (iPosS = 3) Then iColS = (iColS2 And 3)
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table64(iColD2 >> 6) '(/)64
            If (iPosD = 1) Then iColD = TBL.Gi_D_Table16((iColD2 And 63) >> 4) '(/)16
            If (iPosD = 2) Then iColD = TBL.Gi_D_Table4((iColD2 And 15) >> 2) '(/)4
            If (iPosD = 3) Then iColD = (iColD2 And 3)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 3)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = (((iColD2 And 63) And &HF0) Or (iColT << 6)) '(*)64
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = (((iColD2 And 207) And &HF0) Or (iColT << 4)) '(*)16
            If (iPosD = 2) Then VDT.MSX_VRAM(oAddrD) = (((iColD2 And 243) And &HF0) Or (iColT << 2)) '(*)4
            If (iPosD = 3) Then VDT.MSX_VRAM(oAddrD) = (((iColD2 And 252) And &HF0) Or iColT)

        End Sub

        '2 Page, 0~511*0~511, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMMM_7(ByVal Sx As Integer, ByVal Sy As Integer, ByVal Dx As Integer, ByVal Dy As Integer)

            Dim iPosS As Integer, iPosD As Integer
            Dim iColS As Integer = 0, iColD As Integer = 0, iColT As Integer
            Dim iColS2 As Integer, iColD2 As Integer
            Dim oAddrS As Integer, oAddrD As Integer

            iPosS = TBL.Gi_Col_Pos2(Sx)
            oAddrS = TBL.Go_M_Table256(Sy) + TBL.Gi_D_Table2(Sx) '512/2*512/2
            iPosD = TBL.Gi_Col_Pos2(Dx)
            oAddrD = TBL.Go_M_Table256(Dy) + TBL.Gi_D_Table2(Dx) '512/2*512/2

            iColS2 = VDT.MSX_VRAM(oAddrS)
            If (iPosS = 0) Then iColS = TBL.Gi_D_Table16(iColS2 And &HF0)
            If (iPosS = 1) Then iColS = (iColS2 And &HF)
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table16(iColD2 And &HF0)
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF) Or TBL.Gi_M_Table16(iColT))
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF0) Or iColT)

        End Sub

        '2 Page, 0~255*0~511, 256색상
        Public Sub MSX_VDT_CMD_REG46_LMMM_8(ByVal Sx As Integer, ByVal Sy As Integer, ByVal Dx As Integer, ByVal Dy As Integer)

            Dim iColS As Integer, iColD As Integer
            Dim oAddrS As Integer, oAddrD As Integer

            oAddrS = TBL.Go_M_Table256(Sy) + Sx '256*512
            oAddrD = TBL.Go_M_Table256(Dy) + Dx '256*512

            iColS = VDT.MSX_VRAM(oAddrS)
            iColD = VDT.MSX_VRAM(oAddrD)

            VDT.MSX_VRAM(oAddrD) = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 255)

        End Sub

        Public Sub MSX_VDT_CMD_REG46_LMMV()

            Dim X As Integer, Y As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer, StX As Integer, StY As Integer
            Dim Nx As Integer, Ny As Integer
            Dim Dx As Integer, Dy As Integer
            Dim Xp As Integer

            Nx = VDT.GET_VDT_CMD_REG_NX()
            Ny = VDT.GET_VDT_CMD_REG_NY()

            X1 = 0
            Y1 = 0
            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                X2 = (Nx - 1) : StX = 1
            Else
                X2 = (Nx - 1) * (-1) : StX = -1
            End If
            If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                Y2 = (Ny - 1) : StY = 1
            Else
                Y2 = (Ny - 1) * (-1) : StY = -1
            End If

            For Y = Y1 To Y2 Step StY
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY
                For X = X1 To X2 Step StX
                    Xp = X
                    If (Xp < 0) Then
                        If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Xp = Xp + 256
                        If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Xp = Xp + 512
                        If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Xp = Xp + 256
                    End If
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1)
                Next X
            Next Y

            If (StY = 1) Then
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY)
            Else
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY)
            End If
            Call VDT.MSX_VDT_CMD_REG_DY()
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0) '화면끝 ?
            Call VDT.MSX_VDT_CMD_REG_NY()

        End Sub

        '4 Page, 0~255*0~1023, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMMV_5(ByVal Dx As Integer, ByVal Dy As Integer, ByVal iCol As Integer)

            Dim iPosD As Integer
            Dim iColS As Integer, iColD As Integer = 0, iColT As Integer
            Dim iColD2 As Integer
            Dim oAddrD As Integer

            If ((Dx < 0) Or (Dx > 255)) Then GoTo LastProc
            If ((Dy < 0) Or (Dy > 1023)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos2(Dx)
            oAddrD = TBL.Go_M_Table128(Dy) + TBL.Gi_D_Table2(Dx) '256/2*1024/2

            If (iCol = (-1)) Then
                iColS = (VDT.Gi_MSX_VDT_CMD_REG_Color And 15)
            Else
                iColS = (iCol And 15)
            End If
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table16(iColD2 And &HF0)
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF) Or TBL.Gi_M_Table16(iColT))
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF0) Or iColT)

LastProc:

        End Sub

        '4 Page, 0~511*0~1023, 4색상
        Public Sub MSX_VDT_CMD_REG46_LMMV_6(ByVal Dx As Integer, ByVal Dy As Integer, ByVal iCol As Integer)

            Dim iPosD As Integer
            Dim iColS As Integer, iColD As Integer = 0, iColT As Integer
            Dim iColD2 As Integer
            Dim oAddrD As Integer

            If ((Dx < 0) Or (Dx > 511)) Then GoTo LastProc
            If ((Dy < 0) Or (Dy > 1023)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos4(Dx)
            oAddrD = TBL.Go_M_Table128(Dy) + TBL.Gi_D_Table4(Dx) '512/4*1024/4

            If (iCol = (-1)) Then
                iColS = (VDT.Gi_MSX_VDT_CMD_REG_Color And 3)
            Else
                iColS = (iCol And 3)
            End If
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table64(iColD2)
            If (iPosD = 1) Then iColD = TBL.Gi_D_Table16(iColD2 And 63)
            If (iPosD = 2) Then iColD = TBL.Gi_D_Table4(iColD2 And 15)
            If (iPosD = 3) Then iColD = (iColD2 And 3)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 3)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And 63) Or TBL.Gi_M_Table64(iColT))
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And 207) Or TBL.Gi_M_Table16(iColT))
            If (iPosD = 2) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And 243) Or TBL.Gi_M_Table4(iColT))
            If (iPosD = 3) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And 252) Or iColT)

LastProc:

        End Sub

        '2 Page, 0~511*0~511, 16색상
        Public Sub MSX_VDT_CMD_REG46_LMMV_7(ByVal Dx As Integer, ByVal Dy As Integer, ByVal iCol As Integer)

            Dim iPosD As Integer
            Dim iColS As Integer, iColD As Integer = 0, iColT As Integer
            Dim iColD2 As Integer
            Dim oAddrD As Integer

            If ((Dx < 0) Or (Dx > 511)) Then GoTo LastProc
            If ((Dy < 0) Or (Dy > 511)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos2(Dx)
            oAddrD = TBL.Go_M_Table256(Dy) + TBL.Gi_D_Table2(Dx) '512/2*512/2

            If (iCol = (-1)) Then
                iColS = (VDT.Gi_MSX_VDT_CMD_REG_Color And 15)
            Else
                iColS = (iCol And 15)
            End If
            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = TBL.Gi_D_Table16(iColD2 And &HF0)
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

            iColT = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 15)

            If (iPosD = 0) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF) Or TBL.Gi_M_Table16(iColT))
            If (iPosD = 1) Then VDT.MSX_VRAM(oAddrD) = ((iColD2 And &HF0) Or iColT)

LastProc:

        End Sub

        '2 Page, 0~255*0~511, 256색상
        Public Sub MSX_VDT_CMD_REG46_LMMV_8(ByVal Dx As Integer, ByVal Dy As Integer, ByVal iCol As Integer)

            Dim iColS As Integer, iColD As Integer
            Dim oAddrD As Integer

            If ((Dx < 0) Or (Dx > 255)) Then GoTo LastProc
            If ((Dy < 0) Or (Dy > 511)) Then GoTo LastProc

            oAddrD = TBL.Go_M_Table256(Dy) + Dx '256*512

            If (iCol = (-1)) Then
                iColS = VDT.Gi_MSX_VDT_CMD_REG_Color
            Else
                iColS = iCol
            End If
            iColD = VDT.MSX_VRAM(oAddrD)

            VDT.MSX_VRAM(oAddrD) = (fi_MSX_VDT_CMD_LO(iColS, iColD) And 255)

LastProc:

        End Sub

        'Line
        Public Sub MSX_VDT_CMD_REG46_LINE()

            Dim i As Integer
            Dim X1 As Integer, Y1 As Integer, X2 As Integer, Y2 As Integer
            Dim Y As Integer
            Dim F As Double, F1 As Double, F2 As Double
            Dim Dx As Integer, Dy As Integer

            X1 = VDT.Go_MSX_VDT_CMD_REG_DX
            Y1 = VDT.Go_MSX_VDT_CMD_REG_DY
            If (VDT.MSX_VDT_CMD_REG_MAJ = 0) Then 'X긴변
                If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                    X2 = X1 + (VDT.Go_MSX_VDT_CMD_REG_Mjg)
                Else
                    X2 = X1 + ((VDT.Go_MSX_VDT_CMD_REG_Mjg) * (-1))
                End If
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    Y2 = Y1 + (VDT.Go_MSX_VDT_CMD_REG_Min)
                Else
                    Y2 = Y1 + ((VDT.Go_MSX_VDT_CMD_REG_Min) * (-1))
                End If
                If (X1 > X2) Then
                    Call FN.gtSwap16(X1, X2)
                    Call FN.gtSwap16(Y1, Y2)
                End If
                F2 = X2 - X1
                If (Y1 <= Y2) Then
                    Y = 1
                    F1 = Y2 - Y1
                Else
                    Y = -1
                    F1 = Y1 - Y2
                End If
                F = 0 : If (F2 <> 0) Then F = (F1) / (F2)
                For i = 0 To (X2 - X1)
                    Dx = X1 + i
                    Dy = Y1 + (FN.giInt(i * F + 0.5) * Y)
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1)
                Next i
            Else 'Y긴변
                If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                    X2 = X1 + (VDT.Go_MSX_VDT_CMD_REG_Min)
                Else
                    X2 = X1 + ((VDT.Go_MSX_VDT_CMD_REG_Min) * (-1))
                End If
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    Y2 = Y1 + (VDT.Go_MSX_VDT_CMD_REG_Mjg)
                Else
                    Y2 = Y1 + ((VDT.Go_MSX_VDT_CMD_REG_Mjg) * (-1))
                End If
                If (Y1 > Y2) Then
                    FN.gtSwap16(X1, X2)
                    FN.gtSwap16(Y1, Y2)
                End If
                F2 = Y2 - Y1
                If (X1 <= X2) Then
                    Y = 1
                    F1 = X2 - X1
                Else
                    Y = -1
                    F1 = X1 - X2
                End If
                F = 0 : If (F2 <> 0) Then F = (F1) / (F2)
                For i = 0 To (Y2 - Y1)
                    Dy = Y1 + i
                    Dx = X1 + (FN.giInt(i * F + 0.5) * Y)
                    If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1)
                    If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1)
                Next i
            End If

            If (VDT.MSX_VDT_CMD_REG_MAJ = 0) Then 'X긴변
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_Min)
                Else
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_Min)
                End If
            Else 'Y긴변
                If (VDT.MSX_VDT_CMD_REG_DIY = 0) Then
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_Min)
                Else
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_Min)
                End If
            End If
            Call VDT.MSX_VDT_CMD_REG_DY()

        End Sub

        Public Sub MSX_VDT_CMD_REG46_SRCH()

            Dim i As Integer
            Dim X2 As Integer = 0, StX As Integer
            Dim Sx As Integer, Sy As Integer
            Dim iCol As Integer = 0

            Sx = VDT.Go_MSX_VDT_CMD_REG_SX
            Sy = VDT.Go_MSX_VDT_CMD_REG_SY

            If (VDT.MSX_VDT_CMD_REG_DIX = 0) Then
                If (VDT.Gi_MSX_SCREEN_MODE = 5) Then X2 = 255
                If (VDT.Gi_MSX_SCREEN_MODE = 6) Then X2 = 511
                If (VDT.Gi_MSX_SCREEN_MODE = 7) Then X2 = 511
                If (VDT.Gi_MSX_SCREEN_MODE = 8) Then X2 = 255
                StX = 1
            Else
                X2 = 0
                StX = -1
            End If

            VDT.MSX_VDT_ST_REG_BD = 0

            For i = Sx To X2 Step StX
                If (VDT.Gi_MSX_SCREEN_MODE = 5) Then iCol = MSX_VDT_CMD_REG46_POINT_5(i, Sy)
                If (VDT.Gi_MSX_SCREEN_MODE = 6) Then iCol = MSX_VDT_CMD_REG46_POINT_6(i, Sy)
                If (VDT.Gi_MSX_SCREEN_MODE = 7) Then iCol = MSX_VDT_CMD_REG46_POINT_7(i, Sy)
                If (VDT.Gi_MSX_SCREEN_MODE = 8) Then iCol = MSX_VDT_CMD_REG46_POINT_8(i, Sy)
                If (VDT.MSX_VDT_CMD_REG_EQ = 0) Then '경계색발견
                    If (iCol = VDT.Gi_MSX_VDT_CMD_REG_Color) Then
                        VDT.MSX_VDT_ST_REG_BD = 1 '발견
                        VDT.Go_MSX_VDT_ST_REG_BX = (i And 511) Or 65024 '11111118 76543210
                        GoTo LastProc
                    End if 
                Else '경계색이외를발견
                    If (iCol <> VDT.Gi_MSX_VDT_CMD_REG_Color) Then
                        VDT.MSX_VDT_ST_REG_BD = 1 '발견
                        VDT.Go_MSX_VDT_ST_REG_BX = (i And 511) Or 65024 '11111118 76543210
                        GoTo LastProc
                    End If
                End If
            Next i

LastProc:

        End Sub

        'Pset
        Public Sub MSX_VDT_CMD_REG46_PSET()

            Dim Dx As Integer, Dy As Integer

            Dx = VDT.Go_MSX_VDT_CMD_REG_DX
            Dy = VDT.Go_MSX_VDT_CMD_REG_DY
            If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1)
            If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1)
            If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1)
            If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1)

        End Sub

        Public Sub MSX_VDT_CMD_REG46_POINT()

            Dim Sx As Integer, Sy As Integer

            Sx = VDT.Go_MSX_VDT_CMD_REG_SX
            Sy = VDT.Go_MSX_VDT_CMD_REG_SY
            If (VDT.Gi_MSX_SCREEN_MODE = 5) Then VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_5(Sx, Sy)
            If (VDT.Gi_MSX_SCREEN_MODE = 6) Then VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_6(Sx, Sy)
            If (VDT.Gi_MSX_SCREEN_MODE = 7) Then VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_7(Sx, Sy)
            If (VDT.Gi_MSX_SCREEN_MODE = 8) Then VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_8(Sx, Sy)

            VDT.Gi_MSX_VDT_CMD_REG_Color = VDT.Gi_MSX_VDT_ST_REG_Color
            Call VDT.MSX_VDT_CMD_REG_CLR()

        End Sub

        '4 Page, 0~255*0~1023, 16색상
        Public Function MSX_VDT_CMD_REG46_POINT_5(ByVal Sx As Integer, ByVal Sy As Integer) As Integer

            Dim iPosD As Integer
            Dim iColD As Integer, iColD2 As Integer
            Dim oAddrD As Integer

            iColD = 0
            If ((Sx < 0) Or (Sx > 255)) Then GoTo LastProc
            If ((Sy < 0) Or (Sy > 1023)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos2(Sx)
            oAddrD = TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table2(Sx) '256/2*1024/2

            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = (TBL.Gi_D_Table16(iColD2 And &HF0))
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

LastProc:
            MSX_VDT_CMD_REG46_POINT_5 = iColD

        End Function

        '4 Page, 0~511*0~1023, 4색상
        Public Function MSX_VDT_CMD_REG46_POINT_6(ByVal Sx As Integer, ByVal Sy As Integer) As Integer

            Dim iPosD As Integer
            Dim iColD As Integer, iColD2 As Integer
            Dim oAddrD As Integer

            iColD = 0
            If ((Sx < 0) Or (Sx > 511)) Then GoTo LastProc
            If ((Sy < 0) Or (Sy > 1023)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos4(Sx)
            oAddrD = TBL.Go_M_Table128(Sy) + TBL.Gi_D_Table4(Sx) '512/4*1024/4

            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = (TBL.Gi_D_Table64(iColD2))
            If (iPosD = 1) Then iColD = (TBL.Gi_D_Table16(iColD2 And 63))
            If (iPosD = 2) Then iColD = (TBL.Gi_D_Table4(iColD2 And 15))
            If (iPosD = 3) Then iColD = (iColD2 And 3)

LastProc:
            MSX_VDT_CMD_REG46_POINT_6 = iColD

        End Function

        '2 Page, 0~511*0~511, 16색상
        Public Function MSX_VDT_CMD_REG46_POINT_7(ByVal Sx As Integer, ByVal Sy As Integer) As Integer

            Dim iPosD As Integer
            Dim iColD As Integer, iColD2 As Integer
            Dim oAddrD As Integer

            iColD = 0
            If ((Sx < 0) Or (Sx > 511)) Then GoTo LastProc
            If ((Sy < 0) Or (Sy > 511)) Then GoTo LastProc

            iPosD = TBL.Gi_Col_Pos2(Sx)
            oAddrD = TBL.Go_M_Table256(Sy) + TBL.Gi_D_Table2(Sx) '512/2*512/2

            iColD2 = VDT.MSX_VRAM(oAddrD)
            If (iPosD = 0) Then iColD = (TBL.Gi_D_Table16(iColD2 And &HF0))
            If (iPosD = 1) Then iColD = (iColD2 And &HF)

LastProc:
            MSX_VDT_CMD_REG46_POINT_7 = iColD

        End Function

        '2 Page, 0~255*0~511, 256색상
        Public Function MSX_VDT_CMD_REG46_POINT_8(ByVal Sx As Integer, ByVal Sy As Integer) As Integer

            Dim iColD As Integer
            Dim oAddrD As Integer

            iColD = 0
            If ((Sx < 0) Or (Sx > 255)) Then GoTo LastProc
            If ((Sy < 0) Or (Sy > 511)) Then GoTo LastProc

            oAddrD = TBL.Go_M_Table256(Sy) + Sx '256*512

            iColD = VDT.MSX_VRAM(oAddrD)

LastProc:
            MSX_VDT_CMD_REG46_POINT_8 = iColD

        End Function

        Public Function fi_MSX_VDT_CMD_LO(ByVal iColS As Integer, ByVal iColD As Integer) As Integer

            Dim R As Integer

            R = 0

            If (VDT.MSX_VDT_CMD_REG_LO = &H0) Then R = iColS
            If (VDT.MSX_VDT_CMD_REG_LO = &H1) Then R = (iColS And iColD)
            If (VDT.MSX_VDT_CMD_REG_LO = &H2) Then R = (iColS Or iColD)
            If (VDT.MSX_VDT_CMD_REG_LO = &H3) Then R = ((Z80A.giGetIntToInt(Not iColS) And iColD) Or (iColS And Z80A.giGetIntToInt(Not iColD)))
            If (VDT.MSX_VDT_CMD_REG_LO = &H4) Then R = (Z80A.giGetIntToInt(Not iColS))

            If ((VDT.MSX_VDT_CMD_REG_LO >= &H8) And (VDT.MSX_VDT_CMD_REG_LO <= &HC)) Then
                If (iColS = 0) Then
                    R = iColD
                Else
                    If (VDT.MSX_VDT_CMD_REG_LO = &H8) Then R = iColS
                    If (VDT.MSX_VDT_CMD_REG_LO = &H9) Then R = (iColS And iColD)
                    If (VDT.MSX_VDT_CMD_REG_LO = &HA) Then R = (iColS Or iColD)
                    If (VDT.MSX_VDT_CMD_REG_LO = &HB) Then R = ((Z80A.giGetIntToInt(Not iColS) And iColD) Or (iColS And Z80A.giGetIntToInt(Not iColD)))
                    If (VDT.MSX_VDT_CMD_REG_LO = &HC) Then R = Z80A.giGetIntToInt(Not iColS)
                End If
                End If

            fi_MSX_VDT_CMD_LO = R

        End Function
    End Module

End Namespace
