﻿Namespace VDTOUT

    Module msxVDT_OUT

        Private Declare Function StretchDIBits Lib "gdi32.dll" (ByVal hdc As Integer, ByVal XDest As Integer, ByVal YDest As Integer, ByVal nDestWidth As Integer, ByVal nDestHeight As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal nSrcWidth As Integer, ByVal nSrcHeight As Integer, ByVal lpBits As Integer(), ByRef lpBitsInfo As BITMAPINFOHEADER, ByVal iUsage As Integer, ByVal dwRop As Integer) As Integer

        Private Const DIB_RGB_COLORS As Integer = 0
        Private Const SRCCOPY As Integer = &HCC0020 '13369376
        Private Const SRCAND As Integer = &H8800C6
        Private Const BI_RGB As Integer = 0
        Private Const GDI_ERROR As Integer = -1

        Private Structure BITMAPINFOHEADER
            Dim biSize As Int32
            Dim biWidth As Int32
            Dim biHeight As Int32
            Dim biPlanes As Int16
            Dim biBitCount As Int16
            Dim biCompression As Int32
            Dim biSizeImage As Int32
            Dim biXPelsPerMeter As Int32
            Dim biYPelsPerMeter As Int32
            Dim biClrUsed As Int32
            Dim biClrImportant As Int32
        End Structure

        'Private Structure RGBQUAD
        '    Dim rgbBlue As Integer
        '    Dim rgbGreen As Integer
        '    Dim rgbRed As Integer
        '    Dim rgbReserved As Integer
        'End Structure

        Private Structure BITMAPINFO
            Dim bmiHeader As BITMAPINFOHEADER
            'Dim bmiColors() As RGBQUAD
            Dim bmiColor0 As Long
            Dim bmiColor1 As Long
            Dim bmiColor2 As Long
        End Structure

        Private vdtBMPInfo As BITMAPINFO

        'MSX1
        Public vdtBuffer40(61440 - 1) As Integer   '320*192(40*8*24*8)(40*24=960Char)
        Public vdtBuffer46(46080 - 1) As Integer   '240*192(40*6*24*8)(40*24=960Char)'글자우측2Dot표시안함(가로로크게표시됨)
        Public vdtBuffer32(49152 - 1) As Integer   '256*192(32*8*24*8)(32*24=768Char)
        Public vdtBufferSpr(49152 - 1) As Integer    '256*192
        'MSX2
        Public vdtBuffer80(122880 - 1) As Integer  '640*192(80*8*24*8)(80*27=2160Char)
        Public vdtBuffer80p(135680 - 1) As Integer '640*212(80*8*26.5*8)(80*27=2160Char)
        Public vdtBuffer86(92160 - 1) As Integer   '480*192(80*6*24*8)(80*27=2160Char)'글자우측2Dot표시안함(가로로크게표시됨)
        Public vdtBuffer86p(101760 - 1) As Integer '480*212(80*6*26.5*8)(80*27=2160Char)'글자우측2Dot표시안함(가로로크게표시됨)
        Public vdtBuffer32p(54272 - 1) As Integer  '256*212(32*8*26.5*8)
        Public vdtBuffer64(98304 - 1) As Integer   '512*192(64*8*24*8)
        Public vdtBuffer64p(108544 - 1) As Integer '512*212(64*8*26.5*8)
        Public vdtBufferSpr2(54272 - 1) As Integer   '256*212

        Public Sub MSX_SCREEN_INIT()

            If (VDT.Gi_MSX_SCREEN_MODE = 0) Then
                If (MSX.GiCHAR = 0) Then
                    '40*24 (320*192)
                    'With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 320 '비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    '일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                Else
                    '40*24 (240*192)
                    'With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 240 '비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    '일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                End If
            End If

            If (VDT.Gi_MSX_SCREEN_MODE = 10) Then
                If (MSX.GiCHAR = 0) Then
                    '80*24/80*26.5 (640*192/640*212)
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640 '비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0
                        vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        '나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        '일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    Else
                        vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640 '비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -212 '비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0
                        vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        '나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        '일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    End If
                Else
                    '80*24/80*26.5 (480*192/480*212)
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0
                        vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    Else
                        vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -212 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0
                        vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                        vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    End If
                End If
            End If

            If ((VDT.Gi_MSX_SCREEN_MODE = 1) Or (VDT.Gi_MSX_SCREEN_MODE = 2) Or (VDT.Gi_MSX_SCREEN_MODE = 4) Or (VDT.Gi_MSX_SCREEN_MODE = 3)) Then
                '32*24 (256*192) / 16*12 (64*48)
                vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biWidth = 256 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                vdtBMPInfo.bmiHeader.biCompression = 0
                vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
            End If

            If ((VDT.Gi_MSX_SCREEN_MODE = 5) Or (VDT.Gi_MSX_SCREEN_MODE = 8)) Then
                '32*24/32*26vdtBMPInfo.bmiHeader.5 (256*192/256*212)
                If (VDT.MSX_VDT_REG_LN = 0) Then
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                Else
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                End If
            End If

            If ((VDT.Gi_MSX_SCREEN_MODE = 6) Or (VDT.Gi_MSX_SCREEN_MODE = 7)) Then
                '64*24/64*26vdtBMPInfo.bmiHeader.5 (512*192/512*212)
                If (VDT.MSX_VDT_REG_LN = 0) Then
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                Else
                    vdtBMPInfo.bmiHeader.biSize = 40 '표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512 '비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212 '비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1 '플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32 '몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0
                    vdtBMPInfo.bmiHeader.biSizeImage = 0 '비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0
                    vdtBMPInfo.bmiHeader.biClrUsed = 0 '팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0 '팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    '나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    '일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                End If
            End If

            'ReDim BmpInfo.bmiColors(255)
            'For i As Integer = 0 To 255
            '    vdtBMPInfo.bmiColors(i).rgbBlue = i
            '    vdtBMPInfo.bmiColors(i).rgbGreen = i
            '    vdtBMPInfo.bmiColors(i).rgbRed = i
            '    vdtBMPInfo.bmiColors(i).rgbReserved = 0
            'Next

            With vdtBMPInfo
                .bmiColor0 = 0
                .bmiColor1 = 0
                .bmiColor2 = 0
            End With

        End Sub

        Public Sub MSX_SCREEN_DISP()

            'If (Gi_MSX_Screen_Out = 1) And (Gi_MSX_Timer_16_VDP = 1) Then
            If ((MSX.Gi_MSX_Execute = 1) And (MSX.Gi_MSX_Timer_16_VDP = 1)) Then
                VDT.Gi_MSX_Screen_Out = 0
                MSX.Gi_MSX_Timer_16_VDP = 0
                If ((VDT.Gi_MSX_SCREEN_MODE <> VDT.Gi_MSX_Screen_Mode_Prv) Or ((VDT.Gi_MSX_SCREEN_MODE >= 5) And (VDT.MSX_VDT_REG_LN <> VDT.Gi_MSX_VDT_Reg_LN_Prv))) Then
                    Call MSX_SCREEN_INIT()
                    VDT.Gi_MSX_Screen_Mode_Prv = VDT.Gi_MSX_SCREEN_MODE
                    VDT.Gi_MSX_VDT_Reg_LN_Prv = VDT.MSX_VDT_REG_LN
                End If
                If (VDT.Gi_MSX_SCREEN_MODE = 0) Then Call MSX_SCREEN_0_DISP() 'TEXT MODE - 40*24문자*2색
                If (VDT.Gi_MSX_SCREEN_MODE = 1) Then Call MSX_SCREEN_1_DISP() 'GRAPHIC1 MODE - 32*24문자*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 2) Then Call MSX_SCREEN_2_DISP() 'GRAPHIC2 MODE - 256*192도트*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 3) Then Call MSX_SCREEN_3_DISP() 'MULTI COLOR MODE - 64*48도트*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 10) Then Call MSX_SCREEN_10_DISP() 'TEXT2 MODE - 80*24문자*2색
                If (VDT.Gi_MSX_SCREEN_MODE = 4) Then Call MSX_SCREEN_4_DISP() 'GRAPHIC3 MODE - 256*192도트*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 5) Then Call MSX_SCREEN_5_DISP() 'GRAPHIC4 MODE - 256*212도트*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 6) Then Call MSX_SCREEN_6_DISP() 'GRAPHIC5 MODE - 512*212도트*4색
                If (VDT.Gi_MSX_SCREEN_MODE = 7) Then Call MSX_SCREEN_7_DISP() 'GRAPHIC6 MODE - 512*212도트*16색
                If (VDT.Gi_MSX_SCREEN_MODE = 8) Then Call MSX_SCREEN_8_DISP() 'GRAPHIC7 MODE - 256*212도트*256색
            End If

        End Sub

        'SCREEN 0(40), TEXT MODE - 40*24문자*2색
        Public Sub MSX_SCREEN_0_DISP()

            Dim i As Integer, j As Integer, k As Integer, L As Integer
            Dim C As Integer, b As Integer, P As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            If (MSX.GiMSX2 = 0) Then 'MSX1
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 7) 'R4:(?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 15) 'R2:(????AAAA)+0000000000, 0400h
            Else 'MSX2
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 63) 'R4:(??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 127) 'R2:(?AAAAAAA)+0000000000, 0400h
            End If

            VDT.Gi_MSX_ForeColor = TBL.Gi_D_Table16(VDT.MSX_VDT_REG(7) And &HF0)
            VDT.Gi_MSX_BackColor = (VDT.MSX_VDT_REG(7) And &HF)
            VDT.Gi_MSX_OutColor = VDT.Gi_MSX_BackColor
            If (VDT.Gi_MSX_OutColor = 0) Then VDT.Gi_MSX_OutColor = 4 '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            If (MSX.GiCHAR = 0) Then

                '61440:320*192(40*8*24*8),960:40*24
                If (VDT.MSX_VDT_REG_ON = 1) Then
                    For i = 0 To (960 - 1) '화면 Char 표시
                        C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                        P = TBL.Go_T_VRamTable(i)
                        For j = 0 To 7 '폰트
                            b = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j) '해당문자Font테이블8Byte
                            For k = 1 To 8
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                    vdtBuffer40(P + k - 1) = VDT.Go_MSX_Color(VDT.Gi_MSX_ForeColor)
                                Else
                                    vdtBuffer40(P + k - 1) = VDT.Go_MSX_Color(VDT.Gi_MSX_BackColor)
                                End If
                            Next k
                            P = P + 320 '1Line320Dot
                        Next j
                    Next i
                Else
                    For L = 0 To (61440 - 1) '화면 Clear
                        vdtBuffer40(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                    Next L
                End if

                StretchDIBits(Grp.GetHdc(), 11, 12, (320 * 2.94), (192 * 3.6), 0, 0, 320, 192, vdtBuffer40, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh()

            Else

                '46080:240*192(40*6*24*8),960:40*24
                If (VDT.MSX_VDT_REG_ON = 1) Then
                    For i = 0 To (960 - 1) '화면 Char 표시
                        C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                        P = TBL.Go_T_VRamTable(i)
                        For j = 0 To 7 '폰트
                            b = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j) '해당문자Font테이블8Byte
                            For k = 1 To 6
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                    vdtBuffer46(P + k - 1) = VDT.Go_MSX_Color(VDT.Gi_MSX_ForeColor)
                                Else
                                    vdtBuffer46(P + k - 1) = VDT.Go_MSX_Color(VDT.Gi_MSX_BackColor)
                                End If
                            Next k
                            P = P + 240 '1Line240Dot
                        Next j
                    Next i
                Else
                    For L = 0 To (46080 - 1) '화면 Clear
                        vdtBuffer46(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                    Next L
                End If

                StretchDIBits(Grp.GetHdc(), 13, 12, (240 * 3.9), (192 * 3.6), 0, 0, 240, 192, vdtBuffer46, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh()

            End If 

            'StretchDIBits
            '  HDC hdc - Grp.GetHdc(), '출력 대상(윈도우)의 Device Context Handle 값
            '  int XDest - '출력 대상(윈도우)의 좌표 상단 X좌표
            '  int YDest - '출력 대상(윈도우)의 좌표 상단 Y좌표
            '  int nDestWidth - '출력 대상(윈도우)의(XDest) 좌표로부터 너비
            '  int nDestHeight - '출력 대상(윈도우)의(YDest) 좌표로부터 높이
            '  int XSrc - '출력할 DIB 영상의 좌측 상단 X좌표
            '  int YScr - '출력할 DIB 영상의 좌측 상단 Y좌표
            '  int nScrWidth - '출력할 DIB 영상의 XSrc 좌표로부터 너비
            '  int nScrHeight - '출력할 DIB 영상의 XSrc 좌표로부터 높이
            '  const sub *lpBits - vdtBuffer40(0), 'Pixel Data 영역의 시작 메모리 주소
            '  const BITMAPINFO *lpBitsInfo - vdtBMPInfo, 'BITMAPINFO 구조체 영역의 시작 메모리 주소
            '  UNIT iUsage - 'DIB 영상을 출력할 시, Color Table/Palette의 사용 방식을 지정
            '  DWORD dwRop - SRCCOPY 'ROP(Raster-Operation) 연산방식을 지정

        End Sub

        'SCREEN 0(80), TEXT2 MODE - 80*24문자*2색
        Public Sub MSX_SCREEN_10_DISP()

            Dim i As Integer, j As Integer, k As Integer, L As Integer
            Dim C As Integer, b As Integer, P As Integer
            Dim iForeColor As Integer, iBackColor As Integer
            Dim N As Integer, Nc As Integer, Np As Integer
            Dim PK As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 63) 'R4:(??AAAAAA)+00000000000, 0800h - TEXT1 동일
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table4096(TBL.Gi_D_Table4(VDT.MSX_VDT_REG(2) And 127)) 'R2:(?AAAAA11)+000000000000, 1000h
            VDT.Go_MSX_SCR_BLNK_ADDR = TBL.Gi_M_Table32(VDT.MSX_VDT_REG(10) And 7) + TBL.Gi_D_Table8(VDT.MSX_VDT_REG(3)) 'R3 :(AAAAA???)+000000000
            VDT.Go_MSX_SCR_BLNK_ADDR = TBL.Go_M_Table512(VDT.Go_MSX_SCR_BLNK_ADDR) 'R10:(?????AAA)
            VDT.Gi_MSX_ForeColor = TBL.Gi_D_Table16(VDT.MSX_VDT_REG(7) And &HF0)
            VDT.Gi_MSX_BackColor = (VDT.MSX_VDT_REG(7) And &HF)
            VDT.Gi_MSX_OutColor = VDT.Gi_MSX_BackColor
            If (VDT.Gi_MSX_OutColor = 0) Then VDT.Gi_MSX_OutColor = 4 '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)
            VDT.Gi_MSX_ForeColor_Blink = TBL.Gi_D_Table16(VDT.MSX_VDT_REG(12) And &HF0)
            VDT.Gi_MSX_BackColor_Blink = (VDT.MSX_VDT_REG(12) And &HF)
            VDT.Gi_MSX_Blink_Time_Bl = TBL.Gi_D_Table16(VDT.MSX_VDT_REG(13) And &HF0) 'Bl/6초
            VDT.Gi_MSX_Blink_Time_Co = (VDT.MSX_VDT_REG(13) And &HF) 'Co/6초

            If (MSX.GiCHAR = 0) Then

                '122880:640*192(80*8*24*8),  2160(80*27)
                '135680:640*212(80*8*26.5*8),2160(80*27)
                Nc = 0 : Np = 7
                If (VDT.MSX_VDT_REG_ON = 1) Then

                    For i = 0 To (2160 - 1) '화면 Char 표시
                        C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                        N = VDT.MSX_VRAM(VDT.Go_MSX_SCR_BLNK_ADDR + Nc)
                        If (((N And TBL.Gi_B_Table(Np)) = 0) Or (VDT.Gi_MSX_Blink_Time_Bl = 0)) Then
                            'Normal
                            iForeColor = VDT.Gi_MSX_ForeColor
                            iBackColor = VDT.Gi_MSX_BackColor
                        Else
                            'Blink
                            iForeColor = VDT.Gi_MSX_ForeColor_Blink
                            iBackColor = VDT.Gi_MSX_BackColor_Blink
                        End If
                        P = TBL.Go_T2_VRamTable(i)
                        For j = 0 To 7 '폰트
                            b = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j) '해당문자Font테이블8Byte
                            For k = 1 To 8
                                PK = P + k - 1
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                    If (VDT.MSX_VDT_REG_LN = 0) Then
                                        If (PK < 122880) Then vdtBuffer80(PK) = VDT.Go_MSX_Color(iForeColor)
                                    Else
                                        If (PK < 135680) Then vdtBuffer80p(PK) = VDT.Go_MSX_Color(iForeColor)
                                    End If
                                Else
                                    If (VDT.MSX_VDT_REG_LN = 0) Then
                                        If (PK < 122880) Then vdtBuffer80(PK) = VDT.Go_MSX_Color(iBackColor)
                                    Else
                                        If (PK < 135680) Then vdtBuffer80p(PK) = VDT.Go_MSX_Color(iBackColor)
                                    End If
                                    End If
                              Next k
                            P = P + 640 '1Line640Dot
                        Next j
                        Np = Np - 1 : If (Np < 0) Then Nc = Nc + 1 : Np = 7
                    Next i

                Else

                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        For L = 0 To (122880 - 1) '화면 Clear
                            vdtBuffer80(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                        Next L
                    Else
                        For L = 0 To (135680 - 1) '화면 Clear
                            vdtBuffer80p(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                        Next L
                    End If

                End If

                If (VDT.MSX_VDT_REG_LN = 0) Then
                    StretchDIBits(Grp.GetHdc(), 11, 12, (640 * 1.47), (192 * 3.6), 0, 0, 640, 192, vdtBuffer80, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                    'Pic.Refresh();
                Else
                    StretchDIBits(Grp.GetHdc(), 11, 12, (640 * 1.47), (212 * 3.25), 0, 0, 640, 212, vdtBuffer80p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                    'Pic.Refresh();
                End If

            Else

                ' 92160:480*192(80*6*24*8),  2160(80*27)
                '101760:480*212(80*6*26.5*8),2160(80*27)
                Nc = 0 : Np = 7
                If (VDT.MSX_VDT_REG_ON = 1) Then

                    For i = 0 To (2160 - 1) '화면 Char 표시
                        C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                        N = VDT.MSX_VRAM(VDT.Go_MSX_SCR_BLNK_ADDR + Nc)
                        If (((N And TBL.Gi_B_Table(Np)) = 0) Or (VDT.Gi_MSX_Blink_Time_Bl = 0)) Then
                            'Normal
                            iForeColor = VDT.Gi_MSX_ForeColor
                            iBackColor = VDT.Gi_MSX_BackColor
                        Else
                            'Blink
                            iForeColor = VDT.Gi_MSX_ForeColor_Blink
                            iBackColor = VDT.Gi_MSX_BackColor_Blink
                        End If
                        P = TBL.Go_T2_VRamTable(i)
                        For j = 0 To 7 '폰트
                            b = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j) '해당문자Font테이블8Byte
                            For k = 1 To 6
                                PK = P + k - 1
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                    If (VDT.MSX_VDT_REG_LN = 0) Then
                                        If (PK < 92160) Then vdtBuffer86(PK) = VDT.Go_MSX_Color(iForeColor)
                                    Else
                                        If (PK < 101760) Then vdtBuffer86p(PK) = VDT.Go_MSX_Color(iForeColor)
                                    End If
                                Else
                                    If (VDT.MSX_VDT_REG_LN = 0) Then
                                        If (PK < 92160) Then vdtBuffer86(PK) = VDT.Go_MSX_Color(iBackColor)
                                    Else
                                        If (PK < 101760) Then vdtBuffer86p(PK) = VDT.Go_MSX_Color(iBackColor)
                                    End If
                                End If
                            Next k
                            P = P + 480 '1Line480Dot
                        Next j
                        Np = Np - 1 : If (Np < 0) Then Nc = Nc + 1 : Np = 7
                    Next i

                Else

                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        For L = 0 To (92160 - 1) '화면 Clear
                            vdtBuffer86(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                        Next L
                    Else
                        For L = 0 To (101760 - 1) '화면 Clear
                            vdtBuffer86p(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                        Next L
                    End If

                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        StretchDIBits(Grp.GetHdc(), 11, 12, (480 * 1.96), (192 * 3.6), 0, 0, 480, 192, vdtBuffer86, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                        'Pic.Refresh();
                    Else
                        StretchDIBits(Grp.GetHdc(), 11, 12, (480 * 1.96), (212 * 3.25), 0, 0, 480, 212, vdtBuffer86p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                        'Pic.Refresh();
                    End If

                End If

            End If

        End Sub

        'SCREEN 1, GRAPHIC1 MODE - 32*24문자*16색
        Public Sub MSX_SCREEN_1_DISP()

            Dim i As Integer, j As Integer, k As Integer, L As Integer
            Dim C As Integer, b As Integer, O As Integer, P As Integer

            Dim MSX_ForeColor As Integer
            Dim MSX_BackColor As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            If (MSX.GiMSX2 = 0) Then 'MSX1
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 7) 'R4: (?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 15) 'R2: (????AAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Gi_M_Table64(VDT.MSX_VDT_REG(3)) 'R3: (AAAAAAAA)+000000, 0040h
            Else 'MSX2
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 63) 'R4: (??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 127) 'R2: (?AAAAAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Gi_M_Table64(VDT.MSX_VDT_REG(3)) 'R3: (AAAAAAAA)+000000, 0040h
                VDT.Go_MSX_SCR_COLR_ADDR = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Go_M_Table16384(VDT.MSX_VDT_REG(10) And 7) 'R10:(?????AAA)+AAAAAAAA000000. 4???h
            End If

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            '49152:256*192(32*8*24*8),768:32*24
            If (VDT.MSX_VDT_REG_ON = 1) Then

                For i = 0 To (768 - 1) '화면 Char 표시
                    C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                    O = VDT.MSX_VRAM(VDT.Go_MSX_SCR_COLR_ADDR + TBL.Gi_D_Table8(C)) '해당문자Color테이블8Byte
                    MSX_ForeColor = TBL.Gi_MSX_ForeColors(O)
                    MSX_BackColor = TBL.Gi_MSX_BackColors(O)
                    If (MSX_ForeColor = 0) Then MSX_ForeColor = VDT.Gi_MSX_OutColor
                    If (MSX_BackColor = 0) Then MSX_BackColor = VDT.Gi_MSX_OutColor
                    P = TBL.Go_G_VRamTable(i)
                    For j = 0 To 7 '폰트
                        b = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j) '해당문자Font테이블8Byte
                        For k = 1 To 8
                            If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                vdtBuffer32(P + k - 1) = VDT.Go_MSX_Color(MSX_ForeColor)
                            Else
                                vdtBuffer32(P + k - 1) = VDT.Go_MSX_Color(MSX_BackColor)
                            End If
                        Next k
                        P = P + 256 '1Line256Dot
                    Next j
                Next i

                Call VDTSPR.MSX_SPRITE_DISP()

            Else

                For L = 0 To (49152 - 1) '화면 Clear
                    vdtBuffer32(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                Next L

            End If

            StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (192 * 3.6), 0, 0, 256, 192, vdtBuffer32, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
            'Pic.Refresh();

        End Sub

        'SCREEN 2, GRAPHIC2 MODE - 256*192도트*16색
        Public Sub MSX_SCREEN_2_DISP()

            Dim i As Integer, j As Integer, k As Integer, L As Integer
            Dim C As Integer, b As Integer, O As Integer, P As Integer

            Dim oAddr1 As Integer, oAddr2 As Integer
            Dim MSX_ForeColor As Integer
            Dim MSX_BackColor As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            If (MSX.GiMSX2 = 0) Then 'MSX1
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table8192(TBL.Gi_D_Table4(VDT.MSX_VDT_REG(4) And 4)) 'R4: (?????A11)+0000000000000, 2000h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 15) 'R2: (????AAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Go_M_Table8192(TBL.Gi_D_Table128(VDT.MSX_VDT_REG(3) And 128)) 'R3: (A1111111)+0000000000000, 2000h
            Else 'MSX2
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table8192(TBL.Gi_D_Table4(VDT.MSX_VDT_REG(4) And 63)) 'R4: (??AAAA11)+0000000000000, 2000h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 127) 'R2: (?AAAAAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Go_M_Table8192(TBL.Gi_D_Table128(VDT.MSX_VDT_REG(3) And 128)) 'R3: (A1111111)+0000000000000, 2000h
                VDT.Go_MSX_SCR_COLR_ADDR = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Go_M_Table16384(VDT.MSX_VDT_REG(10) And 7) 'R10:(?????AAA)+AAAAAAAA000000. 4???h
            End If

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            '49152:256*192(32*8*24*8),768:32*24
            If (VDT.MSX_VDT_REG_ON = 1) Then

                For i = 0 To (768 - 1) '화면 Char 표시
                    C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                    P = TBL.Go_G_VRamTable(i)
                    For j = 0 To 7 '폰트
                        oAddr1 = VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C) + j
                        oAddr2 = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Gi_M_Table8(C) + j
                        If (i >= 256) Then oAddr1 = oAddr1 + 2048 : oAddr2 = oAddr2 + 2048 '256*8
                        If (i >= 512) Then oAddr1 = oAddr1 + 2048 : oAddr2 = oAddr2 + 2048 '256*8
                        b = VDT.MSX_VRAM(oAddr1) '해당문자Font테이블8Byte
                        O = VDT.MSX_VRAM(oAddr2) '해당문자Color테이블8Byte
                        MSX_ForeColor = TBL.Gi_MSX_ForeColors(O)
                        MSX_BackColor = TBL.Gi_MSX_BackColors(O)
                        If (MSX_ForeColor = 0) Then MSX_ForeColor = VDT.Gi_MSX_OutColor
                        If (MSX_BackColor = 0) Then MSX_BackColor = VDT.Gi_MSX_OutColor
                        For k = 1 To 8
                            If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then
                                vdtBuffer32(P + k - 1) = VDT.Go_MSX_Color(MSX_ForeColor)
                            Else
                                vdtBuffer32(P + k - 1) = VDT.Go_MSX_Color(MSX_BackColor)
                            End If
                        Next k
                        P = P + 256 '1Line256Dot
                    Next j
                Next i

                If (VDT.Gi_MSX_SCREEN_MODE = 2) Then
                    Call VDTSPR.MSX_SPRITE_DISP()
                Else
                    Call VDTSPR.MSX_SPRITE_2_DISP(0)
                End If

            Else

                For L = 0 To (49152 - 1) '화면 Clear
                    vdtBuffer32(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                Next L

            End If

            StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (192 * 3.6), 0, 0, 256, 192, vdtBuffer32, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
            'Pic.Refresh();

        End Sub

        'SCREEN 3, MULTI COLOR MODE - 32*24블록,64*48도트,(256*192)*16색
        Public Sub MSX_SCREEN_3_DISP()

            Dim i As Integer, L As Integer, C As Integer, O As Integer, Co As Integer, Ch As Integer, Cl As Integer
            Dim X As Integer, Y As Integer, Z As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            If (MSX.GiMSX2 = 0) Then 'MSX1
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 7) 'R4: (?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 15) 'R2: (????AAAA)+0000000000, 0400h
            Else 'MSX2
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(4) And 63) 'R4: (??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024(VDT.MSX_VDT_REG(2) And 127) 'R2: (?AAAAAAA)+0000000000, 0400h
            End If

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            '32*24블록,64*48도트
            If (VDT.MSX_VDT_REG_ON = 1) Then

                For i = 0 To 767
                    C = VDT.MSX_VRAM(VDT.Go_MSX_SCR_CHAR_ADDR + i)
                    O = VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8(C)
                    'X(32)*Y(24)블록구하기
                    Y = TBL.Gi_D_Table32(i)
                    X = i Mod 32
                    Z = TBL.Gi_M_Table2(Y Mod 4)
                    '블록표시,32*24->64*48
                    X = TBL.Gi_M_Table2(X) '0,2,4~62
                    Y = TBL.Gi_M_Table2(Y) '0,2,4~46
                    Co = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + O + Z)
                    Ch = TBL.Gi_D_Table16(Co And &HF0) '좌
                    Cl = Co And &HF '우
                    ft_MSX_SCREEN_3_PSet(X + 0, Y + 0, VDT.Go_MSX_Color(Ch)) '좌(상)
                    ft_MSX_SCREEN_3_PSet(X + 1, Y + 0, VDT.Go_MSX_Color(Cl)) '우(상)
                    Co = VDT.MSX_VRAM(VDT.Go_MSX_SCR_FONT_ADDR + O + Z + 1)
                    Ch = TBL.Gi_D_Table16(Co And &HF0) '좌
                    Cl = Co And &HF '우
                    ft_MSX_SCREEN_3_PSet(X + 0, Y + 1, VDT.Go_MSX_Color(Ch)) '좌(하)
                    ft_MSX_SCREEN_3_PSet(X + 1, Y + 1, VDT.Go_MSX_Color(Cl)) '우(하)
                Next i

            Else

                For L = 0 To (49152 - 1) '화면 Clear
                    vdtBuffer32(L) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor) '화면을배경색으로채움
                Next L

            End If

            Call VDTSPR.MSX_SPRITE_DISP()

            StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (192 * 3.6), 0, 0, 256, 192, vdtBuffer32, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
            'Pic.Refresh();

        End Sub

        Public Sub ft_MSX_SCREEN_3_PSet(ByVal X As Integer, ByVal Y As Integer, ByVal C As Integer)

            Dim i As Integer, L As Integer, L2 As Integer

            '64*48->256*192
            L = TBL.Go_M_Table256(TBL.Gi_M_Table4(Y)) + TBL.Gi_M_Table4(X)

            For i = 0 To 3 '0~3Col
                L2 = L + i
                vdtBuffer32(L2) = C       '0Line
                vdtBuffer32(L2 + 256) = C '1Line
                vdtBuffer32(L2 + 512) = C '2Line
                vdtBuffer32(L2 + 768) = C '3Line
            Next i

        End Sub

        'SCREEN 4, GRAPHIC3 MODE - 256*192도트*16색
        Public Sub MSX_SCREEN_4_DISP()

            Call MSX_SCREEN_2_DISP()

        End Sub

        'SCREEN 5, GRAPHIC4 MODE - 256*212도트*16색
        Public Sub MSX_SCREEN_5_DISP()

            Dim i As Integer, L As Integer, L1 As Integer, L2 As Integer, Lx As Integer
            Dim Lt As Integer, F As Integer, C As Integer
            Dim iLine As Integer, iLineDsp As Integer, iLineFlg As Integer

            Dim MSX_ForeColor As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            'VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 127)) 'R2: (?AA11111)+000000000000000, 8000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(VDT.Gi_MSX_Graphic_Page) '0~3 * 8000h

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                Lt = 49152 - 1 '256*192
            Else
                Lt = 54272 - 1 '256*212
            End If

            iLine = 0 : iLineFlg = 0
            If (VDT.MSX_VDT_REG_ON = 1) Then

                F = 0
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR
                L2 = TBL.Go_M_Table128(VDT.MSX_VDT_REG(23))
                L = L1 + L2 : Lx = L1 + 32767
                For i = 0 To Lt
                    C = VDT.MSX_VRAM(L)
                    If (F = 0) Then
                        MSX_ForeColor = TBL.Gi_D_Table16(C And &HF0)
                        F = 1
                    Else
                        MSX_ForeColor = C And &HF
                        F = 0
                        L = L + 1
                        If (L > Lx) Then L = L - 32768
                    End If
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer32(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer32(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    Else
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer32p(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer32p(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    End If
                    iLineFlg = iLineFlg + 1
                    If (iLineFlg = 256) Then
                        If (VDT.MSX_VDT_REG_IE1 = 1) Then
                            iLineDsp = VDT.MSX_VDT_REG(23) + iLine
                            If (iLineDsp > 255) Then iLineDsp = iLineDsp - 256
                            If (iLineDsp = (VDT.MSX_VDT_REG(19) + 3)) Then VDT.MSX_VDT_ST_REG_FH = 1 : GoTo SpriteProc 'R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        End If
                        iLineFlg = 0
                        iLine = iLine + 1
                        L1 = TBL.Go_M_Table32768(VDT.Gi_MSX_Graphic_Page)
                        L2 = TBL.Go_M_Table128(VDT.MSX_VDT_REG(23) + iLine)
                        L = L1 + L2 : Lx = L1 + 32767
                        If (L > Lx) Then L = L - 32768
                    End If
                Next i

            Else

                For i = 0 To Lt
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBuffer32(i) = 0
                    Else
                        vdtBuffer32p(i) = 0
                    End If
                Next i

            End If

SpriteProc:
            Call VDTSPR.MSX_SPRITE_2_DISP(VDT.MSX_VDT_REG_LN)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (192 * 3.6), 0, 0, 256, 192, vdtBuffer32, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            Else
                StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (212 * 3.25), 0, 0, 256, 212, vdtBuffer32p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            End If

        End Sub

        'SCREEN 6, GRAPHIC5 MODE - 512*212도트*4색
        Public Sub MSX_SCREEN_6_DISP()

            Dim i As Integer, L As Integer, L1 As Integer, L2 As Integer, Lx As Integer
            Dim Lt As Integer, F As Integer, C As Integer
            Dim iLine As Integer, iLineDsp As Integer, iLineFlg As Integer

            Dim MSX_ForeColor As Integer = 0

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            'VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 127)) 'R2: (?AA11111)+000000000000000, 8000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(VDT.Gi_MSX_Graphic_Page) '0~3 * 8000h

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                Lt = 98304 - 1 '512*192
            Else
                Lt = 108544 - 1 '512*212
            End If

            iLine = 0 : iLineFlg = 0
            If (VDT.MSX_VDT_REG_ON = 1) Then

                F = 0
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR
                L2 = TBL.Go_M_Table128(VDT.MSX_VDT_REG(23))
                L = L1 + L2 : Lx = L1 + 32767
                For i = 0 To Lt
                    C = VDT.MSX_VRAM(L)
                    If (F = 0) Then MSX_ForeColor = TBL.Gi_D_Table64(C And 192)
                    If (F = 1) Then MSX_ForeColor = TBL.Gi_D_Table16(C And 48)
                    If (F = 2) Then MSX_ForeColor = TBL.Gi_D_Table4(C And 12)
                    If (F = 3) Then MSX_ForeColor = (C And 3)
                    F = F + 1
                    If (F = 4) Then
                        F = 0
                        L = L + 1
                        If (L > Lx) Then L = L - 32768
                    End If
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer64(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer64(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    Else
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer64p(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer64p(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    End If
                    iLineFlg = iLineFlg + 1
                    If (iLineFlg = 512) Then
                        If (VDT.MSX_VDT_REG_IE1 = 1) Then
                            iLineDsp = VDT.MSX_VDT_REG(23) + iLine
                            If (iLineDsp > 255) Then iLineDsp = iLineDsp - 256
                            If (iLineDsp = (VDT.MSX_VDT_REG(19) + 3)) Then VDT.MSX_VDT_ST_REG_FH = 1 : GoTo SpriteProc 'R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        End If
                        iLineFlg = 0
                        iLine = iLine + 1
                        L1 = TBL.Go_M_Table32768(VDT.Gi_MSX_Graphic_Page)
                        L2 = TBL.Go_M_Table128(VDT.MSX_VDT_REG(23) + iLine)
                        L = L1 + L2 : Lx = L1 + 32767
                        If (L > Lx) Then L = L - 32768
                    End If
                Next i

            Else

                For i = 0 To Lt
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBuffer64(i) = 0
                    Else
                        vdtBuffer64p(i) = 0
                    End If
                Next i

            End If

SpriteProc:
            Call VDTSPR.MSX_SPRITE_2_DISP(VDT.MSX_VDT_REG_LN)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                StretchDIBits(Grp.GetHdc(), 11, 12, (512 * 1.84), (192 * 3.6), 0, 0, 512, 192, vdtBuffer64, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            Else
                StretchDIBits(Grp.GetHdc(), 11, 12, (512 * 1.84), (212 * 3.25), 0, 0, 512, 212, vdtBuffer64p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            End If

        End Sub

        'SCREEN 7, GRAPHIC6 MODE - 512*212도트*16색
        Public Sub MSX_SCREEN_7_DISP()

            Dim i As Integer, L As Integer, L1 As Integer, L2 As Integer, Lx As Integer
            Dim Lt As Integer, F As Integer, C As Integer
            Dim iLine As Integer, iLineDsp As Integer, iLineFlg As Integer

            Dim MSX_ForeColor As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            'VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 63)) 'R2: (??A11111)+0000000000000000, 10000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(VDT.Gi_MSX_Graphic_Page) '0~1 * 10000h

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                Lt = 98304 - 1 '512*192
            Else
                Lt = 108544 - 1 '512*212
            End If

            iLine = 0 : iLineFlg = 0
            If (VDT.MSX_VDT_REG_ON = 1) Then

                F = 0
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR
                L2 = TBL.Go_M_Table256(VDT.MSX_VDT_REG(23))
                L = L1 + L2 : Lx = L1 + 65535
                For i = 0 To Lt
                    C = VDT.MSX_VRAM(L)
                    If (F = 0) Then
                        MSX_ForeColor = TBL.Gi_D_Table16(C And &HF0)
                        F = 1
                    Else
                        MSX_ForeColor = C And &HF
                        F = 0
                        L = L + 1
                        If (L > Lx) Then L = L - 65536
                    End If
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer64(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer64(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    Else
                        If ((VDT.MSX_VDT_REG_TP = 0) And (MSX_ForeColor = 0)) Then
                            vdtBuffer64p(i) = VDT.Go_MSX_Color(VDT.Gi_MSX_OutColor)
                        Else
                            vdtBuffer64p(i) = VDT.Go_MSX_Color(MSX_ForeColor)
                        End If
                    End If
                    iLineFlg = iLineFlg + 1
                    If (iLineFlg = 512) Then
                        If (VDT.MSX_VDT_REG_IE1 = 1) Then
                            iLineDsp = VDT.MSX_VDT_REG(23) + iLine
                            If (iLineDsp > 255) Then iLineDsp = iLineDsp - 256
                            If (iLineDsp = (VDT.MSX_VDT_REG(19) + 3)) Then VDT.MSX_VDT_ST_REG_FH = 1 : GoTo SpriteProc 'R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        End If
                        iLineFlg = 0
                        iLine = iLine + 1
                        L1 = TBL.Go_M_Table65536(VDT.Gi_MSX_Graphic_Page)
                        L2 = TBL.Go_M_Table256(VDT.MSX_VDT_REG(23) + iLine)
                        L = L1 + L2 : Lx = L1 + 65535
                        If (L > Lx) Then L = L - 65536
                    End If
                Next i

            Else

                For i = 0 To Lt
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBuffer64(i) = 0
                    Else
                        vdtBuffer64p(i) = 0
                    End If
                Next i

            End If

SpriteProc:
            Call VDTSPR.MSX_SPRITE_2_DISP(VDT.MSX_VDT_REG_LN)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                StretchDIBits(Grp.GetHdc(), 11, 12, (512 * 1.84), (192 * 3.6), 0, 0, 512, 192, vdtBuffer64, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            Else
                StretchDIBits(Grp.GetHdc(), 11, 12, (512 * 1.84), (212 * 3.25), 0, 0, 512, 212, vdtBuffer64p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            End If

        End Sub

        'SCREEN 8, GRAPHIC7 MODE - 256*212도트*256색
        Public Sub MSX_SCREEN_8_DISP()

            Dim i As Integer, L As Integer, L1 As Integer, L2 As Integer, Lx As Integer
            Dim Lt As Integer, C As Integer
            Dim iLine As Integer, iLineDsp As Integer, iLineFlg As Integer

            Dim MSX_ForeColor As Integer
            Dim Color_Green As Integer
            Dim Color_Red As Integer
            Dim Color_Blue As Integer

            Dim Frm = vnMSX2Frm
            Dim Pic = vnMSX2Frm.Controls("ScrnMSX")
            Dim Grp = Pic.CreateGraphics

            'VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 63)) 'R2: (??A11111)+0000000000000000, 10000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(VDT.Gi_MSX_Graphic_Page) '0~1 * 10000h

            VDT.Gi_MSX_OutColor = (VDT.MSX_VDT_REG(7) And &HF)
            'if (VDT.Gi_MSX_OutColor = 0) VDT.Gi_MSX_OutColor = 4; '파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB(VDT.Gi_MSX_OutColor)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                Lt = 49152 - 1 '256*192
            Else
                Lt = 54272 - 1 '256*212
            End If

            iLine = 0 : iLineFlg = 0
            If (VDT.MSX_VDT_REG_ON = 1) Then

                L1 = VDT.Go_MSX_SCR_CHAR_ADDR
                L2 = TBL.Go_M_Table256(VDT.MSX_VDT_REG(23))
                L = L1 + L2 : Lx = L1 + 65535
                For i = 0 To Lt
                    C = VDT.MSX_VRAM(L)
                    L = L + 1
                    If (L > Lx) Then L = L - 65536
                    Color_Green = TBL.Gi_D_Table32(C And 224) '11100000
                    Color_Red = TBL.Gi_D_Table4(C And 28)     '00011100
                    Color_Blue = TBL.Gi_M_Table2(C And 3)     '00000011*
                    Color_Green = TBL.Gi_M_Table36(Color_Green)
                    Color_Red = TBL.Gi_M_Table36(Color_Red)
                    Color_Blue = TBL.Gi_M_Table36(Color_Blue)
                    'MSX_ForeColor = (int)FN.goRGB((byte)Color_Blue, (byte)Color_Green, (byte)Color_Red); 'VB6
                    MSX_ForeColor = FN.goRGB(Color_Red, Color_Green, Color_Blue)
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBuffer32(i) = MSX_ForeColor
                    Else
                        vdtBuffer32p(i) = MSX_ForeColor
                    End If
                    iLineFlg = iLineFlg + 1
                    If (iLineFlg = 256) Then
                        If (VDT.MSX_VDT_REG_IE1 = 1) Then
                            iLineDsp = VDT.MSX_VDT_REG(23) + iLine
                            If (iLineDsp > 255) Then iLineDsp = iLineDsp - 256
                            If (iLineDsp = (VDT.MSX_VDT_REG(19) + 3)) Then VDT.MSX_VDT_ST_REG_FH = 1 : GoTo SpriteProc 'R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        End If
                        iLineFlg = 0
                        iLine = iLine + 1
                        L1 = TBL.Go_M_Table65536(VDT.Gi_MSX_Graphic_Page)
                        L2 = TBL.Go_M_Table256(VDT.MSX_VDT_REG(23) + iLine)
                        L = L1 + L2 : Lx = L1 + 65535
                        If (L > Lx) Then L = L - 65536
                    End If
                Next i

            Else

                For i = 0 To Lt
                    If (VDT.MSX_VDT_REG_LN = 0) Then
                        vdtBuffer32(i) = 0
                    Else
                        vdtBuffer32p(i) = 0
                    End If
                Next i

            End If

SpriteProc:
            Call VDTSPR.MSX_SPRITE_2_DISP(VDT.MSX_VDT_REG_LN)

            If (VDT.MSX_VDT_REG_LN = 0) Then
                StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (192 * 3.6), 0, 0, 256, 192, vdtBuffer32, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            Else
                StretchDIBits(Grp.GetHdc(), 11, 12, (256 * 3.68), (212 * 3.25), 0, 0, 256, 212, vdtBuffer32p, vdtBMPInfo.bmiHeader, DIB_RGB_COLORS, SRCCOPY)
                'Pic.Refresh();
            End If

        End Sub
    End Module

End Namespace
