﻿Namespace VDTSPR

    Module msxVDT_SPRITE

        '소프라이트
        Public Sub MSX_SPRITE_DISP()

            Dim i As Integer, j As Integer, k As Integer, M As Integer, L As Integer
            Dim V As Integer, b As Integer, P As Integer, Ps As Integer, sf As Integer
            Dim Sy As Integer, Sx As Integer, Sc As Integer, FC As Integer, EC As Integer, Xp As Integer
            Dim Vpm(4 - 1) As Integer
            Dim Syy(4 - 1) As Integer
            Dim Sxx(4 - 1) As Integer

            VDT.Go_MSX_SPR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(6) And 7)  'R6:(?????AAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
            VDT.Go_MSX_SPR_ATRB_ADDR = TBL.Go_M_Table128(VDT.MSX_VDT_REG(5) And 127) 'R5:(?AAAAAAA)+0000000, 0080h / 0~31(4Byte) - Y좌표(0~255),X좌표(0~255),패턴번호(0~255),A(EC)000AAAA(Color)

            VDT.MSX_VDT_REG_SZ = IIf((VDT.MSX_VDT_REG(1) And 2) = 0, 0, 1) 'R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
            VDT.MSX_VDT_REG_SM = IIf((VDT.MSX_VDT_REG(1) And 1) = 0, 0, 1) 'R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
            VDT.MSX_VDT_ST_REG_C = 0 '1:소프라이트 충돌

            For L = 0 To (49152 - 1) : VDTOUT.vdtBufferSpr(L) = -1 : Next L

            For i = 0 To 31
                V = VDT.Go_MSX_SPR_ATRB_ADDR + TBL.Gi_M_Table4(i)
                Sy = VDT.MSX_VRAM(V) 'Y좌표0~255
                Sx = VDT.MSX_VRAM(V + 1) 'X좌표0~255
                If (Sy = &HD0) Then GoTo SkipProc '이후표시안함(D0h,208)
                Sc = VDT.MSX_VRAM(V + 2) '패턴번호8Byte0~255
                FC = VDT.MSX_VRAM(V + 3)
                EC = IIf((FC And 128) = 0, 0, 1) 'EC
                FC = (FC And 15) '색상0~15
                If (Sy = 255) Then Sy = 0 Else Sy = Sy + 1
                If (EC = 1) Then Sx = Sx - 32
                Syy(0) = Sy : Sxx(0) = Sx : Vpm(0) = TBL.Go_M_Table256(Syy(0)) + Sxx(0) '256*192
                Syy(1) = Sy + 8 : Sxx(1) = Sx : Vpm(1) = TBL.Go_M_Table256(Syy(1)) + Sxx(1)
                Syy(2) = Sy : Sxx(2) = Sx + 8 : Vpm(2) = TBL.Go_M_Table256(Syy(2)) + Sxx(2)
                Syy(3) = Sy + 8 : Sxx(3) = Sx + 8 : Vpm(3) = TBL.Go_M_Table256(Syy(3)) + Sxx(3)
                P = Vpm(0)
                If (VDT.MSX_VDT_REG_SZ = 0) Then '8*8
                    sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8(Sc)
                    For j = 0 To 7 '8Byte
                        b = VDT.MSX_VRAM(sf + j)
                        For k = 1 To 8 '8Bit
                            If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then '(1)
                                'If (VDT.MSX_VDT_REG_SM = 0) Then '정상
                                Xp = Sxx(0) + k - 1
                                If ((Xp >= 0) And (Xp <= 255)) Then '좌우표시범위이내확인
                                    Ps = P + k - 1
                                    If (Ps > 65535) Then Ps = Ps - 65536
                                    If ((Ps >= 0) And (Ps <= 49151)) Then
                                        If (VDTOUT.vdtBufferSpr(Ps) = -1) Then
                                            VDTOUT.vdtBufferSpr(Ps) = IIf(FC = 0, -2, FC)
                                        Else
                                            If (VDTOUT.vdtBufferSpr(Ps) = -2) Then VDTOUT.vdtBufferSpr(Ps) = IIf(FC = 0, -2, FC)
                                            VDT.MSX_VDT_ST_REG_C = 1
                                        End If
                                    End If
                                End If
                                'Else '확대

                                'End If
                            End If
                        Next k
                        P = P + 256 '1Line256Dot
                    Next j
                Else '16*16
                    Sc = TBL.Gi_Spr_TableStart(Sc) '첫번째위치
                    For M = 0 To 3 '8Byte*4
                        sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8(Sc + M)
                        If (M = 0) Then P = Vpm(0)
                        If (M = 1) Then P = Vpm(1)
                        If (M = 2) Then P = Vpm(2)
                        If (M = 3) Then P = Vpm(3)
                        For j = 0 To 7 '8Byte
                            b = VDT.MSX_VRAM(sf + j)
                            For k = 1 To 8 '8Bit
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then '(1)
                                    'If (VDT.MSX_VDT_REG_SM = 0) Then '정상
                                    Xp = Sxx(M) + k - 1
                                    If ((Xp >= 0) And (Xp <= 255)) Then '좌우표시범위이내확인
                                        Ps = P + k - 1
                                        If (Ps > 65535) Then Ps = Ps - 65536
                                        If ((Ps >= 0) And (Ps <= 49151)) Then
                                            If (VDTOUT.vdtBufferSpr(Ps) = -1) Then
                                                VDTOUT.vdtBufferSpr(Ps) = IIf(FC = 0, -2, FC)
                                            Else
                                                If (VDTOUT.vdtBufferSpr(Ps) = -2) Then VDTOUT.vdtBufferSpr(Ps) = IIf(FC = 0, -2, FC)
                                                VDT.MSX_VDT_ST_REG_C = 1
                                            End If
                                        End If
                                    End If
                                    'Else '확대

                                    'End If
                                End If
                            Next k
                            P = P + 256 '1Line256Dot
                        Next j
                    Next M
                End If
            Next i

SkipProc:
            For L = 0 To (49152 - 1)
                If (VDTOUT.vdtBufferSpr(L) >= 0) Then VDTOUT.vdtBuffer32(L) = VDT.Go_MSX_Color(VDTOUT.vdtBufferSpr(L))
            Next L

        End Sub

        '소프라이트2 (MSX2)
        Public Sub MSX_SPRITE_2_DISP(ByVal iLn As Integer)

            Dim i As Integer, j As Integer, k As Integer, M As Integer, L As Integer, L2 As Integer
            Dim V As Integer, V2 As Integer, b As Integer, P As Integer, Ps As Integer, sf As Integer
            Dim Sy As Integer, Sx As Integer, Sc As Integer, FC As Integer, C As Integer
            Dim EC As Integer, Cc As Integer, IC As Integer, Xp As Integer
            Dim Vpm(4 - 1) As Integer
            Dim Syy(4 - 1) As Integer
            Dim Sxx(4 - 1) As Integer

            If (VDT.MSX_VDT_REG_SPD = 1) Then GoTo ExitProc

            VDT.Go_MSX_SPR_FONT_ADDR = TBL.Go_M_Table2048(VDT.MSX_VDT_REG(6) And 63) 'R6: (??AAAAAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
            'R11: 000000+(A16,A15), R5: (A14~A10)+1xx
            VDT.Go_MSX_SPR_ATRB_ADDR = Z80A.goGetIntHLToLng((VDT.MSX_VDT_REG(11) And 3), (VDT.MSX_VDT_REG(5) And &HFC))
            VDT.Go_MSX_SPR_ATRB_ADDR = TBL.Go_M_Table128(VDT.Go_MSX_SPR_ATRB_ADDR)
            VDT.Go_MSX_SPR_COLR_ADDR = VDT.Go_MSX_SPR_ATRB_ADDR - 512 '200h
            If (VDT.Go_MSX_SPR_COLR_ADDR < 0) Then VDT.Go_MSX_SPR_COLR_ADDR = 0

            VDT.MSX_VDT_REG_SZ = IIf((VDT.MSX_VDT_REG(1) And 2) = 0, 0, 1) 'R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
            VDT.MSX_VDT_REG_SM = IIf((VDT.MSX_VDT_REG(1) And 1) = 0, 0, 1) 'R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
            VDT.MSX_VDT_ST_REG_C = 0 '1:소프라이트 충돌

            For L = 0 To (54272 - 1) : VDTOUT.vdtBufferSpr2(L) = -1 : Next L '256*212

            For i = 0 To 31
                V = VDT.Go_MSX_SPR_ATRB_ADDR + TBL.Gi_M_Table4(i) '어트리뷰트테이블
                Sy = VDT.MSX_VRAM(V) 'Y좌표0~255
                Sx = VDT.MSX_VRAM(V + 1) 'X좌표0~255
                If (Sy = &HD8) Then GoTo SkipProc '이후표시안함(D8h,216)
                Sy = Sy - VDT.MSX_VDT_REG(23) : If (Sy < 0) Then Sy = Sy + 256 '스크롤반영
                Sc = VDT.MSX_VRAM(V + 2) '패턴번호8Byte0~255
                V2 = VDT.Go_MSX_SPR_COLR_ADDR + TBL.Gi_M_Table16(i) '칼라테이블
                FC = VDT.MSX_VRAM(V2)
                EC = IIf((FC And 128) = 0, 0, 1) 'EC - 1:Shift Left
                If (Sy = 255) Then Sy = 0 Else Sy = Sy + 1
                If (EC = 1) Then Sx = Sx - 32
                Syy(0) = Sy : Sxx(0) = Sx : Vpm(0) = TBL.Go_M_Table256(Syy(0)) + Sxx(0) '256*212
                Syy(1) = Sy + 8 : Sxx(1) = Sx : Vpm(1) = TBL.Go_M_Table256(Syy(1)) + Sxx(1)
                Syy(2) = Sy : Sxx(2) = Sx + 8 : Vpm(2) = TBL.Go_M_Table256(Syy(2)) + Sxx(2)
                Syy(3) = Sy + 8 : Sxx(3) = Sx + 8 : Vpm(3) = TBL.Go_M_Table256(Syy(3)) + Sxx(3)
                P = Vpm(0)
                If (VDT.MSX_VDT_REG_SZ = 0) Then '8*8
                    sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8(Sc) '패턴테이블
                    For j = 0 To 7 '8Byte
                        FC = VDT.MSX_VRAM(V2 + j) '칼라테이블
                        Cc = IIf((FC And 64) = 0, 0, 1) 'CC - 1:동일우선순위,Or칼라,충돌없음
                        IC = IIf((FC And 32) = 0, 0, 1) 'IC - 1:충돌확인안함
                        FC = (FC And 15) '색상0~15
                        b = VDT.MSX_VRAM(sf + j) '캐릭터
                        For k = 1 To 8 '8Bit
                            If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then '(1)
                                'If (VDT.MSX_VDT_REG_SM = 0) Then '정상
                                Xp = Sxx(0) + k - 1
                                If ((Xp >= 0) And (Xp <= 255)) Then '좌우표시범위이내확인
                                    Ps = P + k - 1
                                    If (Ps > 65535) Then Ps = Ps - 65536
                                    If ((Ps >= 0) And (Ps <= 54271)) Then
                                        If (VDTOUT.vdtBufferSpr2(Ps) = -1) Then
                                            VDTOUT.vdtBufferSpr2(Ps) = IIf((VDT.MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC)
                                        Else
                                            If (VDTOUT.vdtBufferSpr2(Ps) = -2) Then
                                                VDTOUT.vdtBufferSpr2(Ps) = IIf((VDT.MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC)
                                            Else
                                                If (Not ((VDT.MSX_VDT_REG_TP = 0) And (FC = 0))) Then
                                                    If (Cc = 1) Then 'Or-Color
                                                        If (VDTOUT.vdtBufferSpr2(Ps) < 0) Then VDTOUT.vdtBufferSpr2(Ps) = 0
                                                        VDTOUT.vdtBufferSpr2(Ps) = (VDTOUT.vdtBufferSpr2(Ps) Or FC) '소프라이트 색상 겹치는부분 OR 연산
                                                    End If
                                                End If
                                            End If
                                            If ((Cc = 0) And (IC = 0)) Then VDT.MSX_VDT_ST_REG_C = 1
                                        End If
                                    End If
                                End If
                                'Else '확대

                                'End If
                            End If
                        Next k
                        P = P + 256 '1Line256Dot
                    Next j
                Else '16*16
                    Sc = TBL.Gi_Spr_TableStart(Sc) '첫번째위치
                    For M = 0 To 3 '8Byte*4
                        sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8(Sc + M) '패턴테이블
                        If (M = 0) Then P = Vpm(0)
                        If (M = 1) Then P = Vpm(1)
                        If (M = 2) Then P = Vpm(2)
                        If (M = 3) Then P = Vpm(3)
                        For j = 0 To 7 '8Byte
                            FC = VDT.MSX_VRAM(V2 + IIf((M = 1) Or (M = 3), 8, 0) + j) '칼라테이블
                            Cc = IIf((FC And 64) = 0, 0, 1) 'CC - 1:동일우선순위,Or칼라,충돌없음
                            IC = IIf((FC And 32) = 0, 0, 1) 'IC - 1:충돌확인안함
                            FC = (FC And 15) '색상0~15
                            b = VDT.MSX_VRAM(sf + j) '캐릭터
                            For k = 1 To 8 '8Bit
                                If ((b And TBL.Gi_B_Table(8 - k)) > 0) Then '(1)
                                    'If (VDT.MSX_VDT_REG_SM = 0) Then '정상
                                    Xp = Sxx(M) + k - 1
                                    If ((Xp >= 0) And (Xp <= 255)) Then '좌우표시범위이내확인
                                        Ps = P + k - 1
                                        If (Ps > 65535) Then Ps = Ps - 65536
                                        If ((Ps >= 0) And (Ps <= 54271)) Then
                                            If (VDTOUT.vdtBufferSpr2(Ps) = -1) Then
                                                VDTOUT.vdtBufferSpr2(Ps) = IIf((VDT.MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC)
                                            Else
                                                If (VDTOUT.vdtBufferSpr2(Ps) = -2) Then
                                                    VDTOUT.vdtBufferSpr2(Ps) = IIf((VDT.MSX_VDT_REG_TP = 0) And (FC = 0), -2, FC)
                                                Else
                                                    If (Not ((VDT.MSX_VDT_REG_TP = 0) And (FC = 0))) Then
                                                        If (Cc = 1) Then 'Or-Color
                                                            If (VDTOUT.vdtBufferSpr2(Ps) < 0) Then VDTOUT.vdtBufferSpr2(Ps) = 0
                                                            VDTOUT.vdtBufferSpr2(Ps) = (VDTOUT.vdtBufferSpr2(Ps) Or FC) '소프라이트 색상 겹치는부분 OR 연산
                                                        End If
                                                    End If
                                                End If
                                                If ((Cc = 0) And (IC = 0)) Then VDT.MSX_VDT_ST_REG_C = 1
                                            End If
                                        End If
                                    End If
                                    'Else '확대

                                    'End If
                                End If
                            Next k
                            P = P + 256 '1Line256Dot
                        Next j
                    Next M
                End If
            Next i

SkipProc:
            '256*192/256*212
            If ((VDT.Gi_MSX_SCREEN_MODE = 4) Or (VDT.Gi_MSX_SCREEN_MODE = 5)) Then
                If (iLn = 0) Then
                    For L = 0 To (49152 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer32(L) = C
                        End If
                    Next L
                Else
                    For L = 0 To (54272 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer32p(L) = C
                        End If
                    Next L
                End If
            End If

            '256*192/256*212
            If (VDT.Gi_MSX_SCREEN_MODE = 8) Then
                If (iLn = 0) Then
                    For L = 0 To (49152 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color_G7(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer32(L) = C
                        End If
                    Next L
                Else
                    For L = 0 To (54272 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color_G7(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer32p(L) = C
                        End If
                    Next L
                End If
            End If

            '512*192/512*212
            If ((VDT.Gi_MSX_SCREEN_MODE = 6) Or (VDT.Gi_MSX_SCREEN_MODE = 7)) Then
                L2 = 0
                If (iLn = 0) Then
                    For L = 0 To (49152 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer80(L2) = C : L2 = L2 + 1
                            VDTOUT.vdtBuffer80(L2) = C
                        End If
                    Next L
                Else
                    For L = 0 To (54272 - 1)
                        If (VDTOUT.vdtBufferSpr2(L) >= 0) Then
                            C = VDT.Go_MSX_Color(VDTOUT.vdtBufferSpr2(L))
                            VDTOUT.vdtBuffer80p(L2) = C : L2 = L2 + 1
                            VDTOUT.vdtBuffer80p(L2) = C
                        End If
                    Next L
                End If
            End If

ExitProc:

        End Sub
    End Module

End Namespace
